#include <fx.h>
#include "ProgressDialog.h"

FXDEFMAP ( ProgressDialog ) ProgressDialogMap  [] =
{
  FXMAPFUNC(SEL_CLOSE,   ProgressDialog::ID_CANCEL,    ProgressDialog::onCmdCancel    ),
  FXMAPFUNC(SEL_COMMAND, ProgressDialog::ID_CANCEL,    ProgressDialog::onCmdCancel    ),
  FXMAPFUNC(SEL_COMMAND, ProgressDialog::ID_INCREMENT, ProgressDialog::onCmdIncrement ),
};
FXIMPLEMENT ( ProgressDialog, FXDialogBox, ProgressDialogMap, ARRAYNUMBER ( ProgressDialogMap ) )

ProgressDialog::ProgressDialog ( FXApp* a ) : FXDialogBox ( a, "Progress..." ){
//  setTarget ( this );
//  setSelector (  );
//  setMiniIcon ( icons->MiniPenguin );
  bar = new FXProgressBar( this, NULL, 0, FRAME_SUNKEN|LAYOUT_FILL_X, 0,0, 0,100 );
  cancelButton = new FXButton ( this, "Cancel\tCancel the current operation", NULL, this, ID_CANCEL, LAYOUT_SIDE_BOTTOM|LAYOUT_RIGHT, 0,0, 200,0 );
  }

ProgressDialog::~ProgressDialog (){
  delete bar;
  delete cancelButton;
  }

long ProgressDialog::onCmdCancel ( FXObject*, FXSelector, void* ){
  fxmessage ("cancel pushed\n");
  return 1;
  }

long ProgressDialog::onCmdIncrement ( FXObject*, FXSelector, void* ){
  increment();
  return 1;
  }

void ProgressDialog::total(FXint value){
  bar->setTotal(value);
  }

void ProgressDialog::total(){
  bar->setTotal(bar->getTotal());
  }

void ProgressDialog::increment(){
  bar->increment(1);
  }

void ProgressDialog::increment(FXint value){
  bar->increment(value);
  }
