(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     98588,       2322]
NotebookOptionsPosition[     93523,       2189]
NotebookOutlinePosition[     94637,       2228]
CellTagsIndexPosition[     94594,       2225]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Sinh", "[", "u", "]"}], "]"}], 
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"Sinh", "[", "u", "]"}]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978099162653446`*^9, 3.49780992018535*^9}, 
   3.497816868100286*^9, 3.4978178569916706`*^9, 3.497819935984581*^9, {
   3.499013365776951*^9, 3.4990134267106576`*^9}, 3.4990137262467837`*^9, {
   3.4990137895984955`*^9, 3.4990138005965147`*^9}, {3.5156368208608713`*^9, 
   3.515636820862872*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, {3.4978169434003916`*^9, 
   3.497816948440398*^9}, 3.497820003054675*^9, 3.4990134673955293`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"Sinh", "[", "z", "]"}], "]"}], " ", 
    RowBox[{"Cosh", "[", "z", "]"}]}], "=", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"Sinh", "[", "z", "]"}], "]"}], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", "z"], 
     RowBox[{"Sinh", "[", "z", "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, {3.497816982770447*^9, 3.4978170004804716`*^9}, {
   3.4978200170946946`*^9, 3.497820027074709*^9}, {3.499013486817563*^9, 
   3.4990134954287786`*^9}, 3.499013543196062*^9, {3.5156368208808727`*^9, 
   3.515636829699377*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978200878947935`*^9, 
   3.497820134594859*^9}, 3.4990139034474955`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "]"}], 
   RowBox[{"Cosh", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, {3.4978200683047667`*^9, 
   3.4978200791447816`*^9}, {3.4990137351075993`*^9, 
   3.4990137374476037`*^9}, {3.499013817148144*^9, 3.4990138763034477`*^9}, {
   3.4990159735023313`*^9, 3.4990159813959455`*^9}, {3.5156368208948736`*^9, 
   3.5156368297003775`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{"Cosh", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"(", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], ")"}]}], "]"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "c"}], ")"}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{"SubstFor", "[", 
            RowBox[{
             RowBox[{"Sinh", "[", 
              RowBox[{"c", "*", 
               RowBox[{"(", 
                RowBox[{"a", "+", 
                 RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", 
             "x"}], "]"}], ",", "x"}], "]"}], ",", "x"}], "]"}], ",", "x", 
       ",", 
       RowBox[{"Sinh", "[", 
        RowBox[{"c", "*", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", "x", ",", 
      "True"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497819954544607*^9, 
   3.4990136009005637`*^9, {3.5156368209068747`*^9, 3.5156368297023773`*^9}, 
   3.5156369086948957`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, {3.4978169434003916`*^9, 
   3.497816948440398*^9}, 3.497820003054675*^9, 3.4990134673955293`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"Sinh", "[", "z", "]"}], "]"}], " ", 
    RowBox[{"Coth", "[", "z", "]"}]}], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"f", "[", 
      RowBox[{"Sinh", "[", "z", "]"}], "]"}], 
     RowBox[{"Sinh", "[", "z", "]"}]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", "z"], 
     RowBox[{"Sinh", "[", "z", "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, {3.497816982770447*^9, 3.4978170004804716`*^9}, {
   3.4978200170946946`*^9, 3.497820027074709*^9}, {3.499013486817563*^9, 
   3.4990134954287786`*^9}, 3.499013543196062*^9, {3.4990140227097044`*^9, 
   3.4990140412425375`*^9}, {3.515636820930876*^9, 3.5156368469123616`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978200878947935`*^9, 
   3.497820134594859*^9}, 3.4990139034474955`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "]"}], 
   RowBox[{"Coth", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        RowBox[{"f", "[", "x", "]"}], "x"], " ", 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, {3.4978200683047667`*^9, 
   3.4978200791447816`*^9}, {3.4990137351075993`*^9, 
   3.4990137374476037`*^9}, {3.499013817148144*^9, 3.4990138763034477`*^9}, {
   3.499014076264599*^9, 3.4990140852814145`*^9}, {3.499014340607063*^9, 
   3.499014341465064*^9}, {3.4990159855455523`*^9, 3.4990159957635703`*^9}, {
   3.515636820947877*^9, 3.515636846914362*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{"Coth", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"(", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], ")"}]}], "]"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "c"}], ")"}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"SubstFor", "[", 
             RowBox[{
              RowBox[{"Sinh", "[", 
               RowBox[{"c", "*", 
                RowBox[{"(", 
                 RowBox[{"a", "+", 
                  RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", 
              "x"}], "]"}], "/", "x"}], ",", "x"}], "]"}], ",", "x"}], "]"}], 
       ",", "x", ",", 
       RowBox[{"Sinh", "[", 
        RowBox[{"c", "*", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", "x", ",", 
      "True"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497819954544607*^9, 
   3.4990136009005637`*^9, 3.4990140566397643`*^9, {3.5156368209608774`*^9, 
   3.515636846916362*^9}, 3.515636925021829*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Cosh", "[", "u", "]"}], "]"}], 
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"Cosh", "[", "u", "]"}]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978099162653446`*^9, 3.49780992018535*^9}, 
   3.497816868100286*^9, 3.4978178569916706`*^9, 3.497819935984581*^9, {
   3.499013365776951*^9, 3.4990134267106576`*^9}, 3.4990137262467837`*^9, {
   3.4990137895984955`*^9, 3.4990138005965147`*^9}, {3.499014556542642*^9, 
   3.4990145567922425`*^9}, {3.5156368297063775`*^9, 3.515636829708378*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, {3.4978169434003916`*^9, 
   3.497816948440398*^9}, 3.497820003054675*^9, 3.4990134673955293`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"Cosh", "[", "z", "]"}], "]"}], " ", 
    RowBox[{"Sinh", "[", "z", "]"}]}], "=", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"Cosh", "[", "z", "]"}], "]"}], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", "z"], 
     RowBox[{"Cosh", "[", "z", "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, {3.497816982770447*^9, 3.4978170004804716`*^9}, {
   3.4978200170946946`*^9, 3.497820027074709*^9}, {3.499013486817563*^9, 
   3.4990134954287786`*^9}, 3.499013543196062*^9, {3.499014557665844*^9, 
   3.499014558633046*^9}, {3.4990146074423313`*^9, 3.4990146147119446`*^9}, {
   3.5156368209798784`*^9, 3.515636829716378*^9}, {3.5156369734025965`*^9, 
   3.5156369734025965`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978200878947935`*^9, 
   3.497820134594859*^9}, 3.4990139034474955`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Cosh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "]"}], 
   RowBox[{"Sinh", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, {3.4978200683047667`*^9, 
   3.4978200791447816`*^9}, {3.4990137351075993`*^9, 
   3.4990137374476037`*^9}, {3.499013817148144*^9, 3.4990138763034477`*^9}, {
   3.499014559210247*^9, 3.499014560520649*^9}, {3.4990148709579945`*^9, 
   3.4990148886952257`*^9}, {3.4990161263357997`*^9, 
   3.4990161358050165`*^9}, {3.5156368209898787`*^9, 3.5156368297193785`*^9}, 
   3.5156369944327993`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{"Sinh", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"(", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], ")"}]}], "]"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "c"}], ")"}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{"SubstFor", "[", 
            RowBox[{
             RowBox[{"Cosh", "[", 
              RowBox[{"c", "*", 
               RowBox[{"(", 
                RowBox[{"a", "+", 
                 RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", 
             "x"}], "]"}], ",", "x"}], "]"}], ",", "x"}], "]"}], ",", "x", 
       ",", 
       RowBox[{"Cosh", "[", 
        RowBox[{"c", "*", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", "x", ",", 
      "True"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497819954544607*^9, 
   3.4990136009005637`*^9, {3.4990145607546496`*^9, 3.4990145612382507`*^9}, 
   3.499014624617962*^9, {3.5156368210008793`*^9, 3.515636829725379*^9}, 
   3.5156369701974134`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, {3.4978169434003916`*^9, 
   3.497816948440398*^9}, 3.497820003054675*^9, 3.4990134673955293`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"Cosh", "[", "z", "]"}], "]"}], " ", 
    RowBox[{"Tanh", "[", "z", "]"}]}], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"f", "[", 
      RowBox[{"Cosh", "[", "z", "]"}], "]"}], 
     RowBox[{"Cosh", "[", "z", "]"}]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", "z"], 
     RowBox[{"Cosh", "[", "z", "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, {3.497816982770447*^9, 3.4978170004804716`*^9}, {
   3.4978200170946946`*^9, 3.497820027074709*^9}, {3.499013486817563*^9, 
   3.4990134954287786`*^9}, 3.499013543196062*^9, {3.4990140227097044`*^9, 
   3.4990140412425375`*^9}, {3.499014561503451*^9, 3.4990145621586523`*^9}, {
   3.49901479993107*^9, 3.4990148211939073`*^9}, {3.515636829727379*^9, 
   3.515636838000852*^9}, {3.5156369884234557`*^9, 3.5156369884234557`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978200878947935`*^9, 
   3.497820134594859*^9}, 3.4990139034474955`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Cosh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "]"}], 
   RowBox[{"Tanh", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        RowBox[{"f", "[", "x", "]"}], "x"], " ", 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, {3.4978200683047667`*^9, 
   3.4978200791447816`*^9}, {3.4990137351075993`*^9, 
   3.4990137374476037`*^9}, {3.499013817148144*^9, 3.4990138763034477`*^9}, {
   3.499014076264599*^9, 3.4990140852814145`*^9}, {3.499014340607063*^9, 
   3.499014341465064*^9}, {3.4990145623770523`*^9, 3.4990145625486526`*^9}, {
   3.499014876386804*^9, 3.4990148922520323`*^9}, {3.499016141358626*^9, 
   3.49901614900264*^9}, {3.515636829735379*^9, 3.515636838002852*^9}, 
   3.5156369915496345`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{"Tanh", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"(", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], ")"}]}], "]"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "c"}], ")"}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"SubstFor", "[", 
             RowBox[{
              RowBox[{"Cosh", "[", 
               RowBox[{"c", "*", 
                RowBox[{"(", 
                 RowBox[{"a", "+", 
                  RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", 
              "x"}], "]"}], "/", "x"}], ",", "x"}], "]"}], ",", "x"}], "]"}], 
       ",", "x", ",", 
       RowBox[{"Cosh", "[", 
        RowBox[{"c", "*", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", "x", ",", 
      "True"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497819954544607*^9, 
   3.4990136009005637`*^9, 3.4990140566397643`*^9, {3.499014562735853*^9, 
   3.4990145631258535`*^9}, 3.499014757218195*^9, {3.51563682973938*^9, 
   3.515636838003852*^9}, 3.515636984042205*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Coth", "[", "u", "]"}], "]"}], 
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"Coth", "[", "u", "]"}]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978099162653446`*^9, 3.49780992018535*^9}, 
   3.497816868100286*^9, 3.4978178569916706`*^9, 3.497819935984581*^9, {
   3.499013365776951*^9, 3.4990134267106576`*^9}, 3.4990137262467837`*^9, {
   3.4990137895984955`*^9, 3.4990138005965147`*^9}, {3.4990150904815803`*^9, 
   3.4990150908403807`*^9}, {3.499016244708808*^9, 3.4990162449584084`*^9}, {
   3.5156368469203625`*^9, 3.5156368469223623`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, {3.4978169434003916`*^9, 
   3.497816948440398*^9}, 3.497820003054675*^9, 3.4990134673955293`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"Coth", "[", "z", "]"}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Csch", "[", "z", "]"}], "2"]}], "=", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"f", "[", 
      RowBox[{"Coth", "[", "z", "]"}], "]"}]}], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", "z"], 
     RowBox[{"Coth", "[", "z", "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, {3.497816982770447*^9, 3.4978170004804716`*^9}, {
   3.4978200170946946`*^9, 3.497820027074709*^9}, {3.499013486817563*^9, 
   3.4990134954287786`*^9}, 3.499013543196062*^9, {3.499015091604782*^9, 
   3.4990150922911835`*^9}, 3.4990152330314307`*^9, {3.499016245364009*^9, 
   3.4990162458632097`*^9}, {3.4990163512369947`*^9, 3.4990163541854*^9}, {
   3.515636846928363*^9, 3.5156368619592223`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978200878947935`*^9, 
   3.497820134594859*^9}, 3.4990139034474955`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Coth", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "]"}], 
   SuperscriptBox[
    RowBox[{"Csch", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "2"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["1", "b"]}]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"Coth", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, {3.4978200683047667`*^9, 
   3.4978200791447816`*^9}, {3.4990137351075993`*^9, 
   3.4990137374476037`*^9}, {3.499013817148144*^9, 3.4990138763034477`*^9}, {
   3.499015092634384*^9, 3.4990150929619846`*^9}, {3.499015243483449*^9, 
   3.499015253030666*^9}, {3.4990158796369667`*^9, 3.499015891414987*^9}, {
   3.4990162460816097`*^9, 3.4990162465808105`*^9}, 3.499016373591834*^9, {
   3.4990165083292704`*^9, 3.4990165087972713`*^9}, {3.515636846933363*^9, 
   3.5156368619612226`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{
      RowBox[{"Csch", "[", 
       RowBox[{"c_.", "*", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], "]"}], "^", "2"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "c"}], ")"}]}], ",", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"Regularize", "[", 
           RowBox[{
            RowBox[{"SubstFor", "[", 
             RowBox[{
              RowBox[{"Coth", "[", 
               RowBox[{"c", "*", 
                RowBox[{"(", 
                 RowBox[{"a", "+", 
                  RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", 
              "x"}], "]"}], ",", "x"}], "]"}], ",", "x"}], "]"}], ",", "x", 
        ",", 
        RowBox[{"Coth", "[", 
         RowBox[{"c", "*", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}]}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Coth", "[", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", "x", ",", 
      "True"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonsumQ", "[", "u", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497819954544607*^9, 
   3.4990136009005637`*^9, {3.4990150935391855`*^9, 3.4990150942099867`*^9}, 
   3.4990151653273115`*^9, {3.499016246612011*^9, 3.4990162466744113`*^9}, 
   3.4990163142961297`*^9, {3.515636846937363*^9, 3.5156368619632225`*^9}, 
   3.515637022080381*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, {3.4978169434003916`*^9, 
   3.497816948440398*^9}, 3.497820003054675*^9, 3.4990134673955293`*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"Coth", "[", "z", "]"}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Tanh", "[", "z", "]"}], "n"]}], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"f", "[", 
      RowBox[{"Coth", "[", "z", "]"}], "]"}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Coth", "[", "z", "]"}], "n"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox[
         RowBox[{"Coth", "[", "z", "]"}], "2"]}], ")"}]}]], 
    RowBox[{
     SubscriptBox["\[PartialD]", "z"], 
     RowBox[{"Coth", "[", "z", "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, {3.497816982770447*^9, 3.4978170004804716`*^9}, {
   3.4978200170946946`*^9, 3.497820027074709*^9}, {3.499013486817563*^9, 
   3.4990134954287786`*^9}, 3.499013543196062*^9, {3.4990140227097044`*^9, 
   3.4990140412425375`*^9}, {3.499015094521987*^9, 3.4990150954579887`*^9}, {
   3.499015358627251*^9, 3.4990154123693457`*^9}, {3.499016246705611*^9, 
   3.499016246830411*^9}, {3.4990164208287168`*^9, 3.4990164275523286`*^9}, {
   3.5156368380118523`*^9, 3.515636846952364*^9}, {3.515637069402087*^9, 
   3.5156370773925447`*^9}}],

Cell[TextData[{
 "Rule: ",
 "If  ",
 Cell[BoxData[
  RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978200878947935`*^9, 
   3.497820134594859*^9}, 3.4990139034474955`*^9, {3.49901546622064*^9, 
   3.499015466719841*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Coth", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "]"}], 
   SuperscriptBox[
    RowBox[{"Tanh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        RowBox[{"f", "[", "x", "]"}], 
        RowBox[{
         SuperscriptBox["x", "n"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           SuperscriptBox["x", "2"]}], ")"}]}]], " ", 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"Coth", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, {3.4978200683047667`*^9, 
   3.4978200791447816`*^9}, {3.4990137351075993`*^9, 
   3.4990137374476037`*^9}, {3.499013817148144*^9, 3.4990138763034477`*^9}, {
   3.499014076264599*^9, 3.4990140852814145`*^9}, {3.499014340607063*^9, 
   3.499014341465064*^9}, {3.4990150958167896`*^9, 3.49901509609759*^9}, {
   3.4990154382965913`*^9, 3.499015444099801*^9}, 3.4990155034423056`*^9, {
   3.4990158990122004`*^9, 3.499015911227022*^9}, {3.4990162468616114`*^9, 
   3.4990162468928113`*^9}, 3.499016381173447*^9, {3.499016501933259*^9, 
   3.49901650222966*^9}, {3.515636838013853*^9, 3.515636846955364*^9}, {
   3.5156370724512615`*^9, 3.51563707504141*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{
      RowBox[{"Tanh", "[", 
       RowBox[{"c_.", "*", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], "]"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "c"}], ")"}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"SubstFor", "[", 
             RowBox[{
              RowBox[{"Coth", "[", 
               RowBox[{"c", "*", 
                RowBox[{"(", 
                 RowBox[{"a", "+", 
                  RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", 
              "x"}], "]"}], "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"x", "^", "n"}], "*", 
              RowBox[{"(", 
               RowBox[{"1", "-", 
                RowBox[{"x", "^", "2"}]}], ")"}]}], ")"}]}], ",", "x"}], 
          "]"}], ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{"Coth", "[", 
        RowBox[{"c", "*", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Coth", "[", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", "x", ",", 
      "True"}], "]"}], " ", "&&", " ", 
    RowBox[{"TryPureTanhSubst", "[", 
     RowBox[{
      RowBox[{"u", "*", 
       RowBox[{
        RowBox[{"Tanh", "[", 
         RowBox[{"c", "*", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], "^", "n"}]}], ",", 
      "x"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497819954544607*^9, 
   3.4990136009005637`*^9, 3.4990140566397643`*^9, {3.4990150963939905`*^9, 
   3.4990150969555917`*^9}, 3.499015172409724*^9, {3.4990162469240117`*^9, 
   3.499016275656062*^9}, 3.4990163228137445`*^9, {3.515636838017853*^9, 
   3.5156368469623647`*^9}, 3.515637061979663*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, {3.4978169434003916`*^9, 
   3.497816948440398*^9}, 3.497820003054675*^9, 3.4990134673955293`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Coth", "[", "z", "]"}], "]"}], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"f", "[", 
      RowBox[{"Coth", "[", "z", "]"}], "]"}], 
     RowBox[{"1", "-", 
      SuperscriptBox[
       RowBox[{"Coth", "[", "z", "]"}], "2"]}]], 
    RowBox[{
     SubscriptBox["\[PartialD]", "z"], 
     RowBox[{"Coth", "[", "z", "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, {3.497816982770447*^9, 3.4978170004804716`*^9}, {
   3.4978200170946946`*^9, 3.497820027074709*^9}, {3.499013486817563*^9, 
   3.4990134954287786`*^9}, 3.499013543196062*^9, {3.4990140227097044`*^9, 
   3.4990140412425375`*^9}, {3.499014141223113*^9, 3.499014304336999*^9}, {
   3.4990144633324785`*^9, 3.499014471413293*^9}, {3.4990150974391923`*^9, 
   3.499015098343994*^9}, 3.499015758861554*^9, {3.4990162474856124`*^9, 
   3.499016248312414*^9}, 3.4990164672543983`*^9, {3.5156368469653645`*^9, 
   3.515636846971365*^9}, {3.5156371236721916`*^9, 3.5156371236721916`*^9}, {
   3.515637326231777*^9, 3.515637326231777*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978200878947935`*^9, 
   3.497820134594859*^9}, 3.4990139034474955`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Coth", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        RowBox[{"f", "[", "x", "]"}], 
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}]], " ", 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"Coth", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, {3.4978200683047667`*^9, 
   3.4978200791447816`*^9}, {3.4990137351075993`*^9, 
   3.4990137374476037`*^9}, {3.499013817148144*^9, 3.4990138763034477`*^9}, {
   3.499014076264599*^9, 3.4990140852814145`*^9}, {3.499014390511551*^9, 
   3.499014431820423*^9}, 3.499014491911729*^9, {3.4990150986715946`*^9, 
   3.4990150991863956`*^9}, 3.499015605747285*^9, {3.4990156487097607`*^9, 
   3.4990157151658773`*^9}, {3.499016248749215*^9, 3.499016249045615*^9}, 
   3.4990163858378553`*^9, {3.5156368469723654`*^9, 3.515636846974365*^9}, 
   3.515637328256893*^9, 3.515637567654586*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"v", "=", 
         RowBox[{"FunctionOfHyperbolic", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<\>\"", ",", "\"\<Int[f[Coth[a+b*x]],x]\>\"", ",", 
          "\"\<Subst[Int[f[x]/(1-x^2),x],x,Coth[a+b*x]]/b\>\"", ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{"Dist", "[", 
            RowBox[{
             RowBox[{"1", "/", 
              RowBox[{"Coefficient", "[", 
               RowBox[{"v", ",", "x", ",", "1"}], "]"}]}], ",", 
             RowBox[{"Subst", "[", 
              RowBox[{
               RowBox[{"Int", "[", 
                RowBox[{
                 RowBox[{"Regularize", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"SubstFor", "[", 
                    RowBox[{
                    RowBox[{"Coth", "[", "v", "]"}], ",", "u", ",", "x"}], 
                    "]"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", 
                    RowBox[{"x", "^", "2"}]}], ")"}]}], ",", "x"}], "]"}], 
                 ",", "x"}], "]"}], ",", "x", ",", 
               RowBox[{"Coth", "[", "v", "]"}]}], "]"}]}], "]"}], "]"}]}], 
         "]"}], " ", "/;", "\n", " ", 
        RowBox[{
         RowBox[{"NotFalseQ", "[", "v", "]"}], " ", "&&", " ", 
         RowBox[{"FunctionOfQ", "[", 
          RowBox[{
           RowBox[{"Coth", "[", "v", "]"}], ",", "u", ",", "x", ",", "True"}],
           "]"}], " ", "&&", " ", 
         RowBox[{"TryPureTanhSubst", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}]}]}], "]"}], " ", "/;", "\n", 
     "SimplifyFlag"}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"v", "=", 
        RowBox[{"FunctionOfHyperbolic", "[", 
         RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
      RowBox[{
       RowBox[{"Dist", "[", 
        RowBox[{
         RowBox[{"1", "/", 
          RowBox[{"Coefficient", "[", 
           RowBox[{"v", ",", "x", ",", "1"}], "]"}]}], ",", 
         RowBox[{"Subst", "[", 
          RowBox[{
           RowBox[{"Int", "[", 
            RowBox[{
             RowBox[{"Regularize", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"SubstFor", "[", 
                 RowBox[{
                  RowBox[{"Coth", "[", "v", "]"}], ",", "u", ",", "x"}], 
                 "]"}], "/", 
                RowBox[{"(", 
                 RowBox[{"1", "-", 
                  RowBox[{"x", "^", "2"}]}], ")"}]}], ",", "x"}], "]"}], ",", 
             "x"}], "]"}], ",", "x", ",", 
           RowBox[{"Coth", "[", "v", "]"}]}], "]"}]}], "]"}], " ", "/;", "\n",
        " ", 
       RowBox[{
        RowBox[{"NotFalseQ", "[", "v", "]"}], " ", "&&", " ", 
        RowBox[{"FunctionOfQ", "[", 
         RowBox[{
          RowBox[{"Coth", "[", "v", "]"}], ",", "u", ",", "x", ",", "True"}], 
         "]"}], " ", "&&", " ", 
        RowBox[{"TryPureTanhSubst", "[", 
         RowBox[{"u", ",", "x"}], "]"}]}]}]}], "]"}]}]}], "]"}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497819954544607*^9, 
   3.4990136009005637`*^9, 3.4990140566397643`*^9, 3.4990141257790856`*^9, {
   3.4990150996699963`*^9, 3.4990151017292*^9}, 3.49901518139534*^9, {
   3.4990162492796154`*^9, 3.499016276670064*^9}, 3.499016332267361*^9, {
   3.515636846978366*^9, 3.5156368469993668`*^9}, 3.515637114972694*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Tanh", "[", "u", "]"}], "]"}], 
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"Tanh", "[", "u", "]"}]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978099162653446`*^9, 3.49780992018535*^9}, 
   3.497816868100286*^9, 3.4978178569916706`*^9, 3.497819935984581*^9, {
   3.499013365776951*^9, 3.4990134267106576`*^9}, 3.4990137262467837`*^9, {
   3.4990137895984955`*^9, 3.4990138005965147`*^9}, {3.4990150904815803`*^9, 
   3.4990150908403807`*^9}, {3.5156368380238533`*^9, 3.5156368380268536`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, {3.4978169434003916`*^9, 
   3.497816948440398*^9}, 3.497820003054675*^9, 3.4990134673955293`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"Tanh", "[", "z", "]"}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sech", "[", "z", "]"}], "2"]}], "=", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"Tanh", "[", "z", "]"}], "]"}], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", "z"], 
     RowBox[{"Tanh", "[", "z", "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, {3.497816982770447*^9, 3.4978170004804716`*^9}, {
   3.4978200170946946`*^9, 3.497820027074709*^9}, {3.499013486817563*^9, 
   3.4990134954287786`*^9}, 3.499013543196062*^9, {3.499015091604782*^9, 
   3.4990150922911835`*^9}, 3.4990152330314307`*^9, {3.515636838032854*^9, 
   3.5156368540557704`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978200878947935`*^9, 
   3.497820134594859*^9}, 3.4990139034474955`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Tanh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "]"}], 
   SuperscriptBox[
    RowBox[{"Sech", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "2"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"Tanh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, {3.4978200683047667`*^9, 
   3.4978200791447816`*^9}, {3.4990137351075993`*^9, 
   3.4990137374476037`*^9}, {3.499013817148144*^9, 3.4990138763034477`*^9}, {
   3.499015092634384*^9, 3.4990150929619846`*^9}, {3.499015243483449*^9, 
   3.499015253030666*^9}, {3.4990158796369667`*^9, 3.499015891414987*^9}, {
   3.515636838037854*^9, 3.5156368540577707`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{
      RowBox[{"Sech", "[", 
       RowBox[{"c_.", "*", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], "]"}], "^", "2"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "c"}], ")"}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{"SubstFor", "[", 
            RowBox[{
             RowBox[{"Tanh", "[", 
              RowBox[{"c", "*", 
               RowBox[{"(", 
                RowBox[{"a", "+", 
                 RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", 
             "x"}], "]"}], ",", "x"}], "]"}], ",", "x"}], "]"}], ",", "x", 
       ",", 
       RowBox[{"Tanh", "[", 
        RowBox[{"c", "*", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Tanh", "[", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", "x", ",", 
      "True"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonsumQ", "[", "u", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497819954544607*^9, 
   3.4990136009005637`*^9, {3.4990150935391855`*^9, 3.4990150942099867`*^9}, 
   3.4990151653273115`*^9, {3.5156368380428543`*^9, 3.5156368540597706`*^9}, 
   3.515637153576902*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, {3.4978169434003916`*^9, 
   3.497816948440398*^9}, 3.497820003054675*^9, 3.4990134673955293`*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"Tanh", "[", "z", "]"}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Coth", "[", "z", "]"}], "n"]}], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"f", "[", 
      RowBox[{"Tanh", "[", "z", "]"}], "]"}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Tanh", "[", "z", "]"}], "n"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox[
         RowBox[{"Tanh", "[", "z", "]"}], "2"]}], ")"}]}]], 
    RowBox[{
     SubscriptBox["\[PartialD]", "z"], 
     RowBox[{"Tanh", "[", "z", "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, {3.497816982770447*^9, 3.4978170004804716`*^9}, {
   3.4978200170946946`*^9, 3.497820027074709*^9}, {3.499013486817563*^9, 
   3.4990134954287786`*^9}, 3.499013543196062*^9, {3.4990140227097044`*^9, 
   3.4990140412425375`*^9}, {3.499015094521987*^9, 3.4990150954579887`*^9}, {
   3.499015358627251*^9, 3.4990154123693457`*^9}, {3.5156368380498548`*^9, 
   3.515636847002367*^9}, {3.5156371702658567`*^9, 3.5156371702658567`*^9}}],

Cell[TextData[{
 "Rule: ",
 "If  ",
 Cell[BoxData[
  RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978200878947935`*^9, 
   3.497820134594859*^9}, 3.4990139034474955`*^9, {3.49901546622064*^9, 
   3.499015466719841*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Tanh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "]"}], 
   SuperscriptBox[
    RowBox[{"Coth", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        RowBox[{"f", "[", "x", "]"}], 
        RowBox[{
         SuperscriptBox["x", "n"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           SuperscriptBox["x", "2"]}], ")"}]}]], " ", 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"Tanh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, {3.4978200683047667`*^9, 
   3.4978200791447816`*^9}, {3.4990137351075993`*^9, 
   3.4990137374476037`*^9}, {3.499013817148144*^9, 3.4990138763034477`*^9}, {
   3.499014076264599*^9, 3.4990140852814145`*^9}, {3.499014340607063*^9, 
   3.499014341465064*^9}, {3.4990150958167896`*^9, 3.49901509609759*^9}, {
   3.4990154382965913`*^9, 3.499015444099801*^9}, 3.4990155034423056`*^9, {
   3.4990158990122004`*^9, 3.499015911227022*^9}, {3.5156368380608554`*^9, 
   3.515636847004367*^9}, 3.5156371733510327`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{
      RowBox[{"Coth", "[", 
       RowBox[{"c_.", "*", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], "]"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "c"}], ")"}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"SubstFor", "[", 
             RowBox[{
              RowBox[{"Tanh", "[", 
               RowBox[{"c", "*", 
                RowBox[{"(", 
                 RowBox[{"a", "+", 
                  RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", 
              "x"}], "]"}], "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"x", "^", "n"}], "*", 
              RowBox[{"(", 
               RowBox[{"1", "-", 
                RowBox[{"x", "^", "2"}]}], ")"}]}], ")"}]}], ",", "x"}], 
          "]"}], ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{"Tanh", "[", 
        RowBox[{"c", "*", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Tanh", "[", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", "x", ",", 
      "True"}], "]"}], " ", "&&", " ", 
    RowBox[{"TryPureTanhSubst", "[", 
     RowBox[{
      RowBox[{"u", "*", 
       RowBox[{
        RowBox[{"Coth", "[", 
         RowBox[{"c", "*", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], "^", "n"}]}], ",", 
      "x"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497819954544607*^9, 
   3.4990136009005637`*^9, 3.4990140566397643`*^9, {3.4990150963939905`*^9, 
   3.4990150969555917`*^9}, 3.499015172409724*^9, {3.5156368380658555`*^9, 
   3.515636847009367*^9}, 3.5156371640254993`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, {3.4978169434003916`*^9, 
   3.497816948440398*^9}, 3.497820003054675*^9, 3.4990134673955293`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Tanh", "[", "z", "]"}], "]"}], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"f", "[", 
      RowBox[{"Tanh", "[", "z", "]"}], "]"}], 
     RowBox[{"1", "-", 
      SuperscriptBox[
       RowBox[{"Tanh", "[", "z", "]"}], "2"]}]], 
    RowBox[{
     SubscriptBox["\[PartialD]", "z"], 
     RowBox[{"Tanh", "[", "z", "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, {3.497816982770447*^9, 3.4978170004804716`*^9}, {
   3.4978200170946946`*^9, 3.497820027074709*^9}, {3.499013486817563*^9, 
   3.4990134954287786`*^9}, 3.499013543196062*^9, {3.4990140227097044`*^9, 
   3.4990140412425375`*^9}, {3.499014141223113*^9, 3.499014304336999*^9}, {
   3.4990144633324785`*^9, 3.499014471413293*^9}, {3.4990150974391923`*^9, 
   3.499015098343994*^9}, 3.499015758861554*^9, {3.515636838072856*^9, 
   3.5156368380788565`*^9}, {3.515637231124337*^9, 3.515637231124337*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978200878947935`*^9, 
   3.497820134594859*^9}, 3.4990139034474955`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Tanh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        RowBox[{"f", "[", "x", "]"}], 
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}]], " ", 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"Tanh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, {3.4978200683047667`*^9, 
   3.4978200791447816`*^9}, {3.4990137351075993`*^9, 
   3.4990137374476037`*^9}, {3.499013817148144*^9, 3.4990138763034477`*^9}, {
   3.499014076264599*^9, 3.4990140852814145`*^9}, {3.499014390511551*^9, 
   3.499014431820423*^9}, 3.499014491911729*^9, {3.4990150986715946`*^9, 
   3.4990150991863956`*^9}, 3.499015605747285*^9, {3.4990156487097607`*^9, 
   3.4990157151658773`*^9}, {3.5156368380808563`*^9, 3.5156368380818567`*^9}, 
   3.5156372355315895`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"v", "=", 
         RowBox[{"FunctionOfHyperbolic", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<\>\"", ",", "\"\<Int[f[Tanh[a+b*x]],x]\>\"", ",", 
          "\"\<Subst[Int[f[x]/(1-x^2),x],x,Tanh[a+b*x]]/b\>\"", ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{"Dist", "[", 
            RowBox[{
             RowBox[{"1", "/", 
              RowBox[{"Coefficient", "[", 
               RowBox[{"v", ",", "x", ",", "1"}], "]"}]}], ",", 
             RowBox[{"Subst", "[", 
              RowBox[{
               RowBox[{"Int", "[", 
                RowBox[{
                 RowBox[{"Regularize", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"SubstFor", "[", 
                    RowBox[{
                    RowBox[{"Tanh", "[", "v", "]"}], ",", "u", ",", "x"}], 
                    "]"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", 
                    RowBox[{"x", "^", "2"}]}], ")"}]}], ",", "x"}], "]"}], 
                 ",", "x"}], "]"}], ",", "x", ",", 
               RowBox[{"Tanh", "[", "v", "]"}]}], "]"}]}], "]"}], "]"}]}], 
         "]"}], " ", "/;", "\n", " ", 
        RowBox[{
         RowBox[{"NotFalseQ", "[", "v", "]"}], " ", "&&", " ", 
         RowBox[{"FunctionOfQ", "[", 
          RowBox[{
           RowBox[{"Tanh", "[", "v", "]"}], ",", "u", ",", "x", ",", "True"}],
           "]"}], " ", "&&", " ", 
         RowBox[{"TryPureTanhSubst", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}]}]}], "]"}], " ", "/;", "\n", 
     "SimplifyFlag"}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"v", "=", 
        RowBox[{"FunctionOfHyperbolic", "[", 
         RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
      RowBox[{
       RowBox[{"Dist", "[", 
        RowBox[{
         RowBox[{"1", "/", 
          RowBox[{"Coefficient", "[", 
           RowBox[{"v", ",", "x", ",", "1"}], "]"}]}], ",", 
         RowBox[{"Subst", "[", 
          RowBox[{
           RowBox[{"Int", "[", 
            RowBox[{
             RowBox[{"Regularize", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"SubstFor", "[", 
                 RowBox[{
                  RowBox[{"Tanh", "[", "v", "]"}], ",", "u", ",", "x"}], 
                 "]"}], "/", 
                RowBox[{"(", 
                 RowBox[{"1", "-", 
                  RowBox[{"x", "^", "2"}]}], ")"}]}], ",", "x"}], "]"}], ",", 
             "x"}], "]"}], ",", "x", ",", 
           RowBox[{"Tanh", "[", "v", "]"}]}], "]"}]}], "]"}], " ", "/;", "\n",
        " ", 
       RowBox[{
        RowBox[{"NotFalseQ", "[", "v", "]"}], " ", "&&", " ", 
        RowBox[{"FunctionOfQ", "[", 
         RowBox[{
          RowBox[{"Tanh", "[", "v", "]"}], ",", "u", ",", "x", ",", "True"}], 
         "]"}], " ", "&&", " ", 
        RowBox[{"TryPureTanhSubst", "[", 
         RowBox[{"u", ",", "x"}], "]"}]}]}]}], "]"}]}]}], "]"}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497819954544607*^9, 
   3.4990136009005637`*^9, 3.4990140566397643`*^9, 3.4990141257790856`*^9, {
   3.4990150996699963`*^9, 3.4990151017292*^9}, 3.49901518139534*^9, {
   3.5156368380878572`*^9, 3.5156368381078577`*^9}, 3.5156371899019794`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"TrigSimplify", "[", "u", "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, {3.497676099158681*^9, 3.4976761165836773`*^9}, {
   3.497676783343814*^9, 3.4976767893021545`*^9}, 3.4979216300334096`*^9, {
   3.50014803844258*^9, 3.5001480688314333`*^9}, {3.501013623868741*^9, 
   3.5010136290387487`*^9}, {3.5010150310118046`*^9, 
   3.5010150315288343`*^9}, {3.501015071267107*^9, 3.501015071685131*^9}, {
   3.515608707455614*^9, 3.515608709705617*^9}, 3.5156090207660527`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.497676151127653*^9, {3.5001481383451557`*^9, 
   3.5001481405447593`*^9}, {3.5001482079504566`*^9, 
   3.5001482123304625`*^9}, {3.500149419932153*^9, 3.500149423362158*^9}, {
   3.515608763995693*^9, 3.515608767455698*^9}}],

Cell["\<\
Note: TrigSimplify needs to be tried after trig and hyperbolic rules are \
tried, but before unrestricted trig and hyperbolic substitutions!\
\>", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.497676151127653*^9, {3.5001481383451557`*^9, 
   3.5001481405447593`*^9}, {3.5001482079504566`*^9, 
   3.5001482123304625`*^9}, {3.500149419932153*^9, 3.500149423362158*^9}, {
   3.5002594945359473`*^9, 3.500259563456868*^9}, {3.501013683568825*^9, 
   3.501013685678828*^9}, 3.50101484449045*^9, 3.5156088050057507`*^9, {
   3.515609040846081*^9, 3.5156090853361435`*^9}, {3.5156946168939605`*^9, 
   3.515694745964141*^9}}],

Cell[TextData[{
 "Rule: If trig simplification simplifes ",
 Cell[BoxData["u"]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4976762514733925`*^9, 3.497676285304328*^9}, {
   3.499116130444688*^9, 3.4991161370846972`*^9}, {3.5001484707308245`*^9, 
   3.5001484897008505`*^9}, {3.5001491942318373`*^9, 
   3.5001492156318674`*^9}, {3.501013712288865*^9, 3.501013716708871*^9}, {
   3.515608893925875*^9, 3.5156089311459274`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       RowBox[{"TrigSimplify", "[", "u", "]"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, 3.4976760887800875`*^9, 3.49767613463171*^9, {
   3.4979216146673827`*^9, 3.4979216448690357`*^9}, 3.497982439709942*^9, {
   3.5001482472205114`*^9, 3.5001482843005633`*^9}, 3.5001483178806105`*^9, {
   3.5001483521006584`*^9, 3.5001483785506954`*^9}, {3.5001484497907953`*^9, 
   3.5001484515307975`*^9}, {3.5001485038708706`*^9, 
   3.5001485116608815`*^9}, {3.500148932771471*^9, 3.5001489476314917`*^9}, {
   3.5001489802415376`*^9, 3.500148985201545*^9}, {3.5001490192415924`*^9, 
   3.500149057751646*^9}, {3.500149448142193*^9, 3.500149528422305*^9}, {
   3.500149576592373*^9, 3.5001495871623874`*^9}, 3.500256685307169*^9, {
   3.5002606017382927`*^9, 3.500260607026702*^9}, {3.501014085219387*^9, 
   3.501014128929448*^9}, {3.5010142219695787`*^9, 3.501014229129589*^9}, {
   3.501014297969685*^9, 3.5010143351197367`*^9}, {3.501015035362054*^9, 
   3.501015077626471*^9}, {3.5010220453059998`*^9, 3.50102209128963*^9}, {
   3.5156087844357224`*^9, 3.515608793285734*^9}, {3.515608958665966*^9, 
   3.5156089772059917`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"v", "=", 
       RowBox[{"TrigSimplify", "[", "u", "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"Int", "[", 
       RowBox[{"v", ",", "x"}], "]"}], " ", "/;", "\n", " ", 
      RowBox[{"v", "=!=", "u"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{"Not", "[", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{"w_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", "v_"}]}], ")"}], "^", "m_."}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "v_"}]}], ")"}], "^", "n_."}]}], " ", "/;", 
       " ", "\n", "\t\t", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], 
         "]"}], " ", "&&", " ", 
        RowBox[{"IntegersQ", "[", 
         RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
        RowBox[{"m", "<", "0"}], " ", "&&", " ", 
        RowBox[{"n", "<", "0"}]}]}]}], "]"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.4976760612205105`*^9, {
   3.4979216146673827`*^9, 3.4979216448690357`*^9}, 3.497982323006137*^9, {
   3.497982386981849*^9, 3.497982393877061*^9}, {3.499116123264678*^9, 
   3.4991161253346806`*^9}, 3.5001480987054863`*^9, {3.500148609121018*^9, 
   3.5001486141710253`*^9}, {3.5001487914012733`*^9, 3.500148819181312*^9}, {
   3.5001490807716784`*^9, 3.5001490834616823`*^9}, {3.5001492360318956`*^9, 
   3.5001492795319567`*^9}, {3.500149382632101*^9, 3.5001494102621393`*^9}, {
   3.500149611882422*^9, 3.500149680812518*^9}, 3.5002567018271923`*^9, {
   3.50025973536917*^9, 3.500259739596778*^9}, {3.500260643062765*^9, 
   3.5002606913604503`*^9}, {3.500260725992511*^9, 3.500260741842139*^9}, {
   3.5002607838998127`*^9, 3.50026078798702*^9}, {3.501014352069761*^9, 
   3.501014355559766*^9}, {3.501014580670081*^9, 3.5010145904900947`*^9}, {
   3.501014819420415*^9, 3.501014823730421*^9}, {3.501014995974801*^9, 
   3.5010150000990367`*^9}, {3.501015046893713*^9, 3.5010150856369295`*^9}, {
   3.501015150927664*^9, 3.50101516991975*^9}, {3.501015448593689*^9, 
   3.501015454624034*^9}, {3.5010220581657352`*^9, 3.501022061906949*^9}, {
   3.5010221539452133`*^9, 3.501022177581565*^9}, {3.501022725821923*^9, 
   3.50102273137724*^9}, 3.5156087341956515`*^9, {3.517191266791707*^9, 
   3.5171912691473107`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Hyperbolic Substitution Integration Rules", None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.399999976158142,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 1429, 28, 118, "Title"],
Cell[1999, 52, 305, 4, 67, "Subsubsection"],
Cell[2307, 58, 810, 21, 50, "Subsubsection"],
Cell[3120, 81, 936, 13, 47, "Subsubsection"],
Cell[4059, 96, 1578, 37, 114, "Subsubtitle"],
Cell[5640, 135, 771, 11, 67, "Subsubsection"],
Cell[6414, 148, 1994, 58, 202, "Code"],
Cell[8411, 208, 89, 2, 67, "Subsubsection"],
Cell[8503, 212, 305, 4, 47, "Subsubsection"],
Cell[8811, 218, 919, 23, 75, "Subsubsection"],
Cell[9733, 243, 936, 13, 47, "Subsubsection"],
Cell[10672, 258, 1704, 39, 114, "Subsubtitle"],
Cell[12379, 299, 771, 11, 67, "Subsubsection"],
Cell[13153, 312, 2054, 59, 202, "Code"],
Cell[15210, 373, 44, 1, 6, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[15291, 379, 1477, 28, 80, "Title"],
Cell[16771, 409, 305, 4, 67, "Subsubsection"],
Cell[17079, 415, 964, 23, 50, "Subsubsection"],
Cell[18046, 440, 936, 13, 47, "Subsubsection"],
Cell[18985, 455, 1706, 39, 114, "Subsubtitle"],
Cell[20694, 496, 771, 11, 67, "Subsubsection"],
Cell[21468, 509, 2068, 59, 202, "Code"],
Cell[23539, 570, 89, 2, 67, "Subsubsection"],
Cell[23631, 574, 305, 4, 47, "Subsubsection"],
Cell[23939, 580, 1070, 25, 75, "Subsubsection"],
Cell[25012, 607, 936, 13, 47, "Subsubsection"],
Cell[25951, 622, 1829, 41, 114, "Subsubtitle"],
Cell[27783, 665, 771, 11, 67, "Subsubsection"],
Cell[28557, 678, 2125, 60, 202, "Code"],
Cell[30685, 740, 44, 1, 6, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[30766, 746, 1533, 29, 80, "Title"],
Cell[32302, 777, 305, 4, 67, "Subsubsection"],
Cell[32610, 783, 1033, 25, 50, "Subsubsection"],
Cell[33646, 810, 936, 13, 47, "Subsubsection"],
Cell[34585, 825, 1852, 42, 114, "Subsubtitle"],
Cell[36440, 869, 771, 11, 67, "Subsubsection"],
Cell[37214, 882, 2277, 63, 202, "Code"],
Cell[39494, 947, 89, 2, 67, "Subsubsection"],
Cell[39586, 951, 305, 4, 47, "Subsubsection"],
Cell[39894, 957, 1467, 37, 81, "Subsubsection"],
Cell[41364, 996, 1096, 20, 50, "Subsubsection"],
Cell[42463, 1018, 2183, 49, 130, "Subsubtitle"],
Cell[44649, 1069, 771, 11, 67, "Subsubsection"],
Cell[45423, 1082, 2828, 79, 202, "Code"],
Cell[48254, 1163, 89, 2, 67, "Subsubsection"],
Cell[48346, 1167, 305, 4, 47, "Subsubsection"],
Cell[48654, 1173, 1263, 28, 75, "Subsubsection"],
Cell[49920, 1203, 936, 13, 47, "Subsubsection"],
Cell[50859, 1218, 1898, 41, 116, "Subsubtitle"],
Cell[52760, 1261, 771, 11, 67, "Subsubsection"],
Cell[53534, 1274, 4092, 98, 692, "Code"],
Cell[57629, 1374, 44, 1, 6, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[57710, 1380, 1481, 28, 80, "Title"],
Cell[59194, 1410, 305, 4, 67, "Subsubsection"],
Cell[59502, 1416, 913, 23, 50, "Subsubsection"],
Cell[60418, 1441, 936, 13, 47, "Subsubsection"],
Cell[61357, 1456, 1700, 39, 114, "Subsubtitle"],
Cell[63060, 1497, 771, 11, 67, "Subsubsection"],
Cell[63834, 1510, 2159, 61, 202, "Code"],
Cell[65996, 1573, 89, 2, 67, "Subsubsection"],
Cell[66088, 1577, 305, 4, 47, "Subsubsection"],
Cell[66396, 1583, 1365, 35, 81, "Subsubsection"],
Cell[67764, 1620, 1096, 20, 50, "Subsubsection"],
Cell[68863, 1642, 2037, 47, 130, "Subsubtitle"],
Cell[70903, 1691, 771, 11, 67, "Subsubsection"],
Cell[71677, 1704, 2754, 78, 202, "Code"],
Cell[74434, 1784, 89, 2, 67, "Subsubsection"],
Cell[74526, 1788, 305, 4, 47, "Subsubsection"],
Cell[74834, 1794, 1133, 26, 75, "Subsubsection"],
Cell[75970, 1822, 936, 13, 47, "Subsubsection"],
Cell[76909, 1837, 1806, 40, 116, "Subsubtitle"],
Cell[78718, 1879, 771, 11, 67, "Subsubsection"],
Cell[79492, 1892, 4022, 97, 692, "Code"],
Cell[83517, 1991, 44, 1, 6, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[83598, 1997, 1561, 27, 80, "Title"],
Cell[85162, 2026, 553, 8, 35, "Subsubsection"],
Cell[85718, 2036, 866, 14, 25, "Subsubsection"],
Cell[86587, 2052, 1228, 20, 26, "Subsubsection"],
Cell[87818, 2074, 1953, 34, 53, "Subsubtitle"],
Cell[89774, 2110, 771, 11, 35, "Subsubsection"],
Cell[90548, 2123, 2912, 60, 179, "Code"],
Cell[93463, 2185, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}
]
*)

(* End of internal cache information *)
