(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    428011,      10769]
NotebookOptionsPosition[    415130,      10474]
NotebookOutlinePosition[    416279,      10514]
CellTagsIndexPosition[    416236,      10511]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4977276071672993`*^9, 3.4984069663016233`*^9, {
   3.5154488288078933`*^9, 3.5154488305878954`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.5154488049578595`*^9, 3.5154488049578595`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"a", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", 
           RowBox[{"Cosh", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sinh", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], 
      RowBox[{"b", " ", "d", " ", "n"}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.515448807747864*^9, 3.5154488085178647`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"a", "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"b", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", "d", "*", "n"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.5154488022978563`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.498407084381789*^9, 3.4984070858217907`*^9}, {
   3.515448092386862*^9, 3.515448092386862*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"Cosh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sinh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "2"]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"a", " ", "d", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", " ", 
          RowBox[{"Cosh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sinh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
        ")"}]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, 3.4984069789216413`*^9, {
   3.4984071019718137`*^9, 3.498407129841853*^9}, {3.515448073126835*^9, 
   3.5154480757068386`*^9}, {3.515449063108221*^9, 3.515449094528265*^9}, 
   3.515449186328394*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a_.", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "2"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Sinh", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", "*", "x"}]}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"a", "*", "d", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"b", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ")"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4984069410415883`*^9, 3.4984070532617455`*^9, 3.5154480625168204`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.449'", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840715643189*^9, {
   3.4984080275931096`*^9, 3.4984080381531243`*^9}, 3.498408571803871*^9, 
   3.5154482255970488`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840715643189*^9, {
   3.498407308712103*^9, 3.4984073159621134`*^9}, {3.498408123813244*^9, 
   3.4984081404332676`*^9}, 3.4984085798438826`*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"n", "-", "1"}], "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"Cosh", "[", "z", "]"}]}], "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sinh", "[", "z", "]"}]}]}], ")"}], "n"], "=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", 
           RowBox[{"Cosh", "[", "z", "]"}]}], "+", 
          RowBox[{"a", " ", 
           RowBox[{"Sinh", "[", "z", "]"}]}]}], ")"}], "2"]}], ")"}], 
     FractionBox[
      RowBox[{"n", "-", "1"}], "2"]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", "z"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", " ", 
        RowBox[{"Cosh", "[", "z", "]"}]}], "+", 
       RowBox[{"a", " ", 
        RowBox[{"Sinh", "[", "z", "]"}]}]}], ")"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840715643189*^9, {
   3.498407308712103*^9, 3.4984073159621134`*^9}, 3.4984075375224237`*^9, 
   3.498408444353693*^9, {3.498408614743932*^9, 3.4984087206640797`*^9}, {
   3.5154482463570776`*^9, 3.515448296657148*^9}}],

Cell[TextData[{
 "Note: For odd ",
 Cell[BoxData[
  RowBox[{"n", "<", 
   RowBox[{"-", "1"}]}]]],
 ", might as well stay in the hyperbolic world using 2nd rule below. (???)"
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840715643189*^9, {
   3.498407308712103*^9, 3.4984073159621134`*^9}, {3.498408123813244*^9, 
   3.4984081404332676`*^9}, 3.4984085798438826`*^9, {3.515448546727498*^9, 
   3.5154485898575583`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    FractionBox[
     RowBox[{"n", "-", "1"}], "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}],
    " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.498407084381789*^9, 3.4984070858217907`*^9}, {
   3.498407366552184*^9, 3.498407396032225*^9}, {3.498407665932603*^9, 
   3.498407668742607*^9}, {3.4984088091142035`*^9, 3.498408832034236*^9}, {
   3.4984092350248003`*^9, 3.498409243874812*^9}, {3.515448482997409*^9, 
   3.515448482997409*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
     FractionBox["1", "d"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"Int", "[", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "+", 
          SuperscriptBox["x", "2"]}], ")"}], 
        FractionBox[
         RowBox[{"n", "-", "1"}], "2"]], ",", "x"}], "]"}], ",", "x", ",", 
     RowBox[{
      RowBox[{"b", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"a", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, {3.49799166209334*^9, 
   3.4979917014678087`*^9}, 3.4984069832816477`*^9, {3.498407170311909*^9, 
   3.498407191491939*^9}, 3.498407224301985*^9, 3.4984076175825357`*^9, 
   3.498408318013516*^9, 3.498408417443655*^9, {3.4984085291138115`*^9, 
   3.498408550203841*^9}, {3.515448200767014*^9, 3.515448206217022*^9}, {
   3.515448383227269*^9, 3.515448395047286*^9}, 3.515448604507579*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "d"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", "^", "2"}], "-", 
              RowBox[{"b", "^", "2"}], "+", 
              RowBox[{"x", "^", "2"}]}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"n", "-", "1"}], ")"}], "/", "2"}], ")"}]}], ",", 
           "x"}], "]"}], ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{
        RowBox[{"b", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"a", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}]}], "]"}]}], "]"}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"OddQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.49799144010495*^9, 3.498406936471582*^9, 3.498407148091878*^9, 
   3.498407558302452*^9, {3.49840825619343*^9, 3.4984082574634314`*^9}, 
   3.498408289243476*^9, {3.498408384373609*^9, 3.498408394873624*^9}, 
   3.498408503433776*^9, {3.498409179804723*^9, 3.4984091820947256`*^9}, {
   3.5154481890869975`*^9, 3.515448194457005*^9}, {3.515448408507305*^9, 
   3.5154484334273396`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts with a double-back flip", \
"Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840715643189*^9, {
   3.498407308712103*^9, 3.4984073159621134`*^9}, {3.498408123813244*^9, 
   3.4984081404332676`*^9}, 3.4984085798438826`*^9, 3.4984090455045347`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{
    FractionBox[
     RowBox[{"n", "-", "1"}], "2"], "\[NotElement]", 
    "\[DoubleStruckCapitalZ]"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.498407084381789*^9, 3.4984070858217907`*^9}, {
   3.498407366552184*^9, 3.498407396032225*^9}, {3.498407665932603*^9, 
   3.498407668742607*^9}, {3.4984088091142035`*^9, 3.498408832034236*^9}, {
   3.498409100964612*^9, 3.4984091377146635`*^9}, {3.4984092061447597`*^9, 
   3.498409224474785*^9}, {3.515448732967759*^9, 3.515448732967759*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"Cosh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sinh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", 
           RowBox[{"Cosh", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
          RowBox[{"a", " ", 
           RowBox[{"Sinh", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", 
            RowBox[{"Cosh", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
           RowBox[{"b", " ", 
            RowBox[{"Sinh", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
         RowBox[{"n", "-", "1"}]]}], 
       RowBox[{"d", " ", "n"}]]}]}]}]}], "+", "\[IndentingNewLine]", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "-", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}], ")"}]}], "n"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"Cosh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sinh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, {3.49799166209334*^9, 
   3.4979917014678087`*^9}, 3.4984069832816477`*^9, {3.498407170311909*^9, 
   3.498407191491939*^9}, 3.498407224301985*^9, 3.4984076175825357`*^9, 
   3.498408318013516*^9, 3.498408417443655*^9, {3.4984085291138115`*^9, 
   3.498408550203841*^9}, {3.4984090747245755`*^9, 3.4984090856145906`*^9}, 
   3.51544863401762*^9, {3.5154486984977107`*^9, 3.5154487171777368`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
       RowBox[{"a", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", 
          RowBox[{"Cosh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sinh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", "n"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ")"}], "/", "n"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", 
            RowBox[{"Cosh", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"b", "*", 
            RowBox[{"Sinh", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "2"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"OddQ", "[", "n", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.49799144010495*^9, 3.498406936471582*^9, 3.498407148091878*^9, 
   3.498407558302452*^9, {3.49840825619343*^9, 3.4984082574634314`*^9}, 
   3.498408289243476*^9, {3.498408384373609*^9, 3.498408394873624*^9}, 
   3.498408503433776*^9, 3.498409040004527*^9, {3.4984091896547365`*^9, 
   3.4984091920747395`*^9}, {3.5154486725176744`*^9, 3.515448680637686*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts with a double-back flip", \
"Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840715643189*^9, {
   3.498407308712103*^9, 3.4984073159621134`*^9}, {3.498408123813244*^9, 
   3.4984081404332676`*^9}, 3.4984085798438826`*^9, 3.4984090455045347`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotEqual]", 
    RowBox[{"-", "2"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.498407084381789*^9, 3.4984070858217907`*^9}, {
   3.498407366552184*^9, 3.498407396032225*^9}, {3.498407665932603*^9, 
   3.498407668742607*^9}, {3.4984088091142035`*^9, 3.498408832034236*^9}, {
   3.498409100964612*^9, 3.4984091377146635`*^9}, {3.4984092061447597`*^9, 
   3.498409224474785*^9}, {3.498409331944936*^9, 3.4984093558649693`*^9}, {
   3.515448943558054*^9, 3.515448943558054*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"Cosh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sinh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", 
            RowBox[{"Cosh", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
           RowBox[{"a", " ", 
            RowBox[{"Sinh", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", " ", 
             RowBox[{"Cosh", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
            RowBox[{"b", " ", 
             RowBox[{"Sinh", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"d", " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"]}], ")"}]}]]}]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox[
    RowBox[{"n", "+", "2"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"Cosh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sinh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, {3.49799166209334*^9, 
   3.4979917014678087`*^9}, 3.4984069832816477`*^9, {3.498407170311909*^9, 
   3.498407191491939*^9}, 3.498407224301985*^9, 3.4984076175825357`*^9, 
   3.498408318013516*^9, 3.498408417443655*^9, {3.4984085291138115`*^9, 
   3.498408550203841*^9}, {3.4984090747245755`*^9, 3.4984090856145906`*^9}, {
   3.4984094277950697`*^9, 3.4984094332350774`*^9}, {3.5154489196880207`*^9, 
   3.5154489413680506`*^9}, {3.5154489876181154`*^9, 3.515448989058118*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"a", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", 
          RowBox[{"Cosh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sinh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", 
            RowBox[{"Cosh", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"b", "*", 
            RowBox[{"Sinh", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.49799144010495*^9, 3.498406936471582*^9, 3.498407148091878*^9, 
   3.498407558302452*^9, {3.49840825619343*^9, 3.4984082574634314`*^9}, 
   3.498408289243476*^9, {3.498408384373609*^9, 3.498408394873624*^9}, 
   3.498408503433776*^9, 3.498409040004527*^9, {3.4984091896547365`*^9, 
   3.4984091920747395`*^9}, 3.49840932049492*^9, {3.498409367134985*^9, 
   3.4984094068150406`*^9}, {3.5154488851579723`*^9, 3.515448896887988*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"Cosh", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], " ", 
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "n"]}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4977276071672993`*^9, 3.4984069663016233`*^9, 
   3.498410054215947*^9, {3.498411097837408*^9, 3.498411111517427*^9}, {
   3.515686577352705*^9, 3.5156866088327494`*^9}, {3.515735295681283*^9, 
   3.515735307630904*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, 
   3.4984100946360035`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Cosh", "[", "z", "]"}], " ", 
     RowBox[{"Sinh", "[", "z", "]"}]}], 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"Cosh", "[", "z", "]"}]}], "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sinh", "[", "z", "]"}]}]}]], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"b", " ", 
       RowBox[{"Cosh", "[", "z", "]"}]}], 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]]}], "+", 
    FractionBox[
     RowBox[{"a", " ", 
      RowBox[{"Sinh", "[", "z", "]"}]}], 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}]], "+", 
    FractionBox[
     RowBox[{"a", " ", "b"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"Cosh", "[", "z", "]"}]}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sinh", "[", "z", "]"}]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.4984101039160166`*^9, 3.4984101154860325`*^9}, {3.515735027811612*^9, 
   3.5157350340672235`*^9}, 3.5157350754852962`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    "m"}], ",", "n", ",", 
   RowBox[{
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{"p", "<", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.4984102666962442`*^9, 3.4984103177763157`*^9}, {
   3.4984104860765514`*^9, 3.498410498076568*^9}, 3.515735142005413*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Cosh", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "n"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"Cosh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sinh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                        ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox["b", 
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"]}]]}]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Cosh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "m"], " ", 
      SuperscriptBox[
       RowBox[{"Sinh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"n", "-", "1"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", " ", 
          RowBox[{"Cosh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sinh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"p", "+", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["a", 
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Cosh", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"m", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "n"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"Cosh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sinh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"p", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", "\[IndentingNewLine]", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "b"}], 
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Cosh", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"m", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"n", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"Cosh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sinh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "p"], 
     RowBox[{"\[DifferentialD]", "x", "    "}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, 3.4984069789216413`*^9, {
   3.4984071019718137`*^9, 3.498407129841853*^9}, {3.498410455476508*^9, 
   3.4984104647165213`*^9}, {3.4984105235166035`*^9, 3.49841057792668*^9}, {
   3.4984106125167284`*^9, 3.498410613026729*^9}, {3.515735035642826*^9, 
   3.515735042943639*^9}, {3.5157350959229326`*^9, 3.515735116733369*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "n_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a_.", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "p_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{"b", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ")"}]}], ",", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Cosh", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "m"}], "*", 
          RowBox[{
           RowBox[{"Sinh", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", 
           RowBox[{"(", 
            RowBox[{"n", "-", "1"}], ")"}]}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a", "*", 
              RowBox[{"Cosh", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
             RowBox[{"b", "*", 
              RowBox[{"Sinh", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"p", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Cosh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "n"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", "*", 
             RowBox[{"Cosh", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
            RowBox[{"b", "*", 
             RowBox[{"Sinh", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"b", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Cosh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", "*", 
             RowBox[{"Cosh", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
            RowBox[{"b", "*", 
             RowBox[{"Sinh", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "p"}]}], ",",
         "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", "p"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"p", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4984069410415883`*^9, 3.4984070532617455`*^9, 3.4984103491363597`*^9, {
   3.5157351579174414`*^9, 3.5157352108951344`*^9}, {3.51719129694656*^9, 
   3.517191299302164*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, 
   3.4984100946360035`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Sinh", "[", "z", "]"}], "2"], 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"Cosh", "[", "z", "]"}]}], "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sinh", "[", "z", "]"}]}]}]], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"b", " ", 
       RowBox[{"Sinh", "[", "z", "]"}]}], 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]]}], "+", 
    FractionBox[
     RowBox[{"a", " ", 
      RowBox[{"Cosh", "[", "z", "]"}]}], 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}]], "-", 
    FractionBox[
     SuperscriptBox["a", "2"], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"Cosh", "[", "z", "]"}]}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sinh", "[", "z", "]"}]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.4984101039160166`*^9, 3.4984101154860325`*^9}, 3.498410679376822*^9, {
   3.515686304072323*^9, 3.5156863060523252`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.4984102666962442`*^9, 3.4984103177763157`*^9}, {
   3.4984104860765514`*^9, 3.498410498076568*^9}, {3.498410785486971*^9, 
   3.498410809287004*^9}, 3.515686617892762*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"u", " ", 
      SuperscriptBox[
       RowBox[{"Sinh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "n"]}], 
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox["b", 
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"]}]]}]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{"u", " ", 
      SuperscriptBox[
       RowBox[{"Sinh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"n", "-", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["a", 
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"n", "-", "2"}]], " ", 
     RowBox[{"Cosh", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    SuperscriptBox["a", "2"], 
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"u", " ", 
       SuperscriptBox[
        RowBox[{"Sinh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"n", "-", "2"}]]}], 
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"Cosh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sinh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, 3.4984069789216413`*^9, {
   3.4984071019718137`*^9, 3.498407129841853*^9}, {3.498410455476508*^9, 
   3.4984104647165213`*^9}, {3.4984105235166035`*^9, 3.49841057792668*^9}, {
   3.4984106125167284`*^9, 3.498410613026729*^9}, {3.4984107356169004`*^9, 
   3.498410762106938*^9}, {3.498410847287057*^9, 3.4984108895871162`*^9}, {
   3.5156863652724085`*^9, 3.5156864086124687`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "n_"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a_.", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "b"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "*", 
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "*", 
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}], "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "*", 
         RowBox[{
          RowBox[{
           RowBox[{"Sinh", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", 
           RowBox[{"(", 
            RowBox[{"n", "-", "2"}], ")"}]}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", "*", 
             RowBox[{"Cosh", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
            RowBox[{"b", "*", 
             RowBox[{"Sinh", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", "\n", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", ">", "1"}], " ", "||", " ", 
      RowBox[{"MatchQ", "[", 
       RowBox[{"u", ",", 
        RowBox[{
         RowBox[{"v_.", "*", 
          RowBox[{
           RowBox[{"Tanh", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "m_."}]}], " ", "/;", " ", 
         RowBox[{
          RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
          RowBox[{"m", ">", "0"}]}]}]}], "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4984069410415883`*^9, 3.4984070532617455`*^9, 3.4984103491363597`*^9, 
   3.4984106537567863`*^9, 3.5156862276222153`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, 
   3.4984100946360035`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Cosh", "[", "z", "]"}], "2"], 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"Cosh", "[", "z", "]"}]}], "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sinh", "[", "z", "]"}]}]}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"a", " ", 
      RowBox[{"Cosh", "[", "z", "]"}]}], 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}]], "-", 
    FractionBox[
     RowBox[{"b", " ", 
      RowBox[{"Sinh", "[", "z", "]"}]}], 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}]], "-", 
    FractionBox[
     SuperscriptBox["b", "2"], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"Cosh", "[", "z", "]"}]}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sinh", "[", "z", "]"}]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.4984101039160166`*^9, 3.4984101154860325`*^9}, 3.498410679376822*^9, 
   3.4984109291771717`*^9, {3.5156863181423426`*^9, 3.515686320292345*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.4984102666962442`*^9, 3.4984103177763157`*^9}, {
   3.4984104860765514`*^9, 3.498410498076568*^9}, {3.498410785486971*^9, 
   3.498410809287004*^9}, 3.5156866200227647`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"u", " ", 
      SuperscriptBox[
       RowBox[{"Cosh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "n"]}], 
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["a", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"]}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{"u", " ", 
      SuperscriptBox[
       RowBox[{"Cosh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"n", "-", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["b", 
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     SuperscriptBox[
      RowBox[{"Cosh", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"n", "-", "2"}]], " ", 
     RowBox[{"Sinh", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    SuperscriptBox["b", "2"], 
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"u", " ", 
       SuperscriptBox[
        RowBox[{"Cosh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"n", "-", "2"}]]}], 
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"Cosh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sinh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, 3.4984069789216413`*^9, {
   3.4984071019718137`*^9, 3.498407129841853*^9}, {3.498410455476508*^9, 
   3.4984104647165213`*^9}, {3.4984105235166035`*^9, 3.49841057792668*^9}, {
   3.4984106125167284`*^9, 3.498410613026729*^9}, {3.4984107356169004`*^9, 
   3.498410762106938*^9}, {3.498410847287057*^9, 3.4984108895871162`*^9}, {
   3.498410989107256*^9, 3.4984110005472717`*^9}, {3.5156863763524237`*^9, 
   3.5156864160624795`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "n_"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a_.", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "*", 
         RowBox[{
          RowBox[{"Cosh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "*", 
         RowBox[{
          RowBox[{"Cosh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}], "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "*", 
         RowBox[{
          RowBox[{
           RowBox[{"Cosh", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", 
           RowBox[{"(", 
            RowBox[{"n", "-", "2"}], ")"}]}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", "*", 
             RowBox[{"Cosh", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
            RowBox[{"b", "*", 
             RowBox[{"Sinh", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", "\n", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", ">", "1"}], " ", "||", " ", 
      RowBox[{"MatchQ", "[", 
       RowBox[{"u", ",", 
        RowBox[{
         RowBox[{"v_.", "*", 
          RowBox[{
           RowBox[{"Coth", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "m_."}]}], " ", "/;", " ", 
         RowBox[{
          RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
          RowBox[{"m", ">", "0"}]}]}]}], "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4984069410415883`*^9, 3.4984070532617455`*^9, 3.4984103491363597`*^9, 
   3.4984106537567863`*^9, 3.498410935707181*^9, 3.515686279342288*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Cosh", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"c", " ", 
      RowBox[{"Sinh", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4977276071672993`*^9, 3.4984069663016233`*^9, 
   3.498411414357851*^9, {3.498412682319626*^9, 3.498412691479639*^9}, {
   3.4984165433450317`*^9, 3.49841654935504*^9}, {3.5154271487128143`*^9, 
   3.515427166832839*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.451.4c", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, 3.5154269897225914`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "-", "b"}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9, {3.4984155639236603`*^9, 
   3.4984155645936613`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Cosh", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"c", " ", 
      RowBox[{"Sinh", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      RowBox[{"c", " ", "e"}]]}]}], 
   RowBox[{"Log", "[", 
    RowBox[{"a", "+", 
     RowBox[{"c", " ", 
      RowBox[{"Tanh", "[", 
       FractionBox[
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "2"], "]"}]}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9, {3.4984157332238975`*^9, 3.49841574918392*^9}, {
   3.515427149472815*^9, 3.5154271875528684`*^9}, {3.515427218822912*^9, 
   3.515427223152918*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"a", "+", 
      RowBox[{"c", "*", 
       RowBox[{"Tanh", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], ")"}], "/", "2"}], "]"}]}]}], "]"}], 
    "/", 
    RowBox[{"(", 
     RowBox[{"c", "*", "e"}], ")"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "-", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.515426847302392*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.451.4c", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, 3.515427018742632*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", "b"}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9, {3.4984155639236603`*^9, 
   3.4984155645936613`*^9}, {3.4984158511840625`*^9, 3.498415851644063*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Cosh", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"c", " ", 
      RowBox[{"Sinh", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"c", " ", "e"}]]}]}]}], 
   RowBox[{"Log", "[", 
    RowBox[{"a", "-", 
     RowBox[{"c", " ", 
      RowBox[{"Coth", "[", 
       FractionBox[
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "2"], "]"}]}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9, {3.4984157332238975`*^9, 3.49841574918392*^9}, 
   3.4984158925641203`*^9, {3.515427150212816*^9, 3.515427189602871*^9}, {
   3.515427230212928*^9, 3.5154272598229694`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Log", "[", 
      RowBox[{"a", "-", 
       RowBox[{"c", "*", 
        RowBox[{"Coth", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "/", "2"}], "]"}]}]}], "]"}]}], 
    "/", 
    RowBox[{"(", 
     RowBox[{"c", "*", "e"}], ")"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984158462540555`*^9, 
   3.515426865052417*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.451.4d", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, 
   3.4984115959881053`*^9, 3.4984159939942627`*^9, 3.5154270424726653`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"], "+", 
    SuperscriptBox["c", "2"]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.498407084381789*^9, 3.4984070858217907`*^9}, {
   3.4984116805382233`*^9, 3.4984117154082727`*^9}, {3.4984160053842783`*^9, 
   3.498416008594283*^9}, {3.5154274263032026`*^9, 3.5154274263032026`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Cosh", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"c", " ", 
      RowBox[{"Sinh", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"c", "+", 
        RowBox[{"a", " ", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}]}], 
       RowBox[{"c", " ", "e", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"c", " ", 
           RowBox[{"Cosh", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sinh", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}]}], 
         ")"}]}]]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, 3.4984069789216413`*^9, {
   3.4984071019718137`*^9, 3.498407129841853*^9}, 3.498411666698204*^9, 
   3.49841174926832*^9, 3.49841179187838*^9, {3.498416025714307*^9, 
   3.4984160388143253`*^9}, {3.5154271509728174`*^9, 
   3.5154271697028437`*^9}, {3.5154272762129927`*^9, 3.5154272902130117`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"a", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], "/", 
    RowBox[{"(", 
     RowBox[{"c", "*", "e", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"c", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"b", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], ")"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4984069410415883`*^9, 3.4984070532617455`*^9, 3.498411445777895*^9, 
   3.4984115859180913`*^9, 3.498412722729683*^9, 3.498415966424224*^9, 
   3.498416102404414*^9, {3.5154268836824427`*^9, 3.515426886742447*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.451.4b'", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, 
   3.4984115959881053`*^9, 3.4984159939942627`*^9, 3.498416214164571*^9, 
   3.5154270681927013`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}], ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.498407084381789*^9, 3.4984070858217907`*^9}, {
   3.4984116805382233`*^9, 3.4984117154082727`*^9}, {3.4984160053842783`*^9, 
   3.498416008594283*^9}, {3.4984162850246696`*^9, 3.4984162856346707`*^9}, {
   3.4984163213347206`*^9, 3.498416331354735*^9}, {3.5154274399532213`*^9, 
   3.5154274399532213`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Cosh", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"c", " ", 
      RowBox[{"Sinh", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["2", 
       RowBox[{"e", " ", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "+", 
          SuperscriptBox["c", "2"]}]]}]]}]}]}], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{"c", "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "-", "b"}], ")"}], " ", 
       RowBox[{"Tanh", "[", 
        FractionBox[
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "2"], "]"}]}]}], 
     SqrtBox[
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, 3.4984069789216413`*^9, {
   3.4984071019718137`*^9, 3.498407129841853*^9}, 3.498411666698204*^9, 
   3.49841174926832*^9, 3.49841179187838*^9, {3.498416025714307*^9, 
   3.4984160388143253`*^9}, 3.4984162570246305`*^9, {3.5154271549928226`*^9, 
   3.5154271706628447`*^9}, 3.5154272340529337`*^9, {3.515427308153037*^9, 
   3.5154273412230835`*^9}, 3.5154276694035425`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "*", 
    RowBox[{
     RowBox[{"ArcTanh", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", "b"}], ")"}], "*", 
          RowBox[{"Tanh", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], ")"}], "/", "2"}], "]"}]}]}], ")"}], 
       "/", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}], "+", 
          RowBox[{"c", "^", "2"}]}], ",", "2"}], "]"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"e", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}], "+", 
          RowBox[{"c", "^", "2"}]}], ",", "2"}], "]"}]}], ")"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4984069410415883`*^9, 3.4984070532617455`*^9, 3.498411445777895*^9, 
   3.4984115859180913`*^9, 3.498412722729683*^9, 3.498415966424224*^9, 
   3.498416102404414*^9, 3.49841619951455*^9, 3.5154269400025215`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: Reference: G&R 2.451.4a", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, 
   3.4984115959881053`*^9, 3.4984159939942627`*^9, 3.498416214164571*^9, 
   3.4984164187248573`*^9, 3.5154270818327208`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ">", "0"}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.498407084381789*^9, 3.4984070858217907`*^9}, {
   3.4984116805382233`*^9, 3.4984117154082727`*^9}, {3.4984160053842783`*^9, 
   3.498416008594283*^9}, {3.4984162850246696`*^9, 3.4984162856346707`*^9}, {
   3.4984163213347206`*^9, 3.498416331354735*^9}, {3.498416426654868*^9, 
   3.49841642795487*^9}, {3.515427447893233*^9, 3.515427447893233*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Cosh", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"c", " ", 
      RowBox[{"Sinh", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["2", 
      RowBox[{"e", " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], "+", 
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}]]}]]}]}], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"c", "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "-", "b"}], ")"}], " ", 
       RowBox[{"Tanh", "[", 
        FractionBox[
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "2"], "]"}]}]}], 
     SqrtBox[
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "2"]}], "+", 
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, 3.4984069789216413`*^9, {
   3.4984071019718137`*^9, 3.498407129841853*^9}, 3.498411666698204*^9, 
   3.49841174926832*^9, 3.49841179187838*^9, {3.498416025714307*^9, 
   3.4984160388143253`*^9}, 3.4984162570246305`*^9, 3.4984164777649393`*^9, {
   3.515427157212826*^9, 3.5154271714828463`*^9}, 3.5154272368829374`*^9, {
   3.515427347643092*^9, 3.5154273703031244`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"ArcTan", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", "b"}], ")"}], "*", 
          RowBox[{"Tanh", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], ")"}], "/", "2"}], "]"}]}]}], ")"}], 
       "/", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"a", "^", "2"}]}], "+", 
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"c", "^", "2"}]}], ",", "2"}], "]"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"e", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"a", "^", "2"}]}], "+", 
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"c", "^", "2"}]}], ",", "2"}], "]"}]}], ")"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4984069410415883`*^9, 3.4984070532617455`*^9, 3.498411445777895*^9, 
   3.4984115859180913`*^9, 3.498412722729683*^9, 3.498415966424224*^9, 
   3.498416102404414*^9, 3.49841619951455*^9, 3.4984164374948835`*^9, 
   3.515426925732502*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Cosh", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"c", " ", 
      RowBox[{"Sinh", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4977276071672993`*^9, 3.4984069663016233`*^9, 
   3.498411414357851*^9, 3.4984180577971516`*^9, {3.5156259062480946`*^9, 
   3.5156259079431915`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"], "+", 
    SuperscriptBox["c", "2"]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9, {3.515625333574339*^9, 
   3.515625333574339*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Cosh", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"c", " ", 
      RowBox[{"Sinh", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"c", " ", 
          RowBox[{"Cosh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sinh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}]}], 
      RowBox[{"e", " ", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Cosh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", " ", 
          RowBox[{"Sinh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}]}]]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9, {3.515625347039109*^9, 3.515625365019138*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"a_", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"Cosh", "[", 
        RowBox[{"d_.", "+", 
         RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
      RowBox[{"c_.", "*", 
       RowBox[{"Sinh", "[", 
        RowBox[{"d_.", "+", 
         RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], "]"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
       RowBox[{"b", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"e", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cosh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sinh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.515625141566357*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, 
   3.4984115959881053`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", 
     RowBox[{"Cosh", "[", "z", "]"}]}], "+", 
    RowBox[{"c", " ", 
     RowBox[{"Sinh", "[", "z", "]"}]}]}], "=", 
   RowBox[{"a", "-", 
    RowBox[{"\[ImaginaryI]", " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}]], " ", 
     RowBox[{"Sinh", "[", 
      RowBox[{"z", "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"ArcTan", "[", 
         RowBox[{
          RowBox[{"\[ImaginaryI]", " ", "c"}], ",", "b"}], "]"}]}]}], 
      "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840715643189*^9, {
   3.498407308712103*^9, 3.4984073159621134`*^9}, 3.498411643758172*^9, {
   3.515625179877548*^9, 3.5156251823136873`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"a", "-", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}]]}], ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.498407084381789*^9, 3.4984070858217907`*^9}, {
   3.4984116805382233`*^9, 3.4984117154082727`*^9}, {3.515625336319496*^9, 
   3.515625336319496*^9}, {3.515625410393733*^9, 3.515625414147948*^9}, {
   3.5156256567408237`*^9, 3.515625665820343*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Cosh", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"c", " ", 
      RowBox[{"Sinh", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SqrtBox[
        RowBox[{"a", "-", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}]], " ", 
          RowBox[{"Sinh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}], "+", 
            RowBox[{"\[ImaginaryI]", " ", 
             RowBox[{"ArcTan", "[", 
              RowBox[{
               RowBox[{"\[ImaginaryI]", " ", "c"}], ",", "b"}], "]"}]}]}], 
           "]"}]}]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, 3.4984069789216413`*^9, {
   3.4984071019718137`*^9, 3.498407129841853*^9}, 3.498411666698204*^9, 
   3.49841174926832*^9, 3.49841179187838*^9, {3.515625370217435*^9, 
   3.5156253707164636`*^9}, 3.5156254528181596`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"Cosh", "[", 
        RowBox[{"d_.", "+", 
         RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
      RowBox[{"c_.", "*", 
       RowBox[{"Sinh", "[", 
        RowBox[{"d_.", "+", 
         RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], "]"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"a", "-", 
       RowBox[{"I", "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"c", "^", "2"}]}], "]"}], "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}], "+", 
          RowBox[{"I", "*", 
           RowBox[{"ArcTan", "[", 
            RowBox[{
             RowBox[{"I", "*", "c"}], ",", "b"}], "]"}]}]}], "]"}]}]}], "]"}],
      ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", 
     RowBox[{"a", "-", 
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "-", 
        RowBox[{"c", "^", "2"}]}], "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4984069410415883`*^9, 3.4984070532617455`*^9, 3.498411445777895*^9, 
   3.4984115859180913`*^9, 3.49844101205044*^9, 3.5156252018138027`*^9, {
   3.5156256489693785`*^9, 3.5156256692785406`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, 
   3.4984115959881053`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", 
     RowBox[{"Cosh", "[", "z", "]"}]}], "+", 
    RowBox[{"c", " ", 
     RowBox[{"Sinh", "[", "z", "]"}]}]}], "=", 
   RowBox[{"a", "-", 
    RowBox[{"\[ImaginaryI]", " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}]], " ", 
     RowBox[{"Sinh", "[", 
      RowBox[{"z", "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"ArcTan", "[", 
         RowBox[{
          RowBox[{"\[ImaginaryI]", " ", "c"}], ",", "b"}], "]"}]}]}], 
      "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840715643189*^9, {
   3.498407308712103*^9, 3.4984073159621134`*^9}, 3.498411643758172*^9, {
   3.515625179877548*^9, 3.5156251823136873`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "-", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}]]}], ">", "0"}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.498407084381789*^9, 3.4984070858217907`*^9}, {
   3.498407366552184*^9, 3.498407396032225*^9}, {3.4984118755384965`*^9, 
   3.4984118972785273`*^9}, {3.5156253399407034`*^9, 
   3.5156253399407034`*^9}, {3.515625756374522*^9, 3.5156257578916087`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Cosh", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"c", " ", 
      RowBox[{"Sinh", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
     FractionBox[
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Cosh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", " ", 
          RowBox[{"Sinh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}]}]]}], 
      RowBox[{"e", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Cosh", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
          RowBox[{"c", " ", 
           RowBox[{"Sinh", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}]}], 
         RowBox[{"a", "-", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}]]}]]]}]]}]}], 
   RowBox[{"EllipticE", "[", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        FractionBox["\[Pi]", "2"], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}], "+", 
           RowBox[{"\[ImaginaryI]", " ", 
            RowBox[{"ArcTan", "[", 
             RowBox[{
              RowBox[{"\[ImaginaryI]", " ", "c"}], ",", "b"}], "]"}]}]}], 
          ")"}]}]}], ")"}]}], ",", 
     FractionBox["2", 
      RowBox[{"1", "-", 
       FractionBox["a", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}]]]}]]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, {3.49799166209334*^9, 
   3.4979917014678087`*^9}, 3.4984069832816477`*^9, {3.498407170311909*^9, 
   3.498407191491939*^9}, 3.498407224301985*^9, 3.49841194205859*^9, 
   3.4984125081593823`*^9, {3.4984271620006742`*^9, 3.4984271643094783`*^9}, 
   3.498427389683074*^9, 3.4984277936145835`*^9, 3.4984279420956445`*^9, 
   3.498428188747678*^9, {3.5156256986772223`*^9, 3.515625700189308*^9}, {
   3.515625734168252*^9, 3.5156257441088204`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"Cosh", "[", 
        RowBox[{"d_.", "+", 
         RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
      RowBox[{"c_.", "*", 
       RowBox[{"Sinh", "[", 
        RowBox[{"d_.", "+", 
         RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], "]"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"2", "*", "I", "*", 
    RowBox[{"EllipticE", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Pi", "/", "2"}], "-", 
         RowBox[{"I", "*", 
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}], "+", 
            RowBox[{"I", "*", 
             RowBox[{"ArcTan", "[", 
              RowBox[{
               RowBox[{"I", "*", "c"}], ",", "b"}], "]"}]}]}], ")"}]}]}], 
        ")"}], "/", "2"}], ",", 
      RowBox[{"2", "/", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"a", "/", 
          RowBox[{"Sqrt", "[", 
           RowBox[{
            RowBox[{"b", "^", "2"}], "-", 
            RowBox[{"c", "^", "2"}]}], "]"}]}]}], ")"}]}]}], "]"}], "*", "\n",
     "  ", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}]}], "]"}], "/", "\n", "  ", 
     RowBox[{"(", 
      RowBox[{"e", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Cosh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"Sinh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"a", "-", 
           RowBox[{"Sqrt", "[", 
            RowBox[{
             RowBox[{"b", "^", "2"}], "-", 
             RowBox[{"c", "^", "2"}]}], "]"}]}], ")"}]}], "]"}]}], ")"}]}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PositiveQ", "[", 
      RowBox[{"a", "-", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "-", 
         RowBox[{"c", "^", "2"}]}], "]"}]}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.49799144010495*^9, 3.498406936471582*^9, 3.498407148091878*^9, 
   3.498411443187891*^9, 3.498411840218447*^9, {3.498428687346154*^9, 
   3.4984287108865952`*^9}, {3.498428760213882*^9, 3.4984287629750867`*^9}, {
   3.498428822017991*^9, 3.498428844809631*^9}, {3.498441047540489*^9, 
   3.498441065830515*^9}, 3.5156252359897575`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"c", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4977276071672993`*^9, 3.4984069663016233`*^9, 
   3.498411414357851*^9, {3.498412682319626*^9, 3.498412691479639*^9}, 
   3.4984181133672295`*^9, {3.515626032020288*^9, 3.5156260339834003`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, 3.4984169139755507`*^9, {
   3.4984170148056917`*^9, 3.4984170161556935`*^9}, 3.5154282661576633`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", 
     RowBox[{"Cosh", "[", "z", "]"}]}], "+", 
    RowBox[{"c", " ", 
     RowBox[{"Sinh", "[", "z", "]"}]}]}], "=", 
   RowBox[{"a", "-", 
    RowBox[{"\[ImaginaryI]", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}]], " ", 
     RowBox[{"Sinh", "[", 
      RowBox[{"z", "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"ArcTan", "[", 
         RowBox[{
          RowBox[{"\[ImaginaryI]", " ", "c"}], ",", "b"}], "]"}]}]}], 
      "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.4984169139755507`*^9, 
   3.4984169294355717`*^9}, {3.515428204131954*^9, 3.515428248451632*^9}, {
   3.51542831005614*^9, 3.5154283124273443`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "-", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}]]}], ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9, {3.4984155639236603`*^9, 
   3.4984155645936613`*^9}, {3.4984158511840625`*^9, 3.498415851644063*^9}, {
   3.498416957165611*^9, 3.4984169653256226`*^9}, {3.515428157253872*^9, 
   3.51542816787749*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"c", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox["1", 
        SqrtBox[
         RowBox[{"a", "-", 
          RowBox[{"\[ImaginaryI]", 
           SqrtBox[
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}]], " ", 
           RowBox[{"Sinh", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}], "+", 
             RowBox[{"\[ImaginaryI]", " ", 
              RowBox[{"ArcTan", "[", 
               RowBox[{
                RowBox[{"\[ImaginaryI]", " ", "c"}], ",", "b"}], "]"}]}]}], 
            "]"}]}]}]]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9, {3.4984157332238975`*^9, 3.49841574918392*^9}, 
   3.4984158925641203`*^9, 3.4984170047256775`*^9, {3.4984170427057304`*^9, 
   3.498417061765757*^9}, {3.515427961333952*^9, 3.515428037835662*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"a", "-", 
        RowBox[{"I", "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], "]"}], "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}], "+", 
           RowBox[{"I", "*", 
            RowBox[{"ArcTan", "[", 
             RowBox[{
              RowBox[{"I", "*", "c"}], ",", "b"}], "]"}]}]}], "]"}]}]}], 
       "]"}]}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", 
     RowBox[{"a", "-", 
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "-", 
        RowBox[{"c", "^", "2"}]}], "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984158462540555`*^9, 
   3.498416698885249*^9, 3.498416908705543*^9, 3.4984413227608747`*^9, 
   3.515427883863843*^9, 3.5156258137668047`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Piecewise constant extraction and algebraic simplification\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840715643189*^9, {
   3.4984119516486034`*^9, 3.498411961078616*^9}, {3.4984290446615815`*^9, 
   3.498429057750005*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      FractionBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cosh", "[", "z", "]"}]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"Sinh", "[", "z", "]"}]}]}], 
       RowBox[{"a", "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}]]}]]], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cosh", "[", "z", "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sinh", "[", "z", "]"}]}]}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.4984169139755507`*^9, 
   3.4984169294355717`*^9}, {3.4984172041059566`*^9, 
   3.4984172055859585`*^9}, {3.515428413000721*^9, 3.5154284272279463`*^9}, {
   3.515428591090634*^9, 3.515428608999465*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", 
     RowBox[{"Cosh", "[", "z", "]"}]}], "+", 
    RowBox[{"c", " ", 
     RowBox[{"Sinh", "[", "z", "]"}]}]}], "=", 
   RowBox[{"a", "-", 
    RowBox[{"\[ImaginaryI]", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}]], " ", 
     RowBox[{"Sinh", "[", 
      RowBox[{"z", "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"ArcTan", "[", 
         RowBox[{
          RowBox[{"\[ImaginaryI]", " ", "c"}], ",", "b"}], "]"}]}]}], 
      "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.4984169139755507`*^9, 
   3.4984169294355717`*^9}, {3.515428204131954*^9, 3.515428248451632*^9}, {
   3.51542831005614*^9, 3.5154283124273443`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", "-", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}]]}], "\[NotEqual]", "0"}], " ", "\[And]", 
   " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "-", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}]]}], ">", "0"}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9, {3.4984155639236603`*^9, 
   3.4984155645936613`*^9}, {3.4984158511840625`*^9, 3.498415851644063*^9}, {
   3.498416957165611*^9, 3.4984169653256226`*^9}, {3.498417283746068*^9, 
   3.4984173124761086`*^9}, {3.5156260804210567`*^9, 3.515626086973431*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"c", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
     FractionBox[
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Cosh", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
          RowBox[{"c", " ", 
           RowBox[{"Sinh", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}]}], 
         RowBox[{"a", "-", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}]]}]]]}], 
      RowBox[{"e", " ", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Cosh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", " ", 
          RowBox[{"Sinh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}]}]]}]]}]}], 
   RowBox[{"EllipticF", "[", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        FractionBox["\[Pi]", "2"], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}], "+", 
           RowBox[{"\[ImaginaryI]", " ", 
            RowBox[{"ArcTan", "[", 
             RowBox[{
              RowBox[{"\[ImaginaryI]", " ", "c"}], ",", "b"}], "]"}]}]}], 
          ")"}]}]}], ")"}]}], ",", 
     FractionBox["2", 
      RowBox[{"1", "-", 
       FractionBox["a", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}]]]}]]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9, {3.4984157332238975`*^9, 3.49841574918392*^9}, 
   3.4984158925641203`*^9, 3.4984170047256775`*^9, {3.4984170427057304`*^9, 
   3.498417061765757*^9}, 3.498417142815871*^9, {3.4984292473371377`*^9, 
   3.498429274106785*^9}, {3.49842946469832*^9, 3.4984294728415346`*^9}, 
   3.5154286348955107`*^9, {3.515626011446111*^9, 3.515626026581977*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"2", "*", "I", "*", 
    RowBox[{"EllipticF", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Pi", "/", "2"}], "-", 
         RowBox[{"I", "*", 
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}], "+", 
            RowBox[{"I", "*", 
             RowBox[{"ArcTan", "[", 
              RowBox[{
               RowBox[{"I", "*", "c"}], ",", "b"}], "]"}]}]}], ")"}]}]}], 
        ")"}], "/", "2"}], ",", 
      RowBox[{"2", "/", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"a", "/", 
          RowBox[{"Sqrt", "[", 
           RowBox[{
            RowBox[{"b", "^", "2"}], "-", 
            RowBox[{"c", "^", "2"}]}], "]"}]}]}], ")"}]}]}], "]"}], "*", "\n",
     "  ", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cosh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sinh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "-", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], "]"}]}], ")"}]}], "]"}], "/", "\n", 
     "  ", 
     RowBox[{"(", 
      RowBox[{"e", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cosh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sinh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"a", "-", 
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "-", 
        RowBox[{"c", "^", "2"}]}], "]"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PositiveQ", "[", 
      RowBox[{"a", "-", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "-", 
         RowBox[{"c", "^", "2"}]}], "]"}]}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984158462540555`*^9, 
   3.498416698885249*^9, 3.498416908705543*^9, 3.4984171017058134`*^9, {
   3.498417351646163*^9, 3.4984173769561987`*^9}, {3.498429342575305*^9, 
   3.4984293592673345`*^9}, 3.5156258249704456`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"c", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4977276071672993`*^9, 3.4984069663016233`*^9, 
   3.498411414357851*^9, {3.515434872694073*^9, 3.515434874285276*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Reference: G&R ",
 "2.451.1",
 " inverted with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"], "+", 
    SuperscriptBox["c", "2"]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, 3.498493177988264*^9, 
   3.5154340397306104`*^9, {3.5154342450893707`*^9, 3.5154342450893707`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"], "+", 
    SuperscriptBox["c", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", ">", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.498407084381789*^9, 3.4984070858217907`*^9}, {
   3.4984116805382233`*^9, 3.4984117154082727`*^9}, {3.4984121474088774`*^9, 
   3.498412158138892*^9}, 3.498418845598255*^9, {3.5154341925952787`*^9, 
   3.5154341925952787`*^9}, {3.5154342632946033`*^9, 3.5154342642618046`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"c", " ", 
           RowBox[{"Cosh", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sinh", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Cosh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", " ", 
            RowBox[{"Sinh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
         RowBox[{"n", "-", "1"}]]}], 
       RowBox[{"e", " ", "n"}]]}]}]}]}], "+", "\[IndentingNewLine]", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "n"}], "-", "1"}], ")"}]}], "n"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, 3.4984069789216413`*^9, {
   3.4984071019718137`*^9, 3.498407129841853*^9}, 3.498411666698204*^9, 
   3.49841174926832*^9, 3.49841179187838*^9, {3.498412197028947*^9, 
   3.4984122306389937`*^9}, 3.498412376379198*^9, {3.4984124721293316`*^9, 
   3.4984124753393364`*^9}, {3.515434045674221*^9, 3.5154340565474396`*^9}, {
   3.5154341133471394`*^9, 3.515434123705558*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
       RowBox[{"b", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cosh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sinh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"e", "*", "n"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "-", "1"}], ")"}], "/", "n"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Cosh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"Sinh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4984069410415883`*^9, 3.4984070532617455`*^9, 3.498411445777895*^9, 
   3.4984115859180913`*^9, {3.4984121254088464`*^9, 3.4984121419688697`*^9}, {
   3.4984188240782247`*^9, 3.498418825808227*^9}, {3.498440277731406*^9, 
   3.4984402800214095`*^9}, {3.515433951133254*^9, 3.515433956764864*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.451.1 inverted", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, 3.498412277469059*^9, {
   3.4984155145035915`*^9, 3.498415517813596*^9}, {3.4984189441483927`*^9, 
   3.4984189522984037`*^9}, 3.498420133760058*^9, 3.5154340363454046`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.498407084381789*^9, 3.4984070858217907`*^9}, {
   3.4984116805382233`*^9, 3.4984117154082727`*^9}, {3.4984121474088774`*^9, 
   3.498412158138892*^9}, {3.4984122819690657`*^9, 3.498412287439073*^9}, 
   3.4984206691208076`*^9, {3.5154342817026353`*^9, 3.5154342817026353`*^9}, {
   3.5154348296691976`*^9, 3.515434830464799*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"c", " ", 
           RowBox[{"Cosh", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sinh", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Cosh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", " ", 
            RowBox[{"Sinh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
         RowBox[{"n", "-", "1"}]]}], 
       RowBox[{"e", " ", "n"}]]}]}]}]}], "+", "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", "n"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"n", " ", 
        SuperscriptBox["a", "2"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}]}], "+", 
       RowBox[{"a", " ", "b", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "n"}], "-", "1"}], ")"}], " ", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"a", " ", "c", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "n"}], "-", "1"}], ")"}], 
        RowBox[{"Sinh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, 3.4984069789216413`*^9, {
   3.4984071019718137`*^9, 3.498407129841853*^9}, 3.498411666698204*^9, 
   3.49841174926832*^9, 3.49841179187838*^9, {3.498412197028947*^9, 
   3.4984122306389937`*^9}, {3.4984123290791316`*^9, 
   3.4984123451891537`*^9}, {3.4984123788092012`*^9, 3.4984124018892336`*^9}, 
   3.498420123780044*^9, {3.4984202710002503`*^9, 3.498420305010298*^9}, 
   3.498420414200451*^9, {3.498420487780554*^9, 3.498420488460555*^9}, {
   3.4984207146608715`*^9, 3.498420716610874*^9}, {3.5154340745966716`*^9, 
   3.5154340836602874`*^9}, {3.5154342868974447`*^9, 3.5154342967098618`*^9}, 
   3.515434351621958*^9, {3.5154346570080943`*^9, 3.5154346601436996`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
       RowBox[{"b", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cosh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sinh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"e", "*", "n"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"n", "*", 
            RowBox[{"a", "^", "2"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"n", "-", "1"}], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", "^", "2"}], "-", 
              RowBox[{"c", "^", "2"}]}], ")"}]}], "+", 
           RowBox[{"a", "*", "b", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "*", "n"}], "-", "1"}], ")"}], "*", 
            RowBox[{"Cosh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"a", "*", "c", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "*", "n"}], "-", "1"}], ")"}], "*", 
            RowBox[{"Sinh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "*", "\n", "    ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"Cosh", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"Sinh", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4984069410415883`*^9, 3.4984070532617455`*^9, 3.498411445777895*^9, 
   3.4984115859180913`*^9, {3.4984121254088464`*^9, 3.4984121419688697`*^9}, 
   3.4984122725990524`*^9, {3.4984124118992476`*^9, 3.4984124140692506`*^9}, {
   3.498420597460707*^9, 3.4984206083607225`*^9}, {3.5154347016241727`*^9, 
   3.5154347180978017`*^9}, 3.5154347965035396`*^9, {3.515434833772005*^9, 
   3.515434835098007*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "n"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4977276071672993`*^9, 3.4984069663016233`*^9, 
   3.498411414357851*^9, {3.498412682319626*^9, 3.498412691479639*^9}, 
   3.4984190002484713`*^9, {3.515430042485983*^9, 3.5154300442019863`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"], "+", 
    SuperscriptBox["c", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9, {3.4984155639236603`*^9, 
   3.4984155645936613`*^9}, {3.4984168250854263`*^9, 3.498416828835431*^9}, {
   3.4984176812066245`*^9, 3.498417690706638*^9}, {3.515429068716673*^9, 
   3.515429068716673*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"c", " ", 
            RowBox[{"Cosh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
           RowBox[{"b", " ", 
            RowBox[{"Sinh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             RowBox[{"Cosh", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
            RowBox[{"c", " ", 
             RowBox[{"Sinh", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], 
        RowBox[{"a", " ", "e", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox[
    RowBox[{"n", "+", "1"}], 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9, {3.4984157332238975`*^9, 3.49841574918392*^9}, 
   3.4984158925641203`*^9, 3.4984170047256775`*^9, {3.4984170427057304`*^9, 
   3.498417061765757*^9}, 3.498417142815871*^9, {3.4984174810763445`*^9, 
   3.4984175071063805`*^9}, {3.4984175424564304`*^9, 
   3.4984175583264523`*^9}, {3.4984176607865963`*^9, 3.498417671346611*^9}, {
   3.4984177017366533`*^9, 3.49841770652666*^9}, 3.4984191597086945`*^9, {
   3.4984191954487443`*^9, 3.498419207218761*^9}, {3.5154290072369647`*^9, 
   3.515429019436186*^9}, {3.515429080307493*^9, 3.5154291085591426`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"c", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"b", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cosh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sinh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "e", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Cosh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"Sinh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984158462540555`*^9, 
   3.498416698885249*^9, 3.498416908705543*^9, 3.4984171017058134`*^9, {
   3.498417351646163*^9, 3.4984173769561987`*^9}, 3.4984174573863115`*^9, 
   3.4984176196065383`*^9, 3.515428868677521*^9, {3.5154290487798376`*^9, 
   3.5154290511666417`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Reference: ",
 "G&R 2.451.1",
 " with  ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"-", "2"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.498493180640269*^9, 3.5154294181416864`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"], "+", 
    SuperscriptBox["c", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9, {3.4984155639236603`*^9, 
   3.4984155645936613`*^9}, {3.4984168250854263`*^9, 3.498416828835431*^9}, {
   3.515429436580919*^9, 3.515429436580919*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "2"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"c", " ", 
          RowBox[{"Cosh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sinh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}]}], 
        RowBox[{"e", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Cosh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", " ", 
            RowBox[{"Sinh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["a", 
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9, {3.4984157332238975`*^9, 3.49841574918392*^9}, {
   3.4984167480753183`*^9, 3.4984167773253593`*^9}, {3.4984192598788347`*^9, 
   3.4984192736088543`*^9}, {3.5154293891724358`*^9, 
   3.5154293977680507`*^9}, {3.515429466298971*^9, 3.5154294699805775`*^9}, {
   3.5154295109150496`*^9, 3.5154295179350615`*^9}, 3.5154296085868206`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "2"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"c", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"b", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"e", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}], "+", 
         RowBox[{"c", "^", "2"}]}], ")"}], "*", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cosh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sinh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], ")"}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}], "+", 
         RowBox[{"c", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Cosh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"Sinh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9, {
   3.515429630052459*^9, 3.5154296720165324`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Reference: G&R ",
 "2.451.1",
 " with ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"-", 
    FractionBox["3", "2"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, 3.4984169139755507`*^9, {
   3.4984170148056917`*^9, 3.4984170161556935`*^9}, {3.498417209325964*^9, 
   3.4984172183259764`*^9}, 3.498417464166321*^9, {3.4984193161589136`*^9, 
   3.498419326428928*^9}, 3.4984931817634706`*^9, 3.515429843788434*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"], "+", 
    SuperscriptBox["c", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9, {3.4984155639236603`*^9, 
   3.4984155645936613`*^9}, {3.4984168250854263`*^9, 3.498416828835431*^9}, {
   3.515429974345063*^9, 3.515429974345063*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"c", " ", 
            RowBox[{"Cosh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
           RowBox[{"b", " ", 
            RowBox[{"Sinh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}]}], 
        RowBox[{"e", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         SqrtBox[
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Cosh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", " ", 
            RowBox[{"Sinh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], "]"}]}]}]]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9, {3.4984157332238975`*^9, 3.49841574918392*^9}, 
   3.4984158925641203`*^9, 3.4984170047256775`*^9, {3.4984170427057304`*^9, 
   3.498417061765757*^9}, 3.498417142815871*^9, {3.4984174810763445`*^9, 
   3.4984175071063805`*^9}, {3.4984175424564304`*^9, 
   3.4984175583264523`*^9}, {3.4984193573489714`*^9, 
   3.4984193690589876`*^9}, {3.515429854848853*^9, 3.515429901882936*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"c", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"b", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}], "+", 
          RowBox[{"c", "^", "2"}]}], ")"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Cosh", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
          RowBox[{"c", "*", 
           RowBox[{"Sinh", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}]}], " ", 
    "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}], "+", 
         RowBox[{"c", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Cosh", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
          RowBox[{"c", "*", 
           RowBox[{"Sinh", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", "*", "x"}]}], "]"}]}]}], "]"}], ",", "x"}], "]"}]}],
      "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984158462540555`*^9, 
   3.498416698885249*^9, 3.498416908705543*^9, 3.4984171017058134`*^9, {
   3.498417351646163*^9, 3.4984173769561987`*^9}, 3.4984174573863115`*^9, {
   3.498419340108947*^9, 3.4984193434289513`*^9}, {3.515429931351388*^9, 
   3.515429971271858*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.451.1", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, 3.4984169139755507`*^9, {
   3.4984170148056917`*^9, 3.4984170161556935`*^9}, {3.498417209325964*^9, 
   3.4984172183259764`*^9}, 3.498417464166321*^9, 3.4984176249865456`*^9, 
   3.49841775663673*^9, 3.5154292051701126`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotEqual]", 
    RowBox[{"-", "2"}]}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotEqual]", 
    RowBox[{"-", 
     FractionBox["3", "2"]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9, {3.4984155639236603`*^9, 
   3.4984155645936613`*^9}, {3.4984168250854263`*^9, 3.498416828835431*^9}, {
   3.4984176812066245`*^9, 3.498417690706638*^9}, {3.4984177620467377`*^9, 
   3.498417781366765*^9}, 3.498419459959115*^9, {3.5154292793170424`*^9, 
   3.5154292793170424`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"c", " ", 
           RowBox[{"Cosh", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sinh", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Cosh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", " ", 
            RowBox[{"Sinh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"e", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "+", 
          SuperscriptBox["c", "2"]}], ")"}]}]]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], " ", "a"}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}], " ", "b", " ", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}], " ", "c", " ", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9, {3.4984157332238975`*^9, 3.49841574918392*^9}, 
   3.4984158925641203`*^9, 3.4984170047256775`*^9, {3.4984170427057304`*^9, 
   3.498417061765757*^9}, 3.498417142815871*^9, {3.4984174810763445`*^9, 
   3.4984175071063805`*^9}, {3.4984175424564304`*^9, 
   3.4984175583264523`*^9}, {3.4984176607865963`*^9, 3.498417671346611*^9}, {
   3.4984177017366533`*^9, 3.49841770652666*^9}, {3.4984178160368133`*^9, 
   3.4984178242268248`*^9}, {3.4984195060891795`*^9, 3.49841950648918*^9}, {
   3.5154292301301565`*^9, 3.515429290346262*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
       RowBox[{"b", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cosh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sinh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}], "+", 
          RowBox[{"c", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}], "+", 
          RowBox[{"c", "^", "2"}]}], ")"}]}], ")"}]}], "*", "\n", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"n", "+", "1"}], ")"}], "*", "a"}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"n", "+", "2"}], ")"}], "*", "b", "*", 
           RowBox[{"Cosh", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", "*", "x"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"n", "+", "2"}], ")"}], "*", "c", "*", 
           RowBox[{"Sinh", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Cosh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"Sinh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{
      RowBox[{"-", "3"}], "/", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984158462540555`*^9, 
   3.498416698885249*^9, 3.498416908705543*^9, 3.4984171017058134`*^9, {
   3.498417351646163*^9, 3.4984173769561987`*^9}, 3.4984174573863115`*^9, 
   3.4984176196065383`*^9, {3.4984177347267*^9, 3.498417745826715*^9}, 
   3.498419466729124*^9, {3.515428940312847*^9, 3.515428965631692*^9}, {
   3.5154300258563538`*^9, 3.515430031425564*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      RowBox[{"Cosh", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"C", " ", 
      RowBox[{"Sinh", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"c", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4977276071672993`*^9, 3.4984069663016233`*^9, 
   3.498411414357851*^9, {3.498412682319626*^9, 3.498412691479639*^9}, 
   3.4984190002484713`*^9, 3.498431143345269*^9, {3.4984327899409604`*^9, 
   3.498432793669367*^9}, {3.4984336640444965`*^9, 3.498433664559297*^9}, {
   3.515441179006653*^9, 3.5154411829566584`*^9}, {3.5154447195216093`*^9, 
   3.5154447263016186`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.451.3", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, 3.4984169139755507`*^9, {
   3.4984170148056917`*^9, 3.4984170161556935`*^9}, {3.498417209325964*^9, 
   3.4984172183259764`*^9}, 3.498417464166321*^9, 3.4984176249865456`*^9, {
   3.4984190999186106`*^9, 3.4984191011286125`*^9}, 3.4984312037641754`*^9, {
   3.498432107096561*^9, 3.4984321210117855`*^9}, 3.498432947626037*^9, 
   3.498433970850235*^9, 3.4984931895946846`*^9, {3.5154366850003614`*^9, 
   3.5154366904003687`*^9}, {3.5162350979982004`*^9, 3.516235104692583*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9, {3.4984155639236603`*^9, 
   3.4984155645936613`*^9}, {3.4984168250854263`*^9, 3.498416828835431*^9}, {
   3.4984176812066245`*^9, 3.498417690706638*^9}, {3.4984314419453936`*^9, 
   3.4984314738318496`*^9}, 3.49843175923075*^9, {3.4984328634326897`*^9, 
   3.498432867660297*^9}, {3.4984337769418945`*^9, 3.4984337782366967`*^9}, {
   3.498433846533617*^9, 3.4984338823044796`*^9}, {3.5154366677003365`*^9, 
   3.515436676140349*^9}, {3.516235109827877*^9, 3.5162351198644505`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"C", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"c", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "a", " ", "A"}], "-", 
          RowBox[{"b", " ", "B"}], "+", 
          RowBox[{"c", " ", "C"}]}], ")"}], " ", "x"}], 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"]}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"b", " ", "B"}], "-", 
      RowBox[{"c", " ", "C"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"b", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "-", 
      RowBox[{"c", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}]}], 
   RowBox[{"2", " ", "a", " ", "b", " ", "c", " ", "e"}]], "+", 
  "\[IndentingNewLine]", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", " ", "B"}], "+", 
         RowBox[{"c", " ", "C"}]}], ")"}]}], "-", 
      RowBox[{"2", " ", "a", " ", "A", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", " ", "B"}], "-", 
         RowBox[{"c", " ", "C"}]}], ")"}]}]}], ")"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"c", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}], "]"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
    "e"}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9, {3.4984157332238975`*^9, 3.49841574918392*^9}, 
   3.4984158925641203`*^9, 3.4984170047256775`*^9, {3.4984170427057304`*^9, 
   3.498417061765757*^9}, 3.498417142815871*^9, {3.4984174810763445`*^9, 
   3.4984175071063805`*^9}, {3.4984175424564304`*^9, 
   3.4984175583264523`*^9}, {3.4984176607865963`*^9, 3.498417671346611*^9}, {
   3.4984177017366533`*^9, 3.49841770652666*^9}, 3.4984191597086945`*^9, {
   3.4984191954487443`*^9, 3.498419207218761*^9}, {3.4984313788432827`*^9, 
   3.498431411088539*^9}, 3.4984328210318146`*^9, 3.4984329324316106`*^9, 
   3.4984340743564167`*^9, 3.49843416142017*^9, 3.4984345855073156`*^9, {
   3.5154366567603216`*^9, 3.515436659860326*^9}, {3.515436764420472*^9, 
   3.515436789440507*^9}, 3.5154368673506165`*^9, {3.5162351337372446`*^9, 
   3.5162351500331764`*^9}, {3.516236554865528*^9, 3.51623655751468*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "*", "a", "*", "A"}], "-", 
       RowBox[{"b", "*", "B"}], "+", 
       RowBox[{"c", "*", "C"}]}], ")"}], "*", 
     RowBox[{"x", "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", 
        RowBox[{"a", "^", "2"}]}], ")"}]}]}], " ", "-", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", "*", "B"}], "-", 
       RowBox[{"c", "*", "C"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "-", 
        RowBox[{"c", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "a", "*", "b", "*", "c", "*", "e"}], ")"}]}]}], " ", 
    "+", " ", "\n", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "*", "B"}], "+", 
          RowBox[{"c", "*", "C"}]}], ")"}]}], "-", 
       RowBox[{"2", "*", "a", "*", "A", "*", 
        RowBox[{"b", "^", "2"}]}], "+", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "*", "B"}], "-", 
          RowBox[{"c", "*", "C"}]}], ")"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", 
        RowBox[{"a", "^", "2"}], "*", "b", "*", "c", "*", "e"}], ")"}]}]}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "B", ",", 
        "C"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984158462540555`*^9, 
   3.498416698885249*^9, 3.498416908705543*^9, 3.4984171017058134`*^9, {
   3.498417351646163*^9, 3.4984173769561987`*^9}, 3.4984174573863115`*^9, 
   3.4984176196065383`*^9, 3.4984311835465393`*^9, 3.498431990639157*^9, 
   3.498432773248931*^9, 3.4984328413742504`*^9, {3.498432890405137*^9, 
   3.4984329019179573`*^9}, 3.4984336733577127`*^9, 3.498433726475806*^9, 
   3.4984338188747683`*^9, 3.498433909495328*^9, {3.4984345619824743`*^9, 
   3.4984345685032854`*^9}, {3.515436599220241*^9, 3.5154366441703043`*^9}, {
   3.5154368460105867`*^9, 3.515436853490597*^9}, {3.51623525762333*^9, 
   3.516235309756312*^9}, {3.5162356387001266`*^9, 3.5162356394321685`*^9}, 
   3.5162366405454288`*^9, 3.5162485844015784`*^9},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: G&R 2.451.3 with  ",
 Cell[BoxData[
  RowBox[{"B", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, 3.4984169139755507`*^9, {
   3.4984170148056917`*^9, 3.4984170161556935`*^9}, {3.498417209325964*^9, 
   3.4984172183259764`*^9}, 3.498417464166321*^9, 3.4984176249865456`*^9, {
   3.4984190999186106`*^9, 3.4984191011286125`*^9}, 3.4984312037641754`*^9, {
   3.498432107096561*^9, 3.4984321210117855`*^9}, 3.498493182871073*^9, {
   3.4984937552524786`*^9, 3.4984937670304995`*^9}, 3.5154349807398634`*^9, {
   3.515435099112871*^9, 3.515435099112871*^9}, {3.516235328902407*^9, 
   3.516235334411722*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "*", "a", "*", "A"}], "+", 
       RowBox[{"c", "*", "C"}]}], ")"}], "*", 
     RowBox[{"x", "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", 
        RowBox[{"a", "^", "2"}]}], ")"}]}]}], " ", "+", " ", 
    RowBox[{"C", "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "a", "*", "e"}], ")"}]}]}], " ", "-", " ", 
    RowBox[{"c", "*", "C", "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "a", "*", "b", "*", "e"}], ")"}]}]}], " ", "+", " ", 
    "\n", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", "C"}], "-", 
       RowBox[{"2", "*", "a", "*", "c", "*", "A"}], "-", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", "C"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", 
        RowBox[{"a", "^", "2"}], "*", "b", "*", "e"}], ")"}]}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984158462540555`*^9, 
   3.498416698885249*^9, 3.498416908705543*^9, 3.4984171017058134`*^9, {
   3.498417351646163*^9, 3.4984173769561987`*^9}, 3.4984174573863115`*^9, 
   3.4984176196065383`*^9, 3.4984311835465393`*^9, 3.498431990639157*^9, {
   3.4984341919026237`*^9, 3.4984342187818713`*^9}, {3.4984342969224086`*^9, 
   3.4984343035368204`*^9}, {3.5154350163079257`*^9, 
   3.5154350307535505`*^9}, {3.5154350707208214`*^9, 
   3.5154350759156303`*^9}, {3.515442216698106*^9, 3.5154422240481157`*^9}, {
   3.516235370964813*^9, 3.516235405734802*^9}, {3.516235443181944*^9, 
   3.516235483086226*^9}, {3.516235642028317*^9, 3.516235643430397*^9}, {
   3.5162366429825687`*^9, 3.5162366987827597`*^9}, {3.5162394839500628`*^9, 
   3.5162395498318305`*^9}, {3.516239666833523*^9, 3.5162396758670397`*^9}, {
   3.516239774174662*^9, 3.5162397745646844`*^9}, 3.5162485864306946`*^9},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: G&R 2.451.3 with  ",
 Cell[BoxData[
  RowBox[{"C", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, 3.4984169139755507`*^9, {
   3.4984170148056917`*^9, 3.4984170161556935`*^9}, {3.498417209325964*^9, 
   3.4984172183259764`*^9}, 3.498417464166321*^9, 3.4984176249865456`*^9, {
   3.4984190999186106`*^9, 3.4984191011286125`*^9}, 3.4984312037641754`*^9, {
   3.498432107096561*^9, 3.4984321210117855`*^9}, 3.498493182871073*^9, {
   3.4984937552524786`*^9, 3.4984937670304995`*^9}, 3.5154349807398634`*^9, {
   3.515435099112871*^9, 3.515435099112871*^9}, 3.515441739597438*^9, 
   3.5154417829674983`*^9, {3.515442148988011*^9, 3.5154421555080194`*^9}, {
   3.516235338599962*^9, 3.5162353434382386`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "*", "a", "*", "A"}], "-", 
       RowBox[{"b", "*", "B"}]}], ")"}], "*", 
     RowBox[{"x", "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", 
        RowBox[{"a", "^", "2"}]}], ")"}]}]}], " ", "-", " ", 
    RowBox[{"b", "*", "B", "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "a", "*", "c", "*", "e"}], ")"}]}]}], " ", "+", " ", 
    RowBox[{"B", "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "a", "*", "e"}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", "B"}], "-", 
       RowBox[{"2", "*", "a", "*", "b", "*", "A"}], "+", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", "B"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", 
        RowBox[{"a", "^", "2"}], "*", "c", "*", "e"}], ")"}]}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "B"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984158462540555`*^9, 
   3.498416698885249*^9, 3.498416908705543*^9, 3.4984171017058134`*^9, {
   3.498417351646163*^9, 3.4984173769561987`*^9}, 3.4984174573863115`*^9, 
   3.4984176196065383`*^9, 3.4984311835465393`*^9, 3.498431990639157*^9, {
   3.4984341919026237`*^9, 3.4984342187818713`*^9}, {3.4984342969224086`*^9, 
   3.4984343035368204`*^9}, {3.5154350163079257`*^9, 
   3.5154350307535505`*^9}, {3.5154350707208214`*^9, 3.5154350759156303`*^9}, 
   3.5154417266374197`*^9, {3.5154421043679485`*^9, 3.5154421305679846`*^9}, {
   3.515442232748128*^9, 3.515442239278137*^9}, 3.5162353735509605`*^9, {
   3.5162354163284073`*^9, 3.5162354295621643`*^9}, {3.516235484800324*^9, 
   3.5162355360262537`*^9}, {3.5162356460695477`*^9, 3.516235646815591*^9}, 
   3.5162366457477264`*^9, {3.5162367073172483`*^9, 3.516236739116067*^9}, {
   3.51623956485669*^9, 3.5162395965975056`*^9}, {3.5162398462677855`*^9, 
   3.516239853441196*^9}, {3.5162466916563196`*^9, 3.5162466931184034`*^9}, 
   3.516248588128792*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Reference: G&R ",
 "2.451.2",
 " with  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"A", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}], ")"}]}], "-", 
    RowBox[{"a", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", " ", "B"}], "-", 
       RowBox[{"c", " ", "C"}]}], ")"}]}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, 3.4984169139755507`*^9, {
   3.4984170148056917`*^9, 3.4984170161556935`*^9}, {3.498417209325964*^9, 
   3.4984172183259764`*^9}, 3.498417464166321*^9, 3.4984176249865456`*^9, {
   3.4984190999186106`*^9, 3.4984191011286125`*^9}, 3.4984312037641754`*^9, {
   3.498432107096561*^9, 3.4984321210117855`*^9}, 3.498432947626037*^9, 
   3.498433970850235*^9, 3.4984931895946846`*^9, {3.5154366850003614`*^9, 
   3.5154366904003687`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"A", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], "-", 
     RowBox[{"a", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", " ", "B"}], "-", 
        RowBox[{"c", " ", "C"}]}], ")"}]}]}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9, {3.4984155639236603`*^9, 
   3.4984155645936613`*^9}, {3.4984168250854263`*^9, 3.498416828835431*^9}, {
   3.4984176812066245`*^9, 3.498417690706638*^9}, {3.4984314419453936`*^9, 
   3.4984314738318496`*^9}, 3.49843175923075*^9, {3.4984328634326897`*^9, 
   3.498432867660297*^9}, {3.4984337769418945`*^9, 3.4984337782366967`*^9}, {
   3.498433846533617*^9, 3.4984338823044796`*^9}, {3.5154366677003365`*^9, 
   3.515436676140349*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"C", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"c", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "B"}], "-", 
          RowBox[{"c", " ", "C"}]}], ")"}], " ", "x"}], 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"c", " ", "B"}], "-", 
      RowBox[{"b", " ", "C"}]}], ")"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"c", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}], "]"}]}], 
   RowBox[{"e", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}]}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9, {3.4984157332238975`*^9, 3.49841574918392*^9}, 
   3.4984158925641203`*^9, 3.4984170047256775`*^9, {3.4984170427057304`*^9, 
   3.498417061765757*^9}, 3.498417142815871*^9, {3.4984174810763445`*^9, 
   3.4984175071063805`*^9}, {3.4984175424564304`*^9, 
   3.4984175583264523`*^9}, {3.4984176607865963`*^9, 3.498417671346611*^9}, {
   3.4984177017366533`*^9, 3.49841770652666*^9}, 3.4984191597086945`*^9, {
   3.4984191954487443`*^9, 3.498419207218761*^9}, {3.4984313788432827`*^9, 
   3.498431411088539*^9}, 3.4984328210318146`*^9, 3.4984329324316106`*^9, 
   3.4984340743564167`*^9, 3.49843416142017*^9, 3.4984345855073156`*^9, {
   3.5154366567603216`*^9, 3.515436659860326*^9}, {3.515436764420472*^9, 
   3.515436789440507*^9}, 3.5154368673506165`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", "*", "B"}], "-", 
       RowBox[{"c", "*", "C"}]}], ")"}], "*", 
     RowBox[{"x", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "-", 
        RowBox[{"c", "^", "2"}]}], ")"}]}]}], " ", "-", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c", "*", "B"}], "-", 
       RowBox[{"b", "*", "C"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"c", "^", "2"}]}], ")"}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "B", ",", 
        "C"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"A", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "-", 
         RowBox[{"c", "^", "2"}]}], ")"}]}], "-", 
      RowBox[{"a", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "B"}], "-", 
         RowBox[{"c", "*", "C"}]}], ")"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984158462540555`*^9, 
   3.498416698885249*^9, 3.498416908705543*^9, 3.4984171017058134`*^9, {
   3.498417351646163*^9, 3.4984173769561987`*^9}, 3.4984174573863115`*^9, 
   3.4984176196065383`*^9, 3.4984311835465393`*^9, 3.498431990639157*^9, 
   3.498432773248931*^9, 3.4984328413742504`*^9, {3.498432890405137*^9, 
   3.4984329019179573`*^9}, 3.4984336733577127`*^9, 3.498433726475806*^9, 
   3.4984338188747683`*^9, 3.498433909495328*^9, {3.4984345619824743`*^9, 
   3.4984345685032854`*^9}, {3.515436599220241*^9, 3.5154366441703043`*^9}, {
   3.5154368460105867`*^9, 3.515436853490597*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: G&R ",
 "2.451.2",
 " with  ",
 Cell[BoxData[
  RowBox[{"B", "=", "0"}]]],
 "  and  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"A", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}], ")"}]}], "+", 
    RowBox[{"a", " ", "c", " ", "C"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, 3.4984169139755507`*^9, {
   3.4984170148056917`*^9, 3.4984170161556935`*^9}, {3.498417209325964*^9, 
   3.4984172183259764`*^9}, 3.498417464166321*^9, 3.4984176249865456`*^9, {
   3.4984190999186106`*^9, 3.4984191011286125`*^9}, 3.4984312037641754`*^9, {
   3.498432107096561*^9, 3.4984321210117855`*^9}, 3.498493182871073*^9, {
   3.4984937552524786`*^9, 3.4984937670304995`*^9}, 3.5154349807398634`*^9, {
   3.515435099112871*^9, 3.515435099112871*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "c"}], "*", "C", "*", 
     RowBox[{"x", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "-", 
        RowBox[{"c", "^", "2"}]}], ")"}]}]}], " ", "+", " ", 
    RowBox[{"b", "*", "C", "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"c", "^", "2"}]}], ")"}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"A", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "-", 
         RowBox[{"c", "^", "2"}]}], ")"}]}], "+", 
      RowBox[{"a", "*", "c", "*", "C"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984158462540555`*^9, 
   3.498416698885249*^9, 3.498416908705543*^9, 3.4984171017058134`*^9, {
   3.498417351646163*^9, 3.4984173769561987`*^9}, 3.4984174573863115`*^9, 
   3.4984176196065383`*^9, 3.4984311835465393`*^9, 3.498431990639157*^9, {
   3.4984341919026237`*^9, 3.4984342187818713`*^9}, {3.4984342969224086`*^9, 
   3.4984343035368204`*^9}, {3.5154350163079257`*^9, 
   3.5154350307535505`*^9}, {3.5154350707208214`*^9, 
   3.5154350759156303`*^9}, {3.515442216698106*^9, 3.5154422240481157`*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: G&R ",
 "2.451.2",
 " with  ",
 Cell[BoxData[
  RowBox[{"C", "=", "0"}]]],
 "  and  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"A", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}], ")"}]}], "-", 
    RowBox[{"a", " ", "b", " ", "B"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, 3.4984169139755507`*^9, {
   3.4984170148056917`*^9, 3.4984170161556935`*^9}, {3.498417209325964*^9, 
   3.4984172183259764`*^9}, 3.498417464166321*^9, 3.4984176249865456`*^9, {
   3.4984190999186106`*^9, 3.4984191011286125`*^9}, 3.4984312037641754`*^9, {
   3.498432107096561*^9, 3.4984321210117855`*^9}, 3.498493182871073*^9, {
   3.4984937552524786`*^9, 3.4984937670304995`*^9}, 3.5154349807398634`*^9, {
   3.515435099112871*^9, 3.515435099112871*^9}, 3.515441739597438*^9, 
   3.5154417829674983`*^9, {3.515442148988011*^9, 3.5154421555080194`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"b", "*", "B", "*", 
     RowBox[{"x", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "-", 
        RowBox[{"c", "^", "2"}]}], ")"}]}]}], " ", "-", " ", 
    RowBox[{"c", "*", "B", "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"c", "^", "2"}]}], ")"}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "B"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"A", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "-", 
         RowBox[{"c", "^", "2"}]}], ")"}]}], "-", 
      RowBox[{"a", "*", "b", "*", "B"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984158462540555`*^9, 
   3.498416698885249*^9, 3.498416908705543*^9, 3.4984171017058134`*^9, {
   3.498417351646163*^9, 3.4984173769561987`*^9}, 3.4984174573863115`*^9, 
   3.4984176196065383`*^9, 3.4984311835465393`*^9, 3.498431990639157*^9, {
   3.4984341919026237`*^9, 3.4984342187818713`*^9}, {3.4984342969224086`*^9, 
   3.4984343035368204`*^9}, {3.5154350163079257`*^9, 
   3.5154350307535505`*^9}, {3.5154350707208214`*^9, 3.5154350759156303`*^9}, 
   3.5154417266374197`*^9, {3.5154421043679485`*^9, 3.5154421305679846`*^9}, {
   3.515442232748128*^9, 3.515442239278137*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.451.2", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9, 3.515436699990382*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     SuperscriptBox["c", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"A", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], "-", 
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", " ", "B"}], "-", 
        RowBox[{"c", " ", "C"}]}], ")"}]}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9, {3.4984155639236603`*^9, 
   3.4984155645936613`*^9}, {3.4984168250854263`*^9, 3.498416828835431*^9}, {
   3.4984176812066245`*^9, 3.498417690706638*^9}, {3.4984314419453936`*^9, 
   3.4984314738318496`*^9}, 3.49843175923075*^9, {3.4984320994837475`*^9, 
   3.4984321010281506`*^9}, 3.4984330519962215`*^9, {3.498434747576*^9, 
   3.4984347506804056`*^9}, {3.5154372914712105`*^9, 3.5154373096012354`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"C", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"c", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "B"}], "-", 
          RowBox[{"c", " ", "C"}]}], ")"}], " ", "x"}], 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"c", " ", "B"}], "-", 
      RowBox[{"b", " ", "C"}]}], ")"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"c", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}], "]"}]}], 
   RowBox[{"e", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}]}]], "+", "\[IndentingNewLine]", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"A", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], "-", 
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", " ", "B"}], "-", 
        RowBox[{"c", " ", "C"}]}], ")"}]}]}], 
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     SuperscriptBox["c", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9, {3.4984157332238975`*^9, 3.49841574918392*^9}, {
   3.4984167480753183`*^9, 3.4984167773253593`*^9}, {3.4984192598788347`*^9, 
   3.4984192736088543`*^9}, {3.4984317085306616`*^9, 
   3.4984317224926863`*^9}, {3.4984318598565273`*^9, 3.4984319106266165`*^9}, 
   3.498432821499816*^9, {3.4984332348441424`*^9, 3.4984332447501593`*^9}, 
   3.498434076665221*^9, {3.4984346622282505`*^9, 3.4984346847546897`*^9}, {
   3.5154372524511557`*^9, 3.51543730587123*^9}, {3.5154373568313017`*^9, 
   3.5154373626413097`*^9}, 3.5154374720114627`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", "*", "B"}], "-", 
       RowBox[{"c", "*", "C"}]}], ")"}], "*", 
     RowBox[{"x", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "-", 
        RowBox[{"c", "^", "2"}]}], ")"}]}]}], " ", "-", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c", "*", "B"}], "-", 
       RowBox[{"b", "*", "C"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"c", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"A", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", "^", "2"}], "-", 
            RowBox[{"c", "^", "2"}]}], ")"}]}], "-", 
         RowBox[{"a", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", "*", "B"}], "-", 
            RowBox[{"c", "*", "C"}]}], ")"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "-", 
         RowBox[{"c", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Cosh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"Sinh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "B", ",", 
        "C"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"A", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "-", 
         RowBox[{"c", "^", "2"}]}], ")"}]}], "-", 
      RowBox[{"a", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "B"}], "-", 
         RowBox[{"c", "*", "C"}]}], ")"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9, 
   3.498431175169325*^9, 3.4984315237831373`*^9, 3.4984318251464663`*^9, 
   3.498431987628351*^9, 3.4984327757761354`*^9, 3.498433033494589*^9, 
   3.4984330656774454`*^9, {3.4984331457211857`*^9, 3.4984331533183994`*^9}, 
   3.498433676228118*^9, {3.498433997510682*^9, 3.498434057913988*^9}, {
   3.4984346049605494`*^9, 3.498434605678151*^9}, {3.4984347246595597`*^9, 
   3.4984347265003633`*^9}, {3.515437210051096*^9, 3.515437244751145*^9}, {
   3.5154373330412683`*^9, 3.5154373423212814`*^9}, 3.515437407611373*^9, 
   3.515437466941456*^9, 3.5154424311084056`*^9},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: G&R ",
 "2.451.2",
 " with  ",
 Cell[BoxData[
  RowBox[{"B", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9, {3.498493738154848*^9, 
   3.4984937466880636`*^9}, 3.515435246640731*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "c"}], "*", "C", "*", 
     RowBox[{"x", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "-", 
        RowBox[{"c", "^", "2"}]}], ")"}]}]}], " ", "+", " ", 
    RowBox[{"b", "*", "C", "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"c", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"A", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", "^", "2"}], "-", 
            RowBox[{"c", "^", "2"}]}], ")"}]}], "+", 
         RowBox[{"a", "*", "c", "*", "C"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "-", 
         RowBox[{"c", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Cosh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"Sinh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"A", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "-", 
         RowBox[{"c", "^", "2"}]}], ")"}]}], "+", 
      RowBox[{"a", "*", "c", "*", "C"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9, 
   3.498431175169325*^9, 3.4984315237831373`*^9, 3.4984318251464663`*^9, 
   3.498431987628351*^9, {3.498434366623331*^9, 3.4984343756713467`*^9}, {
   3.5154352883708043`*^9, 3.5154353075900383`*^9}, {3.515435413888625*^9, 
   3.515435441375873*^9}, {3.515442382818338*^9, 3.5154423899183483`*^9}, 
   3.515442429678404*^9},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: G&R ",
 "2.451.2",
 " with  ",
 Cell[BoxData[
  RowBox[{"C", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9, {3.498493738154848*^9, 
   3.4984937466880636`*^9}, 3.515435246640731*^9, 3.5154418217975526`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"b", "*", "B", "*", 
     RowBox[{"x", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "-", 
        RowBox[{"c", "^", "2"}]}], ")"}]}]}], " ", "-", " ", 
    RowBox[{"c", "*", "B", "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"c", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"A", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", "^", "2"}], "-", 
            RowBox[{"c", "^", "2"}]}], ")"}]}], "-", 
         RowBox[{"a", "*", "b", "*", "B"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "-", 
         RowBox[{"c", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Cosh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"Sinh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "B"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"A", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "-", 
         RowBox[{"c", "^", "2"}]}], ")"}]}], "-", 
      RowBox[{"a", "*", "b", "*", "B"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9, 
   3.498431175169325*^9, 3.4984315237831373`*^9, 3.4984318251464663`*^9, 
   3.498431987628351*^9, {3.498434366623331*^9, 3.4984343756713467`*^9}, {
   3.5154352883708043`*^9, 3.5154353075900383`*^9}, {3.515435413888625*^9, 
   3.515435441375873*^9}, 3.5154418185875483`*^9, 3.5154423033082266`*^9, {
   3.5154423445982847`*^9, 3.5154423595183053`*^9}, {3.515442394788355*^9, 
   3.5154424255283976`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Reference: G&R ",
 "2.451.1",
 " with  ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"-", "2"}]}]]],
 "  and  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "A"}], "-", 
    RowBox[{"b", " ", "B"}], "+", 
    RowBox[{"c", " ", "C"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9, 3.498432181820692*^9, {
   3.4984323991446743`*^9, 3.4984324154623027`*^9}, {3.4984326517715178`*^9, 
   3.4984326721139536`*^9}, 3.498433303952264*^9, 3.4984348513785825`*^9, 
   3.4984931905618863`*^9, 3.498493920441169*^9, 3.515436711270398*^9, {
   3.5154378323319674`*^9, 3.5154378323319674`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"a", " ", "A"}], "-", 
     RowBox[{"b", " ", "B"}], "+", 
     RowBox[{"c", " ", "C"}]}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9, {3.4984155639236603`*^9, 
   3.4984155645936613`*^9}, {3.4984168250854263`*^9, 3.498416828835431*^9}, {
   3.4984176812066245`*^9, 3.498417690706638*^9}, {3.4984314419453936`*^9, 
   3.4984314738318496`*^9}, 3.49843175923075*^9, {3.4984320994837475`*^9, 
   3.4984321010281506`*^9}, {3.4984322552188215`*^9, 3.4984322841256723`*^9}, 
   3.4984333049662657`*^9, {3.4984348419873657`*^9, 3.4984348444833703`*^9}, {
   3.5154376831317587`*^9, 3.5154376831317587`*^9}, {3.5154378219319525`*^9, 
   3.5154378219319525`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      RowBox[{"Cosh", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"C", " ", 
      RowBox[{"Sinh", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "2"]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"c", " ", "B"}], "-", 
        RowBox[{"b", " ", "C"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "C"}], "-", 
           RowBox[{"c", " ", "A"}]}], ")"}], " ", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "A"}], "-", 
           RowBox[{"a", " ", "B"}]}], ")"}], " ", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}]}], 
       RowBox[{"e", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "+", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Cosh", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
          RowBox[{"c", " ", 
           RowBox[{"Sinh", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}]}], 
         ")"}]}]]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9, {3.4984157332238975`*^9, 3.49841574918392*^9}, {
   3.4984167480753183`*^9, 3.4984167773253593`*^9}, {3.4984192598788347`*^9, 
   3.4984192736088543`*^9}, {3.4984317085306616`*^9, 
   3.4984317224926863`*^9}, {3.4984318598565273`*^9, 
   3.4984319106266165`*^9}, {3.498432204378332*^9, 3.4984322333163824`*^9}, 
   3.498432821999017*^9, 3.4984333425279317`*^9, 3.4984340793016253`*^9, 
   3.4984348259037375`*^9, {3.515437679541754*^9, 3.515437689201767*^9}, {
   3.515437882692038*^9, 3.5154378851120415`*^9}, {3.5154379444821243`*^9, 
   3.515437970962161*^9}, {3.515438145682406*^9, 3.5154381632324305`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "2"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c", "*", "B"}], "-", 
       RowBox[{"b", "*", "C"}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "*", "C"}], "-", 
          RowBox[{"c", "*", "A"}]}], ")"}], "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "*", "A"}], "-", 
          RowBox[{"a", "*", "B"}]}], ")"}], "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], "/", "\n", "    ", 
    RowBox[{"(", 
     RowBox[{"e", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "-", 
        RowBox[{"b", "^", "2"}], "+", 
        RowBox[{"c", "^", "2"}]}], ")"}], "*", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], ")"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "B", ",", 
        "C"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "A"}], "-", 
      RowBox[{"b", "*", "B"}], "+", 
      RowBox[{"c", "*", "C"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9, 
   3.498431175169325*^9, 3.4984315237831373`*^9, 3.4984318251464663`*^9, 
   3.498431987628351*^9, 3.4984321755026813`*^9, 3.49843277822534*^9, 
   3.4984332805522223`*^9, 3.498433678505722*^9, 3.4984348062477036`*^9, 
   3.515437661961729*^9, {3.5154377640118713`*^9, 3.5154377724618835`*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: G&R ",
 "2.451.1",
 " with  ",
 Cell[BoxData[
  RowBox[{"B", "=", "0"}]]],
 ",  ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"-", "2"}]}]]],
 "  and  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "A"}], "+", 
    RowBox[{"c", " ", "C"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9, 3.498432181820692*^9, {
   3.4984323991446743`*^9, 3.4984324154623027`*^9}, {3.4984326517715178`*^9, 
   3.4984326721139536`*^9}, 3.4984931838070745`*^9, {3.498493396621448*^9, 
   3.4984934439207315`*^9}, {3.4984936249610496`*^9, 3.498493630343059*^9}, {
   3.4984936632903166`*^9, 3.4984936800135465`*^9}, 3.5154355354596386`*^9, {
   3.515435699556327*^9, 3.515435699556327*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "2"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"b", "*", "C"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", "C"}], "-", 
         RowBox[{"c", "*", "A"}]}], ")"}], "*", 
       RowBox[{"Cosh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", "*", "x"}]}], "]"}]}], "-", 
      RowBox[{"b", "*", "A", "*", 
       RowBox[{"Sinh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"e", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "-", 
        RowBox[{"b", "^", "2"}], "+", 
        RowBox[{"c", "^", "2"}]}], ")"}], "*", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], ")"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "A"}], "+", 
      RowBox[{"c", "*", "C"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9, 
   3.498431175169325*^9, 3.4984315237831373`*^9, 3.4984318251464663`*^9, 
   3.498431987628351*^9, 3.4984321755026813`*^9, 3.5154355764409103`*^9, {
   3.5154356368910165`*^9, 3.51543564434783*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: G&R ",
 "2.451.1",
 " with  ",
 Cell[BoxData[
  RowBox[{"C", "=", "0"}]]],
 ",  ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"-", "2"}]}]]],
 "  and  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "A"}], "-", 
    RowBox[{"b", " ", "B"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9, 3.498432181820692*^9, {
   3.4984323991446743`*^9, 3.4984324154623027`*^9}, {3.4984326517715178`*^9, 
   3.4984326721139536`*^9}, 3.4984931838070745`*^9, {3.498493396621448*^9, 
   3.4984934439207315`*^9}, {3.4984936249610496`*^9, 3.498493630343059*^9}, {
   3.4984936632903166`*^9, 3.4984936800135465`*^9}, 3.5154355354596386`*^9, {
   3.515435699556327*^9, 3.515435699556327*^9}, 3.515441850707593*^9, {
   3.5154424834384785`*^9, 3.5154424880484858`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "2"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c", "*", "B"}], "+", 
       RowBox[{"c", "*", "A", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "*", "A"}], "-", 
          RowBox[{"a", "*", "B"}]}], ")"}], "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], "/", 
    RowBox[{"(", 
     RowBox[{"e", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "-", 
        RowBox[{"b", "^", "2"}], "+", 
        RowBox[{"c", "^", "2"}]}], ")"}], "*", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], ")"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "B"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "A"}], "-", 
      RowBox[{"b", "*", "B"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9, 
   3.498431175169325*^9, 3.4984315237831373`*^9, 3.4984318251464663`*^9, 
   3.498431987628351*^9, 3.4984321755026813`*^9, 3.5154355764409103`*^9, {
   3.5154356368910165`*^9, 3.51543564434783*^9}, 3.515441847157588*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Reference: G&R ",
 "2.451.1",
 " with  ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"-", "2"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9, 3.498432181820692*^9, {
   3.4984323991446743`*^9, 3.4984324154623027`*^9}, 3.498493191591488*^9, 
   3.5154367165604053`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "A"}], "-", 
     RowBox[{"b", " ", "B"}], "+", 
     RowBox[{"c", " ", "C"}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9, {3.4984155639236603`*^9, 
   3.4984155645936613`*^9}, {3.4984168250854263`*^9, 3.498416828835431*^9}, {
   3.4984176812066245`*^9, 3.498417690706638*^9}, {3.4984314419453936`*^9, 
   3.4984314738318496`*^9}, 3.49843175923075*^9, {3.4984320994837475`*^9, 
   3.4984321010281506`*^9}, {3.4984322552188215`*^9, 
   3.4984322841256723`*^9}, {3.4984323834198465`*^9, 3.4984323866490517`*^9}, 
   3.498433305855467*^9, 3.498434928988719*^9, {3.5154383075226326`*^9, 
   3.515438318942649*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"C", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "2"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"c", " ", "B"}], "-", 
         RowBox[{"b", " ", "C"}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", " ", "C"}], "-", 
            RowBox[{"c", " ", "A"}]}], ")"}], " ", 
          RowBox[{"Cosh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", " ", "A"}], "-", 
            RowBox[{"a", " ", "B"}]}], ")"}], " ", 
          RowBox[{"Sinh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}]}], 
        RowBox[{"e", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Cosh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", " ", 
            RowBox[{"Sinh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"a", " ", "A"}], "-", 
     RowBox[{"b", " ", "B"}], "+", 
     RowBox[{"c", " ", "C"}]}], 
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9, {3.4984157332238975`*^9, 3.49841574918392*^9}, {
   3.4984167480753183`*^9, 3.4984167773253593`*^9}, {3.4984192598788347`*^9, 
   3.4984192736088543`*^9}, {3.4984317085306616`*^9, 
   3.4984317224926863`*^9}, {3.4984318598565273`*^9, 
   3.4984319106266165`*^9}, {3.498432204378332*^9, 3.4984322333163824`*^9}, {
   3.4984323510497894`*^9, 3.4984323629994106`*^9}, 3.498432822467017*^9, 
   3.4984333084606714`*^9, 3.498433413617256*^9, 3.4984340815948296`*^9, 
   3.498434914808294*^9, {3.5154382128725*^9, 3.5154382140925016`*^9}, {
   3.515438256762562*^9, 3.515438267172576*^9}, {3.5154383010926237`*^9, 
   3.515438326262659*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "2"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"c", "*", "B"}], "-", 
        RowBox[{"b", "*", "C"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", "C"}], "-", 
           RowBox[{"c", "*", "A"}]}], ")"}], "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "*", "A"}], "-", 
           RowBox[{"a", "*", "B"}]}], ")"}], "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], "/", "\n", "     ", 
     RowBox[{"(", 
      RowBox[{"e", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}], "+", 
         RowBox[{"c", "^", "2"}]}], ")"}], "*", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cosh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sinh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], ")"}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", "A"}], "-", 
         RowBox[{"b", "*", "B"}], "+", 
         RowBox[{"c", "*", "C"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}], "+", 
         RowBox[{"c", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Cosh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"Sinh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "B", ",", 
        "C"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "A"}], "-", 
      RowBox[{"b", "*", "B"}], "+", 
      RowBox[{"c", "*", "C"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9, 
   3.498431175169325*^9, 3.4984315237831373`*^9, 3.4984318251464663`*^9, 
   3.498431987628351*^9, 3.4984321755026813`*^9, 3.49843232278254*^9, 
   3.4984327810177445`*^9, 3.4984333852876067`*^9, 3.498433681064126*^9, 
   3.498434875028224*^9, 3.5154382516525545`*^9, {3.5154383526026955`*^9, 
   3.5154383550726995`*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: G&R ",
 "2.451.1",
 " with  ",
 Cell[BoxData[
  RowBox[{"B", "=", "0"}]]],
 "  and  ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"-", "2"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9, 3.498432181820692*^9, {
   3.4984323991446743`*^9, 3.4984324154623027`*^9}, 3.498493185148677*^9, {
   3.498493360710185*^9, 3.4984933752026105`*^9}, {3.498493569424952*^9, 
   3.4984936181906376`*^9}, 3.5154357361359916`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "2"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", "*", "C"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "*", "C"}], "-", 
          RowBox[{"c", "*", "A"}]}], ")"}], "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}], "-", 
       RowBox[{"b", "*", "A", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"e", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}], "+", 
         RowBox[{"c", "^", "2"}]}], ")"}], "*", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cosh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sinh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], ")"}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", "A"}], "+", 
         RowBox[{"c", "*", "C"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}], "+", 
         RowBox[{"c", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Cosh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"Sinh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "A"}], "+", 
      RowBox[{"c", "*", "C"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9, 
   3.498431175169325*^9, 3.4984315237831373`*^9, 3.4984318251464663`*^9, 
   3.498431987628351*^9, 3.4984321755026813`*^9, 3.49843232278254*^9, 
   3.515435729069179*^9, {3.515435766821245*^9, 3.5154357737944574`*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: G&R ",
 "2.451.1",
 " with  ",
 Cell[BoxData[
  RowBox[{"C", "=", "0"}]]],
 "  and  ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"-", "2"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9, 3.498432181820692*^9, {
   3.4984323991446743`*^9, 3.4984324154623027`*^9}, 3.498493185148677*^9, {
   3.498493360710185*^9, 3.4984933752026105`*^9}, {3.498493569424952*^9, 
   3.4984936181906376`*^9}, 3.5154357361359916`*^9, 3.515441875027627*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "2"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"c", "*", "B"}], "+", 
        RowBox[{"c", "*", "A", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "*", "A"}], "-", 
           RowBox[{"a", "*", "B"}]}], ")"}], "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"e", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}], "+", 
         RowBox[{"c", "^", "2"}]}], ")"}], "*", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cosh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sinh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], ")"}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", "A"}], "-", 
         RowBox[{"b", "*", "B"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}], "+", 
         RowBox[{"c", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Cosh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"Sinh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "B"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "A"}], "-", 
      RowBox[{"b", "*", "B"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9, 
   3.498431175169325*^9, 3.4984315237831373`*^9, 3.4984318251464663`*^9, 
   3.498431987628351*^9, 3.4984321755026813`*^9, 3.49843232278254*^9, 
   3.515435729069179*^9, {3.515435766821245*^9, 3.5154357737944574`*^9}, 
   3.5154418721576233`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9, 3.498432181820692*^9, {
   3.4984323991446743`*^9, 3.4984324154623027`*^9}, 3.498432451841566*^9, 
   3.49843515735752*^9, 3.498435501447725*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", "z"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "z"}]}], ")"}], "n"]}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["B", "b"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}], ")"}], 
      RowBox[{"n", "+", "1"}]]}], "+", 
    RowBox[{
     FractionBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"A", " ", "b"}], "-", 
        RowBox[{"a", " ", "B"}]}], ")"}], "b"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}], ")"}], "n"]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9, 3.498432181820692*^9, {
   3.4984323991446743`*^9, 3.4984324154623027`*^9}, 3.498432451841566*^9, 
   3.49843515735752*^9, {3.498435501447725*^9, 3.4984355267977695`*^9}, {
   3.4984357590977774`*^9, 3.4984357721082*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "C"}], "-", 
    RowBox[{"c", " ", "B"}]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"b", " ", "A"}], "-", 
      RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{"n", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], " ", "\[Or]", " ", 
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}]}], "=", "0"}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9, {3.4984155639236603`*^9, 
   3.4984155645936613`*^9}, {3.4984168250854263`*^9, 3.498416828835431*^9}, {
   3.4984176812066245`*^9, 3.498417690706638*^9}, {3.4984314419453936`*^9, 
   3.4984314738318496`*^9}, 3.49843175923075*^9, {3.4984320994837475`*^9, 
   3.4984321010281506`*^9}, {3.4984322552188215`*^9, 
   3.4984322841256723`*^9}, {3.4984323834198465`*^9, 
   3.4984323866490517`*^9}, {3.498432480654817*^9, 3.498432493134839*^9}, {
   3.4984351727703466`*^9, 3.498435175422352*^9}, {3.498435264030507*^9, 
   3.498435269162916*^9}, {3.498435620023533*^9, 3.498435704185681*^9}, {
   3.4984952989331894`*^9, 3.4984952989331894`*^9}, {3.5154385118029184`*^9, 
   3.5154385118029184`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"C", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox["B", "b"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Cosh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", " ", 
          RowBox[{"Sinh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "+", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "A"}], "-", 
     RowBox[{"a", " ", "B"}]}], "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9, {3.4984157332238975`*^9, 3.49841574918392*^9}, {
   3.4984167480753183`*^9, 3.4984167773253593`*^9}, {3.4984192598788347`*^9, 
   3.4984192736088543`*^9}, {3.4984317085306616`*^9, 
   3.4984317224926863`*^9}, {3.4984318598565273`*^9, 
   3.4984319106266165`*^9}, {3.498432204378332*^9, 3.4984322333163824`*^9}, {
   3.4984323510497894`*^9, 3.4984323629994106`*^9}, 3.4984325452077303`*^9, 
   3.4984328232938185`*^9, 3.4984333096306734`*^9, {3.4984334826161776`*^9, 
   3.4984334886845884`*^9}, 3.4984335853579583`*^9, 3.4984340846680355`*^9, 
   3.498435053898138*^9, 3.4984352319256506`*^9, {3.4984353475374537`*^9, 
   3.4984353561018686`*^9}, {3.4984355852822723`*^9, 
   3.4984356013659005`*^9}, {3.498435731626129*^9, 3.498435733295332*^9}, {
   3.5154384442728243`*^9, 3.51543844858283*^9}, {3.5154385259229383`*^9, 
   3.5154385294829435`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"B", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Cosh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"Sinh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], ",", "x"}], "]"}]}], "]"}], " ", 
    "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "A"}], "-", 
         RowBox[{"a", "*", "B"}]}], ")"}], "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Cosh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"Sinh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "B", ",", 
        "C"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "C"}], "-", 
      RowBox[{"c", "*", "B"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "==", 
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}]}], " ", "||", " ", 
      RowBox[{"ZeroQ", "[", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "-", 
        RowBox[{"b", "^", "2"}], "+", 
        RowBox[{"c", "^", "2"}]}], "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9, 
   3.498431175169325*^9, 3.4984315237831373`*^9, 3.4984318251464663`*^9, 
   3.498431987628351*^9, 3.4984321755026813`*^9, 3.49843232278254*^9, {
   3.498432445679556*^9, 3.498432459017579*^9}, {3.498432698712*^9, 
   3.4984326997104015`*^9}, 3.4984327838257494`*^9, {3.4984334339128923`*^9, 
   3.498433453646927*^9}, {3.4984335361242714`*^9, 3.4984335398058777`*^9}, 
   3.4984336840905313`*^9, {3.4984349595179725`*^9, 3.498434974540799*^9}, 
   3.498435149370306*^9, {3.4984351832535653`*^9, 3.49843518598357*^9}, 
   3.498435486861699*^9, {3.4984357147312994`*^9, 3.4984357253393183`*^9}, 
   3.5154384393628173`*^9, {3.515438481242876*^9, 3.5154384838128796`*^9}, {
   3.515438559962986*^9, 3.5154385628729897`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.451.1", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9, 3.498432181820692*^9, {
   3.4984323991446743`*^9, 3.4984324154623027`*^9}, 3.498432451841566*^9, 
   3.5154367220304127`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotEqual]", 
    RowBox[{"-", "2"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9, {3.4984155639236603`*^9, 
   3.4984155645936613`*^9}, {3.4984168250854263`*^9, 3.498416828835431*^9}, {
   3.4984176812066245`*^9, 3.498417690706638*^9}, {3.4984314419453936`*^9, 
   3.4984314738318496`*^9}, 3.49843175923075*^9, {3.4984320994837475`*^9, 
   3.4984321010281506`*^9}, {3.4984322552188215`*^9, 
   3.4984322841256723`*^9}, {3.4984323834198465`*^9, 
   3.4984323866490517`*^9}, {3.498432480654817*^9, 3.498432493134839*^9}, {
   3.515438816603345*^9, 3.515438816603345*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"C", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"c", " ", "B"}], "-", 
          RowBox[{"b", " ", "C"}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a", " ", "C"}], "-", 
             RowBox[{"c", " ", "A"}]}], ")"}], " ", 
           RowBox[{"Cosh", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"b", " ", "A"}], "-", 
             RowBox[{"a", " ", "B"}]}], ")"}], " ", 
           RowBox[{"Sinh", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Cosh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", " ", 
            RowBox[{"Sinh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"e", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "+", 
          SuperscriptBox["c", "2"]}], ")"}]}]]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "A"}], "-", 
          RowBox[{"b", " ", "B"}], "+", 
          RowBox[{"c", " ", "C"}]}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "A"}], "-", 
          RowBox[{"a", " ", "B"}]}], ")"}], " ", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "C"}], "-", 
          RowBox[{"c", " ", "A"}]}], ")"}], " ", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9, {3.4984157332238975`*^9, 3.49841574918392*^9}, {
   3.4984167480753183`*^9, 3.4984167773253593`*^9}, {3.4984192598788347`*^9, 
   3.4984192736088543`*^9}, {3.4984317085306616`*^9, 
   3.4984317224926863`*^9}, {3.4984318598565273`*^9, 
   3.4984319106266165`*^9}, {3.498432204378332*^9, 3.4984322333163824`*^9}, {
   3.4984323510497894`*^9, 3.4984323629994106`*^9}, 3.4984325452077303`*^9, 
   3.4984328232938185`*^9, 3.4984333096306734`*^9, {3.4984334826161776`*^9, 
   3.4984334886845884`*^9}, 3.4984335853579583`*^9, 3.4984340846680355`*^9, 
   3.498435053898138*^9, {3.4984353108461895`*^9, 3.4984353292386217`*^9}, {
   3.515439072293703*^9, 3.5154391037237473`*^9}, {3.5154391601438265`*^9, 
   3.51543918406386*^9}, {3.515439230563925*^9, 3.515439237953935*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c", "*", "B"}], "-", 
       RowBox[{"b", "*", "C"}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "*", "C"}], "-", 
          RowBox[{"c", "*", "A"}]}], ")"}], "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "*", "A"}], "-", 
          RowBox[{"a", "*", "B"}]}], ")"}], "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cosh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sinh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", "\n", "    ", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}], "+", 
          RowBox[{"c", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}], ")"}]}], ",", "\n", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", "*", "A"}], "-", 
              RowBox[{"b", "*", "B"}], "+", 
              RowBox[{"c", "*", "C"}]}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"n", "+", "2"}], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", "*", "A"}], "-", 
              RowBox[{"a", "*", "B"}]}], ")"}], "*", 
            RowBox[{"Cosh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"n", "+", "2"}], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", "*", "C"}], "-", 
              RowBox[{"c", "*", "A"}]}], ")"}], "*", 
            RowBox[{"Sinh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "*", "\n", 
         "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"Cosh", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"Sinh", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "B", ",", 
        "C"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9, 
   3.498431175169325*^9, 3.4984315237831373`*^9, 3.4984318251464663`*^9, 
   3.498431987628351*^9, 3.4984321755026813`*^9, 3.49843232278254*^9, {
   3.498432445679556*^9, 3.498432459017579*^9}, {3.498432698712*^9, 
   3.4984326997104015`*^9}, 3.4984327838257494`*^9, {3.4984334339128923`*^9, 
   3.498433453646927*^9}, {3.4984335361242714`*^9, 3.4984335398058777`*^9}, 
   3.4984336840905313`*^9, {3.4984349595179725`*^9, 3.498434974540799*^9}, {
   3.5154388005433226`*^9, 3.515438836453373*^9}, {3.5154391294837837`*^9, 
   3.5154391315937862`*^9}, {3.5154392596339655`*^9, 3.515439261823969*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: G&R ",
 "2.451.1",
 " with  ",
 Cell[BoxData[
  RowBox[{"B", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9, 3.498432181820692*^9, {
   3.4984323991446743`*^9, 3.4984324154623027`*^9}, 3.498432451841566*^9, {
   3.4984932863136544`*^9, 3.4984932883104577`*^9}, {3.498493319136112*^9, 
   3.498493325064122*^9}, 3.498493566616947*^9, 3.515436508420114*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "*", "C"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", "C"}], "-", 
           RowBox[{"c", "*", "A"}]}], ")"}], "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "-", 
        RowBox[{"b", "*", "A", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cosh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sinh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", "\n", "    ", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}], "+", 
          RowBox[{"c", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}], ")"}]}], ",", "\n", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", "*", "A"}], "+", 
              RowBox[{"c", "*", "C"}]}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"n", "+", "2"}], ")"}], "*", "b", "*", "A", "*", 
            RowBox[{"Cosh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"n", "+", "2"}], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", "*", "C"}], "-", 
              RowBox[{"c", "*", "A"}]}], ")"}], "*", 
            RowBox[{"Sinh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "*", "\n", 
         "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"Cosh", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"Sinh", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9, 
   3.498431175169325*^9, 3.4984315237831373`*^9, 3.4984318251464663`*^9, 
   3.498431987628351*^9, 3.4984321755026813`*^9, 3.49843232278254*^9, {
   3.498432445679556*^9, 3.498432459017579*^9}, {3.498432698712*^9, 
   3.4984326997104015`*^9}, {3.5154359572039795`*^9, 
   3.5154359733812084`*^9}, {3.515436121285068*^9, 3.515436153077924*^9}, {
   3.5154363496538687`*^9, 3.5154363610574894`*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: G&R ",
 "2.451.1",
 " with  ",
 Cell[BoxData[
  RowBox[{"C", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9, 3.498432181820692*^9, {
   3.4984323991446743`*^9, 3.4984324154623027`*^9}, 3.498432451841566*^9, {
   3.4984932863136544`*^9, 3.4984932883104577`*^9}, {3.498493319136112*^9, 
   3.498493325064122*^9}, 3.498493566616947*^9, 3.515436508420114*^9, 
   3.515441897647659*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c", "*", "B"}], "+", 
       RowBox[{"c", "*", "A", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "*", "A"}], "-", 
          RowBox[{"a", "*", "B"}]}], ")"}], "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cosh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sinh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", "\n", "    ", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}], "+", 
          RowBox[{"c", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}], ")"}]}], ",", "\n", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", "*", "A"}], "-", 
              RowBox[{"b", "*", "B"}]}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"n", "+", "2"}], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", "*", "A"}], "-", 
              RowBox[{"a", "*", "B"}]}], ")"}], "*", 
            RowBox[{"Cosh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"n", "+", "2"}], ")"}], "*", "c", "*", "A", "*", 
            RowBox[{"Sinh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "*", "\n", 
         "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"Cosh", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"Sinh", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "B"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9, 
   3.498431175169325*^9, 3.4984315237831373`*^9, 3.4984318251464663`*^9, 
   3.498431987628351*^9, 3.4984321755026813`*^9, 3.49843232278254*^9, {
   3.498432445679556*^9, 3.498432459017579*^9}, {3.498432698712*^9, 
   3.4984326997104015`*^9}, {3.5154359572039795`*^9, 
   3.5154359733812084`*^9}, {3.515436121285068*^9, 3.515436153077924*^9}, {
   3.5154363496538687`*^9, 3.5154363610574894`*^9}, 3.5154418958376565`*^9, {
   3.5154426557987204`*^9, 3.5154426652187333`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.451.1 inverted", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9, 3.498432181820692*^9, {
   3.4984323991446743`*^9, 3.4984324154623027`*^9}, 3.498432451841566*^9, 
   3.49843515735752*^9, 3.5154367451004453`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9, {3.4984155639236603`*^9, 
   3.4984155645936613`*^9}, {3.4984168250854263`*^9, 3.498416828835431*^9}, {
   3.4984176812066245`*^9, 3.498417690706638*^9}, {3.4984314419453936`*^9, 
   3.4984314738318496`*^9}, 3.49843175923075*^9, {3.4984320994837475`*^9, 
   3.4984321010281506`*^9}, {3.4984322552188215`*^9, 
   3.4984322841256723`*^9}, {3.4984323834198465`*^9, 
   3.4984323866490517`*^9}, {3.498432480654817*^9, 3.498432493134839*^9}, {
   3.4984351727703466`*^9, 3.498435175422352*^9}, {3.498435264030507*^9, 
   3.498435269162916*^9}, {3.515442927969101*^9, 3.5154429288291025`*^9}, {
   3.5154430057892103`*^9, 3.5154430057892103`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"C", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "B"}], " ", "c"}], "+", 
          RowBox[{"b", " ", "C"}], "+", 
          RowBox[{"a", " ", "C", " ", 
           RowBox[{"Cosh", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
          RowBox[{"a", " ", "B", " ", 
           RowBox[{"Sinh", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Cosh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", " ", 
            RowBox[{"Sinh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], 
       RowBox[{"a", " ", "e", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "B"}], "-", 
           RowBox[{"c", " ", "C"}]}], ")"}], " ", "n"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "A", " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "B", " ", "n"}], "-", 
           RowBox[{"c", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", " ", "C"}], "-", 
              RowBox[{"c", " ", "B"}]}], ")"}], " ", "n"}], "+", 
           RowBox[{"a", " ", "b", " ", "A", 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "C", " ", "n"}], "-", 
           RowBox[{"b", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", " ", "C"}], "-", 
              RowBox[{"c", " ", "B"}]}], ")"}], " ", "n"}], "+", 
           RowBox[{"a", " ", "c", " ", "A", 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "\[CenterDot]", 
      "\[IndentingNewLine]", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Cosh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", " ", 
          RowBox[{"Sinh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "-", "1"}]]}], 
     RowBox[{"\[DifferentialD]", "x", " "}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9, {3.4984157332238975`*^9, 3.49841574918392*^9}, {
   3.4984167480753183`*^9, 3.4984167773253593`*^9}, {3.4984192598788347`*^9, 
   3.4984192736088543`*^9}, {3.4984317085306616`*^9, 
   3.4984317224926863`*^9}, {3.4984318598565273`*^9, 
   3.4984319106266165`*^9}, {3.498432204378332*^9, 3.4984322333163824`*^9}, {
   3.4984323510497894`*^9, 3.4984323629994106`*^9}, 3.4984325452077303`*^9, 
   3.4984328232938185`*^9, 3.4984333096306734`*^9, {3.4984334826161776`*^9, 
   3.4984334886845884`*^9}, 3.4984335853579583`*^9, 3.4984340846680355`*^9, 
   3.498435053898138*^9, 3.4984352319256506`*^9, {3.4984353475374537`*^9, 
   3.4984353561018686`*^9}, {3.5154394773742704`*^9, 
   3.5154394937042933`*^9}, {3.5154409383063154`*^9, 3.515440982246377*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "B"}], "*", "c"}], "+", 
       RowBox[{"b", "*", "C"}], "+", 
       RowBox[{"a", "*", "C", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
       RowBox[{"a", "*", "B", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cosh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sinh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "e", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], ",", "\n", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", "*", "B"}], "-", 
              RowBox[{"c", "*", "C"}]}], ")"}], "*", "n"}], " ", "+", " ", 
           RowBox[{
            RowBox[{"a", "^", "2"}], "*", "A", "*", 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}], " ", "+", " ", "\n", 
           "        ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"a", "^", "2"}], "*", "B", "*", "n"}], " ", "-", " ", 
              RowBox[{"c", "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"b", "*", "C"}], "-", 
                 RowBox[{"c", "*", "B"}]}], ")"}], "*", "n"}], " ", "+", " ", 
              RowBox[{"a", "*", "b", "*", "A", "*", 
               RowBox[{"(", 
                RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], "*", 
            RowBox[{"Cosh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], " ", "+", " ", "\n", 
           "        ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"a", "^", "2"}], "*", "C", "*", "n"}], " ", "-", " ", 
              RowBox[{"b", "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"b", "*", "C"}], "-", 
                 RowBox[{"c", "*", "B"}]}], ")"}], "*", "n"}], " ", "+", " ", 
              RowBox[{"a", "*", "c", "*", "A", "*", 
               RowBox[{"(", 
                RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], "*", 
            RowBox[{"Sinh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "*", "\n", 
         "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"Cosh", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"Sinh", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", " ", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "B", ",", 
        "C"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9, 
   3.498431175169325*^9, 3.4984315237831373`*^9, 3.4984318251464663`*^9, 
   3.498431987628351*^9, 3.4984321755026813`*^9, 3.49843232278254*^9, {
   3.498432445679556*^9, 3.498432459017579*^9}, {3.498432698712*^9, 
   3.4984326997104015`*^9}, 3.4984327838257494`*^9, {3.4984334339128923`*^9, 
   3.498433453646927*^9}, {3.4984335361242714`*^9, 3.4984335398058777`*^9}, 
   3.4984336840905313`*^9, {3.4984349595179725`*^9, 3.498434974540799*^9}, 
   3.498435149370306*^9, {3.4984351832535653`*^9, 3.49843518598357*^9}, {
   3.5154410494564714`*^9, 3.51544110552655*^9}, {3.5154411587866244`*^9, 
   3.5154411601166267`*^9}, {3.515442895609056*^9, 3.5154429088990746`*^9}, {
   3.515442997909199*^9, 3.5154429984091997`*^9}, 3.5157087884758654`*^9},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: G&R 2.451.1 inverted with ",
 Cell[BoxData[
  RowBox[{"B", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9, 3.498432181820692*^9, {
   3.4984323991446743`*^9, 3.4984324154623027`*^9}, 3.498432451841566*^9, 
   3.49843515735752*^9, 3.5154367451004453`*^9, {3.515443177589451*^9, 
   3.515443183659459*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", "*", "C"}], "+", 
       RowBox[{"a", "*", "C", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cosh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sinh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "e", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], ",", "\n", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "a"}], "*", "c", "*", "C", "*", "n"}], "+", 
           RowBox[{
            RowBox[{"a", "^", "2"}], "*", "A", "*", 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}], "-", 
           RowBox[{"b", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"c", "*", "C", "*", "n"}], "-", 
              RowBox[{"a", "*", "A", "*", 
               RowBox[{"(", 
                RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], "*", 
            RowBox[{"Cosh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"a", "^", "2"}], "*", "C", "*", "n"}], "-", 
              RowBox[{
               RowBox[{"b", "^", "2"}], "*", "C", "*", "n"}], "+", 
              RowBox[{"a", "*", "c", "*", "A", "*", 
               RowBox[{"(", 
                RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], "*", 
            RowBox[{"Sinh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "*", "\n", 
         "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"Cosh", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"Sinh", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", " ", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9, 
   3.498431175169325*^9, 3.4984315237831373`*^9, 3.4984318251464663`*^9, 
   3.498431987628351*^9, 3.4984321755026813`*^9, 3.49843232278254*^9, {
   3.498432445679556*^9, 3.498432459017579*^9}, {3.498432698712*^9, 
   3.4984326997104015`*^9}, 3.4984327838257494`*^9, {3.4984334339128923`*^9, 
   3.498433453646927*^9}, {3.4984335361242714`*^9, 3.4984335398058777`*^9}, 
   3.4984336840905313`*^9, {3.4984349595179725`*^9, 3.498434974540799*^9}, 
   3.498435149370306*^9, {3.4984351832535653`*^9, 3.49843518598357*^9}, {
   3.5154410494564714`*^9, 3.51544110552655*^9}, {3.5154411587866244`*^9, 
   3.5154411601166267`*^9}, {3.5154427530288563`*^9, 3.515442877869031*^9}, {
   3.515443001559204*^9, 3.5154430019392047`*^9}, {3.5154430669692955`*^9, 
   3.5154430734093046`*^9}, {3.5154431082793536`*^9, 3.515443120819371*^9}, {
   3.5154434046597686`*^9, 3.5154434102097764`*^9}, 3.5157087908470697`*^9},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: G&R 2.451.1 inverted with ",
 Cell[BoxData[
  RowBox[{"C", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9, 3.498432181820692*^9, {
   3.4984323991446743`*^9, 3.4984324154623027`*^9}, 3.498432451841566*^9, 
   3.49843515735752*^9, 3.5154367451004453`*^9, {3.515443177589451*^9, 
   3.515443183659459*^9}, 3.5154435945100346`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "B"}], "*", "c"}], "+", 
       RowBox[{"a", "*", "B", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cosh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sinh", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "e", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], ",", "\n", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", "b", "*", "B", "*", "n"}], "+", 
           RowBox[{
            RowBox[{"a", "^", "2"}], "*", "A", "*", 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"a", "^", "2"}], "*", "B", "*", "n"}], "+", 
              RowBox[{
               RowBox[{"c", "^", "2"}], "*", "B", "*", "n"}], "+", 
              RowBox[{"a", "*", "b", "*", "A", "*", 
               RowBox[{"(", 
                RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], "*", 
            RowBox[{"Cosh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", "*", "B", "*", "n"}], "+", 
              RowBox[{"a", "*", "A", "*", 
               RowBox[{"(", 
                RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], "*", 
            RowBox[{"Sinh", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "*", "\n", 
         "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"Cosh", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"Sinh", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", " ", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "B"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9, 
   3.498431175169325*^9, 3.4984315237831373`*^9, 3.4984318251464663`*^9, 
   3.498431987628351*^9, 3.4984321755026813`*^9, 3.49843232278254*^9, {
   3.498432445679556*^9, 3.498432459017579*^9}, {3.498432698712*^9, 
   3.4984326997104015`*^9}, 3.4984327838257494`*^9, {3.4984334339128923`*^9, 
   3.498433453646927*^9}, {3.4984335361242714`*^9, 3.4984335398058777`*^9}, 
   3.4984336840905313`*^9, {3.4984349595179725`*^9, 3.498434974540799*^9}, 
   3.498435149370306*^9, {3.4984351832535653`*^9, 3.49843518598357*^9}, {
   3.5154410494564714`*^9, 3.51544110552655*^9}, {3.5154411587866244`*^9, 
   3.5154411601166267`*^9}, {3.515442895609056*^9, 3.5154429088990746`*^9}, {
   3.515442997909199*^9, 3.5154429984091997`*^9}, {3.515443211449498*^9, 
   3.5154433490096908`*^9}, {3.5154433810597353`*^9, 
   3.5154433823997374`*^9}, {3.515443418989789*^9, 3.515443444899825*^9}, 
   3.515443555069979*^9, 3.5157087928126726`*^9},
 Background->GrayLevel[0.85]]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Rules for Rational Functions of Hyperbolic Sines and Cosines", 
   None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.399999976158142,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 1542, 33, 118, "Title"],
Cell[2112, 57, 1194, 22, 713, "Subsubsection"],
Cell[3309, 81, 1754, 43, 1250, "Subsubtitle"],
Cell[5066, 126, 771, 11, 692, "Subsubsection"],
Cell[5840, 139, 1663, 47, 2113, "Code"],
Cell[7506, 188, 89, 2, 692, "Subsubsection"],
Cell[7598, 192, 1252, 23, 510, "Subsubsection"],
Cell[8853, 217, 2307, 53, 1282, "Subsubtitle"],
Cell[11163, 272, 771, 11, 692, "Subsubsection"],
Cell[11937, 285, 1791, 51, 2113, "Code"],
Cell[13731, 338, 89, 2, 692, "Subsubsection"],
Cell[13823, 342, 466, 7, 475, "Subsubsection"],
Cell[14292, 351, 508, 7, 475, "Subsubsection"],
Cell[14803, 360, 1639, 47, 893, "Subsubsection"],
Cell[16445, 409, 690, 14, 510, "Subsubsection"],
Cell[17138, 425, 1651, 32, 771, "Subsubsection"],
Cell[18792, 459, 2677, 60, 2182, "Subsubtitle"],
Cell[21472, 521, 771, 11, 692, "Subsubsection"],
Cell[22246, 534, 2632, 70, 2113, "Code"],
Cell[24881, 606, 89, 2, 692, "Subsubsection"],
Cell[24973, 610, 551, 8, 475, "Subsubsection"],
Cell[25527, 620, 1703, 32, 771, "Subsubsection"],
Cell[27233, 654, 3570, 88, 3564, "Subsubtitle"],
Cell[30806, 744, 771, 11, 692, "Subsubsection"],
Cell[31580, 757, 3400, 95, 2634, "Code"],
Cell[34983, 854, 89, 2, 692, "Subsubsection"],
Cell[35075, 858, 551, 8, 475, "Subsubsection"],
Cell[35629, 868, 1717, 32, 692, "Subsubsection"],
Cell[37349, 902, 3924, 98, 3793, "Subsubtitle"],
Cell[41276, 1002, 771, 11, 692, "Subsubsection"],
Cell[42050, 1015, 3799, 107, 2634, "Code"],
Cell[45852, 1124, 44, 1, 51, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[45933, 1130, 1922, 44, 92, "Title"],
Cell[47858, 1176, 400, 6, 35, "Subsubsection"],
Cell[48261, 1184, 1570, 47, 42, "Subsubsection"],
Cell[49834, 1233, 1588, 32, 35, "Subsubsection"],
Cell[51425, 1267, 4980, 136, 215, "Subsubtitle"],
Cell[56408, 1405, 771, 11, 35, "Subsubsection"],
Cell[57182, 1418, 5319, 154, 154, "Code"],
Cell[62504, 1574, 89, 2, 35, "Subsubsection"],
Cell[62596, 1578, 400, 6, 25, "Subsubsection"],
Cell[62999, 1586, 1536, 46, 47, "Subsubsection"],
Cell[64538, 1634, 1474, 27, 35, "Subsubsection"],
Cell[66015, 1663, 3717, 97, 126, "Subsubtitle"],
Cell[69735, 1762, 771, 11, 35, "Subsubsection"],
Cell[70509, 1775, 4207, 123, 179, "Code"],
Cell[74719, 1900, 89, 2, 35, "Subsubsection"],
Cell[74811, 1904, 400, 6, 25, "Subsubsection"],
Cell[75214, 1912, 1534, 45, 47, "Subsubsection"],
Cell[76751, 1959, 1476, 27, 35, "Subsubsection"],
Cell[78230, 1988, 3743, 97, 126, "Subsubtitle"],
Cell[81976, 2087, 771, 11, 35, "Subsubsection"],
Cell[82750, 2100, 4204, 122, 179, "Code"],
Cell[86957, 2224, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[87038, 2230, 1636, 34, 89, "Title"],
Cell[88677, 2266, 515, 7, 1355, "Subsubsection"],
Cell[89195, 2275, 1168, 21, 998, "Subsubsection"],
Cell[90366, 2298, 1712, 40, 2448, "Subsubtitle"],
Cell[92081, 2340, 771, 11, 1355, "Subsubsection"],
Cell[92855, 2353, 1558, 43, 4141, "Code"],
Cell[94416, 2398, 89, 2, 1355, "Subsubsection"],
Cell[94508, 2402, 513, 7, 929, "Subsubsection"],
Cell[95024, 2411, 1216, 21, 998, "Subsubsection"],
Cell[96243, 2434, 1759, 41, 2448, "Subsubtitle"],
Cell[98005, 2477, 771, 11, 1355, "Subsubsection"],
Cell[98779, 2490, 1614, 45, 4141, "Code"],
Cell[100396, 2537, 89, 2, 1355, "Subsubsection"],
Cell[100488, 2541, 440, 6, 929, "Subsubsection"],
Cell[100931, 2549, 1384, 25, 998, "Subsubsection"],
Cell[102318, 2576, 2447, 55, 2448, "Subsubtitle"],
Cell[104768, 2633, 771, 11, 1355, "Subsubsection"],
Cell[105542, 2646, 2068, 57, 4141, "Code"],
Cell[107613, 2705, 89, 2, 1355, "Subsubsection"],
Cell[107705, 2709, 467, 7, 929, "Subsubsection"],
Cell[108175, 2718, 1646, 32, 1355, "Subsubsection"],
Cell[109824, 2752, 2598, 60, 3564, "Subsubtitle"],
Cell[112425, 2814, 771, 11, 1355, "Subsubsection"],
Cell[113199, 2827, 2513, 71, 4141, "Code"],
Cell[115715, 2900, 89, 2, 1355, "Subsubsection"],
Cell[115807, 2904, 501, 7, 929, "Subsubsection"],
Cell[116311, 2913, 1746, 34, 1355, "Subsubsection"],
Cell[118060, 2949, 2617, 61, 3564, "Subsubtitle"],
Cell[120680, 3012, 771, 11, 1355, "Subsubsection"],
Cell[121454, 3025, 2572, 73, 4141, "Code"],
Cell[124029, 3100, 44, 1, 99, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[124110, 3106, 1556, 33, 80, "Title"],
Cell[125669, 3141, 1252, 24, 998, "Subsubsection"],
Cell[126924, 3167, 2069, 52, 1923, "Subsubtitle"],
Cell[128996, 3221, 771, 11, 968, "Subsubsection"],
Cell[129770, 3234, 2007, 58, 2958, "Code"],
Cell[131780, 3294, 89, 2, 968, "Subsubsection"],
Cell[131872, 3298, 405, 6, 664, "Subsubsection"],
Cell[132280, 3306, 1076, 29, 1079, "Subsubsection"],
Cell[133359, 3337, 1632, 33, 1230, "Subsubsection"],
Cell[134994, 3372, 2378, 53, 2325, "Subsubtitle"],
Cell[137375, 3427, 771, 11, 968, "Subsubsection"],
Cell[138149, 3440, 2167, 58, 2958, "Code"],
Cell[140319, 3500, 89, 2, 968, "Subsubsection"],
Cell[140411, 3504, 405, 6, 664, "Subsubsection"],
Cell[140819, 3512, 1076, 29, 1079, "Subsubsection"],
Cell[141898, 3543, 1697, 35, 1397, "Subsubsection"],
Cell[143598, 3580, 3670, 90, 5121, "Subsubtitle"],
Cell[147271, 3672, 771, 11, 968, "Subsubsection"],
Cell[148045, 3685, 3630, 101, 4401, "Code"],
Cell[151678, 3788, 44, 1, 71, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[151759, 3794, 1632, 34, 99, "Title"],
Cell[153394, 3830, 606, 8, 968, "Subsubsection"],
Cell[154003, 3840, 1223, 31, 1079, "Subsubsection"],
Cell[155229, 3873, 1413, 27, 1079, "Subsubsection"],
Cell[156645, 3902, 2168, 51, 2882, "Subsubtitle"],
Cell[158816, 3955, 771, 11, 968, "Subsubsection"],
Cell[159590, 3968, 2073, 55, 2958, "Code"],
Cell[161666, 4025, 89, 2, 968, "Subsubsection"],
Cell[161758, 4029, 523, 9, 664, "Subsubsection"],
Cell[162284, 4040, 1350, 35, 2315, "Subsubsection"],
Cell[163637, 4077, 1223, 31, 1079, "Subsubsection"],
Cell[164863, 4110, 1732, 37, 1397, "Subsubsection"],
Cell[166598, 4149, 3347, 86, 5584, "Subsubtitle"],
Cell[169948, 4237, 771, 11, 968, "Subsubsection"],
Cell[170722, 4250, 3627, 103, 4401, "Code"],
Cell[174352, 4355, 44, 1, 71, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[174433, 4361, 1570, 33, 80, "Title"],
Cell[176006, 4396, 708, 17, 1955, "Subsubsection"],
Cell[176717, 4415, 1524, 28, 1397, "Subsubsection"],
Cell[178244, 4445, 3493, 85, 9336, "Subsubtitle"],
Cell[181740, 4532, 771, 11, 1896, "Subsubsection"],
Cell[182514, 4545, 3240, 90, 7225, "Code"],
Cell[185757, 4637, 89, 2, 1896, "Subsubsection"],
Cell[185849, 4641, 595, 8, 1300, "Subsubsection"],
Cell[186447, 4651, 1589, 29, 1896, "Subsubsection"],
Cell[188039, 4682, 4501, 110, 9336, "Subsubtitle"],
Cell[192543, 4794, 771, 11, 1896, "Subsubsection"],
Cell[193317, 4807, 4199, 114, 8625, "Code"],
Cell[197519, 4923, 44, 1, 138, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[197600, 4929, 1679, 35, 89, "Title"],
Cell[199282, 4966, 1491, 29, 1955, "Subsubsection"],
Cell[200776, 4997, 3569, 89, 9546, "Subsubtitle"],
Cell[204348, 5088, 771, 11, 1896, "Subsubsection"],
Cell[205122, 5101, 3462, 98, 7225, "Code"],
Cell[208587, 5201, 89, 2, 1896, "Subsubsection"],
Cell[208679, 5205, 680, 15, 1397, "Subsubsection"],
Cell[209362, 5222, 1364, 25, 1397, "Subsubsection"],
Cell[210729, 5249, 3234, 82, 7090, "Subsubtitle"],
Cell[213966, 5333, 771, 11, 1896, "Subsubsection"],
Cell[214740, 5346, 3079, 89, 7225, "Code"],
Cell[217822, 5437, 89, 2, 1896, "Subsubsection"],
Cell[217914, 5441, 857, 18, 2020, "Subsubsection"],
Cell[218774, 5461, 1364, 25, 1397, "Subsubsection"],
Cell[220141, 5488, 3364, 86, 7964, "Subsubtitle"],
Cell[223508, 5576, 771, 11, 1896, "Subsubsection"],
Cell[224282, 5589, 3348, 94, 7225, "Code"],
Cell[227633, 5685, 89, 2, 1896, "Subsubsection"],
Cell[227725, 5689, 715, 10, 1300, "Subsubsection"],
Cell[228443, 5701, 1763, 35, 2113, "Subsubsection"],
Cell[230209, 5738, 4308, 113, 10406, "Subsubtitle"],
Cell[234520, 5853, 771, 11, 1896, "Subsubsection"],
Cell[235294, 5866, 4555, 127, 8625, "Code"],
Cell[239852, 5995, 44, 1, 138, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[239933, 6001, 2126, 47, 80, "Title"],
Cell[242062, 6050, 970, 13, 48, "Subsubsection"],
Cell[243035, 6065, 1649, 28, 36, "Subsubsection"],
Cell[244687, 6095, 4218, 108, 176, "Subsubtitle"],
Cell[248908, 6205, 771, 11, 48, "Subsubsection"],
Cell[249682, 6218, 4307, 116, 180, "Code"],
Cell[253992, 6336, 1062, 18, 50, "Subsubsection"],
Cell[255057, 6356, 3869, 100, 180, "Code"],
Cell[258929, 6458, 1162, 19, 50, "Subsubsection"],
Cell[260094, 6479, 4000, 102, 180, "Code"],
Cell[264097, 6583, 89, 2, 48, "Subsubsection"],
Cell[264189, 6587, 1282, 30, 40, "Subsubsection"],
Cell[265474, 6619, 1976, 41, 48, "Subsubsection"],
Cell[267453, 6662, 3231, 79, 93, "Subsubtitle"],
Cell[270687, 6743, 771, 11, 48, "Subsubsection"],
Cell[271461, 6756, 3584, 97, 145, "Code"],
Cell[275048, 6855, 1273, 29, 54, "Subsubsection"],
Cell[276324, 6886, 3058, 81, 145, "Code"],
Cell[279385, 6969, 1371, 30, 54, "Subsubsection"],
Cell[280759, 7001, 3113, 81, 145, "Code"],
Cell[283875, 7084, 89, 2, 48, "Subsubsection"],
Cell[283967, 7088, 585, 8, 34, "Subsubsection"],
Cell[284555, 7098, 1963, 40, 48, "Subsubsection"],
Cell[286521, 7140, 3894, 105, 267, "Subsubtitle"],
Cell[290418, 7247, 771, 11, 48, "Subsubsection"],
Cell[291192, 7260, 4656, 131, 180, "Code"],
Cell[295851, 7393, 713, 15, 69, "Subsubsection"],
Cell[296567, 7410, 3851, 109, 251, "Code"],
Cell[300421, 7521, 737, 15, 69, "Subsubsection"],
Cell[301161, 7538, 3910, 109, 351, "Code"],
Cell[305074, 7649, 89, 2, 181, "Subsubsection"],
Cell[305166, 7653, 1125, 26, 134, "Subsubsection"],
Cell[306294, 7681, 1916, 36, 181, "Subsubsection"],
Cell[308213, 7719, 3477, 86, 354, "Subsubtitle"],
Cell[311693, 7807, 771, 11, 181, "Subsubsection"],
Cell[312467, 7820, 3430, 95, 687, "Code"],
Cell[315900, 7917, 1222, 29, 187, "Subsubsection"],
Cell[317125, 7948, 2945, 83, 551, "Code"],
Cell[320073, 8033, 1298, 30, 187, "Subsubsection"],
Cell[321374, 8065, 3002, 84, 551, "Code"],
Cell[324379, 8151, 89, 2, 181, "Subsubsection"],
Cell[324471, 8155, 784, 17, 134, "Subsubsection"],
Cell[325258, 8174, 1889, 36, 181, "Subsubsection"],
Cell[327150, 8212, 4265, 110, 674, "Subsubtitle"],
Cell[331418, 8324, 771, 11, 181, "Subsubsection"],
Cell[332192, 8337, 4397, 124, 820, "Code"],
Cell[336592, 8463, 940, 21, 187, "Subsubsection"],
Cell[337535, 8486, 3857, 110, 687, "Code"],
Cell[341395, 8598, 962, 21, 187, "Subsubsection"],
Cell[342360, 8621, 3921, 112, 687, "Code"],
Cell[346284, 8735, 89, 2, 181, "Subsubsection"],
Cell[346376, 8739, 722, 10, 125, "Subsubsection"],
Cell[347101, 8751, 1511, 41, 193, "Subsubsection"],
Cell[348615, 8794, 2340, 47, 202, "Subsubsection"],
Cell[350958, 8843, 3627, 88, 569, "Subsubtitle"],
Cell[354588, 8933, 771, 11, 181, "Subsubsection"],
Cell[355362, 8946, 4241, 111, 687, "Code"],
Cell[359606, 9059, 89, 2, 181, "Subsubsection"],
Cell[359698, 9063, 689, 10, 125, "Subsubsection"],
Cell[360390, 9075, 1865, 35, 181, "Subsubsection"],
Cell[362258, 9112, 5605, 149, 988, "Subsubtitle"],
Cell[367866, 9263, 771, 11, 181, "Subsubsection"],
Cell[368640, 9276, 6006, 164, 1090, "Code"],
Cell[374649, 9442, 885, 17, 187, "Subsubsection"],
Cell[375537, 9461, 5365, 149, 1090, "Code"],
Cell[380905, 9612, 911, 18, 50, "Subsubsection"],
Cell[381819, 9632, 5407, 149, 285, "Code"],
Cell[387229, 9783, 89, 2, 48, "Subsubsection"],
Cell[387321, 9787, 719, 10, 34, "Subsubsection"],
Cell[388043, 9799, 1920, 34, 48, "Subsubsection"],
Cell[389966, 9835, 5667, 146, 278, "Subsubtitle"],
Cell[395636, 9983, 771, 11, 48, "Subsubsection"],
Cell[396410, 9996, 6186, 160, 320, "Code"],
Cell[402599, 10158, 834, 15, 50, "Subsubsection"],
Cell[403436, 10175, 5398, 138, 250, "Code"],
Cell[408837, 10315, 858, 15, 50, "Subsubsection"],
Cell[409698, 10332, 5416, 139, 250, "Code"]
}, Closed]]
}
]
*)

(* End of internal cache information *)
