(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     66535,       1591]
NotebookOptionsPosition[     62707,       1485]
NotebookOutlinePosition[     63837,       1524]
CellTagsIndexPosition[     63794,       1521]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ArcSech", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, 3.495078733536543*^9, 
   3.4951361046771145`*^9, 3.4951381489899764`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: CRC 591', A&S 4.6.47'", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9, 3.4941723607787027`*^9, 3.4941724567488375`*^9, 
   3.494172696119172*^9, 3.4950807812494097`*^9, 3.4951361632971964`*^9, 
   3.4951382679001427`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"ArcSech", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], " ", 
        RowBox[{"ArcSech", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}]}], "b"]}]}]}]}], "-", 
  RowBox[{
   FractionBox["2", "b"], " ", 
   RowBox[{"ArcTan", "[", 
    SqrtBox[
     FractionBox[
      RowBox[{"1", "-", "a", "-", 
       RowBox[{"b", " ", "x"}]}], 
      RowBox[{"1", "+", "a", "+", 
       RowBox[{"b", " ", "x"}]}]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495078733546543*^9, 3.495078733546543*^9}, {3.4950807901794224`*^9, 
   3.4950807944994287`*^9}, {3.4951361077071185`*^9, 3.4951361077171183`*^9}, 
   3.495136231147291*^9, {3.4951381489899764`*^9, 3.4951381489899764`*^9}, 
   3.4951383188302145`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"ArcSech", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", "x_"}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"ArcSech", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "/", "b"}]}], " ", "-", " ", 
    RowBox[{"2", "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "a", "-", 
           RowBox[{"b", "*", "x"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "+", "a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], "]"}], "/", "b"}]}]}], 
   " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.495078733546543*^9, 3.495078733546543*^9}, 3.4950807641093855`*^9, {
   3.4951361077271185`*^9, 3.4951361077271185`*^9}, 3.4951361778072166`*^9, {
   3.4951381489899764`*^9, 3.4951381489899764`*^9}, 3.4951382575401287`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"ArcSech", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, {3.494176335919876*^9, 
   3.494176356549905*^9}, 3.4950787336865435`*^9, 3.495136107887119*^9, 
   3.495138148999976*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.494173557270378*^9, {3.494176834460574*^9, 
   3.4941768354805756`*^9}, 3.495137570079166*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.4951375893491926`*^9, 3.495137619409235*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"ArcSech", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["a", "b"]}], "+", 
          FractionBox["x", "b"]}], ")"}], "m"], " ", 
       RowBox[{"ArcSech", "[", "x", "]"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, 
   3.494173593500429*^9, 3.494173663970527*^9, 3.4941739141808777`*^9, 
   3.494174420251586*^9, 3.494176720380414*^9, {3.4941767533004603`*^9, 
   3.4941767774904943`*^9}, {3.495078733696543*^9, 3.495078733696543*^9}, {
   3.495081754180772*^9, 3.4950817627807837`*^9}, {3.4951361078971186`*^9, 
   3.495136107907119*^9}, {3.495137296728783*^9, 3.495137299458787*^9}, {
   3.495137638459262*^9, 3.4951376782193174`*^9}, {3.4951381490099764`*^9, 
   3.4951381490099764`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"ArcSech", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "b"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "a"}], "/", "b"}], "+", 
             RowBox[{"x", "/", "b"}]}], ")"}], "^", "m"}], "*", 
          RowBox[{"ArcSech", "[", "x", "]"}]}], ",", "x"}], "]"}], ",", "x", 
       ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.4941735463003626`*^9, 3.494173866490811*^9, 3.494174071121097*^9, 
   3.494176683980363*^9, 3.4949886304357595`*^9, 3.4949909267385945`*^9, {
   3.495078733696543*^9, 3.495078733696543*^9}, 3.495082294241528*^9, {
   3.495136107917119*^9, 3.495136107917119*^9}, 3.4951372690987444`*^9, 
   3.4951375590891504`*^9, {3.4951381490099764`*^9, 3.4951381490099764`*^9}, 
   3.4951383811203012`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Reference: CRC 593', A&S 4.6.58'", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9, 3.4941723607787027`*^9, 3.4941724567488375`*^9, 
   3.494172696119172*^9, 3.4941735657303896`*^9, 3.494176826510563*^9, 
   3.4950822724214973`*^9, 3.4951372505387187`*^9, 3.495138407900339*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.494173557270378*^9, {3.494176834460574*^9, 
   3.4941768354805756`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"ArcSech", "[", "x", "]"}]}], "=", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SqrtBox[
       FractionBox["1", 
        RowBox[{"1", "+", "x"}]]], " ", 
      SqrtBox[
       RowBox[{"1", "+", "x"}]]}], 
     RowBox[{"x", " ", 
      SqrtBox[
       RowBox[{"1", "+", "x"}]], " ", 
      SqrtBox[
       RowBox[{"1", "-", "x"}]]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.494173557270378*^9, {3.494176834460574*^9, 
   3.4941768354805756`*^9}, {3.495138737820801*^9, 3.495138763160836*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"(", 
     RowBox[{
      SqrtBox[
       FractionBox["1", 
        RowBox[{"1", "+", "a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "n"]}]}]]], " ", 
      SqrtBox[
       RowBox[{"1", "+", "a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}]]}], ")"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.494173557270378*^9, {3.494176834460574*^9, 
   3.4941768354805756`*^9}, {3.495138737820801*^9, 3.495138763160836*^9}, 
   3.4951388483109555`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"ArcSech", "[", 
     RowBox[{"a", " ", "x"}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"ArcSech", "[", 
         RowBox[{"a", " ", "x"}], "]"}]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox["x", "m"], 
      RowBox[{
       SqrtBox[
        FractionBox[
         RowBox[{"1", "-", 
          RowBox[{"a", " ", "x"}]}], 
         RowBox[{"1", "+", 
          RowBox[{"a", " ", "x"}]}]]], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"a", " ", "x"}]}], ")"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, 
   3.494173593500429*^9, 3.494173663970527*^9, 3.4941739141808777`*^9, 
   3.494174420251586*^9, 3.494176720380414*^9, {3.4941767533004603`*^9, 
   3.4941767774904943`*^9}, {3.495078733696543*^9, 3.495078733696543*^9}, {
   3.495081754180772*^9, 3.4950817627807837`*^9}, {3.4951361078971186`*^9, 
   3.495136107907119*^9}, {3.495137296728783*^9, 3.495137299458787*^9}, {
   3.4951381490199766`*^9, 3.4951381490199766`*^9}, {3.495138554950545*^9, 
   3.4951385789405785`*^9}, {3.4951386237006407`*^9, 3.495138664460698*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"ArcSech", "[", 
      RowBox[{"a_.", "*", "x_"}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"ArcSech", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"a", "*", "x"}]}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"a", "*", "x"}]}], ")"}]}], "]"}], "*", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"a", "*", "x"}]}], ")"}]}], ")"}]}], ",", "x"}], "]"}]}],
      "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.4941735463003626`*^9, 3.494173866490811*^9, 3.494174071121097*^9, 
   3.494176683980363*^9, 3.4949886304357595`*^9, 3.4949909267385945`*^9, {
   3.495078733696543*^9, 3.495078733696543*^9}, 3.495082294241528*^9, {
   3.495136107917119*^9, 3.495136107917119*^9}, 3.4951372690987444`*^9, {
   3.4951381490199766`*^9, 3.4951381490199766`*^9}, 3.49513845849041*^9, 
   3.495138719320775*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ArcSech", "[", 
       RowBox[{"a_.", "*", 
        RowBox[{"x_", "^", "n_."}]}], "]"}], "/", "x_"}], ",", "x_Symbol"}], 
    "]"}], " ", ":=", "\n", 
   RowBox[{"(*", "   ", 
    RowBox[{
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ArcCosh", "[", 
         RowBox[{
          RowBox[{"1", "/", "a"}], "*", 
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{"-", "n"}], ")"}]}]}], "]"}], "/", "x"}], ",", "x"}], 
      "]"}], " ", "/;"}], " ", "*)"}], "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{
        RowBox[{"ArcSech", "[", 
         RowBox[{"a", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}], "^", "2"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "n"}], ")"}]}], " ", "-", " ", "\n", "  ", 
     RowBox[{
      RowBox[{"ArcSech", "[", 
       RowBox[{"a", "*", 
        RowBox[{"x", "^", "n"}]}], "]"}], "*", 
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"1", "+", 
         RowBox[{"E", "^", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "*", 
            RowBox[{"ArcSech", "[", 
             RowBox[{"a", "*", 
              RowBox[{"x", "^", "n"}]}], "]"}]}], ")"}]}]}], "]"}], "/", 
       "n"}]}], " ", "+", " ", "\n", "  ", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{"2", ",", 
        RowBox[{"-", 
         RowBox[{"E", "^", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "*", 
            RowBox[{"ArcSech", "[", 
             RowBox[{"a", "*", 
              RowBox[{"x", "^", "n"}]}], "]"}]}], ")"}]}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "n"}], ")"}]}]}], " ", "/;", "\n", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{
          RowBox[{"ArcSech", "[", 
           RowBox[{"a", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}], "^", "2"}]}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "n"}], ")"}]}], " ", "-", " ", "\n", "  ", 
       RowBox[{
        RowBox[{"ArcSech", "[", 
         RowBox[{"a", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}], "*", 
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"1", "+", 
           RowBox[{"1", "/", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"1", "/", 
                RowBox[{"(", 
                 RowBox[{"a", "*", 
                  RowBox[{"x", "^", "n"}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"Sqrt", "[", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", 
                  RowBox[{"1", "/", 
                   RowBox[{"(", 
                    RowBox[{"a", "*", 
                    RowBox[{"x", "^", "n"}]}], ")"}]}]}], "]"}], "*", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"1", "+", 
                  RowBox[{"1", "/", 
                   RowBox[{"(", 
                    RowBox[{"a", "*", 
                    RowBox[{"x", "^", "n"}]}], ")"}]}]}], "]"}]}]}], ")"}], 
             "^", "2"}]}]}], "]"}], "/", "n"}]}], " ", "+", " ", "\n", "  ", 
       RowBox[{
        RowBox[{"PolyLog", "[", 
         RowBox[{"2", ",", 
          RowBox[{
           RowBox[{"-", "1"}], "/", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"1", "/", 
               RowBox[{"(", 
                RowBox[{"a", "*", 
                 RowBox[{"x", "^", "n"}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{"1", "/", 
                  RowBox[{"(", 
                   RowBox[{"a", "*", 
                    RowBox[{"x", "^", "n"}]}], ")"}]}]}], "]"}], "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"1", "+", 
                 RowBox[{"1", "/", 
                  RowBox[{"(", 
                   RowBox[{"a", "*", 
                    RowBox[{"x", "^", "n"}]}], ")"}]}]}], "]"}]}]}], ")"}], 
            "^", "2"}]}]}], "]"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "n"}], ")"}]}]}], " ", "/;"}], " ", "*)"}], "\n", 
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "n"}], "}"}], ",", "x"}], "]"}]}]}], " ", 
  "*)"}]], "Code",
 CellChangeTimes->{
  3.49513610866712*^9, {3.4951377176193724`*^9, 3.495137721059377*^9}, {
   3.495138148999976*^9, 3.4951381490099764`*^9}, 3.495138354030264*^9}],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox[
    RowBox[{"ArcSech", "[", 
     FractionBox["c", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}]], "]"}], "m"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, {3.494176335919876*^9, 
   3.494176356549905*^9}, {3.4941768991306643`*^9, 3.4941769105806804`*^9}, {
   3.4941776449217086`*^9, 3.49417766022173*^9}, 3.4941785320029507`*^9, 
   3.4941787397900977`*^9, 3.4950787339465437`*^9, 3.49513610845712*^9, 
   3.4951381490199766`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation:  Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.494173557270378*^9, {3.494176834460574*^9, 
   3.4941768354805756`*^9}, 3.4941787608189344`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"ArcSech", "[", "z", "]"}], "=", 
   RowBox[{"ArcCosh", "[", 
    FractionBox["1", "z"], "]"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.494173557270378*^9, {3.494176834460574*^9, 
   3.4941768354805756`*^9}, {3.4941787608189344`*^9, 3.494178801550606*^9}, {
   3.495078733956544*^9, 3.495078733956544*^9}, {3.4950861359406147`*^9, 
   3.4950861359406147`*^9}, {3.4951361084771194`*^9, 
   3.4951361084771194`*^9}, {3.49513646583762*^9, 3.495136467907623*^9}, {
   3.4951381490299764`*^9, 3.4951381490299764`*^9}, {3.495138897391024*^9, 
   3.495138899041026*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.4941773316412697`*^9, 3.494177333751273*^9}, {
   3.4941781299723873`*^9, 3.494178211092501*^9}, {3.494178252592559*^9, 
   3.4941782798925977`*^9}, {3.49417832450266*^9, 3.494178365332717*^9}, {
   3.4941785870814295`*^9, 3.4941785879394307`*^9}, 3.4941788167606325`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox[
    RowBox[{"ArcSech", "[", 
     FractionBox["c", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}]], "]"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{"u", " ", 
       SuperscriptBox[
        RowBox[{"ArcCosh", "[", 
         RowBox[{
          FractionBox["a", "c"], "+", 
          FractionBox[
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}], "c"]}], "]"}], "m"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.4941763955899596`*^9, 3.4941764290900064`*^9}, {3.4941764605500507`*^9, 
   3.4941764930400963`*^9}, 3.4941770641708956`*^9, 3.494177118590972*^9, 
   3.494177684591764*^9, {3.4941779313321095`*^9, 3.4941779814621797`*^9}, 
   3.494178084342324*^9, 3.4941786065034637`*^9, 3.494178689183609*^9, {
   3.4941788294122553`*^9, 3.4941788693171253`*^9}, 3.4950787339665437`*^9, 
   3.495086145060628*^9, 3.4951361084871197`*^9, {3.4951364819976425`*^9, 
   3.4951364852176476`*^9}, 3.4951381490299764`*^9, {3.4951389039010334`*^9, 
   3.4951389054910355`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"ArcSech", "[", 
       RowBox[{"c_.", "/", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", 
           RowBox[{"x_", "^", "n_."}]}]}], ")"}]}], "]"}], "^", "m_."}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u", "*", 
      RowBox[{
       RowBox[{"ArcCosh", "[", 
        RowBox[{
         RowBox[{"a", "/", "c"}], "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"x", "^", "n"}], "/", "c"}]}]}], "]"}], "^", "m"}]}], ",", 
     "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "n", ",", "m"}], "}"}], ",", 
     "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.4941763709899254`*^9, 3.49417638178994*^9}, 3.494176933060712*^9, {
   3.4941774426614256`*^9, 3.494177546511571*^9}, {3.494177592181635*^9, 
   3.494177592971636*^9}, {3.4941776926217756`*^9, 3.4941777113818016`*^9}, {
   3.4941777916119137`*^9, 3.494177794051917*^9}, 3.494178543602967*^9, 
   3.4941789047135873`*^9, 3.4950787339665437`*^9, 3.495086153090639*^9, 
   3.49513610849712*^9, 3.495136509297681*^9, 3.4951381490299764`*^9, 
   3.495138914871049*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True,
 CellChangeTimes->{3.495137147148574*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"ArcSech", "[", "u", "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160783652334`*^9, 3.4796867206047907`*^9, 3.492825781557537*^9, 
   3.4940008742017097`*^9, {3.494179192846093*^9, 3.4941791992265043`*^9}, 
   3.495078733996544*^9, 3.49513610855712*^9, 3.495138149039976*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell["Rule: If u is free of inverse functions, then", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703531363038*^9, 
   3.4807035352686543`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"ArcSech", "[", "u", "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "x"}]}], " ", 
    RowBox[{"ArcSech", "[", "u", "]"}]}]}], "+", 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", " ", 
      RowBox[{
       SubscriptBox["\[PartialD]", "x"], "u"}]}], 
     RowBox[{
      SuperscriptBox["u", "2"], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        FractionBox["1", "u"]}]], " ", 
      SqrtBox[
       RowBox[{"1", "+", 
        FractionBox["1", "u"]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579734230976`*^9, 3.4796580026851745`*^9}, {
   3.479658101347043*^9, 3.479658102348483*^9}, {3.4796582237129965`*^9, 
   3.4796582279090304`*^9}, {3.4796611944647284`*^9, 3.4796612203719807`*^9}, 
   3.4796613933206687`*^9, {3.4796614761798143`*^9, 3.4796614777420607`*^9}, 
   3.4796618658000607`*^9, {3.4796619856624146`*^9, 3.4796619866938972`*^9}, {
   3.4796645712002354`*^9, 3.4796645805536847`*^9}, 3.4796646283424015`*^9, {
   3.4796867206148047`*^9, 3.4796867206148047`*^9}, {3.479687667676613*^9, 
   3.479687667926973*^9}, 3.480705232098576*^9, {3.49400087421271*^9, 
   3.49400087421371*^9}, {3.494022456770984*^9, 3.4940224580430565`*^9}, {
   3.494179204577314*^9, 3.4941792454181857`*^9}, {3.4950787340065436`*^9, 
   3.4950787340065436`*^9}, {3.49508586111023*^9, 3.4950858614902306`*^9}, {
   3.4951361085671196`*^9, 3.49513610857712*^9}, {3.4951366645778985`*^9, 
   3.49513667291791*^9}, {3.4951367366679993`*^9, 3.495136737118*^9}, {
   3.495138149039976*^9, 3.495138149039976*^9}, 3.495139032411213*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"ArcSech", "[", "u_", "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
    "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "*", 
      RowBox[{"ArcSech", "[", "u", "]"}]}], " ", "+", "\n", "  ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"Regularize", "[", 
        RowBox[{
         RowBox[{"x", "*", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{"u", ",", "x"}], "]"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"u", "^", "2"}], "*", 
             RowBox[{"Sqrt", "[", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{"1", "/", "u"}]}], "]"}], "*", 
             RowBox[{"Sqrt", "[", 
              RowBox[{"1", "+", 
               RowBox[{"1", "/", "u"}]}], "]"}]}], ")"}]}]}], ",", "x"}], 
        "]"}], ",", "x"}], "]"}]}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"InverseFunctionFreeQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"Not", "[", 
      RowBox[{"FunctionOfExponentialOfLinear", "[", 
       RowBox[{"u", ",", "x"}], "]"}], "]"}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.49400087422171*^9, 3.4940008742237105`*^9}, {
   3.494022461285242*^9, 3.4940224616042604`*^9}, 3.4941791634400415`*^9, 
   3.494179261657814*^9, {3.4943677210722713`*^9, 3.494367728102281*^9}, {
   3.4950787340165434`*^9, 3.4950787340165434`*^9}, 3.495085852480218*^9, {
   3.49513610858712*^9, 3.49513610858712*^9}, 3.4951365932477984`*^9, {
   3.495138149039976*^9, 3.4951381490499763`*^9}, {3.495138982081143*^9, 
   3.49513900874118*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcSech", "[", "u", "]"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160783652334`*^9, 3.4796867206047907`*^9, 3.492825781557537*^9, 
   3.4940008742017097`*^9, {3.494179192846093*^9, 3.4941791992265043`*^9}, 
   3.495078733996544*^9, 3.4950883834737616`*^9, 3.495088664064154*^9, 
   3.495088706264213*^9, 3.4951361085971203`*^9, 3.4951381490499763`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9, 3.494172818179343*^9, 
  3.4950884570038643`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[Cell[TextData[Cell[BoxData[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"n", " ", 
      RowBox[{"ArcSech", "[", "z", "]"}]}]], "=", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SqrtBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          FractionBox["1", "z"]}]], " ", 
        SqrtBox[
         RowBox[{"1", "+", 
          FractionBox["1", "z"]}]]}], "+", 
       FractionBox["1", "z"]}], ")"}], "n"]}]]]], "Subsubsection",
   CellChangeTimes->{
    3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
     3.4941728817394323`*^9, {3.4941732517099504`*^9, 
     3.4941732592199607`*^9}}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
   3.4941728817394323`*^9, {3.4941732517099504`*^9, 3.4941732592199607`*^9}, {
   3.4941867403328547`*^9, 3.494186750597673*^9}, {3.494188482910461*^9, 
   3.494188485702866*^9}, 3.494188591549052*^9, {3.49418864176554*^9, 
   3.49418864750635*^9}, {3.4941887057880526`*^9, 3.494188733883702*^9}, {
   3.494189069767892*^9, 3.4941891152419715`*^9}, {3.494198042823061*^9, 
   3.494198045428265*^9}, {3.494198409922906*^9, 3.4941984537277822`*^9}, {
   3.495042116619762*^9, 3.495042147729806*^9}, {3.4950465577559795`*^9, 
   3.495046587316021*^9}, {3.4950805332790623`*^9, 3.49508053863907*^9}, 
   3.4950884735838876`*^9, {3.4951369008582287`*^9, 3.4951369008582287`*^9}, {
   3.4951393533716626`*^9, 3.4951393555616655`*^9}}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ",  ",
 Cell[BoxData[Cell[TextData[Cell[BoxData[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"n", " ", 
      RowBox[{"ArcSech", "[", "z", "]"}]}]], "=", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "z"], "+", 
       SqrtBox[
        FractionBox[
         RowBox[{"1", "-", "z"}], 
         RowBox[{"1", "+", "z"}]]], "+", 
       FractionBox[
        SqrtBox[
         FractionBox[
          RowBox[{"1", "-", "z"}], 
          RowBox[{"1", "+", "z"}]]], "z"]}], ")"}], "n"]}]]]], "Subsubsection",
   CellChangeTimes->{
    3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
     3.4941728817394323`*^9, {3.4941732517099504`*^9, 
     3.4941732592199607`*^9}}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
   3.4941728817394323`*^9, {3.4941732517099504`*^9, 3.4941732592199607`*^9}, {
   3.4941867403328547`*^9, 3.494186750597673*^9}, {3.494188482910461*^9, 
   3.494188485702866*^9}, 3.494188591549052*^9, {3.49418864176554*^9, 
   3.49418864750635*^9}, {3.4941887057880526`*^9, 3.494188733883702*^9}, {
   3.494189069767892*^9, 3.4941891152419715`*^9}, {3.494198042823061*^9, 
   3.494198045428265*^9}, {3.494198409922906*^9, 3.4941984537277822`*^9}, {
   3.495042116619762*^9, 3.495042147729806*^9}, {3.4950465577559795`*^9, 
   3.495046587316021*^9}, {3.4950805332790623`*^9, 3.49508053863907*^9}, 
   3.4950884735838876`*^9, {3.4951369008582287`*^9, 3.4951369008582287`*^9}, {
   3.4951393533716626`*^9, 3.495139425231763*^9}}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ",  ",
 Cell[BoxData[Cell[TextData[Cell[BoxData[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"n", " ", 
      RowBox[{"ArcSech", "[", "z", "]"}]}]], "=", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"1", "+", 
        FractionBox[
         SqrtBox[
          RowBox[{"1", "-", "z"}]], 
         SqrtBox[
          FractionBox["1", 
           RowBox[{"1", "+", "z"}]]]]}], "z"], ")"}], "n"]}]]]], 
   "Subsubsection",
   CellChangeTimes->{
    3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
     3.4941728817394323`*^9, {3.4941732517099504`*^9, 
     3.4941732592199607`*^9}}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
   3.4941728817394323`*^9, {3.4941732517099504`*^9, 3.4941732592199607`*^9}, {
   3.4941867403328547`*^9, 3.494186750597673*^9}, {3.494188482910461*^9, 
   3.494188485702866*^9}, 3.494188591549052*^9, {3.49418864176554*^9, 
   3.49418864750635*^9}, {3.4941887057880526`*^9, 3.494188733883702*^9}, {
   3.494189069767892*^9, 3.4941891152419715`*^9}, {3.494198042823061*^9, 
   3.494198045428265*^9}, {3.494198409922906*^9, 3.4941984537277822`*^9}, {
   3.495042116619762*^9, 3.495042147729806*^9}, {3.4950465577559795`*^9, 
   3.495046587316021*^9}, {3.4950805332790623`*^9, 3.49508053863907*^9}, 
   3.4950884735838876`*^9, {3.4951369008582287`*^9, 3.4951369008582287`*^9}, {
   3.4951393533716626`*^9, 3.495139425231763*^9}, 3.495139457111808*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{
   "u", " ", "is", " ", "a", " ", "polynomial", " ", "in", " ", "x"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.4941773316412697`*^9, 3.494177333751273*^9}, {
   3.4941891756608777`*^9, 3.494189178765283*^9}, {3.4942004775317707`*^9, 
   3.494200477881771*^9}, {3.4950424099901724`*^9, 3.495042435550208*^9}, {
   3.4950458089749312`*^9, 3.4950458106049337`*^9}, {3.49508849651392*^9, 
   3.4950885018439274`*^9}, 3.495088708784217*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcSech", "[", "u", "]"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "u"], "+", 
          SqrtBox[
           FractionBox[
            RowBox[{"1", "-", "u"}], 
            RowBox[{"1", "+", "u"}]]], "+", 
          FractionBox[
           SqrtBox[
            FractionBox[
             RowBox[{"1", "-", "u"}], 
             RowBox[{"1", "+", "u"}]]], "u"]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.4941763955899596`*^9, 3.4941764290900064`*^9}, {3.4941764605500507`*^9, 
   3.4941764930400963`*^9}, {3.4941882372412295`*^9, 3.49418823769363*^9}, {
   3.4950421850198574`*^9, 3.4950422389399333`*^9}, {3.4950457701448765`*^9, 
   3.495045776854886*^9}, {3.495045811494935*^9, 3.495045812534936*^9}, {
   3.495046607366049*^9, 3.495046608966051*^9}, {3.4950787338465433`*^9, 
   3.4950787338465433`*^9}, 3.4950805638291054`*^9, {3.495088521713955*^9, 
   3.4950885812340384`*^9}, {3.4950887102342186`*^9, 3.495088711864221*^9}, 
   3.49513610861712*^9, {3.4951369750483327`*^9, 3.4951369792883387`*^9}, {
   3.495137035838418*^9, 3.4951370393584228`*^9}, 3.4951381490499763`*^9, 
   3.4951395384319215`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"n_.", "*", 
       RowBox[{"ArcSech", "[", "u_", "]"}]}], ")"}]}], ",", " ", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"1", "/", "u"}], " ", "+", " ", 
        RowBox[{"Sqrt", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "u"}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "+", "u"}], ")"}]}], "]"}], " ", "+", " ", 
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "u"}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"1", "+", "u"}], ")"}]}], "]"}], "/", "u"}]}], ")"}], "^",
       "n"}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.4941763709899254`*^9, 3.49417638178994*^9}, {3.4950424525902324`*^9, 
   3.4950425131303167`*^9}, {3.4950457818848934`*^9, 3.495045815844941*^9}, {
   3.495046610586054*^9, 3.4950466137560577`*^9}, {3.4950787338465433`*^9, 
   3.4950787338465433`*^9}, 3.495080565839108*^9, 3.495088448683853*^9, {
   3.4950887134842234`*^9, 3.4950887155342264`*^9}, 3.49513610862712*^9, 
   3.495136953608303*^9, 3.4951381490499763`*^9, 3.4951393208016167`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9, 3.494172818179343*^9, 
  3.4950884570038643`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[Cell[TextData[Cell[BoxData[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"n", " ", 
      RowBox[{"ArcSech", "[", "z", "]"}]}]], "=", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SqrtBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          FractionBox["1", "z"]}]], " ", 
        SqrtBox[
         RowBox[{"1", "+", 
          FractionBox["1", "z"]}]]}], "+", 
       FractionBox["1", "z"]}], ")"}], "n"]}]]]], "Subsubsection",
   CellChangeTimes->{
    3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
     3.4941728817394323`*^9, {3.4941732517099504`*^9, 
     3.4941732592199607`*^9}}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
   3.4941728817394323`*^9, {3.4941732517099504`*^9, 3.4941732592199607`*^9}, {
   3.4941867403328547`*^9, 3.494186750597673*^9}, {3.494188482910461*^9, 
   3.494188485702866*^9}, 3.494188591549052*^9, {3.49418864176554*^9, 
   3.49418864750635*^9}, {3.4941887057880526`*^9, 3.494188733883702*^9}, {
   3.494189069767892*^9, 3.4941891152419715`*^9}, {3.494198042823061*^9, 
   3.494198045428265*^9}, {3.494198409922906*^9, 3.4941984537277822`*^9}, {
   3.495042116619762*^9, 3.495042147729806*^9}, {3.4950465577559795`*^9, 
   3.495046587316021*^9}, {3.4950805332790623`*^9, 3.49508053863907*^9}, 
   3.4950884735838876`*^9, {3.495136928638268*^9, 3.495136928638268*^9}, {
   3.4951393610716734`*^9, 3.4951393610716734`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{
   "u", " ", "is", " ", "a", " ", "polynomial", " ", "in", " ", "x"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.4941773316412697`*^9, 3.494177333751273*^9}, {
   3.4941891756608777`*^9, 3.494189178765283*^9}, {3.4942004775317707`*^9, 
   3.494200477881771*^9}, {3.4950424099901724`*^9, 3.495042435550208*^9}, {
   3.4950458089749312`*^9, 3.4950458106049337`*^9}, {3.49508849651392*^9, 
   3.4950885018439274`*^9}, 3.49508871785423*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcSech", "[", "u", "]"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", "m"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "u"], "+", 
          SqrtBox[
           FractionBox[
            RowBox[{"1", "-", "u"}], 
            RowBox[{"1", "+", "u"}]]], "+", 
          FractionBox[
           SqrtBox[
            FractionBox[
             RowBox[{"1", "-", "u"}], 
             RowBox[{"1", "+", "u"}]]], "u"]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.4941763955899596`*^9, 3.4941764290900064`*^9}, {3.4941764605500507`*^9, 
   3.4941764930400963`*^9}, {3.4941882372412295`*^9, 3.49418823769363*^9}, {
   3.4950421850198574`*^9, 3.4950422389399333`*^9}, {3.4950457701448765`*^9, 
   3.495045776854886*^9}, {3.495045811494935*^9, 3.495045812534936*^9}, {
   3.495046607366049*^9, 3.495046608966051*^9}, {3.4950787338465433`*^9, 
   3.4950787338465433`*^9}, 3.4950805638291054`*^9, {3.495088521713955*^9, 
   3.4950885812340384`*^9}, {3.4950886684841604`*^9, 
   3.4950886778941736`*^9}, {3.495088719864232*^9, 3.4950887212942343`*^9}, 
   3.49513610864712*^9, 3.495136989828354*^9, 3.4951370461384325`*^9, 
   3.4951381490599766`*^9, 3.4951395644519577`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"E", "^", 
      RowBox[{"(", 
       RowBox[{"n_.", "*", 
        RowBox[{"ArcSech", "[", "u_", "]"}]}], ")"}]}]}], ",", " ", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "m"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1", "/", "u"}], " ", "+", " ", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "u"}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"1", "+", "u"}], ")"}]}], "]"}], " ", "+", " ", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "u"}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{"1", "+", "u"}], ")"}]}], "]"}], "/", "u"}]}], ")"}], 
       "^", "n"}]}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.4941763709899254`*^9, 3.49417638178994*^9}, {3.4950424525902324`*^9, 
   3.4950425131303167`*^9}, {3.4950457818848934`*^9, 3.495045815844941*^9}, {
   3.495046610586054*^9, 3.4950466137560577`*^9}, {3.4950787338465433`*^9, 
   3.4950787338465433`*^9}, 3.495080565839108*^9, 3.495088448683853*^9, 
   3.495088619834092*^9, {3.495088722324236*^9, 3.495088724554239*^9}, 
   3.4951361086571198`*^9, 3.4951369604983125`*^9, 3.4951381490599766`*^9, 
   3.495139329471629*^9},
 Background->GrayLevel[0.85]]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Rules for Inverse Hyperbolic Secant Functions", None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.399999976158142,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 1031, 22, 118, "Title"],
Cell[1601, 46, 325, 5, 67, "Subsubsection"],
Cell[1929, 53, 101, 1, 47, "Subsubsection"],
Cell[2033, 56, 732, 10, 47, "Subsubsection"],
Cell[2768, 68, 2007, 45, 159, "Subsubtitle"],
Cell[4778, 115, 795, 11, 67, "Subsubsection"],
Cell[5576, 128, 1470, 40, 202, "Code"],
Cell[7049, 170, 44, 1, 6, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[7130, 176, 1086, 23, 80, "Title"],
Cell[8219, 201, 207, 3, 48, "Subsubsection"],
Cell[8429, 206, 1133, 20, 36, "Subsubsection"],
Cell[9565, 228, 2203, 46, 82, "Subsubtitle"],
Cell[11771, 276, 795, 11, 48, "Subsubsection"],
Cell[12569, 289, 1742, 45, 145, "Code"],
Cell[14314, 336, 113, 2, 48, "Subsubsection"],
Cell[14430, 340, 369, 5, 34, "Subsubsection"],
Cell[14802, 347, 178, 3, 34, "Subsubsection"],
Cell[14983, 352, 654, 23, 95, "Subsubsection"],
Cell[15640, 377, 647, 21, 86, "Subsubsection"],
Cell[16290, 400, 1025, 19, 36, "Subsubsection"],
Cell[17318, 421, 2484, 56, 141, "Subsubtitle"],
Cell[19805, 479, 795, 11, 48, "Subsubsection"],
Cell[20603, 492, 2150, 59, 180, "Code"],
Cell[22756, 553, 4653, 137, 369, "Code"],
Cell[27412, 692, 44, 1, 5, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[27493, 698, 1299, 27, 83, "Title"],
Cell[28795, 727, 207, 3, 67, "Subsubsection"],
Cell[29005, 732, 660, 15, 75, "Subsubsection"],
Cell[29668, 749, 1191, 16, 47, "Subsubsection"],
Cell[30862, 767, 2209, 44, 120, "Subsubtitle"],
Cell[33074, 813, 795, 11, 67, "Subsubsection"],
Cell[33872, 826, 1588, 40, 202, "Code"],
Cell[35463, 868, 86, 2, 6, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[35586, 875, 825, 17, 80, "Title"],
Cell[36414, 894, 57, 0, 67, "Subsubsection"],
Cell[36474, 896, 729, 10, 47, "Subsubsection"],
Cell[37206, 908, 1825, 41, 197, "Subsubtitle"],
Cell[39034, 951, 771, 11, 67, "Subsubsection"],
Cell[39808, 964, 1715, 43, 251, "Code"],
Cell[41526, 1009, 44, 1, 6, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[41607, 1015, 1003, 21, 80, "Title"],
Cell[42613, 1038, 154, 2, 67, "Subsubsection"],
Cell[42770, 1042, 1562, 35, 125, "Subsubsection"],
Cell[44335, 1079, 1686, 39, 174, "Subsubsection"],
Cell[46024, 1120, 1621, 37, 250, "Subsubsection"],
Cell[47648, 1159, 1467, 25, 50, "Subsubsection"],
Cell[49118, 1186, 2441, 49, 251, "Subsubtitle"],
Cell[51562, 1237, 795, 11, 67, "Subsubsection"],
Cell[52360, 1250, 1751, 43, 202, "Code"],
Cell[54114, 1295, 113, 2, 67, "Subsubsection"],
Cell[54230, 1299, 154, 2, 47, "Subsubsection"],
Cell[54387, 1303, 1558, 35, 125, "Subsubsection"],
Cell[55948, 1340, 1466, 25, 50, "Subsubsection"],
Cell[57417, 1367, 2508, 51, 251, "Subsubtitle"],
Cell[59928, 1420, 795, 11, 67, "Subsubsection"],
Cell[60726, 1433, 1965, 49, 202, "Code"]
}, Closed]]
}
]
*)

(* End of internal cache information *)
