(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    610203,      15644]
NotebookOptionsPosition[    580592,      15003]
NotebookOutlinePosition[    581723,      15042]
CellTagsIndexPosition[    581680,      15039]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: CRC 585, A&S 4.6.45", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a", " ", "x"}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "x"}]}], " ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a", " ", "x"}], "]"}]}]}], "+", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", 
     RowBox[{
      SuperscriptBox["a", "2"], 
      SuperscriptBox["x", "2"]}]}], "]"}], 
   RowBox[{"2", "a"}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a_.", "*", "x_"}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=", 
  "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", "*", "x"}], "]"}]}], " ", "+", " ", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "a"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{"a", ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
  3.4940972668388243`*^9, 3.4940972723188314`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "x"}]}], " ", 
    SuperscriptBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}]}], "-", 
  RowBox[{"a", " ", "n", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"x", " ", 
       SuperscriptBox[
        RowBox[{"ArcTanh", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]]}], 
      RowBox[{"1", "-", 
       RowBox[{
        SuperscriptBox["a", "2"], 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{
           RowBox[{"ArcTanh", "[", 
            RowBox[{"a", "*", "x"}], "]"}], "^", 
           RowBox[{"(", 
            RowBox[{"n", "-", "1"}], ")"}]}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{
             RowBox[{"a", "^", "2"}], "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.492802747642827*^9, 
   3.492802751137233*^9}, 3.4928222777249804`*^9, 3.492825819138003*^9, {
   3.492830644352556*^9, 3.492830644712557*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Iterated integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}, {
  3.4940052861338797`*^9, 3.4940052928402634`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.493098879405472*^9, 3.493098884745479*^9}, {3.493099207935931*^9, 
   3.4930992149659414`*^9}, 3.4930996737265835`*^9, 3.493099827186798*^9, {
   3.4932434943005557`*^9, 3.493243522320595*^9}, {3.494005203823172*^9, 
   3.494005223116276*^9}, {3.4940055732323008`*^9, 3.4940055743073626`*^9}, 
   3.4940057909347525`*^9, 3.494006120923627*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"ArcTanh", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"], 
        RowBox[{"2", 
         SuperscriptBox["a", "2"]}]]}]}]}]}]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "2"], 
    SuperscriptBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], "2"], "+", 
  RowBox[{
   FractionBox["n", 
    RowBox[{"2", "a"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493098332554706*^9, 3.4930984922049294`*^9}, {
   3.4930985835950575`*^9, 3.4930986777351894`*^9}, {3.4930988533254347`*^9, 
   3.4930988578754416`*^9}, {3.493099207935931*^9, 3.4930992149659414`*^9}, {
   3.4930993574561405`*^9, 3.493099400886202*^9}, {3.493099526816378*^9, 
   3.49309953534639*^9}, 3.4931705981281786`*^9, {3.493170768098417*^9, 
   3.4931708122284784`*^9}, {3.4940050446890697`*^9, 
   3.4940051357132764`*^9}, {3.494005409976963*^9, 3.494005469155348*^9}, {
   3.4940101517571774`*^9, 3.494010179840784*^9}, {3.494010370766704*^9, 
   3.4940103752849627`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.4940053078671227`*^9, 3.494005310026246*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", 
       RowBox[{"a", "^", "2"}]}], ")"}]}], " ", "+", " ", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", "2"}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "a"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"ArcTanh", "[", 
          RowBox[{"a", "*", "x"}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4928302625720215`*^9, 3.4928303000920744`*^9}, {
   3.4928305645624447`*^9, 3.4928305746224585`*^9}, {3.4930994731463027`*^9, 
   3.4930995793864517`*^9}, {3.4931708257484975`*^9, 3.493170933088648*^9}, {
   3.493170964658692*^9, 3.4931709750387063`*^9}, {3.493171201919024*^9, 
   3.493171205079028*^9}, {3.493171366199254*^9, 3.4931713665792546`*^9}, {
   3.4931715056494493`*^9, 3.49317150626945*^9}, {3.4932434733805265`*^9, 
   3.4932434776305323`*^9}, 3.4932442598016276`*^9, 3.4932444119118404`*^9, {
   3.494004039303565*^9, 3.4940040800098934`*^9}, {3.4940049144956236`*^9, 
   3.4940049151486607`*^9}, {3.4940049727389545`*^9, 
   3.4940049792463264`*^9}, {3.4940054842162094`*^9, 3.494005590086265*^9}, 
   3.494005794311946*^9, {3.494006124318821*^9, 3.494006126234931*^9}, 
   3.4940095020830183`*^9, {3.494010209237465*^9, 3.494010224615345*^9}, {
   3.4940103892347603`*^9, 3.4940104095319214`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Iterated integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}, {
  3.4940052861338797`*^9, 3.4940052928402634`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.493098879405472*^9, 3.493098884745479*^9}, {3.493099207935931*^9, 
   3.4930992149659414`*^9}, 3.4930996737265835`*^9, 3.493099827186798*^9, {
   3.4932434943005557`*^9, 3.493243522320595*^9}, {3.494005203823172*^9, 
   3.494005223116276*^9}, {3.494005912167687*^9, 3.494005912167687*^9}, {
   3.494005996704522*^9, 3.494006005111003*^9}, {3.4940120035220923`*^9, 
   3.4940120062372475`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["x", 
          RowBox[{"m", "-", "1"}]], " ", 
         SuperscriptBox[
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", 
     RowBox[{"m", "+", "1"}]], 
    SuperscriptBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
   RowBox[{"m", "+", "1"}]], "+", 
  "                                                ", "\[IndentingNewLine]", 
  "                                                ", 
  RowBox[{
   FractionBox["n", 
    RowBox[{"a", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "-", "1"}], 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493098332554706*^9, 3.4930984922049294`*^9}, {
   3.4930985835950575`*^9, 3.4930986777351894`*^9}, {3.4930988533254347`*^9, 
   3.4930988578754416`*^9}, {3.493099207935931*^9, 3.4930992149659414`*^9}, {
   3.4930993574561405`*^9, 3.493099400886202*^9}, {3.493099526816378*^9, 
   3.49309953534639*^9}, 3.4931705981281786`*^9, {3.493170768098417*^9, 
   3.4931708122284784`*^9}, {3.4940050446890697`*^9, 
   3.4940051357132764`*^9}, {3.494010254898077*^9, 3.4940102990006*^9}, {
   3.494010355515832*^9, 3.4940103650133753`*^9}, {3.4940156306725535`*^9, 
   3.494015641501173*^9}, {3.494015829505926*^9, 3.494015853240284*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.4940053078671227`*^9, 3.494005310026246*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}]}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", 
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4928302625720215`*^9, 3.4928303000920744`*^9}, {
   3.4928305645624447`*^9, 3.4928305746224585`*^9}, {3.4930994731463027`*^9, 
   3.4930995793864517`*^9}, {3.4931708257484975`*^9, 3.493170933088648*^9}, {
   3.493170964658692*^9, 3.4931709750387063`*^9}, {3.493171201919024*^9, 
   3.493171205079028*^9}, {3.493171366199254*^9, 3.4931713665792546`*^9}, {
   3.4931715056494493`*^9, 3.49317150626945*^9}, {3.4932434733805265`*^9, 
   3.4932434776305323`*^9}, 3.4932442598016276`*^9, 3.4932444119118404`*^9, {
   3.494004039303565*^9, 3.4940040800098934`*^9}, {3.4940049144956236`*^9, 
   3.4940049151486607`*^9}, {3.4940049727389545`*^9, 3.4940049792463264`*^9}, 
   3.4940059089755044`*^9, {3.494006032487569*^9, 3.4940060554328814`*^9}, 
   3.4940094923844633`*^9, {3.4940103280942636`*^9, 3.4940103492304726`*^9}, {
   3.4940104554925504`*^9, 3.4940104824550924`*^9}, {3.4940119781816435`*^9, 
   3.494011987537178*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.493098879405472*^9, 3.493098884745479*^9}, {3.493099207935931*^9, 
   3.4930992149659414`*^9}, 3.4930996737265835`*^9, 3.493099827186798*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], "x"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "2"}]}], " ", 
    SuperscriptBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"1", "-", 
      FractionBox["2", 
       RowBox[{"1", "-", 
        RowBox[{"a", " ", "x"}]}]]}], "]"}]}]}], "-", 
  RowBox[{"2", "a", " ", "n", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcTanh", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"ArcTanh", "[", 
        RowBox[{"1", "-", 
         FractionBox["2", 
          RowBox[{"1", "-", 
           RowBox[{"a", " ", "x"}]}]]}], "]"}]}], 
      RowBox[{"1", "-", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 PageWidth->Infinity,
 CellChangeTimes->{{3.493098332554706*^9, 3.4930984922049294`*^9}, {
   3.4930985835950575`*^9, 3.4930986777351894`*^9}, {3.4930988533254347`*^9, 
   3.4930988578754416`*^9}, {3.493099207935931*^9, 3.4930992149659414`*^9}, {
   3.4930993574561405`*^9, 3.493099400886202*^9}, {3.493099526816378*^9, 
   3.49309953534639*^9}, 3.4931705981281786`*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}], "/", "x_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "*", 
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "*", 
     RowBox[{"ArcTanh", "[", 
      RowBox[{"1", "-", 
       RowBox[{"2", "/", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"a", "*", "x"}]}], ")"}]}]}], "]"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", "a", "*", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"1", "-", 
            RowBox[{"2", "/", 
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"a", "*", "x"}]}], ")"}]}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{
             RowBox[{"a", "^", "2"}], "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4928302625720215`*^9, 3.4928303000920744`*^9}, {
  3.4928305645624447`*^9, 3.4928305746224585`*^9}, {3.4930994731463027`*^9, 
  3.4930995793864517`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.493098879405472*^9, 3.493098884745479*^9}, {3.493099207935931*^9, 
   3.4930992149659414`*^9}, 3.4930996737265835`*^9, 3.493099827186798*^9, {
   3.4932434943005557`*^9, 3.493243522320595*^9}, {3.4940131571360755`*^9, 
   3.494013161549328*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     SuperscriptBox["x", "2"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"ArcTanh", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"], "x"]}]}]}]}]}], "+", 
  RowBox[{"a", " ", "n", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], 
       RowBox[{"n", "-", "1"}]], 
      RowBox[{"x", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["x", "2"]}]}], ")"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493098332554706*^9, 3.4930984922049294`*^9}, {
   3.4930985835950575`*^9, 3.4930986777351894`*^9}, {3.4930988533254347`*^9, 
   3.4930988578754416`*^9}, {3.493099207935931*^9, 3.4930992149659414`*^9}, {
   3.4930993574561405`*^9, 3.493099400886202*^9}, {3.493099526816378*^9, 
   3.49309953534639*^9}, 3.4931705981281786`*^9, {3.493170768098417*^9, 
   3.4931708122284784`*^9}, {3.494013179298343*^9, 3.4940132717176294`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
     RowBox[{"x_", "^", "2"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], "/", "x"}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{"x", "*", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{
              RowBox[{"a", "^", "2"}], "*", 
              RowBox[{"x", "^", "2"}]}]}], ")"}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4928302625720215`*^9, 3.4928303000920744`*^9}, {
   3.4928305645624447`*^9, 3.4928305746224585`*^9}, {3.4930994731463027`*^9, 
   3.4930995793864517`*^9}, {3.4931708257484975`*^9, 3.493170933088648*^9}, {
   3.493170964658692*^9, 3.4931709750387063`*^9}, {3.493171201919024*^9, 
   3.493171205079028*^9}, {3.493171366199254*^9, 3.4931713665792546`*^9}, {
   3.4931715056494493`*^9, 3.49317150626945*^9}, {3.4932434733805265`*^9, 
   3.4932434776305323`*^9}, 3.4932442598016276`*^9, 3.4932444119118404`*^9, {
   3.4940040426067543`*^9, 3.494004046872998*^9}, {3.494009552628909*^9, 
   3.494009555663083*^9}, {3.4940116323648634`*^9, 3.4940116363310905`*^9}, {
   3.494013128108415*^9, 3.494013131212593*^9}, {3.4940133353222675`*^9, 
   3.494013406482337*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Inverted iterated integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}, {
  3.4940052861338797`*^9, 3.4940052928402634`*^9}, {3.494011690737202*^9, 
  3.494011693788377*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.493098879405472*^9, 3.493098884745479*^9}, {3.493099207935931*^9, 
   3.4930992149659414`*^9}, 3.4930996737265835`*^9, 3.493099827186798*^9, {
   3.4932434943005557`*^9, 3.493243522320595*^9}, {3.494005203823172*^9, 
   3.494005223116276*^9}, {3.494005912167687*^9, 3.494005912167687*^9}, {
   3.494005996704522*^9, 3.494006005111003*^9}, {3.4940117189798174`*^9, 
   3.494011721274949*^9}, {3.494011926169668*^9, 3.4940119289428267`*^9}, {
   3.4940120348468843`*^9, 3.494012036980006*^9}, {3.494012573744707*^9, 
   3.4940125763308554`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     SuperscriptBox["x", "3"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["a", "2"], 
        SuperscriptBox[
         RowBox[{"ArcTanh", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"]}], "2"]}]}]}]}], "-", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"2", 
    SuperscriptBox["x", "2"]}]], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "n"}], "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], 
       RowBox[{"n", "-", "1"}]], 
      SuperscriptBox["x", "2"]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493098332554706*^9, 3.4930984922049294`*^9}, {
   3.4930985835950575`*^9, 3.4930986777351894`*^9}, {3.4930988533254347`*^9, 
   3.4930988578754416`*^9}, {3.493099207935931*^9, 3.4930992149659414`*^9}, {
   3.4930993574561405`*^9, 3.493099400886202*^9}, {3.493099526816378*^9, 
   3.49309953534639*^9}, 3.4931705981281786`*^9, {3.493170768098417*^9, 
   3.4931708122284784`*^9}, {3.4940050446890697`*^9, 
   3.4940051357132764`*^9}, {3.494010254898077*^9, 3.4940102990006*^9}, {
   3.494010355515832*^9, 3.4940103650133753`*^9}, 3.4940116760473623`*^9, {
   3.4940120899150343`*^9, 3.494012256009534*^9}, 3.494012321413275*^9, 
   3.494012355001196*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.4940053078671227`*^9, 3.494005310026246*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
     RowBox[{"x_", "^", "3"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", "^", "2"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", "2"}]}], " ", "-", 
    " ", 
    RowBox[{
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", 
       RowBox[{"x", "^", "2"}]}], ")"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"n", "/", "2"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "/", 
         RowBox[{"x", "^", "2"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4928302625720215`*^9, 3.4928303000920744`*^9}, {
   3.4928305645624447`*^9, 3.4928305746224585`*^9}, {3.4930994731463027`*^9, 
   3.4930995793864517`*^9}, {3.4931708257484975`*^9, 3.493170933088648*^9}, {
   3.493170964658692*^9, 3.4931709750387063`*^9}, {3.493171201919024*^9, 
   3.493171205079028*^9}, {3.493171366199254*^9, 3.4931713665792546`*^9}, {
   3.4931715056494493`*^9, 3.49317150626945*^9}, {3.4932434733805265`*^9, 
   3.4932434776305323`*^9}, 3.4932442598016276`*^9, 3.4932444119118404`*^9, {
   3.494004039303565*^9, 3.4940040800098934`*^9}, {3.4940049144956236`*^9, 
   3.4940049151486607`*^9}, {3.4940049727389545`*^9, 3.4940049792463264`*^9}, 
   3.4940059089755044`*^9, {3.494006032487569*^9, 3.4940060554328814`*^9}, 
   3.4940094923844633`*^9, {3.4940103280942636`*^9, 3.4940103492304726`*^9}, {
   3.4940104554925504`*^9, 3.4940104824550924`*^9}, {3.4940117336926594`*^9, 
   3.494011876094804*^9}, {3.4940120191709876`*^9, 3.4940120264064016`*^9}, {
   3.494012388532114*^9, 3.4940124429682274`*^9}, {3.4940125561557016`*^9, 
   3.4940125689854355`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Inverted iterated integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}, {
  3.4940052861338797`*^9, 3.4940052928402634`*^9}, {3.494011690737202*^9, 
  3.494011693788377*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"m", "<", 
    RowBox[{"-", "3"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.493098879405472*^9, 3.493098884745479*^9}, {3.493099207935931*^9, 
   3.4930992149659414`*^9}, 3.4930996737265835`*^9, 3.493099827186798*^9, {
   3.4932434943005557`*^9, 3.493243522320595*^9}, {3.494005203823172*^9, 
   3.494005223116276*^9}, {3.494005912167687*^9, 3.494005912167687*^9}, {
   3.494005996704522*^9, 3.494006005111003*^9}, {3.4940117189798174`*^9, 
   3.494011721274949*^9}, {3.494011926169668*^9, 3.4940119289428267`*^9}, {
   3.4940120348468843`*^9, 3.494012036980006*^9}, {3.494013442081373*^9, 
   3.494013450779871*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"ArcTanh", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox["x", 
     RowBox[{"m", "+", "3"}]], " ", 
    SuperscriptBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
   RowBox[{"m", "+", "1"}]], "-", 
  "                                                ", "\[IndentingNewLine]", 
  "                                                ", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "n"}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "2"], 
     RowBox[{"(", 
      RowBox[{"m", "+", "3"}], ")"}]}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493098332554706*^9, 3.4930984922049294`*^9}, {
   3.4930985835950575`*^9, 3.4930986777351894`*^9}, {3.4930988533254347`*^9, 
   3.4930988578754416`*^9}, {3.493099207935931*^9, 3.4930992149659414`*^9}, {
   3.4930993574561405`*^9, 3.493099400886202*^9}, {3.493099526816378*^9, 
   3.49309953534639*^9}, 3.4931705981281786`*^9, {3.493170768098417*^9, 
   3.4931708122284784`*^9}, {3.4940050446890697`*^9, 
   3.4940051357132764`*^9}, {3.494010254898077*^9, 3.4940102990006*^9}, {
   3.494010355515832*^9, 3.4940103650133753`*^9}, 3.4940116760473623`*^9, {
   3.4940156538678803`*^9, 3.494015661870338*^9}, {3.494015862381807*^9, 
   3.4940158673580914`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.4940053078671227`*^9, 3.494005310026246*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", " ", 
    RowBox[{
     RowBox[{"a", "^", "2"}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "3"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"n", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "3"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "3"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.4928302625720215`*^9, 3.4928303000920744`*^9}, {
   3.4928305645624447`*^9, 3.4928305746224585`*^9}, {3.4930994731463027`*^9, 
   3.4930995793864517`*^9}, {3.4931708257484975`*^9, 3.493170933088648*^9}, {
   3.493170964658692*^9, 3.4931709750387063`*^9}, {3.493171201919024*^9, 
   3.493171205079028*^9}, {3.493171366199254*^9, 3.4931713665792546`*^9}, {
   3.4931715056494493`*^9, 3.49317150626945*^9}, {3.4932434733805265`*^9, 
   3.4932434776305323`*^9}, 3.4932442598016276`*^9, 3.4932444119118404`*^9, {
   3.494004039303565*^9, 3.4940040800098934`*^9}, {3.4940049144956236`*^9, 
   3.4940049151486607`*^9}, {3.4940049727389545`*^9, 3.4940049792463264`*^9}, 
   3.4940059089755044`*^9, {3.494006032487569*^9, 3.4940060554328814`*^9}, 
   3.4940094923844633`*^9, {3.4940103280942636`*^9, 3.4940103492304726`*^9}, {
   3.4940104554925504`*^9, 3.4940104824550924`*^9}, {3.4940117336926594`*^9, 
   3.494011876094804*^9}, {3.4940120191709876`*^9, 3.4940120264064016`*^9}, {
   3.4940134559001637`*^9, 3.4940134576452637`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", "x"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.492802747642827*^9, 
   3.492802751137233*^9}, 3.4928222777249804`*^9, 3.492825819138003*^9, {
   3.492830644352556*^9, 3.492830644712557*^9}, {3.4928404670121565`*^9, 
   3.492840467502157*^9}, 3.492913326383937*^9, {3.4931451285332985`*^9, 
   3.4931451299433002`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.4931456018039613`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox["c", "2"]}], "=", 
   RowBox[{
    SuperscriptBox["d", "2"], " ", "\[And]", " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.493581126911767*^9, 3.493581143581791*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
         RowBox[{"Log", "[", 
          FractionBox[
           RowBox[{"2", " ", "c"}], 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}]], "]"}]}], "d"]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "n"}], "d"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcTanh", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"Log", "[", 
        FractionBox[
         RowBox[{"2", " ", "c"}], 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}]], "]"}]}], 
      RowBox[{"1", "-", 
       RowBox[{
        SuperscriptBox["a", "2"], 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4927459475946445`*^9, 3.49274596552767*^9}, {
   3.4927470791633663`*^9, 3.492747100502587*^9}, {3.492838456185856*^9, 
   3.492838468151077*^9}, {3.4928389429535108`*^9, 3.492838996648805*^9}, {
   3.492839156730687*^9, 3.4928391643123*^9}, 3.4928403497119923`*^9, {
   3.492908275826866*^9, 3.4929083226469316`*^9}, 3.492910391739828*^9, {
   3.4931446954326925`*^9, 3.493144762932787*^9}, 3.4931448959029727`*^9, {
   3.493144975223084*^9, 3.4931449799230905`*^9}, {3.4931453401435947`*^9, 
   3.4931453627536263`*^9}, 3.4931456018039613`*^9, {3.4931469777458878`*^9, 
   3.4931469799558907`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
     RowBox[{"(", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", "x_"}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"2", "*", 
        RowBox[{"c", "/", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], ")"}]}]}], "]"}], "/", "d"}]}], " ", 
    "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"n", "/", "d"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"2", "*", 
            RowBox[{"c", "/", 
             RowBox[{"(", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], ")"}]}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{
             RowBox[{"a", "^", "2"}], "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", 
       RowBox[{"c", "^", "2"}]}], "-", 
      RowBox[{"d", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.4928386496573954`*^9, 3.4928386538382025`*^9}, {
   3.4928387393419533`*^9, 3.4928388738453894`*^9}, {3.4928392099891806`*^9, 
   3.4928392282724123`*^9}, {3.4928392656204743`*^9, 3.492839265890475*^9}, {
   3.4928393374405746`*^9, 3.492839337970576*^9}, 3.4928413413933806`*^9, {
   3.4930740306333447`*^9, 3.4930740321133466`*^9}, {3.493144462352366*^9, 
   3.493144468172374*^9}, {3.493144540822476*^9, 3.4931445433324795`*^9}, {
   3.4931445892825437`*^9, 3.4931445898425446`*^9}, {3.493145449723748*^9, 
   3.493145475833785*^9}, {3.49358106455168*^9, 3.493581066611683*^9}, {
   3.493748575803213*^9, 3.4937486011688576`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", "x"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.492802747642827*^9, 
   3.492802751137233*^9}, 3.4928222777249804`*^9, 3.492825819138003*^9, {
   3.492830644352556*^9, 3.492830644712557*^9}, {3.4928404670121565`*^9, 
   3.492840467502157*^9}, 3.492913326383937*^9, {3.4929975742692375`*^9, 
   3.492997579510846*^9}, {3.4931465961853533`*^9, 3.493146597295355*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.4931456018039613`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox["c", "2"]}], "=", 
   RowBox[{
    SuperscriptBox["d", "2"], " ", "\[And]", " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.4935811541318054`*^9, 
   3.4935811541318054`*^9}, {3.493581238921924*^9, 3.493581239361925*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"x", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"ArcTanh", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
        RowBox[{"Log", "[", 
         RowBox[{"2", "-", 
          FractionBox[
           RowBox[{"2", " ", "c"}], 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}]]}], "]"}]}], "c"]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "n"}], "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcTanh", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"Log", "[", 
        RowBox[{"2", "-", 
         FractionBox[
          RowBox[{"2", " ", "c"}], 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}]]}], "]"}]}], 
      RowBox[{"1", "-", 
       RowBox[{
        SuperscriptBox["a", "2"], 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4927459475946445`*^9, 3.49274596552767*^9}, {
   3.4927470791633663`*^9, 3.492747100502587*^9}, {3.492838456185856*^9, 
   3.492838468151077*^9}, {3.4928389429535108`*^9, 3.492838996648805*^9}, {
   3.492839156730687*^9, 3.4928391643123*^9}, 3.4928403497119923`*^9, {
   3.492908275826866*^9, 3.4929083226469316`*^9}, 3.492910391739828*^9, {
   3.4931446954326925`*^9, 3.493144762932787*^9}, 3.4931448959029727`*^9, {
   3.493144975223084*^9, 3.4931449799230905`*^9}, {3.4931453401435947`*^9, 
   3.4931453627536263`*^9}, 3.4931456018039613`*^9, {3.4931466620154457`*^9, 
   3.493146720405527*^9}, {3.493146762375586*^9, 3.4931467629255867`*^9}, {
   3.4931574816798153`*^9, 3.4931574860698223`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
     RowBox[{"(", 
      RowBox[{"x_", "*", 
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", "x_"}]}], ")"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"2", "-", 
        RowBox[{"2", "*", 
         RowBox[{"c", "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], "]"}], "/", "c"}]}], " ", 
    "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"n", "/", "c"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"2", "-", 
            RowBox[{"2", "*", 
             RowBox[{"c", "/", 
              RowBox[{"(", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{
             RowBox[{"a", "^", "2"}], "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", 
       RowBox[{"c", "^", "2"}]}], "-", 
      RowBox[{"d", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.4928386496573954`*^9, 3.4928386538382025`*^9}, {
   3.4928387393419533`*^9, 3.4928388738453894`*^9}, {3.4928392099891806`*^9, 
   3.4928392282724123`*^9}, {3.4928392656204743`*^9, 3.492839265890475*^9}, {
   3.4928393374405746`*^9, 3.492839337970576*^9}, 3.4928413413933806`*^9, {
   3.4930740306333447`*^9, 3.4930740321133466`*^9}, {3.493144462352366*^9, 
   3.493144468172374*^9}, {3.493144540822476*^9, 3.4931445433324795`*^9}, {
   3.4931445892825437`*^9, 3.4931445898425446`*^9}, {3.493145449723748*^9, 
   3.493145475833785*^9}, {3.493146638085412*^9, 3.4931466465254235`*^9}, {
   3.4931467543555746`*^9, 3.4931467820656137`*^9}, {3.493146817405663*^9, 
   3.493146854555715*^9}, {3.493147492576608*^9, 3.493147492956609*^9}, {
   3.4931575219698725`*^9, 3.4931575367198925`*^9}, 3.4931584323211465`*^9, {
   3.4935810314016333`*^9, 3.493581033811637*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.4931456018039613`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox["c", "2"]}], "=", 
   RowBox[{
    SuperscriptBox["d", "2"], " ", "\[And]", " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.493581162211817*^9, 3.493581162211817*^9}, {
   3.493581231631914*^9, 3.4935812320219145`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{
      RowBox[{"c", " ", "x"}], "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"ArcTanh", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
        RowBox[{"Log", "[", 
         RowBox[{"2", "-", 
          FractionBox[
           RowBox[{"2", " ", "c"}], 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}]]}], "]"}]}], "c"]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "n"}], "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcTanh", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"Log", "[", 
        RowBox[{"2", "-", 
         FractionBox[
          RowBox[{"2", " ", "c"}], 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}]]}], "]"}]}], 
      RowBox[{"1", "-", 
       RowBox[{
        SuperscriptBox["a", "2"], 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4927459475946445`*^9, 3.49274596552767*^9}, {
   3.4927470791633663`*^9, 3.492747100502587*^9}, {3.492838456185856*^9, 
   3.492838468151077*^9}, {3.4928389429535108`*^9, 3.492838996648805*^9}, {
   3.492839156730687*^9, 3.4928391643123*^9}, 3.4928403497119923`*^9, {
   3.492908275826866*^9, 3.4929083226469316`*^9}, 3.492910391739828*^9, {
   3.4931446954326925`*^9, 3.493144762932787*^9}, 3.4931448959029727`*^9, {
   3.493144975223084*^9, 3.4931449799230905`*^9}, {3.4931453401435947`*^9, 
   3.4931453627536263`*^9}, 3.4931456018039613`*^9, {3.4931466620154457`*^9, 
   3.493146720405527*^9}, {3.493146762375586*^9, 3.4931467629255867`*^9}, {
   3.4931574816798153`*^9, 3.4931574860698223`*^9}, {3.493158351951034*^9, 
   3.4931583622410483`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c_.", "*", "x_"}], "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"2", "-", 
        RowBox[{"2", "*", 
         RowBox[{"c", "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], "]"}], "/", "c"}]}], " ", 
    "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"n", "/", "c"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"2", "-", 
            RowBox[{"2", "*", 
             RowBox[{"c", "/", 
              RowBox[{"(", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{
             RowBox[{"a", "^", "2"}], "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", 
       RowBox[{"c", "^", "2"}]}], "-", 
      RowBox[{"d", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.4928386496573954`*^9, 3.4928386538382025`*^9}, {
   3.4928387393419533`*^9, 3.4928388738453894`*^9}, {3.4928392099891806`*^9, 
   3.4928392282724123`*^9}, {3.4928392656204743`*^9, 3.492839265890475*^9}, {
   3.4928393374405746`*^9, 3.492839337970576*^9}, 3.4928413413933806`*^9, {
   3.4930740306333447`*^9, 3.4930740321133466`*^9}, {3.493144462352366*^9, 
   3.493144468172374*^9}, {3.493144540822476*^9, 3.4931445433324795`*^9}, {
   3.4931445892825437`*^9, 3.4931445898425446`*^9}, {3.493145449723748*^9, 
   3.493145475833785*^9}, {3.493146638085412*^9, 3.4931466465254235`*^9}, {
   3.4931467543555746`*^9, 3.4931467820656137`*^9}, {3.493146817405663*^9, 
   3.493146854555715*^9}, {3.493147492576608*^9, 3.493147492956609*^9}, {
   3.4931575219698725`*^9, 3.4931575367198925`*^9}, {3.493158449661171*^9, 
   3.4931584772112093`*^9}, {3.4935810370816417`*^9, 3.4935810386816435`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["x", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", "x"}]}]], "\[Equal]", 
   RowBox[{
    FractionBox["1", "d"], "-", 
    FractionBox["c", 
     RowBox[{"d", " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664443126074*^9, 3.479664484795992*^9, {3.479686720494632*^9, 
   3.479686740223*^9}, {3.4929978496877213`*^9, 3.4929978567233334`*^9}, {
   3.4929979016982126`*^9, 3.492997933194668*^9}, 3.4929979741135397`*^9, {
   3.4932342226975756`*^9, 3.4932342226975756`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox["c", "2"]}], "=", 
   RowBox[{
    SuperscriptBox["d", "2"], " ", "\[And]", " ", 
    RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.4932344140978436`*^9, 3.493234436457875*^9}, 
   3.4932344713679237`*^9, 3.493234764358334*^9, {3.493581169571827*^9, 
   3.4935812149118905`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      SuperscriptBox[
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "d"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["x", 
       RowBox[{"m", "-", "1"}]], " ", 
      SuperscriptBox[
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["c", "d"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "-", "1"}]], " ", 
       SuperscriptBox[
        RowBox[{"ArcTanh", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.4927459475946445`*^9, 3.49274596552767*^9}, {
   3.4927470791633663`*^9, 3.492747100502587*^9}, {3.492838456185856*^9, 
   3.492838468151077*^9}, {3.4928389429535108`*^9, 3.492838996648805*^9}, {
   3.492839156730687*^9, 3.4928391643123*^9}, 3.4928403497119923`*^9, {
   3.492908275826866*^9, 3.4929083226469316`*^9}, 3.492910391739828*^9, {
   3.49299802556243*^9, 3.492998081316928*^9}, {3.4932341813675175`*^9, 
   3.4932341825075192`*^9}, {3.4932342504576144`*^9, 3.493234254887621*^9}, {
   3.4932342987776823`*^9, 3.493234348687752*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "d"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"c", "/", "d"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"ArcTanh", "[", 
            RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", 
       RowBox[{"c", "^", "2"}]}], "-", 
      RowBox[{"d", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.4928386496573954`*^9, 3.4928386538382025`*^9}, {
   3.4928387393419533`*^9, 3.4928388738453894`*^9}, {3.4928392099891806`*^9, 
   3.4928392282724123`*^9}, {3.4928392656204743`*^9, 3.492839265890475*^9}, {
   3.4928393374405746`*^9, 3.492839337970576*^9}, 3.4928413413933806`*^9, {
   3.4929976285885324`*^9, 3.492997657401783*^9}, {3.4929982343063965`*^9, 
   3.492998284850485*^9}, {3.4929983307925663`*^9, 3.4929983346145725`*^9}, {
   3.4929983685134325`*^9, 3.492998380915454*^9}, {3.4929985595281687`*^9, 
   3.492998559886969*^9}, {3.4929986169674697`*^9, 3.4929986552187366`*^9}, {
   3.493145648214026*^9, 3.493145651704031*^9}, {3.493174757504002*^9, 
   3.4931747608840065`*^9}, {3.4932344939779553`*^9, 3.493234517877989*^9}, {
   3.4932345822880793`*^9, 3.4932345974581003`*^9}, {3.493234635668154*^9, 
   3.4932346995382433`*^9}, {3.4935810433816504`*^9, 3.493581045391653*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", "x"}]}]], "\[Equal]", 
   RowBox[{
    FractionBox["1", "c"], "-", 
    FractionBox[
     RowBox[{"d", " ", "x"}], 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664443126074*^9, 3.479664484795992*^9, {3.479686720494632*^9, 
   3.479686740223*^9}, {3.4929978496877213`*^9, 3.4929978567233334`*^9}, {
   3.4929979016982126`*^9, 3.492997933194668*^9}, 3.4929979741135397`*^9, {
   3.4932342226975756`*^9, 3.4932342226975756`*^9}, {3.4932349492985926`*^9, 
   3.493234969438621*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox["c", "2"]}], "=", 
   RowBox[{
    SuperscriptBox["d", "2"], " ", "\[And]", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.4932344140978436`*^9, 3.493234436457875*^9}, 
   3.4932344713679237`*^9, 3.493234764358334*^9, {3.493234813308402*^9, 
   3.4932348147484045`*^9}, {3.4932350526787376`*^9, 3.493235052938738*^9}, {
   3.493581174131833*^9, 3.493581183231846*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      SuperscriptBox[
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "c"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      SuperscriptBox[
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["d", "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "+", "1"}]], " ", 
       SuperscriptBox[
        RowBox[{"ArcTanh", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.4927459475946445`*^9, 3.49274596552767*^9}, {
   3.4927470791633663`*^9, 3.492747100502587*^9}, {3.492838456185856*^9, 
   3.492838468151077*^9}, {3.4928389429535108`*^9, 3.492838996648805*^9}, {
   3.492839156730687*^9, 3.4928391643123*^9}, 3.4928403497119923`*^9, {
   3.492908275826866*^9, 3.4929083226469316`*^9}, 3.492910391739828*^9, {
   3.49299802556243*^9, 3.492998081316928*^9}, {3.4932341813675175`*^9, 
   3.4932341825075192`*^9}, {3.4932342504576144`*^9, 3.493234254887621*^9}, {
   3.4932342987776823`*^9, 3.493234348687752*^9}, {3.4932348327784295`*^9, 
   3.4932348796784954`*^9}, 3.4932349106485386`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"d", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"ArcTanh", "[", 
            RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", 
       RowBox[{"c", "^", "2"}]}], "-", 
      RowBox[{"d", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.4928386496573954`*^9, 3.4928386538382025`*^9}, {
   3.4928387393419533`*^9, 3.4928388738453894`*^9}, {3.4928392099891806`*^9, 
   3.4928392282724123`*^9}, {3.4928392656204743`*^9, 3.492839265890475*^9}, {
   3.4928393374405746`*^9, 3.492839337970576*^9}, 3.4928413413933806`*^9, {
   3.4929976285885324`*^9, 3.492997657401783*^9}, {3.4929982343063965`*^9, 
   3.492998284850485*^9}, {3.4929983307925663`*^9, 3.4929983346145725`*^9}, {
   3.4929983685134325`*^9, 3.492998380915454*^9}, {3.4929985595281687`*^9, 
   3.492998559886969*^9}, {3.4929986169674697`*^9, 3.4929986552187366`*^9}, {
   3.493145648214026*^9, 3.493145651704031*^9}, {3.493174757504002*^9, 
   3.4931747608840065`*^9}, {3.4932344939779553`*^9, 3.493234517877989*^9}, {
   3.4932345822880793`*^9, 3.4932345974581003`*^9}, {3.493234635668154*^9, 
   3.4932346995382433`*^9}, {3.4932349951286573`*^9, 3.493235049278733*^9}, {
   3.4935810501216593`*^9, 3.4935810521316624`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.479616001935333*^9, 3.4796867203444157`*^9, {3.479687071148848*^9, 
   3.479687071399208*^9}, 3.4928222618129525`*^9, 3.4928258304168224`*^9, {
   3.4929226804037867`*^9, 3.4929226942254105`*^9}, {3.492979990624321*^9, 
   3.4929799910143223`*^9}, {3.493060035696517*^9, 3.4930600483865347`*^9}, 
   3.493253406025427*^9, 3.493274216811039*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Reciprocal rule for integration", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.49652737814176*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.493251623431094*^9, 3.493251640965525*^9}, {
   3.4932516789671917`*^9, 3.4932517129752517`*^9}, {3.4932533772433767`*^9, 
   3.4932533782729783`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], 
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"Log", "[", 
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "]"}], 
      RowBox[{"a", " ", "c"}]]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.4927459475946445`*^9, 3.49274596552767*^9}, {
   3.4927470791633663`*^9, 3.492747100502587*^9}, {3.492838456185856*^9, 
   3.492838468151077*^9}, {3.4928389429535108`*^9, 3.492838996648805*^9}, {
   3.492839156730687*^9, 3.4928391643123*^9}, 3.4928403497119923`*^9, {
   3.492908275826866*^9, 3.4929083226469316`*^9}, 3.492910391739828*^9, {
   3.49299802556243*^9, 3.492998081316928*^9}, {3.4932341813675175`*^9, 
   3.4932341825075192`*^9}, {3.4932342504576144`*^9, 3.493234254887621*^9}, {
   3.4932342987776823`*^9, 3.493234348687752*^9}, {3.4932348327784295`*^9, 
   3.4932348796784954`*^9}, 3.4932349106485386`*^9, 3.4933189471337347`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], ")"}], "*", 
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", "*", "x"}], "]"}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"a", "*", "c"}], ")"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.492924584761531*^9, 
   3.4929246531208515`*^9}, {3.4929246982205305`*^9, 3.4929247046789417`*^9}, 
   3.492924739529403*^9, {3.492985420001458*^9, 3.492985475178755*^9}, {
   3.493059939356382*^9, 3.493059968846423*^9}, {3.4930601293866477`*^9, 
   3.493060137446659*^9}, 3.4930603905470133`*^9, {3.4930623946218204`*^9, 
   3.49306243701188*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Power rule for integration", "Subsubsection",
 CellChangeTimes->{3.4937489112350025`*^9}],

Cell[TextData[{
 "Rule:",
 " If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, 3.4929244021788106`*^9, {
   3.493060093566598*^9, 3.4930601027066107`*^9}, {3.4932563547390933`*^9, 
   3.493256358729099*^9}, {3.4932563891491413`*^9, 3.4932563891491413`*^9}, {
   3.493581280781983*^9, 3.4935812915719976`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], 
       RowBox[{"n", "+", "1"}]], 
      RowBox[{"a", " ", "c", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.4927459475946445`*^9, 3.49274596552767*^9}, {
   3.4927470791633663`*^9, 3.492747100502587*^9}, {3.492838456185856*^9, 
   3.492838468151077*^9}, {3.4928389429535108`*^9, 3.492838996648805*^9}, {
   3.492839156730687*^9, 3.4928391643123*^9}, 3.4928403497119923`*^9, {
   3.492908275826866*^9, 3.4929083226469316`*^9}, 3.492910391739828*^9, {
   3.49299802556243*^9, 3.492998081316928*^9}, {3.4932341813675175`*^9, 
   3.4932341825075192`*^9}, {3.4932342504576144`*^9, 3.493234254887621*^9}, {
   3.4932342987776823`*^9, 3.493234348687752*^9}, {3.4932348327784295`*^9, 
   3.4932348796784954`*^9}, 3.4932349106485386`*^9, {3.4933189471337347`*^9, 
   3.4933189614337544`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
     RowBox[{"(", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", "*", "x"}], "]"}], "^", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}], "/", 
    RowBox[{"(", 
     RowBox[{"a", "*", "c", "*", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.492924584761531*^9, 
   3.4929246531208515`*^9}, {3.4929246982205305`*^9, 3.4929247046789417`*^9}, 
   3.492924739529403*^9, {3.492985420001458*^9, 3.492985475178755*^9}, {
   3.493059939356382*^9, 3.493059968846423*^9}, {3.4930601293866477`*^9, 
   3.493060137446659*^9}, 3.4930603905470133`*^9, {3.4935810024215927`*^9, 
   3.4935810041415954`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.492802747642827*^9, 
   3.492802751137233*^9}, 3.4928222777249804`*^9, 3.492825819138003*^9, {
   3.492830644352556*^9, 3.492830644712557*^9}, {3.4928404670121565`*^9, 
   3.492840467502157*^9}, 3.4929133195939274`*^9, 3.4931664671723957`*^9, 
   3.493251887352358*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["x", 
    RowBox[{"1", "-", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["x", "2"]}]}]], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", 
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["x", "2"]}]}], ")"}]}]]}], "+", 
    FractionBox["1", 
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"a", " ", "x"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, 
   3.49290371904314*^9, {3.493790149041623*^9, 3.493790149041623*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.493251623431094*^9, 3.493251640965525*^9}, {
   3.4932516789671917`*^9, 3.4932517129752517`*^9}, {3.4935813034320145`*^9, 
   3.4935813034320145`*^9}, {3.493581363142098*^9, 3.493581363142098*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", " ", 
      SuperscriptBox[
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"ArcTanh", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "+", "1"}]], 
       RowBox[{"d", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", " ", "c"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"1", "-", 
       RowBox[{"a", " ", "x"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.4927426625007477`*^9, 3.492742662695759*^9}, {
   3.4927427022060184`*^9, 3.4927427689718375`*^9}, {3.49274284243804*^9, 
   3.492742899943329*^9}, {3.4927429432068033`*^9, 3.49274296955731*^9}, 
   3.4927430042452946`*^9, {3.4927431140225735`*^9, 3.4927431953072224`*^9}, {
   3.492743302802371*^9, 3.492743321909464*^9}, {3.49274365403046*^9, 
   3.492743699403055*^9}, {3.4927438451893935`*^9, 3.4927438547469406`*^9}, {
   3.492743907312947*^9, 3.4927439763068933`*^9}, {3.4927441805245733`*^9, 
   3.4927442303734245`*^9}, {3.492744267490548*^9, 3.4927442920949554`*^9}, {
   3.492744353045441*^9, 3.492744384969267*^9}, {3.492744450696027*^9, 
   3.4927444509000387`*^9}, {3.492744509440387*^9, 3.4927445278794413`*^9}, {
   3.4927446880156*^9, 3.492744707778731*^9}, {3.492745634407731*^9, 
   3.492745768275388*^9}, 3.492746696296468*^9, {3.4927468384145966`*^9, 
   3.492746872356538*^9}, {3.492839388040646*^9, 3.4928394598207464`*^9}, 
   3.4928397046810894`*^9, {3.492908081426594*^9, 3.4929081433866806`*^9}, 
   3.492910389019825*^9, {3.493251753613323*^9, 3.493251782301773*^9}, {
   3.4932518158262324`*^9, 3.493251846137086*^9}, {3.493412510259725*^9, 
   3.4934125193197374`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", "c"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"a", "*", "x"}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.4928394899907885`*^9, 3.492839600870944*^9}, {
   3.492839660371027*^9, 3.492839670511041*^9}, {3.492839872431324*^9, 
   3.492839876241329*^9}, 3.4928399970514984`*^9, 3.49284133392337*^9, {
   3.492841789364008*^9, 3.492841792164012*^9}, {3.4934125901798368`*^9, 
   3.4934125945498433`*^9}, {3.493580989441575*^9, 3.493580991871578*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}], ")"}]}]], "=", 
   RowBox[{
    FractionBox["a", 
     RowBox[{"1", "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["x", "2"]}]}]], "+", 
    FractionBox["1", 
     RowBox[{"x", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"a", " ", "x"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, 
   3.49290371904314*^9, {3.49316782040429*^9, 3.4931678273342996`*^9}, {
   3.4931678584343433`*^9, 3.4931678962243958`*^9}, {3.4931679645244913`*^9, 
   3.493167967024495*^9}, {3.4931679986345396`*^9, 3.4931680026345453`*^9}, {
   3.4937901559116325`*^9, 3.4937901559116325`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.4931675717539415`*^9, 3.493167580513954*^9}, {
   3.493251958004882*^9, 3.493251958004882*^9}, {3.493581307982021*^9, 
   3.493581307982021*^9}, {3.493581358752092*^9, 3.493581358752092*^9}, {
   3.4937489859591336`*^9, 3.493748987300736*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"x", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"ArcTanh", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "+", "1"}]], 
       RowBox[{"c", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"x", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"a", " ", "x"}]}], ")"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.4927426625007477`*^9, 3.492742662695759*^9}, {
   3.4927427022060184`*^9, 3.4927427689718375`*^9}, {3.49274284243804*^9, 
   3.492742899943329*^9}, {3.4927429432068033`*^9, 3.49274296955731*^9}, 
   3.4927430042452946`*^9, {3.4927431140225735`*^9, 3.4927431953072224`*^9}, {
   3.492743302802371*^9, 3.492743321909464*^9}, {3.49274365403046*^9, 
   3.492743699403055*^9}, {3.4927438451893935`*^9, 3.4927438547469406`*^9}, {
   3.492743907312947*^9, 3.4927439763068933`*^9}, {3.4927441805245733`*^9, 
   3.4927442303734245`*^9}, {3.492744267490548*^9, 3.4927442920949554`*^9}, {
   3.492744353045441*^9, 3.492744384969267*^9}, {3.492744450696027*^9, 
   3.4927444509000387`*^9}, {3.492744509440387*^9, 3.4927445278794413`*^9}, {
   3.4927446880156*^9, 3.492744707778731*^9}, {3.492745634407731*^9, 
   3.492745768275388*^9}, 3.492746696296468*^9, {3.4927468384145966`*^9, 
   3.492746872356538*^9}, {3.492839388040646*^9, 3.4928394598207464`*^9}, 
   3.4928397046810894`*^9, {3.492908081426594*^9, 3.4929081433866806`*^9}, 
   3.492910389019825*^9, {3.4931674144637213`*^9, 3.493167425813738*^9}, {
   3.493167688434105*^9, 3.4931676930941114`*^9}, {3.4932519872549334`*^9, 
   3.4932520116689763`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
     RowBox[{"(", 
      RowBox[{"x_", "*", 
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], ")"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"c", "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
         RowBox[{"(", 
          RowBox[{"x", "*", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"a", "*", "x"}]}], ")"}]}], ")"}]}], ",", "x"}], "]"}]}],
      "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.4928394899907885`*^9, 3.492839600870944*^9}, {
   3.492839660371027*^9, 3.492839670511041*^9}, {3.492839872431324*^9, 
   3.492839876241329*^9}, 3.4928399970514984`*^9, 3.49284133392337*^9, {
   3.492841789364008*^9, 3.492841792164012*^9}, {3.4931675895939665`*^9, 
   3.49316759898398*^9}, 3.4931676669740753`*^9, {3.4931677271841593`*^9, 
   3.493167763914211*^9}, {3.493580981641564*^9, 3.493580983581567*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}], ")"}]}]], "=", 
   RowBox[{
    FractionBox["a", 
     RowBox[{"1", "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["x", "2"]}]}]], "+", 
    FractionBox["1", 
     RowBox[{"x", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"a", " ", "x"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, 
   3.49290371904314*^9, {3.49316782040429*^9, 3.4931678273342996`*^9}, {
   3.4931678584343433`*^9, 3.4931678962243958`*^9}, {3.4931679645244913`*^9, 
   3.493167967024495*^9}, {3.4931679986345396`*^9, 3.4931680026345453`*^9}, {
   3.4937901612916403`*^9, 3.4937901612916403`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.4931675717539415`*^9, 3.493167580513954*^9}, {
   3.493251958004882*^9, 3.493251958004882*^9}, {3.493581312932028*^9, 
   3.493581312932028*^9}, {3.4935813544820857`*^9, 3.4935813544820857`*^9}, {
   3.4937490542092533`*^9, 3.4937490549580545`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{
      RowBox[{"c", " ", "x"}], "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "3"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"ArcTanh", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "+", "1"}]], 
       RowBox[{"c", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"x", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"a", " ", "x"}]}], ")"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.4927426625007477`*^9, 3.492742662695759*^9}, {
   3.4927427022060184`*^9, 3.4927427689718375`*^9}, {3.49274284243804*^9, 
   3.492742899943329*^9}, {3.4927429432068033`*^9, 3.49274296955731*^9}, 
   3.4927430042452946`*^9, {3.4927431140225735`*^9, 3.4927431953072224`*^9}, {
   3.492743302802371*^9, 3.492743321909464*^9}, {3.49274365403046*^9, 
   3.492743699403055*^9}, {3.4927438451893935`*^9, 3.4927438547469406`*^9}, {
   3.492743907312947*^9, 3.4927439763068933`*^9}, {3.4927441805245733`*^9, 
   3.4927442303734245`*^9}, {3.492744267490548*^9, 3.4927442920949554`*^9}, {
   3.492744353045441*^9, 3.492744384969267*^9}, {3.492744450696027*^9, 
   3.4927444509000387`*^9}, {3.492744509440387*^9, 3.4927445278794413`*^9}, {
   3.4927446880156*^9, 3.492744707778731*^9}, {3.492745634407731*^9, 
   3.492745768275388*^9}, 3.492746696296468*^9, {3.4927468384145966`*^9, 
   3.492746872356538*^9}, {3.492839388040646*^9, 3.4928394598207464`*^9}, 
   3.4928397046810894`*^9, {3.492908081426594*^9, 3.4929081433866806`*^9}, 
   3.492910389019825*^9, {3.4931674144637213`*^9, 3.493167425813738*^9}, {
   3.493167688434105*^9, 3.4931676930941114`*^9}, {3.4932519872549334`*^9, 
   3.4932520116689763`*^9}, 3.493252152092824*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c_.", "*", "x_"}], "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "3"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"c", "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
         RowBox[{"(", 
          RowBox[{"x", "*", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"a", "*", "x"}]}], ")"}]}], ")"}]}], ",", "x"}], "]"}]}],
      "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.4928394899907885`*^9, 3.492839600870944*^9}, {
   3.492839660371027*^9, 3.492839670511041*^9}, {3.492839872431324*^9, 
   3.492839876241329*^9}, 3.4928399970514984`*^9, 3.49284133392337*^9, {
   3.492841789364008*^9, 3.492841792164012*^9}, {3.4931675895939665`*^9, 
   3.49316759898398*^9}, 3.4931676669740753`*^9, {3.4931677271841593`*^9, 
   3.493167763914211*^9}, {3.4931684204151297`*^9, 3.4931684392651567`*^9}, {
   3.4935809755915556`*^9, 3.4935809770915575`*^9}, {3.493789934431322*^9, 
   3.493789945661338*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "2"], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], "=", 
   RowBox[{
    FractionBox["1", "d"], "-", 
    FractionBox["c", 
     RowBox[{"d", " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, 
   3.49290371904314*^9, {3.49316782040429*^9, 3.4931678273342996`*^9}, {
   3.4931678584343433`*^9, 3.4931678962243958`*^9}, {3.4931679645244913`*^9, 
   3.493167967024495*^9}, {3.4931679986345396`*^9, 3.4931680026345453`*^9}, 
   3.493790063331503*^9, 3.4937901678516493`*^9, {3.4937902960118284`*^9, 
   3.4937902973518305`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "0", " "}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, 
   3.4929827292027316`*^9, {3.493165973371704*^9, 3.493166003201746*^9}, {
   3.4931661009618826`*^9, 3.493166101641884*^9}, {3.4932522145709333`*^9, 
   3.4932522145709333`*^9}, {3.493581315932032*^9, 3.493581315932032*^9}, {
   3.493581349432079*^9, 3.493581349432079*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "m"], 
      SuperscriptBox[
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "d"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["x", 
       RowBox[{"m", "-", "2"}]], 
      SuperscriptBox[
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["c", "d"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "-", "2"}]], 
       SuperscriptBox[
        RowBox[{"ArcTanh", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493166154681958*^9, 3.4931662030820255`*^9}, 
   3.4931666207326107`*^9, {3.4932522463481894`*^9, 3.49325228099585*^9}, {
   3.4933158052693357`*^9, 3.4933158328693743`*^9}, {3.4933190308138514`*^9, 
   3.493319134053996*^9}, {3.4933192438441496`*^9, 3.4933192445541506`*^9}, {
   3.4933193363142796`*^9, 3.4933193414042864`*^9}, {3.493412534339759*^9, 
   3.493412536469762*^9}, {3.493789994101406*^9, 3.493790017041438*^9}, {
   3.4937903432618947`*^9, 3.4937903499119043`*^9}, {3.493791019842842*^9, 
   3.4937910517128863`*^9}, 3.493791106992964*^9, 3.49379132604327*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "d"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"c", "/", "d"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"ArcTanh", "[", 
            RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929236652023163`*^9, 3.49292366743312*^9}, 
   3.4929802336571484`*^9, {3.492982933672291*^9, 3.4929829505983205`*^9}, {
   3.4929832472016416`*^9, 3.4929833842790823`*^9}, {3.4929834529036026`*^9, 
   3.4929834542764053`*^9}, {3.493166117311906*^9, 3.493166138981936*^9}, {
   3.4931662751621265`*^9, 3.4931663186221876`*^9}, {3.4934126182898765`*^9, 
   3.493412622519882*^9}, {3.4935809700815477`*^9, 3.4935809719615507`*^9}, {
   3.493791136533005*^9, 3.4937911896730795`*^9}, 3.4937912549331713`*^9, {
   3.4938402453864017`*^9, 3.4938402484908075`*^9}, 3.4940033028454423`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], "=", 
   RowBox[{
    FractionBox["1", "c"], "-", 
    FractionBox[
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}], 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, 
   3.49290371904314*^9, {3.49316782040429*^9, 3.4931678273342996`*^9}, {
   3.4931678584343433`*^9, 3.4931678962243958`*^9}, {3.4931679645244913`*^9, 
   3.493167967024495*^9}, {3.4931679986345396`*^9, 3.4931680026345453`*^9}, 
   3.493790063331503*^9, 3.4937901678516493`*^9, {3.4937902960118284`*^9, 
   3.4937902973518305`*^9}, {3.493857825015731*^9, 3.4938578494057655`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.4929828355013185`*^9, 3.492982837903723*^9}, {
   3.493165951941674*^9, 3.493165958321683*^9}, 3.4931660117517576`*^9, {
   3.493252219687742*^9, 3.493252219687742*^9}, {3.4935813186420355`*^9, 
   3.493581344402072*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "m"], 
      SuperscriptBox[
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "c"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["x", "m"], 
      SuperscriptBox[
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["d", "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "+", "2"}]], 
       SuperscriptBox[
        RowBox[{"ArcTanh", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493166154681958*^9, 3.4931662030820255`*^9}, 
   3.4931666207326107`*^9, {3.4932522463481894`*^9, 3.49325228099585*^9}, {
   3.4933158052693357`*^9, 3.4933158328693743`*^9}, {3.4933190308138514`*^9, 
   3.493319134053996*^9}, {3.4933192438441496`*^9, 3.4933192445541506`*^9}, {
   3.4933193363142796`*^9, 3.4933193414042864`*^9}, {3.493412534339759*^9, 
   3.493412536469762*^9}, {3.493789994101406*^9, 3.493790017041438*^9}, {
   3.4937903432618947`*^9, 3.4937903499119043`*^9}, {3.493791019842842*^9, 
   3.4937910517128863`*^9}, 3.493791106992964*^9, 3.49379132604327*^9, {
   3.4937915274235525`*^9, 3.493791535933564*^9}, {3.4937916827437696`*^9, 
   3.4937916869037757`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"d", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"ArcTanh", "[", 
            RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929236652023163`*^9, 3.49292366743312*^9}, 
   3.4929802336571484`*^9, {3.492982933672291*^9, 3.4929829505983205`*^9}, {
   3.4929832472016416`*^9, 3.4929833842790823`*^9}, {3.4929834529036026`*^9, 
   3.4929834542764053`*^9}, {3.493166117311906*^9, 3.493166138981936*^9}, {
   3.4931662751621265`*^9, 3.4931663186221876`*^9}, {3.4934126182898765`*^9, 
   3.493412622519882*^9}, {3.4935809700815477`*^9, 3.4935809719615507`*^9}, {
   3.493791136533005*^9, 3.4937911896730795`*^9}, 3.4937912549331713`*^9, {
   3.4938403406557693`*^9, 3.4938403671446157`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection"],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 " or ",
 Cell[BoxData[
  RowBox[{"a", ">", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
    RowBox[{"1", "-", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["x", "2"]}]}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Tanh", "[", 
        RowBox[{"ArcTanh", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "]"}], "m"], " ", 
      SuperscriptBox[
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], " "}], 
     SuperscriptBox["a", 
      RowBox[{"m", "+", "1"}]]], 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}]}]}]], "Input",
  CellChangeTimes->{{3.4935757447002296`*^9, 3.493575793020297*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664448654022*^9, 3.479664485386842*^9, {3.4796905699999485`*^9, 
   3.4796905930330687`*^9}, {3.493066205237155*^9, 3.493066233807195*^9}, {
   3.493067002288271*^9, 3.493067007218278*^9}, {3.4930671665685015`*^9, 
   3.4930671719285088`*^9}, {3.493575564069977*^9, 3.4935756424400864`*^9}, {
   3.4935756959401617`*^9, 3.49357570903018*^9}, {3.4935758049403143`*^9, 
   3.493575809750321*^9}, {3.493575842110366*^9, 3.4935758494003763`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
    RowBox[{"0", " ", "\[And]", " ", "m"}]}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "\[Or]", " ", 
      RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}], ")"}], " ",
     "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[Or]", 
      " ", 
      RowBox[{"a", ">", "0"}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930669874082503`*^9, 
   3.4930669888982525`*^9}, {3.4932562746689816`*^9, 
   3.4932562746689816`*^9}, {3.493256683249553*^9, 3.4932567141395965`*^9}, {
   3.493484196390273*^9, 3.493484198590276*^9}, {3.4934849126412754`*^9, 
   3.493484912921276*^9}, {3.4934858273225565`*^9, 3.4934858277825565`*^9}, {
   3.4934858606226025`*^9, 3.493485878442628*^9}, {3.493485980752771*^9, 
   3.493486013532817*^9}, 3.4934861613430243`*^9, {3.4935745424185467`*^9, 
   3.4935745428285475`*^9}, {3.4935745924186163`*^9, 3.493574622528659*^9}, {
   3.4935750227192187`*^9, 3.4935750542492633`*^9}, {3.493576012220604*^9, 
   3.493576016990611*^9}, {3.4935813225620413`*^9, 3.4935813359920597`*^9}, {
   3.493584208106081*^9, 3.4935842115060854`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      RowBox[{
       SuperscriptBox["a", 
        RowBox[{"m", "+", "1"}]], "c"}]]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", "n"], 
       SuperscriptBox[
        RowBox[{"Tanh", "[", "x", "]"}], "m"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579733429823`*^9, 3.4796580025249443`*^9}, {
   3.4796580760106115`*^9, 3.479658076961979*^9}, {3.479658170546547*^9, 
   3.47965817467248*^9}, {3.4796583692823153`*^9, 3.4796583839634256`*^9}, {
   3.4796584934408464`*^9, 3.479658497486664*^9}, {3.479661194084181*^9, 
   3.47966122030188*^9}, 3.479661392649704*^9, {3.4796614543984947`*^9, 
   3.4796614565015182`*^9}, {3.4796616029320755`*^9, 3.47966160861024*^9}, 
   3.479661772305622*^9, 3.47966185512471*^9, {3.4796624643307056`*^9, 
   3.4796624837586412`*^9}, {3.4796684805015345`*^9, 3.479668482213997*^9}, {
   3.47968672053469*^9, 3.479686720544704*^9}, {3.4796906638949633`*^9, 
   3.479690664315568*^9}, {3.479690714507741*^9, 3.4796907460130434`*^9}, 
   3.480705514654872*^9, {3.4930650337755156`*^9, 3.493065049545537*^9}, {
   3.4930657623365355`*^9, 3.4930657881965714`*^9}, {3.4930663212373176`*^9, 
   3.493066363577377*^9}, {3.493066963568217*^9, 3.493066975738234*^9}, 
   3.4932537469796257`*^9, 3.493256113988756*^9, {3.4932567461396413`*^9, 
   3.4932567491696453`*^9}, 3.493484110810153*^9, {3.4934842003402786`*^9, 
   3.4934842033302827`*^9}, {3.4934849452513213`*^9, 3.493484979331369*^9}, {
   3.493574446028412*^9, 3.493574506118496*^9}, {3.4935746795187387`*^9, 
   3.493574682028742*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "^", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], "*", "c"}], ")"}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "n"}], "*", 
          RowBox[{
           RowBox[{"Tanh", "[", "x", "]"}], "^", "m"}]}], ",", "x"}], "]"}], 
       ",", "x", ",", 
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", "*", "x"}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "||", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}], ")"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "m", "]"}], " ", "||", " ", 
      RowBox[{"PositiveQ", "[", "a", "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.493065103075612*^9, 3.493065290765875*^9}, {
   3.493065714046468*^9, 3.493065729586489*^9}, {3.4930658063465967`*^9, 
   3.4930658068865976`*^9}, {3.493067047288334*^9, 3.493067049548337*^9}, {
   3.4930670867783895`*^9, 3.493067112388425*^9}, {3.4930674070088377`*^9, 
   3.4930674148588486`*^9}, {3.4930676846992264`*^9, 
   3.4930676962292423`*^9}, {3.493484206670287*^9, 3.4934842155203*^9}, 
   3.4934861347329865`*^9, {3.49348619445307*^9, 3.493486231663122*^9}, {
   3.4934862761831846`*^9, 3.4934862874732003`*^9}, {3.4935748506089783`*^9, 
   3.4935750140392065`*^9}, {3.4935759916505756`*^9, 3.493575995420581*^9}, 
   3.4935766556615047`*^9, 3.493576706471576*^9, {3.493580958311531*^9, 
   3.493580960351534*^9}, {3.4935842485261374`*^9, 3.4935842501161394`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
    RowBox[{"1", "-", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["x", "2"]}]}]], "=", 
   RowBox[{
    FractionBox["1", "a"], 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"Tanh", "[", 
        RowBox[{"ArcTanh", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "]"}], "a"], ")"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}]}]}]], "Input",
  CellChangeTimes->{{3.4935757447002296`*^9, 3.493575793020297*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664448654022*^9, 3.479664485386842*^9, {3.4796905699999485`*^9, 
   3.4796905930330687`*^9}, {3.493066205237155*^9, 3.493066233807195*^9}, {
   3.493067002288271*^9, 3.493067007218278*^9}, {3.4930671665685015`*^9, 
   3.4930671719285088`*^9}, {3.493575564069977*^9, 3.4935756424400864`*^9}, {
   3.4935756959401617`*^9, 3.49357570903018*^9}, {3.4935758049403143`*^9, 
   3.493575809750321*^9}, {3.493575842110366*^9, 3.4935758494003763`*^9}, {
   3.4935761209707565`*^9, 3.493576167880822*^9}, {3.493576511191303*^9, 
   3.493576539971343*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
    RowBox[{"0", " ", "\[And]", " ", "m"}]}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "\[Or]", " ", 
      RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}], ")"}], " ",
     "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[Or]", 
       " ", 
       RowBox[{"a", ">", "0"}]}], ")"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930669874082503`*^9, 
   3.4930669888982525`*^9}, {3.4932562746689816`*^9, 
   3.4932562746689816`*^9}, {3.493256683249553*^9, 3.4932567141395965`*^9}, {
   3.493484196390273*^9, 3.493484198590276*^9}, {3.4934849126412754`*^9, 
   3.493484912921276*^9}, {3.4934858273225565`*^9, 3.4934858277825565`*^9}, {
   3.4934858606226025`*^9, 3.493485878442628*^9}, {3.493485980752771*^9, 
   3.493486013532817*^9}, 3.4934861613430243`*^9, {3.4935745424185467`*^9, 
   3.4935745428285475`*^9}, {3.4935745924186163`*^9, 3.493574622528659*^9}, {
   3.4935750227192187`*^9, 3.4935750542492633`*^9}, {3.493576012220604*^9, 
   3.493576016990611*^9}, 3.493576288350991*^9, {3.493581325842046*^9, 
   3.4935813317720537`*^9}, {3.4935842190960965`*^9, 3.4935842227961016`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      RowBox[{"a", " ", "c"}]]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", "n"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox[
          RowBox[{"Tanh", "[", "x", "]"}], "a"], ")"}], "m"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579733429823`*^9, 3.4796580025249443`*^9}, {
   3.4796580760106115`*^9, 3.479658076961979*^9}, {3.479658170546547*^9, 
   3.47965817467248*^9}, {3.4796583692823153`*^9, 3.4796583839634256`*^9}, {
   3.4796584934408464`*^9, 3.479658497486664*^9}, {3.479661194084181*^9, 
   3.47966122030188*^9}, 3.479661392649704*^9, {3.4796614543984947`*^9, 
   3.4796614565015182`*^9}, {3.4796616029320755`*^9, 3.47966160861024*^9}, 
   3.479661772305622*^9, 3.47966185512471*^9, {3.4796624643307056`*^9, 
   3.4796624837586412`*^9}, {3.4796684805015345`*^9, 3.479668482213997*^9}, {
   3.47968672053469*^9, 3.479686720544704*^9}, {3.4796906638949633`*^9, 
   3.479690664315568*^9}, {3.479690714507741*^9, 3.4796907460130434`*^9}, 
   3.480705514654872*^9, {3.4930650337755156`*^9, 3.493065049545537*^9}, {
   3.4930657623365355`*^9, 3.4930657881965714`*^9}, {3.4930663212373176`*^9, 
   3.493066363577377*^9}, {3.493066963568217*^9, 3.493066975738234*^9}, 
   3.4932537469796257`*^9, 3.493256113988756*^9, {3.4932567461396413`*^9, 
   3.4932567491696453`*^9}, 3.493484110810153*^9, {3.4934842003402786`*^9, 
   3.4934842033302827`*^9}, {3.4934849452513213`*^9, 3.493484979331369*^9}, {
   3.493574446028412*^9, 3.493574506118496*^9}, {3.4935746795187387`*^9, 
   3.493574682028742*^9}, {3.4935764123011646`*^9, 3.493576431451191*^9}, {
   3.4935764737712507`*^9, 3.493576478761257*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c"}], ")"}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "n"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Tanh", "[", "x", "]"}], "/", "a"}], ")"}], "^", "m"}]}],
          ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", "*", "x"}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "||", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}], ")"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "m", "]"}], " ", "||", " ", 
      RowBox[{"PositiveQ", "[", "a", "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.493065103075612*^9, 3.493065290765875*^9}, {
   3.493065714046468*^9, 3.493065729586489*^9}, {3.4930658063465967`*^9, 
   3.4930658068865976`*^9}, {3.493067047288334*^9, 3.493067049548337*^9}, {
   3.4930670867783895`*^9, 3.493067112388425*^9}, {3.4930674070088377`*^9, 
   3.4930674148588486`*^9}, {3.4930676846992264`*^9, 
   3.4930676962292423`*^9}, {3.493484206670287*^9, 3.4934842155203*^9}, 
   3.4934861304629803`*^9, 3.4934861903430643`*^9, {3.4934862534031525`*^9, 
   3.493486262273165*^9}, {3.4934862996232176`*^9, 3.4934863089332304`*^9}, {
   3.493575978670557*^9, 3.4935759803305597`*^9}, {3.4935766168214507`*^9, 
   3.4935766805915403`*^9}, 3.493576722851599*^9, {3.493580952391523*^9, 
   3.493580954621526*^9}, {3.493584242456129*^9, 3.493584244676132*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
     RowBox[{"ArcTanh", "[", "u", "]"}]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.492802747642827*^9, 
   3.492802751137233*^9}, 3.4928222777249804`*^9, 3.492825819138003*^9, {
   3.492830644352556*^9, 3.492830644712557*^9}, {3.4928404670121565`*^9, 
   3.492840467502157*^9}, {3.492913336613951*^9, 3.492913339753956*^9}, {
   3.4931386203491883`*^9, 3.493138625887198*^9}, {3.4931387252593727`*^9, 
   3.493138727848977*^9}, 3.493143725971335*^9, 3.493252609984828*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"ArcTanh", "[", "z", "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", "z"}], "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", "z"}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664443126074*^9, 3.479664484795992*^9, {3.479686720494632*^9, 
   3.479686740223*^9}, {3.4929978496877213`*^9, 3.4929978567233334`*^9}, {
   3.4929979016982126`*^9, 3.492997933194668*^9}, 3.4929979741135397`*^9, {
   3.4931396589834127`*^9, 3.4931396914158697`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["u", "2"], "=", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["2", 
            RowBox[{"1", "+", 
             RowBox[{"a", " ", "x"}]}]]}], ")"}], "2"], " ", "\[Or]", "  ", 
        SuperscriptBox["u", "2"]}], "=", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          FractionBox["2", 
           RowBox[{"1", "-", 
            RowBox[{"a", " ", "x"}]}]]}], ")"}], "2"]}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4930957381510735`*^9, 3.493095777731129*^9}, {3.4930962548817973`*^9, 
   3.493096255481798*^9}, {3.493139493669922*^9, 3.493139531063188*^9}, {
   3.493252668562931*^9, 3.493252668562931*^9}, {3.4935814042921553`*^9, 
   3.493581413882169*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
      RowBox[{"ArcTanh", "[", "u", "]"}]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "2"]}]}], " ", 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"ArcTanh", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
        RowBox[{"Log", "[", 
         RowBox[{"1", "+", "u"}], "]"}]}], 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcTanh", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
       RowBox[{"Log", "[", 
        RowBox[{"1", "-", "u"}], "]"}]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.492982817124486*^9, 3.4929828178576875`*^9}, 
   3.4931655191410685`*^9, 3.493166624072615*^9, {3.493252259202612*^9, 
   3.4932522639918203`*^9}, {3.493252361117591*^9, 3.493252364440397*^9}, 
   3.4933156800291605`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "*", 
     RowBox[{
      RowBox[{"ArcTanh", "[", "u_", "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"1", "+", "u"}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"1", "-", "u"}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"ZeroQ", "[", 
       RowBox[{
        RowBox[{"u", "^", "2"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", "/", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"a", "*", "x"}]}], ")"}]}]}], ")"}], "^", "2"}]}], 
       "]"}], " ", "||", " ", 
      RowBox[{"ZeroQ", "[", 
       RowBox[{
        RowBox[{"u", "^", "2"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", "/", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"a", "*", "x"}]}], ")"}]}]}], ")"}], "^", "2"}]}], 
       "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.4928381673513484`*^9, 
   3.4928381717973566`*^9}, {3.492838221982644*^9, 3.492838250608695*^9}, {
   3.492840280811896*^9, 3.492840287331905*^9}, 3.4928413614234085`*^9, {
   3.493138538807845*^9, 3.4931385448294554`*^9}, {3.493139257267107*^9, 
   3.4931393087783976`*^9}, 3.4931393776681185`*^9, {3.493139438976226*^9, 
   3.4931394493814445`*^9}, {3.4935814251121845`*^9, 3.493581427492188*^9}, {
   3.494029178914469*^9, 3.494029183606737*^9}, {3.4940393228302393`*^9, 
   3.494039326454447*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
     RowBox[{"Log", "[", "u", "]"}]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.492802747642827*^9, 
   3.492802751137233*^9}, 3.4928222777249804`*^9, 3.492825819138003*^9, {
   3.492830644352556*^9, 3.492830644712557*^9}, {3.4928404670121565`*^9, 
   3.492840467502157*^9}, {3.492913336613951*^9, 3.492913339753956*^9}, 
   3.4931436949112916`*^9, 3.493252774143916*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "u"}], ")"}], "2"]}], "=", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       FractionBox["2", 
        RowBox[{"1", "+", 
         RowBox[{"a", " ", "x"}]}]]}], ")"}], "2"]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4930957381510735`*^9, 3.493095777731129*^9}, {3.4930962548817973`*^9, 
   3.493096255481798*^9}, {3.4930966874724026`*^9, 3.493096711762437*^9}, {
   3.4930967471324863`*^9, 3.493096747642487*^9}, {3.4932527496362734`*^9, 
   3.4932527496362734`*^9}, {3.493581449742219*^9, 3.493581458802232*^9}, {
   3.493581496762285*^9, 3.4935815094423027`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
      RowBox[{"Log", "[", "u", "]"}]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{" ", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
         RowBox[{"PolyLog", "[", 
          RowBox[{"2", ",", 
           RowBox[{"1", "-", "u"}]}], "]"}]}]}], 
       RowBox[{"2", "a", " ", "c"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["n", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcTanh", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"PolyLog", "[", 
        RowBox[{"2", ",", 
         RowBox[{"1", "-", "u"}]}], "]"}]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 PageWidth->Infinity,
 CellChangeTimes->{{3.492982817124486*^9, 3.4929828178576875`*^9}, 
   3.4931655191410685`*^9, 3.493166624072615*^9, {3.493252259202612*^9, 
   3.4932522639918203`*^9}, {3.493252361117591*^9, 3.493252364440397*^9}, 
   3.4933156800291605`*^9, 3.4933160671297026`*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "*", 
     RowBox[{
      RowBox[{"Log", "[", "u_", "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{"2", ",", 
        RowBox[{"1", "-", "u"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "a", "*", "c"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"PolyLog", "[", 
           RowBox[{"2", ",", 
            RowBox[{"1", "-", "u"}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "u"}], ")"}], "^", "2"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", "/", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"a", "*", "x"}]}], ")"}]}]}], ")"}], "^", "2"}]}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.4928381673513484`*^9, 
   3.4928381717973566`*^9}, {3.492838221982644*^9, 3.492838250608695*^9}, {
   3.492840280811896*^9, 3.492840287331905*^9}, 3.4928413614234085`*^9, {
   3.493138538807845*^9, 3.4931385448294554`*^9}, {3.4935814687422457`*^9, 
   3.4935814707822485`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "u"}], ")"}], "2"]}], "=", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       FractionBox["2", 
        RowBox[{"1", "-", 
         RowBox[{"a", " ", "x"}]}]]}], ")"}], "2"]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4930957381510735`*^9, 3.493095777731129*^9}, {3.4930962548817973`*^9, 
   3.493096255481798*^9}, {3.4930966874724026`*^9, 3.493096711762437*^9}, {
   3.4932527647214994`*^9, 3.4932527647214994`*^9}, {3.493581521182319*^9, 
   3.493581538282343*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
      RowBox[{"Log", "[", "u", "]"}]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
         RowBox[{"PolyLog", "[", 
          RowBox[{"2", ",", 
           RowBox[{"1", "-", "u"}]}], "]"}]}], 
        RowBox[{"2", "a", " ", "c"}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["n", "2"], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcTanh", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"PolyLog", "[", 
        RowBox[{"2", ",", 
         RowBox[{"1", "-", "u"}]}], "]"}]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 PageWidth->Infinity,
 CellChangeTimes->{{3.492982817124486*^9, 3.4929828178576875`*^9}, 
   3.4931655191410685`*^9, 3.493166624072615*^9, {3.493252259202612*^9, 
   3.4932522639918203`*^9}, {3.493252361117591*^9, 3.493252364440397*^9}, 
   3.4933156800291605`*^9, 3.4933160764997153`*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "*", 
     RowBox[{
      RowBox[{"Log", "[", "u_", "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{"2", ",", 
        RowBox[{"1", "-", "u"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "a", "*", "c"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"PolyLog", "[", 
           RowBox[{"2", ",", 
            RowBox[{"1", "-", "u"}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "u"}], ")"}], "^", "2"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", "/", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"a", "*", "x"}]}], ")"}]}]}], ")"}], "^", "2"}]}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.492840292461912*^9, 3.492840299431922*^9}, 
   3.4928413656434145`*^9, {3.4930965007921414`*^9, 3.4930965332721868`*^9}, {
   3.4935814756022553`*^9, 3.4935814775622582`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"p", ",", "u"}], "]"}]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.492802747642827*^9, 
   3.492802751137233*^9}, 3.4928222777249804`*^9, 3.492825819138003*^9, {
   3.492830644352556*^9, 3.492830644712557*^9}, {3.4928404670121565`*^9, 
   3.492840467502157*^9}, 3.492913349043969*^9, 3.4931388908692636`*^9, 
   3.493143703721304*^9, 3.4932529661958537`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
     SuperscriptBox["u", "2"]}], "=", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       FractionBox["2", 
        RowBox[{"1", "+", 
         RowBox[{"a", " ", "x"}]}]]}], ")"}], "2"]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4930957381510735`*^9, 3.493095777731129*^9}, {3.4930962548817973`*^9, 
   3.493096255481798*^9}, {3.4932531421173625`*^9, 3.4932531421173625`*^9}, {
   3.4935817370726213`*^9, 3.493581749462639*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
      RowBox[{"PolyLog", "[", 
       RowBox[{"p", ",", "u"}], "]"}]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                           ", 
      "\[IndentingNewLine]", "                                             ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
         RowBox[{"PolyLog", "[", 
          RowBox[{
           RowBox[{"p", "+", "1"}], ",", "u"}], "]"}]}], 
        RowBox[{"2", "a", " ", "c"}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["n", "2"], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcTanh", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"PolyLog", "[", 
        RowBox[{
         RowBox[{"p", "+", "1"}], ",", "u"}], "]"}]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.492982817124486*^9, 3.4929828178576875`*^9}, 
   3.4931655191410685`*^9, 3.493166624072615*^9, {3.493252259202612*^9, 
   3.4932522639918203`*^9}, {3.493252361117591*^9, 3.493252364440397*^9}, 
   3.4933156800291605`*^9, 3.4933161350697975`*^9, {3.493320303475633*^9, 
   3.493320336085679*^9}, {3.49332038699575*^9, 3.493320391165756*^9}, {
   3.4933205094659214`*^9, 3.4933205100859222`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{"p_", ",", "u_"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{
        RowBox[{"p", "+", "1"}], ",", "u"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "a", "*", "c"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"PolyLog", "[", 
           RowBox[{
            RowBox[{"p", "+", "1"}], ",", "u"}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "p"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"u", "^", "2"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", "/", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"a", "*", "x"}]}], ")"}]}]}], ")"}], "^", "2"}]}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997359719353`*^9, 3.492799760261178*^9}, {
   3.4928403040619287`*^9, 3.492840308581935*^9}, 3.492841369963421*^9, {
   3.4928426836352596`*^9, 3.492842700155283*^9}, {3.493096333451907*^9, 
   3.4930963718219604`*^9}, {3.4935817628926573`*^9, 3.4935817654026613`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
     SuperscriptBox["u", "2"]}], "=", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       FractionBox["2", 
        RowBox[{"1", "-", 
         RowBox[{"a", " ", "x"}]}]]}], ")"}], "2"]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4930957381510735`*^9, 3.493095777731129*^9}, {3.4932531464697704`*^9, 
   3.4932531464697704`*^9}, {3.4935817416826277`*^9, 3.493581754482646*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
      RowBox[{"PolyLog", "[", 
       RowBox[{"p", ",", "u"}], "]"}]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                          ", 
      "\[IndentingNewLine]", 
      "                                                ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"ArcTanh", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
        RowBox[{"PolyLog", "[", 
         RowBox[{
          RowBox[{"p", "+", "1"}], ",", "u"}], "]"}]}], 
       RowBox[{"2", "a", " ", "c"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["n", "2"], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcTanh", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"PolyLog", "[", 
        RowBox[{
         RowBox[{"p", "+", "1"}], ",", "u"}], "]"}]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.492982817124486*^9, 3.4929828178576875`*^9}, 
   3.4931655191410685`*^9, 3.493166624072615*^9, {3.493252259202612*^9, 
   3.4932522639918203`*^9}, {3.493252361117591*^9, 3.493252364440397*^9}, 
   3.4933156800291605`*^9, 3.4933161430898085`*^9, {3.493320319155655*^9, 
   3.493320327755667*^9}, {3.4933203993557673`*^9, 3.493320454915845*^9}, {
   3.4933205128259263`*^9, 3.493320513405927*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{"p_", ",", "u_"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{
        RowBox[{"p", "+", "1"}], ",", "u"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "a", "*", "c"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"PolyLog", "[", 
           RowBox[{
            RowBox[{"p", "+", "1"}], ",", "u"}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "p"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"u", "^", "2"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", "/", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"a", "*", "x"}]}], ")"}]}]}], ")"}], "^", "2"}]}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
  3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
  3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
  3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
  3.4927992401718645`*^9}, {3.4927992767227287`*^9, 3.4927993156759973`*^9}, {
  3.4927994994131203`*^9, 3.492799508102335*^9}, {3.492799544387999*^9, 
  3.4927995657444363`*^9}, {3.4927996261789427`*^9, 3.492799660327403*^9}, {
  3.4927997257383175`*^9, 3.4927997433351483`*^9}, {3.4927998179656796`*^9, 
  3.4927998331289062`*^9}, {3.49284031232194*^9, 3.4928403176719475`*^9}, {
  3.4928413736734257`*^9, 3.4928413764134293`*^9}, {3.4928427124753*^9, 
  3.4928427180953083`*^9}, {3.4930958623412476`*^9, 3.493095867661255*^9}, {
  3.493096011861457*^9, 3.4930960123514576`*^9}, {3.493581770142668*^9, 
  3.4935817729726715`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.479616025649432*^9, {3.4796162596058445`*^9, 3.479616276069518*^9}, {
   3.4796867203644447`*^9, 3.4796867380098176`*^9}, {3.4796961372252254`*^9, 
   3.4796961375256577`*^9}, 3.492822267896963*^9, 3.4928258267508163`*^9, {
   3.4932577931811075`*^9, 3.4932577998811164`*^9}, 3.493258386041937*^9, 
   3.493258450902028*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4930957381510735`*^9, 3.493095777731129*^9}, {3.4930962548817973`*^9, 
   3.493096255481798*^9}, {3.4932531421173625`*^9, 3.4932531421173625`*^9}, {
   3.493257575370802*^9, 3.493257592210826*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], " ", 
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], " ", 
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       RowBox[{"-", 
        RowBox[{"Log", "[", 
         RowBox[{"ArcCoth", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "]"}]}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"ArcTanh", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "]"}]}], 
      RowBox[{
       RowBox[{"a", " ", "c", " ", 
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a", " ", "x"}], "]"}]}], "-", 
       RowBox[{"a", " ", "c", " ", 
        RowBox[{"ArcTanh", "[", 
         RowBox[{"a", " ", "x"}], "]"}]}]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "*", 
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "*", 
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], ")"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Log", "[", 
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a", "*", "x"}], "]"}], "]"}]}], "+", 
      RowBox[{"Log", "[", 
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "]"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "*", "c", "*", 
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", "*", "x"}], "]"}]}], "-", 
      RowBox[{"a", "*", "c", "*", 
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", "*", "x"}], "]"}]}]}], ")"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.493257632750882*^9, 3.4932576963209715`*^9}, {
  3.4932577508610477`*^9, 3.493257763981066*^9}, {3.493258241061734*^9, 
  3.4932582473017426`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
    RowBox[{"0", " ", "\[And]", " ", "m"}]}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"0", "<", "n", "\[LessEqual]", "m"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.49325840970197*^9, 3.493258411811973*^9}, {
   3.4932584532120314`*^9, 3.4932584537520323`*^9}, {3.4935818687928057`*^9, 
   3.4935818687928057`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "m"], " ", 
      SuperscriptBox[
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                        ", 
      "\[IndentingNewLine]", 
      "                                               ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"ArcCoth", "[", 
          RowBox[{"a", " ", "x"}], "]"}], 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"ArcTanh", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
       RowBox[{"a", " ", "c", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["n", 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"m", "+", "1"}]], " ", 
       SuperscriptBox[
        RowBox[{"ArcTanh", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731727376`*^9, 3.4796580024348145`*^9}, {
   3.4796585662054768`*^9, 3.4796585704015102`*^9}, {3.4796611938738785`*^9, 
   3.479661220251808*^9}, 3.4796613924594307`*^9, {3.479661432957664*^9, 
   3.479661435531365*^9}, {3.4796615599302416`*^9, 3.4796615651577587`*^9}, {
   3.4796617677991424`*^9, 3.4796617978824*^9}, 3.4796618436281796`*^9, {
   3.479662183256541*^9, 3.4796621957945695`*^9}, {3.4796867203944883`*^9, 
   3.4796867402029715`*^9}, {3.4796872323406305`*^9, 3.479687270064875*^9}, {
   3.492826073390849*^9, 3.4928261527013884`*^9}, {3.492826334973708*^9, 
   3.4928263351453085`*^9}, {3.492826679349514*^9, 3.4928266798955145`*^9}, 
   3.4928267967457204`*^9, {3.4932578278611555`*^9, 3.493257905011264*^9}, {
   3.493257942631316*^9, 3.493257944461319*^9}, {3.4932580838015137`*^9, 
   3.4932580841315145`*^9}, {3.4932584146419773`*^9, 
   3.4932584213319864`*^9}, {3.4932584544720325`*^9, 3.493258456582036*^9}, {
   3.493320843336389*^9, 3.4933208585764103`*^9}, {3.4933209087264805`*^9, 
   3.4933209157664905`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "/", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"ArcTanh", "[", 
            RowBox[{"a", "*", "x"}], "]"}], "^", 
           RowBox[{"(", 
            RowBox[{"n", "-", "1"}], ")"}]}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "n", "\[LessEqual]", "m"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4932581278315754`*^9, 3.4932581781516457`*^9}, {
   3.493258211041692*^9, 3.4932582126516943`*^9}, {3.493258319821844*^9, 
   3.4932583217718472`*^9}, {3.493258425361992*^9, 3.4932584627520447`*^9}, 
   3.4935818049827166`*^9, 3.5171886367718873`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
   SuperscriptBox[
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.479616001935333*^9, 3.4796867203444157`*^9, {3.479687071148848*^9, 
   3.479687071399208*^9}, 3.4928222618129525`*^9, 3.4928258304168224`*^9, {
   3.4929226804037867`*^9, 3.4929226942254105`*^9}, {3.492979990624321*^9, 
   3.4929799910143223`*^9}, {3.493060035696517*^9, 3.4930600483865347`*^9}, 
   3.493253406025427*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"c", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930680892297926`*^9, 
   3.4930681267098455`*^9}, {3.4930771831577578`*^9, 
   3.4930771985577793`*^9}, {3.493256297489013*^9, 3.493256308149028*^9}, {
   3.4932563410290737`*^9, 3.4932563441690784`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], 
     SqrtBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", 
         RowBox[{"ArcTanh", "[", 
          RowBox[{"a", " ", "x"}], "]"}], 
         RowBox[{"ArcTan", "[", 
          FractionBox[
           SqrtBox[
            RowBox[{"1", "-", 
             RowBox[{"a", " ", "x"}]}]], 
           SqrtBox[
            RowBox[{"1", "+", 
             RowBox[{"a", " ", "x"}]}]]], "]"}]}], 
        RowBox[{"a", 
         SqrtBox["c"]}]]}]}]}]}]}], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox[
          RowBox[{"1", "-", 
           RowBox[{"a", " ", "x"}]}]]}], 
        SqrtBox[
         RowBox[{"1", "+", 
          RowBox[{"a", " ", "x"}]}]]]}]}], "]"}]}], 
   RowBox[{"a", 
    SqrtBox["c"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox[
         RowBox[{"1", "-", 
          RowBox[{"a", " ", "x"}]}]]}], 
       SqrtBox[
        RowBox[{"1", "+", 
         RowBox[{"a", " ", "x"}]}]]]}], "]"}]}], 
   RowBox[{"a", 
    SqrtBox["c"]}]]}]], "Subsubtitle",
 PageWidth->Infinity,
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.4933211646668386`*^9, {3.494025334902604*^9, 
   3.49402533797978*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a_.", "*", "x_"}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "*", 
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", "*", "x"}], "]"}], "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"1", "-", 
          RowBox[{"a", "*", "x"}]}], "]"}], "/", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"1", "+", 
          RowBox[{"a", "*", "x"}]}], "]"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", 
        RowBox[{"Sqrt", "[", "c", "]"}]}], ")"}]}]}], " ", "-", " ", 
    "\[IndentingNewLine]", "  ", 
    RowBox[{"I", "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{"2", ",", 
        RowBox[{
         RowBox[{"-", "I"}], "*", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"1", "-", 
            RowBox[{"a", "*", "x"}]}], "]"}], "/", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"1", "+", 
            RowBox[{"a", "*", "x"}]}], "]"}]}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", 
        RowBox[{"Sqrt", "[", "c", "]"}]}], ")"}]}]}], " ", "+", " ", 
    "\[IndentingNewLine]", "  ", 
    RowBox[{"I", "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{"2", ",", 
        RowBox[{"I", "*", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"1", "-", 
            RowBox[{"a", "*", "x"}]}], "]"}], "/", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"1", "+", 
            RowBox[{"a", "*", "x"}]}], "]"}]}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", 
        RowBox[{"Sqrt", "[", "c", "]"}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", "c", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.492924584761531*^9, 
   3.4929246531208515`*^9}, {3.4929246982205305`*^9, 3.4929247046789417`*^9}, 
   3.492924739529403*^9, {3.493076725417117*^9, 3.493076780277194*^9}, {
   3.4930770153775234`*^9, 3.4930770237775345`*^9}, {3.4930770970076375`*^9, 
   3.4930771129476595`*^9}, {3.4940253429230623`*^9, 3.4940253474423213`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     SqrtBox[
      RowBox[{"1", "-", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}]], 
     SqrtBox[
      RowBox[{"c", " ", "-", 
       RowBox[{"c", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664448654022*^9, 3.479664485386842*^9, {3.4796905699999485`*^9, 
   3.4796905930330687`*^9}, {3.493066205237155*^9, 3.493066233807195*^9}, {
   3.493067002288271*^9, 3.493067007218278*^9}, {3.4930671665685015`*^9, 
   3.4930671719285088`*^9}, {3.493078825992059*^9, 3.493078849422092*^9}, 
   3.4930790976224394`*^9, {3.4932536079989815`*^9, 3.4932536186070004`*^9}, {
   3.4940258056215277`*^9, 3.4940258056215277`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{"c", ">", "0"}], ")"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930680892297926`*^9, 
   3.4930681267098455`*^9}, {3.4930771831577578`*^9, 
   3.4930771985577793`*^9}, {3.493256297489013*^9, 3.493256308149028*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a", " ", "x"}], "]"}], 
    SqrtBox[
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["x", "2"]}]}]], 
      SqrtBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["x", "2"]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.4933211695768456`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a_.", "*", "x_"}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "-", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}]}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"1", "-", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "*", 
          RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PositiveQ", "[", "c", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.492924584761531*^9, 
   3.4929246531208515`*^9}, {3.4929246982205305`*^9, 3.4929247046789417`*^9}, 
   3.492924739529403*^9, {3.493076725417117*^9, 3.493076780277194*^9}, {
   3.493077825308657*^9, 3.493077828358661*^9}, {3.4930778668687153`*^9, 
   3.493077913738781*^9}, {3.493077978808872*^9, 3.493077978948872*^9}, {
   3.493079137962496*^9, 3.4930791537525177`*^9}, {3.4930802573560643`*^9, 
   3.4930802674060783`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930680892297926`*^9, 
   3.4930681267098455`*^9}, {3.4930771831577578`*^9, 
   3.4930771985577793`*^9}, {3.493256297489013*^9, 3.493256308149028*^9}, {
   3.4932565037393017`*^9, 3.4932565054493046`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox["1", 
        RowBox[{"a", " ", "c", " ", 
         SqrtBox[
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}]]}]]}]}]}]}]}], "+", 
  FractionBox[
   RowBox[{"x", " ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a", " ", "x"}], "]"}]}], 
   RowBox[{"c", 
    SqrtBox[
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]]}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.493321175446854*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a_.", "*", "x_"}], "]"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "/", 
     RowBox[{"(", 
      RowBox[{"a", "*", "c", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", 
          RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}], " ", "+", "\n", "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", 
           RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.492924584761531*^9, 
   3.4929246531208515`*^9}, {3.4929246982205305`*^9, 3.4929247046789417`*^9}, 
   3.492924739529403*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", ">", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.493057857853468*^9, 3.4930578807234993`*^9}, {3.4930589528050003`*^9, 
   3.4930589841650443`*^9}, {3.493256250928948*^9, 3.493256250928948*^9}, {
   3.493493532773344*^9, 3.493493535913348*^9}, {3.493494121514168*^9, 
   3.493494130844181*^9}, {3.4935821227231617`*^9, 3.4935821407331867`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"n", " ", 
         SuperscriptBox[
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", " ", "x"}], "]"}], 
          RowBox[{"n", "-", "1"}]]}], 
        RowBox[{"a", " ", "c", 
         SqrtBox[
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}]]}]]}]}]}]}]}], "+", 
  FractionBox[
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
   RowBox[{"c", 
    SqrtBox[
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]]}]], "+", 
  RowBox[{"n", 
   RowBox[{"(", 
    RowBox[{"n", "-", "1"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], 
       RowBox[{"n", "-", "2"}]], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], 
       RowBox[{"3", "/", "2"}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493058932894973*^9, 3.4930589343449745`*^9}, {
   3.4930590036150713`*^9, 3.493059030475109*^9}, {3.493059071585167*^9, 
   3.4930590795551777`*^9}, {3.4930628403524446`*^9, 3.49306285140246*^9}, {
   3.4932501056192265`*^9, 3.4932501067580285`*^9}, {3.493250146257298*^9, 
   3.493250186942169*^9}, {3.493256078498707*^9, 3.4932560906487236`*^9}, {
   3.4932568685898128`*^9, 3.4932568826798325`*^9}, {3.4933216732775507`*^9, 
   3.4933216957475824`*^9}, {3.4933217278376274`*^9, 3.493321760587673*^9}, 
   3.493321813507747*^9, 3.4933218644878187`*^9, {3.493321906837878*^9, 
   3.493321919617896*^9}, {3.4933220427280684`*^9, 3.493322042928068*^9}, {
   3.4934927094121914`*^9, 3.4934927441222396`*^9}, 3.493492777272286*^9, 
   3.493493493413289*^9, 3.4934935635433865`*^9, 3.493494110054152*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "n"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c", "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", 
           RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}]}], " ", "+", "\n", 
    "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", 
           RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}]}], " ", "+", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}], "/", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"3", "/", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGCQAmIQLZPyfKkF2yvHor2uy0C0gJTrKhC9aGLmMRDdo3j2
HIjmN+W7CKK/r8+5AaLT3lfdBtEvpr5nsATSehP+gunYb8c4QfSvlI9g2qfZ
WwJE52hNUAPR85i4dUF0h94NMB3z8ZMjiObY1uwEop9dOtEOos26NnWC6B+P
j96rAtIMzMqPQHTVcuGXIHpLnfxrEN29p/I9iJ4RlvwFREfMZ2GoBtJnWVeD
6XdlDGwg2iJCGEynOUvy1QBpr+crwfSN3WbJIDpr+Q4w/SMlg6cWSIumFyiD
6M7adxYg2mnOZzA9V1zDDkSn8WaC6W0dss4gOkZpPZh2nfb5sx870N8vlL+C
6MtWsdn+QFrt1ZsKEL3rFtsGEO2me38biF60QngPiD6oKw+mOW7GCFQBaXPT
JWAaAALVs04=
  "],
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.493057857853468*^9, 3.4930578807234993`*^9}, {3.4930589528050003`*^9, 
   3.4930589841650443`*^9}, {3.493256250928948*^9, 3.493256250928948*^9}, {
   3.493493532773344*^9, 3.493493535913348*^9}, {3.493582160473214*^9, 
   3.493582160473214*^9}, {3.493582259573353*^9, 3.493582259573353*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                                              \
  ", "\[IndentingNewLine]", "                        ", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"ArcTanh", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "+", "1"}]], 
       RowBox[{"a", " ", "c", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], " ", 
        SqrtBox[
         RowBox[{"c", "+", 
          RowBox[{"d", " ", 
           SuperscriptBox["x", "2"]}]}]]}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], 
     RowBox[{"n", "+", "2"}]]}], 
   RowBox[{"c", " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "2"}], ")"}], " ", 
    SqrtBox[
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]]}]], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"n", "+", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], 
       RowBox[{"n", "+", "2"}]], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], 
       RowBox[{"3", "/", "2"}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493058932894973*^9, 3.4930589343449745`*^9}, {
   3.4930590036150713`*^9, 3.493059030475109*^9}, {3.493059071585167*^9, 
   3.4930590795551777`*^9}, {3.4930628403524446`*^9, 3.49306285140246*^9}, {
   3.4932501056192265`*^9, 3.4932501067580285`*^9}, {3.493250146257298*^9, 
   3.493250186942169*^9}, {3.493256078498707*^9, 3.4932560906487236`*^9}, {
   3.4932568685898128`*^9, 3.4932568826798325`*^9}, {3.4933216732775507`*^9, 
   3.4933216957475824`*^9}, {3.4933217278376274`*^9, 3.493321760587673*^9}, 
   3.493321813507747*^9, 3.4933218644878187`*^9, {3.493321906837878*^9, 
   3.493321919617896*^9}, {3.4933220427280684`*^9, 3.493322042928068*^9}, {
   3.4934927094121914`*^9, 3.4934927441222396`*^9}, 3.493492777272286*^9, 
   3.493493493413289*^9, 3.4934935635433865`*^9, {3.4935896515237017`*^9, 
   3.4935897029137735`*^9}, {3.4935902147344904`*^9, 3.4935902271545076`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"a", "*", "c", "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", 
          RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}], " ", "-", "\n", "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", 
           RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}]}], " ", "+", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}], "/", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"3", "/", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGCQAGIQLZPyfKkF2yvHor2uy0C0gJTrKhC9aGLmMRDdo3j2
HIjmN+W7CKK/r8+5AaLT3lfdBtEvpr5nsATSehP+gunYb8c4QfSvlI9g2qfZ
WwJE52hNUAPR85i4dUF0h94NMB3z8ZMjiObY1uwEop9dOtEOos26NnWC6B+P
j96rAtIMzMqPQHTVcuGXIHpLnfxrEN29p/I9iJ4RlvwFREfMZ2GoBtJnWVeD
6XdlDGwg2iJCGEynOUvy1QBpr+crwfSN3WbJIDpr+Q4w/SMlg6cWSIumFyiD
6M7adxYg2mnOZzA9V1zDDkSn8WaC6W0dss4gOkZpPZh2nfb5sx870N8vlL+C
6MtWsdn+QFrt1ZsKEL3j3FT+KiDtO/EymAYAT5SmkQ==
  "],
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.493256289109001*^9, 3.493256289109001*^9}, {3.4935821637032185`*^9, 
   3.4935821637032185`*^9}, {3.4935822523333426`*^9, 3.4935822523333426`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a", " ", "x"}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                             ", 
      "\[IndentingNewLine]", "                                      ", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", 
           SuperscriptBox["x", "2"]}]}], ")"}], "m"], 
       RowBox[{"2", " ", "a", " ", "m", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "m"}], "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  FractionBox[
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a", " ", "x"}], "]"}]}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", "m"}], "+", "1"}], ")"}]], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "c", " ", "m"}], 
    RowBox[{
     RowBox[{"2", " ", "m"}], "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"m", "-", "1"}]], " ", 
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.4933211866068697`*^9, {3.4933213613371143`*^9, 
   3.493321413107187*^9}, {3.493590253834545*^9, 3.4935902541945457`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "m_."}], "*", 
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a_.", "*", "x_"}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "m"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "a", "*", "m", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "m"}], "+", "1"}], ")"}]}], ")"}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "m"}], "*", 
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "*", "m"}], "+", "1"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", "c", "*", 
       RowBox[{"m", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "m"}], "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{"ArcTanh", "[", 
          RowBox[{"a", "*", "x"}], "]"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929236652023163`*^9, 3.49292366743312*^9}, 
   3.4929802336571484`*^9, {3.4935809181814747`*^9, 3.4935809199314775`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"m", "\[NotEqual]", 
     RowBox[{"-", 
      FractionBox["3", "2"]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.493582169323227*^9, 
   3.493582169323227*^9}, {3.4935822423333287`*^9, 3.4935822423333287`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a", " ", "x"}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                            ", 
      "\[IndentingNewLine]", "                            ", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], 
         RowBox[{"m", "+", "1"}]], 
        RowBox[{"4", " ", "a", " ", "c", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "2"]}]]}]}]}]}]}], "-", 
  FractionBox[
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], 
     RowBox[{"m", "+", "1"}]], " ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a", " ", "x"}], "]"}]}], 
   RowBox[{"2", "c", 
    RowBox[{"(", 
     RowBox[{"m", "+", "1"}], ")"}]}]], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"2", "m"}], "+", "3"}], 
    RowBox[{"2", " ", "c", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"m", "+", "1"}]], " ", 
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.4935902637145586`*^9, 3.493590263914559*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a_.", "*", "x_"}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}]}], "/", 
     RowBox[{"(", 
      RowBox[{"4", "*", "a", "*", "c", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], ")"}]}], " ", "-", 
    "\n", "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "m"}], "+", "3"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "c", "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{"ArcTanh", "[", 
          RowBox[{"a", "*", "x"}], "]"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"m", "\[NotEqual]", 
     RowBox[{
      RowBox[{"-", "3"}], "/", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
  3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
  3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
  3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
  3.4929234715435762`*^9}, {3.4929235863597775`*^9, 3.4929237005051785`*^9}, {
  3.4929237523440695`*^9, 3.49292375875568*^9}, {3.492923919591963*^9, 
  3.4929239241159706`*^9}, {3.4929244782757444`*^9, 3.4929244935793715`*^9}, {
  3.493580912351467*^9, 3.4935809141414695`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"m", "\[NotEqual]", 
     RowBox[{"-", 
      FractionBox["3", "2"]}]}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.493057857853468*^9, 3.4930578807234993`*^9}, {3.4932562444189386`*^9, 
   3.4932562444189386`*^9}, {3.4935821752432346`*^9, 
   3.4935821752432346`*^9}, {3.493582235473319*^9, 3.493582235473319*^9}}],

Cell[BoxData[
 RowBox[{"\t", 
  RowBox[{
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", 
      RowBox[{
      "x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", "\t", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"n", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", 
              SuperscriptBox["x", "2"]}]}], ")"}], 
           RowBox[{"m", "+", "1"}]], " ", 
          SuperscriptBox[
           RowBox[{"ArcTanh", "[", 
            RowBox[{"a", " ", "x"}], "]"}], 
           RowBox[{"n", "-", "1"}]]}], 
         RowBox[{"4", " ", "a", " ", "c", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}], "2"]}]]}]}]}]}]}], "-", 
   FractionBox[
    RowBox[{"x", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"m", "+", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
    RowBox[{"2", " ", "c", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], "+", "\[IndentingNewLine]", "\t\t", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"2", " ", "m"}], "+", "3"}], 
     RowBox[{"2", " ", "c", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], 
       RowBox[{"m", "+", "1"}]], " ", 
      SuperscriptBox[
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
   RowBox[{
    FractionBox[
     RowBox[{"n", 
      RowBox[{"(", 
       RowBox[{"n", "-", "1"}], ")"}]}], 
     RowBox[{"4", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "2"]}]], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
      SuperscriptBox[
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], 
       RowBox[{"n", "-", "2"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493057986293648*^9, 3.4930579935736575`*^9}, {
  3.493058073023769*^9, 3.4930581370938587`*^9}, {3.493058203013951*^9, 
  3.4930582589840293`*^9}, {3.4930583663841796`*^9, 3.4930583693341837`*^9}, {
  3.493058675794613*^9, 3.4930586798646183`*^9}, {3.4932494353148484`*^9, 
  3.4932495464338436`*^9}, {3.493256213058895*^9, 3.493256222448908*^9}, {
  3.4932569792699676`*^9, 3.4932569886099806`*^9}, {3.493322039288063*^9, 
  3.493322069838106*^9}, {3.4933221617682347`*^9, 3.49332216517824*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "n"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"4", "*", "a", "*", "c", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], ")"}]}]}], " ", "-", 
    "\n", "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "m"}], "+", "3"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "c", "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"4", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "m"}], "*", 
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"m", "\[NotEqual]", 
     RowBox[{
      RowBox[{"-", "3"}], "/", "2"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
  3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
  3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
  3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
  3.4929234715435762`*^9}, {3.4929235863597775`*^9, 3.4929237005051785`*^9}, {
  3.4929237523440695`*^9, 3.49292375875568*^9}, {3.492923919591963*^9, 
  3.4929239241159706`*^9}, {3.4929244782757444`*^9, 3.4929244935793715`*^9}, {
  3.493058294184078*^9, 3.493058321094116*^9}, {3.493058376614194*^9, 
  3.4930583929842167`*^9}, {3.4930584278042655`*^9, 3.4930584671043205`*^9}, {
  3.493058560144451*^9, 3.493058565344458*^9}, {3.493058608014518*^9, 
  3.493058608604519*^9}, {3.4930607207894773`*^9, 3.4930607253094835`*^9}, {
  3.49306140171043*^9, 3.4930614057704363`*^9}, {3.4935809070514593`*^9, 
  3.493580908721462*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{"m", "<", 
      RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
     RowBox[{"n", "<", 
      RowBox[{"-", "1"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.493057857853468*^9, 3.4930578807234993`*^9}, {3.4930589528050003`*^9, 
   3.4930589841650443`*^9}, {3.493256250928948*^9, 3.493256250928948*^9}, {
   3.493493532773344*^9, 3.493493535913348*^9}, {3.493498461430244*^9, 
   3.493498462750246*^9}, {3.4934986627805257`*^9, 3.4934986654705296`*^9}, {
   3.493500262062765*^9, 3.493500278262788*^9}, {3.4935009224036894`*^9, 
   3.4935009269736958`*^9}, {3.4935024446458206`*^9, 
   3.4935024539658337`*^9}, {3.4935821786732397`*^9, 
   3.4935821786732397`*^9}, {3.4935822229233017`*^9, 
   3.4935822229233017`*^9}, {3.493749489450018*^9, 3.4937494905732203`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                           ", 
      "\[IndentingNewLine]", "                                  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"ArcTanh", "[", 
          RowBox[{"a", " ", "x"}], "]"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"a", " ", "c", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}], 
    RowBox[{"n", "+", "1"}]], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{"x", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493058932894973*^9, 3.4930589343449745`*^9}, {
   3.4930590036150713`*^9, 3.493059030475109*^9}, {3.493059071585167*^9, 
   3.4930590795551777`*^9}, {3.4930628403524446`*^9, 3.49306285140246*^9}, {
   3.4932501056192265`*^9, 3.4932501067580285`*^9}, {3.493250146257298*^9, 
   3.493250186942169*^9}, {3.493256078498707*^9, 3.4932560906487236`*^9}, {
   3.4932568685898128`*^9, 3.4932568826798325`*^9}, {3.4933216732775507`*^9, 
   3.4933216957475824`*^9}, {3.4933217278376274`*^9, 3.493321760587673*^9}, 
   3.493321813507747*^9, 3.4933218644878187`*^9, {3.493321906837878*^9, 
   3.493321919617896*^9}, {3.4933220427280684`*^9, 3.493322042928068*^9}, {
   3.4934927094121914`*^9, 3.4934927441222396`*^9}, 3.493492777272286*^9, 
   3.493493493413289*^9, 3.4934935635433865`*^9, {3.4934984296601996`*^9, 
   3.4934984470202236`*^9}, {3.4934985399803543`*^9, 3.493498542300357*^9}, {
   3.4935897542938457`*^9, 3.4935897803338823`*^9}, {3.493590315164631*^9, 
   3.4935903239546432`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", "a", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "m"}], "*", 
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.493058294184078*^9, 3.493058321094116*^9}, {
   3.493058376614194*^9, 3.4930583929842167`*^9}, {3.4930584278042655`*^9, 
   3.4930584671043205`*^9}, {3.493058560144451*^9, 3.493058565344458*^9}, {
   3.493058608014518*^9, 3.493058608604519*^9}, {3.4930607207894773`*^9, 
   3.4930607253094835`*^9}, {3.49306140171043*^9, 3.4930614057704363`*^9}, {
   3.4930627552623253`*^9, 3.4930629395125833`*^9}, {3.493063111452824*^9, 
   3.4930631116128244`*^9}, {3.4930631532528825`*^9, 
   3.4930631552828856`*^9}, {3.4930631929229383`*^9, 
   3.4930631974729443`*^9}, {3.4934926396120934`*^9, 
   3.4934926491221066`*^9}, {3.4934935949134307`*^9, 
   3.4934937034035826`*^9}, {3.4934984698502555`*^9, 3.493498508170309*^9}, 
   3.4934985697303953`*^9, {3.4934986248104725`*^9, 3.493498645260501*^9}, {
   3.4934987095205913`*^9, 3.4934987697006755`*^9}, {3.4935001781326475`*^9, 
   3.493500210632693*^9}, {3.493500590983225*^9, 3.4935005923432274`*^9}, {
   3.4935009097536716`*^9, 3.4935009104136724`*^9}, {3.4935015174045224`*^9, 
   3.4935015211545277`*^9}, {3.4935022843455963`*^9, 3.493502302285621*^9}, {
   3.493502998526596*^9, 3.493502999946598*^9}, {3.493515736345019*^9, 
   3.4935157392850227`*^9}, {3.4935809012014513`*^9, 3.4935809031414537`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], "=", 
   RowBox[{
    FractionBox["1", "a"], " ", 
    SuperscriptBox[
     RowBox[{"Sech", "[", 
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "]"}], 
     RowBox[{"2", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]], " ", 
    SuperscriptBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664448654022*^9, 3.479664485386842*^9, {3.4796905699999485`*^9, 
   3.4796905930330687`*^9}, {3.493066205237155*^9, 3.493066233807195*^9}, {
   3.493067002288271*^9, 3.493067007218278*^9}, {3.4930671665685015`*^9, 
   3.4930671719285088`*^9}, {3.49357941453937*^9, 3.4935794178593745`*^9}, {
   3.4935794530694237`*^9, 3.4935794623694367`*^9}, {3.493579591189617*^9, 
   3.4935795950296226`*^9}, {3.4935796369196815`*^9, 3.493579680229742*^9}, {
   3.4935798057299175`*^9, 3.493579823249942*^9}, {3.493580013000208*^9, 
   3.4935800183302155`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
    RowBox[{"0", " ", "\[And]", " ", "m"}]}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "\[Or]", " ", 
      RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}], ")"}], " ",
     "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[Or]", 
      " ", 
      RowBox[{"c", ">", "0"}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930669874082503`*^9, 
   3.4930669888982525`*^9}, {3.4932562746689816`*^9, 
   3.4932562746689816`*^9}, {3.493256683249553*^9, 3.4932567141395965`*^9}, 
   3.4935791292589703`*^9, 3.4935800548602667`*^9, {3.4935803350706587`*^9, 
   3.4935803371806617`*^9}, {3.493580465490841*^9, 3.4935804699908476`*^9}, {
   3.493580624611064*^9, 3.4935806402710857`*^9}, 3.493582183493246*^9, 
   3.49358221460329*^9, {3.493582721734*^9, 3.4935827257140055`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
   SuperscriptBox[
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SuperscriptBox["c", "m"], "a"]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", "n"], 
       SuperscriptBox[
        RowBox[{"Sech", "[", "x", "]"}], 
        RowBox[{"2", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579733429823`*^9, 3.4796580025249443`*^9}, {
   3.4796580760106115`*^9, 3.479658076961979*^9}, {3.479658170546547*^9, 
   3.47965817467248*^9}, {3.4796583692823153`*^9, 3.4796583839634256`*^9}, {
   3.4796584934408464`*^9, 3.479658497486664*^9}, {3.479661194084181*^9, 
   3.47966122030188*^9}, 3.479661392649704*^9, {3.4796614543984947`*^9, 
   3.4796614565015182`*^9}, {3.4796616029320755`*^9, 3.47966160861024*^9}, 
   3.479661772305622*^9, 3.47966185512471*^9, {3.4796624643307056`*^9, 
   3.4796624837586412`*^9}, {3.4796684805015345`*^9, 3.479668482213997*^9}, {
   3.47968672053469*^9, 3.479686720544704*^9}, {3.4796906638949633`*^9, 
   3.479690664315568*^9}, {3.479690714507741*^9, 3.4796907460130434`*^9}, 
   3.480705514654872*^9, {3.4930650337755156`*^9, 3.493065049545537*^9}, {
   3.4930657623365355`*^9, 3.4930657881965714`*^9}, {3.4930663212373176`*^9, 
   3.493066363577377*^9}, {3.493066963568217*^9, 3.493066975738234*^9}, 
   3.4932537469796257`*^9, 3.493256113988756*^9, {3.4932567461396413`*^9, 
   3.4932567491696453`*^9}, 3.493579009488803*^9, {3.4935790490588584`*^9, 
   3.4935790516388617`*^9}, {3.4935801113403454`*^9, 3.49358011445035*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"c", "^", "m"}], "/", "a"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "n"}], "*", 
          RowBox[{
           RowBox[{"Sech", "[", "x", "]"}], "^", 
           RowBox[{"(", 
            RowBox[{"2", "*", 
             RowBox[{"(", 
              RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], ",", "x"}], "]"}], 
       ",", "x", ",", 
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", "*", "x"}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "||", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}], ")"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "m", "]"}], " ", "||", " ", 
      RowBox[{"PositiveQ", "[", "c", "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.493065103075612*^9, 3.493065290765875*^9}, {
  3.493065714046468*^9, 3.493065729586489*^9}, {3.4930658063465967`*^9, 
  3.4930658068865976`*^9}, {3.493067047288334*^9, 3.493067049548337*^9}, {
  3.4930670867783895`*^9, 3.493067112388425*^9}, {3.4930674070088377`*^9, 
  3.4930674148588486`*^9}, {3.4930676846992264`*^9, 3.4930676962292423`*^9}, {
  3.4935801866504507`*^9, 3.493580239560525*^9}, {3.493580375290715*^9, 
  3.4935803824807253`*^9}, {3.493580473120852*^9, 3.4935804871108713`*^9}, {
  3.493580711731186*^9, 3.493580717491194*^9}, {3.4935808945314417`*^9, 
  3.4935808963414445`*^9}, {3.493582837424162*^9, 3.4935828401941657`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["c", 
        RowBox[{"m", "-", 
         FractionBox["1", "2"]}]], 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}]]}], 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["x", "2"]}]}]]], ",", "x"}], "]"}], "=", "0"}]],
  CellChangeTimes->{{3.4937498379858303`*^9, 3.4937499017587423`*^9}, {
   3.4937499674816575`*^9, 3.493750029569767*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664448654022*^9, 3.479664485386842*^9, {3.4796905699999485`*^9, 
   3.4796905930330687`*^9}, {3.493066205237155*^9, 3.493066233807195*^9}, {
   3.493067002288271*^9, 3.493067007218278*^9}, {3.4930671665685015`*^9, 
   3.4930671719285088`*^9}, {3.49357941453937*^9, 3.4935794178593745`*^9}, {
   3.4935794530694237`*^9, 3.4935794623694367`*^9}, {3.493579591189617*^9, 
   3.4935795950296226`*^9}, {3.4935796369196815`*^9, 3.493579680229742*^9}, {
   3.4935798057299175`*^9, 3.493579823249942*^9}, {3.493580013000208*^9, 
   3.4935800183302155`*^9}, {3.4937499298855915`*^9, 
   3.4937499486524243`*^9}, {3.4937500390389833`*^9, 3.4937500431885905`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
    RowBox[{"0", " ", "\[And]", " ", "m"}]}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "\[Or]", " ", 
      RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}], ")"}], " ",
     "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{"c", ">", "0"}], ")"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930680892297926`*^9, 
   3.4930681267098455`*^9}, {3.4930801578959255`*^9, 
   3.4930801961259785`*^9}, {3.493256255798955*^9, 3.4932562676389713`*^9}, {
   3.493582187523252*^9, 3.493582201173271*^9}, {3.4935826492138987`*^9, 
   3.4935826803839417`*^9}, {3.4935827341640177`*^9, 
   3.4935827808740826`*^9}, {3.4935831190745564`*^9, 3.49358317149463*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "m"], 
   SuperscriptBox[
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox["c", 
        RowBox[{"m", "-", 
         FractionBox["1", "2"]}]], 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}]]}], 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["x", "2"]}]}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "m"], 
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579733429823`*^9, 3.4796580025249443`*^9}, {
   3.4796580760106115`*^9, 3.479658076961979*^9}, {3.479658170546547*^9, 
   3.47965817467248*^9}, {3.4796583692823153`*^9, 3.4796583839634256`*^9}, {
   3.4796584934408464`*^9, 3.479658497486664*^9}, {3.479661194084181*^9, 
   3.47966122030188*^9}, 3.479661392649704*^9, {3.4796614543984947`*^9, 
   3.4796614565015182`*^9}, {3.4796616029320755`*^9, 3.47966160861024*^9}, 
   3.479661772305622*^9, 3.47966185512471*^9, {3.4796624643307056`*^9, 
   3.4796624837586412`*^9}, {3.4796684805015345`*^9, 3.479668482213997*^9}, {
   3.47968672053469*^9, 3.479686720544704*^9}, {3.4796906638949633`*^9, 
   3.479690664315568*^9}, {3.479690714507741*^9, 3.4796907460130434`*^9}, 
   3.480705514654872*^9, {3.4930650337755156`*^9, 3.493065049545537*^9}, {
   3.4930657623365355`*^9, 3.4930657881965714`*^9}, {3.493077421798092*^9, 
   3.4930774294181027`*^9}, {3.49307964724521*^9, 3.493079659035227*^9}, {
   3.4930797467153497`*^9, 3.493079763295373*^9}, {3.493079973595667*^9, 
   3.4930800012057056`*^9}, {3.4932537598652487`*^9, 3.4932537660740595`*^9}, 
   3.493256110328751*^9, {3.4935825897438154`*^9, 3.4935826029438334`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"c", "^", 
     RowBox[{"(", 
      RowBox[{"m", "-", 
       RowBox[{"1", "/", "2"}]}], ")"}]}], "*", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "-", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}]}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "*", 
           RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "m"}], "*", 
       RowBox[{
        RowBox[{"ArcTanh", "[", 
         RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "||", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}], ")"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PositiveQ", "[", "c", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.493065103075612*^9, 3.493065290765875*^9}, {
   3.493065714046468*^9, 3.493065729586489*^9}, {3.4930658063465967`*^9, 
   3.4930658068865976`*^9}, {3.493067423888861*^9, 3.4930674284788675`*^9}, 
   3.493068077149776*^9, {3.493080071975805*^9, 3.493080131335888*^9}, {
   3.4930802396760397`*^9, 3.4930802468960495`*^9}, {3.4932538772710547`*^9, 
   3.4932538805314603`*^9}, {3.4935808882514334`*^9, 3.493580890111436*^9}, {
   3.493582859644193*^9, 3.493582867944205*^9}, {3.4935830452044525`*^9, 
   3.4935830783744993`*^9}, {3.4935832217946997`*^9, 3.493583225184705*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
   SuperscriptBox[
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.479616001935333*^9, 3.4796867203444157`*^9, {3.479687071148848*^9, 
   3.479687071399208*^9}, 3.4928222618129525`*^9, 3.4928258304168224`*^9, {
   3.4929226804037867`*^9, 3.4929226942254105`*^9}, {3.492979990624321*^9, 
   3.4929799910143223`*^9}, {3.493060035696517*^9, 3.4930600483865347`*^9}, 
   3.493253406025427*^9, {3.493354142567293*^9, 3.493354158680215*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}, {
  3.4935738213175373`*^9, 3.493573838477561*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493415722490226*^9, 
   3.493415730810238*^9}, {3.4935738213175373`*^9, 3.493573838477561*^9}, {
   3.4935823105834246`*^9, 3.4935823105834246`*^9}, {3.4935823762035165`*^9, 
   3.4935823762035165`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"ArcTanh", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
       RowBox[{"2", " ", "d", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["n", 
    RowBox[{"2", " ", "a", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.493354278495068*^9, 3.493354294476982*^9}, {
   3.4933546277870464`*^9, 3.4933546449460278`*^9}, {3.493354790721366*^9, 
   3.4933547931895065`*^9}, {3.4933563805813007`*^9, 3.493356384480523*^9}, {
   3.4935738213175373`*^9, 3.493573838477561*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "a", "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.4933546901676145`*^9, 3.493354852357891*^9}, {
   3.493354994220005*^9, 3.4933549944920206`*^9}, 3.493356145801872*^9, 
   3.4933562876739864`*^9, {3.493356396607217*^9, 3.493356401341488*^9}, {
   3.493415708300206*^9, 3.493415712490212*^9}, {3.493580788181293*^9, 
   3.493580790631296*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalQ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493415722490226*^9, 
   3.493415730810238*^9}, {3.4935159619553347`*^9, 3.49351600154539*^9}, {
   3.493582316753433*^9, 3.493582316753433*^9}, {3.493582369383507*^9, 
   3.493582369383507*^9}, {3.4949679439187803`*^9, 3.494967944658781*^9}, {
   3.4949694620709057`*^9, 3.4949694620709057`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], "p"]}], 
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "2"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"x", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", 
             SuperscriptBox["x", "2"]}]}], ")"}], 
          RowBox[{"p", "+", "1"}]]}], 
        RowBox[{"a", " ", "c", " ", 
         RowBox[{"ArcTanh", "[", 
          RowBox[{"a", " ", "x"}], "]"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", "a"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "3"}], ")"}], " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", 
           SuperscriptBox["x", "2"]}]}], ")"}], "p"]}], 
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.493354278495068*^9, 3.493354294476982*^9}, {
   3.4933546277870464`*^9, 3.4933546449460278`*^9}, {3.493354790721366*^9, 
   3.4933547931895065`*^9}, {3.4933563805813007`*^9, 3.493356384480523*^9}, {
   3.4935159055452557`*^9, 3.4935159469853134`*^9}, {3.4935898317039537`*^9, 
   3.493589853353984*^9}, {3.4935903822847247`*^9, 3.4935904229047813`*^9}, {
   3.493590752655243*^9, 3.493590763525258*^9}, {3.4935908715154095`*^9, 
   3.4935908771554174`*^9}, {3.4935909258054857`*^9, 3.493590926785487*^9}, {
   3.493591021125619*^9, 3.493591039645645*^9}, {3.493591125495765*^9, 
   3.493591126025766*^9}, {3.4935912357559195`*^9, 3.49359123615592*^9}, {
   3.494967953858794*^9, 3.4949680122488756`*^9}, {3.4949693812107925`*^9, 
   3.494969427310857*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_."}], "/", 
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "2"}]}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "x"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c", "*", 
        RowBox[{"ArcTanh", "[", 
         RowBox[{"a", "*", "x"}], "]"}]}], ")"}]}]}], " ", "+", 
    "\[IndentingNewLine]", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "a"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "*", "p"}], "+", "3"}], ")"}], "*", 
            RowBox[{"a", "^", "2"}], "*", 
            RowBox[{"x", "^", "2"}]}]}], ")"}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", 
              RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "/", 
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.4933546901676145`*^9, 3.493354852357891*^9}, {
   3.493354994220005*^9, 3.4933549944920206`*^9}, 3.493356145801872*^9, 
   3.4933562876739864`*^9, {3.493356396607217*^9, 3.493356401341488*^9}, {
   3.493415708300206*^9, 3.493415712490212*^9}, {3.4935159552553253`*^9, 
   3.493515974425352*^9}, {3.493516011355404*^9, 3.4935160426754475`*^9}, {
   3.493516152975602*^9, 3.4935161582156096`*^9}, {3.4935807957313037`*^9, 
   3.4935807976813064`*^9}, {3.494969533241005*^9, 3.4949695405110154`*^9}, {
   3.494969605621106*^9, 3.494969728921279*^9}, 3.4949697639513283`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493415722490226*^9, 
   3.493415730810238*^9}, {3.4935159619553347`*^9, 3.49351600154539*^9}, {
   3.493582316753433*^9, 3.493582316753433*^9}, {3.493582369383507*^9, 
   3.493582369383507*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", " ", 
      SuperscriptBox[
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "2"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                                              \
     ", "\[IndentingNewLine]", "                ", 
      FractionBox[
       RowBox[{"x", " ", 
        SuperscriptBox[
         RowBox[{"ArcTanh", "[", 
          RowBox[{"a", " ", "x"}], "]"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"a", " ", "c", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", 
           SuperscriptBox["x", "2"]}]}], ")"}]}]]}]}]}]}], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], 
     RowBox[{"n", "+", "2"}]]}], 
   RowBox[{"d", " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}]}]], "+", 
  RowBox[{
   FractionBox["4", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"n", "+", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"x", " ", 
       SuperscriptBox[
        RowBox[{"ArcTanh", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "+", "2"}]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], "2"]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.493354278495068*^9, 3.493354294476982*^9}, {
   3.4933546277870464`*^9, 3.4933546449460278`*^9}, {3.493354790721366*^9, 
   3.4933547931895065`*^9}, {3.4933563805813007`*^9, 3.493356384480523*^9}, {
   3.4935159055452557`*^9, 3.4935159469853134`*^9}, {3.4935898317039537`*^9, 
   3.493589853353984*^9}, {3.4935903822847247`*^9, 3.4935904229047813`*^9}, {
   3.493590752655243*^9, 3.493590763525258*^9}, {3.4935908715154095`*^9, 
   3.4935908771554174`*^9}, {3.4935909258054857`*^9, 3.493590926785487*^9}, {
   3.493591021125619*^9, 3.493591039645645*^9}, {3.493591125495765*^9, 
   3.493591126025766*^9}, {3.4935912357559195`*^9, 3.49359123615592*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}], "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "2"}]}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", 
           RowBox[{"x", "^", "2"}]}]}], ")"}]}], ")"}]}]}], " ", "+", 
    "\[IndentingNewLine]", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"x", "^", "2"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", 
           RowBox[{"x", "^", "2"}]}]}], ")"}]}], ")"}]}]}], " ", "+", 
    "\[IndentingNewLine]", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"4", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{
           RowBox[{"ArcTanh", "[", 
            RowBox[{"a", "*", "x"}], "]"}], "^", 
           RowBox[{"(", 
            RowBox[{"n", "+", "2"}], ")"}]}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", 
              RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "2"}]}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.4933546901676145`*^9, 3.493354852357891*^9}, {
   3.493354994220005*^9, 3.4933549944920206`*^9}, 3.493356145801872*^9, 
   3.4933562876739864`*^9, {3.493356396607217*^9, 3.493356401341488*^9}, {
   3.493415708300206*^9, 3.493415712490212*^9}, {3.4935159552553253`*^9, 
   3.493515974425352*^9}, {3.493516011355404*^9, 3.4935160426754475`*^9}, {
   3.493516152975602*^9, 3.4935161582156096`*^9}, {3.4935807957313037`*^9, 
   3.4935807976813064`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
    RowBox[{"0", " ", "\[And]", " ", "m"}]}], ",", "n", ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", "p"}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
     "\[And]", " ", 
     RowBox[{"m", "<", 
      RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
     RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
     RowBox[{"m", "+", 
      RowBox[{"2", "p"}], "+", "3"}]}], "=", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493356182221955*^9, 
   3.4933562049342537`*^9}, {3.4933938872666245`*^9, 
   3.4933939122734685`*^9}, {3.493394021941661*^9, 3.493394030412476*^9}, {
   3.493395008824994*^9, 3.493395011601799*^9}, {3.4933950592130823`*^9, 
   3.4933950626138887`*^9}, {3.4933958282120333`*^9, 
   3.4933958335004425`*^9}, {3.4933958648876977`*^9, 3.493395891672944*^9}, {
   3.493406394401163*^9, 3.4934063956011643`*^9}, {3.493414300772232*^9, 
   3.4934143075622416`*^9}, {3.4935055200960126`*^9, 
   3.4935055200960126`*^9}, {3.4935057649384427`*^9, 
   3.4935057649384427`*^9}, {3.493505853515398*^9, 3.493505853515398*^9}, {
   3.493582326893447*^9, 3.4935823540334854`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                             ", 
      "\[IndentingNewLine]", "                                      ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"ArcTanh", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
       RowBox[{"c", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "n"}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.493354278495068*^9, 3.493354294476982*^9}, {
   3.4933546277870464`*^9, 3.4933546449460278`*^9}, {3.493354790721366*^9, 
   3.4933547931895065`*^9}, {3.4933560394157867`*^9, 
   3.4933561011583185`*^9}, {3.4933561738414755`*^9, 
   3.4933561751395497`*^9}, {3.4933562501758413`*^9, 
   3.4933562530870085`*^9}, {3.493356410270999*^9, 3.4933564233687477`*^9}, {
   3.493394874820759*^9, 3.4933949021052065`*^9}, {3.493395751163498*^9, 
   3.4933957978543797`*^9}, {3.493406138010804*^9, 3.4934061641108403`*^9}, {
   3.4934062369309425`*^9, 3.4934062462209554`*^9}, {3.49340655671139*^9, 
   3.4934065590813932`*^9}, {3.4934141473620167`*^9, 
   3.4934141575120316`*^9}, {3.493589928364089*^9, 3.4935899505341206`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"n", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", 
      RowBox[{"2", "*", "p"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "p"}], "+", "3"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.4933546901676145`*^9, 3.493354852357891*^9}, {
   3.493354994220005*^9, 3.4933549944920206`*^9}, {3.4933561282218666`*^9, 
   3.493356154267356*^9}, {3.4933562088824797`*^9, 3.493356243066435*^9}, {
   3.4933562812016163`*^9, 3.4933563433891735`*^9}, {3.4933564509923277`*^9, 
   3.4933564967799463`*^9}, {3.4933565518720975`*^9, 3.493356556926387*^9}, {
   3.493356683297615*^9, 3.493356683651635*^9}, {3.493393781030438*^9, 
   3.4933937826528406`*^9}, {3.49339383350893*^9, 3.4933938341173315`*^9}, {
   3.4933938692017927`*^9, 3.4933938715417967`*^9}, {3.4933939716159725`*^9, 
   3.4933939737687764`*^9}, {3.4933951036263604`*^9, 
   3.4933952261489754`*^9}, {3.4933952605626364`*^9, 3.493395282199874*^9}, {
   3.4933959219993978`*^9, 3.493396038968403*^9}, 3.4933965390584817`*^9, {
   3.4934062197609186`*^9, 3.49340622120092*^9}, {3.4934064692212677`*^9, 
   3.49340657783142*^9}, {3.49341417825206*^9, 3.4934141863320713`*^9}, {
   3.4934142170121145`*^9, 3.4934142188021173`*^9}, {3.493505515821605*^9, 
   3.493505516788807*^9}, 3.493505760539235*^9, {3.4935058497401915`*^9, 
   3.4935058506137934`*^9}, {3.493580815391331*^9, 3.4935808179213347`*^9}, 
   3.5171885891450033`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
    RowBox[{"0", " ", "\[And]", " ", "m"}]}], ",", "n", ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", "p"}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
     "\[And]", " ", 
     RowBox[{"n", "<", 
      RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
     RowBox[{"m", "+", 
      RowBox[{"2", "p"}], "+", "2"}]}], "=", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493356182221955*^9, 
   3.4933562049342537`*^9}, {3.4933938872666245`*^9, 
   3.4933939122734685`*^9}, {3.493394021941661*^9, 3.493394030412476*^9}, {
   3.493395008824994*^9, 3.493395011601799*^9}, {3.4933950592130823`*^9, 
   3.4933950626138887`*^9}, {3.493444320208996*^9, 3.493444321758998*^9}, {
   3.4934444078191185`*^9, 3.4934444112891235`*^9}, {3.493444627119426*^9, 
   3.493444628299427*^9}, {3.4935055051355867`*^9, 3.4935055051355867`*^9}, {
   3.4935057857020793`*^9, 3.4935057857020793`*^9}, {3.493505835918567*^9, 
   3.493505835918567*^9}, {3.493582332753455*^9, 3.4935823464234743`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", " ", "\[LongRightArrow]", 
      "                                                                       \
                                                              ", 
      "\[IndentingNewLine]", "                                   ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", "m"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"ArcTanh", "[", 
          RowBox[{"a", " ", "x"}], "]"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"a", " ", "c", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["m", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.493354278495068*^9, 3.493354294476982*^9}, {
   3.4933546277870464`*^9, 3.4933546449460278`*^9}, {3.493354790721366*^9, 
   3.4933547931895065`*^9}, {3.4933560394157867`*^9, 
   3.4933561011583185`*^9}, {3.4933561738414755`*^9, 
   3.4933561751395497`*^9}, {3.4933562501758413`*^9, 
   3.4933562530870085`*^9}, {3.493356410270999*^9, 3.4933564233687477`*^9}, {
   3.493394874820759*^9, 3.4933949021052065`*^9}, {3.493444143068748*^9, 
   3.493444163808777*^9}, {3.4934446369894395`*^9, 3.493444646849453*^9}, {
   3.49358997156415*^9, 3.493589988114173*^9}, {3.493590469004846*^9, 
   3.493590474204853*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "m"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"m", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", 
      RowBox[{"2", "*", "p"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "p"}], "+", "2"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.4933546901676145`*^9, 3.493354852357891*^9}, {
   3.493354994220005*^9, 3.4933549944920206`*^9}, {3.4933561282218666`*^9, 
   3.493356154267356*^9}, {3.4933562088824797`*^9, 3.493356243066435*^9}, {
   3.4933562812016163`*^9, 3.4933563433891735`*^9}, {3.4933564509923277`*^9, 
   3.4933564967799463`*^9}, {3.4933565518720975`*^9, 3.493356556926387*^9}, {
   3.493356683297615*^9, 3.493356683651635*^9}, {3.493393781030438*^9, 
   3.4933937826528406`*^9}, {3.49339383350893*^9, 3.4933938341173315`*^9}, {
   3.4933938692017927`*^9, 3.4933938715417967`*^9}, {3.4933939716159725`*^9, 
   3.4933939737687764`*^9}, {3.4933951036263604`*^9, 
   3.4933952261489754`*^9}, {3.4933952605626364`*^9, 3.493395282199874*^9}, 
   3.4933965801177535`*^9, {3.4933967072423773`*^9, 3.4933967295972166`*^9}, {
   3.4933967622168736`*^9, 3.493396766506881*^9}, {3.4934444505191784`*^9, 
   3.4934444533991823`*^9}, {3.4934444856092277`*^9, 3.493444554759324*^9}, {
   3.493444656619467*^9, 3.493444664049477*^9}, {3.493505499691177*^9, 
   3.493505500330778*^9}, 3.4935057823168736`*^9, {3.4935058303025575`*^9, 
   3.4935058307705584`*^9}, {3.493580826771347*^9, 3.49358082920135*^9}, 
   3.5171885891762037`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "2"], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], "=", 
   RowBox[{
    FractionBox["1", "d"], "-", 
    FractionBox["c", 
     RowBox[{"d", " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, 
   3.49290371904314*^9, {3.49316782040429*^9, 3.4931678273342996`*^9}, {
   3.4931678584343433`*^9, 3.4931678962243958`*^9}, {3.4931679645244913`*^9, 
   3.493167967024495*^9}, {3.4931679986345396`*^9, 3.4931680026345453`*^9}, 
   3.493790063331503*^9, 3.4937901678516493`*^9, {3.4937902960118284`*^9, 
   3.4937902973518305`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
    RowBox[{"0", " ", "\[And]", " ", "m"}]}], ",", "n", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "p"}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
    "\[And]", " ", 
    RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493356182221955*^9, 
   3.4933562049342537`*^9}, {3.4933938872666245`*^9, 
   3.4933939122734685`*^9}, {3.493394021941661*^9, 3.493394030412476*^9}, {
   3.493582323023442*^9, 3.493582323023442*^9}, {3.4935823597934933`*^9, 
   3.4935823597934933`*^9}, {3.493857373585099*^9, 3.493857373585099*^9}, {
   3.4938623384460526`*^9, 3.4938623392360535`*^9}, {3.49386578680088*^9, 
   3.49386578680088*^9}, {3.493866462471826*^9, 3.493866466731832*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "d"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["x", 
       RowBox[{"m", "-", "2"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], 
       RowBox[{"p", "+", "1"}]], " ", 
      SuperscriptBox[
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["c", "d"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.493354278495068*^9, 3.493354294476982*^9}, {
   3.4933546277870464`*^9, 3.4933546449460278`*^9}, {3.493354790721366*^9, 
   3.4933547931895065`*^9}, {3.4933560394157867`*^9, 
   3.4933561011583185`*^9}, {3.4933561738414755`*^9, 
   3.4933561751395497`*^9}, {3.4933562501758413`*^9, 
   3.4933562530870085`*^9}, {3.493356410270999*^9, 3.4933564233687477`*^9}, 
   3.49385258804259*^9, {3.493852620612636*^9, 3.4938526898507333`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_"}], "*", 
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "d"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"c", "/", "d"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", 
      RowBox[{"2", "*", "p"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.4933546901676145`*^9, 3.493354852357891*^9}, {
   3.493354994220005*^9, 3.4933549944920206`*^9}, {3.4933561282218666`*^9, 
   3.493356154267356*^9}, {3.4933562088824797`*^9, 3.493356243066435*^9}, {
   3.4933562812016163`*^9, 3.4933563433891735`*^9}, {3.4933564509923277`*^9, 
   3.4933564967799463`*^9}, {3.4933565518720975`*^9, 3.493356556926387*^9}, {
   3.493356683297615*^9, 3.493356683651635*^9}, {3.493393781030438*^9, 
   3.4933937826528406`*^9}, {3.49339383350893*^9, 3.4933938341173315`*^9}, {
   3.4933938692017927`*^9, 3.4933938715417967`*^9}, {3.4933939716159725`*^9, 
   3.4933939737687764`*^9}, 3.493396573690542*^9, {3.4935808076513205`*^9, 
   3.493580810011324*^9}, {3.4938563531736703`*^9, 3.493856396943732*^9}, 
   3.4938565202739043`*^9, {3.493857377865105*^9, 3.4938573787451067`*^9}, {
   3.493862320526027*^9, 3.493862321776029*^9}, {3.493865803070903*^9, 
   3.4938658047609053`*^9}, {3.493866443151799*^9, 3.4938664464618034`*^9}, 
   3.517188589207404*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], "=", 
   RowBox[{
    FractionBox["1", "c"], "-", 
    FractionBox[
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}], 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, 
   3.49290371904314*^9, {3.49316782040429*^9, 3.4931678273342996`*^9}, {
   3.4931678584343433`*^9, 3.4931678962243958`*^9}, {3.4931679645244913`*^9, 
   3.493167967024495*^9}, {3.4931679986345396`*^9, 3.4931680026345453`*^9}, 
   3.493790063331503*^9, 3.4937901678516493`*^9, {3.4937902960118284`*^9, 
   3.4937902973518305`*^9}, {3.493857825015731*^9, 3.4938578494057655`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
    RowBox[{"0", " ", "\[And]", " ", "m"}]}], ",", "n", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "p"}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
    "\[And]", " ", 
    RowBox[{"m", "<", "0"}], " ", "\[And]", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493356182221955*^9, 
   3.4933562049342537`*^9}, {3.4933938872666245`*^9, 
   3.4933939122734685`*^9}, {3.493394021941661*^9, 3.493394030412476*^9}, {
   3.493582323023442*^9, 3.493582323023442*^9}, {3.4935823597934933`*^9, 
   3.4935823597934933`*^9}, {3.493857373585099*^9, 3.493857373585099*^9}, {
   3.4938574226851683`*^9, 3.4938574248351707`*^9}, {3.493861363812687*^9, 
   3.493861363812687*^9}, {3.493861896375434*^9, 3.4938618973254347`*^9}, {
   3.493862147205785*^9, 3.493862147205785*^9}, {3.493862334036046*^9, 
   3.4938623346860476`*^9}, {3.4938657907508855`*^9, 
   3.4938657907508855`*^9}, {3.493866473221841*^9, 3.493866473221841*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "c"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], 
       RowBox[{"p", "+", "1"}]], " ", 
      SuperscriptBox[
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["d", "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493166154681958*^9, 3.4931662030820255`*^9}, 
   3.4931666207326107`*^9, {3.4932522463481894`*^9, 3.49325228099585*^9}, {
   3.4933158052693357`*^9, 3.4933158328693743`*^9}, {3.4933190308138514`*^9, 
   3.493319134053996*^9}, {3.4933192438441496`*^9, 3.4933192445541506`*^9}, {
   3.4933193363142796`*^9, 3.4933193414042864`*^9}, {3.493412534339759*^9, 
   3.493412536469762*^9}, {3.493789994101406*^9, 3.493790017041438*^9}, {
   3.4937903432618947`*^9, 3.4937903499119043`*^9}, {3.493791019842842*^9, 
   3.4937910517128863`*^9}, 3.493791106992964*^9, 3.49379132604327*^9, {
   3.4937915274235525`*^9, 3.493791535933564*^9}, {3.4937916827437696`*^9, 
   3.4937916869037757`*^9}, {3.4938571031547203`*^9, 3.493857152184789*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_"}], "*", 
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"d", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", 
      RowBox[{"2", "*", "p"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", "0"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929236652023163`*^9, 3.49292366743312*^9}, 
   3.4929802336571484`*^9, {3.492982933672291*^9, 3.4929829505983205`*^9}, {
   3.4929832472016416`*^9, 3.4929833842790823`*^9}, {3.4929834529036026`*^9, 
   3.4929834542764053`*^9}, {3.493166117311906*^9, 3.493166138981936*^9}, {
   3.4931662751621265`*^9, 3.4931663186221876`*^9}, {3.4934126182898765`*^9, 
   3.493412622519882*^9}, {3.4935809700815477`*^9, 3.4935809719615507`*^9}, {
   3.493791136533005*^9, 3.4937911896730795`*^9}, 3.4937912549331713`*^9, {
   3.4938403406557693`*^9, 3.4938403671446157`*^9}, {3.4938574572652164`*^9, 
   3.493857469385233*^9}, {3.493857542505336*^9, 3.493857549915346*^9}, {
   3.493857663025504*^9, 3.4938576691055126`*^9}, 3.4938621399657745`*^9, {
   3.4938623256060343`*^9, 3.4938623265160356`*^9}, {3.49386579402089*^9, 
   3.493865798890897*^9}, 3.4938664556718163`*^9, 3.517188589223004*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
    RowBox[{"0", " ", "\[And]", " ", "m"}]}], ",", "n", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "p"}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
    "\[And]", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "+", 
      RowBox[{"2", "p"}], "+", "3"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493356182221955*^9, 
   3.4933562049342537`*^9}, {3.4933938872666245`*^9, 
   3.4933939122734685`*^9}, {3.493394021941661*^9, 3.493394030412476*^9}, {
   3.493395008824994*^9, 3.493395011601799*^9}, {3.4933950592130823`*^9, 
   3.4933950626138887`*^9}, {3.4933958282120333`*^9, 
   3.4933958335004425`*^9}, {3.4933958648876977`*^9, 3.493395891672944*^9}, {
   3.493406394401163*^9, 3.4934063956011643`*^9}, {3.4934443505890384`*^9, 
   3.493444358119049*^9}, {3.4935053801481667`*^9, 3.4935053801481667`*^9}, {
   3.4935057769504633`*^9, 3.4935057769504633`*^9}, {3.493505844997783*^9, 
   3.493505844997783*^9}, {3.493582329573451*^9, 3.4935823505034804`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"ArcTanh", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
       RowBox[{"c", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  "                                                                ", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "n"}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", 
       RowBox[{"2", "p"}], "+", "3"}], ")"}]}], 
    RowBox[{" ", 
     RowBox[{"m", "+", "1"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.493354278495068*^9, 3.493354294476982*^9}, {
   3.4933546277870464`*^9, 3.4933546449460278`*^9}, {3.493354790721366*^9, 
   3.4933547931895065`*^9}, {3.4933560394157867`*^9, 
   3.4933561011583185`*^9}, {3.4933561738414755`*^9, 
   3.4933561751395497`*^9}, {3.4933562501758413`*^9, 
   3.4933562530870085`*^9}, {3.493356410270999*^9, 3.4933564233687477`*^9}, {
   3.493394874820759*^9, 3.4933949021052065`*^9}, {3.493395751163498*^9, 
   3.4933957978543797`*^9}, {3.493406138010804*^9, 3.4934061641108403`*^9}, {
   3.4934062369309425`*^9, 3.4934062462209554`*^9}, {3.49340655671139*^9, 
   3.4934065590813932`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"n", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"2", "*", "p"}], "+", "3"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", 
      RowBox[{"2", "*", "p"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "p"}], "+", "3"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.4933546901676145`*^9, 3.493354852357891*^9}, {
   3.493354994220005*^9, 3.4933549944920206`*^9}, {3.4933561282218666`*^9, 
   3.493356154267356*^9}, {3.4933562088824797`*^9, 3.493356243066435*^9}, {
   3.4933562812016163`*^9, 3.4933563433891735`*^9}, {3.4933564509923277`*^9, 
   3.4933564967799463`*^9}, {3.4933565518720975`*^9, 3.493356556926387*^9}, {
   3.493356683297615*^9, 3.493356683651635*^9}, {3.493393781030438*^9, 
   3.4933937826528406`*^9}, {3.49339383350893*^9, 3.4933938341173315`*^9}, {
   3.4933938692017927`*^9, 3.4933938715417967`*^9}, {3.4933939716159725`*^9, 
   3.4933939737687764`*^9}, {3.4933951036263604`*^9, 
   3.4933952261489754`*^9}, {3.4933952605626364`*^9, 3.493395282199874*^9}, {
   3.4933959219993978`*^9, 3.493396038968403*^9}, 3.4933965390584817`*^9, {
   3.4934062197609186`*^9, 3.49340622120092*^9}, {3.4934064692212677`*^9, 
   3.49340657783142*^9}, {3.4934442542789035`*^9, 3.493444261298914*^9}, {
   3.4935053828469715`*^9, 3.4935053837985735`*^9}, 3.493505773830458*^9, {
   3.4935058411913767`*^9, 3.493505841986978*^9}, {3.493580821131339*^9, 
   3.493580823141342*^9}, {3.4938648637095876`*^9, 3.493864868009594*^9}, {
   3.4938653914803267`*^9, 3.493865394630331*^9}, 3.517188589254204*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
    RowBox[{"0", " ", "\[And]", " ", "m"}]}], ",", "n", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "p"}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
    "\[And]", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "+", 
      RowBox[{"2", "p"}], "+", "2"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493356182221955*^9, 
   3.4933562049342537`*^9}, {3.4933938872666245`*^9, 
   3.4933939122734685`*^9}, {3.493394021941661*^9, 3.493394030412476*^9}, {
   3.493395008824994*^9, 3.493395011601799*^9}, {3.4933950592130823`*^9, 
   3.4933950626138887`*^9}, {3.493444320208996*^9, 3.493444321758998*^9}, {
   3.4934444078191185`*^9, 3.4934444112891235`*^9}, {3.4935053527545185`*^9, 
   3.4935053527545185`*^9}, {3.4935057932368927`*^9, 
   3.4935057932368927`*^9}, {3.4935058259189496`*^9, 
   3.4935058259189496`*^9}, {3.493582335173459*^9, 3.493582342413469*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", " ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", "m"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"ArcTanh", "[", 
          RowBox[{"a", " ", "x"}], "]"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"a", " ", "c", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  "                                                                       ", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["m", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"a", 
     RowBox[{"(", 
      RowBox[{"m", "+", 
       RowBox[{"2", "p"}], "+", "2"}], ")"}]}], 
    RowBox[{"n", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.493354278495068*^9, 3.493354294476982*^9}, {
   3.4933546277870464`*^9, 3.4933546449460278`*^9}, {3.493354790721366*^9, 
   3.4933547931895065`*^9}, {3.4933560394157867`*^9, 
   3.4933561011583185`*^9}, {3.4933561738414755`*^9, 
   3.4933561751395497`*^9}, {3.4933562501758413`*^9, 
   3.4933562530870085`*^9}, {3.493356410270999*^9, 3.4933564233687477`*^9}, {
   3.493394874820759*^9, 3.4933949021052065`*^9}, {3.493444143068748*^9, 
   3.493444163808777*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "m"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"m", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"2", "*", "p"}], "+", "2"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", 
      RowBox[{"2", "*", "p"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "p"}], "+", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"m", "\[Equal]", "1"}], " ", "&&", " ", 
      RowBox[{"n", "\[Equal]", 
       RowBox[{"-", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.4933546901676145`*^9, 3.493354852357891*^9}, {
   3.493354994220005*^9, 3.4933549944920206`*^9}, {3.4933561282218666`*^9, 
   3.493356154267356*^9}, {3.4933562088824797`*^9, 3.493356243066435*^9}, {
   3.4933562812016163`*^9, 3.4933563433891735`*^9}, {3.4933564509923277`*^9, 
   3.4933564967799463`*^9}, {3.4933565518720975`*^9, 3.493356556926387*^9}, {
   3.493356683297615*^9, 3.493356683651635*^9}, {3.493393781030438*^9, 
   3.4933937826528406`*^9}, {3.49339383350893*^9, 3.4933938341173315`*^9}, {
   3.4933938692017927`*^9, 3.4933938715417967`*^9}, {3.4933939716159725`*^9, 
   3.4933939737687764`*^9}, {3.4933951036263604`*^9, 
   3.4933952261489754`*^9}, {3.4933952605626364`*^9, 3.493395282199874*^9}, 
   3.4933965801177535`*^9, {3.4933967072423773`*^9, 3.4933967295972166`*^9}, {
   3.4933967622168736`*^9, 3.493396766506881*^9}, {3.4934444505191784`*^9, 
   3.4934444533991823`*^9}, {3.4934444856092277`*^9, 3.493444554759324*^9}, 
   3.4934449081898193`*^9, {3.4935053477937098`*^9, 3.4935053483397107`*^9}, 
   3.493505790023287*^9, {3.4935058218473425`*^9, 3.4935058223465433`*^9}, {
   3.4935808341413574`*^9, 3.4935808367413607`*^9}, {3.493864871779599*^9, 
   3.493864875919605*^9}, {3.4938653985703363`*^9, 3.4938654013003407`*^9}, {
   3.4949606149185195`*^9, 3.4949606201085267`*^9}, {3.4949643212137084`*^9, 
   3.4949643250237136`*^9}, {3.4949661721462994`*^9, 3.494966207656349*^9}, 
   3.494966239426394*^9, {3.4949698434114394`*^9, 3.4949698464514437`*^9}, 
   3.517188589285404*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection"],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 " or ",
 Cell[BoxData[
  RowBox[{"a", ">", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"e", "+", 
      RowBox[{"f", " ", 
       SuperscriptBox["x", "m"]}]}], ")"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], "=", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox["a", 
      RowBox[{"m", "+", "1"}]]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"e", " ", 
       SuperscriptBox["a", "m"]}], "+", 
      RowBox[{"f", " ", 
       SuperscriptBox[
        RowBox[{"Tanh", "[", 
         RowBox[{"ArcTanh", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "]"}], "m"]}]}], ")"}], 
    SuperscriptBox[
     RowBox[{"Sech", "[", 
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "]"}], 
     RowBox[{"2", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}]], " ", 
    SuperscriptBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664448654022*^9, 3.479664485386842*^9, {3.4796905699999485`*^9, 
   3.4796905930330687`*^9}, {3.493066205237155*^9, 3.493066233807195*^9}, {
   3.493067002288271*^9, 3.493067007218278*^9}, {3.4930671665685015`*^9, 
   3.4930671719285088`*^9}, {3.49357941453937*^9, 3.4935794178593745`*^9}, {
   3.4935794530694237`*^9, 3.4935794623694367`*^9}, {3.493579591189617*^9, 
   3.4935795950296226`*^9}, {3.4935796369196815`*^9, 3.493579680229742*^9}, {
   3.4935798057299175`*^9, 3.493579823249942*^9}, {3.493580013000208*^9, 
   3.4935800183302155`*^9}, {3.4935837156853914`*^9, 
   3.4935837306154127`*^9}, {3.493583770785469*^9, 3.4935837932255*^9}, 
   3.493583845935574*^9, {3.49497090133292*^9, 3.4949709217329493`*^9}, {
   3.4949709668630123`*^9, 3.4949710356931086`*^9}, {3.494971138883253*^9, 
   3.494971138883253*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
    RowBox[{"0", " ", "\[And]", " ", "m"}]}], ",", "n", ",", 
   RowBox[{
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "\[Or]", " ", 
      RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}], ")"}], " ",
     "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[Or]", 
      " ", 
      RowBox[{"c", ">", "0"}]}], ")"}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[Or]", 
      " ", 
      RowBox[{"a", ">", "0"}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930669874082503`*^9, 
   3.4930669888982525`*^9}, {3.4932562746689816`*^9, 
   3.4932562746689816`*^9}, {3.493256683249553*^9, 3.4932567141395965`*^9}, {
   3.493484196390273*^9, 3.493484198590276*^9}, {3.4934849126412754`*^9, 
   3.493484912921276*^9}, {3.4934858273225565`*^9, 3.4934858277825565`*^9}, {
   3.4934858606226025`*^9, 3.493485878442628*^9}, {3.493485980752771*^9, 
   3.493486013532817*^9}, 3.4934861613430243`*^9, {3.493582299533409*^9, 
   3.493582299533409*^9}, {3.49358240752356*^9, 3.49358240752356*^9}, {
   3.493584403266354*^9, 3.4935844505964203`*^9}, {3.493584685416749*^9, 
   3.4935846881867533`*^9}, {3.4935847277768087`*^9, 
   3.4935847301168118`*^9}, {3.4935855704579883`*^9, 3.4935855725279913`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"e", "+", 
     RowBox[{"f", " ", 
      SuperscriptBox["x", "m"]}]}], ")"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
   SuperscriptBox[
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SuperscriptBox["c", "p"], 
      SuperscriptBox["a", 
       RowBox[{"m", "+", "1"}]]]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", "n"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"e", " ", 
          SuperscriptBox["a", "m"]}], "+", 
         RowBox[{"f", " ", 
          SuperscriptBox[
           RowBox[{"Tanh", "[", "x", "]"}], "m"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"Sech", "[", "x", "]"}], 
        RowBox[{"2", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579733429823`*^9, 3.4796580025249443`*^9}, {
   3.4796580760106115`*^9, 3.479658076961979*^9}, {3.479658170546547*^9, 
   3.47965817467248*^9}, {3.4796583692823153`*^9, 3.4796583839634256`*^9}, {
   3.4796584934408464`*^9, 3.479658497486664*^9}, {3.479661194084181*^9, 
   3.47966122030188*^9}, 3.479661392649704*^9, {3.4796614543984947`*^9, 
   3.4796614565015182`*^9}, {3.4796616029320755`*^9, 3.47966160861024*^9}, 
   3.479661772305622*^9, 3.47966185512471*^9, {3.4796624643307056`*^9, 
   3.4796624837586412`*^9}, {3.4796684805015345`*^9, 3.479668482213997*^9}, {
   3.47968672053469*^9, 3.479686720544704*^9}, {3.4796906638949633`*^9, 
   3.479690664315568*^9}, {3.479690714507741*^9, 3.4796907460130434`*^9}, 
   3.480705514654872*^9, {3.4930650337755156`*^9, 3.493065049545537*^9}, {
   3.4930657623365355`*^9, 3.4930657881965714`*^9}, {3.4930663212373176`*^9, 
   3.493066363577377*^9}, {3.493066963568217*^9, 3.493066975738234*^9}, 
   3.4932537469796257`*^9, 3.493256113988756*^9, {3.4932567461396413`*^9, 
   3.4932567491696453`*^9}, 3.493484110810153*^9, {3.4934842003402786`*^9, 
   3.4934842033302827`*^9}, {3.4934849452513213`*^9, 3.493484979331369*^9}, {
   3.493583483165066*^9, 3.4935834997850895`*^9}, {3.4935840350458384`*^9, 
   3.493584038155843*^9}, {3.4949712212333684`*^9, 3.494971230293381*^9}, {
   3.4949712621134253`*^9, 3.4949712970934744`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"e_.", "+", 
       RowBox[{"f_.", "*", 
        RowBox[{"x_", "^", "m_."}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_"}], "*", 
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"c", "^", "p"}], "/", 
      RowBox[{"a", "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Expand", "[", 
          RowBox[{
           RowBox[{"x", "^", "n"}], "*", 
           RowBox[{"TrigReduce", "[", 
            RowBox[{"Regularize", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"e", "*", 
                  RowBox[{"a", "^", "m"}]}], "+", 
                 RowBox[{"f", "*", 
                  RowBox[{
                   RowBox[{"Tanh", "[", "x", "]"}], "^", "m"}]}]}], ")"}], 
               "*", 
               RowBox[{
                RowBox[{"Sech", "[", "x", "]"}], "^", 
                RowBox[{"(", 
                 RowBox[{"2", "*", 
                  RowBox[{"(", 
                   RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], ",", "x"}], 
             "]"}], "]"}]}], "]"}], ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", "*", "x"}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "||", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}], ")"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "p", "]"}], " ", "||", " ", 
      RowBox[{"PositiveQ", "[", "c", "]"}]}], ")"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "m", "]"}], " ", "||", " ", 
      RowBox[{"PositiveQ", "[", "a", "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.493065103075612*^9, 3.493065290765875*^9}, {
   3.493065714046468*^9, 3.493065729586489*^9}, {3.4930658063465967`*^9, 
   3.4930658068865976`*^9}, {3.493067047288334*^9, 3.493067049548337*^9}, {
   3.4930670867783895`*^9, 3.493067112388425*^9}, {3.4930674070088377`*^9, 
   3.4930674148588486`*^9}, {3.4930676846992264`*^9, 
   3.4930676962292423`*^9}, {3.493484206670287*^9, 3.4934842155203*^9}, 
   3.4934861347329865`*^9, {3.49348619445307*^9, 3.493486231663122*^9}, {
   3.4934862761831846`*^9, 3.4934862874732003`*^9}, {3.493580741261227*^9, 
   3.4935807428812294`*^9}, {3.4935808762114162`*^9, 3.493580878411419*^9}, {
   3.4935841108559446`*^9, 3.4935841493659987`*^9}, {3.493584751096841*^9, 
   3.4935847734468727`*^9}, 3.4935848245769444`*^9, {3.493584859686993*^9, 
   3.493584861126995*^9}, 3.493585344727672*^9, 3.4935853768577175`*^9, {
   3.4935856376880827`*^9, 3.4935856399880857`*^9}, {3.4949713407035356`*^9, 
   3.494971373883582*^9}, {3.494971426013655*^9, 3.4949714378836718`*^9}, {
   3.494972220994768*^9, 3.49497223640479*^9}, {3.4949725116251745`*^9, 
   3.494972523895192*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], "=", 
   RowBox[{
    FractionBox["1", "a"], 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"Tanh", "[", 
        RowBox[{"ArcTanh", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "]"}], "a"], ")"}], "m"], 
    SuperscriptBox[
     RowBox[{"Sech", "[", 
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "]"}], 
     RowBox[{"2", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}]], " ", 
    SuperscriptBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664448654022*^9, 3.479664485386842*^9, {3.4796905699999485`*^9, 
   3.4796905930330687`*^9}, {3.493066205237155*^9, 3.493066233807195*^9}, {
   3.493067002288271*^9, 3.493067007218278*^9}, {3.4930671665685015`*^9, 
   3.4930671719285088`*^9}, {3.49357941453937*^9, 3.4935794178593745`*^9}, {
   3.4935794530694237`*^9, 3.4935794623694367`*^9}, {3.493579591189617*^9, 
   3.4935795950296226`*^9}, {3.4935796369196815`*^9, 3.493579680229742*^9}, {
   3.4935798057299175`*^9, 3.493579823249942*^9}, {3.493580013000208*^9, 
   3.4935800183302155`*^9}, {3.4935837156853914`*^9, 
   3.4935837306154127`*^9}, {3.493583770785469*^9, 3.4935837932255*^9}, 
   3.493583845935574*^9, {3.493585128467369*^9, 3.493585152037402*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
    RowBox[{"0", " ", "\[And]", " ", "m"}]}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "\[Or]", " ", 
      RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}], ")"}], " ",
     "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[Or]", 
      " ", 
      RowBox[{"c", ">", "0"}]}], ")"}], " ", "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[Or]", 
       " ", 
       RowBox[{"a", ">", "0"}]}], ")"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930669874082503`*^9, 
   3.4930669888982525`*^9}, {3.4932562746689816`*^9, 
   3.4932562746689816`*^9}, {3.493256683249553*^9, 3.4932567141395965`*^9}, {
   3.493484196390273*^9, 3.493484198590276*^9}, {3.4934849126412754`*^9, 
   3.493484912921276*^9}, {3.4934858273225565`*^9, 3.4934858277825565`*^9}, {
   3.4934858606226025`*^9, 3.493485878442628*^9}, {3.493485980752771*^9, 
   3.493486013532817*^9}, 3.4934860446528606`*^9, 3.493486166643031*^9, {
   3.493582304453416*^9, 3.493582304453416*^9}, {3.4935823991735487`*^9, 
   3.4935823991735487`*^9}, {3.49358546440784*^9, 3.4935854739178534`*^9}, 
   3.4935855059178977`*^9, {3.4937503523187337`*^9, 3.4937503527399344`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
   SuperscriptBox[
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SuperscriptBox["c", "p"], "a"]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", "n"], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Tanh", "[", "x", "]"}], "/", "a"}], ")"}], "m"], " ", 
       SuperscriptBox[
        RowBox[{"Sech", "[", "x", "]"}], 
        RowBox[{"2", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579733429823`*^9, 3.4796580025249443`*^9}, {
   3.4796580760106115`*^9, 3.479658076961979*^9}, {3.479658170546547*^9, 
   3.47965817467248*^9}, {3.4796583692823153`*^9, 3.4796583839634256`*^9}, {
   3.4796584934408464`*^9, 3.479658497486664*^9}, {3.479661194084181*^9, 
   3.47966122030188*^9}, 3.479661392649704*^9, {3.4796614543984947`*^9, 
   3.4796614565015182`*^9}, {3.4796616029320755`*^9, 3.47966160861024*^9}, 
   3.479661772305622*^9, 3.47966185512471*^9, {3.4796624643307056`*^9, 
   3.4796624837586412`*^9}, {3.4796684805015345`*^9, 3.479668482213997*^9}, {
   3.47968672053469*^9, 3.479686720544704*^9}, {3.4796906638949633`*^9, 
   3.479690664315568*^9}, {3.479690714507741*^9, 3.4796907460130434`*^9}, 
   3.480705514654872*^9, {3.4930650337755156`*^9, 3.493065049545537*^9}, {
   3.4930657623365355`*^9, 3.4930657881965714`*^9}, {3.4930663212373176`*^9, 
   3.493066363577377*^9}, {3.493066963568217*^9, 3.493066975738234*^9}, 
   3.4932537469796257`*^9, 3.493256113988756*^9, {3.4932567461396413`*^9, 
   3.4932567491696453`*^9}, 3.493484110810153*^9, {3.4934842003402786`*^9, 
   3.4934842033302827`*^9}, {3.4934849452513213`*^9, 3.493484979331369*^9}, {
   3.493486071912899*^9, 3.493486082822914*^9}, {3.4935835296251307`*^9, 
   3.4935835407851467`*^9}, {3.493585265387561*^9, 3.4935852691475663`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_"}], "*", 
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"c", "^", "p"}], "/", "a"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "n"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Tanh", "[", "x", "]"}], "/", "a"}], ")"}], "^", "m"}], 
          "*", 
          RowBox[{
           RowBox[{"Sech", "[", "x", "]"}], "^", 
           RowBox[{"(", 
            RowBox[{"2", "*", 
             RowBox[{"(", 
              RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], ",", "x"}], "]"}], 
       ",", "x", ",", 
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", "*", "x"}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "||", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}], ")"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "p", "]"}], " ", "||", " ", 
      RowBox[{"PositiveQ", "[", "c", "]"}]}], ")"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "m", "]"}], " ", "||", " ", 
      RowBox[{"PositiveQ", "[", "a", "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.493065103075612*^9, 3.493065290765875*^9}, {
   3.493065714046468*^9, 3.493065729586489*^9}, {3.4930658063465967`*^9, 
   3.4930658068865976`*^9}, {3.493067047288334*^9, 3.493067049548337*^9}, {
   3.4930670867783895`*^9, 3.493067112388425*^9}, {3.4930674070088377`*^9, 
   3.4930674148588486`*^9}, {3.4930676846992264`*^9, 
   3.4930676962292423`*^9}, {3.493484206670287*^9, 3.4934842155203*^9}, 
   3.4934861304629803`*^9, 3.4934861903430643`*^9, {3.4934862534031525`*^9, 
   3.493486262273165*^9}, {3.4934862996232176`*^9, 3.4934863089332304`*^9}, {
   3.4935808677814045`*^9, 3.493580870141408*^9}, {3.4935853052876167`*^9, 
   3.493585373757713*^9}, {3.4935856061680384`*^9, 3.493585615798052*^9}, 
   3.493585663598119*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["c", 
        RowBox[{"p", "-", 
         FractionBox["1", "2"]}]], 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}]]}], 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["x", "2"]}]}]]], ",", "x"}], "]"}], "=", "0"}]],
  CellChangeTimes->{{3.4937498379858303`*^9, 3.4937499017587423`*^9}, {
   3.4937499674816575`*^9, 3.493750029569767*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664448654022*^9, 3.479664485386842*^9, {3.4796905699999485`*^9, 
   3.4796905930330687`*^9}, {3.493066205237155*^9, 3.493066233807195*^9}, {
   3.493067002288271*^9, 3.493067007218278*^9}, {3.4930671665685015`*^9, 
   3.4930671719285088`*^9}, {3.49357941453937*^9, 3.4935794178593745`*^9}, {
   3.4935794530694237`*^9, 3.4935794623694367`*^9}, {3.493579591189617*^9, 
   3.4935795950296226`*^9}, {3.4935796369196815`*^9, 3.493579680229742*^9}, {
   3.4935798057299175`*^9, 3.493579823249942*^9}, {3.493580013000208*^9, 
   3.4935800183302155`*^9}, {3.4937499298855915`*^9, 
   3.4937499486524243`*^9}, {3.4937500390389833`*^9, 3.4937500431885905`*^9}, 
   3.4937501538707848`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
    RowBox[{"0", " ", "\[And]", " ", "m"}]}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "\[Or]", " ", 
      RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}], ")"}], " ",
     "\[And]", " ", 
    RowBox[{
     RowBox[{"p", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{"c", ">", "0"}], ")"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930680892297926`*^9, 
   3.4930681267098455`*^9}, {3.4930801578959255`*^9, 
   3.4930801961259785`*^9}, {3.493256255798955*^9, 3.4932562676389713`*^9}, {
   3.4934842169503016`*^9, 3.4934842179803033`*^9}, {3.4934855092121105`*^9, 
   3.4934855137621174`*^9}, {3.49358230776342*^9, 3.49358230776342*^9}, {
   3.4935823874135323`*^9, 3.4935823874135323`*^9}, {3.493586084528708*^9, 
   3.4935861150187507`*^9}, {3.493750356390341*^9, 3.493750356561941*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
   SuperscriptBox[
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox["c", 
        RowBox[{"p", "-", 
         FractionBox["1", "2"]}]], 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}]]}], 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["x", "2"]}]}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], 
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579733429823`*^9, 3.4796580025249443`*^9}, {
   3.4796580760106115`*^9, 3.479658076961979*^9}, {3.479658170546547*^9, 
   3.47965817467248*^9}, {3.4796583692823153`*^9, 3.4796583839634256`*^9}, {
   3.4796584934408464`*^9, 3.479658497486664*^9}, {3.479661194084181*^9, 
   3.47966122030188*^9}, 3.479661392649704*^9, {3.4796614543984947`*^9, 
   3.4796614565015182`*^9}, {3.4796616029320755`*^9, 3.47966160861024*^9}, 
   3.479661772305622*^9, 3.47966185512471*^9, {3.4796624643307056`*^9, 
   3.4796624837586412`*^9}, {3.4796684805015345`*^9, 3.479668482213997*^9}, {
   3.47968672053469*^9, 3.479686720544704*^9}, {3.4796906638949633`*^9, 
   3.479690664315568*^9}, {3.479690714507741*^9, 3.4796907460130434`*^9}, 
   3.480705514654872*^9, {3.4930650337755156`*^9, 3.493065049545537*^9}, {
   3.4930657623365355`*^9, 3.4930657881965714`*^9}, {3.493077421798092*^9, 
   3.4930774294181027`*^9}, {3.49307964724521*^9, 3.493079659035227*^9}, {
   3.4930797467153497`*^9, 3.493079763295373*^9}, {3.493079973595667*^9, 
   3.4930800012057056`*^9}, {3.4932537598652487`*^9, 3.4932537660740595`*^9}, 
   3.493256110328751*^9, 3.4934841140101576`*^9, {3.4934842214303083`*^9, 
   3.49348422304031*^9}, 3.493485244821741*^9, 3.4934853226618495`*^9, {
   3.49358577884828*^9, 3.493585797488306*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_"}], "*", 
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"c", "^", 
     RowBox[{"(", 
      RowBox[{"p", "-", 
       RowBox[{"1", "/", "2"}]}], ")"}]}], "*", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "-", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}]}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "m"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "*", 
           RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
       RowBox[{
        RowBox[{"ArcTanh", "[", 
         RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "||", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}], ")"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"p", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PositiveQ", "[", "c", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.493065103075612*^9, 3.493065290765875*^9}, {
   3.493065714046468*^9, 3.493065729586489*^9}, {3.4930658063465967`*^9, 
   3.4930658068865976`*^9}, {3.493067423888861*^9, 3.4930674284788675`*^9}, 
   3.493068077149776*^9, {3.493080071975805*^9, 3.493080131335888*^9}, {
   3.4930802396760397`*^9, 3.4930802468960495`*^9}, {3.4932538772710547`*^9, 
   3.4932538805314603`*^9}, {3.493484225600314*^9, 3.493484231900323*^9}, {
   3.4934853924419475`*^9, 3.4934853982519555`*^9}, {3.493485439292013*^9, 
   3.4934854647520485`*^9}, {3.493580855471387*^9, 3.4935808593213925`*^9}, {
   3.4935858177883344`*^9, 3.4935858468983755`*^9}, 3.493585879718421*^9, 
   3.493586196118864*^9, {3.4935862626189575`*^9, 3.493586266048962*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"ArcTanh", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, {
   3.4796161531027007`*^9, 3.4796161533330317`*^9}, 3.4796867035102096`*^9, {
   3.4928216890767465`*^9, 3.4928216998095655`*^9}, {3.4928217819749093`*^9, 
   3.492821789587723*^9}, {3.4928219276815653`*^9, 3.492821955418414*^9}, {
   3.492821987970072*^9, 3.4928219896860743`*^9}, {3.4928221957624364`*^9, 
   3.4928222365253077`*^9}, {3.492825657442519*^9, 3.4928256592053223`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: CRC 585, A&S 4.6.45", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070527384861*^9, 3.494109939029312*^9, 3.494112226023958*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], " ", 
        RowBox[{"ArcTanh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}]}], "b"]}]}]}]}], "+", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "2"]}], "]"}], 
   RowBox[{"2", " ", "b"}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579729524207`*^9, 3.479658002354699*^9}, {
   3.479658032958706*^9, 3.479658033819944*^9}, {3.479658266604672*^9, 
   3.479658270990979*^9}, 3.4796611918409553`*^9, {3.4796613913478317`*^9, 
   3.47966140315481*^9}, {3.479661508025606*^9, 3.47966151197128*^9}, {
   3.4796618227781982`*^9, 3.4796618235292788`*^9}, 3.479666675846568*^9, {
   3.4796867202542863`*^9, 3.479686720274315*^9}, {3.4796868616776433`*^9, 
   3.479686861938018*^9}, 3.480705278835781*^9, 3.4941093719059157`*^9, {
   3.494111977016321*^9, 3.4941119773283215`*^9}, {3.494112096481331*^9, 
   3.494112145325017*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a_", "+", 
      RowBox[{"b_.", "*", "x_"}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "/", "b"}]}], " ", "+", " ", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "b"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494109908110058*^9, 3.4941099093268595`*^9}, 
   3.49411043303938*^9, 3.494110873053753*^9, {3.4941120188555946`*^9, 
   3.494112019183195*^9}, {3.4941122005335135`*^9, 3.494112205135522*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: CRC 585, A&S 4.6.45", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070527384861*^9, 3.494109939029312*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "x"}]}], " ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}]}]}], "-", 
  RowBox[{"b", " ", "n", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox["x", "n"], 
      RowBox[{"1", "-", 
       SuperscriptBox["a", "2"], "-", 
       RowBox[{"2", " ", "a", " ", "b", " ", 
        SuperscriptBox["x", "n"]}], "-", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579729524207`*^9, 3.479658002354699*^9}, {
   3.479658032958706*^9, 3.479658033819944*^9}, {3.479658266604672*^9, 
   3.479658270990979*^9}, 3.4796611918409553`*^9, {3.4796613913478317`*^9, 
   3.47966140315481*^9}, {3.479661508025606*^9, 3.47966151197128*^9}, {
   3.4796618227781982`*^9, 3.4796618235292788`*^9}, 3.479666675846568*^9, {
   3.4796867202542863`*^9, 3.479686720274315*^9}, {3.4796868616776433`*^9, 
   3.479686861938018*^9}, 3.480705278835781*^9, 3.4941093719059157`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a_", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"x_", "^", "n_"}]}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}]}], "]"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "n"}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"2", "*", "a", "*", "b", "*", 
            RowBox[{"x", "^", "n"}]}], "-", 
           RowBox[{
            RowBox[{"b", "^", "2"}], "*", 
            RowBox[{"x", "^", 
             RowBox[{"(", 
              RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494109908110058*^9, 3.4941099093268595`*^9}, 
   3.49411043303938*^9, 3.494110873053753*^9, {3.4941119993711605`*^9, 
   3.494112013270785*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"ArcTanh", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796867203043585`*^9, {3.4928222468993263`*^9, 3.492822253420138*^9}, {
   3.4928256632301292`*^9, 3.4928256645561314`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"ArcTanh", "[", "z", "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", "z"}], "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", "z"}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050798897104`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], "x"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"Log", "[", 
        RowBox[{"1", "+", "a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "n"]}]}], "]"}], "x"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"Log", "[", 
       RowBox[{"1", "-", "a", "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], "]"}], "x"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579730125074`*^9, 3.479658002374728*^9}, 
   3.479658039448037*^9, 3.479661193793763*^9, {3.4796615158368387`*^9, 
   3.479661531599504*^9}, 3.4796867203243876`*^9, {3.4796869232261457`*^9, 
   3.4796869451176243`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], "]"}], "/", "x_"}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"1", "+", "a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}]}], "]"}], "/", "x"}], ",", "x"}], 
       "]"}]}], "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"1", "-", "a", "-", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}]}], "]"}], "/", "x"}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{3.49411042149536*^9, 3.4941115092494993`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: CRC 588, A&S 4.6.54", "Subsubsection",
 CellChangeTimes->{3.479686957936056*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{
     RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "+", "1"}], "\[NotEqual]", "n"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.480705286316538*^9, {3.4941088512110004`*^9, 3.494108875297443*^9}, {
   3.4941089257323313`*^9, 3.494108953812381*^9}, {3.494109011158081*^9, 
   3.4941090265241084`*^9}, {3.4941099489353294`*^9, 3.494109954473339*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"ArcTanh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "n"]}]}], "]"}]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", "n"}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox["x", 
       RowBox[{"m", "+", "n"}]], 
      RowBox[{"1", "-", 
       SuperscriptBox["a", "2"], "-", 
       RowBox[{"2", " ", "a", " ", "b", " ", 
        SuperscriptBox["x", "n"]}], "-", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.47965797304255*^9, 3.4796580023847427`*^9}, {
   3.479658043163379*^9, 3.47965804398456*^9}, 3.479658468995696*^9, {
   3.479658610368981*^9, 3.479658625961402*^9}, {3.479661193843835*^9, 
   3.4796612201817074`*^9}, {3.47966139238933*^9, 3.479661423644272*^9}, {
   3.479661536146042*^9, 3.4796615416739902`*^9}, 3.4796617640337276`*^9, 
   3.4796618325222096`*^9, 3.4796668662303267`*^9, {3.4796867203344016`*^9, 
   3.4796867203344016`*^9}, {3.4796869701135664`*^9, 3.4796869707144303`*^9}, 
   3.480705289451045*^9, 3.494108723711976*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"x", "^", "n"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", 
       RowBox[{"n", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "n"}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"2", "*", "a", "*", "b", "*", 
            RowBox[{"x", "^", "n"}]}], "-", 
           RowBox[{
            RowBox[{"b", "^", "2"}], "*", 
            RowBox[{"x", "^", 
             RowBox[{"(", 
              RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"m", "+", "1"}], "\[NotEqual]", "n"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4941089013182883`*^9, 3.494108917386317*^9}, {
   3.494109041609335*^9, 3.494109066584979*^9}, 3.494109140809909*^9, {
   3.4941099607133503`*^9, 3.4941099676865625`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.49283103988311*^9, 3.492831064713145*^9}, {3.4928318015941763`*^9, 
   3.492831805684182*^9}, {3.494096886328291*^9, 3.4940968902482967`*^9}, {
   3.4941055608920193`*^9, 3.4941055608920193`*^9}, {3.4941056188533216`*^9, 
   3.4941056188533216`*^9}, {3.49410967008484*^9, 3.49410967008484*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcTanh", "[", "x", "]"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732428384`*^9, 3.479658002484886*^9}, {
   3.4796580646743107`*^9, 3.479658065695779*^9}, 3.4796611938939075`*^9, {
   3.4796867205046463`*^9, 3.479686740233014*^9}, 3.479694163016453*^9, 
   3.479694241058672*^9, {3.4928308514228463`*^9, 3.4928309174229383`*^9}, {
   3.4928311838033113`*^9, 3.4928311994833336`*^9}, 3.492831236813386*^9, {
   3.494096850808242*^9, 3.4940968754382763`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "b"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ArcTanh", "[", "x", "]"}], "^", "n"}], ",", "x"}], "]"}], 
       ",", "x", ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4928312031533384`*^9, 3.4928312054633417`*^9}, {
  3.4940968956183043`*^9, 3.494096916128333*^9}, {3.494105549363599*^9, 
  3.494105556134011*^9}, {3.494109621771555*^9, 3.4941096256559615`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.492802747642827*^9, 
   3.492802751137233*^9}, 3.4928222777249804`*^9, 3.492825819138003*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.49283103988311*^9, 3.492831064713145*^9}, {3.4928318015941763`*^9, 
   3.492831805684182*^9}, {3.494105585344463*^9, 3.494105589868471*^9}, {
   3.4941069232880135`*^9, 3.4941069232880135`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      SuperscriptBox["b", 
       RowBox[{"m", "+", "1"}]]]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "-", "a"}], ")"}], "m"], " ", 
       SuperscriptBox[
        RowBox[{"ArcTanh", "[", "x", "]"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732428384`*^9, 3.479658002484886*^9}, {
   3.4796580646743107`*^9, 3.479658065695779*^9}, 3.4796611938939075`*^9, {
   3.4796867205046463`*^9, 3.479686740233014*^9}, 3.479694163016453*^9, 
   3.479694241058672*^9, {3.4928308514228463`*^9, 3.4928309174229383`*^9}, {
   3.4928311838033113`*^9, 3.4928311994833336`*^9}, 3.492831236813386*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"b", "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"x", "-", "a"}], ")"}], "^", "m"}], "*", 
          RowBox[{
           RowBox[{"ArcTanh", "[", "x", "]"}], "^", "n"}]}], ",", "x"}], 
        "]"}], ",", "x", ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4928312031533384`*^9, 3.4928312054633417`*^9}, {
   3.4941055723112392`*^9, 3.4941055999928885`*^9}, {3.494106916018401*^9, 
   3.494106918810806*^9}, 3.5171886367718873`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "n"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, 3.4802882652733135`*^9, 3.480288373839424*^9, {
   3.480299236238787*^9, 3.480299238211624*^9}, {3.4803010920372944`*^9, 
   3.480301103143264*^9}, {3.4928037993654737`*^9, 3.49280383115833*^9}, 
   3.4928257757543263`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"ArcTanh", "[", "z", "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", "z"}], "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", "z"}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{3.48030057193943*^9, 3.4803006163232512`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{"n", "=", 
      RowBox[{
       RowBox[{"2", "\[And]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "c"}], "+", "d"}]}], "=", "0"}]}], 
     ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055445578704`*^9, 3.49282853967961*^9, {3.4928286506197653`*^9, 
   3.4928286988398323`*^9}, {3.493751094490037*^9, 3.4937510948176374`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"b", " ", "x"}], "]"}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "n"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"Log", "[", 
        RowBox[{"1", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}], 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "n"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"Log", "[", 
       RowBox[{"1", "-", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "n"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732428384`*^9, 3.479658002484886*^9}, {
   3.4796580646743107`*^9, 3.479658065695779*^9}, 3.4796611938939075`*^9, {
   3.4796867205046463`*^9, 3.479686740233014*^9}, 3.479694163016453*^9, 
   3.479694241058672*^9, {3.4928288741700783`*^9, 3.4928289166801376`*^9}, {
   3.492828963480203*^9, 3.4928290377203074`*^9}, 3.492829172840496*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcTanh", "[", 
      RowBox[{"b_.", "*", "x_"}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"1", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"1", "-", 
           RowBox[{"b", "*", "x"}]}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"n", "==", "2"}], " ", "&&", " ", 
      RowBox[{"ZeroQ", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", "c"}], "+", "d"}], "]"}]}], 
     "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"ArcTanh", "[", "z", "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", "z"}], "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", "z"}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{3.48030057193943*^9, 3.4803006163232512`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{"n", "=", 
      RowBox[{
       RowBox[{"1", "\[And]", 
        RowBox[{
         RowBox[{"a", " ", "d"}], "-", 
         RowBox[{"b", " ", "c"}]}]}], "=", "0"}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055445578704`*^9, 3.49282853967961*^9, {3.4928286506197653`*^9, 
   3.4928286988398323`*^9}, {3.492828783319951*^9, 3.492828794439966*^9}, {
   3.4937511084520617`*^9, 3.4937511087484617`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "n"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"Log", "[", 
        RowBox[{"1", "+", "a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}], 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "n"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"Log", "[", 
       RowBox[{"1", "-", "a", "-", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "n"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732428384`*^9, 3.479658002484886*^9}, {
   3.4796580646743107`*^9, 3.479658065695779*^9}, 3.4796611938939075`*^9, {
   3.4796867205046463`*^9, 3.479686740233014*^9}, 3.479694163016453*^9, 
   3.479694241058672*^9, {3.4928288741700783`*^9, 3.4928289166801376`*^9}, {
   3.492828963480203*^9, 3.4928290377203074`*^9}, {3.4928290833603706`*^9, 
   3.4928291010103955`*^9}, 3.492829178180504*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"1", "+", "a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"1", "-", "a", "-", 
           RowBox[{"b", "*", "x"}]}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"n", "==", "1"}], " ", "&&", " ", 
      RowBox[{"ZeroQ", "[", 
       RowBox[{
        RowBox[{"a", "*", "d"}], "-", 
        RowBox[{"b", "*", "c"}]}], "]"}]}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox[
    RowBox[{"ArcTanh", "[", 
     FractionBox["c", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}]], "]"}], "m"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.479616049603877*^9, {3.479616359880032*^9, 3.479616363935864*^9}, 
   3.47968672044456*^9, 3.4928223678463387`*^9, 3.4928258146763945`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"ArcTanh", "[", "z", "]"}], "=", 
   RowBox[{"ArcCoth", "[", 
    FractionBox["1", "z"], "]"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664443126074*^9, 3.479664484795992*^9, {3.479686720494632*^9, 
   3.479686740223*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807051268772755`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox[
    RowBox[{"ArcTanh", "[", 
     FractionBox["c", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}]], "]"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{"u", " ", 
       SuperscriptBox[
        RowBox[{"ArcCoth", "[", 
         RowBox[{
          FractionBox["a", "c"], "+", 
          FractionBox[
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}], "c"]}], "]"}], "m"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732428384`*^9, 3.479658002484886*^9}, {
   3.4796580646743107`*^9, 3.479658065695779*^9}, 3.4796611938939075`*^9, {
   3.4796867205046463`*^9, 3.479686740233014*^9}, 3.479694163016453*^9, 
   3.479694241058672*^9, {3.4928308514228463`*^9, 3.4928309174229383`*^9}, {
   3.4928311838033113`*^9, 3.4928311994833336`*^9}, 3.492831236813386*^9, {
   3.493250536928784*^9, 3.4932505561012177`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"c_.", "/", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", 
           RowBox[{"x_", "^", "n_."}]}]}], ")"}]}], "]"}], "^", "m_."}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u", "*", 
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{
         RowBox[{"a", "/", "c"}], "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"x", "^", "n"}], "/", "c"}]}]}], "]"}], "^", "m"}]}], ",", 
     "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "n", ",", "m"}], "}"}], ",", 
     "x"}], "]"}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"f", "[", 
     RowBox[{"x", ",", 
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}], 
    RowBox[{"1", "-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.479616049603877*^9, {3.479616359880032*^9, 3.479616363935864*^9}, 
   3.47968672044456*^9, 3.4796940040278387`*^9, 3.492822371293945*^9, 
   3.492825811400389*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"f", "[", "z", "]"}], 
    RowBox[{"1", "-", 
     SuperscriptBox["z", "2"]}]], "=", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"Tanh", "[", 
      RowBox[{"ArcTanh", "[", "z", "]"}], "]"}], "]"}], " ", 
    RowBox[{
     SuperscriptBox["ArcTanh", "\[Prime]",
      MultilineFunction->None], "[", "z", "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4796941282865133`*^9, {3.4799455651493073`*^9, 3.4799455651493073`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"r", "+", 
    RowBox[{"s", " ", "x"}], "+", 
    RowBox[{"t", " ", 
     SuperscriptBox["x", "2"]}]}], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["s", "2"], "-", 
       RowBox[{"4", " ", "r", " ", "t"}]}], 
      RowBox[{"4", " ", "t"}]]}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"s", "+", 
          RowBox[{"2", " ", "t", " ", "x"}]}], ")"}], "2"], 
       RowBox[{
        SuperscriptBox["s", "2"], "-", 
        RowBox[{"4", " ", "r", " ", "t"}]}]]}], ")"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4796941282865133`*^9, {3.4799455651493073`*^9, 3.4799455651493073`*^9}, {
   3.492803054651366*^9, 3.492803093277034*^9}, 3.4928031261930914`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"1", "-", 
    SuperscriptBox[
     RowBox[{"Tanh", "[", "z", "]"}], "2"]}], "=", 
   SuperscriptBox[
    RowBox[{"Sech", "[", "z", "]"}], "2"]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4796941282865133`*^9, {3.4799455651493073`*^9, 3.4799455651493073`*^9}, {
   3.492803054651366*^9, 3.492803093277034*^9}, {3.4928031381427126`*^9, 
   3.4928031451783247`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.480705133626981*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"f", "[", 
     RowBox[{"x", ",", 
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}], 
    RowBox[{"1", "-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           FractionBox["a", "b"]}], "+", 
          FractionBox[
           RowBox[{"Tanh", "[", "x", "]"}], "b"]}], ",", "x"}], "]"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732428384`*^9, 3.479658002484886*^9}, {
   3.4796580646743107`*^9, 3.479658065695779*^9}, 3.4796611938939075`*^9, {
   3.4796867205046463`*^9, 3.479686740233014*^9}, 3.479694163016453*^9, 
   3.479694241058672*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u_", "*", 
       RowBox[{"v_", "^", "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", 
    "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"tmp", "=", 
         RowBox[{"InverseFunctionOfLinear", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<\>\"", ",", "\"\<Int[f[x,ArcTanh[a+b*x]]/(1-(a+b*x)^2),x]\>\"", 
          ",", "\n", "\t\t   ", 
          "\"\<Subst[Int[f[-a/b+Tanh[x]/b,x],x],x,ArcTanh[a+b*x]]/b\>\"", ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{"Dist", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"Discriminant", "[", 
                   RowBox[{"v", ",", "x"}], "]"}]}], "/", 
                 RowBox[{"(", 
                  RowBox[{"4", "*", 
                   RowBox[{"Coefficient", "[", 
                    RowBox[{"v", ",", "x", ",", "2"}], "]"}]}], ")"}]}], 
                ")"}], "^", "n"}], "/", 
              RowBox[{"Coefficient", "[", 
               RowBox[{
                RowBox[{"tmp", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ",", "x", ",", "1"}], 
               "]"}]}], ",", "\n", "\t", 
             RowBox[{"Subst", "[", 
              RowBox[{
               RowBox[{"Int", "[", 
                RowBox[{
                 RowBox[{"Regularize", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"SubstForInverseFunction", "[", 
                    RowBox[{"u", ",", "tmp", ",", "x"}], "]"}], "*", 
                    RowBox[{
                    RowBox[{"Sech", "[", "x", "]"}], "^", 
                    RowBox[{"(", 
                    RowBox[{"2", "*", 
                    RowBox[{"(", 
                    RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], ",", "x"}], 
                  "]"}], ",", "x"}], "]"}], ",", " ", "x", ",", " ", "tmp"}], 
              "]"}]}], "]"}], "]"}]}], "]"}], " ", "/;", "\n", " ", 
        RowBox[{
         RowBox[{"NotFalseQ", "[", "tmp", "]"}], " ", "&&", " ", 
         RowBox[{
          RowBox[{"Head", "[", "tmp", "]"}], "===", "ArcTanh"}], " ", "&&", 
         " ", 
         RowBox[{"ZeroQ", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Discriminant", "[", 
             RowBox[{"v", ",", "x"}], "]"}], "*", 
            RowBox[{
             RowBox[{"tmp", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "^", "2"}]}], "-", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"v", ",", "x"}], "]"}], "^", "2"}]}], "]"}]}]}]}], "]"}],
      " ", "/;", "\n", 
     RowBox[{"SimplifyFlag", " ", "&&", " ", 
      RowBox[{"QuadraticQ", "[", 
       RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
      RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
      RowBox[{"n", "<", "0"}], " ", "&&", " ", 
      RowBox[{"PosQ", "[", 
       RowBox[{"Discriminant", "[", 
        RowBox[{"v", ",", "x"}], "]"}], "]"}], " ", "&&", " ", 
      RowBox[{"MatchQ", "[", 
       RowBox[{"u", ",", 
        RowBox[{
         RowBox[{"r_.", "*", 
          RowBox[{"f_", "^", "w_"}]}], " ", "/;", " ", 
         RowBox[{"FreeQ", "[", 
          RowBox[{"f", ",", "x"}], "]"}]}]}], "]"}]}]}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u_", "*", 
       RowBox[{"v_", "^", "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", 
    "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"tmp", "=", 
         RowBox[{"InverseFunctionOfLinear", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"Dist", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"Discriminant", "[", 
                RowBox[{"v", ",", "x"}], "]"}]}], "/", 
              RowBox[{"(", 
               RowBox[{"4", "*", 
                RowBox[{"Coefficient", "[", 
                 RowBox[{"v", ",", "x", ",", "2"}], "]"}]}], ")"}]}], ")"}], 
            "^", "n"}], "/", 
           RowBox[{"Coefficient", "[", 
            RowBox[{
             RowBox[{"tmp", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "x", ",", "1"}], "]"}]}], 
          ",", "\n", "\t", 
          RowBox[{"Subst", "[", 
           RowBox[{
            RowBox[{"Int", "[", 
             RowBox[{
              RowBox[{"Regularize", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"SubstForInverseFunction", "[", 
                  RowBox[{"u", ",", "tmp", ",", "x"}], "]"}], "*", 
                 RowBox[{
                  RowBox[{"Sech", "[", "x", "]"}], "^", 
                  RowBox[{"(", 
                   RowBox[{"2", "*", 
                    RowBox[{"(", 
                    RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], ",", "x"}], 
               "]"}], ",", "x"}], "]"}], ",", " ", "x", ",", " ", "tmp"}], 
           "]"}]}], "]"}], " ", "/;", "\n", " ", 
        RowBox[{
         RowBox[{"NotFalseQ", "[", "tmp", "]"}], " ", "&&", " ", 
         RowBox[{
          RowBox[{"Head", "[", "tmp", "]"}], "===", "ArcTanh"}], " ", "&&", 
         " ", 
         RowBox[{"ZeroQ", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Discriminant", "[", 
             RowBox[{"v", ",", "x"}], "]"}], "*", 
            RowBox[{
             RowBox[{"tmp", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "^", "2"}]}], "-", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"v", ",", "x"}], "]"}], "^", "2"}]}], "]"}]}]}]}], "]"}],
      " ", "/;", "\n", 
     RowBox[{
      RowBox[{"QuadraticQ", "[", 
       RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
      RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
      RowBox[{"n", "<", "0"}], " ", "&&", " ", 
      RowBox[{"PosQ", "[", 
       RowBox[{"Discriminant", "[", 
        RowBox[{"v", ",", "x"}], "]"}], "]"}], " ", "&&", " ", 
      RowBox[{"MatchQ", "[", 
       RowBox[{"u", ",", 
        RowBox[{
         RowBox[{"r_.", "*", 
          RowBox[{"f_", "^", "w_"}]}], " ", "/;", " ", 
         RowBox[{"FreeQ", "[", 
          RowBox[{"f", ",", "x"}], "]"}]}]}], "]"}]}]}]}]}], "]"}]], "Code",
 CellChangeTimes->{{3.4929838760355463`*^9, 3.492983880777954*^9}, {
  3.4929851720078225`*^9, 3.4929851812586384`*^9}, {3.4933231933196793`*^9, 
  3.4933231981696854`*^9}, {3.4933585331104183`*^9, 3.493358537618676*^9}, {
  3.4935714241857576`*^9, 3.493571428319765*^9}, {3.493588410361964*^9, 
  3.4935884965820847`*^9}, {3.4935885685121856`*^9, 3.4935886868223515`*^9}, {
  3.493588810472524*^9, 3.4935888483625774`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcTanh", "[", "v", "]"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.479616049603877*^9, {3.479616359880032*^9, 3.479616363935864*^9}, 
   3.47968672044456*^9, 3.479691629904016*^9, 3.4928258059403796`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcTanh", "[", "z", "]"}]}]], "=", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "z"}], ")"}], 
     RowBox[{"n", "/", "2"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}], 
     RowBox[{"n", "/", "2"}]]]}]]]
}], "Subsubsection",
 CellChangeTimes->{3.479691863570011*^9, 3.479691931137168*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   FractionBox["n", "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807053790799246`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcTanh", "[", "v", "]"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        RowBox[{"u", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", "v"}], ")"}], 
          RowBox[{"n", "/", "2"}]]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", "v"}], ")"}], 
         RowBox[{"n", "/", "2"}]]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796917199334717`*^9, 3.479691773630685*^9}, {
   3.47969236314837*^9, 3.4796923678050656`*^9}, 3.4796927595483646`*^9, {
   3.4796928103113585`*^9, 3.47969282922856*^9}, {3.4796928900259824`*^9, 
   3.4796928913578978`*^9}, 3.4807053815234385`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{"E", "^", 
      RowBox[{"(", 
       RowBox[{"n_.", "*", 
        RowBox[{"ArcTanh", "[", "v_", "]"}]}], ")"}]}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u", "*", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "v"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"n", "/", "2"}], ")"}]}], "/", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "v"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"n", "/", "2"}], ")"}]}]}]}], ",", "x"}], "]"}], " ", "/;", 
   "\n", 
   RowBox[{"EvenQ", "[", "n", "]"}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796932346515293`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcTanh", "[", "z", "]"}]}]], "=", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "z"}], ")"}], 
     RowBox[{"n", "/", "2"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}], 
     RowBox[{"n", "/", "2"}]]]}]]]
}], "Subsubsection",
 CellChangeTimes->{3.4796918677860737`*^9, 3.4796919317780895`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.480705387221632*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcTanh", "[", "v", "]"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", "v"}], ")"}], 
         RowBox[{"n", "/", "2"}]], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", "v"}], ")"}], 
         RowBox[{"n", "/", "2"}]]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796917210550847`*^9, 3.479691774171462*^9}, {
   3.47969221768921*^9, 3.4796922222357473`*^9}, 3.4796927603194733`*^9, {
   3.4796928116132307`*^9, 3.4796928349267535`*^9}, 3.4796928967055874`*^9, 
   3.48070538951493*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"n_.", "*", 
       RowBox[{"ArcTanh", "[", "v_", "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "v"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "/", "2"}], ")"}]}], "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "v"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "/", "2"}], ")"}]}]}], ",", "x"}], "]"}], " ", "/;", 
   "\n", 
   RowBox[{"RationalQ", "[", "n", "]"}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796932346515293`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcTanh", "[", "z", "]"}]}]], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox[
      RowBox[{"1", "+", "z"}], 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["z", "2"]}]]], ")"}], "n"]}]]]
}], "Subsubsection",
 CellChangeTimes->{3.479691871501416*^9, 3.4796919322788095`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", " ", 
   RowBox[{
    FractionBox[
     RowBox[{"n", "-", "1"}], "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}],
    " ", "\[And]"}]]],
 " v is a polynomial, then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807054045565586`*^9, 3.480705417234789*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcTanh", "[", "v", "]"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        RowBox[{
         SuperscriptBox["x", "m"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", "v"}], ")"}], "n"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           SuperscriptBox["v", "2"]}], ")"}], 
         RowBox[{"n", "/", "2"}]]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796917216960063`*^9, 3.479691774231549*^9}, {
   3.4796923906078544`*^9, 3.479692416084488*^9}, {3.4796927607701216`*^9, 
   3.4796928421371217`*^9}, 3.4796928983179054`*^9, 3.4796931033126736`*^9, 
   3.479693145283024*^9, {3.4796931984494734`*^9, 3.479693210827272*^9}, 
   3.4807054266182814`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"E", "^", 
      RowBox[{"(", 
       RowBox[{"n_.", "*", 
        RowBox[{"ArcTanh", "[", "v_", "]"}]}], ")"}]}]}], ",", " ", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "m"}], "*", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "v"}], ")"}], "^", "n"}], "/", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"v", "^", "2"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"n", "/", "2"}], ")"}]}]}]}], ",", "x"}], "]"}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"OddQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"v", ",", "x"}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796932346515293`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"n", " ", 
      RowBox[{"ArcTanh", "[", "z", "]"}]}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["z", "2"]}], ")"}], "m"]}], "=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}], 
     RowBox[{"m", "-", 
      FractionBox["n", "2"]}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "z"}], ")"}], 
     RowBox[{"m", "+", 
      FractionBox["n", "2"]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{3.4796918758576803`*^9, 3.479691932769515*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{
     RowBox[{"m", "-", 
      FractionBox["n", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "+", 
      FractionBox["n", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807054353007665`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcTanh", "[", "v", "]"}]}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["v", "2"]}], ")"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{"u", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "v"}], ")"}], 
        RowBox[{"m", "-", 
         FractionBox["n", "2"]}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "v"}], ")"}], 
        RowBox[{"m", "+", 
         FractionBox["n", "2"]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796917222768416`*^9, 3.479691774261592*^9}, {
   3.4796924406097536`*^9, 3.479692445126248*^9}, {3.47969249049148*^9, 
   3.4796924960094147`*^9}, 3.47969259154679*^9, {3.4796927611807117`*^9, 
   3.479692812774901*^9}, {3.4796928477752285`*^9, 3.4796928500685263`*^9}, 
   3.479692900881592*^9, {3.4796931059264317`*^9, 3.4796931079994125`*^9}, 
   3.479693147466163*^9, 3.479693333673917*^9, 3.480705437794352*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{"E", "^", 
      RowBox[{"(", 
       RowBox[{"n_.", "*", 
        RowBox[{"ArcTanh", "[", "v_", "]"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"v_", "^", "2"}]}], ")"}], "^", "m_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "v"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", 
         RowBox[{"n", "/", "2"}]}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "v"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"n", "/", "2"}]}], ")"}]}]}], ",", "x"}], "]"}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"n", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"n", "/", "2"}]}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796932346515293`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"n", " ", 
      RowBox[{"ArcTanh", "[", "z", "]"}]}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["z", "2"]}], ")"}], "m"]}], "=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}], 
     RowBox[{"m", "-", 
      FractionBox["n", "2"]}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "z"}], ")"}], 
     RowBox[{"m", "+", 
      FractionBox["n", "2"]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{3.4796918798534255`*^9, 3.4796919333203073`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{
     RowBox[{"m", "-", 
      FractionBox["n", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "+", 
      FractionBox["n", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807054444939857`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcTanh", "[", "v", "]"}]}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["v", "2"]}]}], ")"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "-", 
         RowBox[{"a", " ", 
          SuperscriptBox["v", "2"]}]}], ")"}], "m"], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["v", "2"]}], ")"}], "m"]]}]}], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "v"}], ")"}], 
      RowBox[{"m", "-", 
       FractionBox["n", "2"]}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "v"}], ")"}], 
      RowBox[{"m", "+", 
       FractionBox["n", "2"]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796917227875757`*^9, 3.479691774311664*^9}, {
   3.479691804725397*^9, 3.4796918058670387`*^9}, {3.47969217453716*^9, 
   3.479692191040891*^9}, {3.4796924541291933`*^9, 3.4796925005659666`*^9}, {
   3.4796927614711294`*^9, 3.479692813055304*^9}, {3.4796928536737103`*^9, 
   3.4796928554062014`*^9}, 3.479692903445278*^9, {3.479693109932192*^9, 
   3.479693111714755*^9}, 3.4796931494289856`*^9, 3.4796933344950976`*^9, {
   3.4796933674124303`*^9, 3.479693381352475*^9}, 3.480705447748666*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{"E", "^", 
      RowBox[{"(", 
       RowBox[{"n_.", "*", 
        RowBox[{"ArcTanh", "[", "v_", "]"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"v_", "^", "2"}]}]}], ")"}], "^", "m_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"v", "^", "2"}]}]}], ")"}], "^", "m"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"v", "^", "2"}]}], ")"}], "^", "m"}]}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "v"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"m", "-", 
          RowBox[{"n", "/", "2"}]}], ")"}]}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "v"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"n", "/", "2"}]}], ")"}]}]}], ",", "x"}], "]"}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"n", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"n", "/", "2"}]}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796932346515293`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcTanh", "[", "z", "]"}]}]], "=", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "z"}], ")"}], "n"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["z", "2"]}], ")"}], 
     RowBox[{"n", "/", "2"}]]]}]]]
}], "Subsubsection",
 CellChangeTimes->{3.4796918834586096`*^9, 3.4796919340613728`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", " ", 
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.480705453937565*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcTanh", "[", "v", "]"}]}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["v", "2"]}]}], ")"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     SuperscriptBox["a", "m"]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "v"}], ")"}], "n"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["v", "2"]}], ")"}], 
      RowBox[{"m", "-", 
       FractionBox["n", "2"]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796917233784256`*^9, 3.4796917743316927`*^9}, 
   3.479692235945461*^9, 3.479692337441405*^9, {3.4796927617415185`*^9, 
   3.479692813525981*^9}, {3.4796928583103776`*^9, 3.4796928600829268`*^9}, 
   3.4796929055683312`*^9, 3.4796931136074767`*^9, 3.4796931513817935`*^9, 
   3.4807054564111214`*^9, {3.5158136103924513`*^9, 3.515813622888074*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{"E", "^", 
      RowBox[{"(", 
       RowBox[{"n_.", "*", 
        RowBox[{"ArcTanh", "[", "v_", "]"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", 
         RowBox[{"v_", "^", "2"}]}]}], ")"}], "^", "m_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"a", "^", "m"}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", "v"}], ")"}], "^", "n"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"v", "^", "2"}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"m", "-", 
           RowBox[{"n", "/", "2"}]}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.5158136479417176`*^9, 3.515813710841028*^9}, {
  3.5158142030062923`*^9, 3.5158142169059167`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796932346515293`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcTanh", "[", "z", "]"}]}]], "=", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "z"}], ")"}], "n"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["z", "2"]}], ")"}], 
     RowBox[{"n", "/", "2"}]]]}]]]
}], "Subsubsection",
 CellChangeTimes->{3.4796918870137215`*^9, 3.479691934512021*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{
     RowBox[{"m", "+", "n"}], "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.480705462630064*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcTanh", "[", "v", "]"}]}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "v"}], ")"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        RowBox[{"u", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", "v"}], ")"}], 
          RowBox[{"m", "+", "n"}]]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           SuperscriptBox["v", "2"]}], ")"}], 
         RowBox[{"n", "/", "2"}]]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.479691723999318*^9, 3.479691774351722*^9}, {
   3.479692329930605*^9, 3.479692332384133*^9}, 3.47969252253756*^9, {
   3.479692761981864*^9, 3.479692813786355*^9}, {3.4796928635378942`*^9, 
   3.4796928651902704`*^9}, 3.4796929074510384`*^9, 3.4796931162412643`*^9, 
   3.479693153324587*^9, 3.4796933352461777`*^9, 3.480705465183736*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{"E", "^", 
      RowBox[{"(", 
       RowBox[{"n_.", "*", 
        RowBox[{"ArcTanh", "[", "v_", "]"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "v_"}], ")"}], "^", "m_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u", "*", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "v"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n"}], ")"}]}], "/", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"v", "^", "2"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"n", "/", "2"}], ")"}]}]}]}], ",", "x"}], "]"}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "+", "n"}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796932346515293`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcTanh", "[", "z", "]"}]}]], "=", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "z"}], ")"}], 
     RowBox[{"n", "/", "2"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}], 
     RowBox[{"n", "/", "2"}]]]}]]]
}], "Subsubsection",
 CellChangeTimes->{3.4796918914400864`*^9, 3.479691934972683*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.480705470070763*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcTanh", "[", "v", "]"}]}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "v"}], ")"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        RowBox[{"u", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", "v"}], ")"}], 
          RowBox[{"m", "+", 
           FractionBox["n", "2"]}]]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", "v"}], ")"}], 
         RowBox[{"n", "/", "2"}]]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.479691724680298*^9, 3.4796917743717504`*^9}, 
   3.479692527244328*^9, 3.479692762232224*^9, 3.4796928140767727`*^9, {
   3.4796928677940145`*^9, 3.4796928693262177`*^9}, 3.4796929096341777`*^9, 
   3.4796931552072945`*^9, 3.4796933358470416`*^9, 3.4807054722739315`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{"E", "^", 
      RowBox[{"(", 
       RowBox[{"n_.", "*", 
        RowBox[{"ArcTanh", "[", "v_", "]"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "v_"}], ")"}], "^", "m_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u", "*", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "v"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"n", "/", "2"}]}], ")"}]}], "/", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "v"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"n", "/", "2"}], ")"}]}]}]}], ",", "x"}], "]"}], " ", "/;", 
   "\n", 
   RowBox[{"RationalQ", "[", 
    RowBox[{"{", 
     RowBox[{"m", ",", "n"}], "}"}], "]"}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796932346515293`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcTanh", "[", "z", "]"}]}]], "=", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "z"}], ")"}], 
     RowBox[{"n", "/", "2"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}], 
     RowBox[{"n", "/", "2"}]]]}]]]
}], "Subsubsection",
 CellChangeTimes->{3.4796918958163795`*^9, 3.4796919354133167`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.480705478432787*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcTanh", "[", "v", "]"}]}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", "v"}], ")"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{"u", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "v"}], ")"}], 
        RowBox[{"n", "/", "2"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "v"}], ")"}], 
        RowBox[{"m", "-", 
         FractionBox["n", "2"]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796917253813057`*^9, 3.479691774381765*^9}, 
   3.4796925296177406`*^9, 3.479692762482584*^9, 3.4796928143271327`*^9, {
   3.4796928717497025`*^9, 3.4796928732518625`*^9}, 3.479692911316597*^9, 
   3.479693157049944*^9, 3.47969333636779*^9, 3.480705480706056*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{"E", "^", 
      RowBox[{"(", 
       RowBox[{"n_.", "*", 
        RowBox[{"ArcTanh", "[", "v_", "]"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "v_"}], ")"}], "^", "m_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "v"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "/", "2"}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "v"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", 
         RowBox[{"n", "/", "2"}]}], ")"}]}]}], ",", "x"}], "]"}], " ", "/;", 
   "\n", 
   RowBox[{"RationalQ", "[", 
    RowBox[{"{", 
     RowBox[{"m", ",", "n"}], "}"}], "]"}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796932346515293`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{{3.4796929128387856`*^9, 3.4796929208703346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{
     RowBox[{"a", "-", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807054882268705`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcTanh", "[", "v", "]"}]}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "v"}]}], ")"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     SuperscriptBox["a", "m"]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"n", " ", 
       RowBox[{"ArcTanh", "[", "v", "]"}]}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        FractionBox[
         RowBox[{"b", " ", "v"}], "a"]}], ")"}], "m"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796917262325296`*^9, 3.4796917744017935`*^9}, {
   3.479691808781229*^9, 3.479691811935765*^9}, 3.479692244187312*^9, 
   3.4796923230306835`*^9, {3.479692537238699*^9, 3.4796925598111567`*^9}, {
   3.479692762813059*^9, 3.479692814567478*^9}, {3.479692876356326*^9, 
   3.4796928780888176`*^9}, 3.479692917004776*^9, 3.4796931183543024`*^9, 
   3.4796931588625507`*^9, {3.4796934379638786`*^9, 3.4796934582230096`*^9}, 
   3.4807054904300385`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{"E", "^", 
      RowBox[{"(", 
       RowBox[{"n_.", "*", 
        RowBox[{"ArcTanh", "[", "v_", "]"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "v_"}]}], ")"}], "^", "m_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"a", "^", "m"}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{"E", "^", 
         RowBox[{"(", 
          RowBox[{"n", "*", 
           RowBox[{"ArcTanh", "[", "v", "]"}]}], ")"}]}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            RowBox[{"b", "/", "a"}], "*", "v"}]}], ")"}], "^", "m"}]}], ",", 
       "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"a", "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796932346515293`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: If m is an integer, ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"ArcTanh", "[", "z", "]"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "-", 
       FractionBox["a", 
        SuperscriptBox["z", "2"]]}], ")"}], "m"]}], "=", 
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "a"}], ")"}], "m"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "z"}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["z", "2"]}], ")"}], 
      RowBox[{"m", "-", 
       FractionBox["1", "2"]}]]}], 
    SuperscriptBox["z", 
     RowBox[{"2", " ", "m"}]]]}]]]
}], "Subsubsection",
 CellChangeTimes->{3.479691901214141*^9, 3.4796919362645407`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807054956174974`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"u", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"ArcTanh", "[", "v", "]"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "-", 
       FractionBox["a", 
        SuperscriptBox["v", "2"]]}], ")"}], "m"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "a"}], ")"}], "m"]}]}], " ", 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"u", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           SuperscriptBox["v", "2"]}], ")"}], 
         RowBox[{"m", "-", 
          FractionBox["1", "2"]}]]}], 
       SuperscriptBox["v", 
        RowBox[{"2", " ", "m"}]]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "a"}], ")"}], "m"], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"u", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["v", "2"]}], ")"}], 
        RowBox[{"m", "-", 
         FractionBox["1", "2"]}]]}], 
      SuperscriptBox["v", 
       RowBox[{
        RowBox[{"2", " ", "m"}], "-", "1"}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.47969172714384*^9, 3.4796917744218225`*^9}, {
   3.4796918131975794`*^9, 3.4796918161317987`*^9}, {3.479692262123102*^9, 
   3.4796923178632526`*^9}, 3.479692763243678*^9, 3.4796928148278527`*^9, {
   3.479692880782691*^9, 3.4796928834665504`*^9}, 3.4796929247258787`*^9, 
   3.4796931202269955`*^9, 3.480705497960867*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{"E", "^", 
      RowBox[{"ArcTanh", "[", "v_", "]"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "/", 
         RowBox[{"v_", "^", "2"}]}]}], ")"}], "^", "m_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"b", "^", "m"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"v", "^", "2"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", 
            RowBox[{"1", "/", "2"}]}], ")"}]}], "/", 
         RowBox[{"v", "^", 
          RowBox[{"(", 
           RowBox[{"2", "*", "m"}], ")"}]}]}]}], ",", "x"}], "]"}]}], " ", 
    "+", " ", "\n", "  ", 
    RowBox[{
     RowBox[{"b", "^", "m"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"v", "^", "2"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", 
            RowBox[{"1", "/", "2"}]}], ")"}]}], "/", 
         RowBox[{"v", "^", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "*", "m"}], "-", "1"}], ")"}]}]}]}], ",", "x"}], 
      "]"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"ArcTanh", "[", 
    RowBox[{"b", " ", 
     SuperscriptBox["f", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}]]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, 3.4802882652733135`*^9, 3.480288373839424*^9, {
   3.480299236238787*^9, 3.480299238211624*^9}, {3.4803010920372944`*^9, 
   3.480301103143264*^9}, 3.492825791291954*^9, 3.4933227311790323`*^9, {
   3.4953856911539116`*^9, 3.4953856917155123`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"ArcTanh", "[", "z", "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", "z"}], "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", "z"}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{3.480300575514571*^9, 3.4803006163032227`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070519364328*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"ArcTanh", "[", 
     RowBox[{"b", " ", 
      SuperscriptBox["f", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}]]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["f", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}]]}]}], "]"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       RowBox[{"b", " ", 
        SuperscriptBox["f", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}]]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.48029928226497*^9, 3.4802993300937443`*^9}, 
   3.4802995783907776`*^9, {3.480299703450605*^9, 3.480299715728259*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"ArcTanh", "[", 
     RowBox[{"b_.", "*", 
      RowBox[{"f_", "^", 
       RowBox[{"(", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], ")"}]}]}], "]"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"1", "+", 
          RowBox[{"b", "*", 
           RowBox[{"f", "^", 
            RowBox[{"(", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], "]"}], ",", "x"}], 
       "]"}]}], "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"1", "-", 
          RowBox[{"b", "*", 
           RowBox[{"f", "^", 
            RowBox[{"(", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], "]"}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "c", ",", "d", ",", "f"}], "}"}], ",", "x"}], "]"}], 
   " "}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"ArcTanh", "[", 
    RowBox[{"b", " ", 
     SuperscriptBox["f", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}]]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, 3.4802882652733135`*^9, 3.480288373839424*^9, {
   3.480299236238787*^9, 3.480299238211624*^9}, {3.4803010920372944`*^9, 
   3.480301103143264*^9}, 3.492825791291954*^9, 3.4933227311790323`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"ArcTanh", "[", "z", "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", "z"}], "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", "z"}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{3.48030057193943*^9, 3.4803006163232512`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055445578704`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"b", " ", 
      SuperscriptBox["f", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}]]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["f", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}]]}]}], "]"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       RowBox[{"b", " ", 
        SuperscriptBox["f", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}]]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.480299282274984*^9, 3.4802993007415376`*^9}, {
   3.480299332717517*^9, 3.4802993335386972`*^9}, {3.48029943364264*^9, 
   3.480299444237875*^9}, 3.480299578400792*^9, 3.480299657564624*^9, {
   3.480299717951456*^9, 3.480299731180478*^9}, 3.4803000540747776`*^9, {
   3.480300090066531*^9, 3.480300092169555*^9}, 3.480300126899494*^9, 
   3.480705548133011*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"ArcTanh", "[", 
      RowBox[{"b_.", "*", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], ")"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{"1", "+", 
           RowBox[{"b", "*", 
            RowBox[{"f", "^", 
             RowBox[{"(", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], "]"}]}], ",", "x"}], 
       "]"}]}], "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{"1", "-", 
           RowBox[{"b", "*", 
            RowBox[{"f", "^", 
             RowBox[{"(", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], "]"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d", ",", "f"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"v", " ", 
   RowBox[{"ArcTanh", "[", "u", "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160783652334`*^9, 3.4796867206047907`*^9, 3.492825781557537*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell["Rule: If u is free of inverse functions, then", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703531363038*^9, 
   3.4807035352686543`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"ArcTanh", "[", "u", "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "x"}]}], " ", 
    RowBox[{"ArcTanh", "[", "u", "]"}]}]}], "-", 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", " ", 
      RowBox[{
       SubscriptBox["\[PartialD]", "x"], "u"}]}], 
     RowBox[{"1", "-", 
      SuperscriptBox["u", "2"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579734230976`*^9, 3.4796580026851745`*^9}, {
   3.479658101347043*^9, 3.479658102348483*^9}, {3.4796582237129965`*^9, 
   3.4796582279090304`*^9}, {3.4796611944647284`*^9, 3.4796612203719807`*^9}, 
   3.4796613933206687`*^9, {3.4796614761798143`*^9, 3.4796614777420607`*^9}, 
   3.4796618658000607`*^9, {3.4796619856624146`*^9, 3.4796619866938972`*^9}, {
   3.4796645712002354`*^9, 3.4796645805536847`*^9}, 3.4796646283424015`*^9, {
   3.4796867206148047`*^9, 3.4796867206148047`*^9}, {3.479687667676613*^9, 
   3.479687667926973*^9}, 3.480705232098576*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"ArcTanh", "[", "u_", "]"}], ",", "x_Symbol"}], "]"}], " ", ":=", 
  "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"ArcTanh", "[", "u", "]"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"Regularize", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{"u", ",", "x"}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"u", "^", "2"}]}], ")"}]}]}], ",", "x"}], "]"}], ",", 
      "x"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{"InverseFunctionFreeQ", "[", 
    RowBox[{"u", ",", "x"}], "]"}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], "\[And]"}]]],
 " u is free of inverse functions, then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.4807035587524223`*^9, 
   3.4807036202508526`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"ArcTanh", "[", "u", "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"ArcTanh", "[", "u", "]"}]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "+", "1"}]], " ", 
       RowBox[{
        SubscriptBox["\[PartialD]", "x"], "u"}]}], 
      RowBox[{"1", "-", 
       SuperscriptBox["u", "2"]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.479657973433112*^9, 3.4796580026951885`*^9}, {
   3.479658110380032*^9, 3.479658111381472*^9}, {3.47965823109361*^9, 
   3.4796582349191103`*^9}, {3.479658630027248*^9, 3.4796586331817837`*^9}, {
   3.4796611944747424`*^9, 3.479661220542226*^9}, 3.479661393330683*^9, {
   3.4796614834602833`*^9, 3.4796614855532928`*^9}, {3.4796616350883136`*^9, 
   3.4796616397950816`*^9}, 3.4796618737314653`*^9, 3.479662021574053*^9, 
   3.4796645886853776`*^9, {3.4796867206248193`*^9, 3.4796867206248193`*^9}, {
   3.479687711189181*^9, 3.479687711749987*^9}, 3.480705245037181*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"ArcTanh", "[", "u_", "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"ArcTanh", "[", "u", "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Regularize", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"m", "+", "1"}], ")"}]}], "*", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"u", ",", "x"}], "]"}], "/", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"u", "^", "2"}]}], ")"}]}]}], ",", "x"}], "]"}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"m", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"InverseFunctionFreeQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", "\n", "\t", 
    RowBox[{"Not", "[", 
     RowBox[{"FunctionOfQ", "[", 
      RowBox[{
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ",", "u", ",", "x"}], "]"}], "]"}],
     " ", "&&", " ", "\n", "\t", 
    RowBox[{"FalseQ", "[", 
     RowBox[{"PowerVariableExpn", "[", 
      RowBox[{"u", ",", 
       RowBox[{"m", "+", "1"}], ",", "x"}], "]"}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If u is free of inverse functions, let  ",
 Cell[BoxData[
  RowBox[{"w", "=", 
   RowBox[{"\[Integral]", 
    RowBox[{"v", 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]]],
 ", if w is free of inverse functions, then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703639939163*^9, 
   3.4807036911227617`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"v", " ", 
    RowBox[{"ArcTanh", "[", "u", "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "w"}]}], " ", 
    RowBox[{"ArcTanh", "[", "u", "]"}]}]}], "-", 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"w", " ", 
      RowBox[{
       SubscriptBox["\[PartialD]", "x"], "u"}]}], 
     RowBox[{"1", "-", 
      SuperscriptBox["u", "2"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579734531407`*^9, 3.479658002705203*^9}, {
   3.479658122026779*^9, 3.479658123318637*^9}, {3.4796582402567854`*^9, 
   3.479658243621624*^9}, {3.479658719025221*^9, 3.479658746965397*^9}, {
   3.4796611944747424`*^9, 3.4796612207224846`*^9}, 3.4796613933406973`*^9, {
   3.4796614896692114`*^9, 3.479661491792264*^9}, {3.479661879599904*^9, 
   3.479661922882141*^9}, 3.4796620342622976`*^9, {3.4796645916195965`*^9, 
   3.4796646241063104`*^9}, {3.4796867206348333`*^9, 
   3.4796867206348333`*^9}, {3.4796877839337826`*^9, 3.479687784174128*^9}, 
   3.480705260379242*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"v_", "*", 
     RowBox[{"ArcTanh", "[", "u_", "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"w", "=", 
       RowBox[{"Block", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ShowSteps", "=", "False"}], ",", 
           RowBox[{"StepCounter", "=", "Null"}]}], "}"}], ",", " ", 
         RowBox[{"Int", "[", 
          RowBox[{"v", ",", "x"}], "]"}]}], "]"}]}], "}"}], ",", "  ", "\n", 
     "  ", 
     RowBox[{
      RowBox[{
       RowBox[{"w", "*", 
        RowBox[{"ArcTanh", "[", "u", "]"}]}], " ", "-", "\n", "  ", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{"w", "*", 
            RowBox[{
             RowBox[{"D", "[", 
              RowBox[{"u", ",", "x"}], "]"}], "/", 
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"u", "^", "2"}]}], ")"}]}]}], ",", "x"}], "]"}], ",", 
         "x"}], "]"}]}], " ", "/;", "\n", " ", 
      RowBox[{"InverseFunctionFreeQ", "[", 
       RowBox[{"w", ",", "x"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"InverseFunctionFreeQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", "\n", "\t", 
    RowBox[{"Not", "[", 
     RowBox[{"MatchQ", "[", 
      RowBox[{"v", ",", " ", 
       RowBox[{
        RowBox[{"x", "^", "m_."}], " ", "/;", " ", 
        RowBox[{"FreeQ", "[", 
         RowBox[{"m", ",", "x"}], "]"}]}]}], "]"}], "]"}], " ", "&&", "\n", 
    "\t", 
    RowBox[{"FalseQ", "[", 
     RowBox[{"FunctionOfLinear", "[", 
      RowBox[{
       RowBox[{"v", "*", 
        RowBox[{"ArcTanh", "[", "u", "]"}]}], ",", "x"}], "]"}], 
     "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Rules for Inverse Hyperbolic Tangent Functions", None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.399999976158142,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 858, 19, 118, "Title"],
Cell[1428, 43, 145, 2, 3274, "Subsubsection"],
Cell[1576, 47, 57, 0, 2274, "Subsubsection"],
Cell[1636, 49, 613, 9, 2274, "Subsubsection"],
Cell[2252, 60, 844, 24, 6347, "Subsubtitle"],
Cell[3099, 86, 771, 11, 3274, "Subsubsection"],
Cell[3873, 99, 786, 24, 10016, "Code"],
Cell[4662, 125, 89, 2, 3274, "Subsubsection"],
Cell[4754, 129, 57, 0, 2274, "Subsubsection"],
Cell[4814, 131, 827, 16, 2423, "Subsubsection"],
Cell[5644, 149, 1588, 39, 6161, "Subsubtitle"],
Cell[7235, 190, 771, 11, 3274, "Subsubsection"],
Cell[8009, 203, 1240, 38, 12461, "Code"],
Cell[9252, 243, 44, 1, 270, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[9333, 249, 891, 20, 80, "Title"],
Cell[10227, 271, 187, 2, 4611, "Subsubsection"],
Cell[10417, 275, 1104, 20, 3403, "Subsubsection"],
Cell[11524, 297, 1592, 43, 8619, "Subsubtitle"],
Cell[13119, 342, 819, 11, 4611, "Subsubsection"],
Cell[13941, 355, 2265, 57, 17445, "Code"],
Cell[16209, 414, 89, 2, 4611, "Subsubsection"],
Cell[16301, 418, 187, 2, 3183, "Subsubsection"],
Cell[16491, 422, 1203, 22, 3403, "Subsubsection"],
Cell[17697, 446, 2544, 72, 17128, "Subsubtitle"],
Cell[20244, 520, 819, 11, 4611, "Subsubsection"],
Cell[21066, 533, 3483, 95, 20823, "Code"],
Cell[24552, 630, 89, 2, 4611, "Subsubsection"],
Cell[24644, 634, 125, 1, 3183, "Subsubsection"],
Cell[24772, 637, 902, 17, 3403, "Subsubsection"],
Cell[25677, 656, 1539, 44, 10998, "Subsubtitle"],
Cell[27219, 702, 771, 11, 4611, "Subsubsection"],
Cell[27993, 715, 1789, 53, 17445, "Code"],
Cell[29785, 770, 89, 2, 4611, "Subsubsection"],
Cell[29877, 774, 125, 1, 3183, "Subsubsection"],
Cell[30005, 777, 1006, 19, 3403, "Subsubsection"],
Cell[31014, 798, 1427, 39, 9577, "Subsubtitle"],
Cell[32444, 839, 771, 11, 4611, "Subsubsection"],
Cell[33218, 852, 2074, 53, 17445, "Code"],
Cell[35295, 907, 89, 2, 4611, "Subsubsection"],
Cell[35387, 911, 245, 3, 3183, "Subsubsection"],
Cell[35635, 916, 1304, 23, 3403, "Subsubsection"],
Cell[36942, 941, 1738, 47, 8619, "Subsubtitle"],
Cell[38683, 990, 819, 11, 4611, "Subsubsection"],
Cell[39505, 1003, 2465, 60, 17445, "Code"],
Cell[41973, 1065, 89, 2, 4611, "Subsubsection"],
Cell[42065, 1069, 245, 3, 3183, "Subsubsection"],
Cell[42313, 1074, 1371, 25, 3403, "Subsubsection"],
Cell[43687, 1101, 2465, 69, 16790, "Subsubtitle"],
Cell[46155, 1172, 819, 11, 4611, "Subsubsection"],
Cell[46977, 1185, 3470, 92, 20823, "Code"],
Cell[50450, 1279, 44, 1, 365, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[50531, 1285, 1060, 24, 88, "Title"],
Cell[51594, 1311, 154, 2, 1630991430, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[51751, 1315, 1349, 27, 2106369454, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[53103, 1344, 2033, 56, 2147483647, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[55139, 1402, 771, 11, 1630991430, "Subsubsection"],
Cell[55913, 1415, 3493, 86, 2147483647, "Code"],
Cell[59409, 1503, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[59490, 1509, 1161, 26, 88, "Title"],
Cell[60654, 1537, 154, 2, 1630991430, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[60811, 1541, 1403, 28, 2106369454, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[62217, 1571, 2220, 60, 2147483647, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[64440, 1633, 771, 11, 1630991430, "Subsubsection"],
Cell[65214, 1646, 3831, 92, 2147483647, "Code"],
Cell[69048, 1740, 89, 2, 1630991430, "Subsubsection"],
Cell[69140, 1744, 154, 2, 1117802965, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[69297, 1748, 1401, 28, 2106369454, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[70701, 1778, 2276, 61, 2147483647, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[72980, 1841, 771, 11, 1630991430, "Subsubsection"],
Cell[73754, 1854, 3855, 92, 2147483647, "Code"],
Cell[77612, 1948, 89, 2, 1630991430, "Subsubsection"],
Cell[77704, 1952, 61, 0, 1117802965, "Subsubsection"],
Cell[77768, 1954, 645, 19, 1818382472, "Subsubsection"],
Cell[78416, 1975, 1503, 30, 1630991430, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[79922, 2007, 1711, 47, 2147483647, "Subsubtitle"],
Cell[81636, 2056, 771, 11, 1630991430, "Subsubsection"],
Cell[82410, 2069, 3671, 85, 2147483647, "Code"],
Cell[86084, 2156, 89, 2, 1630991430, "Subsubsection"],
Cell[86176, 2160, 61, 0, 1117802965, "Subsubsection"],
Cell[86240, 2162, 723, 21, 1818382472, "Subsubsection"],
Cell[86966, 2185, 1622, 32, 1630991430, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[88591, 2219, 1761, 47, 2147483647, "Subsubtitle"],
Cell[90355, 2268, 771, 11, 1630991430, "Subsubsection"],
Cell[91129, 2281, 3682, 85, 2147483647, "Code"],
Cell[94814, 2368, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[94895, 2374, 1112, 25, 91, "Title"],
Cell[96010, 2401, 188, 3, 130, "Subsubsection"],
Cell[96201, 2406, 1281, 24, 96, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[97485, 2432, 1263, 29, 253, "Subsubtitle"],
Cell[98751, 2463, 771, 11, 130, "Subsubsection"],
Cell[99525, 2476, 1746, 43, 394, "Code"],
Cell[101274, 2521, 89, 2, 130, "Subsubsection"],
Cell[101366, 2525, 107, 1, 90, "Subsubsection"],
Cell[101476, 2528, 1340, 27, 96, "Subsubsection"],
Cell[102819, 2557, 1351, 32, 250, "Subsubtitle"],
Cell[104173, 2591, 771, 11, 130, "Subsubsection"],
Cell[104947, 2604, 1918, 48, 394, "Code"],
Cell[106868, 2654, 44, 1, 11, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[106949, 2660, 1141, 27, 91, "Title"],
Cell[108093, 2689, 56, 0, 10484114, "Subsubsection"],
Cell[108152, 2691, 839, 27, 13107377, "Subsubsection"],
Cell[108994, 2720, 1391, 26, 7721726, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[110388, 2748, 2259, 53, 20302060, "Subsubtitle"],
Cell[112650, 2803, 771, 11, 10484114, "Subsubsection"],
Cell[113424, 2816, 2791, 69, 39977563, "Code"],
Cell[116218, 2887, 89, 2, 10484114, "Subsubsection"],
Cell[116310, 2891, 56, 0, 7185329, "Subsubsection"],
Cell[116369, 2893, 1011, 29, 13107377, "Subsubsection"],
Cell[117383, 2924, 1437, 27, 7721726, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[118823, 2953, 2317, 55, 21891560, "Subsubtitle"],
Cell[121143, 3010, 771, 11, 10484114, "Subsubsection"],
Cell[121917, 3023, 2905, 71, 39977563, "Code"],
Cell[124825, 3096, 89, 2, 10484114, "Subsubsection"],
Cell[124917, 3100, 56, 0, 7185329, "Subsubsection"],
Cell[124976, 3102, 1011, 29, 13107377, "Subsubsection"],
Cell[125990, 3133, 1443, 27, 7721726, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[127436, 3162, 2312, 54, 20302060, "Subsubtitle"],
Cell[129751, 3218, 771, 11, 10484114, "Subsubsection"],
Cell[130525, 3231, 2980, 72, 39977563, "Code"],
Cell[133508, 3305, 89, 2, 10484114, "Subsubsection"],
Cell[133600, 3309, 56, 0, 7185329, "Subsubsection"],
Cell[133659, 3311, 930, 25, 14677755, "Subsubsection"],
Cell[134592, 3338, 1353, 26, 7721726, "Subsubsection"],
Cell[135948, 3366, 1787, 49, 19716506, "Subsubtitle"],
Cell[137738, 3417, 771, 11, 10484114, "Subsubsection"],
Cell[138512, 3430, 2851, 75, 39977563, "Code"],
Cell[141366, 3507, 89, 2, 10484114, "Subsubsection"],
Cell[141458, 3511, 56, 0, 7185329, "Subsubsection"],
Cell[141517, 3513, 1006, 26, 14677755, "Subsubsection"],
Cell[142526, 3541, 1423, 28, 7721726, "Subsubsection"],
Cell[143952, 3571, 1865, 50, 19716506, "Subsubtitle"],
Cell[145820, 3623, 771, 11, 10484114, "Subsubsection"],
Cell[146594, 3636, 2785, 74, 39977563, "Code"],
Cell[149382, 3712, 89, 2, 14677755, "Subsubsection"],
Cell[149474, 3716, 64, 0, 10059473, "Subsubsection"],
Cell[149541, 3718, 1527, 44, 17360835, "Subsubsection"],
Cell[151071, 3764, 2112, 43, 10810424, "Subsubsection"],
Cell[153186, 3809, 2227, 49, 27219702, "Subsubtitle"],
Cell[155416, 3860, 771, 11, 14677755, "Subsubsection"],
Cell[156190, 3873, 2601, 68, 44903204, "Code"],
Cell[158794, 3943, 89, 2, 14677755, "Subsubsection"],
Cell[158886, 3947, 64, 0, 10059473, "Subsubsection"],
Cell[158953, 3949, 1469, 39, 17360835, "Subsubsection"],
Cell[160425, 3990, 2164, 44, 10810424, "Subsubsection"],
Cell[162592, 4036, 2338, 50, 27219702, "Subsubtitle"],
Cell[164933, 4088, 771, 11, 14677755, "Subsubsection"],
Cell[165707, 4101, 2586, 67, 44903204, "Code"],
Cell[168296, 4170, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[168377, 4176, 1271, 28, 91, "Title"],
Cell[169651, 4206, 61, 0, 132144, "Subsubsection"],
Cell[169715, 4208, 652, 19, 140748, "Subsubsection"],
Cell[170370, 4229, 2000, 45, 156252, "Subsubsection"],
Cell[172373, 4276, 1621, 50, 244991, "Subsubtitle"],
Cell[173997, 4328, 771, 11, 132144, "Subsubsection"],
Cell[174771, 4341, 3987, 105, 503703, "Code"],
Cell[178761, 4448, 44, 1, 9577, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[178842, 4454, 1169, 27, 91, "Title"],
Cell[180014, 4483, 57, 0, 1630991430, "Subsubsection"],
Cell[180074, 4485, 1827, 38, 1929131897, "Subsubsection"],
Cell[181904, 4525, 1584, 48, 2147483647, "Subsubtitle"],
Cell[183491, 4575, 771, 11, 1630991430, "Subsubsection"],
Cell[184265, 4588, 3293, 87, 2147483647, "Code"],
Cell[187561, 4677, 89, 2, 1630991430, "Subsubsection"],
Cell[187653, 4681, 57, 0, 1117802965, "Subsubsection"],
Cell[187713, 4683, 1727, 37, 1929131897, "Subsubsection"],
Cell[189443, 4722, 1590, 48, 2147483647, "Subsubtitle"],
Cell[191036, 4772, 771, 11, 1630991430, "Subsubsection"],
Cell[191810, 4785, 3265, 87, 2147483647, "Code"],
Cell[195078, 4874, 44, 1, 117737970, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[195159, 4880, 1200, 28, 91, "Title"],
Cell[196362, 4910, 57, 0, 1630991430, "Subsubsection"],
Cell[196422, 4912, 1622, 34, 1929131897, "Subsubsection"],
Cell[198047, 4948, 1995, 55, 2147483647, "Subsubtitle"],
Cell[200045, 5005, 771, 11, 1630991430, "Subsubsection"],
Cell[200819, 5018, 3041, 83, 2147483647, "Code"],
Cell[203863, 5103, 89, 2, 1630991430, "Subsubsection"],
Cell[203955, 5107, 57, 0, 1117802965, "Subsubsection"],
Cell[204015, 5109, 1570, 33, 1929131897, "Subsubsection"],
Cell[205588, 5144, 1974, 55, 2147483647, "Subsubtitle"],
Cell[207565, 5201, 771, 11, 1630991430, "Subsubsection"],
Cell[208339, 5214, 3136, 84, 2147483647, "Code"],
Cell[211478, 5300, 44, 1, 117737970, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[211559, 5306, 1213, 29, 91, "Title"],
Cell[212775, 5337, 1314, 24, 1681750933, "Subsubsection"],
Cell[214092, 5363, 1363, 38, 2147483647, "Subsubtitle"],
Cell[215458, 5403, 771, 11, 1630991430, "Subsubsection"],
Cell[216232, 5416, 1563, 48, 2147483647, "Code"],
Cell[217798, 5466, 89, 2, 1630991430, "Subsubsection"],
Cell[217890, 5470, 57, 0, 1117802965, "Subsubsection"],
Cell[217950, 5472, 1127, 25, 1201250716, "Subsubsection"],
Cell[219080, 5499, 2811, 71, 2147483647, "Subsubtitle"],
Cell[221894, 5572, 771, 11, 1630991430, "Subsubsection"],
Cell[222668, 5585, 2464, 74, 2147483647, "Code"],
Cell[225135, 5661, 44, 1, 117737970, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[225216, 5667, 1128, 26, 80, "Title"],
Cell[226347, 5695, 89, 2, 258927, "Subsubsection"],
Cell[226439, 5699, 1135, 23, 190689, "Subsubsection"],
Cell[227577, 5724, 2073, 66, 739009, "Subsubtitle"],
Cell[229653, 5792, 771, 11, 258927, "Subsubsection"],
Cell[230427, 5805, 3155, 85, 1178598, "Code"],
Cell[233585, 5892, 89, 2, 258927, "Subsubsection"],
Cell[233677, 5896, 891, 24, 453154, "Subsubsection"],
Cell[234571, 5922, 1134, 24, 190689, "Subsubsection"],
Cell[235708, 5948, 1345, 41, 679744, "Subsubtitle"],
Cell[237056, 5991, 771, 11, 258927, "Subsubsection"],
Cell[237830, 6004, 2314, 60, 792072, "Code"],
Cell[240147, 6066, 89, 2, 258927, "Subsubsection"],
Cell[240239, 6070, 1071, 21, 190689, "Subsubsection"],
Cell[241313, 6093, 1292, 39, 605079, "Subsubtitle"],
Cell[242608, 6134, 771, 11, 258927, "Subsubsection"],
Cell[243382, 6147, 1949, 54, 987233, "Code"],
Cell[245334, 6203, 89, 2, 258927, "Subsubsection"],
Cell[245426, 6207, 1476, 27, 190689, "Subsubsection"],
Cell[246905, 6236, 2462, 68, 605079, "Subsubtitle"],
Cell[249370, 6306, 771, 11, 258927, "Subsubsection"],
Cell[250144, 6319, 2839, 88, 1178598, "Code"],
Cell[252986, 6409, 89, 2, 258927, "Subsubsection"],
Cell[253078, 6413, 1574, 30, 190689, "Subsubsection"],
Cell[254655, 6445, 3017, 82, 1164697, "Subsubtitle"],
Cell[257675, 6529, 771, 11, 258927, "Subsubsection"],
Cell[258449, 6542, 3229, 99, 1178598, "Code"],
Cell[261681, 6643, 89, 2, 258927, "Subsubsection"],
Cell[261773, 6647, 1176, 23, 190689, "Subsubsection"],
Cell[262952, 6672, 2232, 64, 902796, "Subsubtitle"],
Cell[265187, 6738, 771, 11, 258927, "Subsubsection"],
Cell[265961, 6751, 2620, 77, 1178598, "Code"],
Cell[268584, 6830, 89, 2, 258927, "Subsubsection"],
Cell[268676, 6834, 1455, 29, 288679, "Subsubsection"],
Cell[270134, 6865, 2421, 70, 917501, "Subsubtitle"],
Cell[272558, 6937, 771, 11, 258927, "Subsubsection"],
Cell[273332, 6950, 3132, 92, 1178598, "Code"],
Cell[276467, 7044, 89, 2, 258927, "Subsubsection"],
Cell[276559, 7048, 1557, 31, 288679, "Subsubsection"],
Cell[278119, 7081, 3217, 95, 1382100, "Subsubtitle"],
Cell[281339, 7178, 771, 11, 258927, "Subsubsection"],
Cell[282113, 7191, 4635, 134, 1375700, "Code"],
Cell[286751, 7327, 89, 2, 258927, "Subsubsection"],
Cell[286843, 7331, 57, 0, 177456, "Subsubsection"],
Cell[286903, 7333, 1909, 36, 190689, "Subsubsection"],
Cell[288815, 7371, 2698, 67, 911278, "Subsubtitle"],
Cell[291516, 7440, 771, 11, 258927, "Subsubsection"],
Cell[292290, 7453, 4013, 98, 987233, "Code"],
Cell[296306, 7553, 89, 2, 258927, "Subsubsection"],
Cell[296398, 7557, 64, 0, 177456, "Subsubsection"],
Cell[296465, 7559, 1421, 39, 275841, "Subsubsection"],
Cell[297889, 7600, 1895, 41, 190689, "Subsubsection"],
Cell[299787, 7643, 2140, 47, 460636, "Subsubtitle"],
Cell[301930, 7692, 771, 11, 258927, "Subsubsection"],
Cell[302704, 7705, 2523, 67, 792072, "Code"],
Cell[305230, 7774, 89, 2, 258927, "Subsubsection"],
Cell[305322, 7778, 1453, 38, 485539, "Subsubsection"],
Cell[306778, 7818, 1860, 42, 288679, "Subsubsection"],
Cell[308641, 7862, 2403, 58, 679744, "Subsubtitle"],
Cell[311047, 7922, 771, 11, 258927, "Subsubsection"],
Cell[311821, 7935, 2705, 76, 792072, "Code"],
Cell[314529, 8013, 44, 1, 18716, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[314610, 8019, 1204, 27, 80, "Title"],
Cell[315817, 8048, 229, 3, 393, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[316049, 8053, 1804, 34, 394, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[317856, 8089, 2184, 59, 757, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[320043, 8150, 771, 11, 393, "Subsubsection"],
Cell[320817, 8163, 2959, 81, 1443, "Code"],
Cell[323779, 8246, 89, 2, 393, "Subsubsection"],
Cell[323871, 8250, 1708, 30, 282, "Subsubsection"],
Cell[325582, 8282, 2793, 70, 769, "Subsubtitle"],
Cell[328378, 8354, 771, 11, 393, "Subsubsection"],
Cell[329152, 8367, 3134, 81, 1443, "Code"],
Cell[332289, 8450, 89, 2, 393, "Subsubsection"],
Cell[332381, 8454, 1677, 32, 282, "Subsubsection"],
Cell[334061, 8488, 3424, 92, 1559, "Subsubtitle"],
Cell[337488, 8582, 771, 11, 393, "Subsubsection"],
Cell[338262, 8595, 3922, 109, 1721, "Code"],
Cell[342187, 8706, 89, 2, 393, "Subsubsection"],
Cell[342279, 8710, 125, 1, 270, "Subsubsection"],
Cell[342407, 8713, 2390, 46, 282, "Subsubsection"],
Cell[344800, 8761, 2934, 73, 1296, "Subsubtitle"],
Cell[347737, 8836, 771, 11, 393, "Subsubsection"],
Cell[348511, 8849, 4147, 102, 1443, "Code"],
Cell[352661, 8953, 89, 2, 393, "Subsubsection"],
Cell[352753, 8957, 125, 1, 270, "Subsubsection"],
Cell[352881, 8960, 2279, 43, 282, "Subsubsection"],
Cell[355163, 9005, 2859, 73, 1296, "Subsubtitle"],
Cell[358025, 9080, 771, 11, 393, "Subsubsection"],
Cell[358799, 9093, 4146, 102, 1443, "Code"],
Cell[362948, 9197, 89, 2, 393, "Subsubsection"],
Cell[363040, 9201, 56, 0, 270, "Subsubsection"],
Cell[363099, 9203, 930, 25, 530, "Subsubsection"],
Cell[364032, 9230, 2139, 41, 282, "Subsubsection"],
Cell[366174, 9273, 2325, 61, 655, "Subsubtitle"],
Cell[368502, 9336, 771, 11, 393, "Subsubsection"],
Cell[369276, 9349, 3815, 94, 1443, "Code"],
Cell[373094, 9445, 89, 2, 393, "Subsubsection"],
Cell[373186, 9449, 56, 0, 270, "Subsubsection"],
Cell[373245, 9451, 1006, 26, 530, "Subsubsection"],
Cell[374254, 9479, 2345, 44, 282, "Subsubsection"],
Cell[376602, 9525, 2147, 56, 655, "Subsubtitle"],
Cell[378752, 9583, 771, 11, 393, "Subsubsection"],
Cell[379526, 9596, 3444, 87, 1443, "Code"],
Cell[382973, 9685, 89, 2, 393, "Subsubsection"],
Cell[383065, 9689, 125, 1, 270, "Subsubsection"],
Cell[383193, 9692, 2390, 45, 282, "Subsubsection"],
Cell[385586, 9739, 3340, 92, 1416, "Subsubtitle"],
Cell[388929, 9833, 771, 11, 393, "Subsubsection"],
Cell[389703, 9846, 4988, 127, 1721, "Code"],
Cell[394694, 9975, 89, 2, 393, "Subsubsection"],
Cell[394786, 9979, 125, 1, 270, "Subsubsection"],
Cell[394914, 9982, 2240, 43, 282, "Subsubsection"],
Cell[397157, 10027, 3203, 90, 1397, "Subsubtitle"],
Cell[400363, 10119, 771, 11, 393, "Subsubsection"],
Cell[401137, 10132, 5472, 137, 1721, "Code"],
Cell[406612, 10271, 89, 2, 393, "Subsubsection"],
Cell[406704, 10275, 64, 0, 270, "Subsubsection"],
Cell[406771, 10277, 2272, 64, 418, "Subsubsection"],
Cell[409046, 10343, 2369, 50, 282, "Subsubsection"],
Cell[411418, 10395, 2742, 63, 664, "Subsubtitle"],
Cell[414163, 10460, 771, 11, 393, "Subsubsection"],
Cell[414937, 10473, 3919, 98, 1154, "Code"],
Cell[418859, 10573, 89, 2, 393, "Subsubsection"],
Cell[418951, 10577, 64, 0, 270, "Subsubsection"],
Cell[419018, 10579, 1805, 48, 418, "Subsubsection"],
Cell[420826, 10629, 2338, 50, 282, "Subsubsection"],
Cell[423167, 10681, 2465, 54, 662, "Subsubtitle"],
Cell[425635, 10737, 771, 11, 393, "Subsubsection"],
Cell[426409, 10750, 2984, 79, 1154, "Code"],
Cell[429396, 10831, 89, 2, 393, "Subsubsection"],
Cell[429488, 10835, 1481, 39, 713, "Subsubsection"],
Cell[430972, 10876, 1959, 43, 418, "Subsubsection"],
Cell[432934, 10921, 2595, 62, 982, "Subsubtitle"],
Cell[435532, 10985, 771, 11, 393, "Subsubsection"],
Cell[436306, 10998, 2942, 80, 1154, "Code"],
Cell[439251, 11080, 44, 1, 37, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[439332, 11086, 1071, 22, 80, "Title"],
Cell[440406, 11110, 145, 2, 3274, "Subsubsection"],
Cell[440554, 11114, 57, 0, 2274, "Subsubsection"],
Cell[440614, 11116, 654, 9, 2274, "Subsubsection"],
Cell[441271, 11127, 1432, 37, 6347, "Subsubtitle"],
Cell[442706, 11166, 771, 11, 3274, "Subsubsection"],
Cell[443480, 11179, 1131, 34, 10016, "Code"],
Cell[444614, 11215, 89, 2, 3274, "Subsubsection"],
Cell[444706, 11219, 145, 2, 2274, "Subsubsection"],
Cell[444854, 11223, 57, 0, 2274, "Subsubsection"],
Cell[444914, 11225, 738, 14, 2423, "Subsubsection"],
Cell[445655, 11241, 1468, 38, 6098, "Subsubtitle"],
Cell[447126, 11281, 771, 11, 3274, "Subsubsection"],
Cell[447900, 11294, 1439, 43, 12461, "Code"],
Cell[449342, 11339, 44, 1, 270, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[449423, 11345, 850, 20, 80, "Title"],
Cell[450276, 11367, 56, 0, 1222, "Subsubsection"],
Cell[450335, 11369, 537, 17, 1282, "Subsubsection"],
Cell[450875, 11388, 613, 9, 848, "Subsubsection"],
Cell[451491, 11399, 1222, 37, 2274, "Subsubtitle"],
Cell[452716, 11438, 771, 11, 1222, "Subsubsection"],
Cell[453490, 11451, 1233, 39, 4555, "Code"],
Cell[454726, 11492, 89, 2, 1222, "Subsubsection"],
Cell[454818, 11496, 97, 1, 848, "Subsubsection"],
Cell[454918, 11499, 57, 0, 848, "Subsubsection"],
Cell[454978, 11501, 1133, 23, 902, "Subsubsection"],
Cell[456114, 11526, 1792, 49, 2354, "Subsubtitle"],
Cell[457909, 11577, 771, 11, 1222, "Subsubsection"],
Cell[458683, 11590, 2058, 62, 4555, "Code"],
Cell[460744, 11654, 44, 1, 125, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[460825, 11660, 833, 19, 80, "Title"],
Cell[461661, 11681, 64, 0, 8965, "Subsubsection"],
Cell[461728, 11683, 1128, 20, 6627, "Subsubsection"],
Cell[462859, 11705, 1096, 28, 15367, "Subsubtitle"],
Cell[463958, 11735, 771, 11, 8965, "Subsubsection"],
Cell[464732, 11748, 1125, 32, 27406, "Code"],
Cell[465860, 11782, 44, 1, 692, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[465941, 11788, 868, 20, 80, "Title"],
Cell[466812, 11810, 64, 0, 1222, "Subsubsection"],
Cell[466879, 11812, 1109, 22, 902, "Subsubsection"],
Cell[467991, 11836, 1233, 33, 2113, "Subsubtitle"],
Cell[469227, 11871, 771, 11, 1222, "Subsubsection"],
Cell[470001, 11884, 1449, 43, 3687, "Code"],
Cell[471453, 11929, 44, 1, 125, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[471534, 11935, 860, 22, 86, "Title"],
Cell[472397, 11959, 61, 0, 8965, "Subsubsection"],
Cell[472461, 11961, 433, 15, 9577, "Subsubsection"],
Cell[472897, 11978, 1113, 25, 9577, "Subsubsection"],
Cell[474013, 12005, 1458, 43, 15705, "Subsubtitle"],
Cell[475474, 12050, 771, 11, 8965, "Subsubsection"],
Cell[476248, 12063, 1710, 57, 34151, "Code"],
Cell[477961, 12122, 89, 2, 8965, "Subsubsection"],
Cell[478053, 12126, 61, 0, 6161, "Subsubsection"],
Cell[478117, 12128, 433, 15, 9577, "Subsubsection"],
Cell[478553, 12145, 1157, 25, 6627, "Subsubsection"],
Cell[479713, 12172, 1560, 45, 15705, "Subsubtitle"],
Cell[481276, 12219, 771, 11, 8965, "Subsubsection"],
Cell[482050, 12232, 1762, 57, 34151, "Code"],
Cell[483815, 12291, 44, 1, 692, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[483896, 12297, 896, 21, 83, "Title"],
Cell[484795, 12320, 61, 0, 1630991430, "Subsubsection"],
Cell[484859, 12322, 298, 10, 1818382472, "Subsubsection"],
Cell[485160, 12334, 613, 9, 1117802965, "Subsubsection"],
Cell[485776, 12345, 1171, 30, 2147483647, "Subsubtitle"],
Cell[486950, 12377, 771, 11, 1630991430, "Subsubsection"],
Cell[487724, 12390, 902, 30, 2147483647, "Code"],
Cell[488629, 12422, 44, 1, 117737970, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[488710, 12428, 1049, 27, 93, "Title"],
Cell[489762, 12457, 64, 0, 1630991430, "Subsubsection"],
Cell[489829, 12459, 519, 17, 1737563487, "Subsubsection"],
Cell[490351, 12478, 864, 28, 2039088503, "Subsubsection"],
Cell[491218, 12508, 434, 13, 1201250716, "Subsubsection"],
Cell[491655, 12523, 611, 9, 1117802965, "Subsubsection"],
Cell[492269, 12534, 1300, 39, 2147483647, "Subsubtitle"],
Cell[493572, 12575, 771, 11, 1630991430, "Subsubsection"],
Cell[494346, 12588, 7062, 179, 2147483647, "Code"],
Cell[501411, 12769, 44, 1, 117737970, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[501492, 12775, 825, 18, 80, "Title"],
Cell[502320, 12795, 61, 0, 67, "Subsubsection"],
Cell[502384, 12797, 488, 17, 85, "Subsubsection"],
Cell[502875, 12816, 741, 15, 67, "Subsubsection"],
Cell[503619, 12833, 1020, 28, 130, "Subsubtitle"],
Cell[504642, 12863, 771, 11, 67, "Subsubsection"],
Cell[505416, 12876, 785, 27, 202, "Code"],
Cell[506204, 12905, 89, 2, 67, "Subsubsection"],
Cell[506296, 12909, 61, 0, 47, "Subsubsection"],
Cell[506360, 12911, 492, 17, 85, "Subsubsection"],
Cell[506855, 12930, 717, 14, 50, "Subsubsection"],
Cell[507575, 12946, 951, 27, 130, "Subsubtitle"],
Cell[508529, 12975, 771, 11, 67, "Subsubsection"],
Cell[509303, 12988, 721, 25, 202, "Code"],
Cell[510027, 13015, 89, 2, 67, "Subsubsection"],
Cell[510119, 13019, 61, 0, 47, "Subsubsection"],
Cell[510183, 13021, 433, 15, 113, "Subsubsection"],
Cell[510619, 13038, 923, 19, 75, "Subsubsection"],
Cell[511545, 13059, 1130, 31, 135, "Subsubtitle"],
Cell[512678, 13092, 771, 11, 67, "Subsubsection"],
Cell[513452, 13105, 977, 32, 202, "Code"],
Cell[514432, 13139, 89, 2, 67, "Subsubsection"],
Cell[514524, 13143, 61, 0, 47, "Subsubsection"],
Cell[514588, 13145, 677, 24, 71, "Subsubsection"],
Cell[515268, 13171, 1032, 24, 75, "Subsubsection"],
Cell[516303, 13197, 1311, 34, 103, "Subsubtitle"],
Cell[517617, 13233, 771, 11, 67, "Subsubsection"],
Cell[518391, 13246, 1235, 41, 202, "Code"],
Cell[519629, 13289, 89, 2, 67, "Subsubsection"],
Cell[519721, 13293, 61, 0, 47, "Subsubsection"],
Cell[519785, 13295, 679, 24, 71, "Subsubsection"],
Cell[520467, 13321, 1032, 24, 75, "Subsubsection"],
Cell[521502, 13347, 1689, 46, 142, "Subsubtitle"],
Cell[523194, 13395, 771, 11, 67, "Subsubsection"],
Cell[523968, 13408, 1800, 59, 202, "Code"],
Cell[525771, 13469, 89, 2, 67, "Subsubsection"],
Cell[525863, 13473, 61, 0, 47, "Subsubsection"],
Cell[525927, 13475, 495, 17, 89, "Subsubsection"],
Cell[526425, 13494, 860, 17, 50, "Subsubsection"],
Cell[527288, 13513, 1254, 34, 103, "Subsubtitle"],
Cell[528545, 13549, 771, 11, 67, "Subsubsection"],
Cell[529319, 13562, 1483, 45, 202, "Code"],
Cell[530805, 13609, 89, 2, 67, "Subsubsection"],
Cell[530897, 13613, 61, 0, 47, "Subsubsection"],
Cell[530961, 13615, 493, 17, 89, "Subsubsection"],
Cell[531457, 13634, 868, 19, 50, "Subsubsection"],
Cell[532328, 13655, 1228, 33, 135, "Subsubtitle"],
Cell[533559, 13690, 771, 11, 67, "Subsubsection"],
Cell[534333, 13703, 1066, 36, 202, "Code"],
Cell[535402, 13741, 89, 2, 67, "Subsubsection"],
Cell[535494, 13745, 61, 0, 47, "Subsubsection"],
Cell[535558, 13747, 490, 17, 85, "Subsubsection"],
Cell[536051, 13766, 741, 15, 50, "Subsubsection"],
Cell[536795, 13783, 1158, 32, 149, "Subsubtitle"],
Cell[537956, 13817, 771, 11, 67, "Subsubsection"],
Cell[538730, 13830, 965, 33, 202, "Code"],
Cell[539698, 13865, 89, 2, 67, "Subsubsection"],
Cell[539790, 13869, 61, 0, 47, "Subsubsection"],
Cell[539854, 13871, 492, 17, 85, "Subsubsection"],
Cell[540349, 13890, 741, 15, 50, "Subsubsection"],
Cell[541093, 13907, 1102, 30, 103, "Subsubtitle"],
Cell[542198, 13939, 771, 11, 67, "Subsubsection"],
Cell[542972, 13952, 937, 32, 202, "Code"],
Cell[543912, 13986, 89, 2, 67, "Subsubsection"],
Cell[544004, 13990, 131, 1, 47, "Subsubsection"],
Cell[544138, 13993, 1039, 24, 67, "Subsubsection"],
Cell[545180, 14019, 1324, 34, 114, "Subsubtitle"],
Cell[546507, 14055, 771, 11, 67, "Subsubsection"],
Cell[547281, 14068, 1416, 44, 202, "Code"],
Cell[548700, 14114, 89, 2, 67, "Subsubsection"],
Cell[548792, 14118, 61, 0, 47, "Subsubsection"],
Cell[548856, 14120, 817, 28, 106, "Subsubsection"],
Cell[549676, 14150, 719, 14, 50, "Subsubsection"],
Cell[550398, 14166, 1812, 55, 158, "Subsubtitle"],
Cell[552213, 14223, 771, 11, 67, "Subsubsection"],
Cell[552987, 14236, 1770, 58, 251, "Code"],
Cell[554760, 14296, 44, 1, 6, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[554841, 14302, 837, 20, 80, "Title"],
Cell[555681, 14324, 61, 0, 181, "Subsubsection"],
Cell[555745, 14326, 434, 15, 193, "Subsubsection"],
Cell[556182, 14343, 610, 9, 125, "Subsubsection"],
Cell[556795, 14354, 1166, 37, 310, "Subsubtitle"],
Cell[557964, 14393, 771, 11, 181, "Subsubsection"],
Cell[558738, 14406, 1335, 44, 687, "Code"],
Cell[560076, 14452, 44, 1, 15, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[560157, 14458, 818, 20, 80, "Title"],
Cell[560978, 14480, 61, 0, 181, "Subsubsection"],
Cell[561042, 14482, 433, 15, 193, "Subsubsection"],
Cell[561478, 14499, 782, 16, 134, "Subsubsection"],
Cell[562263, 14517, 1518, 44, 404, "Subtitle"],
Cell[563784, 14563, 771, 11, 181, "Subsubsection"],
Cell[564558, 14576, 1645, 53, 687, "Code"],
Cell[566206, 14631, 44, 1, 15, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[566287, 14637, 690, 15, 80, "Title"],
Cell[566980, 14654, 57, 0, 393, "Subsubsection"],
Cell[567040, 14656, 729, 10, 270, "Subsubsection"],
Cell[567772, 14668, 1181, 28, 655, "Subsubtitle"],
Cell[568956, 14698, 771, 11, 393, "Subsubsection"],
Cell[569730, 14711, 765, 24, 1443, "Code"],
Cell[570498, 14737, 89, 2, 393, "Subsubsection"],
Cell[570590, 14741, 57, 0, 270, "Subsubsection"],
Cell[570650, 14743, 856, 17, 282, "Subsubsection"],
Cell[571509, 14762, 1495, 39, 702, "Subsubtitle"],
Cell[573007, 14803, 771, 11, 393, "Subsubsection"],
Cell[573781, 14816, 1845, 56, 2010, "Code"],
Cell[575629, 14874, 89, 2, 393, "Subsubsection"],
Cell[575721, 14878, 57, 0, 270, "Subsubsection"],
Cell[575781, 14880, 920, 18, 321, "Subsubsection"],
Cell[576704, 14900, 1209, 29, 655, "Subsubtitle"],
Cell[577916, 14931, 771, 11, 393, "Subsubsection"],
Cell[578690, 14944, 1886, 56, 2582, "Code"]
}, Closed]]
}
]
*)

(* End of internal cache information *)
