(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     52769,       1269]
NotebookOptionsPosition[     49580,       1178]
NotebookOutlinePosition[     50699,       1217]
CellTagsIndexPosition[     50656,       1214]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ArcSec", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, 3.495078733536543*^9, 
   3.4951361046771145`*^9, 3.495145058755439*^9, 3.495146022289532*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.821.2, CRC 445', A&S 4.4.62'", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9, 3.4941723607787027`*^9, 3.4941724567488375`*^9, 
   3.494172696119172*^9, 3.4950807812494097`*^9, 3.4951361632971964`*^9, 
   3.495145391254423*^9, 3.495146210535063*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"ArcSec", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], " ", 
        RowBox[{"ArcSec", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}]}], "b"]}]}]}]}], "-", 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], " ", 
      SqrtBox[
       RowBox[{"1", "-", 
        FractionBox["1", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], ")"}], "2"]]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495078733546543*^9, 3.495078733546543*^9}, {3.4950807901794224`*^9, 
   3.4950807944994287`*^9}, {3.4951361077071185`*^9, 3.4951361077171183`*^9}, 
   3.495136231147291*^9, {3.495145058771039*^9, 3.495145058771039*^9}, {
   3.4951454273216867`*^9, 3.4951454329688964`*^9}, {3.495146022289532*^9, 
   3.495146022289532*^9}, 3.4951462291302958`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"ArcSec", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", "x_"}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"ArcSec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "/", "b"}]}], " ", "-", " ", "\n", 
    "  ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}], "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"1", "-", 
           RowBox[{"1", "/", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}]}], "]"}]}], 
        ")"}]}], ",", "x"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.495078733546543*^9, 3.495078733546543*^9}, 3.4950807641093855`*^9, {
   3.4951361077271185`*^9, 3.4951361077271185`*^9}, 3.4951361778072166`*^9, {
   3.495145058771039*^9, 3.495145058771039*^9}, 3.4951453809584045`*^9, {
   3.495146022289532*^9, 3.495146022289532*^9}, 3.495146222406684*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"ArcSec", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, {3.494176335919876*^9, 
   3.494176356549905*^9}, 3.4950787336865435`*^9, 3.495136107887119*^9, 
   3.495145058771039*^9, 3.495146022289532*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.494173557270378*^9, {3.494176834460574*^9, 
   3.4941768354805756`*^9}, 3.495137570079166*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.4951375893491926`*^9, 3.495137619409235*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"ArcSec", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["a", "b"]}], "+", 
          FractionBox["x", "b"]}], ")"}], "m"], " ", 
       RowBox[{"ArcSec", "[", "x", "]"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, 
   3.494173593500429*^9, 3.494173663970527*^9, 3.4941739141808777`*^9, 
   3.494174420251586*^9, 3.494176720380414*^9, {3.4941767533004603`*^9, 
   3.4941767774904943`*^9}, {3.495078733696543*^9, 3.495078733696543*^9}, {
   3.495081754180772*^9, 3.4950817627807837`*^9}, {3.4951361078971186`*^9, 
   3.495136107907119*^9}, {3.495137296728783*^9, 3.495137299458787*^9}, {
   3.495137638459262*^9, 3.4951376782193174`*^9}, {3.495145058786639*^9, 
   3.495145058786639*^9}, {3.495146022305132*^9, 3.495146022305132*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"ArcSec", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "b"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "a"}], "/", "b"}], "+", 
             RowBox[{"x", "/", "b"}]}], ")"}], "^", "m"}], "*", 
          RowBox[{"ArcSec", "[", "x", "]"}]}], ",", "x"}], "]"}], ",", "x", 
       ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.4941735463003626`*^9, 3.494173866490811*^9, 3.494174071121097*^9, 
   3.494176683980363*^9, 3.4949886304357595`*^9, 3.4949909267385945`*^9, {
   3.495078733696543*^9, 3.495078733696543*^9}, 3.495082294241528*^9, {
   3.495136107917119*^9, 3.495136107917119*^9}, 3.4951372690987444`*^9, 
   3.4951375590891504`*^9, {3.495145058786639*^9, 3.495145058786639*^9}, 
   3.4951455158206415`*^9, {3.495146022305132*^9, 3.495146022305132*^9}, 
   3.495146293948409*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Reference: CRC 474", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9, 3.4941723607787027`*^9, 3.4941724567488375`*^9, 
   3.494172696119172*^9, 3.4941735657303896`*^9, 3.494176826510563*^9, 
   3.4950822724214973`*^9, 3.4951372505387187`*^9, 3.4951455874091673`*^9, 
   3.4951463168336496`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.494173557270378*^9, {3.494176834460574*^9, 
   3.4941768354805756`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"ArcSec", "[", 
     RowBox[{"a", " ", "x"}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"ArcSec", "[", 
         RowBox[{"a", " ", "x"}], "]"}]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox["x", 
       RowBox[{"m", "-", "1"}]], 
      SqrtBox[
       RowBox[{"1", "-", 
        FractionBox["1", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["x", "2"]}]]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, 
   3.494173593500429*^9, 3.494173663970527*^9, 3.4941739141808777`*^9, 
   3.494174420251586*^9, 3.494176720380414*^9, {3.4941767533004603`*^9, 
   3.4941767774904943`*^9}, {3.495078733696543*^9, 3.495078733696543*^9}, {
   3.495081754180772*^9, 3.4950817627807837`*^9}, {3.4951361078971186`*^9, 
   3.495136107907119*^9}, {3.495137296728783*^9, 3.495137299458787*^9}, {
   3.4951450588022394`*^9, 3.4951450588022394`*^9}, {3.4951456602908964`*^9, 
   3.4951457225350056`*^9}, {3.495145784810315*^9, 3.495145818927575*^9}, {
   3.495146022305132*^9, 3.495146022305132*^9}, 3.4951463322620764`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"ArcSec", "[", 
      RowBox[{"a_.", "*", "x_"}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"ArcSec", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"1", "-", 
           RowBox[{"1", "/", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "*", "x"}], ")"}], "^", "2"}]}]}], "]"}]}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.4941735463003626`*^9, 3.494173866490811*^9, 3.494174071121097*^9, 
   3.494176683980363*^9, 3.4949886304357595`*^9, 3.4949909267385945`*^9, {
   3.495078733696543*^9, 3.495078733696543*^9}, 3.495082294241528*^9, {
   3.495136107917119*^9, 3.495136107917119*^9}, 3.4951372690987444`*^9, {
   3.4951450588022394`*^9, 3.4951450588022394`*^9}, 3.4951456164252186`*^9, {
   3.4951458263375883`*^9, 3.4951458305183954`*^9}, 3.495145930514571*^9, {
   3.495146022305132*^9, 3.495146022320732*^9}, 3.495146352838513*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Reference: CRC 474", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9, 3.4941723607787027`*^9, 3.4941724567488375`*^9, 
   3.494172696119172*^9, 3.4941735657303896`*^9, 3.494176826510563*^9, 
   3.4950822724214973`*^9, 3.4951372505387187`*^9, 3.4951455874091673`*^9, 
   3.495146321170457*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.494173557270378*^9, {3.494176834460574*^9, 
   3.4941768354805756`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"ArcSec", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"ArcSec", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["b", 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox["x", 
       RowBox[{"m", "+", "1"}]], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "2"], " ", 
       SqrtBox[
        RowBox[{"1", "-", 
         FractionBox["1", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}], ")"}], "2"]]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, 
   3.494173593500429*^9, 3.494173663970527*^9, 3.4941739141808777`*^9, 
   3.494174420251586*^9, 3.494176720380414*^9, {3.4941767533004603`*^9, 
   3.4941767774904943`*^9}, {3.495078733696543*^9, 3.495078733696543*^9}, {
   3.495081754180772*^9, 3.4950817627807837`*^9}, {3.4951361078971186`*^9, 
   3.495136107907119*^9}, {3.495137296728783*^9, 3.495137299458787*^9}, {
   3.4951450588022394`*^9, 3.4951450588022394`*^9}, {3.495145905616927*^9, 
   3.4951459061785283`*^9}, {3.495146022320732*^9, 3.495146022320732*^9}, {
   3.4951463735865493`*^9, 3.4951463738985496`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"ArcSec", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"ArcSec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "/", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"1", "-", 
             RowBox[{"1", "/", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"a", "+", 
                 RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}]}], "]"}]}], 
          ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.4941735463003626`*^9, 3.494173866490811*^9, 3.494174071121097*^9, 
   3.494176683980363*^9, 3.4949886304357595`*^9, 3.4949909267385945`*^9, {
   3.495078733696543*^9, 3.495078733696543*^9}, 3.495082294241528*^9, {
   3.495136107917119*^9, 3.495136107917119*^9}, 3.4951372690987444`*^9, {
   3.4951450588022394`*^9, 3.4951450588022394`*^9}, {3.4951456164252186`*^9, 
   3.4951456381232576`*^9}, {3.495145913884942*^9, 3.495145927722166*^9}, {
   3.495146022320732*^9, 3.495146022320732*^9}, {3.495146369546142*^9, 
   3.495146393148984*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ArcSec", "[", 
       RowBox[{"a_.", "*", 
        RowBox[{"x_", "^", "n_."}]}], "]"}], "/", "x_"}], ",", "x_Symbol"}], 
    "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"I", "*", 
      RowBox[{
       RowBox[{
        RowBox[{"ArcSec", "[", 
         RowBox[{"a", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}], "^", "2"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "n"}], ")"}]}]}], " ", "-", " ", "\n", "  ", 
     RowBox[{
      RowBox[{"ArcSec", "[", 
       RowBox[{"a", "*", 
        RowBox[{"x", "^", "n"}]}], "]"}], "*", 
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"1", "-", 
         RowBox[{"1", "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"I", "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"x", "^", "n"}], "*", "a"}], ")"}]}], "+", 
             RowBox[{"Sqrt", "[", 
              RowBox[{"1", "-", 
               RowBox[{"1", "/", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"x", "^", 
                   RowBox[{"(", 
                    RowBox[{"2", "*", "n"}], ")"}]}], "*", 
                  RowBox[{"a", "^", "2"}]}], ")"}]}]}], "]"}]}], ")"}], "^", 
           "2"}]}]}], "]"}], "/", "n"}]}], " ", "+", " ", "\n", "  ", 
     RowBox[{"I", "*", 
      RowBox[{
       RowBox[{"PolyLog", "[", 
        RowBox[{"2", ",", 
         RowBox[{"1", "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"I", "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"x", "^", "n"}], "*", "a"}], ")"}]}], "+", 
             RowBox[{"Sqrt", "[", 
              RowBox[{"1", "-", 
               RowBox[{"1", "/", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"x", "^", 
                   RowBox[{"(", 
                    RowBox[{"2", "*", "n"}], ")"}]}], "*", 
                  RowBox[{"a", "^", "2"}]}], ")"}]}]}], "]"}]}], ")"}], "^", 
           "2"}]}]}], "]"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "n"}], ")"}]}]}]}], " ", "/;", "\n", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"-", "1"}], "/", 
         RowBox[{"a", "^", "2"}]}], "]"}], "*", "a", "*", 
       RowBox[{
        RowBox[{
         RowBox[{"ArcCsc", "[", 
          RowBox[{"a", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}], "^", "2"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "n"}], ")"}]}]}], " ", "+", " ", "\n", "  ", 
      RowBox[{"Pi", "*", 
       RowBox[{
        RowBox[{"Log", "[", "x", "]"}], "/", "2"}]}], " ", "-", " ", "\n", 
      "  ", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"-", "1"}], "/", 
         RowBox[{"a", "^", "2"}]}], "]"}], "*", "a", "*", 
       RowBox[{"ArcSinh", "[", 
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"-", "1"}], "/", 
           RowBox[{"a", "^", "2"}]}], "]"}], "/", 
         RowBox[{"x", "^", "n"}]}], "]"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"1", "-", 
          RowBox[{"1", "/", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"Sqrt", "[", 
                RowBox[{"-", 
                 RowBox[{"(", 
                  RowBox[{"1", "/", 
                   RowBox[{"a", "^", "2"}]}], ")"}]}], "]"}], "/", 
               RowBox[{"x", "^", "n"}]}], "+", 
              RowBox[{"Sqrt", "[", 
               RowBox[{"1", "-", 
                RowBox[{"1", "/", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"x", "^", 
                    RowBox[{"(", 
                    RowBox[{"2", "*", "n"}], ")"}]}], "*", 
                   RowBox[{"a", "^", "2"}]}], ")"}]}]}], "]"}]}], ")"}], "^", 
            "2"}]}]}], "]"}], "/", "n"}]}], " ", "+", " ", "\n", "  ", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"-", "1"}], "/", 
         RowBox[{"a", "^", "2"}]}], "]"}], "*", "a", "*", 
       RowBox[{
        RowBox[{"PolyLog", "[", 
         RowBox[{"2", ",", " ", 
          RowBox[{"1", "/", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "1"}], "/", 
                 RowBox[{"a", "^", "2"}]}], "]"}], "/", 
               RowBox[{"x", "^", "n"}]}], "+", 
              RowBox[{"Sqrt", "[", 
               RowBox[{"1", "-", 
                RowBox[{"1", "/", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"x", "^", 
                    RowBox[{"(", 
                    RowBox[{"2", "*", "n"}], ")"}]}], "*", 
                   RowBox[{"a", "^", "2"}]}], ")"}]}]}], "]"}]}], ")"}], "^", 
            "2"}]}]}], "]"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "n"}], ")"}]}]}]}], " ", "*)"}], "\n", 
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "n"}], "}"}], ",", "x"}], "]"}]}]}], " ", 
  "*)"}]], "Code",
 CellChangeTimes->{
  3.49513610866712*^9, {3.4951377176193724`*^9, 3.495137721059377*^9}, {
   3.495145058771039*^9, 3.495145058786639*^9}, 3.4951454842149863`*^9, {
   3.495146022305132*^9, 3.495146022305132*^9}, 3.4951462664611607`*^9}],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox[
    RowBox[{"ArcSec", "[", 
     FractionBox["c", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}]], "]"}], "m"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, {3.494176335919876*^9, 
   3.494176356549905*^9}, {3.4941768991306643`*^9, 3.4941769105806804`*^9}, {
   3.4941776449217086`*^9, 3.49417766022173*^9}, 3.4941785320029507`*^9, 
   3.4941787397900977`*^9, 3.4950787339465437`*^9, 3.49513610845712*^9, 
   3.4951450588022394`*^9, 3.495146022320732*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation:  Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.494173557270378*^9, {3.494176834460574*^9, 
   3.4941768354805756`*^9}, 3.4941787608189344`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"ArcSec", "[", "z", "]"}], "=", 
   RowBox[{"ArcCos", "[", 
    FractionBox["1", "z"], "]"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.494173557270378*^9, {3.494176834460574*^9, 
   3.4941768354805756`*^9}, {3.4941787608189344`*^9, 3.494178801550606*^9}, {
   3.495078733956544*^9, 3.495078733956544*^9}, {3.4950861359406147`*^9, 
   3.4950861359406147`*^9}, {3.4951361084771194`*^9, 
   3.4951361084771194`*^9}, {3.49513646583762*^9, 3.495136467907623*^9}, {
   3.495145058833439*^9, 3.4951450830134816`*^9}, {3.4951460223363323`*^9, 
   3.4951460223363323`*^9}, {3.4951461636569805`*^9, 3.4951461652169833`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.4941773316412697`*^9, 3.494177333751273*^9}, {
   3.4941781299723873`*^9, 3.494178211092501*^9}, {3.494178252592559*^9, 
   3.4941782798925977`*^9}, {3.49417832450266*^9, 3.494178365332717*^9}, {
   3.4941785870814295`*^9, 3.4941785879394307`*^9}, 3.4941788167606325`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox[
    RowBox[{"ArcSec", "[", 
     FractionBox["c", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}]], "]"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{"u", " ", 
       SuperscriptBox[
        RowBox[{"ArcCos", "[", 
         RowBox[{
          FractionBox["a", "c"], "+", 
          FractionBox[
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}], "c"]}], "]"}], "m"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.4941763955899596`*^9, 3.4941764290900064`*^9}, {3.4941764605500507`*^9, 
   3.4941764930400963`*^9}, 3.4941770641708956`*^9, 3.494177118590972*^9, 
   3.494177684591764*^9, {3.4941779313321095`*^9, 3.4941779814621797`*^9}, 
   3.494178084342324*^9, 3.4941786065034637`*^9, 3.494178689183609*^9, {
   3.4941788294122553`*^9, 3.4941788693171253`*^9}, 3.4950787339665437`*^9, 
   3.495086145060628*^9, 3.4951361084871197`*^9, {3.4951364819976425`*^9, 
   3.4951364852176476`*^9}, {3.495145058833439*^9, 3.495145085993087*^9}, 
   3.4951460223363323`*^9, {3.4951461687737894`*^9, 3.495146170567793*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"ArcSec", "[", 
       RowBox[{"c_.", "/", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", 
           RowBox[{"x_", "^", "n_."}]}]}], ")"}]}], "]"}], "^", "m_."}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u", "*", 
      RowBox[{
       RowBox[{"ArcCos", "[", 
        RowBox[{
         RowBox[{"a", "/", "c"}], "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"x", "^", "n"}], "/", "c"}]}]}], "]"}], "^", "m"}]}], ",", 
     "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "n", ",", "m"}], "}"}], ",", 
     "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.4941763709899254`*^9, 3.49417638178994*^9}, 3.494176933060712*^9, {
   3.4941774426614256`*^9, 3.494177546511571*^9}, {3.494177592181635*^9, 
   3.494177592971636*^9}, {3.4941776926217756`*^9, 3.4941777113818016`*^9}, {
   3.4941777916119137`*^9, 3.494177794051917*^9}, 3.494178543602967*^9, 
   3.4941789047135873`*^9, 3.4950787339665437`*^9, 3.495086153090639*^9, 
   3.49513610849712*^9, 3.495136509297681*^9, 3.495145058833439*^9, 
   3.495145088972692*^9, 3.4951460223363323`*^9, 3.49514618045821*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True,
 CellChangeTimes->{3.495137147148574*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"ArcSec", "[", "u", "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160783652334`*^9, 3.4796867206047907`*^9, 3.492825781557537*^9, 
   3.4940008742017097`*^9, {3.494179192846093*^9, 3.4941791992265043`*^9}, 
   3.495078733996544*^9, 3.49513610855712*^9, 3.495145058833439*^9, 
   3.4951460223363323`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell["Rule: If u is free of inverse functions, then", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703531363038*^9, 
   3.4807035352686543`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"ArcSec", "[", "u", "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "x"}]}], " ", 
    RowBox[{"ArcSec", "[", "u", "]"}]}]}], "-", 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", " ", 
      RowBox[{
       SubscriptBox["\[PartialD]", "x"], "u"}]}], 
     RowBox[{
      SuperscriptBox["u", "2"], 
      SqrtBox[
       RowBox[{"1", "-", 
        FractionBox["1", 
         SuperscriptBox["u", "2"]]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579734230976`*^9, 3.4796580026851745`*^9}, {
   3.479658101347043*^9, 3.479658102348483*^9}, {3.4796582237129965`*^9, 
   3.4796582279090304`*^9}, {3.4796611944647284`*^9, 3.4796612203719807`*^9}, 
   3.4796613933206687`*^9, {3.4796614761798143`*^9, 3.4796614777420607`*^9}, 
   3.4796618658000607`*^9, {3.4796619856624146`*^9, 3.4796619866938972`*^9}, {
   3.4796645712002354`*^9, 3.4796645805536847`*^9}, 3.4796646283424015`*^9, {
   3.4796867206148047`*^9, 3.4796867206148047`*^9}, {3.479687667676613*^9, 
   3.479687667926973*^9}, 3.480705232098576*^9, {3.49400087421271*^9, 
   3.49400087421371*^9}, {3.494022456770984*^9, 3.4940224580430565`*^9}, {
   3.494179204577314*^9, 3.4941792454181857`*^9}, {3.4950787340065436`*^9, 
   3.4950787340065436`*^9}, {3.49508586111023*^9, 3.4950858614902306`*^9}, {
   3.4951361085671196`*^9, 3.49513610857712*^9}, {3.4951366645778985`*^9, 
   3.49513667291791*^9}, {3.4951367366679993`*^9, 3.495136737118*^9}, {
   3.495145058833439*^9, 3.495145058833439*^9}, {3.495145200013687*^9, 
   3.4951452006220884`*^9}, {3.4951460223363323`*^9, 3.4951460223363323`*^9}, 
   3.4951460918188543`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"ArcSec", "[", "u_", "]"}], ",", "x_Symbol"}], "]"}], " ", ":=", 
  "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"ArcSec", "[", "u", "]"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"Regularize", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{"u", ",", "x"}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"u", "^", "2"}], "*", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"1", "-", 
              RowBox[{"1", "/", 
               RowBox[{"u", "^", "2"}]}]}], "]"}]}], ")"}]}]}], ",", "x"}], 
       "]"}], ",", "x"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"InverseFunctionFreeQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"FunctionOfExponentialOfLinear", "[", 
      RowBox[{"u", ",", "x"}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.49400087422171*^9, 3.4940008742237105`*^9}, {
   3.494022461285242*^9, 3.4940224616042604`*^9}, 3.4941791634400415`*^9, 
   3.494179261657814*^9, {3.4943677210722713`*^9, 3.494367728102281*^9}, {
   3.4950787340165434`*^9, 3.4950787340165434`*^9}, 3.495085852480218*^9, {
   3.49513610858712*^9, 3.49513610858712*^9}, 3.4951365932477984`*^9, {
   3.495145058849039*^9, 3.495145058849039*^9}, 3.495145177159647*^9, {
   3.4951460223363323`*^9, 3.4951460223519325`*^9}, 3.4951460772016287`*^9},
 Background->GrayLevel[0.85]]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Rules for Inverse Secant Functions", None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.399999976158142,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 1050, 22, 118, "Title"],
Cell[1620, 46, 358, 5, 67, "Subsubsection"],
Cell[1981, 53, 101, 1, 47, "Subsubsection"],
Cell[2085, 56, 732, 10, 47, "Subsubsection"],
Cell[2820, 68, 2267, 52, 197, "Subsubtitle"],
Cell[5090, 122, 795, 11, 67, "Subsubsection"],
Cell[5888, 135, 1673, 46, 251, "Code"],
Cell[7564, 183, 44, 1, 6, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[7645, 189, 1107, 23, 80, "Title"],
Cell[8755, 214, 207, 3, 67, "Subsubsection"],
Cell[8965, 219, 1133, 20, 50, "Subsubsection"],
Cell[10101, 241, 2243, 46, 114, "Subsubtitle"],
Cell[12347, 289, 795, 11, 67, "Subsubsection"],
Cell[13145, 302, 1808, 46, 202, "Code"],
Cell[14956, 350, 113, 2, 67, "Subsubsection"],
Cell[15072, 354, 385, 6, 47, "Subsubsection"],
Cell[15460, 362, 178, 3, 47, "Subsubsection"],
Cell[15641, 367, 1025, 19, 50, "Subsubsection"],
Cell[16669, 388, 2517, 56, 197, "Subsubtitle"],
Cell[19189, 446, 795, 11, 67, "Subsubsection"],
Cell[19987, 459, 2160, 57, 251, "Code"],
Cell[22150, 518, 113, 2, 67, "Subsubsection"],
Cell[22266, 522, 383, 6, 47, "Subsubsection"],
Cell[22652, 530, 178, 3, 47, "Subsubsection"],
Cell[22833, 535, 1025, 19, 50, "Subsubsection"],
Cell[23861, 556, 2691, 62, 197, "Subsubtitle"],
Cell[26555, 620, 795, 11, 67, "Subsubsection"],
Cell[27353, 633, 2448, 66, 251, "Code"],
Cell[29804, 701, 5573, 161, 516, "Code"],
Cell[35380, 864, 44, 1, 6, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[35461, 870, 1320, 27, 83, "Title"],
Cell[36784, 899, 207, 3, 67, "Subsubsection"],
Cell[36994, 904, 710, 15, 75, "Subsubsection"],
Cell[37707, 921, 1191, 16, 47, "Subsubsection"],
Cell[38901, 939, 2251, 44, 120, "Subsubtitle"],
Cell[41155, 985, 795, 11, 67, "Subsubsection"],
Cell[41953, 998, 1629, 40, 202, "Code"],
Cell[43585, 1040, 86, 2, 6, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[43708, 1047, 852, 18, 80, "Title"],
Cell[44563, 1067, 57, 0, 67, "Subsubsection"],
Cell[44623, 1069, 729, 10, 47, "Subsubsection"],
Cell[45355, 1081, 1852, 40, 197, "Subsubtitle"],
Cell[47210, 1123, 771, 11, 67, "Subsubsection"],
Cell[47984, 1136, 1580, 39, 251, "Code"]
}, Closed]]
}
]
*)

(* End of internal cache information *)
