(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    379820,       7864]
NotebookOptionsPosition[    371834,       7669]
NotebookOutlinePosition[    373358,       7718]
CellTagsIndexPosition[    373315,       7715]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Trig Integration Recurrence Equations", "Title",
 CellChangeTimes->{{3.5492156771469984`*^9, 3.549215690467017*^9}},
 TextAlignment->Center],

Cell[CellGroupData[{

Cell["Sine Integration Recurrence Equations", "Subtitle",
 CellChangeTimes->{{3.549223049504921*^9, 3.54922306284494*^9}, {
  3.549223137235044*^9, 3.5492231658250837`*^9}},
 TextAlignment->Center,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    StyleBox["\[Integral]",
     FontSize->18], 
    RowBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "m"],
      FontSize->18], 
     StyleBox[
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}],
      FontSize->18], 
     StyleBox[" ",
      FontSize->18], 
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"],
      FontSize->18], 
     StyleBox[
      RowBox[{"\[DifferentialD]", "x"}],
      FontSize->18], 
     StyleBox["  ",
      FontSize->18], 
     StyleBox["when",
      FontFamily->"Arial Narrow",
      FontSize->20,
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontSize->18], 
     StyleBox[
      SuperscriptBox["a", "2"],
      FontSize->18]}]}], 
   StyleBox["-",
    FontSize->18], 
   StyleBox[
    SuperscriptBox["b", "2"],
    FontSize->18]}], 
  StyleBox["\[Equal]",
   FontSize->18], 
  StyleBox["0",
   FontSize->18]}]],
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, {3.501043182982005*^9, 3.501043190019408*^9}, {
   3.502999922267273*^9, 3.5029999245372763`*^9}, 3.505344641393784*^9, {
   3.5053446930938563`*^9, 3.505344715003887*^9}, 3.5053535501052*^9, 
   3.5094714967392817`*^9, {3.5094716071916*^9, 3.509471662428759*^9}, {
   3.509471696610714*^9, 3.5094717281785192`*^9}, {3.509471786124834*^9, 
   3.509471792090175*^9}, {3.509471873836851*^9, 3.509471876436*^9}, {
   3.5095562652147536`*^9, 3.5095563252848377`*^9}, {3.50955638387492*^9, 
   3.5095564136949615`*^9}, {3.5095564499650126`*^9, 
   3.5095565745651865`*^9}, {3.509556659575306*^9, 3.5095566816053367`*^9}, {
   3.5095567320554075`*^9, 3.5095567407354193`*^9}, {3.509556895905637*^9, 
   3.5095569251456776`*^9}, {3.510172496160655*^9, 3.510172513227085*^9}, {
   3.5101727774135485`*^9, 3.5101727805647545`*^9}, {3.5101732386595592`*^9, 
   3.51017323937716*^9}, {3.510173272480418*^9, 3.510173288844847*^9}, {
   3.513278609965268*^9, 3.513278645275317*^9}, {3.513278681485368*^9, 
   3.513278702895398*^9}, 3.513278843665595*^9, {3.515187351099949*^9, 
   3.515187352819951*^9}, 3.515976581518583*^9, {3.5468187568007107`*^9, 
   3.546818756820711*^9}, {3.5468189049209185`*^9, 3.5468189421209707`*^9}, 
   3.5468192801014433`*^9, {3.5468196449319544`*^9, 3.5468196451219544`*^9}, {
   3.546819981802426*^9, 3.546819982042426*^9}, {3.546820459783095*^9, 
   3.546820459783095*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"]], "Subsubtitle",
 CellChangeTimes->{
  3.5492157676571255`*^9, {3.549215838347224*^9, 3.5492158921672993`*^9}},
 TextAlignment->Center],

Cell[TextData[{
 "Symmetric sine recurrence 1a: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.5492163850779896`*^9, 3.5492163861679907`*^9}, {
   3.549218830909015*^9, 3.549218846409037*^9}, {3.549220997182048*^9, 
   3.5492210002120523`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"d", 
   RowBox[{"(", 
    RowBox[{"m", "+", "1"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], " ", "\[Equal]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"a", " ", "A", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"m", "+", "1"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     RowBox[{"n", "-", "1"}]]}], "+", "\[IndentingNewLine]", 
   RowBox[{"d", " ", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"m", "+", "1"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", " ", "b"}], "+", 
           RowBox[{"a", " ", "B"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], "-", 
        RowBox[{"A", " ", "b", " ", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "A", " ", "n"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", " ", "A"}], "+", 
              RowBox[{"b", " ", "B"}]}], ")"}], 
            RowBox[{"(", 
             RowBox[{"m", "+", "1"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "-", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, 3.5016099413762174`*^9, 3.5016100187211533`*^9, 
   3.5016103056680574`*^9, {3.501610366398964*^9, 3.5016103716405735`*^9}, 
   3.5016104208646603`*^9, 3.501791000186797*^9, 3.5017919112180724`*^9, 
   3.5053446395037813`*^9, {3.5053446874638486`*^9, 3.5053447131738844`*^9}, 
   3.5053448537940817`*^9, {3.509845096965584*^9, 3.5098451454756517`*^9}, {
   3.5098452252157636`*^9, 3.5098452294457693`*^9}, 3.5098452628858166`*^9, {
   3.5098452931158586`*^9, 3.5098453190758953`*^9}, {3.5101628923486614`*^9, 
   3.5101629387743425`*^9}, {3.5492160738175535`*^9, 
   3.5492161279276295`*^9}, {3.549216393738002*^9, 3.549216419358038*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Symmetric sine",
 " recurrence 1b: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.549218817878997*^9, 3.5492188211590014`*^9}, 
   3.549218868949068*^9, 3.5492210063920608`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"d", 
   RowBox[{"(", 
    RowBox[{"m", "+", "n", "+", "1"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], " ", "\[Equal]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "b"}], " ", "B", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"m", "+", "1"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     RowBox[{"n", "-", "1"}]]}], "+", "\[IndentingNewLine]", 
   RowBox[{"d", " ", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "A", " ", "n"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "A"}], "+", 
           RowBox[{"b", " ", "B"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", " ", "b"}], "+", 
           RowBox[{"a", " ", "B", " ", "n"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"A", " ", "b"}], "+", 
              RowBox[{"a", " ", "B"}]}], ")"}], 
            RowBox[{"(", 
             RowBox[{"m", "+", "n"}], ")"}]}]}], ")"}], 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "-", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, 3.5016099413762174`*^9, 3.5016100187211533`*^9, 
   3.5016103056680574`*^9, {3.501610366398964*^9, 3.5016103716405735`*^9}, 
   3.5016104208646603`*^9, 3.501791000186797*^9, 3.5017919112180724`*^9, 
   3.5053446395037813`*^9, {3.5053446874638486`*^9, 3.5053447131738844`*^9}, 
   3.5053448537940817`*^9, {3.509845096965584*^9, 3.5098451454756517`*^9}, {
   3.5098452252157636`*^9, 3.5098452294457693`*^9}, 3.5098452628858166`*^9, {
   3.5098452931158586`*^9, 3.5098453190758953`*^9}, {3.5101628923486614`*^9, 
   3.5101629387743425`*^9}, {3.5492160738175535`*^9, 3.5492161279276295`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Symmetric sine",
 " recurrence 2a: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.5492163850779896`*^9, 3.5492163861679907`*^9}, {
   3.5492164773381186`*^9, 3.5492164780781193`*^9}, 3.5492188331190186`*^9, {
   3.5492188867390933`*^9, 3.549218887279094*^9}, 3.5492210077420626`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["a", "2"], " ", "d", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", "n"}], "+", "1"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], " ", "\[Equal]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"a", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"A", " ", "b"}], "-", 
      RowBox[{"a", " ", "B"}]}], ")"}], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], "+", 
   "\[IndentingNewLine]", 
   RowBox[{"d", " ", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"m", "-", "1"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "m"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", " ", "b"}], "-", 
           RowBox[{"a", " ", "B"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "B", " ", "n"}], "+", 
           RowBox[{"a", " ", "A", " ", 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}], "+", 
           RowBox[{"m", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", " ", "A"}], "-", 
              RowBox[{"b", " ", "B"}]}], ")"}]}]}], ")"}], 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "+", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, 3.5016099413762174`*^9, 3.5016100187211533`*^9, 
   3.5016103056680574`*^9, {3.501610366398964*^9, 3.5016103716405735`*^9}, 
   3.5016104208646603`*^9, 3.501791000186797*^9, 3.5017919112180724`*^9, 
   3.5053446395037813`*^9, {3.5053446874638486`*^9, 3.5053447131738844`*^9}, 
   3.5053448537940817`*^9, {3.509845096965584*^9, 3.5098451454756517`*^9}, {
   3.5098452252157636`*^9, 3.5098452294457693`*^9}, 3.5098452628858166`*^9, {
   3.5098452931158586`*^9, 3.5098453190758953`*^9}, {3.5101628923486614`*^9, 
   3.5101629387743425`*^9}, {3.5492160738175535`*^9, 
   3.5492161279276295`*^9}, {3.549216393738002*^9, 3.549216419358038*^9}, {
   3.549216487628133*^9, 3.5492164965881453`*^9}, {3.5492165451082134`*^9, 
   3.549216555958229*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Symmetric sine",
 " recurrence 2b: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.5492163850779896`*^9, 3.5492163861679907`*^9}, {
   3.5492164773381186`*^9, 3.5492164780781193`*^9}, {3.5492165738282537`*^9, 
   3.549216574638255*^9}, 3.5492188346590204`*^9, {3.5492189082691236`*^9, 
   3.5492189089591246`*^9}, 3.5492210094220653`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["b", "2"], "d", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", "n"}], "+", "1"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], " ", "\[Equal]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "b"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"A", " ", "b"}], "-", 
      RowBox[{"a", " ", "B"}]}], ")"}], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"m", "+", "1"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], "+", 
   "\[IndentingNewLine]", 
   RowBox[{"d", " ", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "A", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "A"}], "-", 
           RowBox[{"b", " ", "B"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", " ", "b"}], "-", 
           RowBox[{"a", " ", "B"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{"m", "+", "n", "+", "2"}], ")"}], 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "+", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, 3.5016099413762174`*^9, 3.5016100187211533`*^9, 
   3.5016103056680574`*^9, {3.501610366398964*^9, 3.5016103716405735`*^9}, 
   3.5016104208646603`*^9, 3.501791000186797*^9, 3.5017919112180724`*^9, 
   3.5053446395037813`*^9, {3.5053446874638486`*^9, 3.5053447131738844`*^9}, 
   3.5053448537940817`*^9, {3.509845096965584*^9, 3.5098451454756517`*^9}, {
   3.5098452252157636`*^9, 3.5098452294457693`*^9}, 3.5098452628858166`*^9, {
   3.5098452931158586`*^9, 3.5098453190758953`*^9}, {3.5101628923486614`*^9, 
   3.5101629387743425`*^9}, {3.5492160738175535`*^9, 
   3.5492161279276295`*^9}, {3.549216393738002*^9, 3.549216419358038*^9}, {
   3.549216487628133*^9, 3.5492164965881453`*^9}, {3.5492165451082134`*^9, 
   3.549216555958229*^9}, {3.549216613308309*^9, 3.549216647008356*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Symmetric sine",
 " recurrence 3a: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.5492163850779896`*^9, 3.5492163861679907`*^9}, {
   3.5492164773381186`*^9, 3.5492164780781193`*^9}, {3.5492165738282537`*^9, 
   3.549216574638255*^9}, {3.549217395399404*^9, 3.5492173956794043`*^9}, 
   3.5492188362490225`*^9, {3.549218919039139*^9, 3.549218919509139*^9}, 
   3.549221010962067*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "d", 
   RowBox[{"(", 
    RowBox[{"m", "+", "n", "+", "1"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "=", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "a"}], " ", "B", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], "+", 
   "\[IndentingNewLine]", 
   RowBox[{"d", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"m", "-", "1"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "B", " ", "m"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "B", " ", "n"}], "+", 
           RowBox[{"a", " ", "A", 
            RowBox[{"(", 
             RowBox[{"m", "+", "n", "+", "1"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, {3.5011911220866604`*^9, 3.501191124796664*^9}, {
   3.501613889026425*^9, 3.501613959896524*^9}, {3.501633969615137*^9, 
   3.5016340146827154`*^9}, {3.5016340459675045`*^9, 3.501634132334444*^9}, {
   3.513202312159873*^9, 3.5132023348401704`*^9}, {3.5132024119775825`*^9, 
   3.5132024121975946`*^9}, {3.513202534040564*^9, 3.5132025453582115`*^9}, {
   3.51320266422901*^9, 3.5132026683982487`*^9}, 3.513204378062036*^9, {
   3.513204418605355*^9, 3.5132044382114763`*^9}, {3.513204482094986*^9, 
   3.5132044900344405`*^9}, 3.513204523495354*^9, {3.513204847503886*^9, 
   3.513204875625495*^9}, {3.5132049149997473`*^9, 3.5132049240462646`*^9}, {
   3.5132052784165335`*^9, 3.513205279369588*^9}, 3.5132055395604696`*^9, {
   3.5132064293653636`*^9, 3.5132064350826907`*^9}, {3.549217452879484*^9, 
   3.5492175858296704`*^9}, {3.549217685817412*^9, 3.5492176981174297`*^9}, 
   3.549218100517993*^9, {3.549218181408106*^9, 3.549218182318107*^9}, {
   3.5492182153881536`*^9, 3.5492182160281544`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Symmetric sine",
 " recurrence 3b: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.5492163850779896`*^9, 3.5492163861679907`*^9}, {
   3.5492164773381186`*^9, 3.5492164780781193`*^9}, {3.5492165738282537`*^9, 
   3.549216574638255*^9}, {3.549217395399404*^9, 3.5492173956794043`*^9}, {
   3.5492174277494493`*^9, 3.54921742795945*^9}, {3.549218927829151*^9, 
   3.5492189424691715`*^9}, 3.5492210139220715`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "d", 
   RowBox[{"(", 
    RowBox[{"m", "+", "1"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "=", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"a", " ", "A", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"m", "+", "1"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], "+", 
   "\[IndentingNewLine]", 
   RowBox[{"d", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"m", "+", "1"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "B", " ", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], "-", 
        RowBox[{"b", " ", "A", " ", "n"}], "+", 
        RowBox[{"a", " ", "A", 
         RowBox[{"(", 
          RowBox[{"m", "+", "n", "+", "2"}], ")"}], 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, {3.5011911220866604`*^9, 3.501191124796664*^9}, {
   3.501613889026425*^9, 3.501613959896524*^9}, {3.501633969615137*^9, 
   3.5016340146827154`*^9}, {3.5016340459675045`*^9, 3.501634132334444*^9}, {
   3.5016343278136253`*^9, 3.501634437195882*^9}, 3.5016345097430305`*^9, 
   3.501634610292782*^9, {3.5132023129019156`*^9, 3.5132023349341755`*^9}, {
   3.513202412725625*^9, 3.5132024129406376`*^9}, {3.5132025703136387`*^9, 
   3.5132025755589385`*^9}, {3.513202679841903*^9, 3.513202683741126*^9}, 
   3.513204390453745*^9, {3.5132265746973467`*^9, 3.513226705596833*^9}, {
   3.513226777538948*^9, 3.5132267819462004`*^9}, {3.549217480369523*^9, 
   3.5492175227595825`*^9}, {3.5492175885796747`*^9, 3.5492176781974015`*^9}, 
   3.549218102267995*^9, 3.549218185088111*^9, {3.549218216558155*^9, 
   3.5492182171281557`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    StyleBox["\[Integral]",
     FontSize->18], 
    RowBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "m"],
      FontSize->18], 
     StyleBox[
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"C", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}],
      FontSize->18], 
     StyleBox[" ",
      FontSize->18], 
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"],
      FontSize->18], 
     StyleBox[
      RowBox[{"\[DifferentialD]", "x"}],
      FontSize->18], 
     StyleBox["  ",
      FontSize->18], 
     StyleBox["when",
      FontFamily->"Arial Narrow",
      FontSize->20,
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontSize->18], 
     StyleBox[
      SuperscriptBox["a", "2"],
      FontSize->18]}]}], 
   StyleBox["-",
    FontSize->18], 
   StyleBox[
    SuperscriptBox["b", "2"],
    FontSize->18]}], 
  StyleBox["\[NotEqual]",
   FontSize->18], 
  StyleBox["0",
   FontSize->18]}]],
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, {3.501043182982005*^9, 3.501043190019408*^9}, {
   3.502999922267273*^9, 3.5029999245372763`*^9}, 3.505344641393784*^9, {
   3.5053446930938563`*^9, 3.505344715003887*^9}, 3.5053535501052*^9, 
   3.5094714967392817`*^9, {3.5094716071916*^9, 3.509471662428759*^9}, {
   3.509471696610714*^9, 3.5094717281785192`*^9}, {3.509471786124834*^9, 
   3.509471792090175*^9}, {3.509471873836851*^9, 3.509471876436*^9}, {
   3.5095562652147536`*^9, 3.5095563252848377`*^9}, {3.50955638387492*^9, 
   3.5095564136949615`*^9}, {3.5095564499650126`*^9, 
   3.5095565745651865`*^9}, {3.509556659575306*^9, 3.5095566816053367`*^9}, {
   3.5095567320554075`*^9, 3.5095567407354193`*^9}, {3.509556895905637*^9, 
   3.5095569251456776`*^9}, {3.510172496160655*^9, 3.510172513227085*^9}, {
   3.5101727774135485`*^9, 3.5101727805647545`*^9}, {3.5101732386595592`*^9, 
   3.51017323937716*^9}, {3.510173272480418*^9, 3.510173288844847*^9}, {
   3.513278609965268*^9, 3.513278645275317*^9}, {3.513278681485368*^9, 
   3.513278702895398*^9}, 3.513278843665595*^9, {3.515187351099949*^9, 
   3.515187352819951*^9}, 3.515976581518583*^9, {3.5468187568007107`*^9, 
   3.546818756820711*^9}, {3.5468189049209185`*^9, 3.5468189421209707`*^9}, 
   3.5468192801014433`*^9, {3.5468196449319544`*^9, 3.5468196451219544`*^9}, {
   3.546819981802426*^9, 3.546819982042426*^9}, {3.546820459783095*^9, 
   3.546820459783095*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"]], "Subsubtitle",
 CellChangeTimes->{
  3.5492157676571255`*^9, {3.549215838347224*^9, 3.5492158921672993`*^9}, {
   3.5492191003093925`*^9, 3.5492191003093925`*^9}, {3.5492192136095514`*^9, 
   3.5492192136095514`*^9}},
 TextAlignment->Center],

Cell["Sine recurrence 1a:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.5492163850779896`*^9, 3.5492163861679907`*^9}, {
   3.549218830909015*^9, 3.549218846409037*^9}, {3.5492190914793797`*^9, 
   3.549219093619383*^9}, 3.5492191583694735`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"d", 
   RowBox[{"(", 
    RowBox[{"m", "+", "1"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], " ", "\[Equal]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"A", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"m", "+", "1"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], "+", 
   "\[IndentingNewLine]", 
   RowBox[{"d", " ", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"m", "+", "1"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "B", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], "-", 
        RowBox[{"b", " ", "A", " ", "n"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "A"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", " ", "A"}], "+", 
              RowBox[{"b", " ", "B"}], "+", 
              RowBox[{"a", " ", "C"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"m", "+", "1"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"b", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", " ", 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"A", "+", "C"}], ")"}], 
            RowBox[{"(", 
             RowBox[{"m", "+", "1"}], ")"}]}]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "-", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, 3.5016099413762174`*^9, 3.5016100187211533`*^9, 
   3.5016103056680574`*^9, {3.501610366398964*^9, 3.5016103716405735`*^9}, 
   3.5016104208646603`*^9, 3.501791000186797*^9, 3.5017919112180724`*^9, 
   3.5053446395037813`*^9, {3.5053446874638486`*^9, 3.5053447131738844`*^9}, 
   3.5053448537940817`*^9, {3.509845096965584*^9, 3.5098451454756517`*^9}, {
   3.5098452252157636`*^9, 3.5098452294457693`*^9}, 3.5098452628858166`*^9, {
   3.5098452931158586`*^9, 3.5098453190758953`*^9}, {3.5101628923486614`*^9, 
   3.5101629387743425`*^9}, {3.5492160738175535`*^9, 
   3.5492161279276295`*^9}, {3.549216393738002*^9, 3.549216419358038*^9}, {
   3.5492192947996645`*^9, 3.549219324379706*^9}, 3.5492196342301397`*^9, 
   3.549236814779919*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Sine recurrence 1b:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.5492163850779896`*^9, 3.5492163861679907`*^9}, {
   3.549218830909015*^9, 3.549218846409037*^9}, {3.5492190914793797`*^9, 
   3.549219093619383*^9}, 3.5492191583694735`*^9, {3.5492193545997486`*^9, 
   3.54921935556975*^9}, {3.549219604330098*^9, 3.5492196065201015`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"d", " ", 
   RowBox[{"(", 
    RowBox[{"m", "+", "n", "+", "2"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], " ", "\[Equal]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "C"}], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"m", "+", "1"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], "+", 
   "\[IndentingNewLine]", 
   RowBox[{"d", " ", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"A", "+", "C"}], ")"}], 
            RowBox[{"(", 
             RowBox[{"m", "+", "1"}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", " ", "b"}], "+", 
           RowBox[{"a", " ", "B"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"A", " ", "b"}], "+", 
              RowBox[{"a", " ", "B"}], "+", 
              RowBox[{"b", " ", "C"}]}], ")"}], 
            RowBox[{"(", 
             RowBox[{"m", "+", "n", "+", "1"}], ")"}]}]}], ")"}], 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "C", " ", "n"}], "+", 
           RowBox[{"b", " ", "B", " ", 
            RowBox[{"(", 
             RowBox[{"m", "+", "n", "+", "2"}], ")"}]}]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "-", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, 3.5016099413762174`*^9, 3.5016100187211533`*^9, 
   3.5016103056680574`*^9, {3.501610366398964*^9, 3.5016103716405735`*^9}, 
   3.5016104208646603`*^9, 3.501791000186797*^9, 3.5017919112180724`*^9, 
   3.5053446395037813`*^9, {3.5053446874638486`*^9, 3.5053447131738844`*^9}, 
   3.5053448537940817`*^9, {3.509845096965584*^9, 3.5098451454756517`*^9}, {
   3.5098452252157636`*^9, 3.5098452294457693`*^9}, 3.5098452628858166`*^9, {
   3.5098452931158586`*^9, 3.5098453190758953`*^9}, {3.5101628923486614`*^9, 
   3.5101629387743425`*^9}, {3.5492160738175535`*^9, 
   3.5492161279276295`*^9}, {3.549216393738002*^9, 3.549216419358038*^9}, {
   3.5492192947996645`*^9, 3.549219324379706*^9}, {3.549219511019967*^9, 
   3.549219538730006*^9}, 3.5492196365601435`*^9, {3.5492367655331025`*^9, 
   3.549236778317834*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Sine recurrence 2a:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.5492163850779896`*^9, 3.5492163861679907`*^9}, {
   3.549218830909015*^9, 3.549218846409037*^9}, {3.5492190914793797`*^9, 
   3.549219093619383*^9}, 3.5492191583694735`*^9, {3.5492193545997486`*^9, 
   3.54921935556975*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"b", " ", "d", " ", 
   RowBox[{"(", 
    RowBox[{"n", "+", "1"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], " ", "\[Equal]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A", " ", 
        SuperscriptBox["b", "2"]}], "-", 
       RowBox[{"a", " ", "b", " ", "B"}], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", "C"}]}], ")"}]}], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     RowBox[{"n", "+", "1"}]]}], "+", "\[IndentingNewLine]", 
   RowBox[{"d", " ", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"m", "-", "1"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"m", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"a", " ", "b", " ", "B"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "C"}]}], ")"}]}], "+", 
        RowBox[{"b", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "A"}], "-", 
           RowBox[{"b", " ", "B"}], "+", 
           RowBox[{"a", " ", "C"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"A", " ", "b"}], "-", 
              RowBox[{"a", " ", "B"}], "+", 
              RowBox[{"b", " ", "C"}]}], ")"}], 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"A", " ", 
               SuperscriptBox["b", "2"]}], "-", 
              RowBox[{"a", " ", "b", " ", "B"}], "+", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", "C"}]}], ")"}], 
            RowBox[{"(", 
             RowBox[{"m", "+", "1"}], ")"}]}]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "+", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, 3.5016099413762174`*^9, 3.5016100187211533`*^9, 
   3.5016103056680574`*^9, {3.501610366398964*^9, 3.5016103716405735`*^9}, 
   3.5016104208646603`*^9, 3.501791000186797*^9, 3.5017919112180724`*^9, 
   3.5053446395037813`*^9, {3.5053446874638486`*^9, 3.5053447131738844`*^9}, 
   3.5053448537940817`*^9, {3.509845096965584*^9, 3.5098451454756517`*^9}, {
   3.5098452252157636`*^9, 3.5098452294457693`*^9}, 3.5098452628858166`*^9, {
   3.5098452931158586`*^9, 3.5098453190758953`*^9}, {3.5101628923486614`*^9, 
   3.5101629387743425`*^9}, {3.5492160738175535`*^9, 
   3.5492161279276295`*^9}, {3.549216393738002*^9, 3.549216419358038*^9}, {
   3.5492192947996645`*^9, 3.549219324379706*^9}, {3.549219511019967*^9, 
   3.549219538730006*^9}, {3.5492196393301473`*^9, 3.549219688500216*^9}, {
   3.5492366565878716`*^9, 3.549236666657447*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Sine recurrence 2b:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.5492163850779896`*^9, 3.5492163861679907`*^9}, {
   3.549218830909015*^9, 3.549218846409037*^9}, {3.5492190914793797`*^9, 
   3.549219093619383*^9}, 3.5492191583694735`*^9, {3.5492193545997486`*^9, 
   3.54921935556975*^9}, {3.5492197078802433`*^9, 3.5492197082902436`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "d", " ", 
   RowBox[{"(", 
    RowBox[{"n", "+", "1"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], " ", "\[Equal]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"A", " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{"a", " ", "b", " ", "B"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "C"}]}], ")"}], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"m", "+", "1"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     RowBox[{"n", "+", "1"}]]}], "+", "\[IndentingNewLine]", 
   RowBox[{"d", " ", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"A", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"a", " ", "b", " ", "B"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "C"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], "-", 
        RowBox[{"a", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", " ", "b"}], "-", 
           RowBox[{"a", " ", "B"}], "+", 
           RowBox[{"b", " ", "C"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"a", " ", "b", " ", "B"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "C"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{"m", "+", "n", "+", "3"}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "+", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, 3.5016099413762174`*^9, 3.5016100187211533`*^9, 
   3.5016103056680574`*^9, {3.501610366398964*^9, 3.5016103716405735`*^9}, 
   3.5016104208646603`*^9, 3.501791000186797*^9, 3.5017919112180724`*^9, 
   3.5053446395037813`*^9, {3.5053446874638486`*^9, 3.5053447131738844`*^9}, 
   3.5053448537940817`*^9, {3.509845096965584*^9, 3.5098451454756517`*^9}, {
   3.5098452252157636`*^9, 3.5098452294457693`*^9}, 3.5098452628858166`*^9, {
   3.5098452931158586`*^9, 3.5098453190758953`*^9}, {3.5101628923486614`*^9, 
   3.5101629387743425`*^9}, {3.5492160738175535`*^9, 
   3.5492161279276295`*^9}, {3.549216393738002*^9, 3.549216419358038*^9}, {
   3.5492192947996645`*^9, 3.549219324379706*^9}, {3.549219511019967*^9, 
   3.549219538730006*^9}, {3.5492196393301473`*^9, 3.549219688500216*^9}, {
   3.5492197745503364`*^9, 3.5492197974403687`*^9}, 3.5492367265808744`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Sine recurrence 3a:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.5492163850779896`*^9, 3.5492163861679907`*^9}, {
   3.5492164773381186`*^9, 3.5492164780781193`*^9}, {3.5492165738282537`*^9, 
   3.549216574638255*^9}, {3.549217395399404*^9, 3.5492173956794043`*^9}, 
   3.5492188362490225`*^9, {3.549218919039139*^9, 3.549218919509139*^9}, 
   3.5492198736404753`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"b", " ", "d", 
   RowBox[{"(", 
    RowBox[{"m", "+", "n", "+", "2"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "=", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "C"}], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     RowBox[{"n", "+", "1"}]]}], "+", "\[IndentingNewLine]", 
   RowBox[{"d", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"m", "-", "1"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "C", " ", "m"}], "+", 
        RowBox[{"b", 
         RowBox[{"(", 
          RowBox[{"A", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"A", "+", "C"}], ")"}], 
            RowBox[{"(", 
             RowBox[{"m", "+", "n", "+", "1"}], ")"}]}]}], ")"}], 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "B", 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", " ", "B"}], "-", 
              RowBox[{"a", " ", "C"}]}], ")"}], 
            RowBox[{"(", 
             RowBox[{"m", "+", "1"}], ")"}]}]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, {3.5011911220866604`*^9, 3.501191124796664*^9}, {
   3.501613889026425*^9, 3.501613959896524*^9}, {3.501633969615137*^9, 
   3.5016340146827154`*^9}, {3.5016340459675045`*^9, 3.501634132334444*^9}, {
   3.513202312159873*^9, 3.5132023348401704`*^9}, {3.5132024119775825`*^9, 
   3.5132024121975946`*^9}, {3.513202534040564*^9, 3.5132025453582115`*^9}, {
   3.51320266422901*^9, 3.5132026683982487`*^9}, 3.513204378062036*^9, {
   3.513204418605355*^9, 3.5132044382114763`*^9}, {3.513204482094986*^9, 
   3.5132044900344405`*^9}, 3.513204523495354*^9, {3.513204847503886*^9, 
   3.513204875625495*^9}, {3.5132049149997473`*^9, 3.5132049240462646`*^9}, {
   3.5132052784165335`*^9, 3.513205279369588*^9}, 3.5132055395604696`*^9, {
   3.5132064293653636`*^9, 3.5132064350826907`*^9}, {3.549217452879484*^9, 
   3.5492175858296704`*^9}, {3.549217685817412*^9, 3.5492176981174297`*^9}, 
   3.549218100517993*^9, {3.549218181408106*^9, 3.549218182318107*^9}, {
   3.5492182153881536`*^9, 3.5492182160281544`*^9}, 3.5492198798004837`*^9, {
   3.5492199888406363`*^9, 3.5492201309808354`*^9}, 3.54922078459175*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Sine recurrence 3b:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.5492163850779896`*^9, 3.5492163861679907`*^9}, {
   3.5492164773381186`*^9, 3.5492164780781193`*^9}, {3.5492165738282537`*^9, 
   3.549216574638255*^9}, {3.549217395399404*^9, 3.5492173956794043`*^9}, 
   3.5492188362490225`*^9, {3.549218919039139*^9, 3.549218919509139*^9}, 
   3.5492198736404753`*^9, {3.549220163360881*^9, 3.5492201636708813`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "d", 
   RowBox[{"(", 
    RowBox[{"m", "+", "1"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "=", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"A", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"m", "+", "1"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     RowBox[{"n", "+", "1"}]]}], "+", "\[IndentingNewLine]", 
   RowBox[{"d", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"m", "+", "1"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "B"}], "-", 
           RowBox[{"b", " ", "A"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], "-", 
        RowBox[{"b", " ", "A", " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], "+", 
        RowBox[{"a", 
         RowBox[{"(", 
          RowBox[{"A", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"A", "+", "C"}], ")"}], 
            RowBox[{"(", 
             RowBox[{"m", "+", "1"}], ")"}]}]}], ")"}], 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"b", " ", "A", 
         RowBox[{"(", 
          RowBox[{"m", "+", "n", "+", "3"}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, {3.5011911220866604`*^9, 3.501191124796664*^9}, {
   3.501613889026425*^9, 3.501613959896524*^9}, {3.501633969615137*^9, 
   3.5016340146827154`*^9}, {3.5016340459675045`*^9, 3.501634132334444*^9}, {
   3.513202312159873*^9, 3.5132023348401704`*^9}, {3.5132024119775825`*^9, 
   3.5132024121975946`*^9}, {3.513202534040564*^9, 3.5132025453582115`*^9}, {
   3.51320266422901*^9, 3.5132026683982487`*^9}, 3.513204378062036*^9, {
   3.513204418605355*^9, 3.5132044382114763`*^9}, {3.513204482094986*^9, 
   3.5132044900344405`*^9}, 3.513204523495354*^9, {3.513204847503886*^9, 
   3.513204875625495*^9}, {3.5132049149997473`*^9, 3.5132049240462646`*^9}, {
   3.5132052784165335`*^9, 3.513205279369588*^9}, 3.5132055395604696`*^9, {
   3.5132064293653636`*^9, 3.5132064350826907`*^9}, {3.549217452879484*^9, 
   3.5492175858296704`*^9}, {3.549217685817412*^9, 3.5492176981174297`*^9}, 
   3.549218100517993*^9, {3.549218181408106*^9, 3.549218182318107*^9}, {
   3.5492182153881536`*^9, 3.5492182160281544`*^9}, 3.5492198798004837`*^9, {
   3.5492199888406363`*^9, 3.5492201309808354`*^9}, {3.549220170600891*^9, 
   3.5492203110110874`*^9}, 3.5492208548518486`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Cosecant Integration Recurrence Equations", "Subtitle",
 CellChangeTimes->{{3.549223049504921*^9, 3.54922306284494*^9}, {
  3.549223137235044*^9, 3.5492231759850984`*^9}},
 TextAlignment->Center,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    StyleBox["\[Integral]",
     FontSize->18], 
    RowBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "m"],
      FontSize->18], 
     StyleBox[
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}],
      FontSize->18], 
     StyleBox[" ",
      FontSize->18], 
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"],
      FontSize->18], 
     StyleBox[
      RowBox[{"\[DifferentialD]", "x"}],
      FontSize->18], 
     StyleBox["  ",
      FontSize->18], 
     StyleBox["when",
      FontFamily->"Arial Narrow",
      FontSize->20,
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontSize->18], 
     StyleBox[
      SuperscriptBox["a", "2"],
      FontSize->18]}]}], 
   StyleBox["-",
    FontSize->18], 
   StyleBox[
    SuperscriptBox["b", "2"],
    FontSize->18]}], 
  StyleBox["\[Equal]",
   FontSize->18], 
  StyleBox["0",
   FontSize->18]}]],
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, {3.501043182982005*^9, 3.501043190019408*^9}, {
   3.502999922267273*^9, 3.5029999245372763`*^9}, 3.505344641393784*^9, {
   3.5053446930938563`*^9, 3.505344715003887*^9}, 3.5053535501052*^9, 
   3.5094714967392817`*^9, {3.5094716071916*^9, 3.509471662428759*^9}, {
   3.509471696610714*^9, 3.5094717281785192`*^9}, {3.509471786124834*^9, 
   3.509471792090175*^9}, {3.509471873836851*^9, 3.509471876436*^9}, {
   3.5095562652147536`*^9, 3.5095563252848377`*^9}, {3.50955638387492*^9, 
   3.5095564136949615`*^9}, {3.5095564499650126`*^9, 
   3.5095565745651865`*^9}, {3.509556659575306*^9, 3.5095566816053367`*^9}, {
   3.5095567320554075`*^9, 3.5095567407354193`*^9}, {3.509556895905637*^9, 
   3.5095569251456776`*^9}, {3.510172496160655*^9, 3.510172513227085*^9}, {
   3.5101727774135485`*^9, 3.5101727805647545`*^9}, {3.5101732386595592`*^9, 
   3.51017323937716*^9}, {3.510173272480418*^9, 3.510173288844847*^9}, {
   3.513278609965268*^9, 3.513278645275317*^9}, {3.513278681485368*^9, 
   3.513278702895398*^9}, 3.513278843665595*^9, {3.515187351099949*^9, 
   3.515187352819951*^9}, 3.515976581518583*^9, {3.5468187568007107`*^9, 
   3.546818756820711*^9}, {3.5468189049209185`*^9, 3.5468189421209707`*^9}, 
   3.5468192801014433`*^9, {3.5468196449319544`*^9, 3.5468196451219544`*^9}, {
   3.546819981802426*^9, 3.546819982042426*^9}, {3.546820459783095*^9, 
   3.546820459783095*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"]], "Subsubtitle",
 CellChangeTimes->{
  3.5492157676571255`*^9, {3.549215838347224*^9, 3.5492158921672993`*^9}, {
   3.549221061362138*^9, 3.5492210617021384`*^9}},
 TextAlignment->Center],

Cell[TextData[{
 "Symmetric ",
 "cosecant",
 " recurrence 1a: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.5492163850779896`*^9, 3.5492163861679907`*^9}, {
   3.549218830909015*^9, 3.549218846409037*^9}, {3.549220997182048*^9, 
   3.5492210002120523`*^9}, 3.5492211873723145`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"d", " ", "m", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], " ", "\[Equal]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"a", " ", "A", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Csc", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"m", "+", "1"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     RowBox[{"n", "-", "1"}]]}], "+", "\[IndentingNewLine]", 
   RowBox[{"d", " ", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"m", "+", "1"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", " ", "b"}], "+", 
           RowBox[{"a", " ", "B"}]}], ")"}], "m"}], "-", 
        RowBox[{"A", " ", "b", " ", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "A", " ", "n"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", " ", "A"}], "+", 
              RowBox[{"b", " ", "B"}]}], ")"}], "m"}]}], ")"}], " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "-", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, 3.5016099413762174`*^9, 3.5016100187211533`*^9, 
   3.5016103056680574`*^9, {3.501610366398964*^9, 3.5016103716405735`*^9}, 
   3.5016104208646603`*^9, 3.501791000186797*^9, 3.5017919112180724`*^9, 
   3.5053446395037813`*^9, {3.5053446874638486`*^9, 3.5053447131738844`*^9}, 
   3.5053448537940817`*^9, {3.509845096965584*^9, 3.5098451454756517`*^9}, {
   3.5098452252157636`*^9, 3.5098452294457693`*^9}, 3.5098452628858166`*^9, {
   3.5098452931158586`*^9, 3.5098453190758953`*^9}, {3.5101628923486614`*^9, 
   3.5101629387743425`*^9}, {3.5492160738175535`*^9, 
   3.5492161279276295`*^9}, {3.549216393738002*^9, 3.549216419358038*^9}, {
   3.5492210618721385`*^9, 3.5492210619221387`*^9}, {3.54922134851254*^9, 
   3.549221376222579*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Symmetric ",
 "cosecant",
 " recurrence 1b: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.549218817878997*^9, 3.5492188211590014`*^9}, 
   3.549218868949068*^9, 3.5492210063920608`*^9, 3.5492211874723144`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"d", 
   RowBox[{"(", 
    RowBox[{"m", "+", "n"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], " ", "\[Equal]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "b"}], " ", "B", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    SuperscriptBox[
     RowBox[{"Csc", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"m", "+", "1"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     RowBox[{"n", "-", "1"}]]}], "+", "\[IndentingNewLine]", 
   RowBox[{"d", " ", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "A", " ", "n"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "A"}], "+", 
           RowBox[{"b", " ", "B"}]}], ")"}], "m"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", " ", "b"}], "+", 
           RowBox[{"a", " ", "B", " ", "n"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"A", " ", "b"}], "+", 
              RowBox[{"a", " ", "B"}]}], ")"}], 
            RowBox[{"(", 
             RowBox[{"m", "+", "n", "-", "1"}], ")"}]}]}], ")"}], 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "-", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, 3.5016099413762174`*^9, 3.5016100187211533`*^9, 
   3.5016103056680574`*^9, {3.501610366398964*^9, 3.5016103716405735`*^9}, 
   3.5016104208646603`*^9, 3.501791000186797*^9, 3.5017919112180724`*^9, 
   3.5053446395037813`*^9, {3.5053446874638486`*^9, 3.5053447131738844`*^9}, 
   3.5053448537940817`*^9, {3.509845096965584*^9, 3.5098451454756517`*^9}, {
   3.5098452252157636`*^9, 3.5098452294457693`*^9}, 3.5098452628858166`*^9, {
   3.5098452931158586`*^9, 3.5098453190758953`*^9}, {3.5101628923486614`*^9, 
   3.5101629387743425`*^9}, {3.5492160738175535`*^9, 
   3.5492161279276295`*^9}, {3.5492210619221387`*^9, 3.549221061972139*^9}, {
   3.549221293502463*^9, 3.5492213227225037`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Symmetric ",
 "cosecant",
 " recurrence 2a: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.5492163850779896`*^9, 3.5492163861679907`*^9}, {
   3.5492164773381186`*^9, 3.5492164780781193`*^9}, 3.5492188331190186`*^9, {
   3.5492188867390933`*^9, 3.549218887279094*^9}, 3.5492210077420626`*^9, 
   3.5492211875723143`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["a", "2"], " ", "d", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", "n"}], "+", "1"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], " ", "\[Equal]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"a", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"A", " ", "b"}], "-", 
      RowBox[{"a", " ", "B"}]}], ")"}], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Csc", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], "+", 
   "\[IndentingNewLine]", 
   RowBox[{"d", " ", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"m", "-", "1"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"A", " ", "b"}], "-", 
            RowBox[{"a", " ", "B"}]}], ")"}]}], 
         RowBox[{"(", 
          RowBox[{"m", "-", "1"}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "B", " ", "n"}], "+", 
           RowBox[{"a", " ", "A", " ", 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", " ", "A"}], "-", 
              RowBox[{"b", " ", "B"}]}], ")"}], 
            RowBox[{"(", 
             RowBox[{"m", "-", "1"}], ")"}]}]}], ")"}], 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "+", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, 3.5016099413762174`*^9, 3.5016100187211533`*^9, 
   3.5016103056680574`*^9, {3.501610366398964*^9, 3.5016103716405735`*^9}, 
   3.5016104208646603`*^9, 3.501791000186797*^9, 3.5017919112180724`*^9, 
   3.5053446395037813`*^9, {3.5053446874638486`*^9, 3.5053447131738844`*^9}, 
   3.5053448537940817`*^9, {3.509845096965584*^9, 3.5098451454756517`*^9}, {
   3.5098452252157636`*^9, 3.5098452294457693`*^9}, 3.5098452628858166`*^9, {
   3.5098452931158586`*^9, 3.5098453190758953`*^9}, {3.5101628923486614`*^9, 
   3.5101629387743425`*^9}, {3.5492160738175535`*^9, 
   3.5492161279276295`*^9}, {3.549216393738002*^9, 3.549216419358038*^9}, {
   3.549216487628133*^9, 3.5492164965881453`*^9}, {3.5492165451082134`*^9, 
   3.549216555958229*^9}, {3.549221061972139*^9, 3.5492210620221386`*^9}, {
   3.549221557532832*^9, 3.54922157707286*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Symmetric ",
 "cosecant",
 " recurrence 2b: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.5492163850779896`*^9, 3.5492163861679907`*^9}, {
   3.5492164773381186`*^9, 3.5492164780781193`*^9}, {3.5492165738282537`*^9, 
   3.549216574638255*^9}, 3.5492188346590204`*^9, {3.5492189082691236`*^9, 
   3.5492189089591246`*^9}, 3.5492210094220653`*^9, 3.549221187682315*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["b", "2"], "d", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", "n"}], "+", "1"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], " ", "\[Equal]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "b"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"A", " ", "b"}], "-", 
      RowBox[{"a", " ", "B"}]}], ")"}], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    SuperscriptBox[
     RowBox[{"Csc", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"m", "+", "1"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], "+", 
   "\[IndentingNewLine]", 
   RowBox[{"d", " ", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "A", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "A"}], "-", 
           RowBox[{"b", " ", "B"}]}], ")"}], "m"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", " ", "b"}], "-", 
           RowBox[{"a", " ", "B"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{"m", "+", "n", "+", "1"}], ")"}], 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "+", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, 3.5016099413762174`*^9, 3.5016100187211533`*^9, 
   3.5016103056680574`*^9, {3.501610366398964*^9, 3.5016103716405735`*^9}, 
   3.5016104208646603`*^9, 3.501791000186797*^9, 3.5017919112180724`*^9, 
   3.5053446395037813`*^9, {3.5053446874638486`*^9, 3.5053447131738844`*^9}, 
   3.5053448537940817`*^9, {3.509845096965584*^9, 3.5098451454756517`*^9}, {
   3.5098452252157636`*^9, 3.5098452294457693`*^9}, 3.5098452628858166`*^9, {
   3.5098452931158586`*^9, 3.5098453190758953`*^9}, {3.5101628923486614`*^9, 
   3.5101629387743425`*^9}, {3.5492160738175535`*^9, 
   3.5492161279276295`*^9}, {3.549216393738002*^9, 3.549216419358038*^9}, {
   3.549216487628133*^9, 3.5492164965881453`*^9}, {3.5492165451082134`*^9, 
   3.549216555958229*^9}, {3.549216613308309*^9, 3.549216647008356*^9}, {
   3.549221062032139*^9, 3.549221062072139*^9}, {3.5492216253229275`*^9, 
   3.5492216300929337`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Symmetric ",
 "cosecant",
 " recurrence 3a: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.5492163850779896`*^9, 3.5492163861679907`*^9}, {
   3.5492164773381186`*^9, 3.5492164780781193`*^9}, {3.5492165738282537`*^9, 
   3.549216574638255*^9}, {3.549217395399404*^9, 3.5492173956794043`*^9}, 
   3.5492188362490225`*^9, {3.549218919039139*^9, 3.549218919509139*^9}, 
   3.549221010962067*^9, 3.549221187782315*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "d", 
   RowBox[{"(", 
    RowBox[{"m", "+", "n"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "=", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "a"}], " ", "B", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    SuperscriptBox[
     RowBox[{"Csc", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], "+", 
   "\[IndentingNewLine]", 
   RowBox[{"d", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"m", "-", "1"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "B", " ", 
         RowBox[{"(", 
          RowBox[{"m", "-", "1"}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "B", " ", "n"}], "+", 
           RowBox[{"a", " ", "A", 
            RowBox[{"(", 
             RowBox[{"m", "+", "n"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, {3.5011911220866604`*^9, 3.501191124796664*^9}, {
   3.501613889026425*^9, 3.501613959896524*^9}, {3.501633969615137*^9, 
   3.5016340146827154`*^9}, {3.5016340459675045`*^9, 3.501634132334444*^9}, {
   3.513202312159873*^9, 3.5132023348401704`*^9}, {3.5132024119775825`*^9, 
   3.5132024121975946`*^9}, {3.513202534040564*^9, 3.5132025453582115`*^9}, {
   3.51320266422901*^9, 3.5132026683982487`*^9}, 3.513204378062036*^9, {
   3.513204418605355*^9, 3.5132044382114763`*^9}, {3.513204482094986*^9, 
   3.5132044900344405`*^9}, 3.513204523495354*^9, {3.513204847503886*^9, 
   3.513204875625495*^9}, {3.5132049149997473`*^9, 3.5132049240462646`*^9}, {
   3.5132052784165335`*^9, 3.513205279369588*^9}, 3.5132055395604696`*^9, {
   3.5132064293653636`*^9, 3.5132064350826907`*^9}, {3.549217452879484*^9, 
   3.5492175858296704`*^9}, {3.549217685817412*^9, 3.5492176981174297`*^9}, 
   3.549218100517993*^9, {3.549218181408106*^9, 3.549218182318107*^9}, {
   3.5492182153881536`*^9, 3.5492182160281544`*^9}, {3.549221062082139*^9, 
   3.549221062122139*^9}, {3.549221645072955*^9, 3.5492216623829794`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Symmetric ",
 "cosecant",
 " recurrence 3b: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.5492163850779896`*^9, 3.5492163861679907`*^9}, {
   3.5492164773381186`*^9, 3.5492164780781193`*^9}, {3.5492165738282537`*^9, 
   3.549216574638255*^9}, {3.549217395399404*^9, 3.5492173956794043`*^9}, {
   3.5492174277494493`*^9, 3.54921742795945*^9}, {3.549218927829151*^9, 
   3.5492189424691715`*^9}, 3.5492210139220715`*^9, 3.549221187892315*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "d", " ", "m", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "=", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"a", " ", "A", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    SuperscriptBox[
     RowBox[{"Csc", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"m", "+", "1"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], "+", 
   "\[IndentingNewLine]", 
   RowBox[{"d", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"m", "+", "1"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "B", " ", "m"}], "-", 
        RowBox[{"b", " ", "A", " ", "n"}], "+", 
        RowBox[{"a", " ", "A", 
         RowBox[{"(", 
          RowBox[{"m", "+", "n", "+", "1"}], ")"}], 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, {3.5011911220866604`*^9, 3.501191124796664*^9}, {
   3.501613889026425*^9, 3.501613959896524*^9}, {3.501633969615137*^9, 
   3.5016340146827154`*^9}, {3.5016340459675045`*^9, 3.501634132334444*^9}, {
   3.5016343278136253`*^9, 3.501634437195882*^9}, 3.5016345097430305`*^9, 
   3.501634610292782*^9, {3.5132023129019156`*^9, 3.5132023349341755`*^9}, {
   3.513202412725625*^9, 3.5132024129406376`*^9}, {3.5132025703136387`*^9, 
   3.5132025755589385`*^9}, {3.513202679841903*^9, 3.513202683741126*^9}, 
   3.513204390453745*^9, {3.5132265746973467`*^9, 3.513226705596833*^9}, {
   3.513226777538948*^9, 3.5132267819462004`*^9}, {3.549217480369523*^9, 
   3.5492175227595825`*^9}, {3.5492175885796747`*^9, 3.5492176781974015`*^9}, 
   3.549218102267995*^9, 3.549218185088111*^9, {3.549218216558155*^9, 
   3.5492182171281557`*^9}, {3.549221062132139*^9, 3.549221062172139*^9}, {
   3.5492216669229856`*^9, 3.5492216788030024`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    StyleBox["\[Integral]",
     FontSize->18], 
    RowBox[{
     StyleBox[
      SuperscriptBox[
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "m"],
      FontSize->18], 
     StyleBox[
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"C", " ", 
         SuperscriptBox[
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}],
      FontSize->18], 
     StyleBox[" ",
      FontSize->18], 
     StyleBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"],
      FontSize->18], 
     StyleBox[
      RowBox[{"\[DifferentialD]", "x"}],
      FontSize->18], 
     StyleBox["  ",
      FontSize->18], 
     StyleBox["when",
      FontFamily->"Arial Narrow",
      FontSize->20,
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontSize->18], 
     StyleBox[
      SuperscriptBox["a", "2"],
      FontSize->18]}]}], 
   StyleBox["-",
    FontSize->18], 
   StyleBox[
    SuperscriptBox["b", "2"],
    FontSize->18]}], 
  StyleBox["\[NotEqual]",
   FontSize->18], 
  StyleBox["0",
   FontSize->18]}]],
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, {3.501043182982005*^9, 3.501043190019408*^9}, {
   3.502999922267273*^9, 3.5029999245372763`*^9}, 3.505344641393784*^9, {
   3.5053446930938563`*^9, 3.505344715003887*^9}, 3.5053535501052*^9, 
   3.5094714967392817`*^9, {3.5094716071916*^9, 3.509471662428759*^9}, {
   3.509471696610714*^9, 3.5094717281785192`*^9}, {3.509471786124834*^9, 
   3.509471792090175*^9}, {3.509471873836851*^9, 3.509471876436*^9}, {
   3.5095562652147536`*^9, 3.5095563252848377`*^9}, {3.50955638387492*^9, 
   3.5095564136949615`*^9}, {3.5095564499650126`*^9, 
   3.5095565745651865`*^9}, {3.509556659575306*^9, 3.5095566816053367`*^9}, {
   3.5095567320554075`*^9, 3.5095567407354193`*^9}, {3.509556895905637*^9, 
   3.5095569251456776`*^9}, {3.510172496160655*^9, 3.510172513227085*^9}, {
   3.5101727774135485`*^9, 3.5101727805647545`*^9}, {3.5101732386595592`*^9, 
   3.51017323937716*^9}, {3.510173272480418*^9, 3.510173288844847*^9}, {
   3.513278609965268*^9, 3.513278645275317*^9}, {3.513278681485368*^9, 
   3.513278702895398*^9}, 3.513278843665595*^9, {3.515187351099949*^9, 
   3.515187352819951*^9}, 3.515976581518583*^9, {3.5468187568007107`*^9, 
   3.546818756820711*^9}, {3.5468189049209185`*^9, 3.5468189421209707`*^9}, 
   3.5468192801014433`*^9, {3.5468196449319544`*^9, 3.5468196451219544`*^9}, {
   3.546819981802426*^9, 3.546819982042426*^9}, {3.546820459783095*^9, 
   3.546820459783095*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"]], "Subsubtitle",
 CellChangeTimes->{
  3.5492157676571255`*^9, {3.549215838347224*^9, 3.5492158921672993`*^9}, {
   3.5492191003093925`*^9, 3.5492191003093925`*^9}, {3.5492192136095514`*^9, 
   3.5492192136095514`*^9}, {3.549221062192139*^9, 3.54922106270214*^9}},
 TextAlignment->Center],

Cell["Cosecant recurrence 1a:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.5492163850779896`*^9, 3.5492163861679907`*^9}, {
   3.549218830909015*^9, 3.549218846409037*^9}, {3.5492190914793797`*^9, 
   3.549219093619383*^9}, 3.5492191583694735`*^9, 3.54922106294214*^9, 
   3.549222188403716*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"d", " ", "m", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], " ", "\[Equal]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"A", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Csc", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"m", "+", "1"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], "+", 
   "\[IndentingNewLine]", 
   RowBox[{"d", " ", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"m", "+", "1"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "B", " ", "m"}], "-", 
        RowBox[{"b", " ", "A", " ", "n"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "A"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", " ", "A"}], "+", 
              RowBox[{"a", " ", "C"}], "+", 
              RowBox[{"b", " ", "B"}]}], ")"}], " ", "m"}]}], ")"}], " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"b", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", " ", 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"A", "+", "C"}], ")"}], "m"}]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "-", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, 3.5016099413762174`*^9, 3.5016100187211533`*^9, 
   3.5016103056680574`*^9, {3.501610366398964*^9, 3.5016103716405735`*^9}, 
   3.5016104208646603`*^9, 3.501791000186797*^9, 3.5017919112180724`*^9, 
   3.5053446395037813`*^9, {3.5053446874638486`*^9, 3.5053447131738844`*^9}, 
   3.5053448537940817`*^9, {3.509845096965584*^9, 3.5098451454756517`*^9}, {
   3.5098452252157636`*^9, 3.5098452294457693`*^9}, 3.5098452628858166`*^9, {
   3.5098452931158586`*^9, 3.5098453190758953`*^9}, {3.5101628923486614`*^9, 
   3.5101629387743425`*^9}, {3.5492160738175535`*^9, 
   3.5492161279276295`*^9}, {3.549216393738002*^9, 3.549216419358038*^9}, {
   3.5492192947996645`*^9, 3.549219324379706*^9}, 3.5492196342301397`*^9, {
   3.54922106295214*^9, 3.5492210630121403`*^9}, {3.549222280783845*^9, 
   3.5492223073338823`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Cosecant recurrence 1b:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.5492163850779896`*^9, 3.5492163861679907`*^9}, {
   3.549218830909015*^9, 3.549218846409037*^9}, {3.5492190914793797`*^9, 
   3.549219093619383*^9}, 3.5492191583694735`*^9, {3.5492193545997486`*^9, 
   3.54921935556975*^9}, {3.549219604330098*^9, 3.5492196065201015`*^9}, 
   3.5492210631021404`*^9, 3.549222188503716*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"d", " ", 
   RowBox[{"(", 
    RowBox[{"m", "+", "n", "+", "1"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], " ", "\[Equal]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "C"}], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    SuperscriptBox[
     RowBox[{"Csc", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"m", "+", "1"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], "+", 
   "\[IndentingNewLine]", 
   RowBox[{"d", " ", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"A", "+", "C"}], ")"}], "m"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "A"}], "+", 
           RowBox[{"a", " ", "B"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", " ", "A"}], "+", 
              RowBox[{"a", " ", "B"}], "+", 
              RowBox[{"b", " ", "C"}]}], ")"}], 
            RowBox[{"(", 
             RowBox[{"m", "+", "n"}], ")"}]}]}], ")"}], 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "C", " ", "n"}], "+", 
           RowBox[{"b", " ", "B", " ", 
            RowBox[{"(", 
             RowBox[{"m", "+", "n", "+", "1"}], ")"}]}]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "-", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, 3.5016099413762174`*^9, 3.5016100187211533`*^9, 
   3.5016103056680574`*^9, {3.501610366398964*^9, 3.5016103716405735`*^9}, 
   3.5016104208646603`*^9, 3.501791000186797*^9, 3.5017919112180724`*^9, 
   3.5053446395037813`*^9, {3.5053446874638486`*^9, 3.5053447131738844`*^9}, 
   3.5053448537940817`*^9, {3.509845096965584*^9, 3.5098451454756517`*^9}, {
   3.5098452252157636`*^9, 3.5098452294457693`*^9}, 3.5098452628858166`*^9, {
   3.5098452931158586`*^9, 3.5098453190758953`*^9}, {3.5101628923486614`*^9, 
   3.5101629387743425`*^9}, {3.5492160738175535`*^9, 
   3.5492161279276295`*^9}, {3.549216393738002*^9, 3.549216419358038*^9}, {
   3.5492192947996645`*^9, 3.549219324379706*^9}, {3.549219511019967*^9, 
   3.549219538730006*^9}, 3.5492196365601435`*^9, {3.5492210631121407`*^9, 
   3.5492210631621404`*^9}, {3.5492223210539017`*^9, 3.549222343823933*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Cosecant recurrence 2a:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.5492163850779896`*^9, 3.5492163861679907`*^9}, {
   3.549218830909015*^9, 3.549218846409037*^9}, {3.5492190914793797`*^9, 
   3.549219093619383*^9}, 3.5492191583694735`*^9, {3.5492193545997486`*^9, 
   3.54921935556975*^9}, 3.5492210632521405`*^9, 3.549222188613716*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"b", " ", "d", " ", 
   RowBox[{"(", 
    RowBox[{"n", "+", "1"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], " ", "\[Equal]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A", " ", 
        SuperscriptBox["b", "2"]}], "-", 
       RowBox[{"a", " ", "b", " ", "B"}], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", "C"}]}], ")"}]}], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Csc", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     RowBox[{"n", "+", "1"}]]}], "+", "\[IndentingNewLine]", 
   RowBox[{"d", " ", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"m", "-", "1"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"a", " ", "b", " ", "B"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "C"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{"m", "-", "1"}], ")"}]}], "+", 
        RowBox[{"b", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "A"}], "-", 
           RowBox[{"b", " ", "B"}], "+", 
           RowBox[{"a", " ", "C"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"A", " ", 
               SuperscriptBox["b", "2"]}], "-", 
              RowBox[{"a", " ", "b", " ", "B"}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "C"}]}], ")"}], 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"A", " ", 
               SuperscriptBox["b", "2"]}], "-", 
              RowBox[{"a", " ", "b", " ", "B"}], "+", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", "C"}]}], ")"}], "m"}]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "+", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, 3.5016099413762174`*^9, 3.5016100187211533`*^9, 
   3.5016103056680574`*^9, {3.501610366398964*^9, 3.5016103716405735`*^9}, 
   3.5016104208646603`*^9, 3.501791000186797*^9, 3.5017919112180724`*^9, 
   3.5053446395037813`*^9, {3.5053446874638486`*^9, 3.5053447131738844`*^9}, 
   3.5053448537940817`*^9, {3.509845096965584*^9, 3.5098451454756517`*^9}, {
   3.5098452252157636`*^9, 3.5098452294457693`*^9}, 3.5098452628858166`*^9, {
   3.5098452931158586`*^9, 3.5098453190758953`*^9}, {3.5101628923486614`*^9, 
   3.5101629387743425`*^9}, {3.5492160738175535`*^9, 
   3.5492161279276295`*^9}, {3.549216393738002*^9, 3.549216419358038*^9}, {
   3.5492192947996645`*^9, 3.549219324379706*^9}, {3.549219511019967*^9, 
   3.549219538730006*^9}, {3.5492196393301473`*^9, 3.549219688500216*^9}, {
   3.5492210632621403`*^9, 3.5492210633221407`*^9}, {3.5492223838439894`*^9, 
   3.5492224036040173`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Cosecant recurrence 2b:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.5492163850779896`*^9, 3.5492163861679907`*^9}, {
   3.549218830909015*^9, 3.549218846409037*^9}, {3.5492190914793797`*^9, 
   3.549219093619383*^9}, 3.5492191583694735`*^9, {3.5492193545997486`*^9, 
   3.54921935556975*^9}, {3.5492197078802433`*^9, 3.5492197082902436`*^9}, 
   3.549221063412141*^9, 3.5492221887137165`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "d", " ", 
   RowBox[{"(", 
    RowBox[{"n", "+", "1"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], " ", "\[Equal]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"A", " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{"a", " ", "b", " ", "B"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "C"}]}], ")"}], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    SuperscriptBox[
     RowBox[{"Csc", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"m", "+", "1"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     RowBox[{"n", "+", "1"}]]}], "+", "\[IndentingNewLine]", 
   RowBox[{"d", " ", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"A", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"a", " ", "b", " ", "B"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "C"}]}], ")"}], "m"}], "-", 
        RowBox[{"a", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "A"}], "-", 
           RowBox[{"a", " ", "B"}], "+", 
           RowBox[{"b", " ", "C"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"a", " ", "b", " ", "B"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "C"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{"m", "+", "n", "+", "2"}], ")"}], 
         SuperscriptBox[
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "+", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, 3.5016099413762174`*^9, 3.5016100187211533`*^9, 
   3.5016103056680574`*^9, {3.501610366398964*^9, 3.5016103716405735`*^9}, 
   3.5016104208646603`*^9, 3.501791000186797*^9, 3.5017919112180724`*^9, 
   3.5053446395037813`*^9, {3.5053446874638486`*^9, 3.5053447131738844`*^9}, 
   3.5053448537940817`*^9, {3.509845096965584*^9, 3.5098451454756517`*^9}, {
   3.5098452252157636`*^9, 3.5098452294457693`*^9}, 3.5098452628858166`*^9, {
   3.5098452931158586`*^9, 3.5098453190758953`*^9}, {3.5101628923486614`*^9, 
   3.5101629387743425`*^9}, {3.5492160738175535`*^9, 
   3.5492161279276295`*^9}, {3.549216393738002*^9, 3.549216419358038*^9}, {
   3.5492192947996645`*^9, 3.549219324379706*^9}, {3.549219511019967*^9, 
   3.549219538730006*^9}, {3.5492196393301473`*^9, 3.549219688500216*^9}, {
   3.5492197745503364`*^9, 3.5492197974403687`*^9}, {3.549221063422141*^9, 
   3.5492210634821405`*^9}, {3.5492224333540587`*^9, 3.5492224396740675`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Cosecant recurrence 3a:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.5492163850779896`*^9, 3.5492163861679907`*^9}, {
   3.5492164773381186`*^9, 3.5492164780781193`*^9}, {3.5492165738282537`*^9, 
   3.549216574638255*^9}, {3.549217395399404*^9, 3.5492173956794043`*^9}, 
   3.5492188362490225`*^9, {3.549218919039139*^9, 3.549218919509139*^9}, 
   3.5492198736404753`*^9, 3.5492210635721407`*^9, 3.549222188823716*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"b", " ", "d", 
   RowBox[{"(", 
    RowBox[{"m", "+", "n", "+", "1"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "=", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "C"}], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    SuperscriptBox[
     RowBox[{"Csc", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     RowBox[{"n", "+", "1"}]]}], "+", "\[IndentingNewLine]", 
   RowBox[{"d", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"m", "-", "1"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "C", " ", 
         RowBox[{"(", 
          RowBox[{"m", "-", "1"}], ")"}]}], "+", 
        RowBox[{"b", 
         RowBox[{"(", 
          RowBox[{"A", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"A", "+", "C"}], ")"}], 
            RowBox[{"(", 
             RowBox[{"m", "+", "n"}], ")"}]}]}], ")"}], 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "B", 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", " ", "B"}], "-", 
              RowBox[{"a", " ", "C"}]}], ")"}], "m"}]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, {3.5011911220866604`*^9, 3.501191124796664*^9}, {
   3.501613889026425*^9, 3.501613959896524*^9}, {3.501633969615137*^9, 
   3.5016340146827154`*^9}, {3.5016340459675045`*^9, 3.501634132334444*^9}, {
   3.513202312159873*^9, 3.5132023348401704`*^9}, {3.5132024119775825`*^9, 
   3.5132024121975946`*^9}, {3.513202534040564*^9, 3.5132025453582115`*^9}, {
   3.51320266422901*^9, 3.5132026683982487`*^9}, 3.513204378062036*^9, {
   3.513204418605355*^9, 3.5132044382114763`*^9}, {3.513204482094986*^9, 
   3.5132044900344405`*^9}, 3.513204523495354*^9, {3.513204847503886*^9, 
   3.513204875625495*^9}, {3.5132049149997473`*^9, 3.5132049240462646`*^9}, {
   3.5132052784165335`*^9, 3.513205279369588*^9}, 3.5132055395604696`*^9, {
   3.5132064293653636`*^9, 3.5132064350826907`*^9}, {3.549217452879484*^9, 
   3.5492175858296704`*^9}, {3.549217685817412*^9, 3.5492176981174297`*^9}, 
   3.549218100517993*^9, {3.549218181408106*^9, 3.549218182318107*^9}, {
   3.5492182153881536`*^9, 3.5492182160281544`*^9}, 3.5492198798004837`*^9, {
   3.5492199888406363`*^9, 3.5492201309808354`*^9}, 3.54922078459175*^9, {
   3.549221063582141*^9, 3.5492210636421413`*^9}, {3.549222485404132*^9, 
   3.5492224998041515`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Cosecant recurrence 3b:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.5492163850779896`*^9, 3.5492163861679907`*^9}, {
   3.5492164773381186`*^9, 3.5492164780781193`*^9}, {3.5492165738282537`*^9, 
   3.549216574638255*^9}, {3.549217395399404*^9, 3.5492173956794043`*^9}, 
   3.5492188362490225`*^9, {3.549218919039139*^9, 3.549218919509139*^9}, 
   3.5492198736404753`*^9, {3.549220163360881*^9, 3.5492201636708813`*^9}, 
   3.5492210637321415`*^9, 3.5492221889237165`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "d", " ", "m", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "=", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"A", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    SuperscriptBox[
     RowBox[{"Csc", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"m", "+", "1"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     RowBox[{"n", "+", "1"}]]}], "+", "\[IndentingNewLine]", 
   RowBox[{"d", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"m", "+", "1"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "B"}], "-", 
           RowBox[{"b", " ", "A"}]}], ")"}], "m"}], "-", 
        RowBox[{"b", " ", "A", " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], "+", 
        RowBox[{"a", 
         RowBox[{"(", 
          RowBox[{"A", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"A", "+", "C"}], ")"}], "m"}]}], ")"}], 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"b", " ", "A", 
         RowBox[{"(", 
          RowBox[{"m", "+", "n", "+", "2"}], ")"}], 
         SuperscriptBox[
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, {3.5011911220866604`*^9, 3.501191124796664*^9}, {
   3.501613889026425*^9, 3.501613959896524*^9}, {3.501633969615137*^9, 
   3.5016340146827154`*^9}, {3.5016340459675045`*^9, 3.501634132334444*^9}, {
   3.513202312159873*^9, 3.5132023348401704`*^9}, {3.5132024119775825`*^9, 
   3.5132024121975946`*^9}, {3.513202534040564*^9, 3.5132025453582115`*^9}, {
   3.51320266422901*^9, 3.5132026683982487`*^9}, 3.513204378062036*^9, {
   3.513204418605355*^9, 3.5132044382114763`*^9}, {3.513204482094986*^9, 
   3.5132044900344405`*^9}, 3.513204523495354*^9, {3.513204847503886*^9, 
   3.513204875625495*^9}, {3.5132049149997473`*^9, 3.5132049240462646`*^9}, {
   3.5132052784165335`*^9, 3.513205279369588*^9}, 3.5132055395604696`*^9, {
   3.5132064293653636`*^9, 3.5132064350826907`*^9}, {3.549217452879484*^9, 
   3.5492175858296704`*^9}, {3.549217685817412*^9, 3.5492176981174297`*^9}, 
   3.549218100517993*^9, {3.549218181408106*^9, 3.549218182318107*^9}, {
   3.5492182153881536`*^9, 3.5492182160281544`*^9}, 3.5492198798004837`*^9, {
   3.5492199888406363`*^9, 3.5492201309808354`*^9}, {3.549220170600891*^9, 
   3.5492203110110874`*^9}, 3.5492208548518486`*^9, {3.5492210637321415`*^9, 
   3.549221063792141*^9}, {3.5492225058541603`*^9, 3.5492225226041837`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tangent Integration Recurrence Equations", "Subtitle",
 CellChangeTimes->{{3.549223049504921*^9, 3.54922306284494*^9}, {
   3.549223137235044*^9, 3.5492231658250837`*^9}, 3.5492235624456396`*^9},
 TextAlignment->Center,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Tan", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", " ", 
         RowBox[{"Tan", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Tan", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}], "  ", 
      StyleBox["when",
       FontFamily->"Arial Narrow",
       FontWeight->"Plain"], "  ", 
      SuperscriptBox["a", "2"]}]}], "+", 
    SuperscriptBox["b", "2"]}], "\[Equal]", "0"}],
  FontSize->18]],
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, {3.501043182982005*^9, 3.501043190019408*^9}, {
   3.502999922267273*^9, 3.5029999245372763`*^9}, 3.505344641393784*^9, {
   3.5053446930938563`*^9, 3.505344715003887*^9}, 3.5053535501052*^9, 
   3.5094714967392817`*^9, {3.5094716071916*^9, 3.509471662428759*^9}, {
   3.509471696610714*^9, 3.5094717281785192`*^9}, {3.509471786124834*^9, 
   3.509471792090175*^9}, {3.509471873836851*^9, 3.509471876436*^9}, {
   3.5095562652147536`*^9, 3.5095563252848377`*^9}, {3.50955638387492*^9, 
   3.5095564136949615`*^9}, {3.5095564499650126`*^9, 
   3.5095565745651865`*^9}, {3.509556659575306*^9, 3.5095566816053367`*^9}, {
   3.5095567320554075`*^9, 3.5095567407354193`*^9}, {3.509556895905637*^9, 
   3.5095569251456776`*^9}, {3.510172496160655*^9, 3.510172513227085*^9}, {
   3.5101727774135485`*^9, 3.5101727805647545`*^9}, {3.5101732386595592`*^9, 
   3.51017323937716*^9}, {3.510173272480418*^9, 3.510173288844847*^9}, {
   3.513278609965268*^9, 3.513278645275317*^9}, {3.513278681485368*^9, 
   3.513278702895398*^9}, 3.513278843665595*^9, {3.515187351099949*^9, 
   3.515187352819951*^9}, 3.515976581518583*^9, {3.5468187568007107`*^9, 
   3.546818756820711*^9}, {3.5468189049209185`*^9, 3.5468189421209707`*^9}, 
   3.5468192801014433`*^9, {3.5468196449319544`*^9, 3.5468196451219544`*^9}, {
   3.546819981802426*^9, 3.546819982042426*^9}, {3.546820459783095*^9, 
   3.546820459783095*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"]], "Subsubtitle",
 CellChangeTimes->{
  3.5492157676571255`*^9, {3.549215838347224*^9, 3.5492158921672993`*^9}, {
   3.549223658575774*^9, 3.549223658575774*^9}, {3.5492237324558773`*^9, 
   3.549223732795878*^9}},
 TextAlignment->Center],

Cell[TextData[{
 "Symmetric ",
 "tangent",
 " recurrence 1a (10): If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.5492163850779896`*^9, 3.5492163861679907`*^9}, {
   3.549218830909015*^9, 3.549218846409037*^9}, {3.549220997182048*^9, 
   3.5492210002120523`*^9}, 3.5492235888556767`*^9, {3.549223638135745*^9, 
   3.549223638135745*^9}, {3.5496288715998163`*^9, 3.549628873545027*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"d", " ", 
   RowBox[{"(", 
    RowBox[{"m", "+", "1"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Tan", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Tan", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], " ", 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], " \[InvisibleSpace]", 
  "\[Equal]", "\[IndentingNewLine]", "\[InvisibleSpace]", 
  RowBox[{
   RowBox[{"A", " ", "a", " ", 
    SuperscriptBox[
     RowBox[{"Tan", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"m", "+", "1"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     RowBox[{"n", "-", "1"}]]}], "-", "\[IndentingNewLine]", 
   RowBox[{"d", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Tan", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"m", "+", "1"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"A", " ", "b", " ", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", " ", "b"}], "+", 
           RowBox[{"B", " ", "a"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", " ", "a", " ", 
            RowBox[{"(", 
             RowBox[{"m", "+", "n"}], ")"}]}], "-", 
           RowBox[{"B", " ", "b", " ", 
            RowBox[{"(", 
             RowBox[{"m", "+", "1"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Tan", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "  ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Tan", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "-", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellGroupingRules->{GroupTogetherGrouping, 10006.},
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.502676353440346*^9, 
   3.50267644207047*^9}, {3.5040325316737633`*^9, 3.504032555885006*^9}, 
   3.5040712495285273`*^9, 3.5056768305258074`*^9, {3.5091340250266056`*^9, 
   3.5091340255166063`*^9}, {3.509134110686725*^9, 3.509134210656865*^9}, 
   3.5091358140991096`*^9, {3.5091363851499095`*^9, 3.5091363926999197`*^9}, {
   3.5091366480802774`*^9, 3.509136673460313*^9}, {3.509136756420429*^9, 
   3.509136781060464*^9}, {3.509136898910629*^9, 3.509136952490704*^9}, 
   3.509137023530803*^9, {3.5091371495009794`*^9, 3.509137183211027*^9}, {
   3.5091372666811438`*^9, 3.5091373023411937`*^9}, {3.509137374621295*^9, 
   3.5091373799413023`*^9}, {3.5091374289113708`*^9, 
   3.5091374307213736`*^9}, {3.509154869729108*^9, 3.5091548849591293`*^9}, {
   3.509154923779184*^9, 3.509154943939212*^9}, 3.5091550691693873`*^9, {
   3.5091550996494303`*^9, 3.5091551134994497`*^9}, {3.509155210989586*^9, 
   3.5091552779496794`*^9}, {3.509155484369969*^9, 3.5091554935699816`*^9}, {
   3.509156447241317*^9, 3.5091565172614145`*^9}, {3.509157219352398*^9, 
   3.5091572214624004`*^9}, {3.509200648372362*^9, 3.509200660899184*^9}, {
   3.5092402115853205`*^9, 3.5092402329885583`*^9}, {3.509240301316678*^9, 
   3.509240304764284*^9}, {3.509240391219636*^9, 3.5092403955564437`*^9}, 
   3.509479727927079*^9, {3.509479774026716*^9, 3.5094797761458373`*^9}, {
   3.509479865673958*^9, 3.5094799080873833`*^9}, {3.5094801431328278`*^9, 
   3.5094801751356583`*^9}, {3.5094802246834917`*^9, 
   3.5094802301888065`*^9}, {3.509480713400445*^9, 3.509480768723609*^9}, {
   3.5094808269999423`*^9, 3.5094808723875384`*^9}, {3.5094809372162466`*^9, 
   3.509480949923973*^9}, {3.51465880586613*^9, 3.5146588801362343`*^9}, {
   3.51465891322628*^9, 3.5146589462863264`*^9}, {3.514658986056382*^9, 
   3.5146589924163914`*^9}, {3.5146590248564367`*^9, 3.514659051186473*^9}, {
   3.51465918482666*^9, 3.5146592563867607`*^9}, 3.5146592919368105`*^9, {
   3.51465934869689*^9, 3.514659401466964*^9}, {3.514659463667051*^9, 
   3.5146594829870777`*^9}, {3.5146595199871297`*^9, 
   3.5146595377171545`*^9}, {3.515189456155321*^9, 3.515189459655326*^9}, {
   3.541460111365486*^9, 3.541460146652748*^9}, {3.546876825807645*^9, 
   3.5468768401576653`*^9}, {3.5474089853625393`*^9, 3.547408985392391*^9}, 
   3.548503907128989*^9, {3.5485039646829157`*^9, 3.548503969295041*^9}, {
   3.548504282251905*^9, 3.54850431718303*^9}, 3.548504374552288*^9, 
   3.5485087771049747`*^9, {3.548510973081561*^9, 3.5485110517985153`*^9}, 
   3.5485123794930563`*^9, 3.548514370799966*^9, {3.548524783666271*^9, 
   3.5485248087879457`*^9}, 3.54852601798939*^9, {3.5496313628626957`*^9, 
   3.549631369150161*^9}, {3.549631513992241*^9, 3.549631523536306*^9}, {
   3.5498204057227445`*^9, 3.549820429712778*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Symmetric ",
 "tangent",
 " recurrence 1b (9): If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.549218817878997*^9, 3.5492188211590014`*^9}, 
   3.549218868949068*^9, 3.5492210063920608`*^9, 3.549223588955676*^9, {
   3.5492236441757536`*^9, 3.5492236441757536`*^9}, {3.549628875993989*^9, 
   3.549628876970441*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"d", " ", 
   RowBox[{"(", 
    RowBox[{"m", "+", "n"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Tan", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Tan", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], " ", 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], " \[InvisibleSpace]", 
  "\[Equal]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"B", " ", "b", " ", 
    SuperscriptBox[
     RowBox[{"Tan", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"m", "+", "1"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     RowBox[{"n", "-", "1"}]]}], "+", "\[IndentingNewLine]", 
   RowBox[{"d", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Tan", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "m"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"A", " ", "a", " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "m"}], ")"}]}], "-", 
        RowBox[{"B", " ", "b", " ", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"B", " ", "a", " ", 
            RowBox[{"(", 
             RowBox[{"n", "-", "1"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"A", " ", "b"}], "+", 
              RowBox[{"B", " ", "a"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"m", "+", "n"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Tan", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "  ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Tan", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "-", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.502676353440346*^9, 
   3.50267644207047*^9}, {3.5040325316737633`*^9, 3.504032555885006*^9}, 
   3.5040712495285273`*^9, 3.5056768305258074`*^9, {3.5091340250266056`*^9, 
   3.5091340255166063`*^9}, {3.509134110686725*^9, 3.509134210656865*^9}, 
   3.5091358140991096`*^9, {3.5091363851499095`*^9, 3.5091363926999197`*^9}, {
   3.5091366480802774`*^9, 3.509136673460313*^9}, {3.509136756420429*^9, 
   3.509136781060464*^9}, {3.509136898910629*^9, 3.509136952490704*^9}, 
   3.509137023530803*^9, {3.5091371495009794`*^9, 3.509137183211027*^9}, {
   3.5091372666811438`*^9, 3.5091373023411937`*^9}, {3.509137374621295*^9, 
   3.5091373799413023`*^9}, {3.5091374289113708`*^9, 
   3.5091374307213736`*^9}, {3.509154869729108*^9, 3.5091548849591293`*^9}, {
   3.509154923779184*^9, 3.509154943939212*^9}, 3.5091550691693873`*^9, {
   3.5091550996494303`*^9, 3.5091551134994497`*^9}, {3.509155210989586*^9, 
   3.5091552779496794`*^9}, {3.509155484369969*^9, 3.5091554935699816`*^9}, {
   3.509156447241317*^9, 3.5091565172614145`*^9}, {3.509157219352398*^9, 
   3.5091572214624004`*^9}, {3.509200648372362*^9, 3.509200660899184*^9}, {
   3.5092402115853205`*^9, 3.5092402329885583`*^9}, {3.509240301316678*^9, 
   3.509240304764284*^9}, {3.509240391219636*^9, 3.5092403955564437`*^9}, 
   3.509479727927079*^9, {3.509479774026716*^9, 3.5094797761458373`*^9}, {
   3.509479865673958*^9, 3.5094799080873833`*^9}, {3.5094801431328278`*^9, 
   3.5094801751356583`*^9}, {3.5094802246834917`*^9, 
   3.5094802301888065`*^9}, {3.509480713400445*^9, 3.509480768723609*^9}, {
   3.5094808269999423`*^9, 3.5094808723875384`*^9}, {3.5094809372162466`*^9, 
   3.509480949923973*^9}, {3.51465880586613*^9, 3.5146588801362343`*^9}, {
   3.51465891322628*^9, 3.5146589462863264`*^9}, {3.514658986056382*^9, 
   3.5146589924163914`*^9}, {3.5146590248564367`*^9, 3.514659051186473*^9}, {
   3.51465918482666*^9, 3.5146592563867607`*^9}, 3.5146592919368105`*^9, {
   3.51465934869689*^9, 3.514659401466964*^9}, {3.514659463667051*^9, 
   3.5146594829870777`*^9}, {3.5146595199871297`*^9, 
   3.5146595377171545`*^9}, {3.515189456155321*^9, 3.515189459655326*^9}, {
   3.541460111365486*^9, 3.541460146652748*^9}, {3.546876825807645*^9, 
   3.5468768401576653`*^9}, {3.5474089853625393`*^9, 3.547408985392391*^9}, 
   3.548503907128989*^9, {3.5485039646829157`*^9, 3.548503969295041*^9}, {
   3.548504282251905*^9, 3.54850431718303*^9}, 3.548504374552288*^9, 
   3.5485087771049747`*^9, {3.548510973081561*^9, 3.5485110517985153`*^9}, {
   3.54852455890088*^9, 3.548524588354748*^9}, 3.548525822751001*^9, 
   3.5486095079336576`*^9, {3.5496313741033897`*^9, 3.5496313794233427`*^9}, {
   3.549631528805369*^9, 3.549631531910458*^9}, 3.5498204501528063`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Symmetric ",
 "tangent",
 " recurrence 2a (7): If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.5492163850779896`*^9, 3.5492163861679907`*^9}, {
   3.5492164773381186`*^9, 3.5492164780781193`*^9}, 3.5492188331190186`*^9, {
   3.5492188867390933`*^9, 3.549218887279094*^9}, 3.5492210077420626`*^9, 
   3.5492235890556765`*^9, {3.5492236457957563`*^9, 3.5492236457957563`*^9}, {
   3.549629692368951*^9, 3.549629693924914*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SuperscriptBox["a", "2"], " ", "n", " ", "d", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Tan", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Tan", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], " ", 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], " \[InvisibleSpace]", 
  "\[Equal]", "\[IndentingNewLine]", "\[InvisibleSpace]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "a"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"A", " ", "b"}], "-", 
      RowBox[{"B", " ", "a"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Tan", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], "+", 
   "\[IndentingNewLine]", 
   RowBox[{"d", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Tan", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"m", "-", "1"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", " ", "b"}], "-", 
           RowBox[{"B", " ", "a"}]}], ")"}], " ", "m"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"B", " ", "b", " ", 
            RowBox[{"(", 
             RowBox[{"m", "-", "n"}], ")"}]}], "+", 
           RowBox[{"A", " ", "a", " ", 
            RowBox[{"(", 
             RowBox[{"m", "+", "n"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Tan", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "  ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Tan", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "+", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellGroupingRules->{GroupTogetherGrouping, 10005.},
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.502676353440346*^9, 
   3.50267644207047*^9}, {3.5040325316737633`*^9, 3.504032555885006*^9}, 
   3.5040712495285273`*^9, 3.5056768305258074`*^9, {3.5091340250266056`*^9, 
   3.5091340255166063`*^9}, {3.509134110686725*^9, 3.509134210656865*^9}, 
   3.5091358140991096`*^9, {3.5091363851499095`*^9, 3.5091363926999197`*^9}, {
   3.5091366480802774`*^9, 3.509136673460313*^9}, {3.509136756420429*^9, 
   3.509136781060464*^9}, {3.509136898910629*^9, 3.509136952490704*^9}, 
   3.509137023530803*^9, {3.5091371495009794`*^9, 3.509137183211027*^9}, {
   3.5091372666811438`*^9, 3.5091373023411937`*^9}, {3.509137374621295*^9, 
   3.5091373799413023`*^9}, {3.5091374289113708`*^9, 
   3.5091374307213736`*^9}, {3.509154869729108*^9, 3.5091548849591293`*^9}, {
   3.509154923779184*^9, 3.509154943939212*^9}, 3.5091550691693873`*^9, {
   3.5091550996494303`*^9, 3.5091551134994497`*^9}, {3.509155210989586*^9, 
   3.5091552779496794`*^9}, {3.509155484369969*^9, 3.5091554935699816`*^9}, {
   3.509156447241317*^9, 3.5091565172614145`*^9}, {3.509157219352398*^9, 
   3.5091572214624004`*^9}, {3.509200648372362*^9, 3.509200660899184*^9}, {
   3.5092402115853205`*^9, 3.5092402329885583`*^9}, {3.509240301316678*^9, 
   3.509240304764284*^9}, {3.509240391219636*^9, 3.5092403955564437`*^9}, 
   3.509479727927079*^9, {3.509479774026716*^9, 3.5094797761458373`*^9}, {
   3.509479865673958*^9, 3.5094799080873833`*^9}, {3.5094801431328278`*^9, 
   3.5094801751356583`*^9}, {3.5094802246834917`*^9, 
   3.5094802301888065`*^9}, {3.509480713400445*^9, 3.509480768723609*^9}, {
   3.5094808269999423`*^9, 3.5094808723875384`*^9}, {3.5094809372162466`*^9, 
   3.509480949923973*^9}, {3.51465880586613*^9, 3.5146588801362343`*^9}, {
   3.51465891322628*^9, 3.5146589462863264`*^9}, {3.514658986056382*^9, 
   3.5146589924163914`*^9}, {3.5146590248564367`*^9, 3.514659051186473*^9}, {
   3.51465918482666*^9, 3.5146592563867607`*^9}, 3.5146592919368105`*^9, {
   3.51465934869689*^9, 3.514659401466964*^9}, {3.514659463667051*^9, 
   3.5146594829870777`*^9}, {3.5146595199871297`*^9, 
   3.5146595377171545`*^9}, {3.515189456155321*^9, 3.515189459655326*^9}, {
   3.541460111365486*^9, 3.541460146652748*^9}, {3.546876825807645*^9, 
   3.5468768401576653`*^9}, {3.5474089853625393`*^9, 3.547408985392391*^9}, 
   3.548503907128989*^9, {3.5485039646829157`*^9, 3.548503969295041*^9}, {
   3.548504282251905*^9, 3.54850431718303*^9}, 3.548504374552288*^9, 
   3.5485087771049747`*^9, {3.548510973081561*^9, 3.5485110517985153`*^9}, 
   3.5485123869545183`*^9, 3.548514018039383*^9, {3.548514749073345*^9, 
   3.5485147602577057`*^9}, {3.548524730494541*^9, 3.548524760887985*^9}, 
   3.548526002127614*^9, {3.5496313928062353`*^9, 3.549631414965736*^9}, {
   3.54963153596292*^9, 3.549631538661214*^9}, 3.5498204508528075`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Symmetric ",
 "tangent",
 " recurrence 2b (12): If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.5492163850779896`*^9, 3.5492163861679907`*^9}, {
   3.5492164773381186`*^9, 3.5492164780781193`*^9}, {3.5492165738282537`*^9, 
   3.549216574638255*^9}, 3.5492188346590204`*^9, {3.5492189082691236`*^9, 
   3.5492189089591246`*^9}, 3.5492210094220653`*^9, 3.549223589155677*^9, {
   3.549223647695759*^9, 3.549223647695759*^9}, {3.5496297324543867`*^9, 
   3.549629733744392*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SuperscriptBox["a", "2"], " ", "n", " ", "d", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Tan", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Tan", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], " ", 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], " \[InvisibleSpace]", 
  "\[Equal]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "a"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", "A"}], "+", 
      RowBox[{"b", " ", "B"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Tan", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"1", "+", "m"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], " ", "+", " ", 
   "\[IndentingNewLine]", 
   RowBox[{"d", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Tan", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", " ", "B", " ", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], "+", 
        RowBox[{"a", " ", "A", " ", 
         RowBox[{"(", 
          RowBox[{"m", "+", 
           RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", " ", "b"}], "-", 
           RowBox[{"a", " ", "B"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"m", "+", "n", "+", "1"}], ")"}], " ", 
         RowBox[{"Tan", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "  ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Tan", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "+", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.502676353440346*^9, 
   3.50267644207047*^9}, {3.5040325316737633`*^9, 3.504032555885006*^9}, 
   3.5040712495285273`*^9, 3.5056768305258074`*^9, {3.5091340250266056`*^9, 
   3.5091340255166063`*^9}, {3.509134110686725*^9, 3.509134210656865*^9}, 
   3.5091358140991096`*^9, {3.5091363851499095`*^9, 3.5091363926999197`*^9}, {
   3.5091366480802774`*^9, 3.509136673460313*^9}, {3.509136756420429*^9, 
   3.509136781060464*^9}, {3.509136898910629*^9, 3.509136952490704*^9}, 
   3.509137023530803*^9, {3.5091371495009794`*^9, 3.509137183211027*^9}, {
   3.5091372666811438`*^9, 3.5091373023411937`*^9}, {3.509137374621295*^9, 
   3.5091373799413023`*^9}, {3.5091374289113708`*^9, 
   3.5091374307213736`*^9}, {3.509154869729108*^9, 3.5091548849591293`*^9}, {
   3.509154923779184*^9, 3.509154943939212*^9}, 3.5091550691693873`*^9, {
   3.5091550996494303`*^9, 3.5091551134994497`*^9}, {3.509155210989586*^9, 
   3.5091552779496794`*^9}, {3.509155484369969*^9, 3.5091554935699816`*^9}, {
   3.509156447241317*^9, 3.5091565172614145`*^9}, {3.509157219352398*^9, 
   3.5091572214624004`*^9}, {3.509200648372362*^9, 3.509200660899184*^9}, {
   3.5092402115853205`*^9, 3.5092402329885583`*^9}, {3.509240301316678*^9, 
   3.509240304764284*^9}, {3.509240391219636*^9, 3.5092403955564437`*^9}, 
   3.509479727927079*^9, {3.509479774026716*^9, 3.5094797761458373`*^9}, {
   3.509479865673958*^9, 3.5094799080873833`*^9}, {3.5094801431328278`*^9, 
   3.5094801751356583`*^9}, {3.5094802246834917`*^9, 
   3.5094802301888065`*^9}, {3.509480713400445*^9, 3.509480768723609*^9}, {
   3.5094808269999423`*^9, 3.5094808723875384`*^9}, {3.5094809372162466`*^9, 
   3.509480949923973*^9}, {3.51465880586613*^9, 3.5146588801362343`*^9}, {
   3.51465891322628*^9, 3.5146589462863264`*^9}, {3.514658986056382*^9, 
   3.5146589924163914`*^9}, {3.5146590248564367`*^9, 3.514659051186473*^9}, {
   3.51465918482666*^9, 3.5146592563867607`*^9}, 3.5146592919368105`*^9, {
   3.51465934869689*^9, 3.514659401466964*^9}, {3.514659463667051*^9, 
   3.5146594829870777`*^9}, {3.5146595199871297`*^9, 
   3.5146595377171545`*^9}, {3.515189456155321*^9, 3.515189459655326*^9}, {
   3.541460111365486*^9, 3.541460146652748*^9}, {3.546876825807645*^9, 
   3.5468768401576653`*^9}, {3.5474089853625393`*^9, 3.547408985392391*^9}, 
   3.548503907128989*^9, {3.5485039646829157`*^9, 3.548503969295041*^9}, {
   3.548504282251905*^9, 3.54850431718303*^9}, 3.5485043642450657`*^9, {
   3.54850472727899*^9, 3.54850472797571*^9}, {3.548504852638956*^9, 
   3.548504862553673*^9}, {3.548504991691712*^9, 3.548505006593314*^9}, {
   3.5485050696897182`*^9, 3.548505281441658*^9}, {3.5485076277877817`*^9, 
   3.5485076355550547`*^9}, {3.548510549224729*^9, 3.5485105527786903`*^9}, {
   3.5485236019653883`*^9, 3.548523657919323*^9}, 3.548525698751935*^9, 
   3.548608728783949*^9, {3.548608814409294*^9, 3.5486089321104918`*^9}, 
   3.5486119485595217`*^9, 3.548612006900948*^9, {3.549631434559394*^9, 
   3.5496314628081493`*^9}, {3.549631543227344*^9, 3.5496315489421453`*^9}, 
   3.549820491932865*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Symmetric ",
 "tangent",
 " recurrence 3a (8): If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.5492163850779896`*^9, 3.5492163861679907`*^9}, {
   3.5492164773381186`*^9, 3.5492164780781193`*^9}, {3.5492165738282537`*^9, 
   3.549216574638255*^9}, {3.549217395399404*^9, 3.5492173956794043`*^9}, 
   3.5492188362490225`*^9, {3.549218919039139*^9, 3.549218919509139*^9}, 
   3.549221010962067*^9, 3.549223589265677*^9, {3.549223649525761*^9, 
   3.549223649525761*^9}, {3.549629781894103*^9, 3.549629783124713*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "d", " ", 
   RowBox[{"(", 
    RowBox[{"m", "+", "n"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Tan", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Tan", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], " ", 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], " \[InvisibleSpace]", 
  "\[Equal]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"a", " \[InvisibleSpace]", "B", " ", 
    SuperscriptBox[
     RowBox[{"Tan", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], "+", 
   "\[IndentingNewLine]", 
   RowBox[{"d", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Tan", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"m", "-", "1"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"B", " ", "a", " ", "m"}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", " ", "a", " ", "m"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"A", " ", "a"}], "-", 
              RowBox[{"B", " ", "b"}]}], ")"}], " ", "n"}]}], ")"}], " ", 
         RowBox[{"Tan", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "  ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Tan", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellGroupingRules->{GroupTogetherGrouping, 10004.},
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.502676353440346*^9, 
   3.50267644207047*^9}, {3.5040325316737633`*^9, 3.504032555885006*^9}, 
   3.5040712495285273`*^9, 3.5056768305258074`*^9, {3.5091340250266056`*^9, 
   3.5091340255166063`*^9}, {3.509134110686725*^9, 3.509134210656865*^9}, 
   3.5091358140991096`*^9, {3.5091363851499095`*^9, 3.5091363926999197`*^9}, {
   3.5091366480802774`*^9, 3.509136673460313*^9}, {3.509136756420429*^9, 
   3.509136781060464*^9}, {3.509136898910629*^9, 3.509136952490704*^9}, 
   3.509137023530803*^9, {3.5091371495009794`*^9, 3.509137183211027*^9}, {
   3.5091372666811438`*^9, 3.5091373023411937`*^9}, {3.509137374621295*^9, 
   3.5091373799413023`*^9}, {3.5091374289113708`*^9, 
   3.5091374307213736`*^9}, {3.509154869729108*^9, 3.5091548849591293`*^9}, {
   3.509154923779184*^9, 3.509154943939212*^9}, 3.5091550691693873`*^9, {
   3.5091550996494303`*^9, 3.5091551134994497`*^9}, {3.509155210989586*^9, 
   3.5091552779496794`*^9}, {3.509155484369969*^9, 3.5091554935699816`*^9}, {
   3.509156447241317*^9, 3.5091565172614145`*^9}, {3.509157219352398*^9, 
   3.5091572214624004`*^9}, {3.509200648372362*^9, 3.509200660899184*^9}, {
   3.5092402115853205`*^9, 3.5092402329885583`*^9}, {3.509240301316678*^9, 
   3.509240304764284*^9}, {3.509240391219636*^9, 3.5092403955564437`*^9}, 
   3.509479727927079*^9, {3.509479774026716*^9, 3.5094797761458373`*^9}, {
   3.509479865673958*^9, 3.5094799080873833`*^9}, {3.5094801431328278`*^9, 
   3.5094801751356583`*^9}, {3.5094802246834917`*^9, 
   3.5094802301888065`*^9}, {3.509480713400445*^9, 3.509480768723609*^9}, {
   3.5094808269999423`*^9, 3.5094808723875384`*^9}, {3.5094809372162466`*^9, 
   3.509480949923973*^9}, {3.51465880586613*^9, 3.5146588801362343`*^9}, {
   3.51465891322628*^9, 3.5146589462863264`*^9}, {3.514658986056382*^9, 
   3.5146589924163914`*^9}, {3.5146590248564367`*^9, 3.514659051186473*^9}, {
   3.51465918482666*^9, 3.5146592563867607`*^9}, 3.5146592919368105`*^9, {
   3.51465934869689*^9, 3.514659401466964*^9}, {3.514659463667051*^9, 
   3.5146594829870777`*^9}, {3.5146595199871297`*^9, 
   3.5146595377171545`*^9}, {3.515189456155321*^9, 3.515189459655326*^9}, {
   3.541460111365486*^9, 3.541460146652748*^9}, {3.546876825807645*^9, 
   3.5468768401576653`*^9}, {3.5474089853625393`*^9, 3.547408985392391*^9}, 
   3.548503907128989*^9, {3.5485039646829157`*^9, 3.548503969295041*^9}, {
   3.548504282251905*^9, 3.54850431718303*^9}, 3.548504374552288*^9, 
   3.5485087771049747`*^9, {3.548510973081561*^9, 3.5485110517985153`*^9}, 
   3.548512396266761*^9, 3.548513485675385*^9, {3.5485202368897743`*^9, 
   3.5485202370411453`*^9}, {3.5485246840828648`*^9, 3.548524707299864*^9}, {
   3.5490366711350803`*^9, 3.549036673430152*^9}, {3.5496314683914537`*^9, 
   3.549631489849024*^9}, {3.549631553191831*^9, 3.549631555605074*^9}, 
   3.5498204955928698`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Symmetric tangent recurrence 3b (11): If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.5492163850779896`*^9, 3.5492163861679907`*^9}, {
   3.5492164773381186`*^9, 3.5492164780781193`*^9}, {3.5492165738282537`*^9, 
   3.549216574638255*^9}, {3.549217395399404*^9, 3.5492173956794043`*^9}, {
   3.5492174277494493`*^9, 3.54921742795945*^9}, {3.549218927829151*^9, 
   3.5492189424691715`*^9}, 3.5492210139220715`*^9, 3.549223589365677*^9, {
   3.549223651255764*^9, 3.549223651255764*^9}, {3.549628911982482*^9, 
   3.5496289129770527`*^9}, {3.549629839317285*^9, 3.549629840537054*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "d", " ", 
   RowBox[{"(", 
    RowBox[{"m", "+", "1"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Tan", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Tan", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], " ", 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], " \[InvisibleSpace]", 
  "\[Equal]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"a", " \[InvisibleSpace]", "A", " ", 
    SuperscriptBox[
     RowBox[{"Tan", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"m", "+", "1"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], "-", 
   "\[IndentingNewLine]", 
   RowBox[{"d", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Tan", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"m", "+", "1"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"A", " ", "b", " ", "n"}], "-", 
        RowBox[{"B", " ", "a", " ", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], "+", 
        RowBox[{"A", " ", "a", " ", 
         RowBox[{"(", 
          RowBox[{"m", "+", "n", "+", "1"}], ")"}], " ", 
         RowBox[{"Tan", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "  ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Tan", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.502676353440346*^9, 
   3.50267644207047*^9}, {3.5040325316737633`*^9, 3.504032555885006*^9}, 
   3.5040712495285273`*^9, 3.5056768305258074`*^9, {3.5091340250266056`*^9, 
   3.5091340255166063`*^9}, {3.509134110686725*^9, 3.509134210656865*^9}, 
   3.5091358140991096`*^9, {3.5091363851499095`*^9, 3.5091363926999197`*^9}, {
   3.5091366480802774`*^9, 3.509136673460313*^9}, {3.509136756420429*^9, 
   3.509136781060464*^9}, {3.509136898910629*^9, 3.509136952490704*^9}, 
   3.509137023530803*^9, {3.5091371495009794`*^9, 3.509137183211027*^9}, {
   3.5091372666811438`*^9, 3.5091373023411937`*^9}, {3.509137374621295*^9, 
   3.5091373799413023`*^9}, {3.5091374289113708`*^9, 
   3.5091374307213736`*^9}, {3.509154869729108*^9, 3.5091548849591293`*^9}, {
   3.509154923779184*^9, 3.509154943939212*^9}, 3.5091550691693873`*^9, {
   3.5091550996494303`*^9, 3.5091551134994497`*^9}, {3.509155210989586*^9, 
   3.5091552779496794`*^9}, {3.509155484369969*^9, 3.5091554935699816`*^9}, {
   3.509156447241317*^9, 3.5091565172614145`*^9}, {3.509157219352398*^9, 
   3.5091572214624004`*^9}, {3.509200648372362*^9, 3.509200660899184*^9}, {
   3.5092402115853205`*^9, 3.5092402329885583`*^9}, {3.509240301316678*^9, 
   3.509240304764284*^9}, {3.509240391219636*^9, 3.5092403955564437`*^9}, 
   3.509479727927079*^9, {3.509479774026716*^9, 3.5094797761458373`*^9}, {
   3.509479865673958*^9, 3.5094799080873833`*^9}, {3.5094801431328278`*^9, 
   3.5094801751356583`*^9}, {3.5094802246834917`*^9, 
   3.5094802301888065`*^9}, {3.509480713400445*^9, 3.509480768723609*^9}, {
   3.5094808269999423`*^9, 3.5094808723875384`*^9}, {3.5094809372162466`*^9, 
   3.509480949923973*^9}, {3.51465880586613*^9, 3.5146588801362343`*^9}, {
   3.51465891322628*^9, 3.5146589462863264`*^9}, {3.514658986056382*^9, 
   3.5146589924163914`*^9}, {3.5146590248564367`*^9, 3.514659051186473*^9}, {
   3.51465918482666*^9, 3.5146592563867607`*^9}, 3.5146592919368105`*^9, {
   3.51465934869689*^9, 3.514659401466964*^9}, {3.514659463667051*^9, 
   3.5146594829870777`*^9}, {3.5146595199871297`*^9, 
   3.5146595377171545`*^9}, {3.515189456155321*^9, 3.515189459655326*^9}, {
   3.541460111365486*^9, 3.541460146652748*^9}, {3.546876825807645*^9, 
   3.5468768401576653`*^9}, {3.5474089853625393`*^9, 3.547408985392391*^9}, 
   3.548503907128989*^9, {3.5485039646829157`*^9, 3.548503969295041*^9}, {
   3.548504282251905*^9, 3.54850431718303*^9}, 3.548504374552288*^9, 
   3.5485087771049747`*^9, {3.548510973081561*^9, 3.5485110517985153`*^9}, 
   3.5485124024973593`*^9, 3.548513365020659*^9, {3.548524612709609*^9, 
   3.548524636524725*^9}, 3.5485259924080353`*^9, {3.549631498382663*^9, 
   3.549631506933264*^9}, {3.549631559780897*^9, 3.5496315639534693`*^9}, 
   3.5498204514528084`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Tan", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
      RowBox[{
       StyleBox["(",
        FontSize->18], 
       RowBox[{
        StyleBox["A",
         FontSize->18], 
        StyleBox["+",
         FontSize->18], 
        StyleBox[
         RowBox[{"B", " ", 
          RowBox[{"Tan", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}],
         FontSize->18], 
        StyleBox["+",
         FontSize->18], 
        RowBox[{
         StyleBox["C",
          FontSize->18], 
         StyleBox[" ",
          FontSize->18], 
         SuperscriptBox[
          RowBox[{
           StyleBox["Tan",
            FontSize->18], "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], 
       StyleBox[")",
        FontSize->18]}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Tan", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}], "  ", 
      StyleBox["when",
       FontFamily->"Arial Narrow",
       FontWeight->"Plain"], "  ", 
      SuperscriptBox["a", "2"]}]}], "+", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}],
  FontSize->18]],
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, {3.501043182982005*^9, 3.501043190019408*^9}, {
   3.502999922267273*^9, 3.5029999245372763`*^9}, 3.505344641393784*^9, {
   3.5053446930938563`*^9, 3.505344715003887*^9}, 3.5053535501052*^9, 
   3.5094714967392817`*^9, {3.5094716071916*^9, 3.509471662428759*^9}, {
   3.509471696610714*^9, 3.5094717281785192`*^9}, {3.509471786124834*^9, 
   3.509471792090175*^9}, {3.509471873836851*^9, 3.509471876436*^9}, {
   3.5095562652147536`*^9, 3.5095563252848377`*^9}, {3.50955638387492*^9, 
   3.5095564136949615`*^9}, {3.5095564499650126`*^9, 
   3.5095565745651865`*^9}, {3.509556659575306*^9, 3.5095566816053367`*^9}, {
   3.5095567320554075`*^9, 3.5095567407354193`*^9}, {3.509556895905637*^9, 
   3.5095569251456776`*^9}, {3.510172496160655*^9, 3.510172513227085*^9}, {
   3.5101727774135485`*^9, 3.5101727805647545`*^9}, {3.5101732386595592`*^9, 
   3.51017323937716*^9}, {3.510173272480418*^9, 3.510173288844847*^9}, {
   3.513278609965268*^9, 3.513278645275317*^9}, {3.513278681485368*^9, 
   3.513278702895398*^9}, 3.513278843665595*^9, {3.515187351099949*^9, 
   3.515187352819951*^9}, 3.515976581518583*^9, {3.5468187568007107`*^9, 
   3.546818756820711*^9}, {3.5468189049209185`*^9, 3.5468189421209707`*^9}, 
   3.5468192801014433`*^9, {3.5468196449319544`*^9, 3.5468196451219544`*^9}, {
   3.546819981802426*^9, 3.546819982042426*^9}, {3.546820459783095*^9, 
   3.546820459783095*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"]], "Subsubtitle",
 CellChangeTimes->{
  3.5492157676571255`*^9, {3.549215838347224*^9, 3.5492158921672993`*^9}, {
   3.5492191003093925`*^9, 3.5492191003093925`*^9}, {3.5492192136095514`*^9, 
   3.5492192136095514`*^9}, {3.549223664955783*^9, 3.549223664955783*^9}, {
   3.5492237329758782`*^9, 3.549223733485879*^9}},
 TextAlignment->Center],

Cell["Tangent recurrence 1a:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.5492163850779896`*^9, 3.5492163861679907`*^9}, {
   3.549218830909015*^9, 3.549218846409037*^9}, {3.5492190914793797`*^9, 
   3.549219093619383*^9}, 3.5492191583694735`*^9, 3.5492235625556393`*^9, 
   3.549223608515704*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"d", 
   RowBox[{"(", 
    RowBox[{"m", "+", "1"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Tan", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Tan", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Tan", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "\[Equal]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"A", " ", 
    SuperscriptBox[
     RowBox[{"Tan", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"m", "+", "1"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], "+", 
   "\[IndentingNewLine]", 
   RowBox[{"d", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Tan", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"m", "+", "1"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "B", " ", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], "-", 
        RowBox[{"A", " ", "b", " ", "n"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "B"}], "-", 
           RowBox[{"a", " ", 
            RowBox[{"(", 
             RowBox[{"A", "-", "C"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], " ", 
         RowBox[{"Tan", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"C", " ", 
            RowBox[{"(", 
             RowBox[{"m", "+", "1"}], ")"}]}], "-", 
           RowBox[{"A", " ", 
            RowBox[{"(", 
             RowBox[{"m", "+", "n", "+", "1"}], ")"}]}]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Tan", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Tan", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "-", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, 3.5016099413762174`*^9, 3.5016100187211533`*^9, 
   3.5016103580217495`*^9, 3.5016104320186796`*^9, 3.5017895493447657`*^9, 
   3.501791918958083*^9, 3.5053446394937816`*^9, {3.5053446874238486`*^9, 
   3.5053447131638846`*^9}, 3.5053448486840744`*^9, {3.519400257643668*^9, 
   3.5194002577060585`*^9}, {3.519406667000137*^9, 3.5194066680453386`*^9}, {
   3.519406756091893*^9, 3.51940677145792*^9}, {3.5194068467748528`*^9, 
   3.5194069133869696`*^9}, {3.5194070164251504`*^9, 
   3.5194070226027613`*^9}, {3.519435346800065*^9, 3.5194353489684687`*^9}, {
   3.519436165099502*^9, 3.5194361672991056`*^9}, {3.519436219668398*^9, 
   3.5194362217744017`*^9}, {3.5200962835256567`*^9, 3.520096302276889*^9}, 
   3.549211670073491*^9, {3.5492239046361184`*^9, 3.5492239182461376`*^9}, {
   3.5492239582161937`*^9, 3.549223962396199*^9}, {3.5492259962610483`*^9, 
   3.5492259979610505`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Tangent recurrence 1b:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.5492163850779896`*^9, 3.5492163861679907`*^9}, {
   3.549218830909015*^9, 3.549218846409037*^9}, {3.5492190914793797`*^9, 
   3.549219093619383*^9}, 3.5492191583694735`*^9, {3.5492193545997486`*^9, 
   3.54921935556975*^9}, {3.549219604330098*^9, 3.5492196065201015`*^9}, 
   3.5492235626456394`*^9, 3.549223617735717*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"d", 
   RowBox[{"(", 
    RowBox[{"m", "+", "n", "+", "1"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Tan", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Tan", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Tan", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "\[Equal]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"C", " ", 
    SuperscriptBox[
     RowBox[{"Tan", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"m", "+", "1"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], "+", 
   "\[IndentingNewLine]", 
   RowBox[{"d", " ", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Tan", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "m"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"A", " ", "a", 
           RowBox[{"(", 
            RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], "-", 
          RowBox[{"C", " ", 
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}], "a"}]}], ")"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "B"}], "+", 
           RowBox[{"b", " ", 
            RowBox[{"(", 
             RowBox[{"A", "-", "C"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"m", "+", "n", "+", "1"}], ")"}], 
         RowBox[{"Tan", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "C", " ", "n"}], "+", 
           RowBox[{"b", " ", "B", " ", 
            RowBox[{"(", 
             RowBox[{"m", "+", "n", "+", "1"}], ")"}]}]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Tan", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Tan", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "-", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, {3.501043182982005*^9, 3.501043190019408*^9}, {
   3.501698259718356*^9, 3.501698301628415*^9}, 3.5016984584686346`*^9, 
   3.5017919697981544`*^9, 3.505344639523782*^9, {3.5053446876138487`*^9, 
   3.505344713203885*^9}, 3.5053448658540983`*^9, {3.5194002575656805`*^9, 
   3.519400257628071*^9}, {3.519400963949789*^9, 3.519400966492198*^9}, {
   3.5194011662662587`*^9, 3.519401168824265*^9}, {3.519401213948122*^9, 
   3.5194012250848083`*^9}, {3.5194012608657026`*^9, 3.519401292279269*^9}, {
   3.5194013615840616`*^9, 3.5194013654058657`*^9}, {3.5194014066657495`*^9, 
   3.519401431281287*^9}, 3.5194014779852924`*^9, {3.519401535452745*^9, 
   3.519401537153058*^9}, {3.5194061216075788`*^9, 3.519406123885183*^9}, 
   3.5194346439596305`*^9, {3.520096164934248*^9, 3.5200961864154854`*^9}, {
   3.520096264041222*^9, 3.5200962727928376`*^9}, 3.5492116728416495`*^9, {
   3.5492239045361185`*^9, 3.549223918216138*^9}, {3.549223949986182*^9, 
   3.549223953436187*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Tangent recurrence 2a:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.5492163850779896`*^9, 3.5492163861679907`*^9}, {
   3.549218830909015*^9, 3.549218846409037*^9}, {3.5492190914793797`*^9, 
   3.549219093619383*^9}, 3.5492191583694735`*^9, {3.5492193545997486`*^9, 
   3.54921935556975*^9}, 3.5492235627356396`*^9, 3.549223619055719*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"b", " ", "d", 
   RowBox[{"(", 
    RowBox[{"n", "+", "1"}], ")"}], 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Tan", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Tan", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Tan", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], " ", "\[Equal]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"A", " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{"a", " ", "b", " ", "B"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "C"}]}], ")"}], 
    SuperscriptBox[
     RowBox[{"Tan", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     RowBox[{"n", "+", "1"}]]}], "+", "\[IndentingNewLine]", 
   RowBox[{"d", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Tan", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"m", "-", "1"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["b", "2"]}], "-", 
            RowBox[{"a", " ", "b", " ", "B"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "C"}]}], ")"}]}], " ", "m"}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "B"}], "+", 
           RowBox[{"a", " ", 
            RowBox[{"(", 
             RowBox[{"A", "-", "C"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], " ", 
         RowBox[{"Tan", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          StyleBox[
           RowBox[{
            RowBox[{"b", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", " ", "b"}], "-", 
               RowBox[{"a", " ", "B"}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], "-", 
            RowBox[{"C", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["a", "2"]}], " ", "m"}], "+", 
               RowBox[{
                SuperscriptBox["b", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}]}]}],
           FontColor->GrayLevel[0]], 
          StyleBox[")",
           FontColor->GrayLevel[0]]}], 
         SuperscriptBox[
          RowBox[{"Tan", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], 
       StyleBox[")",
        FontColor->GrayLevel[0]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Tan", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "+", "1"}]], 
      StyleBox[
       RowBox[{"\[DifferentialD]", "x"}],
       FontColor->GrayLevel[0]]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, 3.5016099413762174`*^9, 3.5016100187211533`*^9, 
   3.5016103056680574`*^9, {3.501610366398964*^9, 3.5016103716405735`*^9}, 
   3.5016104208646603`*^9, 3.501791000186797*^9, 3.5017919112180724`*^9, 
   3.5053446395037813`*^9, {3.5053446874638486`*^9, 3.5053447131738844`*^9}, 
   3.5053448537940817`*^9, {3.5193988278340607`*^9, 3.519398829456211*^9}, {
   3.5193989379063234`*^9, 3.5193989538470707`*^9}, {3.5193990181559753`*^9, 
   3.519399036529948*^9}, {3.519399159891367*^9, 3.5193991665671396`*^9}, {
   3.5193992336680145`*^9, 3.5193992558322043`*^9}, {3.5193993105173903`*^9, 
   3.519399319969536*^9}, {3.5193999643335876`*^9, 3.5193999950296645`*^9}, {
   3.519400159553149*^9, 3.5194001957083864`*^9}, {3.519400246740946*^9, 
   3.519400257253728*^9}, {3.5194005442027755`*^9, 3.5194005466204033`*^9}, 
   3.519400617293129*^9, {3.5194007481881886`*^9, 3.519400751775636*^9}, 
   3.519400788445594*^9, {3.519435959974742*^9, 3.519435973967966*^9}, {
   3.520096154154629*^9, 3.5200961613306417`*^9}, {3.520096222248749*^9, 
   3.520096231327965*^9}, {3.5200964529107537`*^9, 3.5200964550479574`*^9}, 
   3.54921167738791*^9, {3.5492239043361177`*^9, 3.549223945196175*^9}, {
   3.549225906300922*^9, 3.549225923260946*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Tangent recurrence 2b:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.5492163850779896`*^9, 3.5492163861679907`*^9}, {
   3.549218830909015*^9, 3.549218846409037*^9}, {3.5492190914793797`*^9, 
   3.549219093619383*^9}, 3.5492191583694735`*^9, {3.5492193545997486`*^9, 
   3.54921935556975*^9}, {3.5492197078802433`*^9, 3.5492197082902436`*^9}, 
   3.5492235628256397`*^9, 3.5492236205657206`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "d", 
   RowBox[{"(", 
    RowBox[{"n", "+", "1"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Tan", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Tan", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Tan", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "\[Equal]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A", " ", 
        SuperscriptBox["b", "2"]}], "-", 
       RowBox[{"a", " ", "b", " ", "B"}], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", "C"}]}], ")"}]}], 
    SuperscriptBox[
     RowBox[{"Tan", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"m", "+", "1"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     RowBox[{"n", "+", "1"}]]}], "+", "\[IndentingNewLine]", " ", 
   RowBox[{"d", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Tan", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "m"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "a"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "B"}], "-", 
           RowBox[{"a", " ", "C"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], "+", 
        RowBox[{"A", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"m", "+", "n", "+", "2"}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "B"}], "-", 
           RowBox[{"b", " ", 
            RowBox[{"(", 
             RowBox[{"A", "-", "C"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], 
         RowBox[{"Tan", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"a", " ", "b", " ", "B"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "C"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"m", "+", "n", "+", "2"}], ")"}], 
         SuperscriptBox[
          RowBox[{"Tan", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Tan", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "+", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.499404301116287*^9, 
   3.49940430323629*^9}, {3.4994048006769867`*^9, 3.4994048025069895`*^9}, {
   3.5003179811489162`*^9, 3.5003179814297166`*^9}, 3.5003181853432746`*^9, {
   3.5003185563630857`*^9, 3.500318557803087*^9}, {3.5013586287231283`*^9, 
   3.5013586400931444`*^9}, {3.5016982582883544`*^9, 3.501698290298399*^9}, 
   3.501698454388629*^9, 3.5017252651905704`*^9, 3.5017919634981456`*^9, 
   3.505344639523782*^9, {3.5053446875938487`*^9, 3.505344713193885*^9}, 
   3.5053448624840937`*^9, {3.5194002577996445`*^9, 3.519400257862035*^9}, {
   3.519408981030201*^9, 3.5194089829334044`*^9}, 3.5194090160054626`*^9, {
   3.519409049280321*^9, 3.519409075051566*^9}, {3.519409230459039*^9, 
   3.5194092971647563`*^9}, {3.519409343450038*^9, 3.519409354307657*^9}, {
   3.520096073861288*^9, 3.520096081130901*^9}, {3.520096341744959*^9, 
   3.520096360199791*^9}, 3.5492116658932524`*^9, {3.5492239047761188`*^9, 
   3.5492239182661376`*^9}, {3.5492239789262223`*^9, 3.549223982996228*^9}, {
   3.54922576907073*^9, 3.5492257740007367`*^9}, {3.549225836800825*^9, 
   3.549225879030884*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Tangent recurrence 3a:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.5492163850779896`*^9, 3.5492163861679907`*^9}, {
   3.5492164773381186`*^9, 3.5492164780781193`*^9}, {3.5492165738282537`*^9, 
   3.549216574638255*^9}, {3.549217395399404*^9, 3.5492173956794043`*^9}, 
   3.5492188362490225`*^9, {3.549218919039139*^9, 3.549218919509139*^9}, 
   3.5492198736404753`*^9, 3.54922356291564*^9, 3.549223622045723*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"b", " ", "d", 
   RowBox[{"(", 
    RowBox[{"m", "+", "n", "+", "1"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Tan", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Tan", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Tan", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "\[Equal]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"C", " ", 
    SuperscriptBox[
     RowBox[{"Tan", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     RowBox[{"n", "+", "1"}]]}], "-", "\[IndentingNewLine]", 
   RowBox[{"d", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Tan", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"m", "-", "1"}]], " ", 
      RowBox[{"(", " ", 
       RowBox[{
        RowBox[{"a", " ", "C", " ", "m"}], "-", 
        RowBox[{"b", " ", 
         RowBox[{"(", 
          RowBox[{"A", "-", "C"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"m", "+", "n", "+", "1"}], ")"}], 
         RowBox[{"Tan", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "C", " ", "m"}], "-", 
           RowBox[{"b", " ", "B", " ", 
            RowBox[{"(", 
             RowBox[{"m", "+", "n", "+", "1"}], ")"}]}]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Tan", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Tan", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.501697974317957*^9, 
   3.5016980069680023`*^9}, 3.501791949958126*^9, 3.5053446395137815`*^9, {
   3.5053446875538487`*^9, 3.505344713193885*^9}, 3.5053448601040907`*^9, {
   3.519400257347314*^9, 3.519400257534485*^9}, {3.5194058087802296`*^9, 
   3.5194058556427116`*^9}, {3.5194059235964313`*^9, 
   3.5194059534392834`*^9}, {3.519562911999762*^9, 3.519562914074566*^9}, {
   3.520014762495964*^9, 3.5200147641492357`*^9}, {3.520014855125953*^9, 
   3.520014890530916*^9}, {3.520096243870387*^9, 3.520096252700002*^9}, 
   3.549211675175783*^9, {3.5492239044461184`*^9, 3.5492239417361703`*^9}, {
   3.5492256989206314`*^9, 3.549225715450655*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Tangent recurrence 3b:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}, {3.549216045807514*^9, 
   3.549216045807514*^9}, {3.5492163850779896`*^9, 3.5492163861679907`*^9}, {
   3.5492164773381186`*^9, 3.5492164780781193`*^9}, {3.5492165738282537`*^9, 
   3.549216574638255*^9}, {3.549217395399404*^9, 3.5492173956794043`*^9}, 
   3.5492188362490225`*^9, {3.549218919039139*^9, 3.549218919509139*^9}, 
   3.5492198736404753`*^9, {3.549220163360881*^9, 3.5492201636708813`*^9}, 
   3.54922356300564*^9, 3.5492236234857244`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "d", 
   RowBox[{"(", 
    RowBox[{"m", "+", "1"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Tan", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Tan", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Tan", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "\[Equal]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"A", " ", 
    SuperscriptBox[
     RowBox[{"Tan", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"m", "+", "1"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     RowBox[{"n", "+", "1"}]]}], "+", "\[IndentingNewLine]", 
   RowBox[{"d", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Tan", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"m", "+", "1"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "B", " ", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], "-", 
        RowBox[{"A", " ", "b", " ", 
         RowBox[{"(", 
          RowBox[{"m", "+", "n", "+", "2"}], ")"}]}], "-", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"A", "-", "C"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], 
         RowBox[{"Tan", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "-", 
        RowBox[{"A", " ", "b", " ", 
         RowBox[{"(", 
          RowBox[{"m", "+", "n", "+", "2"}], ")"}], 
         SuperscriptBox[
          RowBox[{"Tan", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], " ", ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Tan", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, 
   3.4991797926481485`*^9, {3.4991798252678056`*^9, 3.499179837935028*^9}, {
   3.499180927976143*^9, 3.499180938599762*^9}, {3.4991810132614927`*^9, 
   3.4991810250395136`*^9}, {3.4991962578715715`*^9, 
   3.4991962790096083`*^9}, {3.499196703083153*^9, 3.4991967615208554`*^9}, {
   3.499197192643613*^9, 3.499197222845266*^9}, {3.4991977240625467`*^9, 
   3.4991977407233753`*^9}, {3.499197780737446*^9, 3.4991977890990605`*^9}, {
   3.4991980290346823`*^9, 3.4991980546967273`*^9}, {3.499198191403367*^9, 
   3.499198208017396*^9}, {3.499198305326367*^9, 3.4991983055447674`*^9}, {
   3.499198375223689*^9, 3.4991983899189153`*^9}, 3.499198439702202*^9, {
   3.4992136675539966`*^9, 3.4992137193140693`*^9}, 3.499213754044118*^9, {
   3.4992161931675324`*^9, 3.499216193677533*^9}, {3.4992162414576*^9, 
   3.4992163332577286`*^9}, {3.4992164987579603`*^9, 
   3.4992165531380367`*^9}, {3.4993646678093863`*^9, 
   3.4993647284894705`*^9}, {3.499364780039543*^9, 3.499364804929578*^9}, {
   3.499364846769636*^9, 3.4993648633396597`*^9}, {3.499404320916315*^9, 
   3.499404323956319*^9}, {3.499404813317004*^9, 3.499404815097007*^9}, {
   3.5003179817729173`*^9, 3.5003179820537176`*^9}, 3.5003181967000947`*^9, {
   3.5016975310573363`*^9, 3.50169759787743*^9}, 3.501791940008113*^9, 
   3.5053446395137815`*^9, {3.505344687513849*^9, 3.5053447131838846`*^9}, 
   3.505344857134086*^9, {3.519400257721656*^9, 3.5194002577840466`*^9}, 
   3.5194075145652256`*^9, {3.5194076070889883`*^9, 3.5194076135473995`*^9}, {
   3.519408328512255*^9, 3.519408347263488*^9}, {3.519408392316367*^9, 
   3.519408433094839*^9}, {3.520096308969301*^9, 3.5200963331649437`*^9}, {
   3.5200964997264357`*^9, 3.5200965013800387`*^9}, 3.5492116675863495`*^9, {
   3.5492239047361183`*^9, 3.549223918256138*^9}, {3.5492239657562037`*^9, 
   3.549223971396212*^9}, {3.5492255592504363`*^9, 3.549225599900493*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}, Open  ]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Page"], "PageNumber"], " ", "|", " ", 
      StyleBox[
       ValueBox["FileName"], "Header"]}], "Header", 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
   Cell[
    TextData[{
     "Integration", " ", "Recurrence", " ", "Equations", " ", "for", " ", 
      "Trigonometric", " ", "Expressions"}], "Header", 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, 
   Cell[
    TextData[
     CounterBox["Page", CounterFunction :> Identity]], "Header", 
    CellMargins -> {{Inherited, 0}, {Inherited, Inherited}}]}},
PageFooters->{{None, None, None}, {None, None, None}},
PageHeaderLines->{False, False},
PageFooterLines->{False, False},
PrintingOptions->{"FacingPages"->False,
"FirstPageFace"->Right,
"FirstPageFooter"->True,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.3999998569488525`,
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 146, 2, 114, "Title"],
Cell[CellGroupData[{
Cell[716, 26, 218, 4, 70, "Subtitle"],
Cell[CellGroupData[{
Cell[959, 34, 4989, 108, 47, "Subsubtitle"],
Cell[5951, 144, 2738, 43, 36, "Subsubsection"],
Cell[8692, 189, 5754, 130, 128, "Subsubtitle"],
Cell[14449, 321, 89, 2, 35, "Subsubsection"],
Cell[14541, 325, 2689, 43, 26, "Subsubsection"],
Cell[17233, 370, 5672, 128, 128, "Subsubtitle"],
Cell[22908, 500, 89, 2, 35, "Subsubsection"],
Cell[23000, 504, 2795, 44, 26, "Subsubsection"],
Cell[25798, 550, 5872, 134, 127, "Subsubtitle"],
Cell[31673, 686, 89, 2, 35, "Subsubsection"],
Cell[31765, 690, 2849, 45, 26, "Subsubsection"],
Cell[34617, 737, 5904, 135, 128, "Subsubtitle"],
Cell[40524, 874, 89, 2, 35, "Subsubsection"],
Cell[40616, 878, 2895, 46, 26, "Subsubsection"],
Cell[43514, 926, 5654, 121, 127, "Subsubtitle"],
Cell[49171, 1049, 89, 2, 35, "Subsubsection"],
Cell[49263, 1053, 2922, 46, 26, "Subsubsection"],
Cell[52188, 1101, 5447, 118, 128, "Subsubtitle"],
Cell[57638, 1221, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[57719, 1227, 5273, 115, 47, "Subsubtitle"],
Cell[62995, 1344, 2594, 35, 93, "Subsubsection"],
Cell[65592, 1381, 6350, 147, 349, "Subsubtitle"],
Cell[71945, 1530, 89, 2, 93, "Subsubsection"],
Cell[72037, 1534, 2693, 36, 65, "Subsubsection"],
Cell[74733, 1572, 6562, 152, 349, "Subsubtitle"],
Cell[81298, 1726, 89, 2, 93, "Subsubsection"],
Cell[81390, 1730, 2645, 36, 65, "Subsubsection"],
Cell[84038, 1768, 7171, 169, 354, "Subsubtitle"],
Cell[91212, 1939, 89, 2, 93, "Subsubsection"],
Cell[91304, 1943, 2695, 36, 65, "Subsubsection"],
Cell[94002, 1981, 7075, 166, 354, "Subsubtitle"],
Cell[101080, 2149, 89, 2, 93, "Subsubsection"],
Cell[101172, 2153, 2724, 37, 65, "Subsubsection"],
Cell[103899, 2192, 6512, 145, 349, "Subsubtitle"],
Cell[110414, 2339, 89, 2, 93, "Subsubsection"],
Cell[110506, 2343, 2772, 37, 65, "Subsubsection"],
Cell[113281, 2382, 6524, 145, 349, "Subsubtitle"],
Cell[119808, 2529, 44, 1, 8, "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[119901, 2536, 222, 4, 70, "Subtitle"],
Cell[CellGroupData[{
Cell[120148, 2544, 5041, 109, 47, "Subsubtitle"],
Cell[125192, 2655, 2776, 45, 36, "Subsubsection"],
Cell[127971, 2702, 5685, 126, 128, "Subsubtitle"],
Cell[133659, 2830, 89, 2, 35, "Subsubsection"],
Cell[133751, 2834, 2722, 44, 26, "Subsubsection"],
Cell[136476, 2880, 5715, 128, 128, "Subsubtitle"],
Cell[142194, 3010, 89, 2, 35, "Subsubsection"],
Cell[142286, 3014, 2832, 46, 26, "Subsubsection"],
Cell[145121, 3062, 6101, 139, 127, "Subsubtitle"],
Cell[151225, 3203, 89, 2, 35, "Subsubsection"],
Cell[151317, 3207, 2880, 46, 26, "Subsubsection"],
Cell[154200, 3255, 5947, 135, 128, "Subsubtitle"],
Cell[160150, 3392, 89, 2, 35, "Subsubsection"],
Cell[160242, 3396, 2926, 47, 26, "Subsubsection"],
Cell[163171, 3445, 5793, 124, 127, "Subsubtitle"],
Cell[168967, 3571, 89, 2, 35, "Subsubsection"],
Cell[169059, 3575, 2953, 47, 26, "Subsubsection"],
Cell[172015, 3624, 5442, 115, 128, "Subsubtitle"],
Cell[177460, 3741, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[177541, 3747, 5318, 115, 47, "Subsubtitle"],
Cell[182862, 3864, 2645, 36, 130, "Subsubsection"],
Cell[185510, 3902, 6193, 140, 488, "Subsubtitle"],
Cell[191706, 4044, 89, 2, 130, "Subsubsection"],
Cell[191798, 4048, 2747, 37, 90, "Subsubsection"],
Cell[194548, 4087, 6535, 150, 488, "Subsubtitle"],
Cell[201086, 4239, 89, 2, 130, "Subsubsection"],
Cell[201178, 4243, 2695, 36, 90, "Subsubsection"],
Cell[203876, 4281, 7300, 172, 495, "Subsubtitle"],
Cell[211179, 4455, 89, 2, 130, "Subsubsection"],
Cell[211271, 4459, 2749, 37, 90, "Subsubsection"],
Cell[214023, 4498, 7092, 165, 495, "Subsubtitle"],
Cell[221118, 4665, 89, 2, 130, "Subsubsection"],
Cell[221210, 4669, 2774, 37, 90, "Subsubsection"],
Cell[223987, 4708, 6600, 147, 488, "Subsubtitle"],
Cell[230590, 4857, 89, 2, 130, "Subsubsection"],
Cell[230682, 4861, 2828, 38, 90, "Subsubsection"],
Cell[233513, 4901, 6454, 140, 488, "Subsubtitle"],
Cell[239970, 5043, 44, 1, 11, "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[240063, 5050, 246, 4, 70, "Subtitle"],
Cell[CellGroupData[{
Cell[240334, 5058, 4660, 85, 47, "Subsubtitle"],
Cell[244997, 5145, 2878, 46, 36, "Subsubsection"],
Cell[247878, 5193, 7961, 157, 128, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10006.}],
Cell[255842, 5352, 89, 2, 35, "Subsubsection"],
Cell[255934, 5356, 2827, 46, 26, "Subsubsection"],
Cell[258764, 5404, 7879, 155, 128, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[266646, 5561, 89, 2, 35, "Subsubsection"],
Cell[266738, 5565, 2935, 47, 26, "Subsubsection"],
Cell[269676, 5614, 7880, 155, 127, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10005.}],
Cell[277559, 5771, 89, 2, 35, "Subsubsection"],
Cell[277651, 5775, 2986, 48, 26, "Subsubsection"],
Cell[280640, 5825, 8150, 159, 128, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[288793, 5986, 89, 2, 35, "Subsubsection"],
Cell[288885, 5990, 3025, 48, 26, "Subsubsection"],
Cell[291913, 6040, 7709, 149, 127, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10004.}],
Cell[299625, 6191, 89, 2, 35, "Subsubsection"],
Cell[299717, 6195, 3095, 47, 26, "Subsubsection"],
Cell[302815, 6244, 7530, 144, 128, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[310348, 6390, 89, 2, 35, "Subsubsection"],
Cell[310440, 6394, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[310521, 6400, 5328, 109, 47, "Subsubtitle"],
Cell[315852, 6511, 2647, 36, 50, "Subsubsection"],
Cell[318502, 6549, 6238, 141, 223, "Subsubtitle"],
Cell[324743, 6692, 89, 2, 50, "Subsubsection"],
Cell[324835, 6696, 2746, 37, 36, "Subsubsection"],
Cell[327584, 6735, 6083, 139, 251, "Subsubtitle"],
Cell[333670, 6876, 89, 2, 50, "Subsubsection"],
Cell[333762, 6880, 2694, 36, 36, "Subsubsection"],
Cell[336459, 6918, 7692, 179, 230, "Subsubtitle"],
Cell[344154, 7099, 89, 2, 50, "Subsubsection"],
Cell[344246, 7103, 2750, 37, 36, "Subsubsection"],
Cell[346999, 7142, 6909, 165, 230, "Subsubtitle"],
Cell[353911, 7309, 89, 2, 50, "Subsubsection"],
Cell[354003, 7313, 2770, 37, 36, "Subsubsection"],
Cell[356776, 7352, 5664, 126, 179, "Subsubtitle"],
Cell[362443, 7480, 89, 2, 50, "Subsubsection"],
Cell[362535, 7484, 2824, 38, 36, "Subsubsection"],
Cell[365362, 7524, 6397, 138, 223, "Subsubtitle"],
Cell[371762, 7664, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
