/*
 * cmfont-info.c
 * Font metrics for Type1 Computer Modern Fonts
 *
 * extracted from ../fonts/cmpsfont-unix/afm
 *
 * The use of the font metrics appears not to be subject to
 * any restriction.
 */


/* $Id: cmfont-info.c 2277 2014-01-06 10:33:50Z arthurcnorman $ */


typedef struct cm_font_info {
   const char *name;
   short int isfixed, fontwidth, maxleftbearing, maxrightbearing;
   short int capheight, xheight, ascent, descent;
   short int charwidth[256];
} cm_font_info;

static cm_font_info cm_font_widths[] = {
{"CMR5", 0, 1361, 365, 366, 679, 430, 694, -194, {
   831,  1097,  1028,   911,   889,   981,   958,  1028,
   958,  1028,   958,   681,   681,   403,   403,   646,
   403,   438,   681,   681,   681,   681,   681,   981,
   611,   681,   958,  1028,   681,  1178,  1317,  1028,
   403,   403,   681,  1097,   681,  1097,  1028,   403,
   542,   542,   681,  1028,   403,   472,   403,   681,
   681,   681,   681,   681,   681,   681,   681,   681,
   681,   681,   403,   403,  1028,  1028,  1028,   646,
  1028,   981,   935,   958,  1004,   900,   865,  1033,
   981,   494,   692,  1015,   831,  1189,   981,  1028,
   900,  1028,   969,   750,   958,   981,   981,  1328,
   981,   981,   819,   403,   681,   403,   681,   403,
   403,   681,   750,   611,   750,   611,   438,   681,
   750,   403,   438,   715,   403,  1097,   750,   681,
   750,   715,   542,   549,   542,   750,   715,   958,
   715,   715,   611,   681,  1361,   681,   681,   681,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1 }},
{"CMR6", 0, 1222, 332, 333, 683, 430, 694, -194, {
   754,  1000,   935,   831,   806,   896,   870,   935,
   870,   935,   870,   736,   704,   704,  1056,  1056,
   352,   384,   611,   611,   611,   611,   611,   896,
   546,   611,   870,   935,   611,  1078,  1207,   935,
   352,   352,   611,  1000,   611,  1000,   935,   352,
   481,   481,   611,   935,   352,   417,   352,   611,
   611,   611,   611,   611,   611,   611,   611,   611,
   611,   611,   352,   352,   352,   935,   579,   579,
   935,   896,   851,   870,   916,   819,   786,   942,
   896,   443,   624,   929,   754,  1091,   896,   935,
   819,   935,   883,   676,   870,   896,   896,  1220,
   896,   896,   741,   352,   611,   352,   611,   352,
   352,   611,   676,   546,   676,   546,   384,   611,
   676,   352,   384,   644,   352,  1000,   676,   611,
   676,   644,   481,   488,   481,   676,   644,   870,
   644,   644,   546,   611,  1222,   611,   611,   611,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1 }},
{"CMR7", 0, 1151, 312, 313, 683, 430, 694, -194, {
   706,   938,   877,   782,   754,   843,   815,   877,
   815,   877,   815,   678,   647,   647,   970,   970,
   323,   354,   569,   569,   569,   569,   569,   843,
   508,   569,   815,   877,   569,  1014,  1137,   877,
   323,   323,   569,   938,   569,   938,   877,   323,
   446,   446,   569,   877,   323,   385,   323,   569,
   569,   569,   569,   569,   569,   569,   569,   569,
   569,   569,   323,   323,   323,   877,   539,   539,
   877,   843,   799,   815,   860,   768,   737,   884,
   843,   413,   583,   874,   706,  1028,   843,   877,
   768,   877,   829,   631,   815,   843,   843,  1151,
   843,   843,   692,   323,   569,   323,   569,   323,
   323,   569,   631,   508,   631,   508,   354,   569,
   631,   323,   354,   600,   323,   938,   631,   569,
   631,   600,   446,   453,   446,   631,   600,   815,
   600,   600,   508,   569,  1139,   569,   569,   569,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1 }},
{"CMR8", 0, 1091, 293, 294, 683, 430, 694, -194, {
   664,   885,   826,   737,   708,   796,   767,   826,
   767,   826,   767,   620,   590,   590,   885,   885,
   295,   325,   531,   531,   531,   531,   531,   796,
   472,   531,   767,   826,   531,   959,  1077,   826,
   295,   295,   531,   885,   531,   885,   826,   295,
   413,   413,   531,   826,   295,   354,   295,   531,
   531,   531,   531,   531,   531,   531,   531,   531,
   531,   531,   295,   295,   295,   826,   502,   502,
   826,   796,   752,   767,   811,   723,   693,   834,
   796,   383,   545,   825,   664,   973,   796,   826,
   723,   826,   782,   590,   767,   796,   796,  1091,
   796,   796,   649,   295,   531,   295,   531,   295,
   295,   531,   590,   472,   590,   472,   325,   531,
   590,   295,   325,   561,   295,   885,   590,   531,
   590,   561,   414,   419,   413,   590,   561,   767,
   561,   561,   472,   531,  1063,   531,   531,   531,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1 }},
{"CMR9", 0, 1056, 285, 286, 683, 430, 694, -194, {
   642,   856,   799,   714,   685,   771,   742,   799,
   742,   799,   742,   600,   571,   571,   856,   856,
   285,   314,   514,   514,   514,   514,   514,   771,
   457,   514,   742,   799,   514,   928,  1042,   799,
   285,   285,   514,   856,   514,   856,   799,   285,
   400,   400,   514,   799,   285,   343,   285,   514,
   514,   514,   514,   514,   514,   514,   514,   514,
   514,   514,   285,   285,   285,   799,   485,   485,
   799,   771,   728,   742,   785,   699,   671,   806,
   771,   371,   528,   799,   642,   942,   771,   799,
   699,   799,   756,   571,   742,   771,   771,  1056,
   771,   771,   628,   285,   514,   285,   514,   285,
   285,   514,   571,   457,   571,   457,   314,   514,
   571,   285,   314,   542,   285,   856,   571,   514,
   571,   542,   402,   405,   400,   571,   542,   742,
   542,   542,   457,   514,  1028,   514,   514,   514,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1 }},
{"CMR10", 0, 1028, 279, 280, 683, 430, 694, -194, {
   625,   833,   778,   694,   667,   750,   722,   778,
   722,   778,   722,   583,   556,   556,   833,   833,
   278,   306,   500,   500,   500,   500,   500,   750,
   444,   500,   722,   778,   500,   903,  1014,   778,
   278,   278,   500,   833,   500,   833,   778,   278,
   389,   389,   500,   778,   278,   333,   278,   500,
   500,   500,   500,   500,   500,   500,   500,   500,
   500,   500,   278,   278,   278,   778,   472,   472,
   778,   750,   708,   722,   764,   681,   653,   785,
   750,   361,   514,   778,   625,   917,   750,   778,
   681,   778,   736,   556,   722,   750,   750,  1028,
   750,   750,   611,   278,   500,   278,   500,   278,
   278,   500,   556,   444,   556,   444,   306,   500,
   556,   278,   306,   528,   278,   833,   556,   500,
   556,   528,   392,   394,   389,   556,   528,   722,
   528,   528,   444,   500,  1000,   500,   500,   500,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1 }},
{"CMR12", 0, 1006, 274, 275, 683, 430, 694, -194, {
   612,   816,   762,   680,   653,   734,   707,   762,
   707,   762,   707,   571,   544,   544,   816,   816,
   272,   299,   490,   490,   490,   490,   490,   734,
   435,   490,   707,   762,   490,   884,   993,   762,
   272,   272,   490,   816,   490,   816,   762,   272,
   381,   381,   490,   762,   272,   326,   272,   490,
   490,   490,   490,   490,   490,   490,   490,   490,
   490,   490,   272,   272,   272,   762,   462,   462,
   762,   734,   693,   707,   748,   666,   639,   768,
   734,   353,   503,   761,   612,   897,   734,   762,
   666,   762,   721,   544,   707,   734,   734,  1006,
   734,   734,   598,   272,   490,   272,   490,   272,
   272,   490,   544,   435,   544,   435,   299,   490,
   544,   272,   299,   517,   272,   816,   544,   490,
   544,   517,   381,   386,   381,   544,   517,   707,
   517,   517,   435,   490,   979,   490,   490,   490,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1 }},
{"CMR17", 0, 955, 259, 260, 683, 430, 694, -194, {
   576,   772,   720,   641,   615,   693,   668,   720,
   668,   720,   668,   525,   499,   499,   749,   749,
   250,   276,   459,   459,   459,   459,   459,   693,
   406,   459,   668,   720,   459,   837,   942,   720,
   250,   250,   459,   772,   459,   772,   720,   250,
   354,   354,   459,   720,   250,   302,   250,   459,
   459,   459,   459,   459,   459,   459,   459,   459,
   459,   459,   250,   250,   250,   720,   432,   432,
   720,   693,   654,   668,   707,   628,   602,   726,
   693,   328,   471,   719,   576,   850,   693,   720,
   628,   720,   680,   511,   668,   693,   693,   955,
   693,   693,   563,   250,   459,   250,   459,   250,
   250,   459,   511,   406,   511,   406,   276,   459,
   511,   250,   276,   485,   250,   772,   511,   459,
   511,   485,   354,   359,   354,   511,   485,   668,
   485,   485,   406,   459,   917,   459,   459,   459,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1 }},
{"CMMI5", 0, 1361, 345, 168, 683, 430, 694, -194, {
   833,  1153,  1048,   967,  1018,  1110,  1065,   840,
   944,   893,  1061,   913,   791,   747,   654,   614,
   667,   744,   677,   550,   828,   840,   850,   712,
   667,   831,   726,   815,   682,   792,   842,   865,
   931,   886,   675,   855,  1145,   726,   578,   918,
  1361,  1361,  1361,  1361,   458,   458,   736,   736,
   736,   736,   736,   736,   736,   736,   736,   736,
   736,   736,   458,   458,  1083,   736,  1083,   736,
   749,  1036,  1037,   996,  1110,  1007,   867,  1064,
  1110,   627,   773,  1139,   956,  1284,  1076,  1048,
   875,  1082,  1030,   856,   832,   944,   828,  1279,
  1113,   824,   943,   597,   597,   597,  1361,  1361,
   597,   774,   633,   649,   740,   677,   684,   701,
   828,   534,   588,   758,   480,  1228,   881,   703,
   740,   659,   671,   670,   564,   846,   722,  1009,
   792,   731,   689,   534,   553,   889,   736,   458,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1 }},
{"CMMI6", 0, 1222, 308, 130, 683, 430, 694, -194, {
   743,  1028,   934,   859,   907,  1000,   952,   736,
   833,   781,   946,   805,   698,   652,   566,   523,
   572,   644,   590,   466,   726,   736,   750,   622,
   572,   727,   639,   717,   582,   690,   742,   767,
   819,   780,   587,   751,  1022,   639,   488,   812,
  1222,  1222,  1222,  1222,   380,   380,   639,   639,
   639,   639,   639,   639,   639,   639,   639,   639,
   639,   639,   380,   380,   963,   639,   963,   639,
   659,   924,   927,   884,   998,   900,   775,   953,
  1000,   548,   682,  1026,   846,  1162,   967,   934,
   780,   966,   922,   757,   731,   838,   730,  1151,
  1001,   726,   838,   509,   509,   509,  1222,  1222,
   519,   675,   548,   559,   642,   589,   601,   608,
   726,   446,   512,   661,   402,  1094,   770,   613,
   642,   571,   580,   584,   477,   737,   625,   893,
   698,   633,   596,   446,   479,   787,   639,   380,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1 }},
{"CMMI7", 0, 1139, 289, 112, 683, 430, 694, -194, {
   694,   954,   869,   798,   844,   936,   886,   678,
   770,   717,   880,   743,   648,   600,   519,   476,
   520,   589,   544,   423,   669,   678,   695,   573,
   520,   668,   593,   662,   527,   633,   687,   714,
   756,   720,   540,   690,   950,   593,   439,   751,
  1139,  1139,  1139,  1139,   339,   339,   585,   585,
   585,   585,   585,   585,   585,   585,   585,   585,
   585,   585,   339,   339,   893,   585,   893,   585,
   610,   859,   863,   819,   934,   839,   725,   889,
   936,   506,   632,   960,   784,  1089,   905,   869,
   727,   900,   861,   701,   675,   778,   675,  1074,
   937,   672,   778,   462,   462,   462,  1139,  1139,
   478,   620,   502,   511,   595,   542,   557,   557,
   669,   404,   473,   607,   361,  1014,   706,   564,
   589,   524,   530,   539,   432,   675,   571,   826,
   648,   579,   546,   399,   442,   730,   585,   339,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1 }},
{"CMMI8", 0, 1063, 269, 92, 683, 430, 694, -194, {
   643,   885,   806,   737,   783,   873,   823,   620,
   708,   655,   817,   682,   596,   547,   470,   430,
   467,   533,   496,   376,   612,   620,   639,   522,
   467,   610,   544,   607,   472,   576,   632,   660,
   694,   661,   491,   632,   882,   544,   389,   692,
  1063,  1063,  1063,  1063,   295,   295,   531,   531,
   531,   531,   531,   531,   531,   531,   531,   531,
   531,   531,   295,   295,   826,   531,   826,   531,
   560,   796,   801,   757,   872,   779,   672,   828,
   873,   461,   580,   896,   723,  1020,   843,   806,
   674,   836,   800,   646,   619,   719,   619,  1002,
   874,   616,   720,   413,   413,   413,  1063,  1063,
   434,   564,   455,   460,   547,   493,   510,   506,
   612,   362,   430,   553,   317,   940,   645,   514,
   535,   474,   479,   491,   384,   615,   517,   762,
   598,   525,   494,   350,   400,   673,   531,   295,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1 }},
{"CMMI9", 0, 1028, 265, 89, 683, 430, 694, -194, {
   628,   856,   782,   714,   761,   850,   799,   600,
   685,   631,   792,   659,   579,   531,   456,   416,
   451,   513,   481,   364,   592,   600,   619,   507,
   451,   588,   529,   588,   452,   556,   612,   641,
   671,   639,   477,   609,   853,   529,   374,   671,
  1028,  1028,  1028,  1028,   285,   285,   514,   514,
   514,   514,   514,   514,   514,   514,   514,   514,
   514,   514,   285,   285,   799,   514,   799,   514,
   544,   771,   778,   734,   848,   756,   656,   805,
   850,   449,   566,   870,   699,   993,   822,   782,
   656,   811,   778,   628,   600,   699,   599,   971,
   849,   597,   699,   400,   400,   400,  1028,  1028,
   424,   544,   440,   445,   533,   478,   499,   490,
   592,   352,   420,   535,   307,   905,   620,   498,
   516,   459,   464,   479,   371,   591,   499,   737,
   583,   506,   478,   334,   392,   653,   514,   285,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1 }},
{"CMMI10", 0, 1000, 264, 86, 683, 430, 694, -194, {
   615,   833,   763,   694,   742,   831,   780,   583,
   667,   612,   772,   640,   566,   518,   444,   406,
   438,   497,   469,   354,   576,   583,   603,   494,
   438,   570,   517,   571,   437,   540,   596,   626,
   651,   622,   466,   591,   828,   517,   363,   654,
  1000,  1000,  1000,  1000,   278,   278,   500,   500,
   500,   500,   500,   500,   500,   500,   500,   500,
   500,   500,   278,   278,   778,   500,   778,   500,
   531,   750,   759,   715,   828,   738,   643,   786,
   831,   440,   555,   849,   681,   970,   803,   763,
   642,   791,   759,   613,   584,   683,   583,   944,
   828,   581,   683,   389,   389,   389,  1000,  1000,
   417,   529,   429,   433,   520,   466,   490,   477,
   576,   345,   412,   521,   298,   878,   600,   485,
   503,   446,   451,   469,   361,   572,   485,   716,
   572,   490,   465,   322,   384,   636,   500,   278,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1 }},
{"CMMI12", 0, 979, 263, 88, 683, 430, 694, -194, {
   607,   816,   748,   680,   729,   811,   766,   571,
   653,   598,   758,   623,   553,   508,   434,   395,
   428,   483,   456,   346,   564,   571,   589,   484,
   428,   555,   505,   557,   425,   528,   580,   613,
   637,   610,   458,   577,   809,   505,   354,   641,
   979,   979,   979,   979,   272,   272,   490,   490,
   490,   490,   490,   490,   490,   490,   490,   490,
   490,   490,   272,   272,   762,   490,   762,   490,
   517,   734,   744,   701,   813,   725,   634,   772,
   811,   432,   541,   833,   666,   947,   784,   748,
   631,   775,   745,   602,   574,   665,   571,   924,
   813,   568,   670,   381,   381,   381,   979,   979,
   411,   514,   416,   421,   509,   454,   483,   469,
   564,   334,   405,   509,   292,   856,   584,   471,
   491,   434,   441,   461,   354,   557,   473,   700,
   556,   477,   455,   313,   378,   623,   490,   272,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1 }},
{"CMSY5", 0, 1568, 271, 271, 683, 430, 694, -944, {
  1083,   458,  1083,   736,  1083,   736,  1083,  1083,
  1083,  1083,  1083,  1083,  1083,  1361,   736,   736,
  1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,
  1083,  1083,  1083,  1083,  1361,  1361,  1083,  1083,
  1361,  1361,   736,   736,  1361,  1361,  1361,  1083,
  1361,  1361,   875,   875,  1361,  1361,  1361,  1083,
   441,  1361,   944,   944,  1222,  1222,     0,     0,
   806,   806,   944,   736,  1014,  1014,  1083,  1083,
   875,  1113,   919,   782,  1084,   771,   988,   850,
  1195,   820,   958,  1055,   965,  1568,  1126,  1089,
   998,  1132,  1196,   868,   822,   874,   899,  1368,
   997,   929,   991,   944,   944,   944,   944,   944,
   875,   875,   667,   667,   667,   667,   736,   736,
   597,   597,   458,   736,   736,   875,   736,   458,
  1097,  1036,  1153,   632,   944,   944,  1083,  1083,
   667,   667,   667,   875,  1083,  1083,  1083,  1083,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1 }},
{"CMSY6", 0, 1427, 229, 230, 683, 430, 694, -948, {
   963,   380,   963,   639,   963,   639,   963,   963,
   963,   963,   963,   963,   963,  1222,   639,   639,
   963,   963,   963,   963,   963,   963,   963,   963,
   963,   963,   963,   963,  1222,  1222,   963,   963,
  1222,  1222,   639,   639,  1222,  1222,  1222,   963,
  1222,  1222,   769,   769,  1222,  1222,  1222,   963,
   366,  1222,   833,   833,  1093,  1093,     0,     0,
   704,   704,   833,   639,   898,   898,   963,   963,
   769,   990,   813,   678,   961,   671,   880,   747,
  1059,   709,   846,   939,   855,  1427,  1006,   973,
   878,  1008,  1061,   762,   711,   774,   785,  1223,
   884,   824,   884,   833,   833,   833,   833,   833,
   769,   769,   574,   574,   574,   574,   639,   639,
   509,   509,   380,   639,   639,   769,   639,   380,
  1000,   924,  1028,   542,   833,   833,   963,   963,
   574,   574,   574,   769,   963,   963,   963,   963,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1 }},
{"CMSY7", 0, 1343, 207, 208, 683, 430, 694, -951, {
   893,   339,   893,   585,   893,   585,   893,   893,
   893,   893,   893,   893,   893,  1139,   585,   585,
   893,   893,   893,   893,   893,   893,   893,   893,
   893,   893,   893,   893,  1139,  1139,   893,   893,
  1139,  1139,   585,   585,  1139,  1139,  1139,   893,
  1139,  1139,   708,   708,  1139,  1139,  1139,   893,
   329,  1139,   770,   770,  1016,  1016,     0,     0,
   647,   647,   770,   585,   831,   831,   893,   893,
   708,   918,   753,   620,   889,   616,   818,   689,
   979,   647,   782,   872,   792,  1343,   936,   906,
   809,   936,   981,   702,   648,   718,   720,  1135,
   819,   764,   823,   770,   770,   770,   770,   770,
   708,   708,   524,   524,   524,   524,   585,   585,
   462,   462,   339,   585,   585,   708,   585,   339,
   938,   859,   954,   494,   770,   770,   893,   893,
   524,   524,   524,   708,   893,   893,   893,   893,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1 }},
{"CMSY8", 0, 1265, 184, 185, 683, 430, 694, -955, {
   826,   295,   826,   531,   826,   531,   826,   826,
   826,   826,   826,   826,   826,  1063,   531,   531,
   826,   826,   826,   826,   826,   826,   826,   826,
   826,   826,   826,   826,  1063,  1063,   826,   826,
  1063,  1063,   531,   531,  1063,  1063,  1063,   826,
  1063,  1063,   649,   649,  1063,  1063,  1063,   826,
   288,  1063,   708,   708,   944,   944,     0,     0,
   590,   590,   708,   531,   767,   767,   826,   826,
   649,   849,   695,   563,   822,   561,   758,   631,
   904,   585,   720,   807,   731,  1265,   869,   842,
   743,   868,   907,   643,   586,   663,   656,  1055,
   756,   706,   764,   708,   708,   708,   708,   708,
   649,   649,   472,   472,   472,   472,   531,   531,
   413,   413,   295,   531,   531,   649,   531,   295,
   885,   796,   885,   444,   708,   708,   826,   826,
   472,   472,   472,   649,   826,   826,   826,   826,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1 }},
{"CMSY9", 0, 1229, 178, 179, 683, 430, 694, -958, {
   799,   285,   799,   514,   799,   514,   799,   799,
   799,   799,   799,   799,   799,  1028,   514,   514,
   799,   799,   799,   799,   799,   799,   799,   799,
   799,   799,   799,   799,  1028,  1028,   799,   799,
  1028,  1028,   514,   514,  1028,  1028,  1028,   799,
  1028,  1028,   628,   628,  1028,  1028,  1028,   799,
   279,  1028,   685,   685,   914,   914,     0,     0,
   571,   571,   685,   514,   742,   742,   799,   799,
   628,   821,   674,   543,   794,   542,   736,   611,
   871,   563,   697,   782,   708,  1229,   842,   816,
   717,   839,   874,   622,   563,   642,   632,  1017,
   732,   685,   742,   685,   685,   685,   685,   685,
   628,   628,   457,   457,   457,   457,   514,   514,
   400,   400,   285,   514,   514,   628,   514,   285,
   856,   771,   856,   428,   685,   685,   799,   799,
   457,   457,   457,   628,   799,   799,   799,   799,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1 }},
{"CMSY10", 0, 1201, 174, 175, 683, 430, 694, -960, {
   778,   278,   778,   500,   778,   500,   778,   778,
   778,   778,   778,   778,   778,  1000,   500,   500,
   778,   778,   778,   778,   778,   778,   778,   778,
   778,   778,   778,   778,  1000,  1000,   778,   778,
  1000,  1000,   500,   500,  1000,  1000,  1000,   778,
  1000,  1000,   611,   611,  1000,  1000,  1000,   778,
   275,  1000,   667,   667,   889,   889,     0,     0,
   556,   556,   667,   500,   722,   722,   778,   778,
   611,   798,   657,   527,   771,   528,   719,   595,
   845,   545,   678,   762,   690,  1201,   820,   796,
   696,   817,   848,   606,   545,   626,   613,   988,
   713,   668,   725,   667,   667,   667,   667,   667,
   611,   611,   444,   444,   444,   444,   500,   500,
   389,   389,   278,   500,   500,   611,   500,   278,
   833,   750,   833,   417,   667,   667,   778,   778,
   444,   444,   444,   611,   778,   778,   778,   778,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1 }},
{"CMEX10", 0, 1511, 702, 473, -1, 430, 750, -2960, {
   458,   458,   417,   417,   472,   472,   472,   472,
   583,   583,   472,   472,   333,   556,   578,   578,
   597,   597,   736,   736,   528,   528,   583,   583,
   583,   583,   750,   750,   750,   750,  1044,  1044,
   792,   792,   583,   583,   639,   639,   639,   639,
   806,   806,   806,   806,  1278,  1278,   811,   811,
   875,   875,   667,   667,   667,   667,   667,   667,
   889,   889,   889,   889,   889,   889,   889,   667,
   875,   875,   875,   875,   611,   611,   833,  1111,
   472,   556,  1111,  1511,  1111,  1511,  1111,  1511,
  1056,   944,   472,   833,   833,   833,   833,   833,
  1444,  1278,   556,  1111,  1111,  1111,  1111,  1111,
   944,  1278,   556,  1000,  1444,   556,  1000,  1444,
   472,   472,   528,   528,   528,   528,   667,   667,
  1000,  1000,  1000,  1000,  1056,  1056,  1056,   778,
   667,   667,   450,   450,   450,   450,   778,   778,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1 }},
{(char *)0, 0,0,0,0,0,0,0,0, {0}}};


/* End of cmfont-info.c */
