#! /bin/bash

# Usage:
#   $srcdir/create_bundle.sh name srcdir ?icon
#
# Sets up name.app with a proper Info.plist etc for use with MacOSX.
# This copies in an icon, and arg2 (if present) specifies its identity
# as an .icns file in $srcdir

echo TRACE: create_bundle.sh $*

P=$1.app/Contents/Info.plist
srcdir=$2
IC=${3:-fwin}

SetFile -t APPL $1
mkdir -p $1.app/Contents
mkdir -p $1.app/Contents/MacOS
mkdir -p $1.app/Contents/Resources
mkdir -p $1.app/Contents/Resources/Fonts
F="$1.app/Contents/Resources/Fonts"
cp $srcdir/wxfonts/README                        $F/README.BaKoMa
cp $srcdir/wxfonts/BaKoMa-AMS.Fonts              $F
cp $srcdir/wxfonts/BaKoMa-CM.Fonts               $F
cp $srcdir/wxfonts/README.news                   $F/README.news.BaKoMa
cp $srcdir/wxfonts/LICENCE                       $F/LICENCE.BaKoMa
cp $srcdir/wxfonts/*.ttf                         $F
cp $srcdir/cm-unicode/LICENSE                    $F/LICENSE.cm-unicode
cp $srcdir/cm-unicode/README                     $F/README.cm-unicode
cp $srcdir/cm-unicode/cmuntt.otf                 $F
# The DejaVu Sans Mono font covers a range of characters that CMTT does not..
cp $srcdir/dejavu-fonts-ttf-2.32/LICENSE          $F/LICENSE.dejavu-fonts-ttf-2.32
cp $srcdir/dejavu-fonts-ttf-2.32/README           $F/README.dejavu-fonts-ttf-2.32
cp $srcdir/dejavu-fonts-ttf-2.32/AUTHORS          $F/AUTHORS.dejavu-fonts-ttf-2.32
cp $srcdir/dejavu-fonts-ttf-2.32/ttf/DejaVuSansMono.ttf $F
# I will also use fireflysung and sazanami fonts to cover the CJK range
cp $srcdir/fireflysung-1.3.0/fireflysung.ttf      $F
cp $srcdir/fireflysung-1.3.0/AUTHORS              $F/AUTHORS.fireflysung
cp $srcdir/fireflysung-1.3.0/COPYRIGHT            $F/COPYRIGHT.fireflysung
mkdir -p $F/license.fireflysung
mkdir -p $F/license.fireflysung/big5
mkdir -p $F/license.fireflysung/english
mkdir -p $F/license.fireflysung/gb
cp $srcdir/fireflysung-1.3.0/license/big5/ARPHICPL.TXT    $F/license.fireflysung/big5
cp $srcdir/fireflysung-1.3.0/license/english/ARPHICPL.TXT $F/license.fireflysung/english
cp $srcdir/fireflysung-1.3.0/license/gb/ARPHICPL.TXT      $F/license.fireflysung/gb
cp $srcdir/sazanami-20040629/README               $F/README.sazanami
cp $srcdir/sazanami-20040629/sazanami-gothic.ttf  $F
cp $srcdir/sazanami-20040629/sazanami-mincho.ttf  $F
mkdir -p $F/doc.sazanami
mkdir -p $F/doc.sazanami/ayu
mkdir -p $F/doc.sazanami/kappa
mkdir -p $F/doc.sazanami/misaki
mkdir -p $F/doc.sazanami/mplus
mkdir -p $F/doc.sazanami/oradano
mkdir -p $F/doc.sazanami/shinonome
cp  $srcdir/sazanami-20040629/doc/ayu/README.txt      $F/doc.sazanami/ayu
cp  $srcdir/sazanami-20040629/doc/kappa/README        $F/doc.sazanami/kappa
cp  $srcdir/sazanami-20040629/doc/misaki/misakib8.txt $F/doc.sazanami/misaki
cp  $srcdir/sazanami-20040629/doc/mplus/LICENSE_J     $F/doc.sazanami/mplus
cp  $srcdir/sazanami-20040629/doc/oradano/README.txt  $F/doc.sazanami/oradano
cp  $srcdir/sazanami-20040629/doc/shinonome/LICENSE   $F/doc.sazanami/shinonome
mkdir -p $1.app/Contents/Resources/reduce.resources
AA="$1.app/Contents/Resources/reduce.resources"
cp $srcdir/../../packages/redlog/mma/mma.awk          $AA
cp $srcdir/../../packages/redlog/qepcad/qepcad.awk    $AA
echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" > $P
echo "<!DOCTYPE plist SYSTEM \"file://localhost/System/Library/DTDs/PropertyList.dtd\">" >> $P
echo "<plist version=\"0.9\">" >> $P
echo "<dict>" >> $P
echo "<key>CFBundleInfoDictionaryVersion</key>" >> $P
echo "<string>6.0</string>" >> $P
echo "<key>CFBundleIdentifier</key>" >> $P
echo "<string>com.codemist.reduce.$1</string>" >> $P
echo "<key>CFBundleDevelopmentRegion</key>" >> $P
echo "<string>English</string>" >> $P
echo "<key>CFBundleLocalizations</key>" >> $P
echo "<array> <string>en</string> </array>" >> $P
echo "<key>CFBundleExecutable</key>" >> $P
echo "<string>$1</string>" >> $P
echo "<key>CFBundleIconFile</key>" >> $P
echo "<string>$IC.icns</string>" >> $P
echo "<key>CFBundleName</key>" >> $P
echo "<string>$1</string>" >> $P
echo "<key>CFBundlePackageType</key>" >> $P
echo "<string>APPDVI</string>" >> $P
echo "<key>CFBundleSignature</key>" >> $P
echo "<string>????</string>" >> $P
echo "<key>CFBundleVersion</key>" >> $P
echo "<string>1</string>" >> $P
echo "<key>CFBundleShortVersionString</key>" >> $P
echo "<string>1</string>" >> $P
echo "<key>CFBundleGetInfoString</key>" >> $P
echo "<string>$1 version 1, (C) 2010 Codemist Ltd</string>" >> $P
echo "<key>CFBundleLongVersionString</key>" >> $P
echo "<string>1, (C) 2010 Codemist Ltd</string>" >> $P
echo "<key>NSHumanReadableCopyright</key>" >> $P
echo "<string>Copyright 2010 Codemist Ltd</string>" >> $P
echo "<key>LSRequiresCarbon</key>" >> $P
echo "<true/>" >> $P
echo "<key>CSResourcesFileMapped</key>" >> $P
echo "<true/>" >> $P
echo "<key>ATSApplicationFontsPath</key>" >> $P
echo "<string>Fonts</string>" >> $P
echo "</dict>" >> $P
echo "</plist>" >> $P
echo -n "APPL????" >$1.app/Contents/PkgInfo
ln -f $1 $1.app/Contents/MacOS/$1
cp -f $srcdir/$IC.icns $1.app/Contents/Resources/$IC.icns
# Application frawework set up!
