
/*
   Additional header for resource specifications.  Only to
   be included by the module (main.c) which actually deals
   with the resources -- none of the others need it.

   C Cannam, 1992-3.
*/


static XtResource resources[] = {
  {
    XtNreduceHistoryMax,
    XtCReduceHistoryMax,
    XtRInt,
    sizeof(int),
    XtOffset(AppDataPtr,reduceHistoryMax),
    XtRImmediate,
    (caddr_t) 100,
  },
  {
    XtNreduceHistoryExcess,
    XtCReduceHistoryExcess,
    XtRInt,
    sizeof(int),
    XtOffset(AppDataPtr,reduceHistoryExcess),
    XtRImmediate,
    (caddr_t) 50,
  },
  {
    XtNwidthInColumns,
    XtCWidthInColumns,
    XtRInt,
    sizeof(int),
    XtOffset(AppDataPtr,widthInColumns),
    XtRImmediate,
    (caddr_t) 200, /* WN */
  },
  {
    XtNgraphicalLineSpace,
    XtCGraphicalLineSpace,
    XtRInt,
    sizeof(int),
    XtOffset(AppDataPtr,graphicalLineSpace),
    XtRImmediate,
    (caddr_t) 10,
  },
  {
    XtNhistoryPaneHeight,
    XtCHistoryPaneHeight,
    XtRDimension,
    sizeof(Dimension),
    XtOffset(AppDataPtr,historyPaneHeight),
    XtRImmediate,
    (caddr_t) 400,
  },
  {
    XtNinputPaneHeight,
    XtCInputPaneHeight,
    XtRDimension,
    sizeof(Dimension),
    XtOffset(AppDataPtr,inputPaneHeight),
    XtRImmediate,
    (caddr_t) 50,
  },
  {
    XtNfontSelectorHeight,
    XtCFontSelectorHeight,
    XtRDimension,
    sizeof(Dimension),
    XtOffset(AppDataPtr,fontSelectorHeight),
    XtRImmediate,
    (caddr_t) 400,
  },
  {
    XtNfontSelectorWidth,
    XtCFontSelectorWidth,
    XtRDimension,
    sizeof(Dimension),
    XtOffset(AppDataPtr,fontSelectorWidth),
    XtRImmediate,
    (caddr_t) 400,
  },
  {
    XtNreducePath,
    XtCReducePath,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr,reducePath),
    XtRImmediate,
    "$reduce/lisp/psl/linux/psl",
  },
  {
    XtNreduceName,
    XtCReduceName,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr,reduceName),
    XtRImmediate,
    "bpsl",
  },
  {
    XtNreduceInitFile,
    XtCReduceInitFile,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr,reduceInitFile),
    XtRImmediate,
    "$reduce/xr/bin/xr.red",
  },
  {
    XtNreduceImageFile,
    XtCReduceImageFile,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr,reduceImageFile),
    XtRImmediate,
    "$reduce/lisp/psl/linux/red/reduce.img",
  },
  {
    XtNreduceHelpFile,
    XtCReduceHelpFile,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr,reduceHelpFile),
    XtRImmediate,
    "$reduce/help/redref.info",
  },
  {
    XtNreduceOptions,
    XtCReduceOptions,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr,reduceOptions),
    XtRImmediate,
    "-td 12000000",
  },
  {
    XtNinputBufferSize,
    XtCInputBufferSize,
    XtRInt,
    sizeof(int),
    XtOffset(AppDataPtr,inputBufferSize),
    XtRImmediate,
    (caddr_t) 10000,
  },
  {
    XtNoutputBufferSize,
    XtCOutputBufferSize,
    XtRInt,
    sizeof(int),
    XtOffset(AppDataPtr,outputBufferSize),
    XtRImmediate,
    (caddr_t) 2000, 
  },
  {
    XtNoutputOnDelay,
    XtCOutputOnDelay,
    XtRInt,
    sizeof(int),
    XtOffset(AppDataPtr,outputOnDelay),
    XtRImmediate,
    (caddr_t) 100,
  },
  {
    XtNoutputOffDelay,
    XtCOutputOffDelay,
    XtRInt,
    sizeof(int),
    XtOffset(AppDataPtr,outputOffDelay),
    XtRImmediate,
    (caddr_t) 100,
  },
  {
    XtNnormalAsciiFont,
    XtCNormalAsciiFont,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr,normalAsciiFont),
    XtRImmediate,
    "-*-new century schoolbook-medium-r-*--14-*-*-*-*-*-*-*",
  },
  {
    XtNnormalGreekFont,
    XtCNormalGreekFont,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr,normalGreekFont),
    XtRImmediate,
    "-*-symbol-*-*-*-*-14-*-*-*-*-*-*-*",
  },
  {
    XtNnormalSymbolFont,
    XtCNormalSymbolFont,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr,normalSymbolFont),
    XtRImmediate,
    "-*-symbol-*-*-*-*-14-*-*-*-*-*-*-*",
  },
  {
    XtNsmallSymbolFont,
    XtCSmallSymbolFont,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr,smallSymbolFont),
    XtRImmediate,
    "-*-symbol-*-*-*-*-12-*-*-*-*-*-*-*",
  },
  {
    XtNsmallGreekFont,
    XtCSmallGreekFont,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr,smallGreekFont),
    XtRImmediate,
    "-*-symbol-*-*-*-*-11-*-*-*-*-*-*-*",
  },
  {
    XtNsmallAsciiFont,
    XtCSmallAsciiFont,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr,smallAsciiFont),
    XtRImmediate,
    "-*-new century schoolbook-medium-r-*--12-*-*-*-*-*-*-*",
  },
  {
    XtNinputPaneFont,
    XtCInputPaneFont,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr,inputPaneFont),
    XtRImmediate,
    "-*-courier-bold-r-*--14-*-*-*-*-*-*-*",
  },
  {
    XtNoutputTextFont,
    XtCOutputTextFont,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr,outputTextFont),
    XtRImmediate,
    "-*-times-bold-r-*--14-*-*-*-*-*-*-*",
  },
  {
    XtNinputHistoryFont,
    XtCInputHistoryFont,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr,inputHistoryFont),
    XtRImmediate,
    "-*-courier-medium-r-*--14-*-*-*-*-*-*-*",
  },
  {
    XtNoptionButtonFont,
    XtCOptionButtonFont,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr,optionButtonFont),
    XtRImmediate,
    "-*-helvetica-bold-r-*--14-*-*-*-*-*-*-*",
  },
  {
    XtNhelpTextFont,
    XtCHelpTextFont,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr,helpTextFont),
    XtRImmediate,
    "-*-helvetica-medium-r-*--14-*-*-*-*-*-*-*",
  },
  {
    XtNhelpXrefFont,
    XtCHelpXrefFont,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr,helpXrefFont),
    XtRImmediate,
    "-*-helvetica-bold-r-*--14-*-*-*-*-*-*-*",
  },
  {
    XtNverbatimFont,
    XtCVerbatimFont,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr,verbatimFont),
    XtRImmediate,
    "-*-courier-medium-r-*--14-*-*-*-*-*-*-*",
  },
  {
    XtNhelpTitleFont,
    XtCHelpTitleFont,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr,helpTitleFont),
    XtRImmediate,
    "-*-helvetica-bold-r-*--14-*-*-*-*-*-*-*",
  },
  {
    XtNpsTextFont,
    XtCPsTextFont,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr,psTextFont),
    XtRImmediate,
    "Courier",
  },
  {
    XtNpsSymbolFont,
    XtCPsSymbolFont,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr,psSymbolFont),
    XtRImmediate,
    "Symbol",
  },
  {
    XtNpsAsciiFont,
    XtCPsAsciiFont,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr,psAsciiFont),
    XtRImmediate,
    "Times-Roman",
  },
  {
    XtNscaleFonts,
    XtCScaleFonts,
    XtRBoolean,
    sizeof(Boolean),
    XtOffset(AppDataPtr,scaleFonts),
    XtRImmediate,
    (caddr_t) True,
  },
  {
    XtNreverseVideo,
    XtCReverseVideo,
    XtRBoolean,
    sizeof(Boolean),
    XtOffset(AppDataPtr,reverseGraph),
    XtRImmediate,
    (caddr_t) False,
  },
  {
    XtNuseGreekFont,
    XtCUseGreekFont,
    XtRBoolean,
    sizeof(Boolean),
    XtOffset(AppDataPtr,useGreekFont),
    XtRImmediate,
    (caddr_t)True,
  },
  {
    XtNuseSymbolFont,
    XtCUseSymbolFont,
    XtRBoolean,
    sizeof(Boolean),
    XtOffset(AppDataPtr,useSymbolFont),
    XtRImmediate,
    (caddr_t)True,
  },
  {
    XtNmatchBrackets,
    XtCMatchBrackets,
    XtRBoolean,
    sizeof(Boolean),
    XtOffset(AppDataPtr,matchBrackets),
    XtRImmediate,
    (caddr_t) True,
  },
  {
    XtNforceBracketMatch,
    XtCForceBracketMatch,
    XtRBoolean,
    sizeof(Boolean),
    XtOffset(AppDataPtr,forceBracketMatch),
    XtRImmediate,
    (caddr_t) False,
  },
  {
    XtNbracketFlashTime,
    XtCBracketFlashTime,
    XtRInt,
    sizeof(int),
    XtOffset(AppDataPtr,bracketFlashTime),
    XtRImmediate,
    (caddr_t) 1200,
  },
  {
    XtNmultiClickTime,
    XtCMultiClickTime,
    XtRInt,
    sizeof(int),
    XtOffset(AppDataPtr,multiClickTime),
    XtRImmediate,
    (caddr_t) 500,
  },
  {
    XtNlogToFile,
    XtCLogToFile,
    XtRBoolean,
    sizeof(Boolean),
    XtOffset(AppDataPtr,logToFile),
    XtRImmediate,
    (caddr_t) False,
  },
  {
    XtNignoreTeXFonts,
    XtCIgnoreTeXFonts,
    XtRBoolean,
    sizeof(Boolean),
    XtOffset(AppDataPtr,ignoreTeXFonts),
    XtRImmediate,
    (caddr_t) False,
  },
  {
    XtNpointerJump,
    XtCPointerJump,
    XtRBoolean,
    sizeof(Boolean),
    XtOffset(AppDataPtr,pointerJump),
    XtRImmediate,
    (caddr_t) True,
  },
  {
    XtNuseGraphics,
    XtCUseGraphics,
    XtRBoolean,
    sizeof(Boolean),
    XtOffset(AppDataPtr,useGraphics),
    XtRImmediate,
    (caddr_t) True,
  },
  {
    XtNpageMode,
    XtCPageMode,
    XtRBoolean,
    sizeof(Boolean),
    XtOffset(AppDataPtr,pageMode),
    XtRImmediate,
    (caddr_t) False,
  },
  {
    XtNlogFile,
    XtCLogFile,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr,logFile),
    XtRImmediate,
    "/dev/null",
  },
  {
    XtNfoundDefaults,
    XtCFoundDefaults,
    XtRBoolean,
    sizeof(Boolean),
    XtOffset(AppDataPtr,foundDefaults),
    XtRImmediate,
    (caddr_t)True,
  },
  {
    XtNkludgeTitleHeight,
    XtCKludgeTitleHeight,
    XtRDimension,
    sizeof(Dimension),
    XtOffset(AppDataPtr,kludgeTitleHeight),
    XtRImmediate,
    (caddr_t)20,
  },
};


static XrmOptionDescRec XReduceOptions[] = {
  {"-history",         "*reduceHistoryMax",    XrmoptionSepArg,   NULL},
  {"-hexcess",         "*reduceHistoryExcess", XrmoptionSepArg,   NULL},
  {"-linelength",      "*widthInColumns",      XrmoptionSepArg,   NULL},
  {"-graphspace",      "*graphicalLineSpace",  XrmoptionSepArg,   NULL},
  {"-ibuf",            "*inputBufferSize",     XrmoptionSepArg,   NULL},
  {"-obuf",            "*outputBufferSize",    XrmoptionSepArg,   NULL},
  {"-ondelay",         "*outputOnDelay",       XrmoptionSepArg,   NULL},
  {"-offdelay",        "*outputOffDelay",      XrmoptionSepArg,   NULL},
  {"-oheight",         "*historyPaneHeight",   XrmoptionSepArg,   NULL},
  {"-iheight",         "*inputPaneHeight",     XrmoptionSepArg,   NULL},
  {"-fheight",         "*fontSelectorHeight",  XrmoptionSepArg,   NULL},
  {"-fwidth",          "*fontSelectorWidth",   XrmoptionSepArg,   NULL},
  {"-rpath",           "*reducePath",          XrmoptionSepArg,   NULL},
  {"-rname",           "*reduceName",          XrmoptionSepArg,   NULL},
  {"-rimage",          "*reduceImageFile",     XrmoptionSepArg,   NULL},
  {"-rinitfile",       "*reduceInitFile",      XrmoptionSepArg,   NULL},
  {"-rhelpfile",       "*reduceHelpFile",      XrmoptionSepArg,   NULL},
  {"-asciifn",         "*normalAsciiFont",     XrmoptionSepArg,   NULL},
  {"-greekfn",         "*normalGreekFont",     XrmoptionSepArg,   NULL},
  {"-symbolfn",        "*normalSymbolFont",    XrmoptionSepArg,   NULL},
  {"-smallasciifn",    "*smallAsciiFont",      XrmoptionSepArg,   NULL},
  {"-smallgreekfn",    "*smallGreekFont",      XrmoptionSepArg,   NULL},
  {"-smallsymfn",      "*smallSymbolFont",     XrmoptionSepArg,   NULL},
  {"-inputpanefn",     "*inputPaneFont",       XrmoptionSepArg,   NULL},
  {"-inputhistfn",     "*inputHistoryFont",    XrmoptionSepArg,   NULL},
  {"-outputtextfn",    "*outputTextFont",      XrmoptionSepArg,   NULL},
  {"-buttonfn",        "*optionButtonFont",    XrmoptionSepArg,   NULL},
  {"-helptextfn",      "*helpTextFont",        XrmoptionSepArg,   NULL},
  {"-helpxreffn",      "*helpXrefFont",        XrmoptionSepArg,   NULL},
  {"-helptitlefn",     "*helpTitleFont",       XrmoptionSepArg,   NULL},
  {"-verbfn",          "*verbatimFont",        XrmoptionSepArg,   NULL},
  {"-pstextfn",        "*psTextFont",          XrmoptionSepArg,   NULL},
  {"-pssymbolfn",      "*psSymbolFont",        XrmoptionSepArg,   NULL},
  {"-psasciifn",       "*psAsciiFont",         XrmoptionSepArg,   NULL},
  {"-logfile",         "*logFile",             XrmoptionSepArg,   NULL},
  {"-bflashtime",      "*bracketFlashTime",    XrmoptionSepArg,   NULL},
  {"-mclicktime",      "*multiClickTime",      XrmoptionSepArg,   NULL},
  {"-usegreek",        "*useGreekFont",        XrmoptionNoArg,  "True"},
  {"-usenogreek",      "*useGreekFont",        XrmoptionNoArg, "False"},
  {"-usesymbol",       "*useSymbolFont",       XrmoptionNoArg,  "True"},
  {"-usenosymbol",     "*useSymbolFont",       XrmoptionNoArg, "False"},
  {"-scalefns",        "*scaleFonts",          XrmoptionNoArg,  "True"},
  {"-noscalefns",      "*scaleFonts",          XrmoptionNoArg, "False"},
  {"-reverse",         "*reverseVideo",        XrmoptionNoArg,  "True"},
  {"-forward",         "*reverseVideo",        XrmoptionNoArg, "False"},
  {"-bmatch",          "*matchBrackets",       XrmoptionNoArg,  "True"},
  {"-bnomatch",        "*matchBrackets",       XrmoptionNoArg, "False"},
  {"-bforcematch",     "*forceBracketMatch",   XrmoptionNoArg,  "True"},
  {"-bnoforcematch",   "*forceBracketMatch",   XrmoptionNoArg, "False"},
  {"-log",             "*logToFile",           XrmoptionNoArg,  "True"},
  {"-nolog",           "*logToFile",           XrmoptionNoArg, "False"},
  {"-texfns",          "*ignoreTeXFonts",      XrmoptionNoArg, "False"},
  {"-notexfns",        "*ignoreTeXFonts",      XrmoptionNoArg,  "True"},
  {"-pagemode",        "*pageMode",            XrmoptionNoArg,  "True"},
  {"-nopagemode",      "*pageMode",            XrmoptionNoArg, "False"},
  {"-pointerjump",     "*pointerJump",         XrmoptionNoArg,  "True"},
  {"-nopointerjump",   "*pointerJump",         XrmoptionNoArg, "False"},
};

