/*
 *   retail - a logfile monitoring utility
 *
 *   Copyright (C) Y2K (2000) A.L.Lambert
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* global variables	*/
short int retval;	/* what value do we return at the end of all this	*/
short int debug;	/* do we go into debug mode?  (developer test only	*/
FILE *in_file;		/* the files we'll be reading for input			*/
FILE *in_stat;		/* the file we're using to store our place in in_file	*/
char *st_filename;	/* the var we store the name of the offset file 	*/
	
char **files;		/* an array of all the file's we'll be opening		*/
char *suffix;		/* suffix of the file we open to store stats in		*/
char *prefix;		/* prefix directory for where we put stats files	*/

/* structure for our info on the file	*/
typedef struct {
	long int ipos;	/* last position as an int		*/
	char apos[64];	/* last position in ascii		*/
	char *last_line; /* last known line in the file		*/
} FILE_STAT;

FILE_STAT f;

/* our local functions */
int proc_args(int argc, char **argv);
int open_infile(char *fname);
int open_stfile(char *fname);
int read_stfile();
int read_infile();
int write_stfile();
int close_files();
int local_cleanup();
