# TapiocaStor Enterprise Backup
# Copyright 2002 The TapiocaStor Group
#
# Released under the Ruby license, see http://www.ruby-lang.org

# Written January 2002 Eric Lee Green <eric@badtux.org>
# This is an example of how to use the AES module.

require 'aes'

# create a new AES object. Note that I use all caps. 
a=AES.new

# the key must be hex, either 32, 48, or 64 chars, for
# 128, 192, or 256 bits total data. Here I use a hex string
# that is kind of a cryptographic joke:
a.set_key('deadbeefdeadbeefdeadbeefdeadbeef')

# the 'encrypt' method uses ECB to encode a single 128-bit binary block of
# data. It returns a 128-bit encoded block of data. it ONLY accepts 128 bit
# blocks of data. See cfb_* for more info
b=a.encrypt("deadbeefdeadbeef")

# then decrypt our now-encrypted block of data. 
print a.decrypt(b),"\n"  # should print deadbeefdeadbeef

# okay, CFB-128 mode accepts arbitrary-length strings. You must,
# however, salt it prior to encrypting or decrypting. The salt value
# is basically part of the key and must be a different value for each
# stream of data that you encrypt or decrypt, see aescrypt for more
# info (the cfb code in aescrypt and the cfb code in twofish-py and
# aes-rb are identical). The salt should basically be a 128-bit string
# that you might, e.g., get from /dev/urandom.

a.cfb_salt('128bitbinaryvalu') # must be a 128-bit BINARY value

b=a.cfb_encrypt("now is the time for all good men to come to the aid of their country.\n")

# to decrypt the string, you must salt the cfb with the exact same salt
# value that it was encrypted with. It's okay to send the salt in plain
# text pre-pending the encrypted data, that's what I do with the 'aescrypt'
# utility. 
a.cfb_salt('128bitbinaryvalu') # must be a 128-bit BINARY value
30
print a.cfb_decrypt(b)
