# TapiocaStor Enterprise Backup
# Copyright 2002 The TapiocaStor Group
#
# Released under the Ruby license, see http://www.ruby-lang.org

# Written January 2002 Eric Lee Green <eric@badtux.org>
# This tests some of the AES test vectors.

require "aes"

VECTOR_FILE="aes-ecb-tbl.txt"

# simple state table to parse the ecb file.

# this is the 'blank line' state that skips blank lines.
def getline(fh)
    s=""
    while s == ""
	s=fh.gets
	if (s==nil)
	    return nil  # eof, sigh. 
	end
	s.strip!
    end
    if s==""
	return nil
    end
    return s.split("=")
end
    
def hex2str(hexval)
    retval=""
    while hexval != ""
	i=hexval[0..1].hex
	hexval=hexval[2..-1]
	retval=retval+i.chr
	if hexval==nil
	    return retval
	end
    end
    return retval
end
	

fh=open("aes-ecb-tbl.txt","r")

# now for the actual state table: we have four states, I, KEY, PT, CT.

state=0
str=getline(fh)

while str != nil
    if state==0
	if (str[0] != "I")
	    print("\nstr='#{str}'\nFinished.\n")
	    exit 0
	end
	i=Integer(str[1])
	print "#{i}"
	str=getline(fh)
	state=1
    elsif state==1
	print "."
	if (str[0]!="KEY")
 	    raise "[1]Illegal file format for aes-ecb-tbl.txt, exiting."
	end
	key=str[1]
	str=getline(fh)
	if (str[0]=="CT")
	    state=3
	else
	    state=2
	end
    elsif state==2
	print "."
	if (str[0]!="PT")
 	    raise "[2]Illegal file format for aes-ecb-tbl.txt, exiting."
	end
	pt=hex2str(str[1])
	str=getline(fh)
	if (str[0]=="CT")
	    state=3
	else
	    state=4
	end
    elsif state==3
	print "."
	if (str[0]!="CT")
 	    raise "[2]Illegal file format for aes-ecb-tbl.txt, exiting."
	end
	ct=hex2str(str[1])
	str=getline(fh)
	if (str==nil)
	    state=4
	elsif (str[0]=="PT")
	    state=2
	else
	    state=4
	end
    elsif state==4
	a=AES.new
	a.set_key(key)
	new_ct=a.encrypt(pt)
	
	new_pt=a.decrypt(ct)
	if ct!=new_ct
	    print "\nEncrypt test #{i} failed: expected '#{ct}', got '#{new_ct}'.\n"
	end
	
	if (pt!=new_pt)
	    print "\nDecrypt test #{i} failed: expected '#{pt}', got '#{new_pt}'.\n"
	end
	
	state=0 # sigh!
    end
	    

end  # of the loop. 
