# Shows an error page when catches an exception.
class CKErrorPage < CKComponent
	attr_accessor :error

	def version
		CKApplication.version
	end

	def error_class
		error.class
	end

	def reason
		error.message
	end

	def backtrace
		error.backtrace
	end

	def error=( e )
		@error = e

		options = application.log_options
		if options['file'] then
			begin
				log = CKLog.new options
				log.fatal "#{error_class} at #{application.name}: #{reason}"
				log.fatal backtrace.join("\n")
			rescue CKLog::FileSizeError
				@warning = "Can't write log to file. Check limit of file size."
			end
		end
	end

	def warning?
		if @warning then
			true
		else
			false
		end
	end
end
