require 'div/div'
require 'div/tofusession'
require 'aiura'
require 'rinda/tuplespace'

module Div
  module StoryDiv
    def initialize(*args)
      super(*args)
      @first_ask = true
    end

    def write_ask
      return if @first_ask
      session.write_ask(self)
    ensure
      @first_ask = false
    end

    def take_ans
      session.take_ans(self)
    end

    def ask_cmd(options=nil)
      begin
        write_ask
        cmd, params, cntxt = take_ans
      end until (options.nil? || options.include?(cmd))
      return cmd, params, cntxt
    end
  end

  module StorySession
    def initialize(*args)
      super(*args)
      @extend = 3000
      @place = Rinda::TupleSpace.new
    end

    def write_ans(div, cmd, params, cntxt)
      @place.write([cmd, params, cntxt, 'prompter-ans', div], self)
    end

    def write_ask(div)
      @place.write(['prompter-ask', div], @extend)
    end
    
    def take_ask(div)
      @place.take(['prompter-ask', div], @extend)
    end

    def take_ans(div)
      @place.take([nil, nil, nil, 'prompter-ans', div], self)
    end

    def ans(div, cmd, params, cntxt)
      write_ans(div, cmd, params, cntxt)
      take_ask(div)
    rescue
      p($!) if $DEBUG
      @extend = -1
    end

    def expires
      Time.now + @extend
    end

    def renew
      @extend
    end
  end
end

class AiuraStory
  def initialize(div)
    @div = div
  end

  def start
    Thread.start { main }
  end

  def main
    loop do
      @div.aiura = nil
      boy, girl = @div.ask_names
      aiura = Aiura.new(boy, girl)
      @div.aiura = aiura
      (aiura.history.size-1).times do 
        @div.ask_next
        @div.show_next_line
      end
      @div.ask_restart
    end
  end
end

class AiuraDiv < Div::Div
  include Div::StoryDiv
  include Div::KCode

  set_erb('aiura.erb')
  
  def initialize(session)
    super(session)
    @ask = nil
    @display = nil
    @lineno = 1
    @first = true
    @story = AiuraStory.new(self)
    @story.start
  end
  attr_accessor :display

  def to_names(params)
    boy ,= params['boy']
    girl ,= params['girl']
    return nil if boy.nil? || boy == ''
    return nil if girl.nil? || girl == ''
    [kconv(boy), kconv(girl)]
  end

  def ask_names
    begin
      @ask = 'names'
      cmd, params, cntxt = ask_cmd(['aiura'])
      boy, girl = to_names(params)
    end until(boy)
    return boy, girl
  end

  def ask_next
    @ask = 'next'
    ask_cmd(['next'])
  end

  def ask_restart
    @ask = 'restart'
    ask_cmd(['restart'])
  end

  def show_next_line
    @lineno += 1
  end

  def aiura=(it)
    @aiura = it
    return if it.nil?
    str = ""
    it.display(str)
    @display = str.split("\n")
    @lineno = 1
  end

  def do_else(context, params)
    cmd, = params['div_cmd']
    session.ans(self, cmd, params, context)
  end
end

class AiuraBaseDiv < Div::Div
  set_erb('aiura_base.erb')
  
  def initialize(session)
    super(session)
    @aiura_div = AiuraDiv.new(session)
  end
end

class AiuraTofuSession < Div::TofuSession
  include Div::StorySession

  def initialize(bartender, hint=nil)
    super(bartender, hint)
    @base = AiuraBaseDiv.new(self)
  end

  def do_GET(context)
    update_div(context)
    context.res_header('content-type', 'text/html; charset=euc-jp')
    context.res_body(@base.to_html(context))
  end
end

if __FILE__ == $0
  require 'drb/drb'
  require 'tofu/proxy'
  
  tofu = Tofu::Bartender.new(AiuraTofuSession)
  DRb.start_service('druby://localhost:7643', tofu)
  DRb.thread.join
end
