require 'div'
require 'parsedate'

class PaperDiv < Div::Div
  set_erb('paper.erb')

  def initialize(session, paper)
    super(session)
    @paper = paper
    @mode = :browse
  end

  def remove(key)
    @paper.remove(key, session.username)
  end

  def add(text, commentator)
    @paper.add(session.username, text, commentator.split)
  end

  def comment(key, text, succ)
    @paper.comment(key, session.username, text, succ == 'OK')
  end

  def to_args(params)
    key, = params['key']
    text, = params['text']
    commentator, = params['commentator']
    status, = params['status']
    return key, text, commentator, status
  end

  def do_remove(context, params)
    key, = to_args(params)
    remove(key)
  end

  def do_edit(context, params)
    @mode = :edit
  end
  
  def do_browse(context, params)
    @mode = :browse
  end

  def do_add(context, params)
    key, text, commentator = to_args(params)
    add(text, commentator)
    @mode = :browse
  end

  def do_comment(context, params)
    key, text, commentator, status = to_args(params)
    comment(key, text, status)
  end
end

