require 'div/div'
require 'div/js'
require 'div/tofusession'

require 'board'

class BoardLogDiv < Div::Div
  set_erb('board_log.erb')
  
  def initialize(session)
    super(session)
    @lines = 10
  end
  
  def board
    session.board
  end
end

class BoardAddDiv < Div::Div
  include Div::KCode

  set_erb('board_add.erb')

  def initialize(session)
    super(session)
  end

  def board
    session.board
  end

  def do_add(context, params)
    value ,= params['message']
    board.add(@session.nick, kconv(value))
    session.reset_interval
  end
end

class BoardNickDiv < Div::Div
  include Div::KCode

  set_erb('board_nick.erb')

  def initialize(session)
    super(session)
  end

  def do_nick(context, params)
    nick ,= params['nick']
    return if nick.size == 0
    @session.nick = kconv(nick)
  end
end

class BoardBaseDiv < Div::Div
  set_erb('board_base.erb')
  
  def initialize(session)
    super(session)
    @add_div = BoardAddDiv.new(session)
    @nick_div = BoardNickDiv.new(session)
    @log_div = BoardLogDiv.new(session)
  end
end

class BoardTofuSession < Div::TofuSession
  @@board = Board.new

  def initialize(bartender, hint=nil)
    super(bartender, hint)
    @base = BoardBaseDiv.new(self)
    @nick = nil
    reset_interval
  end
  attr_accessor :nick, :interval

  def reset_interval
    @interval = 3000
  end

  def incr_interval
    @interval += 500 if @interval <= 60000
  end

  def board
    @@board
  end

  def do_GET(context)
    incr_interval

    update_div(context)

    return if do_inner_html(context)

    body =  @base.to_html(context)
    context.res_header('content-type', 'text/html; charset=euc-jp')
    context.res_body(body)
  end
end

if __FILE__ == $0
  require 'drb/drb'
  require 'tofu/proxy'

  tofu = Tofu::Bartender.new(BoardTofuSession)
  DRb.start_service('druby://localhost:7643', tofu)
  DRb.thread.join
end
