=begin
= Description
    net-pingsimple - A simple version of "ping" using Ruby
= Prerequisites
Win32 users need the "win32_popen" package by Park Heesob.  Available on the
RAA.
= Synopsis
    require 'net/pingsimple'

    # check with udp or tcp ping

    t = Net::PingTCP.new(host)
    u = Net::PingUDP.new(host)
    e = Net::PingExternal.new(host)

    if t.ping?
       puts "Host is alive"
       unless t.warning.nil?
          puts "Warning encountered: " + t.warning
       end
    else
       puts "Couldn't connect to host: " + t.exception
    end
= Ping Classes
--- PingTCP
    Attempts to open a connection using TCPSocket.  A successful open means
    the ping was successful.
--- PingUDP
    Attempts to open a connection using UDPSocket and sends a small string.  If
    the return string matches, the ping was successful.
--- PingExternal
    Uses the 'open3' module and calls your system's local 'ping' command.  If
    nothing is sent to stderr (or only a warning was sent), the ping was
    successful.
== Constants
--- VERSION
    The current version number.
== Class Methods
--- PingXXX.new(host,port=7,timeout=5)
    Creates a new Ping object of the appropriate type (PingTCP, PingUDP or
    PingExternal).
--- PingTCP.econnrefused
    Returns the value of the (({econnrefused})) class variable (true or
    false).
--- PingTCP.econnrefused=(boolean)
    Sets the default behavior for how to interpret Errno::ECONNREFUSED.  By
    default this is set to false.  That is, an ECONNREFUSED error will return
    false for a ping attempt.  Setting this to true will cause ECONNREFUSED
    errors to return true for a ping attempt.

    Note that this method is for PingTCP only.

    See the FAQ below for more details if you want to know why I did things
    this way.
--- PingTCP.ecr
    An alias for (({PingTCP.econnrefused}))
--- PingTCP.ecr=(boolean)
    An alias for (({PingTCP.econnrefused=}))
--- PingXXX.VERSION
    Returns the current version number (as a string).
== Instance Methods
--- PingSimple#ping?
    Returns one of two values - true or false.  If you want to know *why* it
    failed, you can check the 'exception' attribute.
--- PingSimple#ping
    An alias for (({ping?}))
--- PingSimple#host
    Returns the host name.
--- PingSimple#host=(string)
    Set the host name.  An IP address is also valid.
--- PingSimple#port
    Returns the port number.
--- PingSimple#port=(port_number = 7)
    Set the port number to open socket connections on.  The default is 7 (or
    whatever your 'echo' port is set to).
--- PingSimple#data
    Returns the string being sent to UDP connections.
--- PingSimple#data(string = "ping")
    The string sent in UDP connections.
--- PingSimple#time
    Returns the time that is used as the timeout value.
--- PingSimple#time=(integer = 5)
    The amount of time before the timeout module raises a TimeoutError
    Exception during connection attempts.
--- PingSimple#exception
    If an exception is raised, it is caught and stored in this attribute.  It
    is not raised in your code.  Note that warnings are not considered
    exceptions
--- PingSimple#warning
    If an error is encountered and its error string matches /warning/i, then
    it is stored in this attribute
= NOTES
If a host is down ((*IT IS CONSIDERED A FAILED PING*)), and the "no answer from
<host>" text is assigned to the ((<exception|PingSimple#exception>)) attribute.
You may disagree with this behavior, in which case you need merely check the
exception attribute against a regex as a simple workaround.
= FAQ
Q: "Why don't you return exceptions if a connection fails?"

A: Because ping is only meant to return one of two things - success or failure.
It's very simple.  If you want to find out *why* the ping failed, you can check
the ((<exception|PingSimple#exception>)) attribute.  You may also want to
check for non-nil values in the ((<warning|PingSimple#warning>)) attribute.

Q: "I know the host is alive, but a TCP or UDP ping tells me otherwise.  What gives?"

A: It's possible that the echo port has been disabled on the remote
host for security reasons.  You could also have a firewall issue.  Your
best best is to specify a different port or to use PingExternal instead.

Q: "What warnings are you referring to?"

A: This is the one that I've seen personally: ((*'Warning: time of day goes
back, taking countermeasures.'*)).

Q: "Why does TCP ping return false when I know it should return true?"

A: By default ECONNREFUSED errors will return a value of false.  This is contrary
to what most other folks do for TCP pings.  The problem with their philosphy
is that you can get false positives if a firewall blocks the route to the
host.  The problem with my philosophy is that you can get false negatives
if there is no firewall (or it's not blocking the route).  Given the alternatives
I chose the latter.  You can always change the default behavior by using the
'econnrefused' class method.

Q: "Couldn't you use traceroute information to tell for sure?"

A: I *could* but I won't so don't bug me about it.  It's far more effort than it's
worth.  Besides, this is pingsimple, not pingcomplex. :)
= Known Bugs
    None known.  Please report any bugs on the project page at
    http://ruby-netutils.sf.net.
= Future Plans
    Add an PingICMP class (help wanted), though see arton's icmpping package on the RAA.
= License
Ruby's
= Copyright
(C) 2003, 2004 Daniel J. Berger
All Rights Reserved
= Warranty
	This package is provided "as is" and without any express or
	implied warranties, including, without limitation, the implied
	warranties of merchantability and fitness for a particular purpose.
= Author
    Daniel J. Berger
    djberg96 at yahoo dot com
    rubyhacker1 on IRC
=end
