#!/bin/env ruby
#
# run this from many nodes in the same nfs mounted directory
# if it runs for a few days you should be fine
# use monitor.rb to watch the progress and gather stats
#

require 'ftools'
require 'tempfile'
require 'socket'
require 'nfsstore.rb'

puts "using NFSStore::VERSION <#{ NFSStore::VERSION }>"


path = ARGV[0] || "nfs.db"
list_size = Integer(ARGV[1] || (1 << 16))
sleeptime = Integer(ARGV[2] || 1)
db = NFSStore.new path
stolenlock = 0 
hostname = Socket::gethostname
div = '=' * 79
loopno = 0
list = nil

loop do
  puts div, div
  puts "#{ hostname } loop #{ loopno }"

  db.transaction do
    db['list'] = [] unless db.root? 'list'

    list = db['list']

    list << [list.size, hostname, Time.now.to_f]

    if list.size >= list_size
      i = 0
      while((a = list[i]) and (b = list[i + 1]))
        a, b = a[0], b[0]
        raise "UNSORTED!" unless(a.succ == b)
        i += 1
      end
      printf "ALL <%d> ELEMENTS SORTED\n", list.size
      list.clear
    end

    db['list'] = list
  end

  list.last(8).each{|e| p e}

  sleep sleeptime 
  sleep rand
  loopno += 1
  puts
end
