require 'test/unit'
require 'rexml/document'

class OrderTester < Test::Unit::TestCase
   def setup
     @doc = REXML::Document.new(TESTDOC)
     @items = REXML::XPath.match(@doc,'//x')
   end
   def test_first_element
     assert_equal '1', @items[0].attributes['id']
   end
   def test_second_element
     assert_equal '2', @items[1].attributes['id']
   end
   def test_third_element
     assert_equal '3', @items[2].attributes['id']
   end
end

TESTDOC = <<END
<a>
  <b/>
  <x id='1'/>
  <c/>
  <d>
    <x id='2'/>
  </d>
  <x id='3'/>
</a>
END

