#!/usr/bin/env ruby
#
# $Id: tkspell.rb,v 1.4 2002/04/15 02:15:45 ianmacd Exp $

require 'tk'
require 'google'

KEY = File.open("#{ENV['HOME']}/.google_key") {|kf| kf.readline.chomp}

class SearchBox
  def spellcheck(p)
    google = Google::Search.new(KEY)
    google.spell(p) || p
  end

  def initialize
    pad = { 'padx' => 10, 'pady' => 10 }
    padleft = { 'padx' => 10, 'pady' => 10, 'side' => 'left' }

    root = TkRoot.new { title 'Google Spell-check' }
    phrase = TkVariable.new
    dospellcheck = proc { phrase.value = spellcheck(phrase.value) unless
			    phrase.value.empty? }
    TkLabel.new(root) {
      text 'Phrase'
      pack
    }
    TkEntry.new(root) {
      textvariable phrase
      width 30
      pack
    }
    TkButton.new(root) {
      text "Check"
      command dospellcheck
      pack(padleft)
    }
    TkButton.new(root) {
      text "Clear"
      command proc { phrase.value = nil }
      pack(padleft)
    }
    TkButton.new(root) {
      text "Cancel"
      command proc { exit }
      pack(padleft)
    }
  end
end

SearchBox.new
Tk.mainloop
