# $Id: ruby-google.spec,v 1.13 2003/05/20 07:12:06 ianmacd Exp $
#
Summary: Ruby/Google module
Name: ruby-google
Version: 0.5.1
Release: 1
License: GPL
Group: Applications/Ruby
Source: http://www.caliban.org/files/ruby/%{name}-%{version}.tar.gz
URL: http://www.caliban.org/ruby
Packager: Ian Macdonald <ian@caliban.org>
BuildRoot: /var/tmp/%{name}-%{version}
BuildRequires: ruby
Requires: ruby, ruby-SOAP4R >= 1.4.8

%description
Ruby/Google is a Ruby interface to the Google Web API. Information on the
Google Web API can be found at http://www.google.com/apis/

%prep
%setup
make config ROOT=$RPM_BUILD_ROOT/%{_prefix}
make setup

%clean 
rm -rf $RPM_BUILD_ROOT

%install
rm -rf $RPM_BUILD_ROOT
make install
mkdir -p $RPM_BUILD_ROOT%{_mandir}/man3
install google.3 $RPM_BUILD_ROOT%{_mandir}/man3/google.3
gzip -9 $RPM_BUILD_ROOT%{_mandir}/man3/google.3

find $RPM_BUILD_ROOT%{_prefix} -type f -print | \
	ruby -pe 'sub(%r(^'$RPM_BUILD_ROOT'), "")' > %{name}-%{version}-filelist

%files -f %{name}-%{version}-filelist
%doc COPYING CHANGES google.html README
%doc -P examples/
%defattr(-,root,root)

%changelog
* Tue May 20 2003 Ian Macdonald <ian@caliban.org> 0.5.1-1
- 0.5.1
- replace Object#type with Object#class to silence warnings in Ruby 1.8

* Fri Jan 17 2003 Ian Macdonald <ian@caliban.org> 0.5.0-1
- 0.5.0
- use WSDL driver in new SOAP4R 1.4.8

* Mon Sep  9 2002 Ian Macdonald <ian@caliban.org>
- 0.4.2
- oe and ie parameters in Google::Search are now deprecated

* Thu May 23 2002 Ian Macdonald <ian@caliban.org>
- 0.4.1
- minor code-clean up to improve legibility
- fixed a couple of bugs in the RD documentation
- build using a Makefile

* Wed May  1 2002 Ian Macdonald <ian@caliban.org>
- 0.4.0
- directoryCategories member of the Struct::Response returned by
  Search.new is now of type Struct::DirectoryCategory
- the directoryName member of the Struct::ResultElement returned by
  ResultElement.new was renamed fullViewableName
- the directoryEncoding member of the the Struct::ResultElement was renamed
  specialEncoding
- a new class method, Search.query_length_ok?, was added
- a new class method, Search.query_words_ok?, was added
- a new class method, Search.query_sites_ok?, was added
- a new class method, Search.query_ok?, was added
- a new class method, Search.restrict, was added

* Mon Apr 22 2002 Ian Macdonald <ian@caliban.org>
- 0.3.0
- Search#search now returns Struct::Response instead of Google::Search
- resultElements member of the Struct::Response returned by Search#search
  contains Struct::ResultElement objects. These no longer contain the instance
  variable @attribute.
- numerous improvements to documentation

* Sun Apr 14 2002 Ian Macdonald <ian@caliban.org>
- 0.2.0
- add HTTP proxy support
- documentation referred to 'results' hash. Should have been 'resultElements'
- the 'search' method now returns a Struct instead of a hash
- the 'resultElements' element of the Struct returned by the 'search' method is
  now also a Struct, not a hash
- track defined methods using class variables, in order to avoid method
  redefinition warnings in SOAP4R when running Ruby with -w
- added new example program: tkspell.rb
- make example programs pull key from ~/.google_key

* Thu Apr 11 2002 Ian Macdonald <ian@caliban.org>
- 0.1.0
