# $Id: ruby-google.spec,v 1.16 2006/02/08 01:06:35 ianmacd Exp $
#
Summary: Ruby/Google library for access to the Google Web API
Name: ruby-google
Version: 0.6.0
Release: 1
License: GPL
Group: Applications/Ruby
Source: http://www.caliban.org/files/ruby/%{name}-%{version}.tar.gz
URL: http://www.caliban.org/ruby
Packager: Ian Macdonald <ian@caliban.org>
BuildRoot: /var/tmp/%{name}-%{version}
BuildRequires: ruby
Requires: ruby, ruby-SOAP4R >= 1.5.5

%description
Ruby/Google is a Ruby interface to the Google Web API. Information on the
Google Web API can be found at http://www.google.com/apis/

%prep
%setup
make config ROOT=$RPM_BUILD_ROOT%{_prefix}
make setup

%clean 
rm -rf $RPM_BUILD_ROOT

%install
rm -rf $RPM_BUILD_ROOT
make install
mkdir -p $RPM_BUILD_ROOT%{_mandir}/man3
install google.3 $RPM_BUILD_ROOT%{_mandir}/man3/google.3
gzip -9 $RPM_BUILD_ROOT%{_mandir}/man3/google.3

find $RPM_BUILD_ROOT%{_prefix} -type f -print | \
	ruby -pe 'sub(%r(^'$RPM_BUILD_ROOT'), "")' > %{name}-%{version}-filelist

%files -f %{name}-%{version}-filelist
%doc COPYING CHANGES google.html README
%doc examples/
%defattr(-,root,root)

%changelog
* Wed Feb  8 2006 Ian Macdonald <ian@caliban.org> 0.6.0-1
- 0.6.0
- New method, Search#utf8, allows user to request conversion of query strings
  to UTF-8, prior to sending to Google.
- SOAP4R 1.5.5 and, consequently, Ruby 1.8.3 deprecate createDriver in favour
  of create_rpc_driver within the SOAP::WSDLDriverFactory class.
- Other minor fixes have been made.

* Tue May 20 2003 Ian Macdonald <ian@caliban.org> 0.5.1-1
- 0.5.1
- Replace Object#type with Object#class to silence warnings in Ruby 1.8.

* Fri Jan 17 2003 Ian Macdonald <ian@caliban.org> 0.5.0-1
- 0.5.0
- Use WSDL driver in new SOAP4R 1.4.8.

* Mon Sep  9 2002 Ian Macdonald <ian@caliban.org>
- 0.4.2
- oe and ie parameters in Google::Search are now deprecated.

* Thu May 23 2002 Ian Macdonald <ian@caliban.org>
- 0.4.1
- Minor code-clean up to improve legibility.
- Fixed a couple of bugs in the RD documentation.
- Build using a Makefile.

* Wed May  1 2002 Ian Macdonald <ian@caliban.org>
- 0.4.0
- directoryCategories member of the Struct::Response returned by
  Search.new is now of type Struct::DirectoryCategory.
- The directoryName member of the Struct::ResultElement returned by
  ResultElement.new was renamed fullViewableName.
- The directoryEncoding member of the the Struct::ResultElement was renamed
  specialEncoding.
- A new class method, Search.query_length_ok?, was added.
- A new class method, Search.query_words_ok?, was added.
- A new class method, Search.query_sites_ok?, was added.
- A new class method, Search.query_ok?, was added.
- A new class method, Search.restrict, was added.

* Mon Apr 22 2002 Ian Macdonald <ian@caliban.org>
- 0.3.0
- Search#search now returns Struct::Response instead of Google::Search.
- resultElements member of the Struct::Response returned by Search#search
  contains Struct::ResultElement objects. These no longer contain the instance
  variable @attribute.
- Numerous improvements to documentation.

* Sun Apr 14 2002 Ian Macdonald <ian@caliban.org>
- 0.2.0
- Add HTTP proxy support.
- Documentation referred to 'results' hash. Should have been 'resultElements'.
- The 'search' method now returns a Struct instead of a hash.
- The 'resultElements' element of the Struct returned by the 'search' method is
  now also a Struct, not a hash.
- Track defined methods using class variables, in order to avoid method
  redefinition warnings in SOAP4R when running Ruby with -w.
- Added new example program: tkspell.rb.
- Make example programs pull key from ~/.google_key

* Thu Apr 11 2002 Ian Macdonald <ian@caliban.org>
- 0.1.0
