=begin
= Description
    Provides hostname and ip address information for a given host.
= Synopsis
    require 'sys/host'
    include Sys

    p Host.hostname
    p Host.ip_addr
    
    # Windows
    Host.info{ |h|
       p h
    }

= Constants
--- VERSION
    Returns the current version number of this package (as a string)
= Class Methods
--- Host.hostname
    Returns the hostname of the current host.  This may or not return
    the FQDN, depending on your system.
--- Host.ip_addr
    Returns a list of IP addresses for the current host (yes, it is
    possible to have more than one).
== Windows Only Class Method
--- Host.info(host=localhost){ |h| ... }
	Yields a HostInfo struct for each network adapter on ((|host|)).  A
	HostInfo struct contains the following members:
	
	* arp_always_source_route?
    * arp_use_ether_snap?
    * caption
    * database_path
    * dead_gw_detect_enabled?
    * default_ip_gateway
    * default_tos
    * default_ttl
    * description
    * dhcp_enabled?
    * dhcp_lease_expires
    * dhcp_lease_obtained
    * dhcp_server
    * dns_domain
    * dns_domain_suffix_search_order
    * dns_enabled_for_wins_resolution?
    * dns_host_name
    * dns_server_search_order
    * domain_dns_registration_enabled?
    * forward_buffer_memory
    * full_dns_registration_enabled?
    * gateway_cost_metric
    * igmp_level
    * index
    * ip_address
    * ip_connection_metric
    * ip_enabled?
    * ip_filter_security_enabled?
    * ip_port_security_enabled?
    * ip_sec_permit_ip_protocols
    * ip_sec_permit_tcp_ports
    * ip_sec_permit_udp_ports
    * ip_subnet
    * ip_use_zero_broadcast
    * ipx_address
    * ipx_enabled?
    * ipx_frame_type
    * ipx_media_type
    * ipx_network_number
    * ipx_virtual_net_number
    * keep_alive_interval
    * keep_alive_time
    * mac_address
    * mtu
    * num_forward_packets
    * pmtubh_detect_enabled?
    * pmtu_discovery_enabled?
    * service_name
    * setting_id
    * tcpip_netbios_options
    * tcp_max_connect_retransmissions
    * tcp_max_data_retransmissions
    * tcp_num_connections
    * tcp_use_rfc1122_urgent_pointer?
    * tcp_window_size
    * wins_enable_lm_hosts_lookup?
    * wins_host_lookup_file
    * wins_primary_server
    * wins_scope_id
    * wins_secondary_server
    
    For details on each of these attributes, please visit http://www.msdn.com
    and search on Win32_NetworkAdapterConfiguration.
    
    Note that some of these members will return nil because they are not
    supported by your BIOS or current BIOS settings (afaict).
= Exception Classes
--- HostError < StandardError
    Raised in the event of a failure for any of the class methods provided
    with this package.  Generally speaking, it means there was a failure in
    the underlying gethostname() or gethostbyname() calls.
= Notes
    IPV6 is not supported (yet).
= Future Plans
    Add support for IPV6.  This will be difficult unless I have access to a
    system on an IPV6 network.  Any help on this front appreciated.
= Notes
	The Windows version of this package uses OLE + WMI.  The Host.info method
	returns considerably more information than the *nix versions of this
	package at the moment.
= Known Bugs
    Returning multiple ip addresses for multi-homed systems doesn't seem to
    work properly on *nix systems.  Help appreciated.
    
    Please log any other bugs on the project home page at
    http://ruby-sysutils.sf.net.
= Acknowledgements
    Thanks go to Mike Hall, Guy Decoux, and Matz for their help with
    C extensions in general.

    Thanks also go to Richard Stevens for his excellent Unix programming
    books.
= License
    Ruby's
= Copyright
    Copyright 2002-2004, Daniel J. Berger, djberg96 at yahoo dot com

    All Rights Reserved. This module is free software. It may be used,
    redistributed and/or modified under the same terms as Ruby itself.
= Warranty
	This package is provided "as is" and without any express or
	implied warranties, including, without limitation, the implied
	warranties of merchantability and fitness for a particular purpose.
= Author
    Daniel J. Berger
    djberg96 at yahoo dot com
    rubyhacker1 on IRC
= See Also
    gethostbyname, gethostbyname_r, gethostname, hostname (Unix)
    WMI, OLE (Windows)
=end
