require "mkmf"
require "ftools"

# Remove any symlinks that may already exist
if File.exists?("host.c")
   File.delete("host.c")
end

case RUBY_PLATFORM
   when /freebsd/i
      have_func("getipnodebyname")
      File.symlink("lib/os/freebsd.c","host.c")
   when /sunos|solaris/i
      have_library("nsl")
      have_library("socket")
      have_func("gethostbyname_r","netdb.h")
      File.symlink("lib/os/sunos.c","host.c")
   when /linux/i
      have_func("gethostbyname_r","netdb.h")
      File.symlink("lib/os/linux.c","host.c")
   when /win32|windows|dos|mingw|cygwin/i
      STDERR.puts "Run the 'install.rb' script to install on Win32 systems"
   else
      File.symlink("lib/os/generic.c","host.c")
end

have_func("inet_ntop")
create_makefile("sys/host")
