################################################
# install.rb - for sys-host
#
# For pure Ruby versions only
################################################
require 'rbconfig'
require 'ftools'
include Config
install_dir = CONFIG['sitelibdir'] + '/sys'

file = ""

case RUBY_PLATFORM
   when /windows|win32|mingw|cygwin|dos/i
      file = "lib/os/windows.rb"
   else
      STDERR.puts "Use 'extconf.rb/make/make site-install' for this platform"
      exit
end

# Create the 'sys' toplevel directory if it doesn't already exist
begin
   unless File.exist?(install_dir)
      Dir.mkdir(install_dir)
   end
rescue Errno::EACCES => e
   puts "Unable to create #{install_dir}: #{e}"
   exit
end

# Finally, copy the file to the appropriate directory
begin
   File.copy(file,"#{install_dir}/host.rb")
   puts "cp #{file} #{install_dir}/host.rb"
rescue Errno::EACCES => e
   puts "Unable to install cpu.rb to #{install_dir}: #{e}"
   exit
end

puts "Installation successful"