#########################################
# tc_host.rb
#
# Test suite for sys-host, all platforms
#########################################
if File.basename(Dir.pwd) == "test"
   require "ftools"
   Dir.chdir ".."
   Dir.mkdir("sys") unless File.exists?("sys")
   if File::ALT_SEPARATOR
      File.copy("lib/os/windows.rb","sys/host.rb")
   else
      case RUBY_PLATFORM
         when /hpux/i
            File.copy("host.sl","sys")
         when /osx|darwin|mac/i
            File.copy("host.bundle","sys")
         else
            File.copy("host.so","sys")
      end
   end
   $LOAD_PATH.unshift Dir.pwd
end

require "sys/host"
require "test/unit"
include Sys

class TC_Host < Test::Unit::TestCase
   def test_version
      assert_equal("0.5.0",Host::VERSION)
   end

   def test_hostname
      assert_respond_to(Host, :hostname)
      assert_nothing_raised{ Host.hostname }
      assert_kind_of(String,Host.hostname)
      assert_equal(`hostname`.chomp,Host.hostname) # sanity check
   end

   def test_ip_addr
      assert_respond_to(Host, :ip_addr)
      assert_nothing_raised{ Host.ip_addr }
      assert_kind_of(Array,Host.ip_addr)
   end
   
   # Windows only at the moment
   def test_info
      if File::ALT_SEPARATOR
         assert_respond_to(Host,:info)
         assert_nothing_raised{ Host.info{} }
      else
         puts "Test skipped on this platform"
      end
   end
end
