#####################################################################
# test.rb
#
# A generic test script for those without testunit installed.
# Copy this to the sys-uptime base directory to run it independently
#####################################################################
if File.basename(Dir.pwd) == "examples"
   require "ftools"
   Dir.chdir "../.."
   
   extension = ".so"
   extension = ".bundle" if RUBY_PLATFORM =~ /powerpc|darwin/i
   extension = ".sl" if RUBY_PLATFORM =~ /hpux/i
   file = "uptime" + extension
   
   Dir.mkdir("sys") unless File.exists?("sys")
   if File::ALT_SEPARATOR
      File.copy("lib/os/windows.rb","sys/uptime.rb")
   else
      File.copy(file,"sys")
   end
   $LOAD_PATH.unshift Dir.pwd
end

require 'sys/uptime'
include Sys

print "\nGENERIC TEST SCRIPT FOR SYS-UPTIME\n\n"
puts 'VERSION: ' + Uptime::VERSION

puts "Days: " + Uptime.days.to_s
puts "Hours: " + Uptime.hours.to_s
puts "Minutes: " + Uptime.minutes.to_s
puts "Seconds: " + Uptime.seconds.to_s
puts "Uptime: " + Uptime.uptime
puts "DHMS: " + Uptime.dhms.join(', ')
puts "Boot Time: " + Uptime.boot_time.to_s

print "\nTest successful\n"
