= Synopsis
   require 'sys/uptime'
   include Sys

   p Uptime.days
   p Uptime.hours
   p Uptime.minutes
   p Uptime.seconds
   p Uptime.dhms.join(', ')
   p Uptime.uptime
   p Uptime.boot_time

= Description
    This package provides uptime and boot time information, similar to the
    'uptime' Unix command.
= Constants
--- VERSION
    Returns the current version number of this package (as a string)
= Class Methods
--- Uptime.boot_time
    Returns the boot time as a Time object.
--- Uptime.days
    Returns the total number of days the system has been up.
--- Uptime.hours
    Returns the total number of hours the system has been up.
--- Uptime.minutes
    Returns the total number of minutes the system has been up.
--- Uptime.seconds
    Returns the total number of seconds the system has been up.
--- Uptime.dhms
    Calculates and returns the number of days, hours, minutes and
    seconds the system has been running as a four-element Array.
--- Uptime.uptime
    Calculates and returns the number of days, hours, minutes and
    seconds the system has been running as a colon-separated string.
= Exceptions
--- UptimeError
    Raised if something goes wrong.  On Unix, this would likely mean a
    failure of the times() function.  On Windows, it probably means you
    failed to connect to WMI properly.
= Notes
	On Windows, each of the class methods optionally takes a host name as
	a single argument.  The default is localhost.
	
    The current time, users and load average are NOT included in this
    module, even though you may be used to seeing them with the command
    line version of 'uptime'.  This is because these things have
    _absolutely nothing_ to do with uptime (at least, not as I
    logically think of uptime).
= Known Bugs
	None that I am aware of.  Please log any bugs you find on the project
	website at http://ruby-sysutils.sf.net.
= Questions
    "Doesn't Struct::Tms do this?" - No.
= License
    Ruby's
= Copyright
    Copyright 2002-2004, Daniel J. Berger

    All Rights Reserved. This module is free software. It may be used,
    redistributed and/or modified under the same terms as Ruby itself.
= Warranty
	This package is provided "as is" and without any express or
	implied warranties, including, without limitation, the implied
	warranties of merchantability and fitness for a particular purpose.
= Author
    Daniel J. Berger
    djberg96 at yahoo dot com
    rubyhacker1 on IRC
    
    Mike Hall
    m3ha11 at rcn dot com
= See Also
    uptime
=end
