##############################################
# extconf.rb
#
# Configuration & build script for sys-uptime
##############################################
require 'mkmf'
require 'ftools'

#######################################################################
# In case this is run more than one time, delete the link/copy if it
# already exists.
#######################################################################
uptime_file = "uptime.c"
File.delete(uptime_file) if File.exists?(uptime_file)

case RUBY_PLATFORM
   when /windows|win32|cygwin|mingw|dos/i
      STDERR.puts "Run the 'install.rb' script instead on this platform"
      exit
   else 
      have_header("sys/loadavg.h")
      c_file = "lib/os/unix.c"
      File.symlink(c_file,uptime_file)
      if File.exists?("lib/os/windows.rb")
         File.move("lib/os/windows.rb","lib/os/windows.orig") # Don't install
      end
end

have_header("utmpx.h")
create_makefile('sys/uptime')
