#################################
# tc_uptime.rb
#
# Test suite for sys-uptime
#################################
if File.basename(Dir.pwd) == "test"
   require "ftools"
   Dir.chdir ".."

   extension = ".so"
   extension = ".bundle" if RUBY_PLATFORM =~ /powerpc|darwin/i
   extension = ".sl" if RUBY_PLATFORM =~ /hpux/i
   
   Dir.mkdir("sys") unless File.exists?("sys")

   if File::ALT_SEPARATOR
      File.copy("lib/os/windows.rb","sys/uptime.rb")
   else
      file = "uptime" + extension  
      File.copy(file,"sys")
   end
   $LOAD_PATH.unshift Dir.pwd
end

require "sys/uptime"
require "test/unit"
include Sys

class TC_Uptime < Test::Unit::TestCase
   def test_version
      assert_equal("0.4.1",Uptime::VERSION,"Bad VERSION")
   end

   def test_seconds
      assert_respond_to(Uptime,:seconds)
      assert_nothing_raised{ Uptime.seconds }
      assert_kind_of(Fixnum,Uptime.seconds,"Bad seconds() type")
      assert_equal(true,Uptime.seconds > 0, "Bad seconds() return value")
   end

   def test_minutes
      assert_respond_to(Uptime,:minutes)
      assert_nothing_raised{ Uptime.minutes }
      assert_kind_of(Fixnum,Uptime.minutes,"Bad minutes() type")
   end

   def test_hours
      assert_respond_to(Uptime,:hours)
      assert_nothing_raised{ Uptime.hours }
      assert_kind_of(Fixnum,Uptime.hours,"Bad hours() type")
   end

   def test_days
      assert_respond_to(Uptime,:days)
      assert_nothing_raised{ Uptime.days }
      assert_kind_of(Fixnum,Uptime.days,"Bad days() type")
   end 

   def test_uptime
      assert_respond_to(Uptime,:uptime)
      assert_nothing_raised{ Uptime.uptime }
      assert_kind_of(String,Uptime.uptime,"Bad uptime() type")
      assert_equal(false,Uptime.uptime.empty?,"Empty string uptime()")
   end
   
   def test_dhms
      assert_respond_to(Uptime,:dhms)
      assert_nothing_raised{ Uptime.dhms }
      assert_kind_of(Array,Uptime.dhms,"Bad uptime() type")
      assert_equal(false,Uptime.dhms.empty?,"Empty array from dhms()")
      assert_equal(4,Uptime.dhms.length)
   end
   
   def test_boot_time
      assert_respond_to(Uptime,:boot_time)
      assert_nothing_raised{ Uptime.boot_time }
      assert_kind_of(Time,Uptime.boot_time)
   end
end
