=begin
= test for WebUnit::HtmlElem
  Copyright(C) 2001 yuichi TAKAHASHI
  $Id: test_htmlelem.rb,v 1.1.1.1 2003/01/21 11:50:40 yuichi Exp $
=end

require 'webunit/webunit'
require 'runit/cui/testrunner'

module WebUnit

  class TestHtmlElem < WebUnit::TestCase

    def test_accessor

      attr_hash = { 'attr1' => '1', 'attr2' => '2', 'name'=>'x' }
      h = HtmlElem::new( 'test', attr_hash )

      assert_equals( 'test', h.tag )
      assert_equals( '', h.data )
      assert_equals( attr_hash, h.attrs )
      assert_equals( [], h.children )
      assert_equals( [], h.array )
      assert_equals( 'x', h.name )

    end

    def test_append # data, array, inspect, extract

      attr_hash = { 'attr1' => '1', 'attr2' => '2' }
      h = HtmlElem::new( 'test', attr_hash )

      h.append 'data'

      assert_equals( 'data', h.data )
      assert_equals( ['data'], h.array )

      child1 = HtmlElem::new( 'child', 'attr1' => '3' )
      child1.append( 'data2' )

      h.append child1

      assert_equals( 'data', h.data )
      assert_equals( ['data',child1], h.array )

      h.append ' 1 '
      assert_equals( 'data 1 ', h.data )
      assert_equals( ['data',child1,' 1 '], h.array )

      child2 = HtmlElem::new( 'child', 'attr1' => '4' )
      child2.append 'data3'
      h.append child2

      assert_equals( [child1,child2], h.find( 'child' ) )
      assert_equals( [h], h.search( 'data 1 ' ) )
      assert_equals( [child2], h.search( 'data3' ) )

      assert_equals( true, h.has?( 'data' ) )
      assert_equals( false, h.has?( 'data2' ) )
      assert_equals( true, h.has?( child1 ) )
      assert_equals( false, child1.has?( child1 ) )

      assert_equals( '<test attr1=1 attr2=2>:data 1 :', h.inspect )

      assert_equals( 'data data2 1 data3', h.extract )
      child1.append( 'xxx' )
      assert_equals( 'data data2 xxx 1 data3', h.extract )

    end

  end

end

