; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=x86-64 -mattr=+avx512vl,+avx512dq | FileCheck %s --check-prefix=CHECK

define <4 x i32> @mask_shuffle_v4i32_1234(<4 x i32> %a, <4 x i32> %b, <4 x i32> %passthru, i8 %mask) {
; CHECK-LABEL: mask_shuffle_v4i32_1234:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    valignd {{.*#+}} xmm2 {%k1} = xmm0[1,2,3],xmm1[0]
; CHECK-NEXT:    vmovdqa %xmm2, %xmm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 1, i32 2, i32 3, i32 4>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res = select <4 x i1> %mask.extract, <4 x i32> %shuffle, <4 x i32> %passthru
  ret <4 x i32> %res
}

define <4 x i32> @maskz_shuffle_v4i32_1234(<4 x i32> %a, <4 x i32> %b, i8 %mask) {
; CHECK-LABEL: maskz_shuffle_v4i32_1234:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    valignd {{.*#+}} xmm0 {%k1} {z} = xmm0[1,2,3],xmm1[0]
; CHECK-NEXT:    retq
  %shuffle = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 1, i32 2, i32 3, i32 4>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res = select <4 x i1> %mask.extract, <4 x i32> %shuffle, <4 x i32> zeroinitializer
  ret <4 x i32> %res
}

define <4 x i32> @mask_shuffle_v4i32_2345(<4 x i32> %a, <4 x i32> %b, <4 x i32> %passthru, i8 %mask) {
; CHECK-LABEL: mask_shuffle_v4i32_2345:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    valignd {{.*#+}} xmm2 {%k1} = xmm0[2,3],xmm1[0,1]
; CHECK-NEXT:    vmovdqa %xmm2, %xmm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 2, i32 3, i32 4, i32 5>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res = select <4 x i1> %mask.extract, <4 x i32> %shuffle, <4 x i32> %passthru
  ret <4 x i32> %res
}

define <4 x i32> @maskz_shuffle_v4i32_2345(<4 x i32> %a, <4 x i32> %b, i8 %mask) {
; CHECK-LABEL: maskz_shuffle_v4i32_2345:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    valignd {{.*#+}} xmm0 {%k1} {z} = xmm0[2,3],xmm1[0,1]
; CHECK-NEXT:    retq
  %shuffle = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 2, i32 3, i32 4, i32 5>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res = select <4 x i1> %mask.extract, <4 x i32> %shuffle, <4 x i32> zeroinitializer
  ret <4 x i32> %res
}

define <2 x i64> @mask_shuffle_v2i64_12(<2 x i64> %a, <2 x i64> %b, <2 x i64> %passthru, i8 %mask) {
; CHECK-LABEL: mask_shuffle_v2i64_12:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    valignq {{.*#+}} xmm2 {%k1} = xmm0[1],xmm1[0]
; CHECK-NEXT:    vmovdqa %xmm2, %xmm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <2 x i64> %a, <2 x i64> %b, <2 x i32> <i32 1, i32 2>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %res = select <2 x i1> %mask.extract, <2 x i64> %shuffle, <2 x i64> %passthru
  ret <2 x i64> %res
}

define <2 x i64> @maskz_shuffle_v2i64_12(<2 x i64> %a, <2 x i64> %b, i8 %mask) {
; CHECK-LABEL: maskz_shuffle_v2i64_12:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    valignq {{.*#+}} xmm0 {%k1} {z} = xmm0[1],xmm1[0]
; CHECK-NEXT:    retq
  %shuffle = shufflevector <2 x i64> %a, <2 x i64> %b, <2 x i32> <i32 1, i32 2>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %res = select <2 x i1> %mask.extract, <2 x i64> %shuffle, <2 x i64> zeroinitializer
  ret <2 x i64> %res
}

define <4 x i64> @mask_shuffle_v4i64_1234(<4 x i64> %a, <4 x i64> %b, <4 x i64> %passthru, i8 %mask) {
; CHECK-LABEL: mask_shuffle_v4i64_1234:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    valignq {{.*#+}} ymm2 {%k1} = ymm0[1,2,3],ymm1[0]
; CHECK-NEXT:    vmovdqa %ymm2, %ymm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 1, i32 2, i32 3, i32 4>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res = select <4 x i1> %mask.extract, <4 x i64> %shuffle, <4 x i64> %passthru
  ret <4 x i64> %res
}

define <4 x i64> @maskz_shuffle_v4i64_1234(<4 x i64> %a, <4 x i64> %b, i8 %mask) {
; CHECK-LABEL: maskz_shuffle_v4i64_1234:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    valignq {{.*#+}} ymm0 {%k1} {z} = ymm0[1,2,3],ymm1[0]
; CHECK-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 1, i32 2, i32 3, i32 4>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res = select <4 x i1> %mask.extract, <4 x i64> %shuffle, <4 x i64> zeroinitializer
  ret <4 x i64> %res
}

define <4 x i64> @mask_shuffle_v4i64_1230(<4 x i64> %a, <4 x i64> %passthru, i8 %mask) {
; CHECK-LABEL: mask_shuffle_v4i64_1230:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vpermq {{.*#+}} ymm1 {%k1} = ymm0[1,2,3,0]
; CHECK-NEXT:    vmovdqa %ymm1, %ymm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> undef, <4 x i32> <i32 1, i32 2, i32 3, i32 0>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res = select <4 x i1> %mask.extract, <4 x i64> %shuffle, <4 x i64> %passthru
  ret <4 x i64> %res
}

define <4 x i64> @maskz_shuffle_v4i64_1230(<4 x i64> %a, i8 %mask) {
; CHECK-LABEL: maskz_shuffle_v4i64_1230:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vpermq {{.*#+}} ymm0 {%k1} {z} = ymm0[1,2,3,0]
; CHECK-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> undef, <4 x i32> <i32 1, i32 2, i32 3, i32 0>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res = select <4 x i1> %mask.extract, <4 x i64> %shuffle, <4 x i64> zeroinitializer
  ret <4 x i64> %res
}

define <8 x i32> @mask_shuffle_v8i32_12345678(<8 x i32> %a, <8 x i32> %b, <8 x i32> %passthru, i8 %mask) {
; CHECK-LABEL: mask_shuffle_v8i32_12345678:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    valignd {{.*#+}} ymm2 {%k1} = ymm0[1,2,3,4,5,6,7],ymm1[0]
; CHECK-NEXT:    vmovdqa %ymm2, %ymm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %res = select <8 x i1> %mask.cast, <8 x i32> %shuffle, <8 x i32> %passthru
  ret <8 x i32> %res
}

define <8 x i32> @maskz_shuffle_v8i32_12345678(<8 x i32> %a, <8 x i32> %b, i8 %mask) {
; CHECK-LABEL: maskz_shuffle_v8i32_12345678:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    valignd {{.*#+}} ymm0 {%k1} {z} = ymm0[1,2,3,4,5,6,7],ymm1[0]
; CHECK-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %res = select <8 x i1> %mask.cast, <8 x i32> %shuffle, <8 x i32> zeroinitializer
  ret <8 x i32> %res
}

define <8 x i32> @mask_shuffle_v8i32_23456789(<8 x i32> %a, <8 x i32> %b, <8 x i32> %passthru, i8 %mask) {
; CHECK-LABEL: mask_shuffle_v8i32_23456789:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    valignd {{.*#+}} ymm2 {%k1} = ymm0[2,3,4,5,6,7],ymm1[0,1]
; CHECK-NEXT:    vmovdqa %ymm2, %ymm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %res = select <8 x i1> %mask.cast, <8 x i32> %shuffle, <8 x i32> %passthru
  ret <8 x i32> %res
}

define <8 x i32> @maskz_shuffle_v8i32_23456789(<8 x i32> %a, <8 x i32> %b, i8 %mask) {
; CHECK-LABEL: maskz_shuffle_v8i32_23456789:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    valignd {{.*#+}} ymm0 {%k1} {z} = ymm0[2,3,4,5,6,7],ymm1[0,1]
; CHECK-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> %b, <8 x i32> <i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %res = select <8 x i1> %mask.cast, <8 x i32> %shuffle, <8 x i32> zeroinitializer
  ret <8 x i32> %res
}

define <8 x i32> @mask_shuffle_v8i32_12345670(<8 x i32> %a, <8 x i32> %passthru, i8 %mask) {
; CHECK-LABEL: mask_shuffle_v8i32_12345670:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    valignd {{.*#+}} ymm1 {%k1} = ymm0[1,2,3,4,5,6,7,0]
; CHECK-NEXT:    vmovdqa %ymm1, %ymm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> undef, <8 x i32> <i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %res = select <8 x i1> %mask.cast, <8 x i32> %shuffle, <8 x i32> %passthru
  ret <8 x i32> %res
}

define <8 x i32> @maskz_shuffle_v8i32_12345670(<8 x i32> %a, i8 %mask) {
; CHECK-LABEL: maskz_shuffle_v8i32_12345670:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    valignd {{.*#+}} ymm0 {%k1} {z} = ymm0[1,2,3,4,5,6,7,0]
; CHECK-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> undef, <8 x i32> <i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %res = select <8 x i1> %mask.cast, <8 x i32> %shuffle, <8 x i32> zeroinitializer
  ret <8 x i32> %res
}

define <8 x i32> @mask_shuffle_v8i32_23456701(<8 x i32> %a, <8 x i32> %passthru, i8 %mask) {
; CHECK-LABEL: mask_shuffle_v8i32_23456701:
; CHECK:       # BB#0:
; CHECK-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[1,2,3,0]
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vmovdqa32 %ymm0, %ymm1 {%k1}
; CHECK-NEXT:    vmovdqa %ymm1, %ymm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> undef, <8 x i32> <i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %res = select <8 x i1> %mask.cast, <8 x i32> %shuffle, <8 x i32> %passthru
  ret <8 x i32> %res
}

define <8 x i32> @maskz_shuffle_v8i32_23456701(<8 x i32> %a, i8 %mask) {
; CHECK-LABEL: maskz_shuffle_v8i32_23456701:
; CHECK:       # BB#0:
; CHECK-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[1,2,3,0]
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vmovdqa32 %ymm0, %ymm0 {%k1} {z}
; CHECK-NEXT:    retq
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> undef, <8 x i32> <i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %res = select <8 x i1> %mask.cast, <8 x i32> %shuffle, <8 x i32> zeroinitializer
  ret <8 x i32> %res
}

define <4 x i32> @mask_extract_v16i32_v4i32_0(<16 x i32> %a, <4 x i32> %passthru, i8 %mask) {
; CHECK-LABEL: mask_extract_v16i32_v4i32_0:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vextracti32x4 $0, %zmm0, %xmm1 {%k1}
; CHECK-NEXT:    vmovdqa %xmm1, %xmm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <16 x i32> %a, <16 x i32> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res = select <4 x i1> %mask.extract, <4 x i32> %shuffle, <4 x i32> %passthru
  ret <4 x i32> %res
}

define <4 x i32> @mask_extract_v16i32_v4i32_1(<16 x i32> %a, <4 x i32> %passthru, i8 %mask) {
; CHECK-LABEL: mask_extract_v16i32_v4i32_1:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vextracti32x4 $1, %zmm0, %xmm1 {%k1}
; CHECK-NEXT:    vmovdqa %xmm1, %xmm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <16 x i32> %a, <16 x i32> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res = select <4 x i1> %mask.extract, <4 x i32> %shuffle, <4 x i32> %passthru
  ret <4 x i32> %res
}

define <4 x i32> @mask_extract_v16i32_v4i32_2(<16 x i32> %a, <4 x i32> %passthru, i8 %mask) {
; CHECK-LABEL: mask_extract_v16i32_v4i32_2:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vextracti32x4 $2, %zmm0, %xmm1 {%k1}
; CHECK-NEXT:    vmovdqa %xmm1, %xmm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <16 x i32> %a, <16 x i32> undef, <4 x i32> <i32 8, i32 9, i32 10, i32 11>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res = select <4 x i1> %mask.extract, <4 x i32> %shuffle, <4 x i32> %passthru
  ret <4 x i32> %res
}

define <4 x i32> @mask_extract_v16i32_v4i32_3(<16 x i32> %a, <4 x i32> %passthru, i8 %mask) {
; CHECK-LABEL: mask_extract_v16i32_v4i32_3:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vextracti32x4 $3, %zmm0, %xmm1 {%k1}
; CHECK-NEXT:    vmovdqa %xmm1, %xmm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <16 x i32> %a, <16 x i32> undef, <4 x i32> <i32 12, i32 13, i32 14, i32 15>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res = select <4 x i1> %mask.extract, <4 x i32> %shuffle, <4 x i32> %passthru
  ret <4 x i32> %res
}

define <4 x float> @mask_extract_v16f32_v4f32_0(<16 x float> %a, <4 x float> %passthru, i8 %mask) {
; CHECK-LABEL: mask_extract_v16f32_v4f32_0:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vextractf32x4 $0, %zmm0, %xmm1 {%k1}
; CHECK-NEXT:    vmovaps %xmm1, %xmm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <16 x float> %a, <16 x float> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res = select <4 x i1> %mask.extract, <4 x float> %shuffle, <4 x float> %passthru
  ret <4 x float> %res
}

define <4 x float> @mask_extract_v16f32_v4f32_1(<16 x float> %a, <4 x float> %passthru, i8 %mask) {
; CHECK-LABEL: mask_extract_v16f32_v4f32_1:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vextractf32x4 $1, %zmm0, %xmm1 {%k1}
; CHECK-NEXT:    vmovaps %xmm1, %xmm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <16 x float> %a, <16 x float> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res = select <4 x i1> %mask.extract, <4 x float> %shuffle, <4 x float> %passthru
  ret <4 x float> %res
}

define <4 x float> @mask_extract_v16f32_v4f32_2(<16 x float> %a, <4 x float> %passthru, i8 %mask) {
; CHECK-LABEL: mask_extract_v16f32_v4f32_2:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vextractf32x4 $2, %zmm0, %xmm1 {%k1}
; CHECK-NEXT:    vmovaps %xmm1, %xmm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <16 x float> %a, <16 x float> undef, <4 x i32> <i32 8, i32 9, i32 10, i32 11>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res = select <4 x i1> %mask.extract, <4 x float> %shuffle, <4 x float> %passthru
  ret <4 x float> %res
}

define <4 x float> @mask_extract_v16f32_v4f32_3(<16 x float> %a, <4 x float> %passthru, i8 %mask) {
; CHECK-LABEL: mask_extract_v16f32_v4f32_3:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vextractf32x4 $3, %zmm0, %xmm1 {%k1}
; CHECK-NEXT:    vmovaps %xmm1, %xmm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <16 x float> %a, <16 x float> undef, <4 x i32> <i32 12, i32 13, i32 14, i32 15>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res = select <4 x i1> %mask.extract, <4 x float> %shuffle, <4 x float> %passthru
  ret <4 x float> %res
}

define <8 x i32> @mask_extract_v16i32_v8i32_0(<16 x i32> %a, <8 x i32> %passthru, i8 %mask) {
; CHECK-LABEL: mask_extract_v16i32_v8i32_0:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vextracti32x8 $0, %zmm0, %ymm1 {%k1}
; CHECK-NEXT:    vmovdqa %ymm1, %ymm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <16 x i32> %a, <16 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %res = select <8 x i1> %mask.cast, <8 x i32> %shuffle, <8 x i32> %passthru
  ret <8 x i32> %res
}

define <8 x i32> @mask_extract_v16i32_v8i32_1(<16 x i32> %a, <8 x i32> %passthru, i8 %mask) {
; CHECK-LABEL: mask_extract_v16i32_v8i32_1:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vextracti32x8 $1, %zmm0, %ymm1 {%k1}
; CHECK-NEXT:    vmovdqa %ymm1, %ymm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <16 x i32> %a, <16 x i32> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %res = select <8 x i1> %mask.cast, <8 x i32> %shuffle, <8 x i32> %passthru
  ret <8 x i32> %res
}

define <8 x float> @mask_extract_v16f32_v8f32_0(<16 x float> %a, <8 x float> %passthru, i8 %mask) {
; CHECK-LABEL: mask_extract_v16f32_v8f32_0:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vextractf32x8 $0, %zmm0, %ymm1 {%k1}
; CHECK-NEXT:    vmovaps %ymm1, %ymm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <16 x float> %a, <16 x float> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %res = select <8 x i1> %mask.cast, <8 x float> %shuffle, <8 x float> %passthru
  ret <8 x float> %res
}

define <8 x float> @mask_extract_v16f32_v8f32_1(<16 x float> %a, <8 x float> %passthru, i8 %mask) {
; CHECK-LABEL: mask_extract_v16f32_v8f32_1:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vextractf32x8 $1, %zmm0, %ymm1 {%k1}
; CHECK-NEXT:    vmovaps %ymm1, %ymm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <16 x float> %a, <16 x float> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %res = select <8 x i1> %mask.cast, <8 x float> %shuffle, <8 x float> %passthru
  ret <8 x float> %res
}

define <2 x i64> @mask_extract_v8i64_v2i64_0(<8 x i64> %a, <2 x i64> %passthru, i8 %mask) {
; CHECK-LABEL: mask_extract_v8i64_v2i64_0:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vextracti64x2 $0, %zmm0, %xmm1 {%k1}
; CHECK-NEXT:    vmovdqa %xmm1, %xmm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <8 x i64> %a, <8 x i64> undef, <2 x i32> <i32 0, i32 1>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %res = select <2 x i1> %mask.extract, <2 x i64> %shuffle, <2 x i64> %passthru
  ret <2 x i64> %res
}

define <2 x i64> @mask_extract_v8i64_v2i64_1(<8 x i64> %a, <2 x i64> %passthru, i8 %mask) {
; CHECK-LABEL: mask_extract_v8i64_v2i64_1:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vextracti64x2 $1, %zmm0, %xmm1 {%k1}
; CHECK-NEXT:    vmovdqa %xmm1, %xmm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <8 x i64> %a, <8 x i64> undef, <2 x i32> <i32 2, i32 3>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %res = select <2 x i1> %mask.extract, <2 x i64> %shuffle, <2 x i64> %passthru
  ret <2 x i64> %res
}

define <2 x i64> @mask_extract_v8i64_v2i64_2(<8 x i64> %a, <2 x i64> %passthru, i8 %mask) {
; CHECK-LABEL: mask_extract_v8i64_v2i64_2:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vextracti64x2 $2, %zmm0, %xmm1 {%k1}
; CHECK-NEXT:    vmovdqa %xmm1, %xmm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <8 x i64> %a, <8 x i64> undef, <2 x i32> <i32 4, i32 5>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %res = select <2 x i1> %mask.extract, <2 x i64> %shuffle, <2 x i64> %passthru
  ret <2 x i64> %res
}

define <2 x i64> @mask_extract_v8i64_v2i64_3(<8 x i64> %a, <2 x i64> %passthru, i8 %mask) {
; CHECK-LABEL: mask_extract_v8i64_v2i64_3:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vextracti64x2 $3, %zmm0, %xmm1 {%k1}
; CHECK-NEXT:    vmovdqa %xmm1, %xmm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <8 x i64> %a, <8 x i64> undef, <2 x i32> <i32 6, i32 7>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %res = select <2 x i1> %mask.extract, <2 x i64> %shuffle, <2 x i64> %passthru
  ret <2 x i64> %res
}

define <2 x double> @mask_extract_v8f64_v2f64_0(<8 x double> %a, <2 x double> %passthru, i8 %mask) {
; CHECK-LABEL: mask_extract_v8f64_v2f64_0:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vextractf64x2 $0, %zmm0, %xmm1 {%k1}
; CHECK-NEXT:    vmovapd %xmm1, %xmm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <8 x double> %a, <8 x double> undef, <2 x i32> <i32 0, i32 1>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %res = select <2 x i1> %mask.extract, <2 x double> %shuffle, <2 x double> %passthru
  ret <2 x double> %res
}

define <2 x double> @mask_extract_v8f64_v2f64_1(<8 x double> %a, <2 x double> %passthru, i8 %mask) {
; CHECK-LABEL: mask_extract_v8f64_v2f64_1:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vextractf64x2 $1, %zmm0, %xmm1 {%k1}
; CHECK-NEXT:    vmovapd %xmm1, %xmm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <8 x double> %a, <8 x double> undef, <2 x i32> <i32 2, i32 3>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %res = select <2 x i1> %mask.extract, <2 x double> %shuffle, <2 x double> %passthru
  ret <2 x double> %res
}

define <2 x double> @mask_extract_v8f64_v2f64_2(<8 x double> %a, <2 x double> %passthru, i8 %mask) {
; CHECK-LABEL: mask_extract_v8f64_v2f64_2:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vextractf64x2 $2, %zmm0, %xmm1 {%k1}
; CHECK-NEXT:    vmovapd %xmm1, %xmm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <8 x double> %a, <8 x double> undef, <2 x i32> <i32 4, i32 5>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %res = select <2 x i1> %mask.extract, <2 x double> %shuffle, <2 x double> %passthru
  ret <2 x double> %res
}

define <2 x double> @mask_extract_v8f64_v2f64_3(<8 x double> %a, <2 x double> %passthru, i8 %mask) {
; CHECK-LABEL: mask_extract_v8f64_v2f64_3:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vextractf64x2 $3, %zmm0, %xmm1 {%k1}
; CHECK-NEXT:    vmovapd %xmm1, %xmm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <8 x double> %a, <8 x double> undef, <2 x i32> <i32 6, i32 7>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %res = select <2 x i1> %mask.extract, <2 x double> %shuffle, <2 x double> %passthru
  ret <2 x double> %res
}

define <4 x i64> @mask_extract_v8i64_v4i64_0(<8 x i64> %a, <4 x i64> %passthru, i8 %mask) {
; CHECK-LABEL: mask_extract_v8i64_v4i64_0:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vextracti64x4 $0, %zmm0, %ymm1 {%k1}
; CHECK-NEXT:    vmovdqa %ymm1, %ymm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <8 x i64> %a, <8 x i64> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res = select <4 x i1> %mask.extract, <4 x i64> %shuffle, <4 x i64> %passthru
  ret <4 x i64> %res
}

define <4 x i64> @mask_extract_v8i64_v4i64_1(<8 x i64> %a, <4 x i64> %passthru, i8 %mask) {
; CHECK-LABEL: mask_extract_v8i64_v4i64_1:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vextracti64x4 $1, %zmm0, %ymm1 {%k1}
; CHECK-NEXT:    vmovdqa %ymm1, %ymm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <8 x i64> %a, <8 x i64> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res = select <4 x i1> %mask.extract, <4 x i64> %shuffle, <4 x i64> %passthru
  ret <4 x i64> %res
}

define <4 x double> @mask_extract_v8f64_v4f64_0(<8 x double> %a, <4 x double> %passthru, i8 %mask) {
; CHECK-LABEL: mask_extract_v8f64_v4f64_0:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vextractf64x4 $0, %zmm0, %ymm1 {%k1}
; CHECK-NEXT:    vmovapd %ymm1, %ymm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <8 x double> %a, <8 x double> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res = select <4 x i1> %mask.extract, <4 x double> %shuffle, <4 x double> %passthru
  ret <4 x double> %res
}

define <4 x double> @mask_extract_v8f64_v4f64_1(<8 x double> %a, <4 x double> %passthru, i8 %mask) {
; CHECK-LABEL: mask_extract_v8f64_v4f64_1:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vextractf64x4 $1, %zmm0, %ymm1 {%k1}
; CHECK-NEXT:    vmovapd %ymm1, %ymm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <8 x double> %a, <8 x double> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res = select <4 x i1> %mask.extract, <4 x double> %shuffle, <4 x double> %passthru
  ret <4 x double> %res
}

define <8 x i32> @mask_extract_v8i64_v8i32_1(<8 x i64> %a, <8 x i32> %passthru, i8 %mask) {
; CHECK-LABEL: mask_extract_v8i64_v8i32_1:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vextracti32x8 $1, %zmm0, %ymm1 {%k1}
; CHECK-NEXT:    vmovdqa %ymm1, %ymm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <8 x i64> %a, <8 x i64> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle.cast = bitcast <4 x i64> %shuffle to <8 x i32>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %res = select <8 x i1> %mask.cast, <8 x i32> %shuffle.cast, <8 x i32> %passthru
  ret <8 x i32> %res
}

define <8 x float> @mask_extract_v8f64_v8f32_1(<8 x double> %a, <8 x float> %passthru, i8 %mask) {
; CHECK-LABEL: mask_extract_v8f64_v8f32_1:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vextractf32x8 $1, %zmm0, %ymm1 {%k1}
; CHECK-NEXT:    vmovaps %ymm1, %ymm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <8 x double> %a, <8 x double> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle.cast = bitcast <4 x double> %shuffle to <8 x float>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %res = select <8 x i1> %mask.cast, <8 x float> %shuffle.cast, <8 x float> %passthru
  ret <8 x float> %res
}

define <4 x i32> @mask_cast_extract_v8i64_v4i32_1(<8 x i64> %a, <4 x i32> %passthru, i8 %mask) {
; CHECK-LABEL: mask_cast_extract_v8i64_v4i32_1:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vextracti32x4 $1, %zmm0, %xmm1 {%k1}
; CHECK-NEXT:    vmovdqa %xmm1, %xmm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <8 x i64> %a, <8 x i64> undef, <2 x i32> <i32 2, i32 3>
  %shuffle.cast = bitcast <2 x i64> %shuffle to <4 x i32>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res = select <4 x i1> %mask.extract, <4 x i32> %shuffle.cast, <4 x i32> %passthru
  ret <4 x i32> %res
}

define <4 x float> @mask_cast_extract_v8f64_v4f32_1(<8 x double> %a, <4 x float> %passthru, i8 %mask) {
; CHECK-LABEL: mask_cast_extract_v8f64_v4f32_1:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vextractf32x4 $1, %zmm0, %xmm1 {%k1}
; CHECK-NEXT:    vmovaps %xmm1, %xmm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <8 x double> %a, <8 x double> undef, <2 x i32> <i32 2, i32 3>
  %shuffle.cast = bitcast <2 x double> %shuffle to <4 x float>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res = select <4 x i1> %mask.extract, <4 x float> %shuffle.cast, <4 x float> %passthru
  ret <4 x float> %res
}

define <4 x i64> @mask_cast_extract_v16i32_v4i64_1(<16 x i32> %a, <4 x i64> %passthru, i8 %mask) {
; CHECK-LABEL: mask_cast_extract_v16i32_v4i64_1:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vextracti64x4 $1, %zmm0, %ymm1 {%k1}
; CHECK-NEXT:    vmovdqa %ymm1, %ymm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <16 x i32> %a, <16 x i32> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %shuffle.cast = bitcast <8 x i32> %shuffle to <4 x i64>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res = select <4 x i1> %mask.extract, <4 x i64> %shuffle.cast, <4 x i64> %passthru
  ret <4 x i64> %res
}

define <4 x double> @mask_cast_extract_v16f32_v4f64_1(<16 x float> %a, <4 x double> %passthru, i8 %mask) {
; CHECK-LABEL: mask_cast_extract_v16f32_v4f64_1:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vextractf64x4 $1, %zmm0, %ymm1 {%k1}
; CHECK-NEXT:    vmovapd %ymm1, %ymm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <16 x float> %a, <16 x float> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %shuffle.cast = bitcast <8 x float> %shuffle to <4 x double>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res = select <4 x i1> %mask.extract, <4 x double> %shuffle.cast, <4 x double> %passthru
  ret <4 x double> %res
}

define <2 x i64> @mask_cast_extract_v16i32_v2i64_1(<16 x i32> %a, <2 x i64> %passthru, i8 %mask) {
; CHECK-LABEL: mask_cast_extract_v16i32_v2i64_1:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vextracti64x2 $1, %zmm0, %xmm1 {%k1}
; CHECK-NEXT:    vmovdqa %xmm1, %xmm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <16 x i32> %a, <16 x i32> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle.cast = bitcast <4 x i32> %shuffle to <2 x i64>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %res = select <2 x i1> %mask.extract, <2 x i64> %shuffle.cast, <2 x i64> %passthru
  ret <2 x i64> %res
}

define <2 x double> @mask_cast_extract_v16f32_v2f64_1(<16 x float> %a, <2 x double> %passthru, i8 %mask) {
; CHECK-LABEL: mask_cast_extract_v16f32_v2f64_1:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %edi, %k1
; CHECK-NEXT:    vextractf64x2 $1, %zmm0, %xmm1 {%k1}
; CHECK-NEXT:    vmovapd %xmm1, %xmm0
; CHECK-NEXT:    retq
  %shuffle = shufflevector <16 x float> %a, <16 x float> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %shuffle.cast = bitcast <4 x float> %shuffle to <2 x double>
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %res = select <2 x i1> %mask.extract, <2 x double> %shuffle.cast, <2 x double> %passthru
  ret <2 x double> %res
}

define <2 x double> @broadcast_v4f32_0101_from_v2f32_mask(double* %x, <2 x double> %passthru, i8 %mask) {
; CHECK-LABEL: broadcast_v4f32_0101_from_v2f32_mask:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %esi, %k1
; CHECK-NEXT:    vmovddup {{.*#+}} xmm0 {%k1} = mem[0,0]
; CHECK-NEXT:    retq
  %q = load double, double* %x, align 1
  %vecinit.i = insertelement <2 x double> undef, double %q, i32 0
  %vecinit2.i = insertelement <2 x double> %vecinit.i, double %q, i32 1
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %res = select <2 x i1> %mask.extract, <2 x double> %vecinit2.i, <2 x double> %passthru
  ret <2 x double> %res
}

define <2 x double> @broadcast_v4f32_0101_from_v2f32_maskz(double* %x, i8 %mask) {
; CHECK-LABEL: broadcast_v4f32_0101_from_v2f32_maskz:
; CHECK:       # BB#0:
; CHECK-NEXT:    kmovb %esi, %k1
; CHECK-NEXT:    vmovddup {{.*#+}} xmm0 {%k1} {z} = mem[0,0]
; CHECK-NEXT:    retq
  %q = load double, double* %x, align 1
  %vecinit.i = insertelement <2 x double> undef, double %q, i32 0
  %vecinit2.i = insertelement <2 x double> %vecinit.i, double %q, i32 1
  %mask.cast = bitcast i8 %mask to <8 x i1>
  %mask.extract = shufflevector <8 x i1> %mask.cast, <8 x i1> undef, <2 x i32> <i32 0, i32 1>
  %res = select <2 x i1> %mask.extract, <2 x double> %vecinit2.i, <2 x double> zeroinitializer
  ret <2 x double> %res
}
