// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -no-opaque-pointers -triple riscv32 -target-feature +experimental-zbp -emit-llvm %s -o - \
// RUN:     | FileCheck %s  -check-prefix=RV32ZBP

// RV32ZBP-LABEL: @grev(
// RV32ZBP-NEXT:  entry:
// RV32ZBP-NEXT:    [[RS1_ADDR:%.*]] = alloca i32, align 4
// RV32ZBP-NEXT:    [[RS2_ADDR:%.*]] = alloca i32, align 4
// RV32ZBP-NEXT:    store i32 [[RS1:%.*]], i32* [[RS1_ADDR]], align 4
// RV32ZBP-NEXT:    store i32 [[RS2:%.*]], i32* [[RS2_ADDR]], align 4
// RV32ZBP-NEXT:    [[TMP0:%.*]] = load i32, i32* [[RS1_ADDR]], align 4
// RV32ZBP-NEXT:    [[TMP1:%.*]] = load i32, i32* [[RS2_ADDR]], align 4
// RV32ZBP-NEXT:    [[TMP2:%.*]] = call i32 @llvm.riscv.grev.i32(i32 [[TMP0]], i32 [[TMP1]])
// RV32ZBP-NEXT:    ret i32 [[TMP2]]
//
long grev(long rs1, long rs2)
{
  return __builtin_riscv_grev_32(rs1, rs2);
}

// RV32ZBP-LABEL: @grevi(
// RV32ZBP-NEXT:  entry:
// RV32ZBP-NEXT:    [[RS1_ADDR:%.*]] = alloca i32, align 4
// RV32ZBP-NEXT:    [[I:%.*]] = alloca i32, align 4
// RV32ZBP-NEXT:    store i32 [[RS1:%.*]], i32* [[RS1_ADDR]], align 4
// RV32ZBP-NEXT:    store i32 13, i32* [[I]], align 4
// RV32ZBP-NEXT:    [[TMP0:%.*]] = load i32, i32* [[RS1_ADDR]], align 4
// RV32ZBP-NEXT:    [[TMP1:%.*]] = call i32 @llvm.riscv.grev.i32(i32 [[TMP0]], i32 13)
// RV32ZBP-NEXT:    ret i32 [[TMP1]]
//
long grevi(long rs1)
{
  const int i = 13;
  return __builtin_riscv_grev_32(rs1, i);
}

// RV32ZBP-LABEL: @gorc(
// RV32ZBP-NEXT:  entry:
// RV32ZBP-NEXT:    [[RS1_ADDR:%.*]] = alloca i32, align 4
// RV32ZBP-NEXT:    [[RS2_ADDR:%.*]] = alloca i32, align 4
// RV32ZBP-NEXT:    store i32 [[RS1:%.*]], i32* [[RS1_ADDR]], align 4
// RV32ZBP-NEXT:    store i32 [[RS2:%.*]], i32* [[RS2_ADDR]], align 4
// RV32ZBP-NEXT:    [[TMP0:%.*]] = load i32, i32* [[RS1_ADDR]], align 4
// RV32ZBP-NEXT:    [[TMP1:%.*]] = load i32, i32* [[RS2_ADDR]], align 4
// RV32ZBP-NEXT:    [[TMP2:%.*]] = call i32 @llvm.riscv.gorc.i32(i32 [[TMP0]], i32 [[TMP1]])
// RV32ZBP-NEXT:    ret i32 [[TMP2]]
//
long gorc(long rs1, long rs2)
{
  return __builtin_riscv_gorc_32(rs1, rs2);
}

// RV32ZBP-LABEL: @gorci(
// RV32ZBP-NEXT:  entry:
// RV32ZBP-NEXT:    [[RS1_ADDR:%.*]] = alloca i32, align 4
// RV32ZBP-NEXT:    [[I:%.*]] = alloca i32, align 4
// RV32ZBP-NEXT:    store i32 [[RS1:%.*]], i32* [[RS1_ADDR]], align 4
// RV32ZBP-NEXT:    store i32 13, i32* [[I]], align 4
// RV32ZBP-NEXT:    [[TMP0:%.*]] = load i32, i32* [[RS1_ADDR]], align 4
// RV32ZBP-NEXT:    [[TMP1:%.*]] = call i32 @llvm.riscv.gorc.i32(i32 [[TMP0]], i32 13)
// RV32ZBP-NEXT:    ret i32 [[TMP1]]
//
long gorci(long rs1)
{
  const int i = 13;
  return __builtin_riscv_gorc_32(rs1, i);
}

// RV32ZBP-LABEL: @shfl(
// RV32ZBP-NEXT:  entry:
// RV32ZBP-NEXT:    [[RS1_ADDR:%.*]] = alloca i32, align 4
// RV32ZBP-NEXT:    [[RS2_ADDR:%.*]] = alloca i32, align 4
// RV32ZBP-NEXT:    store i32 [[RS1:%.*]], i32* [[RS1_ADDR]], align 4
// RV32ZBP-NEXT:    store i32 [[RS2:%.*]], i32* [[RS2_ADDR]], align 4
// RV32ZBP-NEXT:    [[TMP0:%.*]] = load i32, i32* [[RS1_ADDR]], align 4
// RV32ZBP-NEXT:    [[TMP1:%.*]] = load i32, i32* [[RS2_ADDR]], align 4
// RV32ZBP-NEXT:    [[TMP2:%.*]] = call i32 @llvm.riscv.shfl.i32(i32 [[TMP0]], i32 [[TMP1]])
// RV32ZBP-NEXT:    ret i32 [[TMP2]]
//
long shfl(long rs1, long rs2)
{
  return __builtin_riscv_shfl_32(rs1, rs2);
}

// RV32ZBP-LABEL: @shfli(
// RV32ZBP-NEXT:  entry:
// RV32ZBP-NEXT:    [[RS1_ADDR:%.*]] = alloca i32, align 4
// RV32ZBP-NEXT:    [[I:%.*]] = alloca i32, align 4
// RV32ZBP-NEXT:    store i32 [[RS1:%.*]], i32* [[RS1_ADDR]], align 4
// RV32ZBP-NEXT:    store i32 13, i32* [[I]], align 4
// RV32ZBP-NEXT:    [[TMP0:%.*]] = load i32, i32* [[RS1_ADDR]], align 4
// RV32ZBP-NEXT:    [[TMP1:%.*]] = call i32 @llvm.riscv.shfl.i32(i32 [[TMP0]], i32 13)
// RV32ZBP-NEXT:    ret i32 [[TMP1]]
//
long shfli(long rs1)
{
  const int i = 13;
  return __builtin_riscv_shfl_32(rs1, i);
}

// RV32ZBP-LABEL: @unshfl(
// RV32ZBP-NEXT:  entry:
// RV32ZBP-NEXT:    [[RS1_ADDR:%.*]] = alloca i32, align 4
// RV32ZBP-NEXT:    [[RS2_ADDR:%.*]] = alloca i32, align 4
// RV32ZBP-NEXT:    store i32 [[RS1:%.*]], i32* [[RS1_ADDR]], align 4
// RV32ZBP-NEXT:    store i32 [[RS2:%.*]], i32* [[RS2_ADDR]], align 4
// RV32ZBP-NEXT:    [[TMP0:%.*]] = load i32, i32* [[RS1_ADDR]], align 4
// RV32ZBP-NEXT:    [[TMP1:%.*]] = load i32, i32* [[RS2_ADDR]], align 4
// RV32ZBP-NEXT:    [[TMP2:%.*]] = call i32 @llvm.riscv.unshfl.i32(i32 [[TMP0]], i32 [[TMP1]])
// RV32ZBP-NEXT:    ret i32 [[TMP2]]
//
long unshfl(long rs1, long rs2)
{
  return __builtin_riscv_unshfl_32(rs1, rs2);
}

// RV32ZBP-LABEL: @unshfli(
// RV32ZBP-NEXT:  entry:
// RV32ZBP-NEXT:    [[RS1_ADDR:%.*]] = alloca i32, align 4
// RV32ZBP-NEXT:    [[I:%.*]] = alloca i32, align 4
// RV32ZBP-NEXT:    store i32 [[RS1:%.*]], i32* [[RS1_ADDR]], align 4
// RV32ZBP-NEXT:    store i32 13, i32* [[I]], align 4
// RV32ZBP-NEXT:    [[TMP0:%.*]] = load i32, i32* [[RS1_ADDR]], align 4
// RV32ZBP-NEXT:    [[TMP1:%.*]] = call i32 @llvm.riscv.unshfl.i32(i32 [[TMP0]], i32 13)
// RV32ZBP-NEXT:    ret i32 [[TMP1]]
//
long unshfli(long rs1)
{
  const int i = 13;
  return __builtin_riscv_unshfl_32(rs1, i);
}

// RV32ZBP-LABEL: @xperm_n(
// RV32ZBP-NEXT:  entry:
// RV32ZBP-NEXT:    [[RS1_ADDR:%.*]] = alloca i32, align 4
// RV32ZBP-NEXT:    [[RS2_ADDR:%.*]] = alloca i32, align 4
// RV32ZBP-NEXT:    store i32 [[RS1:%.*]], i32* [[RS1_ADDR]], align 4
// RV32ZBP-NEXT:    store i32 [[RS2:%.*]], i32* [[RS2_ADDR]], align 4
// RV32ZBP-NEXT:    [[TMP0:%.*]] = load i32, i32* [[RS1_ADDR]], align 4
// RV32ZBP-NEXT:    [[TMP1:%.*]] = load i32, i32* [[RS2_ADDR]], align 4
// RV32ZBP-NEXT:    [[TMP2:%.*]] = call i32 @llvm.riscv.xperm.n.i32(i32 [[TMP0]], i32 [[TMP1]])
// RV32ZBP-NEXT:    ret i32 [[TMP2]]
//
long xperm_n(long rs1, long rs2)
{
  return __builtin_riscv_xperm_n(rs1, rs2);
}

// RV32ZBP-LABEL: @xperm_b(
// RV32ZBP-NEXT:  entry:
// RV32ZBP-NEXT:    [[RS1_ADDR:%.*]] = alloca i32, align 4
// RV32ZBP-NEXT:    [[RS2_ADDR:%.*]] = alloca i32, align 4
// RV32ZBP-NEXT:    store i32 [[RS1:%.*]], i32* [[RS1_ADDR]], align 4
// RV32ZBP-NEXT:    store i32 [[RS2:%.*]], i32* [[RS2_ADDR]], align 4
// RV32ZBP-NEXT:    [[TMP0:%.*]] = load i32, i32* [[RS1_ADDR]], align 4
// RV32ZBP-NEXT:    [[TMP1:%.*]] = load i32, i32* [[RS2_ADDR]], align 4
// RV32ZBP-NEXT:    [[TMP2:%.*]] = call i32 @llvm.riscv.xperm.b.i32(i32 [[TMP0]], i32 [[TMP1]])
// RV32ZBP-NEXT:    ret i32 [[TMP2]]
//
long xperm_b(long rs1, long rs2)
{
  return __builtin_riscv_xperm_b(rs1, rs2);
}

// RV32ZBP-LABEL: @xperm_h(
// RV32ZBP-NEXT:  entry:
// RV32ZBP-NEXT:    [[RS1_ADDR:%.*]] = alloca i32, align 4
// RV32ZBP-NEXT:    [[RS2_ADDR:%.*]] = alloca i32, align 4
// RV32ZBP-NEXT:    store i32 [[RS1:%.*]], i32* [[RS1_ADDR]], align 4
// RV32ZBP-NEXT:    store i32 [[RS2:%.*]], i32* [[RS2_ADDR]], align 4
// RV32ZBP-NEXT:    [[TMP0:%.*]] = load i32, i32* [[RS1_ADDR]], align 4
// RV32ZBP-NEXT:    [[TMP1:%.*]] = load i32, i32* [[RS2_ADDR]], align 4
// RV32ZBP-NEXT:    [[TMP2:%.*]] = call i32 @llvm.riscv.xperm.h.i32(i32 [[TMP0]], i32 [[TMP1]])
// RV32ZBP-NEXT:    ret i32 [[TMP2]]
//
long xperm_h(long rs1, long rs2)
{
  return __builtin_riscv_xperm_h(rs1, rs2);
}
