/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.taskdefs.optional.junit.XMLConstants;
import org.apache.tools.ant.util.DOMElementWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class XMLJUnitResultFormatter
implements JUnitResultFormatter,
XMLConstants {
    private NumberFormat nf = NumberFormat.getInstance(Locale.US);
    private Document doc;
    private Element rootElement;
    private Element currentTest;
    private long lastTestStart = 0L;
    private OutputStream out;

    private static DocumentBuilder getDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }

    public void setOutput(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void startTestSuite(JUnitTest jUnitTest) {
        this.doc = XMLJUnitResultFormatter.getDocumentBuilder().newDocument();
        this.rootElement = this.doc.createElement("testsuite");
        this.rootElement.setAttribute("name", jUnitTest.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void endTestSuite(JUnitTest jUnitTest) throws BuildException {
        this.rootElement.setAttribute("tests", "" + jUnitTest.runCount());
        this.rootElement.setAttribute("failures", "" + jUnitTest.failureCount());
        this.rootElement.setAttribute("errors", "" + jUnitTest.errorCount());
        this.rootElement.setAttribute("time", this.nf.format((double)jUnitTest.getRunTime() / 1000.0));
        if (this.out == null) return;
        OutputStreamWriter outputStreamWriter = null;
        try {
            try {
                outputStreamWriter = new OutputStreamWriter(this.out);
                outputStreamWriter.write("<?xml version=\"1.0\"?>\n");
                new DOMElementWriter().write(this.rootElement, (Writer)outputStreamWriter, 0, "  ");
                ((Writer)outputStreamWriter).flush();
            }
            catch (IOException iOException) {
                throw new BuildException("Unable to write log file", (Throwable)iOException);
            }
            Object var5_3 = null;
            if (this.out == System.out) return;
            if (this.out == System.err) return;
            if (outputStreamWriter == null) return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (this.out == System.out) throw throwable;
            if (this.out == System.err) throw throwable;
            if (outputStreamWriter == null) throw throwable;
            try {
                ((Writer)outputStreamWriter).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        ((Writer)outputStreamWriter).close();
        return;
    }

    public void startTest(Test test) {
        this.lastTestStart = System.currentTimeMillis();
        this.currentTest = this.doc.createElement("testcase");
        this.currentTest.setAttribute("name", ((TestCase)test).name());
        this.rootElement.appendChild(this.currentTest);
    }

    public void endTest(Test test) {
        this.currentTest.setAttribute("time", this.nf.format((double)(System.currentTimeMillis() - this.lastTestStart) / 1000.0));
    }

    public void addFailure(Test test, Throwable throwable) {
        this.formatError("failure", test, throwable);
    }

    public void addFailure(Test test, AssertionFailedError assertionFailedError) {
        this.addFailure(test, (Throwable)assertionFailedError);
    }

    public void addError(Test test, Throwable throwable) {
        this.formatError("error", test, throwable);
    }

    private void formatError(String string, Test test, Throwable throwable) {
        if (test != null) {
            this.endTest(test);
        }
        Element element = this.doc.createElement(string);
        if (test != null) {
            this.currentTest.appendChild(element);
        } else {
            this.rootElement.appendChild(element);
        }
        String string2 = throwable.getMessage();
        if (string2 != null && string2.length() > 0) {
            element.setAttribute("message", throwable.getMessage());
        }
        element.setAttribute("type", throwable.getClass().getName());
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)stringWriter, true));
        Text text = this.doc.createTextNode(stringWriter.toString());
        element.appendChild(text);
    }
}

