/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sound;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;

public class AntSoundPlayer
implements LineListener,
BuildListener {
    private File fileSuccess = null;
    private int loopsSuccess = 0;
    private Long durationSuccess = null;
    private File fileFail = null;
    private int loopsFail = 0;
    private Long durationFail = null;
    static /* synthetic */ Class class$javax$sound$sampled$Clip;

    public void addBuildSuccessfulSound(File file, int n, Long l) {
        this.fileSuccess = file;
        this.loopsSuccess = n;
        this.durationSuccess = l;
    }

    public void addBuildFailedSound(File file, int n, Long l) {
        this.fileFail = file;
        this.loopsFail = n;
        this.durationFail = l;
    }

    private void play(Project project, File file, int n, Long l) {
        Clip clip = null;
        AudioInputStream audioInputStream = null;
        try {
            audioInputStream = AudioSystem.getAudioInputStream(file);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            project.log("Audio format is not yet supported: " + unsupportedAudioFileException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (audioInputStream != null) {
            AudioFormat audioFormat = audioInputStream.getFormat();
            DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$Clip == null ? (class$javax$sound$sampled$Clip = AntSoundPlayer.class$("javax.sound.sampled.Clip")) : class$javax$sound$sampled$Clip, audioFormat, -1);
            try {
                clip = (Clip)AudioSystem.getLine(info);
                clip.addLineListener(this);
                clip.open(audioInputStream);
            }
            catch (LineUnavailableException lineUnavailableException) {
                project.log("The sound device is currently unavailable");
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (l != null) {
                this.playClip(clip, l);
            } else {
                this.playClip(clip, n);
            }
            clip.drain();
            clip.close();
        } else {
            project.log("Can't get data from file " + file.getName());
        }
    }

    private void playClip(Clip clip, int n) {
        clip.loop(n);
        while (clip.isRunning()) {
        }
    }

    private void playClip(Clip clip, long l) {
        long l2 = System.currentTimeMillis();
        clip.loop(-1);
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void update(LineEvent lineEvent) {
        if (lineEvent.getType().equals(LineEvent.Type.STOP)) {
            Line line = lineEvent.getLine();
            line.close();
        } else if (lineEvent.getType().equals(LineEvent.Type.CLOSE)) {
            // empty if block
        }
    }

    public void buildStarted(BuildEvent buildEvent) {
    }

    public void buildFinished(BuildEvent buildEvent) {
        if (buildEvent.getException() == null && this.fileSuccess != null) {
            this.play(buildEvent.getProject(), this.fileSuccess, this.loopsSuccess, this.durationSuccess);
        } else if (buildEvent.getException() != null && this.fileFail != null) {
            this.play(buildEvent.getProject(), this.fileFail, this.loopsFail, this.durationFail);
        }
    }

    public void targetStarted(BuildEvent buildEvent) {
    }

    public void targetFinished(BuildEvent buildEvent) {
    }

    public void taskStarted(BuildEvent buildEvent) {
    }

    public void taskFinished(BuildEvent buildEvent) {
    }

    public void messageLogged(BuildEvent buildEvent) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

