/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.lib.sql;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.xalan.lib.sql.ColumnHeader;
import org.apache.xalan.lib.sql.Row;
import org.apache.xalan.lib.sql.StreamableNode;
import org.apache.xalan.lib.sql.XStatement;
import org.apache.xpath.patterns.NodeTest;
import org.w3c.dom.Node;

public class RowSet
extends StreamableNode {
    private static final int ROWSET_POS_NONE = 0;
    private static final int ROWSET_POS_COLHDR = 1;
    private static final int ROWSET_POS_ROW = 2;
    private int m_RowSetPos = 0;
    ColumnHeader[] m_columnHeaders = null;
    Row m_firstrow;
    private static final boolean DEBUG = false;

    public RowSet(XStatement xStatement) {
        super(xStatement);
        try {
            ResultSetMetaData resultSetMetaData;
            int n;
            if (this.m_columnHeaders == null && (n = (resultSetMetaData = xStatement.m_resultSet.getMetaData()).getColumnCount()) > 0) {
                this.m_columnHeaders = new ColumnHeader[n];
                int n2 = 0;
                while (n2 < n) {
                    this.m_columnHeaders[n2] = new ColumnHeader(this.getXStatement(), this, n2, resultSetMetaData);
                    ++n2;
                }
            }
        }
        catch (SQLException sQLException) {
            this.m_columnHeaders = null;
        }
    }

    public Node getFirstChild() {
        NodeTest nodeTest = this.getNodeTest();
        if (nodeTest == null || nodeTest.getLocalName().equals("column-header")) {
            this.m_RowSetPos = 1;
            return this.getFirstColHdr();
        }
        if (nodeTest.getLocalName().equals("row")) {
            this.m_RowSetPos = 2;
            return this.getFirstRow();
        }
        return null;
    }

    private Node getFirstColHdr() {
        if (this.m_columnHeaders != null) {
            return this.m_columnHeaders[0];
        }
        return null;
    }

    private Node getFirstRow() {
        XStatement xStatement = this.getXStatement();
        try {
            if (this.m_firstrow == null) {
                ResultSet resultSet = this.getXStatement().getResultSet();
                this.m_firstrow = resultSet.next() ? new Row(this.getXStatement(), this, null) : null;
            } else if (!xStatement.getShouldCacheNodes()) {
                return null;
            }
        }
        catch (SQLException sQLException) {
            return null;
        }
        return this.m_firstrow;
    }

    public Node getNextSibling() {
        switch (this.m_RowSetPos) {
            case 0: {
                return this.getFirstColHdr();
            }
            case 1: {
                return this.getFirstRow();
            }
        }
        return null;
    }

    public String getNodeName() {
        return "row-set";
    }

    public Node getParentNode() {
        return this.getXStatement();
    }

    public boolean hasChildNodes() {
        return true;
    }
}

