/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;

public class SignJar
extends Task {
    protected String jar;
    protected String alias;
    protected String keystore;
    protected String storepass;
    protected String storetype;
    protected String keypass;
    protected String sigfile;
    protected String signedjar;
    protected boolean verbose;
    protected boolean internalsf;
    protected boolean sectionsonly;

    public void setJar(String string) {
        this.jar = string;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public void setKeystore(String string) {
        this.keystore = string;
    }

    public void setStorepass(String string) {
        this.storepass = string;
    }

    public void setStoretype(String string) {
        this.storetype = string;
    }

    public void setKeypass(String string) {
        this.keypass = string;
    }

    public void setSigfile(String string) {
        this.sigfile = string;
    }

    public void setSignedjar(String string) {
        this.signedjar = string;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setInternalsf(boolean bl) {
        this.internalsf = bl;
    }

    public void setSectionsonly(boolean bl) {
        this.sectionsonly = bl;
    }

    public void execute() throws BuildException {
        if (Project.getJavaVersion().equals("1.1")) {
            throw new BuildException("The signjar task is only available on JDK versions 1.2 or greater");
        }
        if (null == this.jar) {
            throw new BuildException("jar attribute must be set");
        }
        if (null == this.alias) {
            throw new BuildException("alias attribute must be set");
        }
        if (null == this.storepass) {
            throw new BuildException("storepass attribute must be set");
        }
        if (this.isUpToDate()) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        ExecTask execTask = (ExecTask)this.project.createTask("exec");
        execTask.setExecutable("jarsigner");
        if (null != this.keystore) {
            execTask.createArg().setValue("-keystore");
            execTask.createArg().setValue(this.keystore);
        }
        if (null != this.storepass) {
            execTask.createArg().setValue("-storepass");
            execTask.createArg().setValue(this.storepass);
        }
        if (null != this.storetype) {
            execTask.createArg().setValue("-storetype");
            execTask.createArg().setValue(this.storetype);
        }
        if (null != this.keypass) {
            execTask.createArg().setValue("-keypass");
            execTask.createArg().setValue(this.keypass);
        }
        if (null != this.sigfile) {
            execTask.createArg().setValue("-sigfile");
            execTask.createArg().setValue(this.sigfile);
        }
        if (null != this.signedjar) {
            execTask.createArg().setValue("-signedjar");
            execTask.createArg().setValue(this.signedjar);
        }
        if (this.verbose) {
            execTask.createArg().setValue("-verbose");
        }
        if (this.internalsf) {
            execTask.createArg().setValue("-internalsf");
        }
        if (this.sectionsonly) {
            execTask.createArg().setValue("-sectionsonly");
        }
        execTask.createArg().setValue(this.jar);
        execTask.createArg().setValue(this.alias);
        this.log("Signing Jar : " + new File(this.jar).getAbsolutePath());
        execTask.setFailonerror(true);
        execTask.setTaskName(this.getTaskName());
        execTask.execute();
    }

    protected boolean isUpToDate() {
        if (null != this.jar && null != this.signedjar) {
            File file = new File(this.jar);
            File file2 = new File(this.signedjar);
            if (!file.exists()) {
                return false;
            }
            if (!file2.exists()) {
                return false;
            }
            if (file.equals(file2)) {
                return false;
            }
            if (file2.lastModified() > file.lastModified()) {
                return true;
            }
        }
        return false;
    }
}

