/*
 * Decompiled with CFR 0.152.
 */
package liqp.filters;

import java.util.Arrays;
import java.util.HashMap;
import liqp.LValue;
import liqp.filters.Append;
import liqp.filters.Capitalize;
import liqp.filters.Date;
import liqp.filters.Divided_By;
import liqp.filters.Downcase;
import liqp.filters.Escape;
import liqp.filters.Escape_Once;
import liqp.filters.First;
import liqp.filters.H;
import liqp.filters.Join;
import liqp.filters.Last;
import liqp.filters.Map;
import liqp.filters.Minus;
import liqp.filters.Modulo;
import liqp.filters.Newline_To_Br;
import liqp.filters.Plus;
import liqp.filters.Prepend;
import liqp.filters.Remove;
import liqp.filters.Remove_First;
import liqp.filters.Replace;
import liqp.filters.Replace_First;
import liqp.filters.Size;
import liqp.filters.Sort;
import liqp.filters.Split;
import liqp.filters.Strip_HTML;
import liqp.filters.Strip_Newlines;
import liqp.filters.Times;
import liqp.filters.Truncate;
import liqp.filters.Truncatewords;
import liqp.filters.Upcase;

public abstract class Filter
extends LValue {
    private static final java.util.Map<String, Filter> FILTERS = new HashMap<String, Filter>();
    public final String name;

    protected Filter() {
        this.name = this.getClass().getSimpleName().toLowerCase();
    }

    public Filter(String name) {
        this.name = name;
    }

    public abstract Object apply(Object var1, Object ... var2);

    public final void checkParams(Object[] params, int expected) {
        if (params == null || params.length != expected) {
            throw new RuntimeException("Liquid error: wrong number of arguments (" + (params.length + 1) + " for " + (expected + 1) + ")");
        }
    }

    protected Object get(int index, Object ... params) {
        if (index >= params.length) {
            throw new RuntimeException("error in filter '" + this.name + "': cannot get param index: " + index + " from: " + Arrays.toString(params));
        }
        return params[index];
    }

    public static Filter getFilter(String name) {
        Filter filter = FILTERS.get(name);
        if (filter == null) {
            throw new RuntimeException("unknown filter: " + name);
        }
        return filter;
    }

    public static java.util.Map<String, Filter> getFilters() {
        return new HashMap<String, Filter>(FILTERS);
    }

    public static void registerFilter(Filter filter) {
        FILTERS.put(filter.name, filter);
    }

    static {
        Filter.registerFilter(new Append());
        Filter.registerFilter(new Capitalize());
        Filter.registerFilter(new Date());
        Filter.registerFilter(new Divided_By());
        Filter.registerFilter(new Downcase());
        Filter.registerFilter(new Escape());
        Filter.registerFilter(new Escape_Once());
        Filter.registerFilter(new First());
        Filter.registerFilter(new H());
        Filter.registerFilter(new Join());
        Filter.registerFilter(new Last());
        Filter.registerFilter(new Map());
        Filter.registerFilter(new Minus());
        Filter.registerFilter(new Modulo());
        Filter.registerFilter(new Newline_To_Br());
        Filter.registerFilter(new Plus());
        Filter.registerFilter(new Prepend());
        Filter.registerFilter(new Remove());
        Filter.registerFilter(new Remove_First());
        Filter.registerFilter(new Replace());
        Filter.registerFilter(new Replace_First());
        Filter.registerFilter(new Size());
        Filter.registerFilter(new Sort());
        Filter.registerFilter(new Split());
        Filter.registerFilter(new Strip_HTML());
        Filter.registerFilter(new Strip_Newlines());
        Filter.registerFilter(new Times());
        Filter.registerFilter(new Truncate());
        Filter.registerFilter(new Truncatewords());
        Filter.registerFilter(new Upcase());
    }
}

