#pragma once
namespace shtools {
extern "C"
{
  void PlmBar(double* p,
              const int lmax,
              const double z,
              const int* csphase = nullptr,
              const int* cnorm = nullptr,
              int* exitstatus = nullptr);
  void PlmBar_d1(double* p,
                 double* dp1,
                 const int lmax,
                 const double z,
                 const int* csphase = nullptr,
                 const int* cnorm = nullptr,
                 int* exitstatus = nullptr);
  void PlBar(double* p,
             const int lmax,
             const double z,
             int* exitstatus = nullptr);
  void PlBar_d1(double* p,
                double* dp1,
                const int lmax,
                const double z,
                int* exitstatus = nullptr);
  void PlmON(double* p,
             const int lmax,
             const double z,
             const int* csphase = nullptr,
             const int* cnorm = nullptr,
             int* exitstatus = nullptr);
  void PlmON_d1(double* p,
                double* dp1,
                const int lmax,
                const double z,
                const int* csphase = nullptr,
                const int* cnorm = nullptr,
                int* exitstatus = nullptr);
  void PlON(double* p,
            const int lmax,
            const double z,
            int* exitstatus = nullptr);
  void PlON_d1(double* p,
               double* dp1,
               const int lmax,
               const double z,
               int* exitstatus = nullptr);
  void PlmSchmidt(double* p,
                  const int lmax,
                  const double z,
                  const int* csphase = nullptr,
                  const int* cnorm = nullptr,
                  int* exitstatus = nullptr);
  void PlmSchmidt_d1(double* p,
                     double* dp1,
                     const int lmax,
                     const double z,
                     const int* csphase = nullptr,
                     const int* cnorm = nullptr,
                     int* exitstatus = nullptr);
  void PlSchmidt(double* p,
                 const int lmax,
                 const double z,
                 int* exitstatus = nullptr);
  void PlSchmidt_d1(double* p,
                    double* dp1,
                    const int lmax,
                    const double z,
                    int* exitstatus = nullptr);
  void PLegendreA(double* p,
                  const int lmax,
                  const double z,
                  const int* csphase = nullptr,
                  int* exitstatus = nullptr);
  void PLegendreA_d1(double* p,
                     double* dp1,
                     const int lmax,
                     const double z,
                     const int* csphase = nullptr,
                     int* exitstatus = nullptr);
  void PLegendre(double* p,
                 const int lmax,
                 const double z,
                 int* exitstatus = nullptr);
  void PLegendre_d1(double* p,
                    double* dp1,
                    const int lmax,
                    const double z,
                    int* exitstatus = nullptr);
  int PlmIndex(const int l, const int m);
  void SHExpandDH(const double* grid,
                  const int grid_d0,
                  const int grid_d1,
                  const int n,
                  double* cilm,
                  const int cilm_dim,
                  int* lmax,
                  const int* norm = nullptr,
                  const int* sampling = nullptr,
                  const int* csphase = nullptr,
                  const int* lmax_calc = nullptr,
                  int* exitstatus = nullptr);
  void MakeGridDH(double* griddh,
                  const int griddh_d0,
                  const int griddh_d1,
                  int* n,
                  const double* cilm,
                  const int cilm_dim,
                  const int lmax,
                  const int* norm = nullptr,
                  const int* sampling = nullptr,
                  const int* csphase = nullptr,
                  const int* lmax_calc = nullptr,
                  const int* extend = nullptr,
                  int* exitstatus = nullptr);
  void SHExpandDHC(const double _Complex* grid,
                   const int grid_d0,
                   const int grid_d1,
                   const int n,
                   double _Complex* cilm,
                   const int cilm_dim,
                   int* lmax,
                   const int* norm = nullptr,
                   const int* sampling = nullptr,
                   const int* csphase = nullptr,
                   const int* lmax_calc = nullptr,
                   int* exitstatus = nullptr);
  void MakeGridDHC(double _Complex* griddh,
                   const int griddh_d0,
                   const int griddh_d1,
                   int* n,
                   const double _Complex* cilm,
                   const int cilm_dim,
                   const int lmax,
                   const int* norm = nullptr,
                   const int* sampling = nullptr,
                   const int* csphase = nullptr,
                   const int* lmax_calc = nullptr,
                   const int* extend = nullptr,
                   int* exitstatus = nullptr);
  void SHGLQ(const int lmax,
             double* zero,
             double* w,
             double* plx = nullptr,
             const int* norm = nullptr,
             const int* csphase = nullptr,
             const int* cnorm = nullptr,
             int* exitstatus = nullptr);
  void SHExpandGLQ(double* cilm,
                   const int cilm_dim,
                   const int lmax,
                   const double* gridglq,
                   const double* w,
                   const double* plx = nullptr,
                   const double* zero = nullptr,
                   const int* norm = nullptr,
                   const int* csphase = nullptr,
                   const int* lmax_calc = nullptr,
                   int* exitstatus = nullptr);
  void MakeGridGLQ(double* gridglq,
                   const int gridglq_d0,
                   const int gridglq_d1,
                   const double* cilm,
                   const int cilm_dim,
                   const int lmax,
                   const double* plx = nullptr,
                   const double* zero = nullptr,
                   const int* norm = nullptr,
                   const int* csphase = nullptr,
                   const int* lmax_calc = nullptr,
                   const int* extend = nullptr,
                   int* exitstatus = nullptr);
  void SHExpandGLQC(double _Complex* cilm,
                    const int cilm_dim,
                    const int lmax,
                    const double _Complex* gridglq,
                    const double* w,
                    const double* plx = nullptr,
                    const double* zero = nullptr,
                    const int* norm = nullptr,
                    const int* csphase = nullptr,
                    const int* lmax_calc = nullptr,
                    int* exitstatus = nullptr);
  void MakeGridGLQC(double _Complex* gridglq,
                    const int gridglq_d0,
                    const int gridglq_d1,
                    const double _Complex* cilm,
                    const int cilm_dim,
                    const int lmax,
                    const double* plx = nullptr,
                    const double* zero = nullptr,
                    const int* norm = nullptr,
                    const int* csphase = nullptr,
                    const int* lmax_calc = nullptr,
                    const int* extend = nullptr,
                    int* exitstatus = nullptr);
  void GLQGridCoord(double* latglq,
                    const int latglq_d0,
                    double* longlq,
                    const int longlq_d0,
                    const int lmax,
                    int* nlat,
                    int* nlong,
                    const int* extend = nullptr,
                    int* exitstatus = nullptr);
  void SHExpandLSQ(double* cilm,
                   const int cilm_dim,
                   const double* d,
                   const double* lat,
                   const double* lon,
                   const int nmax,
                   const int lmax,
                   const int* norm = nullptr,
                   double* chi2 = nullptr,
                   const int* csphase = nullptr,
                   const double* weights = nullptr,
                   int* exitstatus = nullptr);
  void MakeGrid2d(double* grid,
                  const int grid_d0,
                  const int grid_d1,
                  const double* cilm,
                  const int cilm_dim,
                  const int lmax,
                  const double interval,
                  int* nlat,
                  int* nlong,
                  const int* norm = nullptr,
                  const int* csphase = nullptr,
                  const double* f = nullptr,
                  const double* a = nullptr,
                  const double* north = nullptr,
                  const double* south = nullptr,
                  const double* east = nullptr,
                  const double* west = nullptr,
                  const int* dealloc = nullptr,
                  int* exitstatus = nullptr);
  double MakeGridPoint(const double* cilm,
                       const int cilm_dim,
                       const int lmax,
                       const double lat,
                       const double lon,
                       const int* norm = nullptr,
                       const int* csphase = nullptr,
                       const int* dealloc = nullptr);
  double _Complex MakeGridPointC(const double _Complex* cilm,
                                 const int cilm_dim,
                                 const int lmax,
                                 const double lat,
                                 const double lon,
                                 const int* norm = nullptr,
                                 const int* csphase = nullptr,
                                 const int* dealloc = nullptr);
  void SHMultiply(double* cilmout,
                  const int cilmout_dim,
                  const double* cilm1,
                  const int cilm1_dim,
                  const int lmax1,
                  const double* cilm2,
                  const int cilm2_dim,
                  const int lmax2,
                  const int* precomp = nullptr,
                  const int* norm = nullptr,
                  const int* csphase = nullptr,
                  int* exitstatus = nullptr);
  void SHRead(const char* filename,
              const int filename_d1,
              double* cilm,
              const int cilm_dim,
              int* lmax,
              const int* skip = nullptr,
              double* header = nullptr,
              const int header_d0 = 0,
              double* error = nullptr,
              int* exitstatus = nullptr);
  void SHRead2(const char* filename,
               const int filename_d1,
               double* cilm,
               const int cilm_dim,
               int* lmax,
               double* gm,
               double* r0_pot,
               double* error = nullptr,
               double* dot = nullptr,
               const int dot_dim = 0,
               double* doystart = nullptr,
               double* doyend = nullptr,
               double* epoch = nullptr,
               int* exitstatus = nullptr);
  void SHReadJPL(const char* filename,
                 const int filename_d1,
                 double* cilm,
                 const int cilm_dim,
                 const int lmax,
                 double* error = nullptr,
                 double* gm = nullptr,
                 const char* formatstring = nullptr,
                 int* exitstatus = nullptr);
  void SHCilmToVector(const double* cilm,
                      const int cilm_dim,
                      double* vector,
                      const int lmax,
                      int* exitstatus = nullptr);
  void SHVectorToCilm(const double* vector,
                      double* cilm,
                      const int cilm_dim,
                      const int lmax,
                      int* exitstatus = nullptr);
  void SHCilmToCindex(const double* cilm,
                      const int cilm_dim,
                      double* cindex,
                      const int cindex_d1,
                      const int* degmax = nullptr,
                      int* exitstatus = nullptr);
  void SHCindexToCilm(const double* cindex,
                      const int cindex_d1,
                      double* cilm,
                      const int cilm_dim,
                      const int* degmax = nullptr,
                      int* exitstatus = nullptr);
  void SHrtoc(const double* rcilm,
              const int rcilm_dim,
              double* ccilm,
              const int ccilm_dim,
              const int* degmax = nullptr,
              const int* convention = nullptr,
              const int* switchcs = nullptr,
              int* exitstatus = nullptr);
  void SHctor(const double* ccilm,
              const int ccilm_dim,
              double* rcilm,
              const int rcilm_dim,
              const int* degmax = nullptr,
              const int* convention = nullptr,
              const int* switchcs = nullptr,
              int* exitstatus = nullptr);
  void djpi2(double* dj,
             const int dj_dim,
             const int lmax,
             int* exitstatus = nullptr);
  void SHRotateCoef(const double* x,
                    const double* cof,
                    const int cof_d0,
                    const int cof_d1,
                    double* rcof,
                    const int rcof_d1,
                    const double* dj,
                    const int dj_dim,
                    const int lmax,
                    int* exitstatus = nullptr);
  void SHRotateRealCoef(double* cilmrot,
                        const int cilmrot_dim,
                        const double* cilm,
                        const int cilm_dim,
                        const int lmax,
                        const double* x,
                        const double* dj,
                        const int dj_dim,
                        int* exitstatus = nullptr);
  double SHPowerL(const double* cilm, const int cilm_dim, const int l);
  double SHPowerDensityL(const double* cilm, const int cilm_dim, const int l);
  double SHCrossPowerL(const double* cilm1,
                       const int cilm1_dim,
                       const double* cilm2,
                       const int cilm2_dim,
                       const int l);
  double SHCrossPowerDensityL(const double* cilm1,
                              const int cilm1_dim,
                              const double* cilm2,
                              const int cilm2_dim,
                              const int l);
  void SHPowerSpectrum(const double* cilm,
                       const int cilm_dim,
                       const int lmax,
                       double* spectra,
                       int* exitstatus = nullptr);
  void SHPowerSpectrumDensity(const double* cilm,
                              const int cilm_dim,
                              const int lmax,
                              double* spectra,
                              int* exitstatus = nullptr);
  void SHCrossPowerSpectrum(const double* cilm1,
                            const int cilm1_dim,
                            const double* cilm2,
                            const int cilm2_dim,
                            const int lmax,
                            double* cspectra,
                            int* exitstatus = nullptr);
  void SHCrossPowerSpectrumDensity(const double* cilm1,
                                   const int cilm1_dim,
                                   const double* cilm2,
                                   const int cilm2_dim,
                                   const int lmax,
                                   double* cspectra,
                                   int* exitstatus = nullptr);
  void SHAdmitCorr(const double* gilm,
                   const int gilm_dim,
                   const double* tilm,
                   const int tilm_dim,
                   const int lmax,
                   double* admit,
                   double* corr,
                   double* admit_error = nullptr,
                   int* exitstatus = nullptr);
  double SHConfidence(const int l_conf, const double r);
  double SHPowerLC(const double _Complex* cilm,
                   const int cilm_dim,
                   const int l);
  double SHPowerDensityLC(const double _Complex* cilm,
                          const int cilm_dim,
                          const int l);
  double _Complex SHCrossPowerLC(const double _Complex* cilm1,
                                 const int cilm1_dim,
                                 const double _Complex* cilm2,
                                 const int cilm2_dim,
                                 const int l);
  double _Complex SHCrossPowerDensityLC(const double _Complex* cilm1,
                                        const int cilm1_dim,
                                        const double _Complex* cilm2,
                                        const int cilm2_dim,
                                        const int l);
  void SHPowerSpectrumC(const double _Complex* cilm,
                        const int cilm_dim,
                        const int lmax,
                        double* spectra,
                        int* exitstatus = nullptr);
  void SHPowerSpectrumDensityC(const double _Complex* cilm,
                               const int cilm_dim,
                               const int lmax,
                               double* spectra,
                               int* exitstatus = nullptr);
  void SHCrossPowerSpectrumC(const double _Complex* cilm1,
                             const int cilm1_dim,
                             const double _Complex* cilm2,
                             const int cilm2_dim,
                             const int lmax,
                             double _Complex* cspectra,
                             int* exitstatus = nullptr);
  void SHCrossPowerSpectrumDensityC(const double _Complex* cilm1,
                                    const int cilm1_dim,
                                    const double _Complex* cilm2,
                                    const int cilm2_dim,
                                    const int lmax,
                                    double _Complex* cspectra,
                                    int* exitstatus = nullptr);
  void SHMultiTaperSE(double* mtse,
                      double* sd,
                      const double* cilm,
                      const int cilm_dim,
                      const int lmax,
                      const double* tapers,
                      const int tapers_d0,
                      const int tapers_d1,
                      const int* taper_order,
                      const int lmaxt,
                      const int k,
                      const double* alpha = nullptr,
                      const double* lat = nullptr,
                      const double* lon = nullptr,
                      const double* taper_wt = nullptr,
                      const int* norm = nullptr,
                      const int* csphase = nullptr,
                      int* exitstatus = nullptr);
  void SHMultiTaperCSE(double* mtse,
                       double* sd,
                       const double* cilm1,
                       const int cilm1_dim,
                       const int lmax1,
                       const double* cilm2,
                       const int cilm2_dim,
                       const int lmax2,
                       const double* tapers,
                       const int tapers_d0,
                       const int tapers_d1,
                       const int* taper_order,
                       const int lmaxt,
                       const int k,
                       const double* alpha = nullptr,
                       const double* lat = nullptr,
                       const double* lon = nullptr,
                       const double* taper_wt = nullptr,
                       const int* norm = nullptr,
                       const int* csphase = nullptr,
                       int* exitstatus = nullptr);
  void SHLocalizedAdmitCorr(const double* tapers,
                            const int tapers_d0,
                            const int tapers_d1,
                            const int* taper_order,
                            const int lwin,
                            const double lat,
                            const double lon,
                            const double* gilm,
                            const int gilm_dim,
                            const double* tilm,
                            const int tilm_dim,
                            const int lmax,
                            double* admit,
                            double* corr,
                            const int k,
                            double* admit_error = nullptr,
                            double* corr_error = nullptr,
                            const double* taper_wt = nullptr,
                            const int* mtdef = nullptr,
                            const int* k1linsig = nullptr,
                            int* exitstatus = nullptr);
  void SHReturnTapers(const double theta0,
                      const int lmax,
                      double* tapers,
                      const int tapers_dim,
                      double* eigenvalues,
                      int* taper_order,
                      const int* degrees = nullptr,
                      int* exitstatus = nullptr);
  void SHReturnTapersM(const double theta0,
                       const int lmax,
                       const int m,
                       double* tapers,
                       const int tapers_dim,
                       double* eigenvalues,
                       double* shannon = nullptr,
                       const int* degrees = nullptr,
                       int* ntapers = nullptr,
                       int* exitstatus = nullptr);
  void ComputeDm(double* dllm,
                 const int dllm_d0,
                 const int dllm_d1,
                 const int lmax,
                 const int m,
                 const double theta0,
                 const int* degrees = nullptr,
                 int* exitstatus = nullptr);
  void ComputeDG82(double* dG82,
                   const int dG82_d0,
                   const int dG82_d1,
                   const int lmax,
                   const int m,
                   const double theta0,
                   int* exitstatus = nullptr);
  int SHFindLWin(const double theta0,
                 const int m,
                 const double alpha,
                 const int* taper_number = nullptr);
  void SHBiasK(const double* tapers,
               const int tapers_d0,
               const int tapers_d1,
               const int lwin,
               const int k,
               const double* incspectra,
               const int ldata,
               double* outcspectra,
               const double* taper_wt = nullptr,
               const int* save_cg = nullptr,
               int* exitstatus = nullptr);
  void SHMTCouplingMatrix(double* Mmt,
                          const int Mmt_d0,
                          const int Mmt_d1,
                          const int lmax,
                          const double* tapers_power,
                          const int tapers_power_d0,
                          const int tapers_power_d1,
                          const int lwin,
                          const int k,
                          const double* taper_wt = nullptr,
                          int* exitstatus = nullptr);
  void SHBiasAdmitCorr(const double* sgt,
                       const double* sgg,
                       const double* stt,
                       const int lmax,
                       const double* tapers,
                       const int tapers_d0,
                       const int tapers_d1,
                       const int lwin,
                       const int k,
                       double* admit,
                       double* corr,
                       const int* mtdef = nullptr,
                       const double* taper_wt = nullptr,
                       int* exitstatus = nullptr);
  void SHMTDebias(double* mtdebias,
                  const int mtdebias_d1,
                  const double* mtspectra,
                  const int mtspectra_d1,
                  const int lmax,
                  const double* tapers,
                  const int tapers_d0,
                  const int tapers_d1,
                  const int lwin,
                  const int k,
                  const int nl,
                  double* lmid,
                  int* n,
                  const double* taper_wt = nullptr,
                  int* exitstatus = nullptr);
  void SHMTVarOpt(const int l,
                  const double* tapers,
                  const int tapers_d0,
                  const int tapers_d1,
                  const int* taper_order,
                  const int lwin,
                  const int kmax,
                  const double* Sff,
                  double* var_opt,
                  double* var_unit,
                  double* weight_opt = nullptr,
                  const int weight_opt_d0 = 0,
                  const int weight_opt_d1 = 0,
                  double* unweighted_covar = nullptr,
                  const int unweighted_covar_d0 = 0,
                  const int unweighted_covar_d1 = 0,
                  const int* nocross = nullptr,
                  int* exitstatus = nullptr);
  void SHMTVar(const int l,
               const double* tapers,
               const int tapers_d0,
               const int tapers_d1,
               const int* taper_order,
               const int lwin,
               const int kmax,
               const double* Sff,
               double* variance,
               const double* taper_wt = nullptr,
               const int taper_wt_d0 = 0,
               double* unweighted_covar = nullptr,
               const int unweighted_covar_d0 = 0,
               const int unweighted_covar_d1 = 0,
               const int* nocross = nullptr,
               int* exitstatus = nullptr);
  double _Complex SHSjkPG(const double* incspectra,
                          const int l,
                          const int m,
                          const int mprime,
                          const double* hj_real,
                          const double* hk_real,
                          const int mj,
                          const int mk,
                          const int lwin,
                          const int hkcc);
  void SHReturnTapersMap(double* tapers,
                         const int tapers_d0,
                         const int tapers_d1,
                         double* eigenvalues,
                         const int* dh_mask,
                         const int dh_mask_d0,
                         const int dh_mask_d1,
                         const int n_dh,
                         const int lmax,
                         const int sampling,
                         const int ntapers,
                         const int* degrees = nullptr,
                         int* exitstatus = nullptr);
  void SHBiasKMask(const double* tapers,
                   const int tapers_d0,
                   const int tapers_d1,
                   const int lwin,
                   const int k,
                   const double* incspectra,
                   const int ldata,
                   double* outcspectra,
                   const double* taper_wt = nullptr,
                   const int* save_cg = nullptr,
                   int* exitstatus = nullptr);
  void SHMultiTaperMaskSE(double* mtse,
                          double* sd,
                          const double* cilm,
                          const int cilm_dim,
                          const int lmax,
                          const double* tapers,
                          const int tapers_d0,
                          const int tapers_d1,
                          const int lmaxt,
                          const int k,
                          const double* taper_wt = nullptr,
                          const int* norm = nullptr,
                          const int* csphase = nullptr,
                          int* exitstatus = nullptr);
  void SHMultiTaperMaskCSE(double* mtse,
                           double* sd,
                           const double* cilm1,
                           const int cilm1_dim,
                           const int lmax1,
                           const double* cilm2,
                           const int cilm2_dim,
                           const int lmax2,
                           const double* tapers,
                           const int tapers_d0,
                           const int tapers_d1,
                           const int lmaxt,
                           const int k,
                           const double* taper_wt = nullptr,
                           const int* norm = nullptr,
                           const int* csphase = nullptr,
                           int* exitstatus = nullptr);
  void ComputeDMap(double* Dij,
                   const int dij_dim,
                   const int* dh_mask,
                   const int dh_mask_d0,
                   const int dh_mask_d1,
                   const int n_dh,
                   const int lmax,
                   const int* sampling = nullptr,
                   const int* degrees = nullptr,
                   int* exitstatus = nullptr);
  void Curve2Mask(int* dhgrid,
                  const int dhgrid_d0,
                  const int dhgrid_d1,
                  const int n,
                  const int sampling,
                  const double* profile,
                  const int profile_d0,
                  const int profile_d1,
                  const int nprofile,
                  int* NP,
                  const int* extend = nullptr,
                  int* exitstatus = nullptr);
  void SHBias(const double* Shh,
              const int lwin,
              const double* incspectra,
              const int ldata,
              double* outcspectra,
              const int* save_cg = nullptr,
              int* exitstatus = nullptr);
  void SphericalCapCoef(double* coef,
                        const double theta,
                        const int lmax,
                        int* exitstatus = nullptr);
  void MakeGravGridDH(const double* cilm,
                      const int cilm_dim,
                      const int lmax,
                      const double gm,
                      const double r0,
                      const double a,
                      const double f,
                      double* rad,
                      const int nlon,
                      const int nlat,
                      double* theta,
                      double* phi,
                      double* total,
                      int* n,
                      const int* sampling = nullptr,
                      const int* lmax_calc = nullptr,
                      const double* omega = nullptr,
                      const int* normal_gravity = nullptr,
                      double* pot = nullptr,
                      const int* extend = nullptr,
                      int* exitstatus = nullptr);
  void MakeGravGradGridDH(const double* cilm,
                          const int cilm_dim,
                          const int lmax,
                          const double gm,
                          const double r0,
                          const double a,
                          const double f,
                          double* vxx,
                          const int nlon,
                          const int nlat,
                          double* vyy,
                          double* vzz,
                          double* vxy,
                          double* vxz,
                          double* vyz,
                          int* n,
                          const int* sampling = nullptr,
                          const int* lmax_calc = nullptr,
                          const int* extend = nullptr,
                          int* exitstatus = nullptr);
  void MakeMagGradGridDH(const double* cilm,
                         const int cilm_dim,
                         const int lmax,
                         const double r0,
                         const double a,
                         const double f,
                         double* vxx,
                         const int nlon,
                         const int nlat,
                         double* vyy,
                         double* vzz,
                         double* vxy,
                         double* vxz,
                         double* vyz,
                         int* n,
                         const int* sampling = nullptr,
                         const int* lmax_calc = nullptr,
                         const int* extend = nullptr,
                         int* exitstatus = nullptr);
  void MakeGeoidGrid(double* geoid,
                     const int geoid_d0,
                     const int geoid_d1,
                     const double* cilm,
                     const int cilm_dim,
                     const int lmax,
                     const double r0pot,
                     const double GM,
                     const double PotRef,
                     const double omega,
                     const double r,
                     const int gridtype,
                     const int order,
                     int* nlat,
                     int* nlong,
                     const double* interval = nullptr,
                     const int* lmax_calc = nullptr,
                     const double* a = nullptr,
                     const double* f = nullptr,
                     const int* extend = nullptr,
                     int* exitstatus = nullptr);
  void CilmPlus(double* cilm,
                const int cilm_dim,
                const double* gridin,
                const int gridin_d0,
                const int gridin_d1,
                const int lmax,
                const int nmax,
                const double mass,
                double* d,
                const double rho,
                const int gridtype,
                const double* w = nullptr,
                const double* zero = nullptr,
                const double* plx = nullptr,
                const int plx_d0 = 0,
                const int plx_d1 = 0,
                const int* n = nullptr,
                const double* dref = nullptr,
                int* exitstatus = nullptr);
  void CilmMinus(double* cilm,
                 const int cilm_dim,
                 const double* gridin,
                 const int gridin_d0,
                 const int gridin_d1,
                 const int lmax,
                 const int nmax,
                 const double mass,
                 double* d,
                 const double rho,
                 const int gridtype,
                 const double* w = nullptr,
                 const double* zero = nullptr,
                 const double* plx = nullptr,
                 const int plx_d0 = 0,
                 const int plx_d1 = 0,
                 const int* n = nullptr,
                 const double* dref = nullptr,
                 int* exitstatus = nullptr);
  void CilmPlusRhoH(double* cilm,
                    const int cilm_dim,
                    const double* gridin,
                    const int gridin_d0,
                    const int gridin_d1,
                    const int lmax,
                    const int nmax,
                    const double mass,
                    double* d,
                    const double* rho,
                    const int rho_d0,
                    const int rho_d1,
                    const int gridtype,
                    const double* w = nullptr,
                    const double* zero = nullptr,
                    const double* plx = nullptr,
                    const int plx_d0 = 0,
                    const int plx_d1 = 0,
                    const int* n = nullptr,
                    const double* dref = nullptr,
                    int* exitstatus = nullptr);
  void CilmMinusRhoH(double* cilm,
                     const int cilm_dim,
                     const double* gridin,
                     const int gridin_d0,
                     const int gridin_d1,
                     const int lmax,
                     const int nmax,
                     const double mass,
                     double* d,
                     const double* rho,
                     const int rho_d0,
                     const int rho_d1,
                     const int gridtype,
                     const double* w = nullptr,
                     const double* zero = nullptr,
                     const double* plx = nullptr,
                     const int plx_d0 = 0,
                     const int plx_d1 = 0,
                     const int* n = nullptr,
                     const double* dref = nullptr,
                     int* exitstatus = nullptr);
  void BAtoHilm(double* cilm,
                const int cilm_dim,
                const double* ba,
                const int ba_dim,
                const double* gridglq,
                const int gridglq_d0,
                const int gridglq_d1,
                const int lmax,
                const int nmax,
                const double mass,
                const double r0,
                const double rho,
                const int gridtype,
                const double* w = nullptr,
                const double* plx = nullptr,
                const int plx_d0 = 0,
                const int plx_d1 = 0,
                const double* zero = nullptr,
                const int* filter_type = nullptr,
                const int* filter_deg = nullptr,
                const int* lmax_calc = nullptr,
                int* exitstatus = nullptr);
  void BAtoHilmRhoH(double* cilm,
                    const int cilm_dim,
                    const double* ba,
                    const int ba_dim,
                    const double* gridglq,
                    const int gridglq_d0,
                    const int gridglq_d1,
                    const int lmax,
                    const int nmax,
                    const double mass,
                    const double r0,
                    const double* rho,
                    const int rho_d0,
                    const int rho_d1,
                    const int gridtype,
                    const double* w = nullptr,
                    const double* plx = nullptr,
                    const int plx_d0 = 0,
                    const int plx_d1 = 0,
                    const double* zero = nullptr,
                    const int* filter_type = nullptr,
                    const int* filter_deg = nullptr,
                    const int* lmax_calc = nullptr,
                    int* exitstatus = nullptr);
  double DownContFilterMA(const int l,
                          const int half,
                          const double r,
                          const double d);
  double DownContFilterMC(const int l,
                          const int half,
                          const double r,
                          const double d);
  double NormalGravity(const double geocentric_lat,
                       const double gm,
                       const double omega,
                       const double a,
                       const double b);
  void MakeMagGridDH(const double* cilm,
                     const int cilm_dim,
                     const int lmax,
                     const double r0,
                     const double a,
                     const double f,
                     double* rad_grid,
                     const int nlon,
                     const int nlat,
                     double* theta_grid,
                     double* phi_grid,
                     double* total_grid,
                     int* n,
                     const int* sampling = nullptr,
                     const int* lmax_calc = nullptr,
                     double* pot_grid = nullptr,
                     const int* extend = nullptr,
                     int* exitstatus = nullptr);
  void SHMagPowerSpectrum(const double* cilm,
                          const int cilm_dim,
                          const double a,
                          const double r,
                          const int lmax,
                          double* spectra,
                          int* exitstatus = nullptr);
  double SHMagPowerL(const double* cilm,
                     const int cilm_dim,
                     const double a,
                     const double r,
                     const int l);
  void MakeCircleCoord(double* coord,
                       const int coord_d0,
                       const double lat,
                       const double lon,
                       const double theta0,
                       const double* cinterval = nullptr,
                       int* cnum = nullptr,
                       int* exitstatus = nullptr);
  void MakeEllipseCoord(double* coord,
                        const int coord_d0,
                        const double lat,
                        const double lon,
                        const double dec,
                        const double A_theta,
                        const double B_theta,
                        const double* cinterval = nullptr,
                        int* cnum = nullptr,
                        int* exitstatus = nullptr);
  void Wigner3j(double* w3j,
                int* jmin,
                int* jmax,
                const int j2,
                const int j3,
                const int m1,
                const int m2,
                const int m3,
                int* exitstatus = nullptr);
  double RandomN(int* idum);
  double RandomGaussian(int* idum);
  void PreGLQ(const double x1,
              const double x2,
              const int n,
              double* zero,
              double* w,
              int* exitstatus = nullptr);
  int NGLQ(const int degree);
  int NGLQSH(const int degree);
  int NGLQSHN(const int degree, const int n);
  void DHaj(const int n,
            double* aj,
            const int aj_d0,
            const int* extend = nullptr,
            int* exitstatus = nullptr);
  int YilmIndexVector(const int i, const int l, const int m);
  void EigValVecSym(const double* ain,
                    const int n,
                    double* eig,
                    const int eig_d0,
                    double* evec,
                    const int evec_d1,
                    const char* ul = nullptr,
                    const int* K = nullptr,
                    int* exitstatus = nullptr);
  void EigValVecSymTri(const double* ain,
                       const int n,
                       double* eig,
                       double* evec,
                       const char* ul = nullptr,
                       int* exitstatus = nullptr);
  void EigValSym(const double* ain,
                 const int n,
                 double* eval,
                 const char* ul = nullptr);
  void SHRotateTapers(double* tapersrot,
                      const int tapersrot_d0,
                      const int tapersrot_d1,
                      const double* tapers,
                      const int tapers_d0,
                      const int tapers_d1,
                      const int* taper_order,
                      const int lmax,
                      const int nrot,
                      const double* x,
                      const double* dj,
                      const int dj_dim,
                      int* exitstatus = nullptr);
  void SlepianCoeffs(double* falpha,
                     const double* galpha,
                     const int galpha_d0,
                     const int galpha_d1,
                     const double* film,
                     const int film_dim,
                     const int lmax,
                     const int nmax,
                     int* exitstatus = nullptr);
  void SlepianCoeffsToSH(double* film,
                         const int film_dim,
                         const double* falpha,
                         const double* galpha,
                         const int galpha_d0,
                         const int galpha_d1,
                         const int lmax,
                         const int nmax,
                         int* exitstatus = nullptr);
  void SHSCouplingMatrix(double* kij,
                         const int kij_d0,
                         const int kij_d1,
                         const double* galpha,
                         const int galpha_d0,
                         const int galpha_d1,
                         const int lmax,
                         const int nmax,
                         int* exitstatus = nullptr);
  void SHSlepianVar(const int l,
                    const double* galpha,
                    const int galpha_d0,
                    const int galpha_d1,
                    const int* galpha_order,
                    const int lmax,
                    const int kmax,
                    const double* Sff,
                    double* variance,
                    int* exitstatus = nullptr);
  void SHSCouplingMatrixCap(double* kij,
                            const int kij_d0,
                            const int kij_d1,
                            const double* galpha,
                            const int galpha_d0,
                            const int galpha_d1,
                            const int* galpha_order,
                            const int lmax,
                            const int nmax,
                            int* exitstatus = nullptr);
}
}
