/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jv.vecmath.PdVector;

public class EquationAdmin
extends JPanel
implements ActionListener {
    Equation oldeq;
    public String img_filename;
    JPanel eqnpanel = new JPanel();
    RayFrame rayFrame;
    int rtPOVRAY = 0;
    int rtSURF;
    int raytracer = this.rtSURF = 1;
    public jv4surfex jv4sx;
    private surfex surfex_;
    private Project project;
    private double[] ang = new double[3];
    private double[] scale = new double[3];
    Vector eqnList = new Vector();
    int eqncounter = 0;
    int ProjectNumber;
    String projectName;
    String filename;
    PdVector lastUpVector;
    PdVector lastViewDir;
    PdVector lastPosition;
    PdVector lastInterest;
    double lastScale;

    EquationAdmin(jv4surfex jv4surfex2, RayFrame rayFrame, surfex surfex2, Project project) {
        this.project = project;
        this.surfex_ = surfex2;
        this.img_filename = surfex.tmpDir + "test.png";
        this.jv4sx = jv4surfex2;
        this.rayFrame = rayFrame;
        this.projectName = "Project 1";
        this.lastScale = 1.0;
        this.lastViewDir = new PdVector(3.2, 0.3, -0.9);
        this.lastPosition = new PdVector(10.0, 20.0, -20.0);
        this.lastUpVector = new PdVector(0.0, 1.0, 0.0);
        this.lastInterest = new PdVector(0.0, 1.0, 0.0);
        this.ang[0] = 3.2;
        this.ang[1] = 0.3;
        this.ang[2] = -0.9;
        this.scale[0] = this.lastScale;
        this.scale[1] = this.lastScale;
        this.scale[2] = this.lastScale;
    }

    public void clear() {
        this.eqnList.clear();
        this.eqncounter = 0;
        this.eqnpanel.removeAll();
    }

    public Vector getEqNrs() {
        Vector<Object> vector = new Vector<Object>();
        vector.add("-");
        ListIterator listIterator = this.eqnList.listIterator();
        while (listIterator.hasNext()) {
            vector.add(new Integer(((Equation)listIterator.next()).eqnr));
        }
        return vector;
    }

    public Equation getEqnFromNo(int n) {
        ListIterator listIterator = this.eqnList.listIterator();
        while (listIterator.hasNext()) {
            Equation equation = (Equation)listIterator.next();
            if (equation.eqnr != n) continue;
            return equation;
        }
        return null;
    }

    EquationAdmin(int n, String string, RayFrame rayFrame, surfex surfex2, jv4surfex jv4surfex2, Project project) {
        this.project = project;
        this.jv4sx = jv4surfex2;
        this.filename = string;
        this.rayFrame = rayFrame;
        this.ProjectNumber = n;
        this.projectName = "Project" + n;
        this.surfex_ = surfex2;
        this.img_filename = surfex.tmpDir + "test.png";
        this.lastScale = 1.0;
        this.lastViewDir = new PdVector(3.2, 0.3, -0.9);
        this.lastPosition = new PdVector(10.0, 20.0, -20.0);
        this.lastUpVector = new PdVector(0.0, 1.0, 0.0);
        this.lastInterest = new PdVector(0.0, 1.0, 0.0);
        this.ang[0] = 3.2;
        this.ang[1] = 0.3;
        this.ang[2] = -0.9;
        this.scale[0] = this.lastScale;
        this.scale[1] = this.lastScale;
        this.scale[2] = this.lastScale;
        this.setLayout(new BorderLayout());
        this.eqnpanel.setLayout(new GridLayout(20, 0));
        this.newEquation();
        this.oldeq = (Equation)this.eqnList.firstElement();
        ((Equation)this.eqnList.firstElement()).setBasePlaneDefault();
        this.add(this.eqnpanel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.length() >= 15 && string.substring(0, 15).hashCode() == "basePlaneButton".hashCode()) {
            ListIterator listIterator = this.eqnList.listIterator();
            this.oldeq.setBasePlane(false);
            while (listIterator.hasNext()) {
                Equation equation = (Equation)listIterator.next();
                if (equation.basePlaneButton.getActionCommand() != string) continue;
                this.oldeq = equation;
                this.updateScale();
                equation.setBasePlane(true, this.jv4sx, this.scale);
            }
        }
        if (string.length() >= 17 && string.substring(0, 17).hashCode() == "deletePlaneButton".hashCode()) {
            int n = new Integer(string.substring(17, string.length()));
            if (((Equation)this.eqnList.elementAt(n - 1)).isBasePlane()) {
                this.updateScale();
                if (n != 1) {
                    ((Equation)this.eqnList.elementAt(n - 2)).setBasePlane(true, this.jv4sx, this.scale);
                } else if (this.eqnList.size() >= 2) {
                    ((Equation)this.eqnList.elementAt(n)).setBasePlane(true, this.jv4sx, this.scale);
                }
            }
            this.eqnList.removeElementAt(n - 1);
            this.updateEquationPanel();
        }
    }

    public void updateScale() {
        this.scale[0] = 1.0 / this.jv4sx.getScale();
        this.scale[1] = 1.0 / this.jv4sx.getScale();
        this.scale[2] = 1.0 / this.jv4sx.getScale();
    }

    public String fileFormatFromExt(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return "";
        }
        String string2 = string.substring(n + 1);
        if (string2.equals("ras")) {
            return "sun";
        }
        if (string2.equals("tif")) {
            return "tiff";
        }
        if (string2.equals("JPG")) {
            return "jpg";
        }
        return string2;
    }

    public String getSurfCode_Part1(Dimension dimension, boolean bl, jv4surfex jv4surfex2) {
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        return this.getSurfCode_Part1(dimension, bl, "rot_x=0.0; rot_y=0.0; rot_z=0.0;\n", null, null, jv4surfex2, dArray);
    }

    public String getSurfCode_Part1(Dimension dimension, boolean bl, String[] stringArray, double[] dArray, jv4surfex jv4surfex2) {
        double[] dArray2 = new double[]{0.0, 0.0, 0.0};
        return this.getSurfCode_Part1(dimension, bl, "rot_x=0.0; rot_y=0.0; rot_z=0.0;\n", stringArray, dArray, jv4surfex2, dArray2);
    }

    public String getSurfCode_Part1(Dimension dimension, boolean bl, String string, String[] stringArray, double[] dArray, jv4surfex jv4surfex2, double[] dArray2) {
        int n;
        if (dimension.width % 2 == 1) {
            --dimension.width;
        }
        if (dimension.height % 2 == 1) {
            --dimension.height;
        }
        String string2 = "";
        string2 = string2 + "root_finder = " + this.project.getRootFinder() + "; epsilon = " + this.project.getEpsilon() + ";\n";
        string2 = string2 + "illumination = ambient_light + diffuse_light + reflected_light + transmitted_light;\n";
        string2 = string2 + "ambient      = 40;\ndiffuse      = 80;\nreflected    = 80;\ntransmitted  = 20;\n";
        string2 = string2 + "smoothness   = 50;\ntransparence = 0;\n";
        string2 = string2 + "thickness = 10;\n";
        string2 = bl ? string2 + "antialiasing = 6;\n" : string2 + "antialiasing = 0;\n";
        string2 = string2 + "background_red=" + this.project.bgColorButton.getBackground().getRed() + ";\n" + "background_green=" + this.project.bgColorButton.getBackground().getGreen() + ";\n" + "background_blue=" + this.project.bgColorButton.getBackground().getBlue() + ";\n";
        string2 = string2 + "width=" + dimension.width + ";\n" + "height=" + dimension.height + ";\n";
        string2 = string2 + string;
        string2 = string2 + "scale_x=" + this.scale[0] + ";\n" + "scale_y=" + this.scale[1] + ";\n" + "scale_z=" + this.scale[2] + ";\n";
        string2 = string2 + "double PI = 2*arcsin(1);";
        string2 = string2 + "\n// the parameters:\n";
        int n2 = 0;
        int n3 = 1;
        ListIterator listIterator = this.project.parAdmin.parList.listIterator();
        while (listIterator.hasNext()) {
            OneParameter oneParameter = (OneParameter)listIterator.next();
            String string3 = oneParameter.getSurfCode();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (oneParameter.nameLabel.getText().compareTo(stringArray[i]) != 0) continue;
                    string3 = oneParameter.getSurfCode(dArray[i]) + "\n";
                }
            }
            string2 = string2 + string3;
            ++n2;
            ++n3;
        }
        string2 = string2 + "\n// the equations:\n";
        listIterator = this.eqnList.listIterator();
        int n4 = 0;
        int n5 = 1;
        while (listIterator.hasNext()) {
            Equation equation = (Equation)listIterator.next();
            string2 = string2 + equation.getPolyCode("f" + n5) + "\n";
            ++n5;
        }
        while (listIterator.hasPrevious()) {
            listIterator.previous();
        }
        n4 = 0;
        n5 = 1;
        while (listIterator.hasNext()) {
            Equation equation = (Equation)listIterator.next();
            equation.surf_no = -1;
            if (equation.isSelected() && equation.visType.getSelectedIndex() != 2 && n4 <= 9) {
                string2 = string2 + equation.getSurfCode("f" + n5, n4 + 1, jv4surfex2.getCameraRotationYXZ()) + "\n";
                equation.surf_no = ++n4;
            }
            ++n5;
        }
        while (listIterator.hasPrevious()) {
            listIterator.previous();
        }
        int n6 = 0;
        int n7 = 1;
        String string4 = "";
        while (listIterator.hasNext()) {
            Equation equation = (Equation)listIterator.next();
            if (equation.isSelected() && equation.visType.getSelectedIndex() == 2 && n6 <= 9) {
                string4 = n6 >= 1 ? "" + (n6 + 1) : "";
                string2 = string2 + "clip_surface" + string4 + " = f" + n7 + ";\n";
                equation.surf_no = ++n6;
            }
            ++n7;
        }
        string2 = string2 + "\n// the solitary points (shown as spheres):\n";
        listIterator = this.project.solPtsAdm.solPtsList.listIterator();
        int n8 = 0;
        String string5 = "";
        int n9 = n4;
        while (listIterator.hasNext()) {
            Equation equation;
            SolitaryPoint solitaryPoint = (SolitaryPoint)listIterator.next();
            if (solitaryPoint.radiusLabel.getText().equals("0.0")) continue;
            string2 = string2 + solitaryPoint.getSurfCode();
            ++n8;
            String string6 = solitaryPoint.getSurfNo();
            if (string6 == "-" || (equation = this.getEqnFromNo(Integer.parseInt(string6))) == null || equation.surf_no == -1) continue;
            string5 = equation.surf_no == 1 ? "surface" : "surface" + equation.surf_no;
            string2 = string2 + string5 + " = " + string5 + "*" + solitaryPoint.getName() + ";\n";
        }
        string2 = string2 + "\n// the rotation:\n";
        double[] dArray3 = jv4surfex2.getCameraRotationYXZ();
        for (n = 0; n < n4; ++n) {
            string5 = n == 0 ? "surface" : "surface" + (n + 1);
            string2 = string2 + string5 + "=rotate(" + string5 + "," + dArray2[0] + ",yAxis);\n";
            string2 = string2 + string5 + "=rotate(" + string5 + "," + dArray2[1] + ",xAxis);\n";
            string2 = string2 + string5 + "=rotate(" + string5 + "," + dArray2[2] + ",zAxis);\n";
            string2 = string2 + string5 + "=rotate(" + string5 + "," + dArray3[0] + ",yAxis);\n";
            string2 = string2 + string5 + "=rotate(" + string5 + "," + dArray3[1] + ",xAxis);\n";
            string2 = string2 + string5 + "=rotate(" + string5 + "," + dArray3[2] + ",zAxis);\n";
            if (dArray2[0] == 0.0) continue;
        }
        string2 = string2 + "clip = " + this.project.getClipMode() + ";\n";
        if (this.project.getClipMode() == 7) {
            string2 = string2 + "clip_front = 1000; clip_back = -1000;\n";
        }
        string2 = string2 + "radius = " + this.project.getClipRadius() + ";\n";
        string2 = string2 + "\n// the rotation:\n";
        for (n = 0; n < n6; ++n) {
            string5 = n == 0 ? "clip_surface" : "clip_surface" + (n + 1);
            string2 = string2 + string5 + "=rotate(" + string5 + "," + dArray2[0] + ",yAxis);\n";
            string2 = string2 + string5 + "=rotate(" + string5 + "," + dArray2[1] + ",xAxis);\n";
            string2 = string2 + string5 + "=rotate(" + string5 + "," + dArray2[2] + ",zAxis);\n";
            string2 = string2 + string5 + "=rotate(" + string5 + "," + dArray3[0] + ",yAxis);\n";
            string2 = string2 + string5 + "=rotate(" + string5 + "," + dArray3[1] + ",xAxis);\n";
            string2 = string2 + string5 + "=rotate(" + string5 + "," + dArray3[2] + ",zAxis);\n";
            if (dArray2[0] == 0.0) continue;
        }
        string2 = string2 + "draw_surface;\n";
        string2 = string2 + "\n// the curves:\n";
        listIterator = this.project.cuAdm.cunList.listIterator();
        n4 = 0;
        int n10 = 1;
        String string7 = "-";
        int n11 = -1;
        while (listIterator.hasNext()) {
            Curve curve = (Curve)listIterator.next();
            if (curve.isSelected() && !(string7 = curve.C[0].getSelectedItem().toString()).equals("-") && (n11 = ((Equation)this.eqnList.elementAt((int)(Integer.parseInt((String)string7) - 1))).surf_no) != -1) {
                string2 = string2 + curve.getSurfCode("c" + n10, n11, jv4surfex2.getCameraRotationYXZ());
                ++n4;
            }
            ++n10;
        }
        string2 = string2 + "\n// save the image:\n";
        string2 = string2 + "filename=\"";
        return string2;
    }

    public String getSurfCode_Part2(String string) {
        String string2 = "";
        string2 = string2 + "color_file_format=" + this.fileFormatFromExt(string) + ";\n";
        string2 = string2 + "save_color_image;\n";
        return string2;
    }

    public String getSurfCode_Dither_Part1(int n) {
        String string = "";
        string = string + "resolution = " + n + ";\n";
        string = string + "dither_surface;\n";
        string = string + "filename=\"";
        return string;
    }

    public String getSurfCode_Dither_Part2() {
        String string = "\";\n";
        string = string + "dither_file_format=tiff;\n";
        string = string + "save_dithered_image;\n";
        return string;
    }

    public void saveSurfCode(String string, String string2, boolean bl, jv4surfex jv4surfex2) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintWriter printWriter = new PrintWriter(fileOutputStream, true);
            printWriter.println("scale_x = " + this.scale[0] + ";");
            printWriter.println("scale_y = " + this.scale[1] + ";");
            printWriter.println("scale_z = " + this.scale[2] + ";");
            printWriter.println("radius=" + this.project.getClipRadius() + ";");
            printWriter.println("illumination = ambient_light + diffuse_light + reflected_light + transmitted_light;");
            printWriter.println("ambient      = 40;\ndiffuse      = 80;\nreflected    = 80;\ntransmitted  = 20;");
            printWriter.println("smoothness   = 50;\ntransparence = 0;");
            printWriter.println("thickness = 10;");
            if (bl) {
                printWriter.println("antialiasing = 6;\n");
            } else {
                printWriter.println("antialiasing = 0;\n");
            }
            printWriter.println("background_red=" + this.project.bgColorButton.getBackground().getRed() + "; " + "background_green=" + this.project.bgColorButton.getBackground().getGreen() + "; " + "background_blue=" + this.project.bgColorButton.getBackground().getBlue() + ";\n");
            ListIterator listIterator = this.eqnList.listIterator();
            int n = 0;
            int n2 = 1;
            while (listIterator.hasNext()) {
                Equation equation = (Equation)listIterator.next();
                if (equation.isSelected() && n <= 9) {
                    equation.savesurfCode(printWriter, "f" + n2, n + 1, jv4surfex2.getCameraRotationYXZ());
                    ++n;
                    printWriter.println("");
                }
                ++n2;
            }
            printWriter.println("draw_surface;");
            printWriter.println("filename=\"" + string2 + "\";");
            printWriter.println("color_file_format=" + this.fileFormatFromExt(string2) + ";");
            printWriter.println("save_color_image;");
            printWriter.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public void updateEquationPanel() {
        this.eqnpanel.removeAll();
        this.eqnpanel.setLayout(new GridLayout(20, 0));
        ListIterator listIterator = this.eqnList.listIterator();
        int n = 1;
        while (listIterator.hasNext()) {
            Equation equation = (Equation)listIterator.next();
            equation.updateActionCommands(n++);
            this.eqnpanel.add(equation);
        }
        SwingUtilities.updateComponentTreeUI(this);
    }

    public double[] getAngles() {
        this.ang = this.jv4sx.getCameraRotationYXZ();
        return this.ang;
    }

    public double[] getScales() {
        return this.scale;
    }

    public String vec2Str(double[] dArray) {
        return "<" + dArray[0] + "," + dArray[1] + "," + dArray[2] + ">";
    }

    public void newEquation() {
        Equation equation = new Equation(this.eqnList.size() + 1, ++this.eqncounter, this, this.jv4sx, this.surfex_);
        equation.colorButton_i.setBackground(this.project.appearanceScheme.getEquationColorInside(equation.getEqNo()));
        equation.colorButton_o.setBackground(this.project.appearanceScheme.getEquationColorOutside(equation.getEqNo()));
        this.eqnpanel.add(equation);
        this.eqnList.add(equation);
        equation.basePlaneButton.addActionListener(this);
        equation.deletePlaneButton.addActionListener(this);
        SwingUtilities.updateComponentTreeUI(this);
    }

    public void loadGeneralData(BufferedReader bufferedReader, String string, int n) {
        block18: {
            try {
                String string2 = bufferedReader.readLine();
                if (string.equals("complete") || string.equals("onlystyle")) {
                    this.lastUpVector = new PdVector(Double.parseDouble(bufferedReader.readLine()), Double.parseDouble(bufferedReader.readLine()), Double.parseDouble(bufferedReader.readLine()));
                    this.lastViewDir = new PdVector(Double.parseDouble(bufferedReader.readLine()), Double.parseDouble(bufferedReader.readLine()), Double.parseDouble(bufferedReader.readLine()));
                    this.lastPosition = new PdVector(Double.parseDouble(bufferedReader.readLine()), Double.parseDouble(bufferedReader.readLine()), Double.parseDouble(bufferedReader.readLine()));
                    this.lastInterest = new PdVector(Double.parseDouble(bufferedReader.readLine()), Double.parseDouble(bufferedReader.readLine()), Double.parseDouble(bufferedReader.readLine()));
                    this.jv4sx.setScale(Double.parseDouble(bufferedReader.readLine()));
                    this.project.setScale(this.jv4sx.getScale());
                    String string3 = bufferedReader.readLine();
                    int n2 = 0;
                    try {
                        n2 = Integer.parseInt(string3);
                    }
                    catch (Exception exception) {
                        double d = this.project.getScale();
                        try {
                            this.jv4sx.setScaleMinMax(Double.parseDouble(string3), Double.parseDouble(bufferedReader.readLine()));
                            n2 = Integer.parseInt(bufferedReader.readLine());
                        }
                        catch (Exception exception2) {
                            System.out.println("ex:" + exception2.toString());
                        }
                    }
                    this.project.bgColorButton.setBackground(new Color(n2, Integer.parseInt(bufferedReader.readLine()), Integer.parseInt(bufferedReader.readLine())));
                    this.project.antialiasing.setSelected(Boolean.valueOf(bufferedReader.readLine()));
                    if (n >= 8907) {
                        this.project.clipMode.setSelectedIndex(Integer.parseInt(bufferedReader.readLine()));
                        this.project.clipRadius.setText(bufferedReader.readLine());
                    }
                    break block18;
                }
                if (string.equals("specify")) {
                    System.out.println("load Data");
                    try {
                        String string4 = bufferedReader.readLine();
                        while (string4.equals("view:") || string4.equals("scale:") || string4.equals("background:") || string4.equals("antialiasing:") || string4.equals("clipMode:") || string4.equals("clipRadius:")) {
                            if (string4.equals("view:")) {
                                this.lastUpVector = new PdVector(Double.parseDouble(bufferedReader.readLine()), Double.parseDouble(bufferedReader.readLine()), Double.parseDouble(bufferedReader.readLine()));
                                this.lastViewDir = new PdVector(Double.parseDouble(bufferedReader.readLine()), Double.parseDouble(bufferedReader.readLine()), Double.parseDouble(bufferedReader.readLine()));
                                this.lastPosition = new PdVector(Double.parseDouble(bufferedReader.readLine()), Double.parseDouble(bufferedReader.readLine()), Double.parseDouble(bufferedReader.readLine()));
                                this.lastInterest = new PdVector(Double.parseDouble(bufferedReader.readLine()), Double.parseDouble(bufferedReader.readLine()), Double.parseDouble(bufferedReader.readLine()));
                            }
                            if (string4.equals("scale:")) {
                                this.lastScale = Double.parseDouble(bufferedReader.readLine());
                                this.jv4sx.setScale(this.lastScale);
                                this.project.setScale(this.jv4sx.getScale());
                            }
                            if (string4.equals("background:")) {
                                this.project.bgColorButton.setBackground(new Color(Integer.parseInt(bufferedReader.readLine()), Integer.parseInt(bufferedReader.readLine()), Integer.parseInt(bufferedReader.readLine())));
                            }
                            if (string4.equals("antialiasing:")) {
                                this.project.antialiasing.setSelected(Boolean.valueOf(bufferedReader.readLine()));
                            }
                            if (string4.equals("clipMode:")) {
                                this.project.clipMode.setSelectedIndex(Integer.parseInt(bufferedReader.readLine()));
                            }
                            if (string4.equals("clipRadius:")) {
                                this.project.clipRadius.setText(bufferedReader.readLine());
                            }
                            bufferedReader.mark(255);
                            string4 = bufferedReader.readLine();
                        }
                        bufferedReader.reset();
                    }
                    catch (Exception exception) {
                        bufferedReader.reset();
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("ex_lg:" + exception.toString());
            }
        }
        this.updateJV4SXandReconstructLastView();
    }

    public void loadEquations(BufferedReader bufferedReader, String string, int n) {
        try {
            String string2 = bufferedReader.readLine();
            String string3 = bufferedReader.readLine();
            boolean bl = true;
            for (int i = Integer.parseInt(string3); i > 0; --i) {
                String string4 = bufferedReader.readLine();
                if (bl) {
                    bl = false;
                } else {
                    this.newEquation();
                }
                if (string.equals("specify")) {
                    try {
                        bufferedReader.mark(255);
                        String string5 = bufferedReader.readLine();
                        while (string5.equals("eqno:") || string5.equals("equation:") || string5.equals("insidecolor:") || string5.equals("outsidecolor:") || string5.equals("basecolor:") || string5.equals("showcbox:") || string5.equals("clipping:") || string5.equals("clipradius:") || string5.equals("transparency:")) {
                            if (string5.equals("eqno:")) {
                                ((Equation)this.eqnList.lastElement()).setEquationNo(Integer.parseInt(bufferedReader.readLine()));
                            }
                            if (string5.equals("equation:")) {
                                ((Equation)this.eqnList.lastElement()).text.setText(bufferedReader.readLine());
                            }
                            if (string5.equals("insidecolor:")) {
                                ((Equation)this.eqnList.lastElement()).colorButton_i.setBackground(new Color(Integer.parseInt(bufferedReader.readLine()), Integer.parseInt(bufferedReader.readLine()), Integer.parseInt(bufferedReader.readLine())));
                            }
                            if (string5.equals("outsidecolor:")) {
                                ((Equation)this.eqnList.lastElement()).colorButton_o.setBackground(new Color(Integer.parseInt(bufferedReader.readLine()), Integer.parseInt(bufferedReader.readLine()), Integer.parseInt(bufferedReader.readLine())));
                            }
                            if (string5.equals("basecolor:")) {
                                int n2 = Integer.parseInt(bufferedReader.readLine());
                                if (n2 != 255) {
                                    ((Equation)this.eqnList.lastElement()).basePlaneButton.setBackground(new Color(0, 255, 0));
                                } else {
                                    ((Equation)this.eqnList.lastElement()).basePlaneButton.setBackground(new Color(255, 255, 255));
                                }
                            }
                            if (string5.equals("showcbox:")) {
                                ((Equation)this.eqnList.lastElement()).cbox.setSelected(Boolean.valueOf(bufferedReader.readLine()));
                            }
                            if (string5.equals("clipping:")) {
                                ((Equation)this.eqnList.lastElement()).optionButtonPane.bt2.setSelected(Boolean.valueOf(bufferedReader.readLine()) == false);
                            }
                            if (string5.equals("clipradius:")) {
                                ((Equation)this.eqnList.lastElement()).optionButtonPane.clipingRadiusTextField.setText(bufferedReader.readLine());
                            }
                            if (string5.equals("transparency:")) {
                                ((Equation)this.eqnList.lastElement()).optionButtonPane.slider1.setValue(Integer.parseInt(bufferedReader.readLine()));
                            }
                            bufferedReader.mark(255);
                            string5 = bufferedReader.readLine();
                        }
                        bufferedReader.reset();
                    }
                    catch (Exception exception) {
                        System.out.println("lE ex:" + exception);
                        bufferedReader.reset();
                    }
                    continue;
                }
                if (string.equals("complete") || string.equals("onlyeqns") || string.equals("eqnsvis")) {
                    ((Equation)this.eqnList.lastElement()).setEquationNo(Integer.parseInt(bufferedReader.readLine()));
                    ((Equation)this.eqnList.lastElement()).text.setText(bufferedReader.readLine());
                }
                if (string.equals("complete") || string.equals("onlystyle")) {
                    ((Equation)this.eqnList.lastElement()).colorButton_i.setBackground(new Color(Integer.parseInt(bufferedReader.readLine()), Integer.parseInt(bufferedReader.readLine()), Integer.parseInt(bufferedReader.readLine())));
                    ((Equation)this.eqnList.lastElement()).colorButton_o.setBackground(new Color(Integer.parseInt(bufferedReader.readLine()), Integer.parseInt(bufferedReader.readLine()), Integer.parseInt(bufferedReader.readLine())));
                    int n3 = Integer.parseInt(bufferedReader.readLine());
                    if (n3 != 255) {
                        ((Equation)this.eqnList.lastElement()).basePlaneButton.setBackground(new Color(0, 255, 0));
                    } else {
                        ((Equation)this.eqnList.lastElement()).basePlaneButton.setBackground(new Color(255, 255, 255));
                    }
                }
                if (string.equals("complete") || string.equals("onlystyle") || string.equals("eqnsvis")) {
                    ((Equation)this.eqnList.lastElement()).cbox.setSelected(Boolean.valueOf(bufferedReader.readLine()));
                    if (n >= 8907) {
                        ((Equation)this.eqnList.lastElement()).visType.setSelectedIndex(Integer.parseInt(bufferedReader.readLine()));
                    }
                }
                if (string.equals("complete") || string.equals("onlystyle")) {
                    ((Equation)this.eqnList.lastElement()).optionButtonPane.bt2.setSelected(Boolean.valueOf(bufferedReader.readLine()) == false);
                    ((Equation)this.eqnList.lastElement()).optionButtonPane.clipingRadiusTextField.setText(bufferedReader.readLine());
                }
                if (!string.equals("complete") && !string.equals("onlystyle") && !string.equals("eqnsvis")) continue;
                ((Equation)this.eqnList.lastElement()).optionButtonPane.slider1.setValue(Integer.parseInt(bufferedReader.readLine()));
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public void save(PrintWriter printWriter) {
        ListIterator listIterator = this.eqnList.listIterator();
        printWriter.println("////////////////// EQUATIONS: /////////////////////////");
        printWriter.println(this.eqnList.size());
        while (listIterator.hasNext()) {
            ((Equation)listIterator.next()).saveYourself(printWriter);
        }
    }

    public String save() {
        String string = "";
        ListIterator listIterator = this.eqnList.listIterator();
        string = string + "////////////////// EQUATIONS: /////////////////////////\n";
        string = string + this.eqnList.size() + "\n";
        while (listIterator.hasNext()) {
            string = string + ((Equation)listIterator.next()).saveYourself();
        }
        return string;
    }

    public void updateJV4SX() {
        ListIterator listIterator = this.eqnList.listIterator();
        while (listIterator.hasNext()) {
            Equation equation = (Equation)listIterator.next();
            if (!equation.isBasePlane()) continue;
            equation.updateJV4SX();
            break;
        }
        this.jv4sx.changeFrameTitle(this.projectName + "triangulated view - surfex (uses JavaView)");
    }

    public void updateJV4SXandReconstructLastView() {
        ListIterator listIterator = this.eqnList.listIterator();
        while (listIterator.hasNext()) {
            Equation equation = (Equation)listIterator.next();
            if (!equation.isBasePlane()) continue;
            equation.updateJV4SX();
            break;
        }
        this.jv4sx.disp.getCamera().setInterest(this.lastInterest);
        this.jv4sx.disp.getCamera().setPosition(this.lastPosition);
        this.jv4sx.disp.getCamera().setUpVector(this.lastUpVector);
        this.jv4sx.setScale(this.project.getScale());
        this.jv4sx.changeFrameTitle(this.projectName + "triangulated view - surfex (uses JavaView)");
    }
}

