/*
 * Decompiled with CFR 0.152.
 */
package jv.anim;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.anim.PsAnimation;
import jv.anim.PsKeyframeIf;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;

public class PsAnimation_IP
extends PsPanel
implements ActionListener,
ItemListener {
    protected PsAnimation m_anim;
    protected Checkbox m_cOneWay;
    protected Checkbox m_cLoop;
    protected Checkbox m_cBackForth;
    protected Button m_bRewind;
    protected Button m_bStart;
    protected Button m_bStop;
    protected Button m_bForward;
    protected Button m_bFirstKey;
    protected Button m_bPreviousKey;
    protected Button m_bNextKey;
    protected Button m_bLastKey;
    protected Panel m_labelPanel;
    protected Panel m_pKeyButtonPanel;
    private static /* synthetic */ Class class$jv$anim$PsAnimation_IP;

    public PsAnimation_IP() {
        if (this.getClass() == (class$jv$anim$PsAnimation_IP != null ? class$jv$anim$PsAnimation_IP : (class$jv$anim$PsAnimation_IP = PsAnimation_IP.class$("jv.anim.PsAnimation_IP")))) {
            this.init();
        }
    }

    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        if (source == this.m_cOneWay) {
            this.m_anim.setRepeat(0);
        } else if (source == this.m_cLoop) {
            this.m_anim.setRepeat(1);
        } else if (source == this.m_cBackForth) {
            this.m_anim.setRepeat(2);
        }
    }

    public void setParent(PsUpdateIf anAnim) {
        super.setParent(anAnim);
        if (anAnim != null && anAnim == this.m_anim) {
            return;
        }
        this.m_anim = (PsAnimation)anAnim;
        if (this.m_anim == null) {
            this.setTitle(PsConfig.getMessage("NoAnimationAttached"));
            PsDebug.notify("hide, since missing animation");
            this.setVisible(false);
            return;
        }
        this.enableKeys(this.m_anim.m_enableKeys);
        this.setTitle(this.m_anim.getName());
        this.m_labelPanel.removeAll();
        this.m_labelPanel.add(this.m_anim.m_currentTime.getInfoPanel());
    }

    public boolean update(Object event) {
        PsDebug.notify("called");
        if (this.m_anim == null) {
            PsDebug.warning("missing animation");
            return false;
        }
        if (event == this.m_anim) {
            this.setTitle(this.m_anim.getName());
            if (this.m_anim.m_repeat == 0) {
                this.m_cOneWay.setState(true);
            } else if (this.m_anim.m_repeat == 1) {
                this.m_cLoop.setState(true);
            } else if (this.m_anim.m_repeat == 2) {
                this.m_cBackForth.setState(true);
            }
            this.enableKeys(this.m_anim.m_enableKeys);
        }
        return super.update(event);
    }

    public void actionPerformed(ActionEvent event) {
        Object key;
        Object source = event.getSource();
        if (source == this.m_bRewind) {
            this.m_anim.start(3);
            return;
        }
        if (source == this.m_bStart) {
            this.m_anim.start(0);
            return;
        }
        if (source == this.m_bStop) {
            this.m_anim.stop();
            return;
        }
        if (source == this.m_bForward) {
            this.m_anim.start(2);
            return;
        }
        if (this.m_anim.m_enableKeys && this.m_anim.m_dynamicList != null && (key = this.m_anim.m_dynamicList.elementAt(0)) instanceof PsKeyframeIf) {
            PsKeyframeIf keyIf = (PsKeyframeIf)key;
            if (source == this.m_bFirstKey) {
                this.m_anim.setTime(keyIf.getTimeOfFirstKey());
                return;
            }
            if (source == this.m_bPreviousKey) {
                this.m_anim.setTime(keyIf.getTimeOfPreviousKey());
                return;
            }
            if (source == this.m_bNextKey) {
                this.m_anim.setTime(keyIf.getTimeOfNextKey());
                return;
            }
            if (source == this.m_bLastKey) {
                this.m_anim.setTime(keyIf.getTimeOfLastKey());
                return;
            }
        }
    }

    private static /* synthetic */ Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    protected void enableKeys(boolean flag) {
        if (flag) {
            if (this.m_bFirstKey == null) {
                this.m_bFirstKey = new Button(PsConfig.getMessage("bFirstKey"));
                this.m_bFirstKey.addActionListener(this);
                this.m_pKeyButtonPanel.add(this.m_bFirstKey);
                this.m_bPreviousKey = new Button(PsConfig.getMessage("bPreviousKey"));
                this.m_bPreviousKey.addActionListener(this);
                this.m_pKeyButtonPanel.add(this.m_bPreviousKey);
                this.m_bNextKey = new Button(PsConfig.getMessage("bNextKey"));
                this.m_bNextKey.addActionListener(this);
                this.m_pKeyButtonPanel.add(this.m_bNextKey);
                this.m_bLastKey = new Button(PsConfig.getMessage("bLastKey"));
                this.m_bLastKey.addActionListener(this);
                this.m_pKeyButtonPanel.add(this.m_bLastKey);
            }
        } else if (this.m_bFirstKey != null) {
            this.m_pKeyButtonPanel.removeAll();
            this.m_bFirstKey = null;
            this.m_bPreviousKey = null;
            this.m_bNextKey = null;
            this.m_bLastKey = null;
        }
    }

    public void init() {
        super.init();
        this.setLayout(new GridLayout(5, 1));
        Panel pControlButtons = new Panel();
        pControlButtons.setLayout(new GridLayout(1, 4));
        this.m_bRewind = new Button(PsConfig.getMessage("bRewind"));
        this.m_bRewind.addActionListener(this);
        pControlButtons.add(this.m_bRewind);
        this.m_bStart = new Button(PsConfig.getMessage("bStart"));
        this.m_bStart.addActionListener(this);
        pControlButtons.add(this.m_bStart);
        this.m_bStop = new Button(PsConfig.getMessage("bStop"));
        this.m_bStop.addActionListener(this);
        pControlButtons.add(this.m_bStop);
        this.m_bForward = new Button(PsConfig.getMessage("bForward"));
        this.m_bForward.addActionListener(this);
        pControlButtons.add(this.m_bForward);
        this.m_pKeyButtonPanel = new Panel();
        this.m_pKeyButtonPanel.setLayout(new GridLayout(1, 4));
        this.m_labelPanel = new Panel();
        this.m_labelPanel.setLayout(new GridLayout(1, 1));
        Panel pCheckbox = new Panel();
        pCheckbox.setLayout(new GridLayout(1, 3));
        this.add(pCheckbox);
        CheckboxGroup gCheckbox = new CheckboxGroup();
        this.m_cOneWay = new Checkbox(PsConfig.getMessage("cOneWay"), gCheckbox, false);
        this.m_cOneWay.addItemListener(this);
        pCheckbox.add(this.m_cOneWay);
        this.m_cLoop = new Checkbox(PsConfig.getMessage("cLoop"), gCheckbox, false);
        this.m_cLoop.addItemListener(this);
        pCheckbox.add(this.m_cLoop);
        this.m_cBackForth = new Checkbox(PsConfig.getMessage("cBackForth"), gCheckbox, true);
        this.m_cBackForth.addItemListener(this);
        pCheckbox.add(this.m_cBackForth);
        this.addTitle(PsConfig.getMessage("NoAnimationAttached"));
        this.add(this.m_labelPanel);
        this.add(pControlButtons);
        this.add(this.m_pKeyButtonPanel);
        this.add(pCheckbox);
    }
}

