/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import jv.geom.PgBndConstraint;
import jv.geom.PgElementEdge;
import jv.geom.PgElementSet;
import jv.geom.PgPolygon;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.project.PvGeometryIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;

public class PgBndPolygon
extends PgPolygon {
    protected static double MAX_PASTE_ANGLE = 50.0;
    protected static double MAX_LOGIC_ANGLE = 20.0;
    protected PgElementSet m_triang;
    protected PiVector m_vertexInd = new PiVector();
    protected PiVector m_elementInd = new PiVector();
    protected PiVector m_neighbourLocInd = new PiVector();
    protected boolean m_bConforming = true;
    protected PgBndConstraint m_bndConstraint;
    private static /* synthetic */ Class class$jv$geom$PgBndPolygon;

    public int bndcmp(PgBndPolygon b, double maxDist) {
        if (b == null) {
            PsDebug.warning("missing argument");
            return 0;
        }
        if (this.m_triang != b.m_triang) {
            PsDebug.warning("bnd's associated to different elementSets");
            return 0;
        }
        if (this.m_numVertices != b.m_numVertices) {
            return 0;
        }
        if (this.m_numVertices < 2 || b.m_numVertices < 2) {
            PsDebug.warning("bnd with less than 2 points");
            return 0;
        }
        int nop = this.m_numVertices;
        PdVector[] triangVertex = this.m_triang.m_vertex;
        int[] av = this.m_vertexInd.m_data;
        int[] bv = b.m_vertexInd.m_data;
        if (PdVector.dist(triangVertex[av[0]], triangVertex[bv[0]]) < maxDist && PdVector.dist(triangVertex[av[nop - 1]], triangVertex[bv[nop - 1]]) < maxDist && PdVector.dist(triangVertex[av[1]], triangVertex[bv[1]]) < maxDist) {
            return 1;
        }
        if (PdVector.dist(triangVertex[av[0]], triangVertex[bv[nop - 1]]) < maxDist && PdVector.dist(triangVertex[av[nop - 1]], triangVertex[bv[0]]) < maxDist && PdVector.dist(triangVertex[av[1]], triangVertex[bv[nop - 2]]) < maxDist) {
            return -1;
        }
        return 0;
    }

    public int getNumElements() {
        return this.getNumVertices() - 1;
    }

    public boolean merge(PgBndPolygon b) {
        if (b == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        if (this.m_triang != b.m_triang) {
            PsDebug.warning("bnd's associated to different elementSets", this);
            return false;
        }
        if (this.m_numVertices < 2 || b.m_numVertices < 2) {
            PsDebug.warning("bnd's less than 2 points", this);
            return false;
        }
        int oldNov = this.m_numVertices;
        int newNov = this.m_numVertices + b.m_numVertices;
        super.merge(b);
        this.setNumVertices(newNov - 1);
        this.m_vertexInd.copy(oldNov, b.m_vertexInd, 1, b.m_numVertices - 1);
        this.m_elementInd.copy(oldNov - 1, b.m_elementInd, 0, b.m_numVertices - 1);
        this.m_neighbourLocInd.copy(oldNov - 1, b.m_neighbourLocInd, 0, b.m_numVertices - 1);
        return true;
    }

    public boolean constrain() {
        if (this.m_bndConstraint == null) {
            PsDebug.notify("boundary has no constraint");
            return true;
        }
        if (this.m_triang == null) {
            PsDebug.warning("missing element set.");
            return true;
        }
        PdVector m_start = this.m_bndConstraint.m_start;
        PdVector m_dir = this.m_bndConstraint.m_dir;
        PdVector m_vec1 = this.m_bndConstraint.m_vec1;
        PdVector m_vec2 = this.m_bndConstraint.m_vec2;
        PdVector[] vertex = this.m_triang.getVertices();
        if (this.m_bndConstraint.hasShape(4)) {
            int j = 0;
            while (j < this.m_numVertices) {
                PuVectorGeom.projectPointToLine(vertex[this.m_vertexInd.m_data[j]], vertex[this.m_vertexInd.m_data[j]], m_start, m_dir);
                ++j;
            }
        } else if (this.m_bndConstraint.hasShape(5)) {
            int j = 0;
            while (j < this.m_numVertices) {
                PuVectorGeom.projectPointToPlane(vertex[this.m_vertexInd.m_data[j]], vertex[this.m_vertexInd.m_data[j]], m_start, m_dir);
                ++j;
            }
        } else if (this.m_bndConstraint.hasShape(11)) {
            double radius = m_vec1.dist(m_start);
            int j = 0;
            while (j < this.m_numVertices) {
                PuVectorGeom.projectPointToCircle(vertex[this.m_vertexInd.m_data[j]], vertex[this.m_vertexInd.m_data[j]], m_vec1, m_vec2, radius);
                ++j;
            }
        } else {
            PsDebug.warning("not implemented for this shape");
            return false;
        }
        this.assignVertices();
        return true;
    }

    public boolean bnd_paste(PgBndPolygon b, int type) {
        if (b == null) {
            PsDebug.error("missing argument", this);
            return false;
        }
        if (this.m_triang != b.m_triang) {
            PsDebug.error("bnd's associated to different elementSets", this);
            return false;
        }
        if (this.m_numVertices < 2 || b.m_numVertices < 2) {
            PsDebug.error("bnd's less than 2 points", this);
            return false;
        }
        if (!(type == 11 || type == 12 || type == 21 || type == 22)) {
            PsDebug.error("type must be 11, 12, 21 or 22", this);
            return false;
        }
        if (type == 11 || type == 12) {
            this.invert();
        }
        if (type == 12 || type == 22) {
            b.invert();
        }
        return this.merge(b);
    }

    public boolean bnd_id(PgBndPolygon b, int orient) {
        int i;
        if (b == null) {
            PsDebug.error("missing argument", this);
            return false;
        }
        if (this.m_triang != b.m_triang) {
            PsDebug.error("bnd's associated to different elementSets", this);
            return false;
        }
        if (this.m_numVertices != b.m_numVertices) {
            return false;
        }
        if (this.m_numVertices < 2 || b.m_numVertices < 2) {
            PsDebug.error("bnd's less than 2 points", this);
            return false;
        }
        int nop = this.m_numVertices;
        int[] av = this.m_vertexInd.m_data;
        int[] bv = b.m_vertexInd.m_data;
        if (orient < 0) {
            b.invert();
        }
        int j = 0;
        while (j < nop - 1) {
            int a_triang_ind = this.m_elementInd.m_data[j];
            int b_triang_ind = b.m_elementInd.m_data[j];
            int opp_ind = this.m_triang.getNeighbourLocInd(b_triang_ind, bv[j], bv[j + 1]);
            this.m_triang.m_neighbour[b_triang_ind].m_data[opp_ind] = this.m_elementInd.m_data[j];
            opp_ind = this.m_triang.getNeighbourLocInd(a_triang_ind, av[j], av[j + 1]);
            this.m_triang.m_neighbour[a_triang_ind].m_data[opp_ind] = b.m_elementInd.m_data[j];
            ++j;
        }
        j = 0;
        while (j < nop) {
            i = 0;
            while (i < this.m_triang.m_numElements) {
                this.m_triang.m_element[i].changeValue(bv[j], av[j]);
                ++i;
            }
            this.m_triang.m_vertex[bv[j]].setTag(2);
            ++j;
        }
        PgBndPolygon[] bndList = this.m_triang.getBoundaries();
        i = 0;
        while (i < bndList.length) {
            if (bndList[i] != null && bndList[i] != this && bndList[i] != b && !bndList[i].hasTag(2)) {
                j = 0;
                while (j < nop) {
                    bndList[i].m_vertexInd.changeValue(bndList[i].m_numVertices, bv[j], av[j]);
                    ++j;
                }
            }
            ++i;
        }
        this.setTag(2);
        b.setTag(2);
        return true;
    }

    public boolean isConforming() {
        return this.m_bConforming;
    }

    public void makeConforming() {
        if (this.isConforming()) {
            return;
        }
        if (this.m_triang == null) {
            PsDebug.warning("missing element set");
            return;
        }
        this.setNumVertices(this.m_numVertices + 1);
        PiVector elem = null;
        int locInd = 0;
        int j = 0;
        while (j < this.m_numVertices - 1) {
            int elemInd = this.m_elementInd.m_data[j];
            elem = this.m_triang.m_element[elemInd];
            locInd = this.m_neighbourLocInd.m_data[j];
            this.m_vertexInd.m_data[j] = elem.m_data[(locInd + 1) % elem.getSize()];
            if (this.m_triang.m_neighbour[elemInd].m_data[locInd] > -1) {
                PsDebug.warning("neighbourLocInd wrong");
            }
            ++j;
        }
        this.m_vertexInd.m_data[this.m_numVertices - 1] = elem.m_data[(locInd + 2) % elem.getSize()];
        this.m_bConforming = true;
        this.assignVertices();
    }

    public static void bndcpy(int from, int to, int nedges, PgBndPolygon a, PgBndPolygon b) {
        int i = 0;
        while (i < nedges) {
            b.m_vertexInd.m_data[to + i] = a.m_vertexInd.m_data[from + i];
            ++i;
        }
        i = 0;
        while (i < nedges) {
            b.m_elementInd.m_data[to + i] = a.m_elementInd.m_data[from + i];
            ++i;
        }
    }

    public static void bndcp(int from, int to, int nedges, PgBndPolygon a, PgBndPolygon b) {
        int i = 0;
        while (i < nedges + 1) {
            b.m_vertexInd.m_data[to + i] = a.m_vertexInd.m_data[from + i];
            ++i;
        }
        i = 0;
        while (i < nedges) {
            b.m_elementInd.m_data[to + i] = a.m_elementInd.m_data[from + i];
            ++i;
        }
    }

    protected void setMaxNumVertices(int aNumVertices) {
        if (this.m_maxNumVertices == aNumVertices) {
            return;
        }
        super.setMaxNumVertices(aNumVertices);
        this.m_vertexInd.setSize(aNumVertices);
        this.m_elementInd.setSize(aNumVertices - 1);
        this.m_neighbourLocInd.setSize(aNumVertices - 1);
    }

    public int bndtst(double maxDist) {
        if (this.m_triang == null) {
            PsDebug.error("missing associated elementSet", this);
            return -1;
        }
        if (this.m_numVertices < 2) {
            PsDebug.error("bnd has less than 2 points", this);
            return -1;
        }
        int nop = this.m_numVertices;
        int count = 0;
        PdVector[] triangVertex = this.m_triang.m_vertex;
        int[] av = this.m_vertexInd.m_data;
        int i = 1;
        while (i < nop) {
            if (PdVector.dist(triangVertex[av[0]], triangVertex[av[i]]) < maxDist) {
                ++count;
            }
            ++i;
        }
        if (count == 0) {
            return -1;
        }
        if (count == nop - 1) {
            return 1;
        }
        return 0;
    }

    public double bnd_dist(PgBndPolygon b) {
        double dist;
        if (b == null) {
            PsDebug.error("missing argument", this);
            return 1000.0;
        }
        if (this.m_triang != b.m_triang) {
            PsDebug.error("bnd's associated to different elementSets", this);
            return 1000.0;
        }
        if (this.m_numVertices != b.m_numVertices) {
            return 1000.0;
        }
        if (this.m_numVertices < 2 || b.m_numVertices < 2) {
            PsDebug.error("bnd's less than 2 points", this);
            return 1000.0;
        }
        int nop = this.m_numVertices;
        int[] av = this.m_vertexInd.m_data;
        int[] bv = b.m_vertexInd.m_data;
        double maxDist = PdVector.sqrDist(this.m_triang.m_vertex[av[0]], this.m_triang.m_vertex[bv[0]]);
        if (maxDist <= (dist = PdVector.sqrDist(this.m_triang.m_vertex[av[0]], this.m_triang.m_vertex[bv[nop - 1]]))) {
            int i = 1;
            while (i < nop) {
                dist = PdVector.sqrDist(this.m_triang.m_vertex[av[i]], this.m_triang.m_vertex[bv[i]]);
                maxDist = Math.max(maxDist, dist);
                ++i;
            }
            dist = Math.sqrt(maxDist);
        } else {
            maxDist = dist;
            int i = 1;
            while (i < nop) {
                dist = PdVector.sqrDist(this.m_triang.m_vertex[av[i]], this.m_triang.m_vertex[bv[nop - 1 - i]]);
                maxDist = Math.max(maxDist, dist);
                ++i;
            }
            dist = -Math.sqrt(maxDist);
        }
        return dist;
    }

    public int bnd_cmp_logic(PgBndPolygon b, double maxDist) {
        PdVector b12;
        PdVector a12;
        PdVector p2;
        double angle2;
        if (b == null) {
            PsDebug.error("missing argument", this);
            return 0;
        }
        if (this.m_triang != b.m_triang) {
            PsDebug.error("bnd's associated to different elementSets", this);
            return 0;
        }
        if (this.m_numVertices != b.m_numVertices) {
            return 0;
        }
        if (this.m_numVertices < 2 || b.m_numVertices < 2) {
            PsDebug.error("bnd's less than 2 points", this);
            return 0;
        }
        int nopa = this.m_numVertices;
        int nopb = b.m_numVertices;
        int[] av = this.m_vertexInd.m_data;
        int[] bv = b.m_vertexInd.m_data;
        if (PdVector.sqrDist(this.m_triang.m_vertex[av[0]], this.m_triang.m_vertex[bv[0]]) < maxDist && PdVector.sqrDist(this.m_triang.m_vertex[av[nopa - 1]], this.m_triang.m_vertex[bv[nopb - 1]]) < maxDist) {
            PdVector p2 = this.m_triang.m_vertex[av[0]];
            PdVector a12 = this.m_triang.m_vertex[av[1]];
            PdVector b12 = this.m_triang.m_vertex[bv[1]];
            double angle2 = PdVector.angle(p2, a12, b12);
            if (Math.abs(angle2) < MAX_LOGIC_ANGLE) {
                return 1;
            }
        } else if (PdVector.sqrDist(this.m_triang.m_vertex[av[0]], this.m_triang.m_vertex[bv[nopb - 1]]) < maxDist && PdVector.sqrDist(this.m_triang.m_vertex[av[nopa - 1]], this.m_triang.m_vertex[bv[0]]) < maxDist && Math.abs(angle2 = PdVector.angle(p2 = this.m_triang.m_vertex[av[0]], a12 = this.m_triang.m_vertex[av[1]], b12 = this.m_triang.m_vertex[bv[nopb - 2]])) < MAX_LOGIC_ANGLE) {
            return -1;
        }
        return 0;
    }

    public boolean makeElementInd() {
        if (this.m_triang == null) {
            PsDebug.warning("missing element set");
            return false;
        }
        int i = 0;
        while (i < this.m_numVertices - 1) {
            PgElementEdge edge = this.m_triang.getEdge(this.m_vertexInd.m_data[i], this.m_vertexInd.m_data[i + 1]);
            if (edge == null) {
                PsDebug.warning("edge not found between vertices v0=" + this.m_vertexInd.m_data[i] + " and v1=" + this.m_vertexInd.m_data[i + 1]);
                return false;
            }
            this.m_elementInd.m_data[i] = edge.getElementInd(0);
            this.m_neighbourLocInd.m_data[i] = edge.getNeighbourLocInd(0);
            ++i;
        }
        this.assignVertices();
        return true;
    }

    public boolean invert() {
        if (this.m_numVertices < 2) {
            PsDebug.error("invert: bnd has less than 2 points", this);
            return false;
        }
        this.m_vertexInd.invert(this.m_numVertices);
        this.m_elementInd.invert(this.m_numVertices - 1);
        return true;
    }

    public Object clone() {
        PgBndPolygon clone = (PgBndPolygon)super.clone();
        if (clone == null) {
            return null;
        }
        clone.m_triang = null;
        if (this.m_vertexInd != null) {
            clone.m_vertexInd = (PiVector)this.m_vertexInd.clone();
        }
        if (this.m_elementInd != null) {
            clone.m_elementInd = (PiVector)this.m_elementInd.clone();
        }
        if (this.m_neighbourLocInd != null) {
            clone.m_neighbourLocInd = (PiVector)this.m_neighbourLocInd.clone();
        }
        if (this.m_bndConstraint != null) {
            clone.m_bndConstraint = (PgBndConstraint)this.m_bndConstraint.clone();
        }
        return clone;
    }

    public static boolean bndinv(int from, int to, int nedges, PgBndPolygon a, PgBndPolygon b) {
        if (from + nedges > a.m_numVertices || to < nedges - 1) {
            PsDebug.error("bndinv: invalid offsets", a);
            return false;
        }
        int i = 0;
        while (i < nedges) {
            b.m_vertexInd.m_data[to - i] = a.m_vertexInd.m_data[from + i];
            ++i;
        }
        i = 0;
        while (i < nedges - 1) {
            b.m_elementInd.m_data[to - 1 - i] = a.m_elementInd.m_data[from + i];
            ++i;
        }
        return true;
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer("");
        strBuf.append(super.toString());
        strBuf.append("\t ******* PgBndPolygon *********\n");
        strBuf.append("\t MAX_PASTE_ANGLE = " + MAX_PASTE_ANGLE + "\n");
        strBuf.append("\t MAX_LOGIC_ANGLE = " + MAX_LOGIC_ANGLE + "\n");
        strBuf.append("\t is conforming = " + this.isConforming() + "\n");
        strBuf.append("\t ******* m_vertexInd *******\n");
        if (this.m_vertexInd == null) {
            strBuf.append("\t m_vertexInd = null\n");
        } else {
            strBuf.append("\t m_vertexInd" + this.m_vertexInd.toShortString());
        }
        strBuf.append("\t ******* m_elementInd *******\n");
        if (this.m_elementInd == null) {
            strBuf.append("\t m_elementInd = null\n");
        } else {
            strBuf.append("\t m_elementInd = " + this.m_elementInd.toShortString());
        }
        strBuf.append("\t ******* m_neighbourLocInd *******\n");
        if (this.m_neighbourLocInd == null) {
            strBuf.append("\t m_neighbourLocInd = null\n");
        } else {
            strBuf.append("\t m_neighbourLocInd = " + this.m_neighbourLocInd.toShortString());
        }
        strBuf.append("\t ******* m_bndConstraint *******\n");
        if (this.m_bndConstraint == null) {
            strBuf.append("\t m_bndConstraint = null\n");
        } else {
            strBuf.append("\t " + this.m_bndConstraint.toString());
        }
        return strBuf.toString();
    }

    public PgBndPolygon(int aVertexDim) {
        super(aVertexDim);
        if (this.getClass() == (class$jv$geom$PgBndPolygon != null ? class$jv$geom$PgBndPolygon : (class$jv$geom$PgBndPolygon = PgBndPolygon.class$("jv.geom.PgBndPolygon")))) {
            this.init();
        }
    }

    public PiVector getVertexInd() {
        return this.m_vertexInd;
    }

    public PiVector getElementInd() {
        return this.m_elementInd;
    }

    public PgBndConstraint getBndConstraint() {
        return this.m_bndConstraint;
    }

    public void setBndConstraint(PgBndConstraint bndConstraint) {
        this.m_bndConstraint = bndConstraint;
    }

    public void paint(PvGeometryIf dc) {
        super.paint(dc);
    }

    public boolean blend(double s, PgBndPolygon a, double t, PgBndPolygon b) {
        if (a == null || a.m_numVertices == 0) {
            PsDebug.warning("empty first argument", this);
            return false;
        }
        if (b == null || a.m_numVertices != b.m_numVertices) {
            PsDebug.warning("wrong second argument", this);
            return false;
        }
        if (Math.abs(s) < 1.0E-10) {
            s = 0.0;
        }
        if (Math.abs(t) < 1.0E-10) {
            t = 0.0;
        }
        if (!super.blend(s, a, t, b)) {
            return false;
        }
        this.m_vertexInd.copy(a.m_vertexInd);
        this.m_elementInd.copy(a.m_elementInd);
        this.m_neighbourLocInd.copy(a.m_neighbourLocInd);
        if (a.m_bndConstraint == null || b.m_bndConstraint != null) {
            // empty if block
        }
        return true;
    }

    public PgElementSet getElementSet() {
        return this.m_triang;
    }

    public void setElementSet(PgElementSet aTriang) {
        this.m_triang = aTriang;
    }

    protected int bnd_cmp_paste(PgBndPolygon b, double maxDist) {
        PdVector q;
        PdVector r;
        PdVector p;
        if (b == null) {
            PsDebug.error("missing argument", this);
            return 0;
        }
        if (this.m_triang != b.m_triang) {
            PsDebug.error("bnd's associated to different elementSets", this);
            return 0;
        }
        if (this.m_numVertices < 2 || b.m_numVertices < 2) {
            PsDebug.error("bnd's less than 2 points", this);
            return 0;
        }
        int a_nop = this.m_numVertices;
        int b_nop = b.m_numVertices;
        int[] av = this.m_vertexInd.m_data;
        int[] bv = b.m_vertexInd.m_data;
        int type = 0;
        if (PdVector.dist(this.m_triang.m_vertex[av[0]], this.m_triang.m_vertex[bv[0]]) < maxDist) {
            type = 11;
            p = this.m_triang.m_vertex[av[0]];
            r = this.m_triang.m_vertex[av[1]];
            q = this.m_triang.m_vertex[bv[1]];
        } else if (PdVector.dist(this.m_triang.m_vertex[av[0]], this.m_triang.m_vertex[bv[b_nop - 1]]) < maxDist) {
            type = 12;
            p = this.m_triang.m_vertex[av[0]];
            r = this.m_triang.m_vertex[av[1]];
            q = this.m_triang.m_vertex[bv[b_nop - 2]];
        } else if (PdVector.dist(this.m_triang.m_vertex[av[a_nop - 1]], this.m_triang.m_vertex[bv[0]]) < maxDist) {
            type = 21;
            p = this.m_triang.m_vertex[av[a_nop - 1]];
            r = this.m_triang.m_vertex[av[a_nop - 2]];
            q = this.m_triang.m_vertex[bv[1]];
        } else if (PdVector.dist(this.m_triang.m_vertex[av[a_nop - 1]], this.m_triang.m_vertex[bv[b_nop - 1]]) < maxDist) {
            type = 22;
            p = this.m_triang.m_vertex[av[a_nop - 1]];
            r = this.m_triang.m_vertex[av[a_nop - 2]];
            q = this.m_triang.m_vertex[bv[b_nop - 2]];
        } else {
            return 0;
        }
        double angle = PdVector.angle(p, q, r);
        if (Math.abs(angle - 180.0) > MAX_PASTE_ANGLE) {
            return 0;
        }
        return type;
    }

    public void makeNonConforming() {
        if (!this.isConforming()) {
            return;
        }
        if (this.m_triang == null) {
            PsDebug.warning("missing element set");
            return;
        }
        this.setNumVertices(this.m_numVertices - 1);
        int j = 0;
        while (j < this.m_numVertices) {
            int elemInd = this.m_elementInd.m_data[j];
            PiVector elem = this.m_triang.m_element[elemInd];
            int locInd = this.m_neighbourLocInd.m_data[j];
            this.m_vertexInd.m_data[j] = elem.m_data[locInd];
            if (this.m_triang.m_neighbour[elemInd].m_data[locInd] > -1) {
                PsDebug.warning("neighbourLocInd wrong");
            }
            ++j;
        }
        this.m_bConforming = false;
        this.assignVertices();
    }

    public void copy(PgGeometry aGeom) {
        super.copy(aGeom);
        if (!(aGeom instanceof PgBndPolygon)) {
            return;
        }
        PgBndPolygon geom = (PgBndPolygon)aGeom;
        this.m_vertexInd.copy(geom.getVertexInd());
        this.m_elementInd.copy(geom.getElementInd());
        this.m_neighbourLocInd.copy(geom.getNeighbourLocInd());
        this.m_bConforming = geom.isConforming();
        PgBndConstraint bndConstr = geom.getBndConstraint();
        if (bndConstr != null) {
            if (this.m_bndConstraint == null) {
                this.m_bndConstraint = new PgBndConstraint(bndConstr.m_dim);
            }
            this.m_bndConstraint.copy(bndConstr);
        } else {
            this.m_bndConstraint = null;
        }
        this.assignVertices();
    }

    private static /* synthetic */ Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public boolean assignVertices() {
        if (this.m_triang == null) {
            PsDebug.warning("missing element set");
            return false;
        }
        int num = this.m_triang.getNumVertices();
        int i = 0;
        while (i < this.m_numVertices) {
            if (this.m_vertexInd.m_data[i] == -1 || this.m_vertexInd.m_data[i] >= num) {
                this.setTag(2);
                return false;
            }
            this.m_vertex[i].copy(this.m_triang.m_vertex[this.m_vertexInd.m_data[i]]);
            ++i;
        }
        return true;
    }

    public void init() {
        super.init();
        this.clearTag(2);
        this.m_bndConstraint = null;
    }

    public PiVector getNeighbourLocInd() {
        return this.m_neighbourLocInd;
    }

    public boolean bndsh(int n) {
        if (this.m_numVertices < 2) {
            PsDebug.error("bndsh: bnd has less than 2 points", this);
            return false;
        }
        int nov = this.m_numVertices;
        int k = nov - 1 - n;
        int i = 0;
        while (i <= k) {
            this.m_vertexInd.m_data[nov - 1 - i] = this.m_vertexInd.m_data[k - i];
            ++i;
        }
        i = 1;
        while (i <= k) {
            this.m_elementInd.m_data[nov - 1 - i] = this.m_elementInd.m_data[k - i];
            ++i;
        }
        i = n - 1;
        while (i >= 0) {
            this.m_elementInd.m_data[i] = -1;
            --i;
        }
        return true;
    }

    public boolean bnd_shrink() {
        int j;
        if (this.m_triang == null) {
            PsDebug.error("missing associated elementSet", this);
            return false;
        }
        if (this.m_numVertices < 2) {
            PsDebug.error("bnd has less than 2 points", this);
            return false;
        }
        int nop = this.m_numVertices;
        int[] av = this.m_vertexInd.m_data;
        boolean bHasDeleted = false;
        int i = 0;
        while (i < nop - 1) {
            int a_triang_ind = this.m_elementInd.m_data[i];
            PiVector a_elem = this.m_triang.getElement(a_triang_ind);
            PiVector a_neigh = this.m_triang.getNeighbour(a_triang_ind);
            int elemLen = a_elem.getSize();
            if (elemLen < 3) {
                PsDebug.error("elementSet corrupt with element size < 3", this);
                return false;
            }
            int node1_ind = a_elem.getIndexOf(av[i]);
            int node2_ind = a_elem.getIndexOf(av[i + 1]);
            if (elemLen == 3) {
                int node1_tri_ind = a_neigh.m_data[node1_ind];
                int node2_tri_ind = a_neigh.m_data[node2_ind];
                if (node1_tri_ind != -1) {
                    this.m_triang.m_neighbour[node1_tri_ind].changeValue(a_triang_ind, node2_tri_ind);
                }
                if (node2_tri_ind != -1) {
                    this.m_triang.m_neighbour[node2_tri_ind].changeValue(a_triang_ind, node1_tri_ind);
                }
                a_elem.setConstant(av[0]);
                a_elem.setTag(2);
                a_neigh.setConstant(-1);
                a_neigh.setTag(2);
                bHasDeleted = true;
            } else {
                int edge = (node1_ind + 1) % elemLen == node2_ind ? node1_ind : node2_ind;
                a_neigh.m_data[(edge - 1 + elemLen) % elemLen] = a_neigh.m_data[edge];
                j = edge;
                while (j < elemLen - 1) {
                    a_elem.m_data[j] = a_elem.m_data[j + 1];
                    a_neigh.m_data[j] = a_neigh.m_data[j + 1];
                    ++j;
                }
                int[] neigh = a_neigh.getEntries();
                this.m_triang.setDimOfElement(a_triang_ind, elemLen - 1);
                j = 0;
                while (j < elemLen - 1) {
                    a_neigh.m_data[j] = neigh[j];
                    ++j;
                }
            }
            ++i;
        }
        int numElem = this.m_triang.getNumElements();
        j = 1;
        while (j < nop) {
            i = 0;
            while (i < numElem) {
                this.m_triang.m_element[i].changeValue(av[j], av[0]);
                ++i;
            }
            this.m_triang.m_vertex[av[j]].setTag(2);
            ++j;
        }
        PgBndPolygon[] bndList = this.m_triang.getBoundaries();
        i = 0;
        while (i < bndList.length) {
            if (bndList[i] != null && bndList[i] != this && !bndList[i].hasTag(2)) {
                j = 1;
                while (j < nop) {
                    bndList[i].m_vertexInd.changeValue(bndList[i].m_numVertices, av[j], av[0]);
                    ++j;
                }
            }
            ++i;
        }
        this.setTag(2);
        if (bHasDeleted) {
            this.m_triang.removeMarkedElements();
        }
        return true;
    }
}

