/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import jv.vecmath.P_Vector;
import jv.vecmath.PuData;

public class PgElementEdge
extends P_Vector {
    private int m_size;
    protected int m_vertInd0;
    protected int m_vertInd1;
    protected int[] m_elemInd;
    protected int[] m_neighbourLocInd;

    public String toString() {
        StringBuffer strBuf = new StringBuffer(super.toString());
        strBuf.append("\t ******* PgElementEdge ***********\n");
        strBuf.append("\t Index of vertices = [" + this.m_vertInd0 + ", " + this.m_vertInd1 + "]\n");
        strBuf.append("\t Number of adjacent elements = " + this.m_size + "\n");
        strBuf.append("\t Indices of adjacent elements = [" + this.m_elemInd[0]);
        int i = 1;
        while (i < this.m_size) {
            strBuf.append(", " + this.m_elemInd[i]);
            ++i;
        }
        strBuf.append("\n");
        strBuf.append("\t Local indices of opposite vertices = [" + this.m_neighbourLocInd[0]);
        i = 1;
        while (i < this.m_size) {
            strBuf.append(", " + this.m_neighbourLocInd[i]);
            ++i;
        }
        strBuf.append("\n");
        return strBuf.toString();
    }

    public PgElementEdge(int v1, int v2) {
        this.m_vertInd0 = v1;
        this.m_vertInd1 = v2;
        this.m_size = 0;
        this.m_elemInd = new int[2];
        this.m_neighbourLocInd = new int[2];
    }

    public int getEdgeInd(int ind) {
        if (ind == 0) {
            return this.m_vertInd0;
        }
        return this.m_vertInd1;
    }

    public int getElementInd(int ind) {
        return this.m_elemInd[ind];
    }

    public int[] getElements() {
        return this.m_elemInd;
    }

    public void addElement(int elemInd, int neighInd) {
        ++this.m_size;
        if (this.m_size > this.m_elemInd.length) {
            this.m_elemInd = PuData.realloc(this.m_elemInd, this.m_size);
            this.m_neighbourLocInd = PuData.realloc(this.m_neighbourLocInd, this.m_size);
        }
        this.m_elemInd[this.m_size - 1] = elemInd;
        this.m_neighbourLocInd[this.m_size - 1] = neighInd;
    }

    public int getSize() {
        return this.m_size;
    }

    public int getNeighbourLocInd(int ind) {
        return this.m_neighbourLocInd[ind];
    }
}

