/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.geom.PgElementSet;
import jv.geom.PgTexture;
import jv.loader.PgFileDialog;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.GuiStackLayout;
import jv.project.PvDisplayIf;
import jv.project.PvViewerIf;
import jv.vecmath.PiVector;

public class PgTexture_IP
extends PsPanel
implements ActionListener,
ItemListener {
    protected PgTexture m_texture;
    protected Panel m_pSize;
    protected Checkbox m_cShowImage;
    protected TextField m_tImage;
    protected String m_fileName;
    protected String m_dirName;
    protected Button m_bBrowse;
    protected Choice m_cImageFit;
    protected Button m_bReset;
    protected PvDisplayIf m_display;
    protected PgElementSet m_texGeom;
    protected PgElementSet m_imgGeom;
    private boolean m_bUpdateFromHere = false;
    private static /* synthetic */ Class class$jv$geom$PgTexture_IP;

    public PgTexture_IP() {
        if (this.getClass() == (class$jv$geom$PgTexture_IP != null ? class$jv$geom$PgTexture_IP : (class$jv$geom$PgTexture_IP = PgTexture_IP.class$("jv.geom.PgTexture_IP")))) {
            this.init();
        }
    }

    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        PsDebug.notify("entered");
        if (source != this.m_cImageFit && source == this.m_cShowImage) {
            if (this.m_cShowImage.getState()) {
                PgElementSet srcGeom = (PgElementSet)this.m_texture.getFather();
                if (!srcGeom.hasVertexTextures() && !srcGeom.hasElementTextures()) {
                    return;
                }
                this.updateTextureGeometry(srcGeom);
                this.m_texGeom.showVertexTexture(false);
                this.m_texGeom.setTexture(null);
                this.m_texGeom.showElementTexture(false);
                this.m_texGeom.showElements(false);
                this.m_texGeom.showEdges(true);
                this.m_imgGeom = new PgElementSet(2);
                this.m_imgGeom.setName("TexImage of " + srcGeom.getName());
                this.m_imgGeom.computePlane(2, 2, 0.0, 0.0, 1.0, 1.0);
                this.m_imgGeom.makeVertexTextureFromBndBox(0, 1);
                this.m_imgGeom.setTexture((PgTexture)this.m_texture.clone());
                this.m_imgGeom.showVertexTexture(true);
                PvViewerIf viewer = (PvViewerIf)PsConfig.getViewer();
                this.m_display = viewer.newDisplay("Texture", true);
                this.m_display.addGeometry(this.m_texGeom);
                this.m_display.addGeometry(this.m_imgGeom);
                this.m_display.setBackgroundColor(Color.red);
                this.m_display.setDrawingOrder(-1, this.m_imgGeom);
                this.m_display.selectCamera(1);
                ((Component)this.m_display.getFrame()).setVisible(true);
            } else {
                PvViewerIf viewer = (PvViewerIf)PsConfig.getViewer();
                if (viewer.hasDisplay(this.m_display)) {
                    viewer.removeDisplay(this.m_display);
                }
                this.m_display = null;
                this.m_texGeom = null;
                this.m_imgGeom = null;
            }
        }
        this.m_texture.update(this);
    }

    public void setParent(PsUpdateIf texture) {
        super.setParent(texture);
        this.m_texture = (PgTexture)texture;
        this.m_pSize.add(this.m_texture.m_uMin.getInfoPanel());
        this.m_pSize.add(this.m_texture.m_vMin.getInfoPanel());
        this.m_pSize.add(this.m_texture.m_uMax.getInfoPanel());
        this.m_pSize.add(this.m_texture.m_vMax.getInfoPanel());
    }

    protected void updateTextureGeometry(PgElementSet srcGeom) {
        if (this.m_texGeom == null) {
            this.m_texGeom = (PgElementSet)srcGeom.clone();
            this.m_texGeom.setParent(this);
            this.m_texGeom.removeAllVectorFields();
            this.m_texGeom.setElementTextures(null);
            this.m_texGeom.setVertexTextures(null);
        }
        this.m_texGeom.setName("TexCoords of " + srcGeom.getName());
        this.m_texGeom.setDimOfVertices(srcGeom.getDimOfTextures());
        if (srcGeom.hasVertexTextures()) {
            this.m_texGeom.setNumVertices(srcGeom.getNumVertices());
            this.m_texGeom.setVertices(srcGeom.getVertexTextures());
            this.m_texGeom.copyConnectivity(srcGeom);
        } else if (srcGeom.hasElementTextures()) {
            this.m_texGeom.setNumVertices(srcGeom.getNumElementIndices());
            this.m_texGeom.setVertices(srcGeom.getVertexTextures());
            this.m_texGeom.setNumElements(srcGeom.getNumElements());
            PiVector[] texElement = this.m_texGeom.getElements();
            int noe = srcGeom.getNumElements();
            int num = 0;
            int k = 0;
            while (k < noe) {
                int elemSize = texElement[k].getSize();
                int kk = 0;
                while (kk < elemSize) {
                    texElement[k].m_data[kk] = num++;
                    ++kk;
                }
                ++k;
            }
        } else {
            this.m_texGeom = null;
        }
    }

    public boolean update(Object object) {
        PsDebug.notify("isShowing = " + this.isShowing());
        if (this.m_texture == null) {
            PsDebug.warning("missing texture");
            return false;
        }
        if (this.m_bUpdateFromHere) {
            return true;
        }
        if (object == this.m_texture) {
            PgElementSet srcGeom;
            String imgName;
            String title = this.m_texture.getName();
            if (title != null && this.getTitle() != null && !title.equals(this.getTitle())) {
                this.setTitle(title);
            }
            if ((imgName = this.m_texture.getImageName()) != null && !imgName.equals(this.m_tImage.getText())) {
                ((TextComponent)this.m_tImage).setText(this.m_texture.getImageName());
            }
            if (this.m_imgGeom != null) {
                this.m_imgGeom.setTexture(this.m_texture);
                this.m_imgGeom.update(this.m_imgGeom);
            }
            if ((srcGeom = (PgElementSet)this.m_texture.getFather()) != null && (srcGeom.hasVertexTextures() || srcGeom.hasElementTextures())) {
                this.updateTextureGeometry(srcGeom);
                if (this.m_texGeom != null) {
                    this.m_bUpdateFromHere = true;
                    this.m_texGeom.update(null);
                    this.m_bUpdateFromHere = false;
                }
            }
            return true;
        }
        if (object == this.m_texGeom) {
            PgElementSet srcGeom = (PgElementSet)this.m_texture.getFather();
            srcGeom.setVertexTextures(this.m_texGeom.getVertices());
            srcGeom.update(srcGeom);
            return true;
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent event) {
        PsDebug.notify("entered");
        if (this.m_texture == null) {
            return;
        }
        Object source = event.getSource();
        if (source == this.m_tImage) {
            this.m_fileName = this.m_tImage.getText();
            this.m_fileName.trim();
            this.m_texture.setImageName(this.m_fileName);
            Image img = this.m_texture.loadImage(this);
            if (img == null) {
                this.m_texture.setImageName(null);
                return;
            }
            this.m_texture.update(this.m_texture);
        } else if (source == this.m_bBrowse) {
            if (!PsConfig.isApplication()) {
                this.m_fileName = this.m_tImage.getText();
                this.m_fileName.trim();
            } else {
                PgFileDialog fd = new PgFileDialog(PsConfig.getFrame(), PsConfig.getMessage("OpenImage"), 0);
                if (this.m_dirName == null) {
                    this.m_dirName = PsConfig.getCodeBase() + "images";
                }
                ((FileDialog)fd).setDirectory(this.m_dirName);
                ((Component)fd).setVisible(true);
                String fileName = fd.getFile();
                if (fileName == null) {
                    PsDebug.notify("dialog cancelled");
                    return;
                }
                PsDebug.notify("file = " + fileName);
                this.m_dirName = ((FileDialog)fd).getDirectory();
                PsDebug.notify("dir  = " + this.m_dirName);
                this.m_fileName = this.m_dirName + fileName;
                this.m_fileName.trim();
                ((TextComponent)this.m_tImage).setText(this.m_fileName);
            }
            this.m_texture.setImageName(this.m_fileName);
            Image img = this.m_texture.loadImage(this);
            if (img == null) {
                return;
            }
            this.m_texture.update(this.m_texture);
        } else if (source == this.m_bReset) {
            this.m_texture.init();
            this.m_texture.update(this.m_texture);
        }
    }

    private static /* synthetic */ Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public void init() {
        super.init();
        PsPanel pTexImage = new PsPanel();
        pTexImage.setLayout(new GridLayout(3, 2));
        pTexImage.addTitle(PsConfig.getMessage("textureImage"));
        this.m_cShowImage = new Checkbox(PsConfig.getMessage("ShowTexture"));
        this.m_cShowImage.addItemListener(this);
        pTexImage.add(this.m_cShowImage);
        pTexImage.add(new Label(PsConfig.getMessage("Tiling")));
        this.m_cImageFit = new Choice();
        this.m_cImageFit.addItemListener(this);
        this.m_cImageFit.addItem(PsConfig.getMessage("cCenter"));
        this.m_cImageFit.addItem(PsConfig.getMessage("cTesselate"));
        this.m_cImageFit.addItem(PsConfig.getMessage("cResize"));
        this.m_cImageFit.setEnabled(false);
        pTexImage.add(this.m_cImageFit);
        Panel textPanel = new Panel();
        textPanel.setLayout(new GuiStackLayout(0, 0));
        textPanel.add("WIDE*2", new Label(PsConfig.getMessage("ImageFile")));
        this.m_bBrowse = new Button(PsConfig.getMessage("Load"));
        this.m_bBrowse.addActionListener(this);
        textPanel.add("FILL*1", this.m_bBrowse);
        pTexImage.add(textPanel);
        this.m_tImage = new TextField();
        this.m_tImage.addActionListener(this);
        pTexImage.add(this.m_tImage);
        this.add(pTexImage);
        this.addSubTitle(PsConfig.getMessage("textureSize"));
        this.m_pSize = new Panel();
        this.m_pSize.setLayout(new GridLayout(4, 1));
        this.add(this.m_pSize);
        Panel pBottomButtons = new Panel();
        pBottomButtons.setLayout(new FlowLayout());
        this.add(pBottomButtons);
        this.m_bReset = new Button(PsConfig.getMessage("bReset"));
        this.m_bReset.addActionListener(this);
        pBottomButtons.add(this.m_bReset);
    }
}

