/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import jv.geom.PgVectorField;
import jv.number.PdArray_IP;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;

public class PgVectorField_IP
extends PsPanel
implements TextListener {
    protected PgVectorField m_vectorField;
    protected TextField m_tNumVectors;
    protected Panel m_pNumVectors;
    protected PdArray_IP m_vertexPanel;
    protected int m_visibleVectors = 5;
    protected int m_visibleDim = 3;
    protected static String[] m_header = new String[]{"X", "Y", "Z", "W"};
    protected boolean m_bInteractive = true;
    private static /* synthetic */ Class class$jv$geom$PgVectorField_IP;

    public PgVectorField_IP() {
        if (this.getClass() == (class$jv$geom$PgVectorField_IP != null ? class$jv$geom$PgVectorField_IP : (class$jv$geom$PgVectorField_IP = PgVectorField_IP.class$("jv.geom.PgVectorField_IP")))) {
            this.init();
        }
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.m_vectorField = (PgVectorField)parent;
    }

    public boolean update(Object anObject) {
        PsDebug.notify("called");
        if (this.m_vectorField == null) {
            PsDebug.warning("missing pointSet");
            return true;
        }
        if (anObject == this.m_vectorField) {
            this.setTitle(PsConfig.getMessage("InspectorOf") + this.m_vectorField.getName());
            this.m_bInteractive = false;
            ((TextComponent)this.m_tNumVectors).setText(String.valueOf(this.m_vectorField.getNumVectors()));
            this.m_bInteractive = true;
            this.m_vertexPanel.setVector(this.m_vectorField.getVectors(), m_header, this.m_vectorField.getNumVectors(), this.m_vectorField.getDimOfVertices());
            return true;
        }
        if (anObject == this.m_vertexPanel) {
            this.m_vectorField.update(this);
            return true;
        }
        return super.update(anObject);
    }

    private static /* synthetic */ Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public void init() {
        super.init();
        this.setBorderType(3);
        this.addTitle("");
        Panel pNumVectors = new Panel();
        pNumVectors.setLayout(new GridLayout(1, 2));
        this.add(pNumVectors);
        Label lNumVectors = new Label(PsConfig.getMessage("lNumVectors"));
        pNumVectors.add(lNumVectors);
        this.m_tNumVectors = new TextField("0", 7);
        this.m_tNumVectors.addTextListener(this);
        pNumVectors.add(this.m_tNumVectors);
        this.m_vertexPanel = new PdArray_IP(this.m_visibleVectors, this.m_visibleDim);
        this.m_vertexPanel.update(this);
        this.add(this.m_vertexPanel);
    }

    public void textValueChanged(TextEvent event) {
        PsDebug.notify("entered");
        if (!this.m_bInteractive) {
            return;
        }
        Object source = event.getSource();
        if (source == this.m_tNumVectors) {
            try {
                int num = Integer.parseInt(this.m_tNumVectors.getText());
                if (num != this.m_vectorField.getNumVectors()) {
                    PsDebug.notify("setNumVectors=" + this.m_tNumVectors.getText());
                    this.m_vectorField.setNumVectors(num);
                    this.m_vertexPanel.setVector(this.m_vectorField.getVectors(), m_header, num, this.m_vectorField.getDimOfVertices());
                }
                this.m_vectorField.update(this);
            }
            catch (NumberFormatException e) {
                PsDebug.warning("wrong format = " + this.m_tNumVectors.getText(), this);
                return;
            }
        }
    }
}

