/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.util.BitSet;
import jv.geom.PgBndConstraint;
import jv.geom.PgElementSet;
import jv.geom.PgPolygon;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;

public class PgMacroPatch
extends PsObject {
    protected PiVector[] m_vertexType;
    protected PdVector[] m_vertex;
    protected PiVector m_element;
    protected BitSet[] m_bndShapeBits;
    protected PiVector[] m_bndShape;
    protected int m_dim;
    protected int m_bndType;
    protected int m_orientation;
    protected int m_numULines;
    protected int m_numVLines;
    protected int m_numUSubs;
    protected int m_numVSubs;
    private static /* synthetic */ Class class$jv$loader$PgMacroPatch;

    public void setOrientation(int aNum) {
        this.m_orientation = aNum;
    }

    public PgPolygon makePolygon(PgPolygon aPolygon, int anInd) {
        if (anInd < 0 || this.getNumVertices() <= anInd) {
            PsDebug.warning("polygon index=" + anInd + " out of range");
            return aPolygon;
        }
        int nov = this.m_element.getSize();
        int bndLen = nov == 4 && anInd % 2 == 1 ? this.m_numVLines : this.m_numULines;
        if (aPolygon == null) {
            aPolygon = new PgPolygon(this.m_dim);
        }
        aPolygon.setNumVertices(bndLen);
        PdVector p = this.m_vertex[this.m_element.m_data[anInd]];
        PdVector q = this.m_vertex[this.m_element.m_data[(anInd + 1) % nov]];
        PiVector shapeVec = this.m_bndShape[anInd];
        PdVector[] aVertex = aPolygon.getVertices();
        if (this.m_bndShapeBits[anInd].get(7)) {
            int j = 0;
            while (j < bndLen) {
                double v = (double)j / ((double)bndLen - 1.0);
                aVertex[j].blend(1.0 - v, p, v, q);
                ++j;
            }
        } else if (this.m_bndShapeBits[anInd].get(8)) {
            PdVector mid = this.m_vertex[shapeVec.m_data[1]];
            PdVector orient = this.m_vertex[shapeVec.m_data[2]];
            int j = 0;
            while (j < bndLen) {
                double v = (double)j / ((double)bndLen - 1.0);
                PuVectorGeom.evalCircle(aVertex[j], mid, orient, p, q, v);
                ++j;
            }
        } else if (this.m_bndShapeBits[anInd].get(9)) {
            PdVector bot = this.m_vertex[shapeVec.m_data[1]];
            PdVector axisDir = this.m_vertex[shapeVec.m_data[2]];
            int j = 0;
            while (j < bndLen) {
                double v = (double)j / ((double)bndLen - 1.0);
                PuVectorGeom.evalHelix(aVertex[j], bot, axisDir, p, q, v);
                ++j;
            }
        } else if (this.m_bndShapeBits[anInd].get(10)) {
            PsDebug.warning("evalSpline not yet written, use line instead");
        } else {
            PsDebug.warning("unrecognized edge type");
        }
        return aPolygon;
    }

    public int getNumVertices() {
        return this.m_element.getSize();
    }

    public void setNumVertices(int aNum) {
        this.m_element.setSize(aNum);
        this.m_bndShapeBits = new BitSet[aNum];
        int i = 0;
        while (i < aNum) {
            this.m_bndShapeBits[i] = new BitSet(32);
            ++i;
        }
        this.m_bndShape = PiVector.realloc(this.m_bndShape, aNum, 3);
    }

    public PgMacroPatch(int aDim) {
        this.m_dim = aDim;
        if (this.getClass() == (class$jv$loader$PgMacroPatch != null ? class$jv$loader$PgMacroPatch : (class$jv$loader$PgMacroPatch = PgMacroPatch.class$("jv.loader.PgMacroPatch")))) {
            this.init();
        }
    }

    public PgElementSet buildElementSet(PgElementSet geom) {
        if (geom == null) {
            PsDebug.notify("geom created");
            geom = new PgElementSet(3);
        }
        int numVertices = this.getNumVertices();
        PgPolygon[] curve = new PgPolygon[numVertices];
        int i = 0;
        while (i < numVertices) {
            curve[i] = new PgPolygon(this.m_dim);
            curve[i] = this.makePolygon(curve[i], i);
            ++i;
        }
        PgBndConstraint[] bndConstraint = new PgBndConstraint[numVertices];
        int i2 = 0;
        while (i2 < numVertices) {
            bndConstraint[i2] = new PgBndConstraint(this.m_dim);
            bndConstraint[i2] = this.makeBndConstraint(bndConstraint[i2], i2);
            ++i2;
        }
        switch (numVertices) {
            case 3: {
                geom.buildTriangleFromCurve(curve, bndConstraint);
                break;
            }
            case 4: {
                geom.buildQuadrFromCurve(curve, bndConstraint);
                break;
            }
            default: {
                geom.buildPolygonFromCurve(curve);
            }
        }
        return geom;
    }

    public void setVertex(PdVector[] vertex) {
        this.m_vertex = vertex;
    }

    public int getBndType() {
        return this.m_bndType;
    }

    public void setBndType(int aNum) {
        this.m_bndType = aNum;
    }

    public PgBndConstraint makeBndConstraint(PgBndConstraint aBndConstraint, int anInd) {
        if (anInd < 0 || this.getNumVertices() <= anInd) {
            PsDebug.warning("BndConstraint index=" + anInd + " out of range");
            return aBndConstraint;
        }
        int nov = this.m_element.getSize();
        if (aBndConstraint == null) {
            aBndConstraint = new PgBndConstraint(this.m_dim);
        }
        aBndConstraint.m_start = this.m_vertex[this.m_element.m_data[anInd]];
        aBndConstraint.m_end = this.m_vertex[this.m_element.m_data[(anInd + 1) % nov]];
        aBndConstraint.setShape(this.m_bndShapeBits[anInd]);
        aBndConstraint.m_vec1 = this.m_vertex[this.m_bndShape[anInd].m_data[1]];
        aBndConstraint.m_vec2 = this.m_vertex[this.m_bndShape[anInd].m_data[2]];
        if (aBndConstraint.m_startDir == null) {
            aBndConstraint.m_startDir = new PdVector(this.m_dim);
        }
        aBndConstraint.m_startDir.setConstant(0.0);
        if (aBndConstraint.m_endDir == null) {
            aBndConstraint.m_endDir = new PdVector(this.m_dim);
        }
        aBndConstraint.m_endDir.setConstant(0.0);
        if (this.m_bndShapeBits[anInd].get(4)) {
            aBndConstraint.m_dir = PdVector.subNew(aBndConstraint.m_end, aBndConstraint.m_start);
            aBndConstraint.m_dir.normalize();
        } else if (this.m_bndShapeBits[anInd].get(5)) {
            PdVector otherDir;
            aBndConstraint.m_dir = this.m_vertex[this.m_bndShape[anInd].m_data[2]];
            aBndConstraint.m_dir.normalize();
            if (this.m_bndShapeBits[(anInd - 1 + nov) % nov].get(5)) {
                otherDir = this.m_vertex[this.m_bndShape[(anInd - 1 + nov) % nov].m_data[2]];
                aBndConstraint.m_startDir = PdVector.crossNew(aBndConstraint.m_dir, otherDir);
                aBndConstraint.m_startDir.normalize();
            }
            if (this.m_bndShapeBits[(anInd + 1) % nov].get(5)) {
                otherDir = this.m_vertex[this.m_bndShape[(anInd + 1) % nov].m_data[2]];
                aBndConstraint.m_endDir = PdVector.crossNew(aBndConstraint.m_dir, otherDir);
                aBndConstraint.m_endDir.normalize();
            }
        } else if (!this.m_bndShapeBits[anInd].get(11) && !this.m_bndShapeBits[anInd].get(12)) {
            if (this.m_bndShapeBits[anInd].get(3)) {
                aBndConstraint.m_dir = new PdVector(this.m_dim);
                aBndConstraint.m_dir.setConstant(0.0);
            } else {
                PsDebug.warning("unrecognized edge type");
                aBndConstraint.m_dir.setConstant(0.0);
            }
        }
        return aBndConstraint;
    }

    private static /* synthetic */ Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public void setVertexType(PiVector[] vertexType) {
        this.m_vertexType = vertexType;
    }

    public void init() {
        super.init();
        this.m_orientation = 0;
        this.m_vertexType = null;
        this.m_vertex = null;
        this.m_element = new PiVector();
        this.m_bndShapeBits = null;
        this.m_bndShape = null;
    }

    public int getOrientation() {
        return this.m_orientation;
    }
}

