/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Date;
import jv.loader.PsXmlLoader;
import jv.loader.PvDisplayOption;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PvDisplayIf;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;
import jv.vecmath.PdVector;

public class PvDisplayLoader {
    private static final int UNKNOWN = -1;
    private static final int TRUE = 1;
    private static final int FALSE = 0;

    private static void parseOption(PvDisplayOption option, int tag, String attr) {
        if (attr == null) {
            return;
        }
        if (attr.equalsIgnoreCase("show")) {
            option.setOption(tag, true);
        } else {
            option.setOption(tag, false);
        }
    }

    protected static PvDisplayOption[] parseRsrcTree(PsXmlSrc src) {
        String strVersion = null;
        String strVersionType = null;
        String strAbstract = null;
        PsXmlNode root = src.getRootNode();
        if (root == null) {
            PsDebug.warning("missing root node.");
            return null;
        }
        PsXmlNode version = PsXmlSrc.getRsrcNode(root, "version");
        if (version == null) {
            PsDebug.warning("missing version information, using default.");
            strVersion = "0.0";
            strVersionType = "dump";
        } else {
            strVersion = version.getContent();
            strVersionType = version.getAttribute("type");
        }
        strAbstract = PsXmlSrc.getRsrc(root, "abstract");
        PsXmlNode displays = PsXmlSrc.getRsrcNode(root, "displays");
        if (displays == null) {
            PsDebug.warning("missing displays node");
            return null;
        }
        String[] attr = new String[]{"tag", "name"};
        PsXmlNode[] display = PsXmlSrc.getRsrcNodes(displays, "display");
        if (display == null || display.length == 0) {
            PsDebug.warning("missing display node");
            return null;
        }
        PvDisplayOption[] option = new PvDisplayOption[display.length];
        int i = 0;
        while (i < display.length) {
            PsXmlNode window;
            PsXmlNode foreground;
            PsXmlNode background;
            int j;
            option[i] = new PvDisplayOption();
            option[i].setVersion(strVersion);
            option[i].setVersionType(strVersionType);
            option[i].setAbstract(strAbstract);
            option[i].setTitle(display[i].getAttribute("name"));
            PvDisplayLoader.parseOption(option[i], 1, display[i].getAttribute("antiAlias"));
            PvDisplayLoader.parseOption(option[i], 2, display[i].getAttribute("autoRotate"));
            PvDisplayLoader.parseOption(option[i], 3, display[i].getAttribute("axes"));
            PvDisplayLoader.parseOption(option[i], 4, display[i].getAttribute("axesLabel"));
            PvDisplayLoader.parseOption(option[i], 7, display[i].getAttribute("border"));
            PvDisplayLoader.parseOption(option[i], 8, display[i].getAttribute("boundingBox"));
            PvDisplayLoader.parseOption(option[i], 9, display[i].getAttribute("center"));
            PvDisplayLoader.parseOption(option[i], 10, display[i].getAttribute("cross"));
            PvDisplayLoader.parseOption(option[i], 11, display[i].getAttribute("depthcue"));
            PvDisplayLoader.parseOption(option[i], 12, display[i].getAttribute("drawing"));
            PvDisplayLoader.parseOption(option[i], 13, display[i].getAttribute("edgeAura"));
            PvDisplayLoader.parseOption(option[i], 15, display[i].getAttribute("frame"));
            PvDisplayLoader.parseOption(option[i], 16, display[i].getAttribute("info"));
            PvDisplayLoader.parseOption(option[i], 18, display[i].getAttribute("magnet"));
            PvDisplayLoader.parseOption(option[i], 19, display[i].getAttribute("single"));
            PvDisplayLoader.parseOption(option[i], 20, display[i].getAttribute("sorting"));
            PvDisplayLoader.parseOption(option[i], 21, display[i].getAttribute("visible"));
            PvDisplayLoader.parseOption(option[i], 22, display[i].getAttribute("xyGrid"));
            PvDisplayLoader.parseOption(option[i], 23, display[i].getAttribute("xzGrid"));
            PvDisplayLoader.parseOption(option[i], 24, display[i].getAttribute("yzGrid"));
            PvDisplayLoader.parseOption(option[i], 25, display[i].getAttribute("zBuffer"));
            PsXmlNode cameras = PsXmlSrc.getRsrcNode(display[i], "cameras");
            if (cameras != null) {
                String currCamera = cameras.getAttribute("select");
                int currCameraInd = -1;
                int k = 0;
                while (k < PvDisplayIf.CAMERA_NAME.length) {
                    if (currCamera.equals(PvDisplayIf.CAMERA_NAME[k])) {
                        currCameraInd = k;
                        break;
                    }
                    ++k;
                }
                if (currCameraInd == -1) {
                    PsDebug.warning("unknown selected camera type = " + currCamera);
                    currCameraInd = 0;
                }
                option[i].setCurrentCamera(currCameraInd);
                PsXmlNode[] camera = PsXmlSrc.getRsrcNodes(cameras, "camera");
                if (camera != null) {
                    option[i].setNumCameras(camera.length);
                    j = 0;
                    while (j < camera.length) {
                        PsXmlNode clip;
                        PsXmlNode transform;
                        double d;
                        currCamera = camera[j].getAttribute("projection");
                        currCameraInd = -1;
                        k = 0;
                        while (k < PvDisplayIf.CAMERA_NAME.length) {
                            if (currCamera.equals(PvDisplayIf.CAMERA_NAME[k])) {
                                currCameraInd = k;
                                break;
                            }
                            ++k;
                        }
                        if (currCameraInd == -1) {
                            PsDebug.warning("unknown type of camera[" + k + "], type = " + currCamera);
                            currCameraInd = 0;
                        }
                        option[i].setCameraProjection(j, currCameraInd);
                        PdVector vec = PsXmlLoader.parsePdVector(camera[j], "position", attr);
                        if (vec != null) {
                            option[i].setCameraPosition(j, vec);
                        }
                        if ((vec = PsXmlLoader.parsePdVector(camera[j], "interest", attr)) != null) {
                            option[i].setCameraInterest(j, vec);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble(camera[j], "fieldOfView")) != 0.0) {
                            option[i].setCameraFieldOfView(j, d);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble(camera[j], "roll")) != 0.0) {
                            option[i].setCameraRoll(j, d);
                        }
                        if ((transform = PsXmlSrc.getRsrcNode(camera[j], "transform")) != null) {
                            String perspective;
                            String ambient;
                            String enable = transform.getAttribute("enable");
                            if (enable != null && enable.equals("show")) {
                                option[i].setEnabledCameraTransform(j, true);
                            }
                            if ((ambient = transform.getAttribute("ambient")) != null) {
                                if (ambient.equals("R3Euclidean")) {
                                    option[i].setCameraAmbient(j, 3);
                                } else if (ambient.equals("R4Euclidean")) {
                                    option[i].setCameraAmbient(j, 6);
                                } else if (ambient.equals("S3Sphere")) {
                                    option[i].setCameraAmbient(j, 7);
                                } else if (ambient.equals("H3Hyperbolic")) {
                                    option[i].setCameraAmbient(j, 8);
                                }
                            }
                            if ((perspective = transform.getAttribute("perspective")) != null) {
                                if (perspective.equals("parallel")) {
                                    option[i].setCameraPerspective(j, 0);
                                } else if (perspective.equals("stereographic")) {
                                    option[i].setCameraPerspective(j, 1);
                                } else if (perspective.equals("poincareBall")) {
                                    option[i].setCameraPerspective(j, 1);
                                } else if (perspective.equals("kleinBall")) {
                                    option[i].setCameraPerspective(j, 2);
                                } else if (perspective.equals("upperHalfspace")) {
                                    option[i].setCameraPerspective(j, 3);
                                }
                            }
                        }
                        if ((clip = PsXmlSrc.getRsrcNode(camera[j], "clipping")) != null) {
                            String enable = clip.getAttribute("enable");
                            if (enable != null && enable.equals("show")) {
                                option[i].setEnabledCameraClip(j, true);
                            }
                            if ((d = PsXmlSrc.getRsrcAsDouble(camera[j], "near")) != 0.0) {
                                option[i].setCameraNearClip(j, d);
                            }
                            if ((d = PsXmlSrc.getRsrcAsDouble(camera[j], "far")) != 0.0) {
                                option[i].setCameraFarClip(j, d);
                            }
                        }
                        ++j;
                    }
                }
            } else {
                PsDebug.warning("missing element 'cameras'.");
            }
            PsXmlNode lights = PsXmlSrc.getRsrcNode(display[i], "lights");
            if (lights != null) {
                PsXmlNode[] light;
                PsXmlNode ambient = PsXmlSrc.getRsrcNode(lights, "ambient");
                if (ambient != null) {
                    option[i].setAmbientLight(PsXmlLoader.parseColorRGB(ambient, "color"));
                }
                if ((light = PsXmlSrc.getRsrcNodes(lights, "light")) != null) {
                    option[i].setNumLights(light.length);
                    j = 0;
                    while (j < light.length) {
                        Color color;
                        PdVector vec;
                        String type = light[i].getAttribute("type");
                        if (type != null) {
                            if (type.equals("bulb")) {
                                option[i].setLightType(j, 1);
                            } else if (type.equals("rgbCube")) {
                                option[i].setLightType(j, 2);
                            } else if (type.equals("hue")) {
                                option[i].setLightType(j, 3);
                            } else if (type.equals("spot")) {
                                option[i].setLightType(j, 4);
                            } else if (type.equals("sun")) {
                                option[i].setLightType(j, 5);
                            }
                        }
                        if ((vec = PsXmlLoader.parsePdVector(light[i], "position", attr)) != null) {
                            option[i].setLightPosition(j, vec);
                        }
                        if ((vec = PsXmlLoader.parsePdVector(light[i], "interest", attr)) != null) {
                            option[i].setLightInterest(j, vec);
                        }
                        if ((color = PsXmlLoader.parseColorRGB(light[i], "color")) != null) {
                            option[i].setLightColor(j, color);
                        }
                        ++j;
                    }
                }
            }
            if ((background = PsXmlSrc.getRsrcNode(display[i], "background")) != null) {
                String imageVisibility;
                Color color = PsXmlLoader.parseColorRGB(background, "color");
                if (color != null) {
                    option[i].setBackgroundColor(color);
                }
                if ((imageVisibility = background.getAttribute("image")) != null && imageVisibility.equals("show")) {
                    option[i].setOption(5, true);
                } else {
                    option[i].setOption(5, false);
                }
                PsXmlNode image = PsXmlSrc.getRsrcNode(background, "image");
                if (image != null) {
                    PsXmlNode url;
                    String repeat = image.getAttribute("repeat");
                    if (repeat != null) {
                        option[i].setBackgroundImageRepeat(repeat);
                    }
                    if ((url = PsXmlSrc.getRsrcNode(image, "url")) != null) {
                        option[i].setBackgroundImage(url.getContent());
                    }
                }
            }
            if ((foreground = PsXmlSrc.getRsrcNode(display[i], "foreground")) != null) {
                String imageVisibility;
                Color color = PsXmlLoader.parseColorRGB(foreground, "color");
                if (color != null) {
                    option[i].setForegroundColor(color);
                }
                if ((imageVisibility = foreground.getAttribute("image")) != null && imageVisibility.equals("show")) {
                    option[i].setOption(14, true);
                } else {
                    option[i].setOption(14, false);
                }
                PsXmlNode image = PsXmlSrc.getRsrcNode(foreground, "image");
                if (image != null) {
                    PsXmlNode url;
                    String repeat = image.getAttribute("repeat");
                    if (repeat != null) {
                        option[i].setForegroundImageRepeat(repeat);
                    }
                    if ((url = PsXmlSrc.getRsrcNode(image, "url")) != null) {
                        option[i].setForegroundImage(url.getContent());
                    }
                }
            }
            if ((window = PsXmlSrc.getRsrcNode(display[i], "window")) != null) {
                PsXmlNode x = PsXmlSrc.getRsrcNode(window, "x");
                if (x != null) {
                    int xPos = PsXmlSrc.getRsrcAsInteger(window, "x");
                    int yPos = PsXmlSrc.getRsrcAsInteger(window, "y");
                    option[i].setWindowPosition(xPos, yPos);
                }
                int width = PsXmlSrc.getRsrcAsInteger(window, "width");
                int height = PsXmlSrc.getRsrcAsInteger(window, "height");
                option[i].setWindowSize(width, height);
            }
            ++i;
        }
        return option;
    }

    public static PvDisplayOption[] read(String fileName) {
        BufferedReader in = PsUtil.open(fileName);
        if (in == null) {
            PsDebug.warning("could not open = " + fileName);
            return null;
        }
        PvDisplayOption[] option = PvDisplayLoader.read(in);
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return option;
    }

    public static PvDisplayOption[] read(BufferedReader in) {
        if (in == null) {
            PsDebug.warning("missing reader");
            return null;
        }
        PsXmlSrc src = PsXmlLoader.read(in);
        if (src == null) {
            PsDebug.warning("failed to parsing XML in reader");
            return null;
        }
        PvDisplayOption[] option = PvDisplayLoader.parseRsrcTree(src);
        if (option == null) {
            PsDebug.warning("failed to interpret content of JVD in reader");
            return null;
        }
        return option;
    }

    private static boolean hasAttribute(String attr, String value) {
        return attr != null && attr.equalsIgnoreCase(value);
    }

    private static int parseVisibility(String attr) {
        if (attr == null) {
            return -1;
        }
        if (attr.equalsIgnoreCase("show")) {
            return 1;
        }
        return 0;
    }

    public static String write(PvDisplayOption[] option) {
        if (option == null || option.length == 0) {
            PsDebug.warning("missing options.");
            return null;
        }
        PsXmlSrc src = PvDisplayLoader.fillRsrcTree(null, option);
        if (src == null) {
            PsDebug.warning("failed to generate XML tree");
            return null;
        }
        return PsXmlSrc.write(src);
    }

    protected static PsXmlSrc fillRsrcTree(PsXmlSrc src, PvDisplayOption[] option) {
        PsXmlNode root;
        if (option == null || option.length == 0 || option[0] == null) {
            return null;
        }
        if (src == null) {
            src = new PsXmlSrc();
        }
        if ((root = src.getRootNode()) == null) {
            root = new PsXmlNode("jv-disp");
            src.setRootNode(root);
        }
        src.setDocName("jv-disp");
        PsXmlNode[] meta = new PsXmlNode[2];
        meta[0] = root.addChild("meta");
        meta[0].addAttribute("generator", PsConfig.getProgram() + " v." + PsConfig.getVersion());
        meta[1] = root.addChild("meta");
        meta[1].addAttribute("date", new Date().toString());
        if (option[0] != null) {
            PsXmlNode version = root.addChild("version", option[0].getVersion());
            version.addAttribute("type", option[0].getVersionType());
            if (option[0].getTitle() != null) {
                root.addChild("title", option[0].getTitle());
            }
            root.addChild("abstract", option[0].getAbstract());
        }
        PsXmlNode displays = root.addChild("displays");
        if (option != null) {
            int i = 0;
            while (i < option.length) {
                Dimension dim;
                PsXmlNode display = displays.addChild("display");
                display.addAttribute("name", option[i].getTitle());
                if (option[i].getOption(1)) {
                    display.addAttribute("antiAlias", "show");
                }
                if (option[i].getOption(2)) {
                    display.addAttribute("autoRotate", "show");
                }
                if (option[i].getOption(3)) {
                    display.addAttribute("axes", "show");
                }
                if (option[i].getOption(4)) {
                    display.addAttribute("axesLabel", "show");
                }
                if (!option[i].getOption(7)) {
                    display.addAttribute("border", "hide");
                }
                if (option[i].getOption(8)) {
                    display.addAttribute("boundingBox", "show");
                }
                if (option[i].getOption(9)) {
                    display.addAttribute("center", "show");
                }
                if (option[i].getOption(10)) {
                    display.addAttribute("cross", "show");
                }
                if (!option[i].getOption(11)) {
                    display.addAttribute("depthcue", "hide");
                }
                if (!option[i].getOption(12)) {
                    display.addAttribute("drawing", "hide");
                }
                if (option[i].getOption(13)) {
                    display.addAttribute("edgeAura", "show");
                }
                if (option[i].getOption(15)) {
                    display.addAttribute("frame", "show");
                }
                if (option[i].getOption(16)) {
                    display.addAttribute("info", "show");
                }
                if (option[i].getOption(18)) {
                    display.addAttribute("magnet", "show");
                }
                if (option[i].getOption(19)) {
                    display.addAttribute("single", "show");
                }
                if (!option[i].getOption(20)) {
                    display.addAttribute("sorting", "hide");
                }
                if (!option[i].getOption(21)) {
                    display.addAttribute("visible", "hide");
                }
                if (option[i].getOption(22)) {
                    display.addAttribute("xyGrid", "show");
                }
                if (option[i].getOption(23)) {
                    display.addAttribute("xzGrid", "show");
                }
                if (option[i].getOption(24)) {
                    display.addAttribute("yzGrid", "show");
                }
                if (option[i].getOption(25)) {
                    display.addAttribute("zBuffer", "show");
                }
                PsXmlNode cameras = display.addChild("cameras");
                int currCam = option[i].getCurrentCamera();
                if (currCam < 0 || currCam >= PvDisplayIf.CAMERA_NAME.length) {
                    PsDebug.warning("unknown camera type = " + currCam);
                } else {
                    cameras.addAttribute("select", PvDisplayIf.CAMERA_NAME[currCam]);
                }
                int numCameras = option[i].getNumCameras();
                int j = 0;
                while (j < numCameras) {
                    PsXmlNode camera = cameras.addChild("camera");
                    int cameraType = option[i].getCameraProjection(j);
                    if (cameraType < 0 || cameraType >= PvDisplayIf.CAMERA_NAME.length) {
                        PsDebug.warning("unknown camera type = " + cameraType);
                    } else {
                        camera.addAttribute("projection", PvDisplayIf.CAMERA_NAME[cameraType]);
                    }
                    PsXmlLoader.addVector(camera, "position", option[i].getCameraPosition(j), true);
                    PsXmlLoader.addVector(camera, "interest", option[i].getCameraInterest(j), true);
                    camera.addChild("fieldOfView", option[i].getCameraAngle(j));
                    camera.addChild("roll", option[i].getCameraRoll(j));
                    PsXmlNode transform = camera.addChild("transform");
                    if (option[i].isEnabledCameraTransform(j)) {
                        transform.addAttribute("enable", "show");
                    } else {
                        transform.addAttribute("enable", "hide");
                    }
                    int ambient = option[i].getCameraAmbient(j);
                    switch (ambient) {
                        case 3: {
                            transform.addAttribute("ambient", "R3Euclidean");
                            break;
                        }
                        case 6: {
                            transform.addAttribute("ambient", "R4Euclidean");
                            break;
                        }
                        case 7: {
                            transform.addAttribute("ambient", "S3Sphere");
                            break;
                        }
                        case 8: {
                            transform.addAttribute("ambient", "H3Hyperbolic");
                            break;
                        }
                        default: {
                            transform.addAttribute("ambient", "R3Euclidean");
                        }
                    }
                    int perspective = option[i].getCameraPerspective(j);
                    switch (perspective) {
                        case 0: {
                            transform.addAttribute("perspective", "parallel");
                            break;
                        }
                        case 1: {
                            transform.addAttribute("perspective", "stereographic");
                            break;
                        }
                        default: {
                            PsDebug.warning("unknown perspective type = " + perspective);
                        }
                    }
                    PsXmlNode clipping = camera.addChild("clipping");
                    if (option[i].isEnabledCameraClip(j)) {
                        clipping.addAttribute("enable", "show");
                    } else {
                        clipping.addAttribute("enable", "hide");
                    }
                    clipping.addChild("near", option[i].getCameraNearClip(j));
                    clipping.addChild("far", option[i].getCameraFarClip(j));
                    ++j;
                }
                PsXmlNode lights = display.addChild("lights");
                PsXmlLoader.addColor(lights, "ambient", option[i].getAmbientLight());
                int numLights = option[i].getNumLights();
                int j2 = 0;
                while (j2 < numLights) {
                    PsXmlNode light = lights.addChild("light");
                    int type = option[i].getLightType(j2);
                    switch (type) {
                        case 1: {
                            light.addAttribute("type", "bulb");
                            break;
                        }
                        case 2: {
                            light.addAttribute("type", "rgbCube");
                            break;
                        }
                        case 3: {
                            light.addAttribute("type", "hue");
                            break;
                        }
                        case 4: {
                            light.addAttribute("type", "spot");
                            break;
                        }
                        case 5: {
                            light.addAttribute("type", "sun");
                            break;
                        }
                        default: {
                            PsDebug.warning("unknown light type = " + type);
                        }
                    }
                    PsXmlLoader.addVector(light, "position", option[i].getLightPosition(j2), true);
                    PsXmlLoader.addVector(light, "interest", option[i].getLightInterest(j2), true);
                    PsXmlLoader.addColor(light, "color", option[i].getLightColor(j2));
                    ++j2;
                }
                PsXmlNode background = display.addChild("background");
                PsXmlLoader.addColor(background, "color", option[i].getBackgroundColor());
                String imageUrl = option[i].getBackgroundImage();
                if (imageUrl != null) {
                    if (option[i].getOption(5)) {
                        background.addAttribute("image", "show");
                    }
                    PsXmlNode image = background.addChild("image");
                    image.addAttribute("repeat", option[i].getBackgroundImageRepeat());
                    image.addChild("url", imageUrl);
                }
                PsXmlNode foreground = display.addChild("foreground");
                PsXmlLoader.addColor(foreground, "color", option[i].getForegroundColor());
                imageUrl = option[i].getForegroundImage();
                if (imageUrl != null) {
                    if (option[i].getOption(14)) {
                        foreground.addAttribute("image", "show");
                    }
                    PsXmlNode image = foreground.addChild("image");
                    image.addAttribute("repeat", option[i].getForegroundImageRepeat());
                    image.addChild("url", imageUrl);
                }
                PsXmlNode window = display.addChild("window");
                Point point = option[i].getWindowPosition();
                if (point != null) {
                    window.addChild("x", point.x);
                    window.addChild("y", point.y);
                }
                if ((dim = option[i].getWindowSize()) != null) {
                    window.addChild("width", dim.width);
                    window.addChild("height", dim.height);
                }
                ++i;
            }
        }
        return src;
    }
}

