/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import jv.number.PdColor;
import jv.object.PsDebug;
import jv.project.PvCameraIf;
import jv.project.PvDisplayIf;
import jv.vecmath.P_Vector;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuData;
import jv.vecmath.PuVectorGeom;

public class PvDisplayOption
extends P_Vector {
    public static final int SHOW_ANTIALIAS = 1;
    public static final int SHOW_AUTOROTATE = 2;
    public static final int SHOW_AXES = 3;
    public static final int SHOW_AXES_LABEL = 4;
    public static final int SHOW_BACKGROUND_IMAGE = 5;
    public static final int SHOW_BORDER = 7;
    public static final int SHOW_BOUNDING_BOX = 8;
    public static final int SHOW_CENTER = 9;
    public static final int SHOW_CROSS = 10;
    public static final int SHOW_DEPTHCUE = 11;
    public static final int SHOW_DRAWING = 12;
    public static final int SHOW_EDGE_AURA = 13;
    public static final int SHOW_FOREGROUND_IMAGE = 14;
    public static final int SHOW_FRAME = 15;
    public static final int SHOW_INFO = 16;
    public static final int SHOW_LIGHTING = 17;
    public static final int SHOW_MAGNET = 18;
    public static final int SHOW_SINGLE = 19;
    public static final int SHOW_SORTING = 20;
    public static final int SHOW_VISIBLE = 21;
    public static final int SHOW_XY_GRID = 22;
    public static final int SHOW_XZ_GRID = 23;
    public static final int SHOW_YZ_GRID = 24;
    public static final int SHOW_ZBUFFER = 25;
    public static final int LIGHT_BULB = 1;
    public static final int LIGHT_RGB_CUBE = 2;
    public static final int LIGHT_HUE = 3;
    public static final int LIGHT_SPOT = 4;
    public static final int LIGHT_SUN = 5;
    protected String m_version = "0.90";
    protected String m_versionType = "dump";
    protected String m_title;
    protected String m_abstract;
    protected int m_dim;
    protected String[] m_axesLabel;
    protected int m_numCameras;
    protected int m_currentCamera;
    protected int[] m_cameraProjection;
    protected PdVector[] m_cameraPosition;
    protected PdVector[] m_cameraInterest;
    protected double[] m_cameraRoll;
    protected double[] m_cameraFieldOfView;
    protected boolean[] m_cameraEnableTransform;
    protected int[] m_cameraAmbient;
    protected int[] m_cameraPerspective;
    protected boolean[] m_cameraEnableClip;
    protected double[] m_cameraNearClip;
    protected double[] m_cameraFarClip;
    protected int m_numLights;
    protected Color m_ambientLight;
    protected int[] m_lightType;
    protected PdVector[] m_lightPosition;
    protected PdVector[] m_lightInterest;
    protected Color[] m_lightColor;
    protected Color m_backgroundColor;
    protected String m_backgroundImageRepeat;
    protected String m_backgroundImage;
    protected Color m_foregroundColor;
    protected String m_foregroundImageRepeat;
    protected String m_foregroundImage;
    protected Point m_windowPosition;
    protected Dimension m_windowSize;
    protected PdVector m_viewCenter;
    protected PiVector m_axesEdge;

    public void setCameraPerspective(int ind, int perspective) {
        if (!this.assureCameraIndex(ind)) {
            return;
        }
        this.m_cameraPerspective[ind] = perspective;
    }

    public double getCameraRoll(int ind) {
        return this.m_cameraRoll[ind];
    }

    public void setCameraRoll(int ind, double roll) {
        if (!this.assureCameraIndex(ind)) {
            return;
        }
        this.m_cameraRoll[ind] = roll;
    }

    public void setEnabledCameraTransform(int ind, boolean v) {
        if (!this.assureCameraIndex(ind)) {
            return;
        }
        this.m_cameraEnableTransform[ind] = v;
    }

    public String getBackgroundImage() {
        return this.m_backgroundImage;
    }

    public void setBackgroundImage(String image) {
        this.m_backgroundImage = image;
    }

    public boolean isEnabledCameraClip(int ind) {
        return this.m_cameraEnableClip[ind];
    }

    protected boolean getOption(int flag) {
        return this.hasTag(flag);
    }

    public void setOption(int flag, boolean val) {
        if (val) {
            this.setTag(flag);
        } else {
            this.clearTag(flag);
        }
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setVersion(String version) {
        this.m_version = version;
    }

    public PiVector getAxesEdge() {
        return this.m_axesEdge;
    }

    public int getCameraAmbient(int ind) {
        return this.m_cameraAmbient[ind];
    }

    public void setCameraAmbient(int ind, int ambient) {
        if (!this.assureCameraIndex(ind)) {
            return;
        }
        this.m_cameraAmbient[ind] = ambient;
    }

    public Color getBackgroundColor() {
        return this.m_backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.m_backgroundColor = color;
    }

    public void setAxesEdge(PiVector edges) {
        this.m_axesEdge = edges;
    }

    public int getCurrentCamera() {
        return this.m_currentCamera;
    }

    public void setCurrentCamera(int type) {
        this.m_currentCamera = type;
    }

    public int getNumLights() {
        return this.m_numLights;
    }

    public void setNumLights(int num) {
        if (num < 0) {
            PsDebug.warning("number = " + num + " < 0");
            return;
        }
        if (num == this.m_numLights) {
            return;
        }
        this.m_numLights = num;
        this.m_lightType = PuData.realloc(this.m_lightType, this.m_numLights);
        this.m_lightPosition = PdVector.realloc(this.m_lightPosition, this.m_numLights);
        this.m_lightInterest = PdVector.realloc(this.m_lightInterest, this.m_numLights);
        this.m_lightColor = PdColor.realloc(this.m_lightColor, this.m_numLights);
    }

    public PdMatrix getCameraMatrix(int ind) {
        PdVector interest = this.getCameraInterest(ind);
        PdVector position = this.getCameraPosition(ind);
        PdVector viewDir = PdVector.subNew(interest, position);
        viewDir.normalize();
        PdVector upVector = new PdVector(0.0, 0.0, 1.0);
        PdVector wDir = new PdVector(3);
        PdVector upDir = upVector.orthogonalPart(null, viewDir);
        if (!upDir.normalize()) {
            PsDebug.notify("upVector parallel to line of view, modify 1");
            upVector.m_data[1] = upVector.m_data[1] + 1.0;
            upDir = upVector.orthogonalPart(null, viewDir);
            if (!upDir.normalize()) {
                PsDebug.notify("upVector parallel to line of view, modify 2");
                upVector.m_data[2] = upVector.m_data[2] + 1.0;
                upDir = upVector.orthogonalPart(null, viewDir);
                if (!upDir.normalize()) {
                    PsDebug.notify("upVector parallel to line of view, modify 3");
                    upVector.m_data[2] = upVector.m_data[2] + 1.0;
                    upDir = upVector.orthogonalPart(null, viewDir);
                }
            }
        }
        upVector.copy(upDir);
        PuVectorGeom.rotatePointAroundVector(upDir, upVector, viewDir, this.m_cameraRoll[ind] * Math.PI / 180.0);
        wDir.cross(viewDir, upDir);
        PdMatrix trans = new PdMatrix(4);
        double fac = PdVector.dist(position, interest);
        int i = 0;
        while (i < 3) {
            trans.m_data[0][i] = fac * wDir.m_data[i];
            trans.m_data[1][i] = fac * upDir.m_data[i];
            trans.m_data[2][i] = -fac * viewDir.m_data[i];
            trans.m_data[3][i] = interest.m_data[i];
            ++i;
        }
        trans.m_data[3][3] = 1.0;
        return trans;
    }

    public void setCameraMatrix(int ind, PdMatrix trans) {
        PdVector interest = new PdVector(3);
        PdVector viewDir = new PdVector(3);
        PdVector upDir = new PdVector(3);
        PdVector wDir = new PdVector(3);
        PdVector projZDir = new PdVector(3);
        int i = 0;
        while (i < 3) {
            wDir.m_data[i] = trans.m_data[0][i];
            upDir.m_data[i] = trans.m_data[1][i];
            viewDir.m_data[i] = -trans.m_data[2][i];
            interest.m_data[i] = trans.m_data[3][i];
            projZDir.m_data[i] = trans.m_data[i][2];
            ++i;
        }
        this.setCameraPosition(ind, PdVector.subNew(interest, viewDir));
        this.setCameraInterest(ind, interest);
        projZDir.setEntry(2, 0.0);
        projZDir.normalize();
        double roll = Math.acos(projZDir.getEntry(1)) * 180.0 / Math.PI;
        this.setCameraRoll(ind, roll);
    }

    public boolean isEnabledCameraTransform(int ind) {
        return this.m_cameraEnableTransform[ind];
    }

    public double getCameraFarClip(int ind) {
        return this.m_cameraFarClip[ind];
    }

    public double getCameraFieldOfView(int ind) {
        return this.m_cameraFieldOfView[ind];
    }

    public void setCameraFieldOfView(int ind, double angle) {
        if (!this.assureCameraIndex(ind)) {
            return;
        }
        this.m_cameraFieldOfView[ind] = angle;
    }

    public void setCameraFarClip(int ind, double dist) {
        if (!this.assureCameraIndex(ind)) {
            return;
        }
        this.m_cameraFarClip[ind] = dist;
    }

    public PdVector getCameraPosition(int ind) {
        return this.m_cameraPosition[ind];
    }

    public void setCameraPosition(int ind, PdVector position) {
        if (!this.assureCameraIndex(ind)) {
            return;
        }
        this.m_cameraPosition[ind].copy(position);
    }

    public Color getAmbientLight() {
        return this.m_ambientLight;
    }

    public void setAmbientLight(Color color) {
        this.m_ambientLight = color;
    }

    public PdVector getLightPosition(int ind) {
        return this.m_lightPosition[ind];
    }

    public void setLightPosition(int ind, PdVector position) {
        if (!this.assureLightIndex(ind)) {
            return;
        }
        this.m_lightPosition[ind] = position;
    }

    public void configure(PvDisplayIf disp) {
        Dimension dim;
        Point pos;
        if (disp == null) {
            PsDebug.warning("missing display");
            return;
        }
        disp.setEnabledUpdate(false);
        disp.setAutoCenter(false);
        disp.setPaintTag(64, this.getOption(1));
        disp.setEnabledAnimation(this.getOption(2));
        if (this.getBackgroundColor() != null) {
            disp.setBackgroundColor(this.getBackgroundColor());
        }
        disp.showBackImage(this.getOption(5));
        if (this.getBackgroundImage() != null) {
            disp.setBackgroundImage(this.getBackgroundImage());
        }
        disp.showBndBox(this.getOption(8));
        disp.setPaintTag(4, this.getOption(7));
        disp.setPaintTag(16384, this.getOption(9));
        disp.setPaintTag(16, this.getOption(10));
        disp.showDepthcue(this.getOption(11));
        disp.setPaintTag(1, this.getOption(12));
        disp.showEdgeAura(this.getOption(13));
        if (this.getForegroundColor() != null) {
            disp.setForegroundColor(this.getForegroundColor());
        }
        disp.showFrame(this.getOption(15));
        disp.setPaintTag(256, this.getOption(16));
        disp.showMagnet(this.getOption(18));
        disp.setPaintTag(2048, this.getOption(19));
        disp.setEnabledPainters(this.getOption(20));
        disp.showGrid(this.getOption(22));
        disp.setEnabledZBuffer(this.getOption(25));
        int i = 0;
        while (i < this.m_numCameras) {
            PvCameraIf camera = null;
            if (!disp.hasCamera(this.m_cameraProjection[i])) {
                disp.selectCamera(this.m_cameraProjection[i]);
            }
            camera = disp.getCamera(this.m_cameraProjection[i]);
            camera.setInterest(this.m_cameraInterest[i]);
            camera.setPosition(this.m_cameraPosition[i]);
            camera.setFieldOfView(this.m_cameraFieldOfView[i]);
            camera.setRoll(this.m_cameraRoll[i]);
            camera.setEnabledClip(this.isEnabledCameraClip(i));
            camera.setNearClip(this.getCameraNearClip(i));
            camera.setFarClip(this.getCameraFarClip(i));
            camera.update(camera);
            ++i;
        }
        disp.selectCamera(this.getCurrentCamera());
        Frame frame = disp.getFrame();
        if (frame != null && (pos = this.getWindowPosition()) != null) {
            ((Component)frame).setLocation(pos);
        }
        if ((dim = this.getWindowSize()) != null) {
            disp.setSizeWithinFrame(dim.width, dim.height);
        }
        disp.setName(this.getTitle());
        disp.setEnabledUpdate(true);
        disp.showAxes(this.getOption(3));
    }

    public int getCameraProjection(int ind) {
        return this.m_cameraProjection[ind];
    }

    public void setCameraProjection(int ind, int projection) {
        if (!this.assureCameraIndex(ind)) {
            return;
        }
        this.m_cameraProjection[ind] = projection;
    }

    public String getAbstract() {
        return this.m_abstract;
    }

    public void setAbstract(String abstr) {
        this.m_abstract = abstr;
    }

    public Point getWindowPosition() {
        return this.m_windowPosition;
    }

    public void setWindowPosition(int x, int y) {
        this.m_windowPosition = new Point(x, y);
    }

    public Dimension getWindowSize() {
        return this.m_windowSize;
    }

    public void setWindowSize(int width, int height) {
        this.m_windowSize = new Dimension(width, height);
    }

    public String[] getAxesLabel() {
        return this.m_axesLabel;
    }

    public void setAxesLabel(String[] labels) {
        this.m_axesLabel = labels;
    }

    public void setOptions(PvDisplayIf disp) {
        Frame frame;
        if (disp == null) {
            PsDebug.warning("missing display");
            return;
        }
        this.setOption(1, disp.hasPaintTag(64));
        this.setOption(2, disp.isEnabledAnimation());
        this.setOption(3, disp.isShowingAxes());
        this.setBackgroundColor(disp.getBackgroundColor());
        this.setOption(5, disp.isShowingBackImage());
        this.setOption(8, disp.isShowingBndBox());
        this.setOption(7, disp.hasPaintTag(4));
        this.setOption(9, disp.hasPaintTag(16384));
        this.setOption(10, disp.hasPaintTag(16));
        this.setOption(11, disp.isShowingDepthcue());
        this.setOption(12, disp.hasPaintTag(1));
        this.setOption(13, disp.isShowingEdgeAura());
        this.setForegroundColor(disp.getForegroundColor());
        this.setOption(15, disp.isShowingFrame());
        this.setOption(16, disp.hasPaintTag(256));
        this.setOption(18, disp.isShowingMagnet());
        this.setOption(19, disp.hasPaintTag(2048));
        this.setOption(20, disp.isEnabledPainters());
        this.setOption(22, disp.isShowingGrid());
        this.setOption(25, disp.isEnabledZBuffer());
        PvCameraIf[] camera = disp.getCameras();
        int numCameras = camera.length;
        this.setNumCameras(numCameras);
        int i = 0;
        while (i < numCameras) {
            this.setCameraProjection(i, camera[i].getProjectionMode());
            this.setCameraPosition(i, camera[i].getPosition());
            this.setCameraInterest(i, camera[i].getInterest());
            this.setCameraAngle(i, camera[i].getFieldOfView());
            this.setCameraRoll(i, camera[i].getRoll());
            this.setEnabledCameraClip(i, camera[i].isEnabledClip());
            this.setCameraNearClip(i, camera[i].getNearClip());
            this.setCameraFarClip(i, camera[i].getFarClip());
            ++i;
        }
        PvCameraIf currentCamera = disp.getCamera();
        if (currentCamera != null) {
            this.setCurrentCamera(currentCamera.getProjectionMode());
        }
        if ((frame = disp.getFrame()) != null) {
            Point pos = frame.location();
            if (pos != null) {
                this.setWindowPosition(pos.x, pos.y);
            } else {
                this.setWindowPosition(-1, -1);
            }
        }
        this.setTitle(disp.getName());
        Dimension dispSize = disp.getSize();
        this.setWindowSize(dispSize.width, dispSize.height);
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public String getVersionType() {
        return this.m_versionType;
    }

    public void setVersionType(String versionType) {
        this.m_versionType = versionType;
    }

    public PdVector getCameraInterest(int ind) {
        return this.m_cameraInterest[ind];
    }

    public void setCameraInterest(int ind, PdVector interest) {
        if (!this.assureCameraIndex(ind)) {
            return;
        }
        this.m_cameraInterest[ind].copy(interest);
    }

    public void setEnabledCameraClip(int ind, boolean v) {
        if (!this.assureCameraIndex(ind)) {
            return;
        }
        this.m_cameraEnableClip[ind] = v;
    }

    public double getCameraNearClip(int ind) {
        return this.m_cameraNearClip[ind];
    }

    public void setCameraNearClip(int ind, double dist) {
        if (!this.assureCameraIndex(ind)) {
            return;
        }
        this.m_cameraNearClip[ind] = dist;
    }

    public int getLightType(int ind) {
        return this.m_lightType[ind];
    }

    public void setLightType(int ind, int type) {
        if (!this.assureLightIndex(ind)) {
            return;
        }
        this.m_lightType[ind] = type;
    }

    public PdVector getLightInterest(int ind) {
        return this.m_lightInterest[ind];
    }

    public void setLightInterest(int ind, PdVector direction) {
        if (!this.assureLightIndex(ind)) {
            return;
        }
        this.m_lightInterest[ind] = direction;
    }

    public String getForegroundImageRepeat() {
        return this.m_foregroundImageRepeat;
    }

    public void setForegroundImageRepeat(String repeat) {
        this.m_foregroundImageRepeat = repeat;
    }

    public String getForegroundImage() {
        return this.m_foregroundImage;
    }

    public void setForegroundImage(String image) {
        this.m_foregroundImage = image;
    }

    public int getNumCameras() {
        return this.m_numCameras;
    }

    public void setNumCameras(int num) {
        if (num < 0) {
            PsDebug.warning("num = " + num + " < 0");
            return;
        }
        if (num == this.m_numCameras) {
            return;
        }
        this.m_numCameras = num;
        this.m_cameraProjection = PuData.realloc(this.m_cameraProjection, this.m_numCameras);
        this.m_cameraPosition = PdVector.realloc(this.m_cameraPosition, this.m_numCameras, this.m_dim);
        this.m_cameraInterest = PdVector.realloc(this.m_cameraInterest, this.m_numCameras, this.m_dim);
        this.m_cameraFieldOfView = PuData.realloc(this.m_cameraFieldOfView, this.m_numCameras);
        this.m_cameraRoll = PuData.realloc(this.m_cameraRoll, this.m_numCameras);
        this.m_cameraEnableTransform = PuData.realloc(this.m_cameraEnableTransform, this.m_numCameras);
        this.m_cameraAmbient = PuData.realloc(this.m_cameraAmbient, this.m_numCameras);
        this.m_cameraPerspective = PuData.realloc(this.m_cameraPerspective, this.m_numCameras);
        this.m_cameraEnableClip = PuData.realloc(this.m_cameraEnableClip, this.m_numCameras);
        this.m_cameraNearClip = PuData.realloc(this.m_cameraNearClip, this.m_numCameras);
        this.m_cameraFarClip = PuData.realloc(this.m_cameraFarClip, this.m_numCameras);
    }

    public String getBackgroundImageRepeat() {
        return this.m_backgroundImageRepeat;
    }

    public void setBackgroundImageRepeat(String repeat) {
        this.m_backgroundImageRepeat = repeat;
    }

    public PvDisplayOption() {
        this.setOption(1, false);
        this.setOption(2, false);
        this.setOption(3, false);
        this.setOption(4, false);
        this.setOption(5, false);
        this.setOption(8, false);
        this.setOption(7, true);
        this.setOption(9, false);
        this.setOption(10, false);
        this.setOption(11, true);
        this.setOption(12, true);
        this.setOption(13, false);
        this.setOption(14, false);
        this.setOption(15, false);
        this.setOption(16, false);
        this.setOption(17, false);
        this.setOption(18, false);
        this.setOption(19, false);
        this.setOption(20, true);
        this.setOption(21, true);
        this.setOption(22, false);
        this.setOption(23, false);
        this.setOption(24, false);
        this.setOption(25, false);
        this.m_dim = 3;
        this.m_axesLabel = new String[]{"x", "y", "z"};
    }

    public Color getLightColor(int ind) {
        return this.m_lightColor[ind];
    }

    public void setLightColor(int ind, Color color) {
        if (!this.assureLightIndex(ind)) {
            return;
        }
        this.m_lightColor[ind] = color;
    }

    public Color getForegroundColor() {
        return this.m_foregroundColor;
    }

    public void setForegroundColor(Color color) {
        this.m_foregroundColor = color;
    }

    private boolean assureCameraIndex(int ind) {
        if (ind < 0) {
            PsDebug.warning("index = " + ind + " < 0");
            return false;
        }
        if (ind < this.m_numCameras) {
            return true;
        }
        this.setNumCameras(ind + 1);
        return true;
    }

    private boolean assureLightIndex(int ind) {
        if (ind < 0) {
            PsDebug.warning("index = " + ind + " < 0");
            return false;
        }
        if (ind < this.m_numLights) {
            return true;
        }
        this.setNumLights(ind + 1);
        return true;
    }

    public double getCameraAngle(int ind) {
        return this.getCameraFieldOfView(ind);
    }

    public void setCameraAngle(int ind, double angle) {
        this.setCameraFieldOfView(ind, angle);
    }

    public int getCameraPerspective(int ind) {
        return this.m_cameraPerspective[ind];
    }
}

