/*
 * Decompiled with CFR 0.152.
 */
package jv.number;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import jv.number.PuInteger;
import jv.number.PuInteger_Config;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.GuiStackLayout;

public class PuInteger_IP
extends PsPanel
implements ActionListener,
AdjustmentListener {
    protected PuInteger m_number;
    protected int m_oldValue = 0;
    protected int m_newValue = 0;
    protected Button m_bConfig;
    protected TextField m_text;
    public Scrollbar m_scrollbar;
    private static /* synthetic */ Class class$jv$number$PuInteger_IP;

    public void adjustmentValueChanged(AdjustmentEvent event) {
        Object source = event.getSource();
        if (source == this.m_scrollbar) {
            this.m_newValue = this.m_scrollbar.getValue();
            if (this.m_oldValue == this.m_newValue) {
                return;
            }
            this.m_oldValue = this.m_newValue;
            this.m_number.setValueFromPanel(this.m_newValue, this);
            ((TextComponent)this.m_text).setText(String.valueOf(this.m_number.getValue()));
            PsDebug.notify("setValue=" + this.m_number.getValue());
            this.m_number.update(this);
        }
    }

    public PuInteger_IP() {
        if (this.getClass() == (class$jv$number$PuInteger_IP != null ? class$jv$number$PuInteger_IP : (class$jv$number$PuInteger_IP = PuInteger_IP.class$("jv.number.PuInteger_IP")))) {
            this.init();
        }
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.m_number = (PuInteger)parent;
        this.setTitle(this.m_number.getName());
    }

    public boolean update(Object object) {
        PsDebug.notify("called");
        if (this.m_number == null) {
            PsDebug.warning("missing integer");
            return true;
        }
        if (object == this.m_number) {
            ((TextComponent)this.m_text).setText(String.valueOf(this.m_number.getValue()));
            this.m_scrollbar.setUnitIncrement(this.m_number.m_lineIncr);
            this.m_scrollbar.setBlockIncrement(this.m_number.m_pageIncr);
            this.m_scrollbar.setValues(this.m_number.m_value, this.m_number.m_pageIncr, this.m_number.m_minimum, this.m_number.m_maximum + this.m_number.m_pageIncr);
            this.m_oldValue = this.m_number.m_value;
            this.setEnabled(this.m_number.m_enabled);
            return true;
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_text) {
            PsDebug.notify("text chosen");
            String text = this.m_text.getText();
            if (text == null || text.equals("")) {
                return;
            }
            try {
                int newValue = Integer.parseInt(text);
                this.m_number.setValueFromPanel(newValue, this);
                if (this.m_number.getValue() != newValue) {
                    newValue = this.m_number.getValue();
                    ((TextComponent)this.m_text).setText(String.valueOf(newValue));
                }
                this.m_scrollbar.setValue(newValue);
                this.m_oldValue = newValue;
                PsDebug.notify("setValue=" + newValue);
            }
            catch (NumberFormatException e) {
                PsDebug.warning("wrong format = " + text);
                return;
            }
            this.m_number.update(this);
        } else if (source == this.m_bConfig) {
            PuInteger_Config config = new PuInteger_Config(this.m_number);
            config.init(this.m_number.m_minimum, this.m_number.m_maximum, this.m_number.m_lineIncr, this.m_number.m_pageIncr);
            config.setParent(this);
            ((Component)config).setVisible(true);
            this.m_number.update(this.m_number);
        }
    }

    private static /* synthetic */ Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public void init() {
        super.init();
        this.setLayout(new GridLayout(1, 2));
        Panel textPanel = new Panel();
        textPanel.setLayout(new GuiStackLayout(0, 0));
        this.add(textPanel);
        this.setTitle("");
        textPanel.add("WIDE*2", this.getTitle());
        this.m_text = new TextField(7);
        this.m_text.addActionListener(this);
        textPanel.add("FILL*1", this.m_text);
        Panel scroll = new Panel();
        scroll.setLayout(new BorderLayout());
        this.add(scroll);
        this.m_scrollbar = new Scrollbar(0);
        this.m_scrollbar.addAdjustmentListener(this);
        scroll.add("Center", this.m_scrollbar);
        this.m_bConfig = new Button(PsConfig.getMessage("bConfig"));
        this.m_bConfig.addActionListener(this);
        scroll.add("East", this.m_bConfig);
    }

    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.m_bConfig.setEnabled(flag);
        this.m_lTitle.setEnabled(flag);
        this.m_text.setEnabled(flag);
        this.m_scrollbar.setEnabled(flag);
    }
}

